////////////////////////////////////////////////////////////
//                                                        //
//   Exoplanet host stars catalog for SpaceEngine 0.974   //
//                                                        //
//             Last update : 2016-05-13                   //
//                                                        //
// Original data from:                                    //
//                                                        //
// 1) NASA Exoplanet Archive                              //
//    http://exoplanetarchive.ipac.caltech.edu/index.html //
// 2) Interactive Exoplanet Catalog                       //
//    http://exoplanet.eu/catalog/                        //
//    Jean Schneider (CNRS-LUTH, Paris Observatory)       //
//                                                        //
////////////////////////////////////////////////////////////

// Star solver log level:
// 0 - do not log
// 1 - log errors and warnings only
// 2 - log everything
LogLevel    0


Star	"11 Oph"
{
	RA      16.37367053
	Dec     -24.087208
	Dist    125
	AppMagn 13.804
	Class  "M9"
	MassSol 0.02
	RadSol  0.12
	Teff    2375
	Age     0.011
}

Star	"11 UMi/HD 136726/HIP 74793"
{
	RA      15.28496907
	Dec     71.823898
	Dist    119.47
	AppMagn 5.016
	Class  "K4III"
	MassSol 1.8
	RadSol  24.08
	Teff    4340
	FeH     0.04
	Age     1.56
}

Star	"14 Her/HD 145675/HIP 79248"
{
	RA      16.1734202
	Dec     43.817646
	Dist    18.15
	AppMagn 6.61
	Class  "K0V"
	MassSol 0.9
	RadSol  0.708
	Teff    5311
	FeH     0.43
	Age     5.1
}

Star	"1RXS J160929.1-210524/1RXS 1609/RXJ 1609"
{
	RA      16.15833333
	Dec     -21.0827778
	Dist    145
	AppMagn 10.99
	Class  "K7V"
	MassSol 0.73
	RadSol  1.35
	Teff    4060
	Age     0.011
}

Star	"1SWASP J1407/J1407"
{
	RA      14.13
	Dec     -39.76194447
	Dist    133
	AppMagn 12.4
	MassSol 0.9
	RadSol  0.99
	Teff    4400
	Age     0.016
}

Star	"24 Sex/HD 90043/HIP 50887"
{
	RA      10.39111111
	Dec     0.9022222
	Dist    74.8
	AppMagn 7.38
	Class  "G5"
	MassSol 1.54
	RadSol  4.9
	Teff    5098
	FeH    -0.03
	Age     2.7
}

Star	"2M 0122-24/2MASS J01225093-2439505"
{
	RA      1.380833333
	Dec     -24.6142
	Dist    36
	AppMagn 14.24
	Class  "M3.5"
	MassSol 0.4
	Teff    3530
	Age     0.12
}

Star	"2M 0219-39/2MASS J02192210-3925225"
{
	RA      2.322777778
	Dec     -39.42305557
	Dist    39.4
	AppMagn 13.42
	Class  "M6"
	MassSol 0.11
	RadSol  0.27
	Teff    3064
}

Star	"2M 0441+23/2MASS J04414489+2301513"
{
	RA      4.695833333
	Dec     23.0308333
	Dist    140
	AppMagn 13.726
	Class  "M8.5"
	MassSol 0.02
	Age     0.001
}

Star	"2M 0746+20/2MASS J07464256+2000321"
{
	RA      7.778611113
	Dec     20.0088889
	Dist    12.21
	AppMagn 17.7
	Class  "L1V"
	MassSol 0.12
	RadSol  0.089
	Teff    2205
}

Star	"2M 1207-39/2MASS J12073346-3932539"
{
	RA      12.12583333
	Dec     -39.5483333
	Dist    52.4
	AppMagn 20.15
	Class  "M8"
	MassSol 0.025
	Age     0.008
}

Star	"2M 1938+46/2MASS J19383260+4603591"
{
	RA      19.6425
	Dec     46.0663889
	AppMagn 12.889
	Class  "B5IV"
	MassSol 0.6
}

Star	"2M 2140+16/2MASS J21402931+1625183"
{
	RA      21.6748108
	Dec     16.421759
	Dist    25
	AppMagn 12.266
	Class  "M8.5"
	MassSol 0.08
	RadSol  0.12
	Teff    2300
}

Star	"2M 2206-20/2MASS J22062280-2047058"
{
	RA      22.10638889
	Dec     -20.785
	Dist    26.67
	AppMagn 19.788
	MassSol 0.13
	RadSol  0.11
	Teff    2350
}

Star	"2M J2126-81/TYC 9486-927-1"
{
	RA      21.42444445
	Dec     -81.64111113
	Dist    24.75
	AppMagn 9
	Class  "M2"
	MassSol 0.4
	Age     0.027
}

Star	"4 UMa/HD 73108/HIP 42527"
{
	RA      8.67027778
	Dec     64.3280556
	Dist    78.5
	AppMagn 5.79
	Class  "K1III"
	MassSol 1.234
	RadSol  18.11
	Teff    4415
	FeH    -0.25
	Age     4.604
}

Star	"51 Eri/HD 29391/HIP 21547"
{
	RA      4.626703429
	Dec     -2.473548598
	Dist    29.4
	AppMagn 5.223
	Class  "F0IV"
	MassSol 1.75
	FeH    -0.027
	Age     0.02
}

Star	"6 Lyn/HD 45410/HIP 31039"
{
	RA      6.5130854
	Dec     58.162632
	Dist    56.95
	AppMagn 5.86
	Class  "K0III"
	MassSol 1.7
	RadSol  5.2
	Teff    4978
	FeH    -0.13
}

Star	"61 Vir/HD 115617/HIP 64924"
{
	RA      13.30675453
	Dec     -18.311195
	Dist    8.52
	AppMagn 4.74
	Class  "G7V"
	MassSol 0.94
	RadSol  0.96
	Teff    5577
	FeH    -0.01
	Age     8.96
}

Star	"7 CMa/HD 47205/HIP 31592"
{
	RA      6.611399333
	Dec     -19.255878
	Dist    19.84
	AppMagn 3.92
	Class  "K1III"
	MassSol 1.52
	RadSol  2.3
	Teff    4792
	FeH     0.21
}

Star	"70 Vir/HD 117176/HIP 65721"
{
	RA      13.47383627
	Dec     13.778788
	Dist    18.11
	AppMagn 4.98
	Class  "G4V"
	MassSol 1.09
	RadSol  1.94
	Teff    5439
	FeH    -0.09
	Age     7.09
}

Star	"75 Cet/HD 15779/HIP 11791"
{
	RA      2.5359502
	Dec     -1.034896
	Dist    81.5
	AppMagn 5.35
	Class  "G3III"
	MassSol 2.49
	RadSol  10.5
	Teff    4846
	FeH     0
}

Star	"8 UMi/8 Umi/HD 133086/HIP 73136"
{
	RA      14.94676513
	Dec     74.900925
	Dist    159.1
	AppMagn 6.83
	Class  "K0"
	MassSol 1.8
	RadSol  9.9
	Teff    4847.4
	FeH    -0.03
	Age     1.7
}

Star	"81 Cet/HD 16400/HIP 12247"
{
	RA      2.628333333
	Dec     -3.3961111
	Dist    97.2
	AppMagn 5.65
	Class  "G5III"
	MassSol 2.4
	RadSol  11
	Teff    4785
	FeH    -0.06
}

/*
Star	"91 Aqr/HD 219449/HIP 114855"
{
	RA      23.26472222
	Dec     -9.0875
	Dist    45.9
	AppMagn 4.21
	Class  "K0III"
	MassSol 1.4
	RadSol  11
	Teff    4665
	FeH    -0.03
	Age     3.56
}
*/

Star	"AB Pic/HD 44627/HIP 30034"
{
	RA      6.320253467
	Dec     -58.05431
	Dist    45.52
	AppMagn 9.128
	Class  "K2V"
	Teff    4875
	FeH    -0.64
	Age     0.03
}

Star	"ALF Ari/HD 12929/HIP 9884"
{
	RA      2.1195576
	Dec     23.462423
	Dist    20.21
	AppMagn 2
	Class  "K1IIIb"
	MassSol 1.5
	RadSol  13.9
	Teff    4553
	FeH    -0.09
}

Star	"Ain/EPS Tau/HD 28305/HIP 20889"
{
	RA      4.476944447
	Dec     19.1805556
	Dist    45
	AppMagn 3.53
	Class  "K0III"
	MassSol 2.7
	RadSol  13.7
	Teff    4901
	FeH     0.17
	Age     0.625
}

Star	"Aldebaran/ALF Tau/HD 29139/HIP 21421"
{
	RA      4.5986776
	Dec     16.509302
	Dist    20.43
	AppMagn 0.85
	Class  "K5III"
	MassSol 1.13
	RadSol  45.1
	Teff    4055
	FeH    -0.27
	Age     6.6
}

Star	"BD+15 2375"
{
	RA      11.76555556
	Dec     14.61638891
	Dist    774
	AppMagn 10.3
	MassSol 1.08
	RadSol  8.95
	Teff    4649
	FeH    -0.22
	Age     7.4
}

Star	"BD+20 1790"
{
	RA      7.395440667
	Dec     20.416334
	Dist    25.4
	AppMagn 7.032
	Class  "K5V"
	MassSol 0.63
	RadSol  0.71
	Teff    4410
	FeH     0.3
}

Star	"BD+20 2457"
{
	RA      10.27916667
	Dec     19.8913889
	Dist    200
	AppMagn 9.75
	Class  "K2II"
	MassSol 2.8
	RadSol  49
	Teff    4127
	FeH    -1
}

Star	"BD+20 274"
{
	RA      1.7280216
	Dec     21.005314
	AppMagn 9.36
	Class  "K5III"
	MassSol 0.8
	RadSol  17.3
	Teff    4296
	FeH    -0.46
}

Star	"BD+20 594"
{
	RA      3.576666667
	Dec     20.59916669
	Dist    152.1
	AppMagn 11
	Class  "K0"
	MassSol 0.961
	RadSol  0.928
	Teff    5766
	FeH    -0.15
	Age     3.34
}

Star	"BD+24 4697"
{
	RA      23.0275
	Dec     25.78805558
	Dist    48.8
	AppMagn 9.74
	MassSol 0.75
	Teff    5077
	FeH    -0.11
}

Star	"BD+26 1888"
{
	RA      9.041944445
	Dec     25.88944447
	Dist    38
	AppMagn 9.76
	Class  "K7"
	MassSol 0.76
	Teff    4748
	FeH     0.02
}

Star	"BD+48 738"
{
	RA      2.713888887
	Dec     49.5869444
	AppMagn 9.14
	Class  "K0III"
	MassSol 0.74
	RadSol  11
	Teff    4414
	FeH    -0.2
}

Star	"BD+49 828"
{
	RA      3.042777779
	Dec     49.73000003
	AppMagn 9.38
	Class  "K0"
	MassSol 1.52
	RadSol  7.6
	Teff    4943
	FeH    -0.19
	Age     2.3
}

Star	"BD-10 3166"
{
	RA      10.97444445
	Dec     -10.7702778
	Dist    66
	AppMagn 10.08
	Class  "G4V"
	MassSol 0.99
	RadSol  1.71
	Teff    5400
	FeH     0.5
	Age     4.18
}

Star	"BET Cir"
{
	RA      15.29194445
	Dec     -58.80111113
	Dist    30.56
	Class  "A3V"
	MassSol 1.96
	Teff    8676
	Age     0.367
}

Star	"BET Cnc/HD 69267/HIP 40526"
{
	RA      8.275255867
	Dec     9.185545
	Dist    89.05
	AppMagn 3.53
	Class  "K4III"
	MassSol 1.7
	RadSol  47.2
	Teff    4092.1
	FeH    -0.29
	Age     1.85
}

Star	"BET Pic/HD 39060/HIP 27321"
{
	RA      5.788055553
	Dec     -51.0663889
	Dist    19.3
	AppMagn 3.86
	Class  "A6V"
	MassSol 1.73
	Age     0.04
}

Star	"BET UMi/HD 131873/HIP 72607"
{
	RA      14.84509073
	Dec     74.155502
	Dist    38.78
	AppMagn 2.08
	Class  "K4III"
	MassSol 1.4
	RadSol  38.3
	Teff    4126
	FeH    -0.27
	Age     2.95
}

Star	"CD-35 2722"
{
	RA      6.155336195
	Dec     -35.82533225
	Dist    21.3
	AppMagn 10.98
	Class  "M1V"
	MassSol 0.4
	Teff    3680
	FeH     0.04
	Age     0.1
}

Star	"CHXR 73"
{
	RA      11.10805555
	Dec     -77.6258333
	AppMagn 11.32
	Class  "M3.2"
	MassSol 0.35
	Age     0.002
}

Star	"CT Cha"
{
	RA      11.06919147
	Dec     -76.455383
	Dist    165
	AppMagn 12.36
	Class  "K7"
	Age     0.002
}

Star	"Cervantes/MU Ara/HD 160691/HIP 86796"
{
	RA      17.73555555
	Dec     -51.8338889
	Dist    15.3
	AppMagn 5.15
	Class  "G3V"
	MassSol 1.08
	RadSol  1.245
	Teff    5700
	FeH     0.28
	Age     6.41
}

Star	"Chalawan/47 UMa/HD 95128/HIP 53721"
{
	RA      10.99138889
	Dec     40.4294444
	Dist    13.97
	AppMagn 5.1
	Class  "G0V"
	MassSol 1.03
	RadSol  1.24
	Teff    5892
	FeH     0
	Age     7.4
}

Star	"CoRoT-1"
{
	RA      6.80527778
	Dec     -3.1022222
	Dist    460
	AppMagn 13.6
	Class  "G0V"
	MassSol 0.95
	RadSol  1.11
	Teff    6298
	FeH     0.06
}

Star	"CoRoT-10"
{
	RA      19.40416667
	Dec     0.7461111
	Dist    345
	AppMagn 15.22
	Class  "K1V"
	MassSol 0.89
	RadSol  0.79
	Teff    5075
	FeH     0.26
	Age     3
}

Star	"CoRoT-11"
{
	RA      18.7125
	Dec     5.9377778
	Dist    560
	AppMagn 12.94
	Class  "F6V"
	MassSol 1.56
	RadSol  1.36
	Teff    6343
	FeH     0.04
	Age     2
}

Star	"CoRoT-12"
{
	RA      6.71777778
	Dec     -1.2963889
	Dist    1150
	AppMagn 15.52
	Class  "G2V"
	MassSol 1.078
	RadSol  1.116
	Teff    5675
	FeH     0.16
	Age     6.3
}

Star	"CoRoT-13"
{
	RA      6.848055553
	Dec     -5.0863889
	Dist    1310
	AppMagn 15.04
	Class  "G0V"
	MassSol 1.09
	RadSol  1.01
	Teff    5945
	FeH     0.01
	Age     1.64
}

Star	"CoRoT-14"
{
	RA      6.895
	Dec     -5.5361111
	Dist    1340
	AppMagn 16.03
	Class  "F9V"
	MassSol 1.13
	RadSol  1.21
	Teff    6035
	FeH     0.05
	Age     4.2
}

Star	"CoRoT-15"
{
	RA      6.474444445
	Dec     6.186241673
	AppMagn 14.83 // not V mag
	Class  "F7V"
}

Star	"CoRoT-16"
{
	RA      18.56833333
	Dec     -6.0025
	Dist    840
	AppMagn 15.64
	Class  "G5V"
	MassSol 1.098
	RadSol  1.19
	Teff    5650
	FeH     0.19
	Age     6.73
}

Star	"CoRoT-17"
{
	RA      18.57972222
	Dec     -6.6122222
	Dist    920
	AppMagn 15.46
	Class  "G2V"
	MassSol 1.04
	RadSol  1.59
	Teff    5740
	FeH     0
	Age     10.7
}

Star	"CoRoT-18"
{
	RA      6.544722223
	Dec     0.031388901
	Dist    870
	AppMagn 14.99
	Class  "G9V"
	MassSol 0.95
	RadSol  1
	Teff    5440
	FeH    -0.1
}

Star	"CoRoT-19"
{
	RA      6.468888889
	Dec     0.170555562
	Dist    800
	AppMagn 14.78
	Class  "F9V"
	MassSol 1.21
	RadSol  1.65
	Teff    6090
	FeH    -0.02
	Age     5
}

Star	"CoRoT-2"
{
	RA      19.45194445
	Dec     1.3838889
	Dist    300
	AppMagn 12.57
	Class  "G7V"
	MassSol 0.97
	RadSol  0.902
	Teff    5575
	FeH    -0.04
}

Star	"CoRoT-20"
{
	RA      6.515362267
	Dec     0.22692
	Dist    1230
	AppMagn 14.66
	Class  "G2V"
	MassSol 1.14
	RadSol  0.92
	Teff    5880
	FeH     0.14
	Age     0.1
}

Star	"CoRoT-21"
{
	RA      6.73683
	Dec     -0.29913
	AppMagn 16
	Class  "F8IV"
	MassSol 1.29
	RadSol  1.945
	Teff    6200
	FeH     0
	Age     4.1
}

Star	"CoRoT-22"
{
	RA      18.71114093
	Dec     6.219136
	Dist    592
	AppMagn 11.93
	Class  "G0IV"
	MassSol 1.099
	RadSol  1.136
	Teff    5939
	FeH     0.17
	Age     3.3
}

Star	"CoRoT-23"
{
	RA      18.65217433
	Dec     4.3578
	Dist    600
	AppMagn 15.63
	Class  "G0V"
	MassSol 1.14
	RadSol  1.61
	Teff    5900
	FeH     0.05
	Age     7.2
}

Star	"CoRoT-24"
{
	RA      6.7948364
	Dec     -3.719301
	Dist    600
	AppMagn 14.3
	Class  "K1V"
	MassSol 0.91
	RadSol  0.86
	Teff    4950
	FeH     0.3
	Age     11
}

Star	"CoRoT-25"
{
	RA      18.70861333
	Dec     6.5139
	Dist    1000
	AppMagn 15
	Class  "G0V"
	MassSol 1.09
	RadSol  1.19
	Teff    6040
	FeH    -0.01
	Age     5.2
}

Star	"CoRoT-26"
{
	RA      18.65
	Dec     6.97
	Dist    1670
	AppMagn 15.76
	Class  "G8IV"
	MassSol 1.09
	RadSol  1.79
	Teff    5590
	FeH     0.01
	Age     8.6
}

Star	"CoRoT-27"
{
	RA      18.56638667
	Dec     5.5386
	AppMagn 15.54
	Class  "G2"
	MassSol 1.05
	RadSol  1.08
	Teff    5900
	FeH     0.1
	Age     4.21
}

Star	"CoRoT-28"
{
	RA      18.57916667
	Dec     5.5739
	Dist    560
	AppMagn 13.49
	Class  "G9IV"
	MassSol 1.01
	RadSol  1.78
	Teff    5150
	FeH     0.15
	Age     12
}

Star	"CoRoT-29"
{
	RA      18.59361333
	Dec     6.4797
	Dist    765
	AppMagn 15.35
	Class  "K0V"
	MassSol 0.976
	RadSol  0.9
	Teff    5260
	FeH     0.2
	Age     4.5
}

Star	"CoRoT-3"
{
	RA      19.47027778
	Dec     0.1219444
	Dist    680
	AppMagn 13.3
	Class  "F3V"
	MassSol 1.41
	RadSol  1.44
	Teff    6558
	FeH     0.14
	Age     2
}

Star	"CoRoT-33"
{
	RA      18.64277778
	Dec     5.624722241
	AppMagn 14.7
	Class  "G9V"
	MassSol 0.86
	RadSol  0.94
	Teff    5225
	FeH     0.44
	Age     4.6
}

Star	"CoRoT-4"
{
	RA      6.813055553
	Dec     -0.6727778
	AppMagn 13.7
	Class  "F8V"
	MassSol 1.1
	RadSol  1.15
	Teff    6190
	FeH     0.05
	Age     1
}

Star	"CoRoT-5"
{
	RA      6.751944447
	Dec     0.8152778
	Dist    400
	AppMagn 14
	Class  "F9V"
	MassSol 1
	RadSol  1.186
	Teff    6100
	FeH    -0.25
	Age     6.9
}

Star	"CoRoT-6"
{
	RA      18.73833333
	Dec     6.6633333
	AppMagn 13.9
	Class  "F9V"
	MassSol 1.055
	RadSol  1.025
	Teff    6090
	FeH    -0.2
}

Star	"CoRoT-7"
{
	RA      6.730408333
	Dec     -1.063033
	Dist    153.7
	AppMagn 11.668
	Class  "G9V"
	MassSol 0.91
	RadSol  0.82
	Teff    5259
	FeH     0.138
	Age     1.5
}

Star	"CoRoT-8"
{
	RA      19.43916667
	Dec     1.4266667
	Dist    380
	AppMagn 14.8
	Class  "K1V"
	MassSol 0.88
	RadSol  0.77
	Teff    5080
	FeH     0.3
	Age     3
}

Star	"CoRoT-9"
{
	RA      18.71916667
	Dec     6.2041667
	Dist    460
	AppMagn 13.7
	Class  "G3V"
	MassSol 0.99
	RadSol  0.94
	Teff    5625
	FeH    -0.01
	Age     4
}

Star	"DENIS-P J082303.1-491201/DE0823-49"
{
	RA      8.384166667
	Dec     -48.79972222
	Dist    20.69
	AppMagn 12.636
	Class  "L1.5"
	MassSol 0.045
	Teff    2150
	Age     0.1
}

Star	"DH Tau"
{
	RA      4.494877133
	Dec     26.54952
	Dist    140
	AppMagn 13.71
	Class  "M0.5"
	MassSol 0.33
	RadSol  0.27
	Age     0.001
}

Star	"DW Lyn"
{
	RA      7.119390834
	Dec     60.64725836
	AppMagn 15.45 // not V mag
	Class  "sdB"
}

Star	"EPIC 201295312"
{
	RA      11.60083333
	Dec     -2.520833347
	AppMagn 12.5
	MassSol 1.13
	RadSol  1.52
	Teff    5830
	FeH     0.13
}

Star	"EPIC 201367065/K2-3"
{
	RA      11.48888889
	Dec     -1.454722235
	Dist    42
	AppMagn 12.17
	Class  "M0V"
	MassSol 0.612
	RadSol  0.553
	Teff    3951
	FeH    -0.3
	Age     1
}

Star	"EPIC 201505350/K2-19"
{
	RA      11.66402222
	Dec     0.6035833482
	Dist    291
	AppMagn 12.806
	Class  "G9V"
	MassSol 0.93
	RadSol  0.86
	Teff    5430
	FeH     0.1
	Age     8
}

Star	"EPIC 205117205"
{
	RA      16.17083333
	Dec     -19.31916668
	Dist    145
	AppMagn 16
	Class  "M3.3"
	MassSol 0.54
	RadSol  1.06
	Teff    3540
	Age     0.0095
}

Star	"ETA Cet"
{
	RA      1.143055556
	Dec     -10.18222224
	Dist    38
	AppMagn 3.45
	Class  "K1III"
	MassSol 1.7
	RadSol  14.3
	Teff    4528
	FeH     0.12
}

Star	"Edasich/Eldsich/IOT Dra/12 Dra/HD 137759/HIP 75458"
{
	RA      15.41527778
	Dec     58.9658333
	Dist    31.5
	AppMagn 3.31
	Class  "K2III"
	MassSol 1.4
	RadSol  12.8
	Teff    4445
	FeH     0.15
}

Star	"FU Tau"
{
	RA      4.393260533
	Dec     25.049898
	Dist    140
	AppMagn 13.913
	Class  "M7.2"
	MassSol 0.05
	Teff    2838
	Age     0.001
}

Star	"Fafnir/42 Dra/HD 170693/HIP 90344"
{
	RA      18.43309327
	Dec     65.563484
	Dist    97.28
	AppMagn 4.82
	Class  "K1.5III"
	MassSol 0.98
	RadSol  22.03
	Teff    4200
	FeH    -0.46
	Age     9.49
}

Star	"Fomalhaut/HD 216956/HIP 113368"
{
	RA      22.96084593
	Dec     -29.622236
	Dist    7.69
	AppMagn 1.16
	Class  "A3V"
	MassSol 2
	RadSol  1.842
	Teff    8590
	Age     0.44
}

Star	"GQ Lup"
{
	RA      15.82002867
	Dec     -35.651421
	Dist    139
	AppMagn 12.43
	Class  "K7V"
	MassSol 0.7
	Age     0.001
}

Star	"GSC 06214-00210"
{
	RA      16.36518553
	Dec     -20.719202
	Dist    145
	AppMagn 12.375
	Class  "K7"
	MassSol 0.9
	Teff    4200
	Age     0.011
}

Star	"GU Psc"
{
	RA      1.209722223
	Dec     17.06555557
	Dist    48
	AppMagn 13.55
	Class  "M3"
	MassSol 0.35
	FeH     0.1
	Age     0.1
}

Star	"Gliese 1132"
{
	RA      10.2477158
	Dec     -47.156727
	Dist    12.04
	AppMagn 13.49
	Class  "M4.5V"
	MassSol 0.18
	RadSol  0.21
	Teff    3270
	FeH    -0.12
	Age     5
}

Star	"Gliese 1214"
{
	RA      17.2552558
	Dec     4.96392
	Dist    13
	AppMagn 15.1
	Class  "M4.5"
	MassSol 0.16
	RadSol  0.18
	Teff    3170
	FeH     0
	Age     6
}

Star	"Gliese 160.2"
{
	RA      4.109678156
	Dec     -19.14687801
	AppMagn 9.675
	Class  "M0V"
	MassSol 0.69
	Teff    4347
}

Star	"Gliese 163/HIP 19394"
{
	RA      4.154446667
	Dec     -53.3736
	Dist    15
	AppMagn 11.8
	Class  "M3.5"
	MassSol 0.4
	Teff    3500
	FeH     0.1
	Age     3
}

Star	"Gliese 176/HD 285968/HIP 21932"
{
	RA      4.7154938
	Dec     18.958172
	Dist    9.42
	AppMagn 9.97
	Class  "M2V"
	MassSol 0.45
	RadSol  0.45
	Teff    3679
	FeH     0.15
}

Star	"Gliese 179/HIP 22627"
{
	RA      4.868333333
	Dec     6.4766667
	Dist    12.3
	AppMagn 11.96
	Class  "M3.5"
	MassSol 0.357
	RadSol  0.38
	Teff    3370
	FeH     0.3
}

Star	"Gliese 180"
{
	RA      4.897216601
	Dec     -16.22658487
	AppMagn 10.894
	Class  "M2V"
	MassSol 0.43
	Teff    3371
}

Star	"Gliese 221/HIP 27803/BD-06 1339"
{
	RA      5.883333333
	Dec     -5.9947
	Dist    20
	AppMagn 6.69
	Class  "K7V"
	MassSol 0.7
	Teff    4324
	FeH    -0.14
	Age     4.4
}

Star	"Gliese 27.1"
{
	RA      0.6663405319
	Dec     -43.74677819
	AppMagn 11.401
	Class  "M0.5V"
	MassSol 0.53
	Teff    3542
}

Star	"Gliese 317"
{
	RA      8.683055553
	Dec     -23.4563889
	Dist    15.1
	AppMagn 12
	Class  "M3.5"
	MassSol 0.42
	Teff    3510
	FeH     0.36
}

Star	"Gliese 328/HIP 43790"
{
	RA      8.918886667
	Dec     1.54901111
	Dist    19.8
	AppMagn 9.98
	Class  "K7"
	MassSol 0.69
	Teff    3900
	FeH     0
}

Star	"Gliese 3293"
{
	RA      4.476666667
	Dec     -25.16916667
	Dist    17.9
	AppMagn 11.96
	Class  "M2.5"
	MassSol 0.42
	RadSol  0.404
	Teff    3466
	FeH     0.02
}

Star	"Gliese 3341"
{
	RA      5.263055557
	Dec     -31.29611113
	Dist    23.1
	AppMagn 12.08
	Class  "M2.5"
	MassSol 0.47
	RadSol  0.349
	Teff    3526
	FeH    -0.09
}

Star	"Gliese 3470"
{
	RA      7.985
	Dec     15.3916667
	Dist    30.7
	AppMagn 12.27
	Class  "M1.5"
	MassSol 0.539
	RadSol  0.568
	Teff    3600
	FeH     0.2
	Age     1
}

Star	"Gliese 3634"
{
	RA      10.976416
	Dec     -31.14399
	Dist    19.8
	AppMagn 11.93
	Class  "M2.5"
	MassSol 0.45
	RadSol  0.43
}

Star	"Gliese 422"
{
	RA      11.26672375
	Dec     -56.45233364
	AppMagn 11.516
	Class  "M3.5V"
	MassSol 0.35
	Teff    3323
}

Star	"Gliese 433/HIP 56528"
{
	RA      11.59083333
	Dec     -32.54
	Dist    9.04
	AppMagn 9.79
	Class  "M1.5"
	MassSol 0.48
	Teff    3600
	FeH    -0.22
}

Star	"Gliese 436/HIP 57087"
{
	RA      11.70305555
	Dec     26.7063889
	Dist    10.2
	AppMagn 10.68
	Class  "M2.5"
	MassSol 0.452
	RadSol  0.464
	Teff    3684
	FeH    -0.32
	Age     6
}

Star	"Gliese 504/HD 115383/HIP 64792"
{
	RA      13.27972
	Dec     9.4242
	Dist    17.56
	AppMagn 5.22
	Class  "G0V"
	MassSol 1.22
	Teff    6234
	FeH     0.28
	Age     0.16
}

Star	"Gliese 581/HIP 74995"
{
	RA      15.32388889
	Dec     -7.7222222
	Dist    6.21
	AppMagn 10.55
	Class  "M2.5V"
	MassSol 0.31
	RadSol  0.3
	Teff    3498
	FeH    -0.135
	Age     8
}

Star	"Gliese 649/HIP 83043"
{
	RA      16.96916667
	Dec     25.7441667
	Dist    10.34
	AppMagn 9.7
	Class  "M1.5"
	MassSol 0.54
	Teff    3700
	FeH     0.08
}

Star	"Gliese 674/HIP 85523"
{
	RA      17.47776287
	Dec     -46.895191
	Dist    4.54
	AppMagn 9.37
	Class  "M2.5"
	MassSol 0.35
	Teff    3600
	FeH    -0.28
	Age     0.55
}

Star	"Gliese 682"
{
	RA      17.61768401
	Dec     -43.68078619
	Dist    5.08
	AppMagn 10.96
	Class  "M3.5V"
	MassSol 0.27
	RadSol  0.27
	Teff    3028
}

Star	"Gliese 687/HIP 86162"
{
	RA      17.60722222
	Dec     68.33916668
	Dist    4.5
	AppMagn 9.15
	Class  "M3.5V"
	MassSol 0.413
	RadSol  0.4183
	Teff    3413
}

Star	"Gliese 758"
{
	RA      19.39277778
	Dec     33.2219444
	Dist    15.5
	AppMagn 6.36
	Class  "K0V"
	MassSol 0.97
	RadSol  0.88
	Teff    5425
	FeH     0.18
	Age     8.2
}

Star	"Gliese 785/HD 192310/HIP 99825"
{
	RA      20.25472222
	Dec     -27.0330556
	Dist    8.911
	AppMagn 6.13
	Class  "K1V"
	MassSol 0.78
	RadSol  0.68
	Teff    5144
	FeH     0.08
}

Star	"Gliese 832/HD 204961/HIP 106440"
{
	RA      21.55944445
	Dec     -49.0088889
	Dist    4.94
	AppMagn 8.67
	Class  "M1.5"
	MassSol 0.45
	Teff    3472
	FeH    -0.31
}

Star	"Gliese 849/HIP 109388"
{
	RA      22.16120807
	Dec     -4.640729
	Dist    8.77
	AppMagn 10.37
	Class  "M3V"
	MassSol 0.49
	RadSol  0.52
	FeH     0.16
}

Star	"Gliese 86 A/HD 13445/HIP 10138"
{
	RA      2.173870626
	Dec     -50.82372722
	Dist    10.9
	AppMagn 6.17
	Class  "K1V"
	MassSol 0.8
	RadSol  0.855
	Teff    5350
	FeH    -0.24
	Age     2.03
}

Star	"Gliese 876/HIP 113020"
{
	RA      22.88694445
	Dec     -14.2536111
	Dist    4.7
	AppMagn 10.17
	Class  "M4V"
	MassSol 0.334
	RadSol  0.36
	Teff    3350
	FeH     0.05
	Age     2.5
}

Star	"HAT-P-10/WASP-11"
{
	RA      3.158055553
	Dec     30.6736111
	Dist    125
	AppMagn 11.89
	Class  "K3V"
	MassSol 0.82
	RadSol  0.81
	Teff    4980
	FeH     0.13
	Age     11.2
}

Star	"HAT-P-12"
{
	RA      13.95944445
	Dec     43.4936111
	Dist    142.5
	AppMagn 12.84
	Class  "K4"
	MassSol 0.73
	RadSol  0.7
	Teff    4650
	FeH    -0.29
	Age     2.5
}

Star	"HAT-P-13"
{
	RA      8.658835867
	Dec     47.352051
	Dist    214
	AppMagn 10.622
	Class  "G4"
	MassSol 1.22
	RadSol  1.56
	Teff    5653
	FeH     0.41
	Age     5
}

Star	"HAT-P-14"
{
	RA      17.34107867
	Dec     38.242165
	Dist    205
	AppMagn 9.98
	Class  "F"
	MassSol 1.39
	RadSol  1.47
	Teff    6600
	FeH     0.11
	Age     1.3
}

Star	"HAT-P-15"
{
	RA      4.416534933
	Dec     39.460636
	Dist    190
	AppMagn 12.16
	Class  "G5"
	MassSol 1.01
	RadSol  1.08
	Teff    5568
	FeH     0.22
	Age     6.8
}

Star	"HAT-P-16"
{
	RA      0.6383333333
	Dec     42.4630556
	Dist    235
	AppMagn 10.8
	Class  "F8"
	MassSol 1.218
	RadSol  1.237
	Teff    6158
	FeH     0.17
	Age     2
}

Star	"HAT-P-17"
{
	RA      21.63583333
	Dec     30.4886111
	Dist    90
	AppMagn 10.54
	Class  "K"
	MassSol 0.857
	RadSol  0.837
	Teff    5246
	FeH     0
	Age     7.8
}

Star	"HAT-P-18"
{
	RA      17.09
	Dec     33.0125
	Dist    166
	AppMagn 12.76
	Class  "K"
	MassSol 0.77
	RadSol  0.717
	Teff    4870
	FeH     0.1
	Age     12.4
}

Star	"HAT-P-19"
{
	RA      0.6344444467
	Dec     34.7116667
	Dist    215
	AppMagn 12.9
	Class  "K"
	MassSol 0.842
	RadSol  0.82
	Teff    4990
	FeH     0.23
	Age     8.8
}

Star	"HAT-P-20"
{
	RA      7.461111113
	Dec     24.3363889
	Dist    70
	AppMagn 11.34
	Class  "K7"
	MassSol 0.756
	RadSol  0.694
	Teff    4595
	FeH     0.35
	Age     6.7
}

Star	"HAT-P-21"
{
	RA      11.41833333
	Dec     41.0280556
	Dist    254
	AppMagn 11.46
	Class  "G3"
	MassSol 0.947
	RadSol  1.105
	Teff    5588
	FeH     0.01
	Age     10.2
}

Star	"HAT-P-23"
{
	RA      20.408256
	Dec     16.762152
	Dist    393
	AppMagn 11.94
	Class  "G0"
	MassSol 1.1
	RadSol  1.09
	Teff    5885
	FeH     0.13
	Age     4
}

Star	"HAT-P-24"
{
	RA      7.255003867
	Dec     14.262599
	Dist    396
	AppMagn 11.818
	Class  "F8"
	MassSol 1.19
	RadSol  1.32
	Teff    6373
	FeH    -0.16
	Age     2.8
}

Star	"HAT-P-25"
{
	RA      3.229166667
	Dec     25.1975
	Dist    297
	AppMagn 13.19
	Class  "G5"
	MassSol 1.01
	RadSol  0.959
	Teff    5500
	FeH     0.31
	Age     3.2
}

Star	"HAT-P-26"
{
	RA      14.2104258
	Dec     4.059997
	Dist    134
	AppMagn 11.74
	Class  "K1"
	MassSol 0.816
	RadSol  0.788
	Teff    5079
	FeH    -0.04
	Age     9
}

Star	"HAT-P-27/WASP-40"
{
	RA      14.85111111
	Dec     5.9472222
	Dist    204
	AppMagn 12.21
	Class  "G8"
	MassSol 0.945
	RadSol  0.898
	Teff    5300
	FeH     0.29
	Age     4.4
}

Star	"HAT-P-28"
{
	RA      0.8666666667
	Dec     34.7283333
	Dist    395
	AppMagn 13.03
	Class  "G3"
	MassSol 1.025
	RadSol  1.103
	Teff    5680
	FeH     0.12
	Age     6.1
}

Star	"HAT-P-29"
{
	RA      2.208611113
	Dec     51.7788889
	Dist    322
	AppMagn 11.9
	Class  "F8"
	MassSol 1.207
	RadSol  1.224
	Teff    6087
	FeH     0.21
	Age     2.2
}

Star	"HAT-P-3"
{
	RA      13.73972222
	Dec     48.0286111
	Dist    130
	AppMagn 11.86
	Class  "K"
	MassSol 0.917
	RadSol  0.799
	Teff    5224
	FeH     0.41
	Age     1.6
}

Star	"HAT-P-30/WASP-51"
{
	RA      8.263333333
	Dec     5.8366667
	Dist    193
	AppMagn 10.42
	Class  "F"
	MassSol 1.18
	RadSol  1.33
	Teff    6250
	FeH    -0.08
	Age     1
}

Star	"HAT-P-31"
{
	RA      18.1025
	Dec     26.4266667
	Dist    354
	AppMagn 11.66
	MassSol 1.218
	RadSol  1.36
	Teff    6065
	FeH     0.15
	Age     3.17
}

Star	"HAT-P-32"
{
	RA      2.069444445
	Dec     46.6877778
	Dist    320
	AppMagn 11.29
	Class  "G"
	MassSol 1.176
	RadSol  1.387
	Teff    6001
	FeH    -0.16
	Age     3.8
}

Star	"HAT-P-33"
{
	RA      7.545555553
	Dec     33.835
	Dist    419
	AppMagn 11.89
	Class  "F"
	MassSol 1.403
	RadSol  1.777
	Teff    6401
	FeH     0.05
	Age     2.4
}

Star	"HAT-P-35"
{
	RA      8.216717533
	Dec     4.787023
	Dist    535
	AppMagn 12.46
	MassSol 1.24
	RadSol  1.44
	Teff    6096
	FeH     0.11
	Age     3.5
}

Star	"HAT-P-36"
{
	RA      12.5510834
	Dec     44.915352
	Dist    317
	AppMagn 12.262
	MassSol 1.02
	RadSol  1.1
	Teff    5560
	FeH     0.26
	Age     6.6
}

Star	"HAT-P-37"
{
	RA      18.95307007
	Dec     51.269138
	Dist    411
	AppMagn 13.23
	MassSol 0.93
	RadSol  0.88
	Teff    5500
	FeH     0.03
	Age     3.6
}

Star	"HAT-P-38"
{
	RA      2.358882133
	Dec     32.246151
	Dist    249
	AppMagn 12.557
	Class  "G"
	MassSol 0.89
	RadSol  0.92
	Teff    5330
	FeH     0.06
	Age     10.1
}

Star	"HAT-P-39"
{
	RA      7.583886667
	Dec     17.83
	Dist    642
	AppMagn 11.422
	MassSol 1.404
	RadSol  1.625
	Teff    6430
	FeH     0.19
	Age     2
}

Star	"HAT-P-4"
{
	RA      15.33277778
	Dec     36.2297222
	Dist    310
	AppMagn 11.2
	Class  "F"
	MassSol 1.26
	RadSol  1.59
	Teff    5890
	FeH     0.2
	Age     4.2
}

Star	"HAT-P-40"
{
	RA      22.3675
	Dec     45.4575
	Dist    501
	AppMagn 11.699
	MassSol 1.512
	RadSol  2.206
	Teff    6080
	FeH     0.22
	Age     2.7
}

Star	"HAT-P-41"
{
	RA      19.82138667
	Dec     4.6725
	Dist    344
	AppMagn 11.087
	MassSol 1.28
	RadSol  1.19
	Teff    6479
	FeH     0.13
	Age     2.2
}

Star	"HAT-P-42"
{
	RA      9.0229594
	Dec     6.09723
	Dist    447
	AppMagn 12.168
	MassSol 1.18
	RadSol  1.53
	Teff    5743
	FeH     0.27
	Age     5.1
}

Star	"HAT-P-43"
{
	RA      8.595049
	Dec     10.206653
	Dist    542
	AppMagn 13.356
	MassSol 1.05
	RadSol  1.1
	Teff    5645
	FeH     0.23
	Age     5.7
}

Star	"HAT-P-44"
{
	RA      14.20972
	Dec     47.0147
	Dist    374
	AppMagn 13.212
	MassSol 0.939
	RadSol  0.979
	Teff    5295
	FeH     0.33
	Age     8.9
}

Star	"HAT-P-45"
{
	RA      18.29166667
	Dec     -3.3811
	Dist    305
	AppMagn 12.794
	MassSol 1.259
	RadSol  1.319
	Teff    6330
	FeH     0.07
	Age     2
}

Star	"HAT-P-46"
{
	RA      18.02972
	Dec     -2.9708333
	Dist    296
	AppMagn 11.936
	MassSol 1.284
	RadSol  1.396
	Teff    6120
	FeH     0.3
	Age     2.5
}

Star	"HAT-P-5"
{
	RA      18.29369913
	Dec     36.62141
	Dist    342
	AppMagn 12
	MassSol 1.16
	RadSol  1.14
	Teff    5960
	FeH     0.24
	Age     1.7
}

Star	"HAT-P-50"
{
	RA      7.870894067
	Dec     12.13941
	Dist    497
	AppMagn 11.762
	MassSol 1.27
	RadSol  1.7
	Teff    6280
	FeH    -0.18
	Age     3.37
}

Star	"HAT-P-51"
{
	RA      1.404346
	Dec     32.810764
	Dist    470
	AppMagn 13.44
	MassSol 0.98
	RadSol  1.04
	Teff    5449
	FeH     0.27
	Age     8.2
}

Star	"HAT-P-52"
{
	RA      2.848111933
	Dec     29.022396
	Dist    385
	AppMagn 14.068
	MassSol 0.89
	RadSol  0.89
	Teff    5131
	FeH     0.28
	Age     9.4
}

Star	"HAT-P-53"
{
	RA      1.458073667
	Dec     38.968147
	Dist    719
	AppMagn 13.73
	MassSol 1.09
	RadSol  1.21
	Teff    5956
	FeH     0
	Age     4.67
}

Star	"HAT-P-54"
{
	RA      6.659866867
	Dec     25.48254
	Dist    135.8
	AppMagn 13.505
	Class  "K"
	MassSol 0.65
	RadSol  0.62
	Teff    4390
	FeH    -0.127
	Age     3.9
}

Star	"HAT-P-55"
{
	RA      17.6182
	Dec     25.73119447
	Dist    480
	AppMagn 13.207
	MassSol 1.013
	RadSol  1.011
	Teff    5808
	FeH    -0.03
	Age     4.2
}

Star	"HAT-P-57"
{
	RA      18.31622807
	Dec     10.597294
	Dist    303
	AppMagn 10.465
	Class  "A8V"
	MassSol 1.47
	RadSol  1.5
	Teff    7500
	FeH    -0.25
	Age     1
}

Star	"HAT-P-6"
{
	RA      23.65166667
	Dec     42.4661111
	Dist    200
	AppMagn 10.5
	Class  "F"
	MassSol 1.29
	RadSol  1.46
	Teff    6570
	FeH    -0.13
	Age     2.3
}

Star	"HAT-P-8"
{
	RA      22.86944445
	Dec     35.4472222
	Dist    230
	AppMagn 10.17
	MassSol 1.28
	RadSol  1.58
	Teff    6200
	FeH     0.01
	Age     3.4
}

Star	"HAT-P-9"
{
	RA      7.344444447
	Dec     37.1405556
	Dist    480
	AppMagn 12.297
	Class  "F"
	MassSol 1.28
	RadSol  1.32
	Teff    6350
	FeH     0.12
	Age     1.6
}

Star	"HATS-1"
{
	RA      11.70168867
	Dec     -23.354836
	Dist    303
	AppMagn 12.053
	MassSol 0.99
	RadSol  1.04
	Teff    5870
	FeH    -0.06
	Age     6
}

Star	"HATS-10"
{
	RA      19.62055556
	Dec     -22.20444445
	Dist    496
	AppMagn 13.1
	MassSol 1.1
	RadSol  1.105
	Teff    5880
	FeH     0.15
	Age     3.3
}

Star	"HATS-11"
{
	RA      19.29333333
	Dec     -22.39000001
	Dist    906
	AppMagn 14
	Class  "G0"
	MassSol 1
	RadSol  1.44
	Teff    6060
	FeH    -0.39
	Age     7.7
}

Star	"HATS-12"
{
	RA      19.28027778
	Dec     -19.35583335
	Dist    981
	AppMagn 12.76
	Class  "F"
	MassSol 1.49
	RadSol  2.21
	Teff    6408
	FeH    -0.1
	Age     2.36
}

Star	"HATS-13"
{
	RA      21.13076373
	Dec     -26.096655
	Dist    476
	AppMagn 13.887
	MassSol 0.96
	RadSol  0.89
	Teff    5523
	FeH     0.05
	Age     2.5
}

Star	"HATS-14"
{
	RA      20.88103233
	Dec     -25.687334
	Dist    513
	AppMagn 13.79
	MassSol 0.97
	RadSol  0.93
	Teff    5346
	FeH     0.33
	Age     4.9
}

Star	"HATS-15"
{
	RA      20.7395
	Dec     -19.43752779
	Dist    689
	AppMagn 14.774
	MassSol 0.871
	RadSol  0.922
	Teff    5311
	FeH     0
	Age     11
}

Star	"HATS-16"
{
	RA      23.9039
	Dec     -30.01300001
	Dist    774
	AppMagn 13.834
	MassSol 0.97
	RadSol  1.238
	Teff    5738
	FeH     0.1
	Age     9.5
}

Star	"HATS-17"
{
	RA      12.81277778
	Dec     -47.61361113
	Dist    339
	AppMagn 12.4
	Class  "G"
	MassSol 1.131
	RadSol  1.091
	Teff    5846
	FeH     0.3
	Age     2.1
}

Star	"HATS-2"
{
	RA      11.782606
	Dec     -22.562992
	Dist    360
	AppMagn 13.562
	Class  "K"
	MassSol 0.88
	RadSol  0.9
	Teff    5227
	FeH     0.15
	Age     9.7
}

Star	"HATS-3"
{
	RA      20.83055333
	Dec     -24.4289
	Dist    453
	AppMagn 11.44
	Class  "F"
	MassSol 1.209
	RadSol  1.404
	Teff    6351
	FeH    -0.157
	Age     3.2
}

Star	"HATS-4"
{
	RA      6.2741384
	Dec     -22.546885
	Dist    420
	AppMagn 13.459
	Class  "G"
	MassSol 1
	RadSol  0.93
	Teff    5403
	FeH     0.43
	Age     2.1
}

Star	"HATS-5"
{
	RA      4.481524667
	Dec     -21.481916
	Dist    257
	AppMagn 12.63
	Class  "G"
	MassSol 0.94
	RadSol  0.87
	Teff    5304
	FeH     0.19
	Age     3.6
}

Star	"HATS-6"
{
	RA      5.876453133
	Dec     -19.031656
	Dist    148.4
	AppMagn 15.16
	Class  "M1V"
	MassSol 0.57
	RadSol  0.57
	Teff    3724
	FeH     0.2
}

Star	"HATS-7"
{
	RA      13.9238
	Dec     -21.20769445
	Dist    257
	AppMagn 6.1
	Class  "K2"
	MassSol 0.849
	RadSol  0.815
	Teff    4985
	FeH     0.25
	Age     7.8
}

Star	"HATS-8"
{
	RA      19.6627828
	Dec     -25.748318
	Dist    829
	AppMagn 14.03
	Class  "G2V"
	MassSol 1.06
	RadSol  1.09
	Teff    5679
	FeH     0.21
	Age     5.1
}

Star	"HATS-9"
{
	RA      19.38722222
	Dec     -20.14972224
	Dist    622
	AppMagn 13.3
	MassSol 1.03
	RadSol  1.5
	Teff    5336
	FeH     0.34
	Age     10.8
}

Star	"HD 100546/HIP 56379"
{
	RA      11.55706687
	Dec     -70.194786
	Dist    97
	AppMagn 6.704
	Class  "B9V"
	MassSol 2.4
	Teff    10500
}

Star	"HD 100655/HIP 56508"
{
	RA      11.58444445
	Dec     20.4416667
	Dist    122
	AppMagn 6.45
	Class  "G9III"
	MassSol 2.4
	RadSol  9.3
	Teff    4861
	FeH     0.15
}

Star	"HD 10069/HIP 7562/WASP-18"
{
	RA      1.623620733
	Dec     -45.677887
	Dist    105.49
	AppMagn 9.303
	Class  "F6IV"
	MassSol 1.28
	RadSol  1.23
	Teff    6400
	FeH     0
	Age     0.63
}

Star	"HD 100777/HIP 56572"
{
	RA      11.59777778
	Dec     -4.7558333
	Dist    52.8
	AppMagn 8.42
	Class  "K0"
	MassSol 1
	Teff    5582
	FeH     0.27
	Age     2
}

Star	"HD 10180/HIP 7599"
{
	RA      1.631548933
	Dec     -60.511528
	Dist    39.02
	AppMagn 7.321
	Class  "G1V"
	MassSol 1.06
	RadSol  1.11
	Teff    5911
	FeH     0.08
	Age     4.3
}

Star	"HD 101930/HIP 57172"
{
	RA      11.725
	Dec     -58.0066667
	Dist    30.49
	AppMagn 8.21
	Class  "K1V"
	MassSol 0.74
	Teff    5079
	FeH     0.17
	Age     5.39
}

Star	"HD 102117/HIP 57291"
{
	RA      11.74735007
	Dec     -58.703709
	Dist    42
	AppMagn 7.448
	Class  "G6V"
	MassSol 1.03
	RadSol  1.27
	Teff    5672
	FeH     0.3
	Age     6.21
}

Star	"HD 102195/HIP 57370"
{
	RA      11.76166667
	Dec     2.8213889
	Dist    28.98
	AppMagn 8.05
	Class  "K0V"
	MassSol 0.926
	RadSol  0.835
	Teff    5291
	FeH     0.05
	Age     2.4
}

Star	"HD 102272/HIP 57428"
{
	RA      11.77320453
	Dec     14.123986
	Dist    164.2
	AppMagn 8.711
	Class  "K2"
	MassSol 1.9
	RadSol  10.1
	Teff    4908
	FeH     0.26
}

Star	"HD 102329/HIP 57467"
{
	RA      11.7796234
	Dec     3.474293
	Dist    138.5
	AppMagn 7.886
	Class  "K0III"
	MassSol 1.95
	RadSol  6.3
	Teff    4830
	FeH     0.3
	Age     1.6
}

Star	"HD 102956/HIP 57820"
{
	RA      11.85625307
	Dec     57.640736
	Dist    121.07
	AppMagn 7.851
	Class  "G5"
	MassSol 1.68
	RadSol  4.4
	Teff    5054
	FeH     0.19
	Age     2.3
}

Star	"HD 103197/HIP 57931"
{
	RA      11.88138327
	Dec     -50.292824
	Dist    49.33
	AppMagn 9.391
	Class  "K1V"
	MassSol 0.9
	Teff    5303
	FeH     0.21
	Age     9.1
}

Star	"HD 103720/HIP 58237"
{
	RA      11.94477333
	Dec     -2.778953
	Dist    41.6
	AppMagn 9.49
	Class  "K3V"
	MassSol 0.79
	RadSol  0.73
	Teff    5017
	FeH    -0.02
	Age     3.8
}

Star	"HD 103774/HIP 58263"
{
	RA      11.94888667
	Dec     -12.1078
	Dist    55
	AppMagn 7.12
	Class  "F5V"
	MassSol 1.335
	Teff    6489
	FeH     0.28
	Age     1.05
}

Star	"HD 104067/HIP 58451"
{
	RA      11.98611347
	Dec     -20.353781
	Dist    20.82
	AppMagn 7.92
	Class  "K2V"
	MassSol 0.791
	Teff    4969
	FeH    -0.06
	Age     4.33
}

Star	"HD 10442"
{
	RA      1.698097133
	Dec     2.704376
	AppMagn 7.84
	Class  "K2IV"
	MassSol 1.56
	Teff    5034
	FeH     0.11
}

Star	"HD 106252/HIP 59610"
{
	RA      12.22472222
	Dec     10.0413889
	Dist    37.44
	AppMagn 7.36
	Class  "G0"
	MassSol 0.96
	RadSol  1.09
	Teff    5754
	FeH    -0.078
	Age     5.02
}

Star	"HD 106270/HIP 59625"
{
	RA      12.22702333
	Dec     -9.513381
	Dist    87.87
	AppMagn 7.577
	Class  "G5IV"
	MassSol 1.32
	RadSol  2.5
	Teff    5638
	FeH     0.08
	Age     4.3
}

Star	"HD 10647/HIP 7978"
{
	RA      1.708055553
	Dec     -53.7408333
	Dist    17.3
	AppMagn 5.52
	Class  "F8V"
	MassSol 1.1
	RadSol  1.1
	Teff    6039
	FeH    -0.078
	Age     4.8
}

Star	"HD 106906/HIP 59960"
{
	RA      12.29810893
	Dec     -55.975525
	Dist    91.83
	AppMagn 7.797
	Class  "F5V"
	MassSol 1.5
	Teff    6516
	Age     0.013
}

Star	"HD 10697/HIP 8159"
{
	RA      1.748611113
	Dec     20.0830556
	Dist    32.56
	AppMagn 6.29
	Class  "G5IV"
	MassSol 1.15
	RadSol  1.72
	Teff    5641
	FeH     0.1
	Age     6.9
}

Star	"HD 107148/HIP 60081"
{
	RA      12.32027778
	Dec     -3.3197222
	Dist    51.3
	AppMagn 8.01
	Class  "G5"
	MassSol 1.12
	Teff    5797
	FeH     0.314
	Age     5.6
}

Star	"HD 108147/HIP 60644"
{
	RA      12.42944445
	Dec     -64.0219444
	Dist    38.57
	AppMagn 6.99
	Class  "G0V"
	MassSol 1.19
	RadSol  1.22
	Teff    6067
	FeH     0.18
	Age     1.98
}

Star	"HD 108341/HIP 60788"
{
	RA      12.45871987
	Dec     -71.422974
	Dist    49.4
	AppMagn 9.36
	Class  "K2V"
	MassSol 0.84
	RadSol  0.79
	Teff    5122
	FeH     0.04
	Age     4.9
}

Star	"HD 108863/HIP 61020"
{
	RA      12.5055308
	Dec     21.948244
	Dist    138.5
	AppMagn 7.739
	Class  "K0"
	MassSol 1.85
	RadSol  5.6
	Teff    4956
	FeH     0.2
	Age     1.8
}

Star	"HD 108874/HIP 61028"
{
	RA      12.50746767
	Dec     22.879829
	Dist    68.54
	AppMagn 8.76
	Class  "G5V"
	MassSol 1
	RadSol  1.22
	Teff    5407
	FeH     0.14
	Age     7.26
}

Star	"HD 109246/HIP 61177"
{
	RA      12.5353302
	Dec     74.489548
	Dist    65.62
	AppMagn 8.757
	Class  "G0"
	MassSol 1.01
	RadSol  1.02
	Teff    5844
	FeH     0.1
}

Star	"HD 109271/HIP 61300"
{
	RA      12.56
	Dec     -11.6219
	Dist    62
	AppMagn 8.05
	Class  "G5V"
	MassSol 1.047
	Teff    5783
	FeH     0.1
	Age     7.3
}

Star	"HD 109749 A/HIP 61595 A"
{
	RA      12.6212158
	Dec     -40.812115
	Dist    59.03
	AppMagn 8.208
	Class  "G3V"
	MassSol 1.2
	Teff    5610
	FeH     0.25
	Age     10.3
}

Star	"HD 110014/HIP 61740"
{
	RA      12.65410153
	Dec     -7.995564
	Dist    97.66
	AppMagn 4.67
	Class  "K2III"
	MassSol 2.17
	RadSol  20.9
	Teff    4445
	FeH     0.19
	Age     0.95
}

Star	"HD 111232/HIP 62534"
{
	RA      12.8143758
	Dec     -68.425148
	Dist    28.88
	AppMagn 7.59
	Class  "G5V"
	MassSol 0.78
	Teff    5494
	FeH    -0.36
	Age     5.2
}

Star	"HD 112410/HIP 63242"
{
	RA      12.95888667
	Dec     -65.6464
	Dist    135
	AppMagn 6.86
	Class  "G8III"
	MassSol 1.54
	Teff    4830
	FeH    -0.31
}

Star	"HD 113337/HIP 63584"
{
	RA      13.02972
	Dec     63.6103
	Dist    36.9
	AppMagn 6
	Class  "F6V"
	MassSol 1.4
	RadSol  1.5
	Teff    6577
	FeH     0.07
	Age     0.15
}

Star	"HD 11343/HIP 8541"
{
	RA      1.835091667
	Dec     -54.464962
	Dist    168.63
	AppMagn 7.88
	Class  "K2III"
	MassSol 1.17
	RadSol  7.83
	Teff    4670
	FeH    -0.15
}

Star	"HD 113538/HIP 63833"
{
	RA      13.08263247
	Dec     -52.442924
	Dist    15.9
	AppMagn 9.057
	Class  "K9V"
	MassSol 0.58
	RadSol  0.53
	Teff    4462
	FeH    -0.24
	Age     4.3
}

Star	"HD 114386/HIP 64295"
{
	RA      13.17772827
	Dec     -35.054783
	Dist    28.04
	AppMagn 8.73
	Class  "K3V"
	MassSol 0.75
	RadSol  0.76
	Teff    4819
	FeH     0
	Age     2.19
}

Star	"HD 114613/HIP 64408"
{
	RA      13.200885
	Dec     -37.80302
	Dist    20.48
	AppMagn 4.85
	Class  "G4IV"
	MassSol 1.36
	Teff    5729
	FeH     0.18
}

Star	"HD 114762/HIP 64426"
{
	RA      13.20527778
	Dec     17.5169444
	Dist    39.46
	AppMagn 7.3
	Class  "F9V"
	MassSol 0.84
	RadSol  1.24
	Teff    5934
	FeH    -0.71
	Age     11.8
}

Star	"HD 114783/HIP 64457"
{
	RA      13.21194445
	Dec     -2.265
	Dist    20.4
	AppMagn 7.57
	Class  "K0"
	MassSol 0.92
	RadSol  0.78
	Teff    5105
	FeH     0.33
	Age     3.7
}

Star	"HD 11506/HIP 8770"
{
	RA      1.880703867
	Dec     -19.506975
	Dist    51.7
	AppMagn 7.51
	Class  "G0V"
	MassSol 1.24
	RadSol  1.33
	Teff    6055
	FeH     0.29
	Age     5.4
}

Star	"HD 116029/HIP 65117"
{
	RA      13.3443176
	Dec     24.648699
	Dist    110.62
	AppMagn 7.871
	Class  "K0"
	MassSol 1.58
	RadSol  4.6
	Teff    4951
	FeH     0.18
	Age     2.7
}

Star	"HD 117207/HIP 65808"
{
	RA      13.4891978
	Dec     -35.570995
	Dist    33.01
	AppMagn 7.247
	Class  "G8IV"
	MassSol 1.07
	RadSol  1.09
	Teff    5432
	FeH     0.27
	Age     6.68
}

Star	"HD 117253/HIP 65891"
{
	RA      13.50702007
	Dec     -58.664356
	Dist    136
	AppMagn 6.75
	Class  "K0III"
	MassSol 2.5
	RadSol  8.93
	Teff    5000
	FeH     0.16
}

Star	"HD 11755/HIP 9242"
{
	RA      1.980579733
	Dec     73.152382
	Dist    231.5
	AppMagn 6.87
	Class  "G5"
	MassSol 0.9
	RadSol  27.3
	Teff    4312.5
	FeH    -0.74
	Age     10.2
}

Star	"HD 117618/HIP 66047"
{
	RA      13.54027778
	Dec     -47.2711111
	Dist    38
	AppMagn 7.18
	Class  "G2V"
	MassSol 1.05
	RadSol  1.19
	Teff    5861
	FeH     0.04
	Age     3.88
}

Star	"HD 118203/HIP 66192"
{
	RA      13.56722222
	Dec     53.7283333
	Dist    88.6
	AppMagn 8.05
	Class  "K0"
	MassSol 1.23
	Teff    5600
	FeH     0.1
	Age     4.6
}

Star	"HD 11964/HIP 9094"
{
	RA      1.9525
	Dec     -10.2422222
	Dist    33.98
	AppMagn 6.42
	Class  "G5"
	MassSol 1.125
	RadSol  2.18
	Teff    5248
	FeH     0.17
	Age     9.56
}

Star	"HD 11977/HIP 8928"
{
	RA      1.915555553
	Dec     -67.6472222
	Dist    66.5
	AppMagn 4.7
	Class  "G8.5III"
	MassSol 1.91
	RadSol  13
	Teff    4975
	FeH    -0.21
	Age     1.25
}

Star	"HD 120084/HIP 66903"
{
	RA      13.71444667
	Dec     78.0617
	Dist    97.7
	AppMagn 5.91
	Class  "G7III"
	MassSol 2.39
	RadSol  9.12
	Teff    4892
	FeH     0.09
}

Star	"HD 121056/HIP 67851"
{
	RA      13.8977946
	Dec     -35.314362
	Dist    66
	AppMagn 6.17
	Class  "K0III"
	MassSol 1.63
	RadSol  5.92
	Teff    4890
	FeH     0
}

Star	"HD 121504/HIP 68162"
{
	RA      13.9547882
	Dec     -56.040043
	Dist    44.37
	AppMagn 7.517
	Class  "G2V"
	MassSol 1.18
	Teff    6075
	FeH     0.16
	Age     1.62
}

Star	"HD 122430"
{
	RA      14.03944445
	Dec     -27.4297222
	Dist    135
	AppMagn 5.48
	Class  "K3III"
	MassSol 1.39
	RadSol  22.9
	Teff    4300
	FeH    -0.05
	Age     3.11
}

Star	"HD 122562"
{
	RA      14.03916667
	Dec     20.88138892
	Dist    53.8
	AppMagn 7.69
	Class  "G5"
	MassSol 1.13
	Teff    4958
	FeH     0.31
}

Star	"HD 12484/HIP 9519"
{
	RA      2.040758267
	Dec     2.815859
	Dist    51.1
	AppMagn 8.17
	Class  "F8"
	MassSol 1.01
	Teff    5920
	FeH     0.05
}

Star	"HD 125595/HIP 70170"
{
	RA      14.3564402
	Dec     -40.393948
	Dist    27.45
	AppMagn 9
	Class  "K3V"
	MassSol 0.756
	Teff    4908
	FeH     0.02
	Age     3.53
}

Star	"HD 125612/HIP 70123"
{
	RA      14.34819847
	Dec     -17.481522
	Dist    52.83
	AppMagn 8.317
	Class  "G3V"
	MassSol 1.1
	RadSol  1.05
	Teff    5897
	FeH     0.24
	Age     2.1
}

Star	"HD 12648/HIP 10800"
{
	RA      2.316576867
	Dec     85.736153
	Dist    158.4
	AppMagn 6.98
	Class  "G5"
	MassSol 1.2
	RadSol  9.2
	Teff    4835.8
	FeH    -0.57
	Age     4.5
}

Star	"HD 126525"
{
	RA      14.45916667
	Dec     -51.9330556
	Dist    38.1
	AppMagn 7.85
	Class  "G4V"
}

Star	"HD 12661/HIP 9683"
{
	RA      2.076111113
	Dec     25.4141667
	Dist    37.16
	AppMagn 7.44
	Class  "G6V"
	MassSol 1.07
	RadSol  1.12
	Teff    5742
	FeH     0.29
	Age     7.05
}

Star	"HD 126614/HIP 70623"
{
	RA      14.44666667
	Dec     -5.1777778
	Dist    72.4
	AppMagn 8.81
	Class  "K0"
	MassSol 1.145
	RadSol  1.09
	Teff    5585
	FeH     0.56
	Age     7.2
}

Star	"HD 128311/HIP 71395"
{
	RA      14.60015567
	Dec     9.746518
	Dist    16.6
	AppMagn 7.51
	Class  "K0V"
	MassSol 0.83
	RadSol  0.76
	Teff    4965
	FeH     0.08
	Age     0.39
}

Star	"HD 128356"
{
	RA      14.61805556
	Dec     -25.80250002
	Dist    26.03
	AppMagn 8.29
	Class  "K3V"
	MassSol 0.65
	RadSol  0.85
	Teff    4875
	FeH     0.17
	Age     10
}

Star	"HD 129445/HIP 72203"
{
	RA      14.7675
	Dec     -68.7625
	Dist    67.61
	AppMagn 8.8
	Class  "G8V"
	MassSol 0.99
	FeH     0.25
}

Star	"HD 130322/HIP 72339"
{
	RA      14.79242453
	Dec     -0.281476
	Dist    29.76
	AppMagn 8.031
	Class  "K0V"
	MassSol 0.92
	RadSol  0.85
	Teff    5387
	FeH    -0.02
	Age     0.35
}

Star	"HD 131496/HIP 72845"
{
	RA      14.8897298
	Dec     18.235401
	Dist    121.36
	AppMagn 7.799
	Class  "K0"
	MassSol 1.61
	RadSol  4.6
	Teff    4927
	FeH     0.25
	Age     2.7
}

Star	"HD 131664/HIP 73408"
{
	RA      15.0016876
	Dec     -73.535339
	Dist    57.21
	AppMagn 8.128
	Class  "G3V"
}

Star	"HD 13189/HIP 10085"
{
	RA      2.161158733
	Dec     32.316437
	Dist    300.3
	AppMagn 7.556
	Class  "K2"
	MassSol 4.5
	RadSol  50.39
}

Star	"HD 132406/HIP 73146"
{
	RA      14.9485138
	Dec     53.382168
	Dist    70.97
	AppMagn 8.467
	Class  "G0"
	MassSol 1.09
	Teff    5885
	FeH     0.18
	Age     6.4
}

Star	"HD 134060"
{
	RA      15.17916667
	Dec     -61.4222222
	Dist    24.2
	AppMagn 6.29
	Class  "G0V"
}

Star	"HD 134113"
{
	RA      15.12972222
	Dec     8.87972225
	Dist    71.9
	AppMagn 8.26
	Class  "F9V"
	MassSol 0.81
	Teff    5782
	FeH    -0.74
}

Star	"HD 134606"
{
	RA      15.25416667
	Dec     -70.5197222
	Dist    26.5
	AppMagn 6.85
	Class  "G6IV"
}

Star	"HD 134987/HIP 74500"
{
	RA      15.22462973
	Dec     -25.309347
	Dist    25.65
	AppMagn 6.45
	Class  "G5V"
	MassSol 1.07
	RadSol  1.25
	Teff    5740
	FeH     0.25
	Age     9.7
}

Star	"HD 135760/HIP 74890"
{
	RA      15.30481367
	Dec     -41.42057
	Dist    91.49
	AppMagn 7.05
	Class  "K1III"
	MassSol 1.74
	RadSol  5.77
	Teff    4850
	FeH     0.2
}

Star	"HD 136352"
{
	RA      15.36333333
	Dec     -48.3175
	Dist    14.8
	AppMagn 5.65
	Class  "G4V"
}

Star	"HD 136418/HIP 74961"
{
	RA      15.3183838
	Dec     41.733208
	Dist    106.38
	AppMagn 7.879
	Class  "G5"
	MassSol 1.33
	RadSol  3.4
	Teff    5071
	FeH    -0.07
	Age     4
}

Star	"HD 137388/HIP 76351"
{
	RA      15.59442447
	Dec     -80.20459
	Dist    38.45
	AppMagn 8.696
	Class  "K2IV"
	MassSol 0.86
	RadSol  0.82
	Teff    5240
	FeH     0.18
	Age     6.45
}

Star	"HD 13808"
{
	RA      2.211944447
	Dec     -53.7438889
	Dist    28.6
	AppMagn 8.38
	Class  "K2V"
}

Star	"HD 13908/HIP 10743"
{
	RA      2.304166667
	Dec     65.59444446
	Dist    71.2
	AppMagn 7.51
	Class  "F8V"
	MassSol 1.29
	RadSol  1.67
	Teff    6255
	FeH     0.01
	Age     2.9
}

Star	"HD 13931/HIP 10626"
{
	RA      2.27972222
	Dec     43.7730556
	Dist    44.2
	AppMagn 7.61
	Class  "G0"
	MassSol 1.02
	RadSol  1.23
	Teff    5829
	FeH     0.03
	Age     8.4
}

Star	"HD 139357/HIP 76311"
{
	RA      15.58783267
	Dec     53.922142
	Dist    121.36
	AppMagn 5.964
	Class  "K0"
	MassSol 1.35
	RadSol  11.47
	Teff    4700
	FeH    -0.13
	Age     3.07
}

Star	"HD 14067/HIP 10657"
{
	RA      2.286233267
	Dec     23.76782827
	Dist    163.4
	AppMagn 6.51
	Class  "G9III"
	MassSol 2.4
	RadSol  12.4
	Teff    4815
	FeH    -0.1
	Age     0.69
}

Star	"HD 141399/HIP 77301"
{
	RA      15.7816152
	Dec     46.986263
	Dist    36.2
	AppMagn 7.2
	Class  "K0"
	MassSol 1.07
	RadSol  1.46
	Teff    5600
	FeH     0.35
}

Star	"HD 141937/HIP 77740"
{
	RA      15.87154133
	Dec     -18.436066
	Dist    33.46
	AppMagn 7.25
	Class  "G2V"
	MassSol 1.1
	RadSol  1.06
	Teff    5925
	FeH     0.11
	Age     2.55
}

Star	"HD 142/HIP 522"
{
	RA      0.1053265333
	Dec     -49.075191
	Dist    25.64
	AppMagn 5.7
	Class  "G1IV"
	MassSol 1.23
	RadSol  1.47
	Teff    6245
	FeH     0.09
	Age     5.93
}

Star	"HD 142022 A/HIP 79242"
{
	RA      16.17083333
	Dec     -84.2313889
	Dist    35.87
	AppMagn 7.7
	Class  "K0V"
	MassSol 0.99
	RadSol  0.705
	Teff    5382
	FeH     0.19
	Age     13.3
}

Star	"HD 142245/HIP 77783"
{
	RA      15.8822998
	Dec     15.430708
	Dist    106.38
	AppMagn 7.452
	Class  "K0"
	MassSol 1.69
	RadSol  5.2
	Teff    4878
	FeH     0.23
	Age     2.3
}

Star	"HD 142415/HIP 78169"
{
	RA      15.9613312
	Dec     -60.200256
	Dist    34.57
	AppMagn 7.327
	Class  "G1V"
	MassSol 1.09
	RadSol  1.03
	Teff    5834
	FeH     0.21
	Age     1.49
}

Star	"HD 143105/HIP 77838"
{
	RA      15.89348853
	Dec     68.720116
	Dist    48.7
	AppMagn 6.75
	Class  "F5"
	MassSol 1.51
	Teff    6380
	FeH     0.15
}

Star	"HD 143361/HIP 78521"
{
	RA      16.03065187
	Dec     -44.434536
	Dist    59.35
	AppMagn 9.225
	Class  "G6V"
	MassSol 0.95
	FeH     0.29
}

Star	"HD 143567/HIP 78530"
{
	RA      16.03207093
	Dec     -21.980389
	Dist    156.7
	AppMagn 7.192
	Class  "B9V"
	MassSol 2.5
	Teff    10500
	Age     0.011
}

Star	"HD 145377/HIP 79346"
{
	RA      16.193457
	Dec     -27.078173
	Dist    55.19
	AppMagn 8.095
	Class  "G3V"
	MassSol 1.12
	RadSol  1.14
	Teff    6046
	FeH     0.12
	Age     1.3
}

Star	"HD 145457/HIP 79219"
{
	RA      16.16775413
	Dec     26.74275
	Dist    126.1
	AppMagn 6.566
	Class  "K0"
	MassSol 1.9
	RadSol  9.9
	Teff    4757
	FeH    -0.14
}

Star	"HD 145934"
{
	RA      16.2194092
	Dec     13.239476
	AppMagn 8.5
	Class  "K0"
	MassSol 1.75
	RadSol  5.38
}

Star	"HD 1461/HIP 1499"
{
	RA      0.3116298667
	Dec     -8.053001
	Dist    23.44
	AppMagn 6.47
	Class  "G0V"
	MassSol 1.02
	RadSol  1.11
	Teff    5765
	FeH     0.19
	Age     6.3
}

Star	"HD 146389/WASP-38"
{
	RA      16.26398927
	Dec     10.032566
	Dist    110
	AppMagn 9.447
	Class  "F8"
	MassSol 1.2
	RadSol  1.33
	Teff    6150
	FeH    -0.12
	Age     5
}

Star	"HD 147018/HIP 80250"
{
	RA      16.38333333
	Dec     -61.6888889
	Dist    42.96
	AppMagn 8.3
	Class  "G9V"
	MassSol 0.927
	Teff    5441
	FeH     0.1
	Age     6.36
}

Star	"HD 147506/HIP 80076/HAT-P-2"
{
	RA      16.3434326
	Dec     41.048084
	Dist    135.32
	AppMagn 8.71
	Class  "F8"
	MassSol 1.36
	RadSol  1.64
	Teff    6290
	FeH     0.14
	Age     2.7
}

Star	"HD 147513/HIP 80337"
{
	RA      16.40035807
	Dec     -39.192982
	Dist    12.87
	AppMagn 5.39
	Class  "G4V"
	MassSol 0.92
	RadSol  1
	Teff    5701
	FeH    -0.03
	Age     0.65
}

Star	"HD 147873"
{
	RA      16.42916667
	Dec     -33.45361112
	Dist    104.93
	AppMagn 7.96
	Class  "G1V"
	MassSol 1.38
	RadSol  2.29
	Teff    5972
	FeH    -0.03
	Age     4
}

Star	"HD 148156/HIP 80680"
{
	RA      16.47146707
	Dec     -46.317623
	Dist    53.05
	AppMagn 7.689
	Class  "G1V"
	MassSol 1.22
	RadSol  1.21
	Teff    6308
	FeH     0.29
}

Star	"HD 148427/HIP 80687"
{
	RA      16.47448627
	Dec     -13.39964
	Dist    59.28
	AppMagn 6.895
	Class  "K0III"
	MassSol 1.45
	RadSol  3.22
	Teff    5052
	FeH     0.154
	Age     2.5
}

Star	"HD 149143/HIP 81022"
{
	RA      16.54751387
	Dec     2.084832
	Dist    63.49
	AppMagn 7.893
	Class  "G3V"
	MassSol 1.1
	Teff    5730
	FeH     0.2
	Age     7.6
}

Star	"HD 1502/HIP 1547"
{
	RA      0.3214073333
	Dec     14.054755
	Dist    167.5
	AppMagn 8.342
	Class  "K0"
	MassSol 1.61
	RadSol  4.5
	Teff    5049
	FeH     0.09
	Age     2.4
}

Star	"HD 150433"
{
	RA      16.68555555
	Dec     -2.8572222
	Dist    29.6
	AppMagn 7.22
	Class  "G0"
}

Star	"HD 150706/HIP 80902"
{
	RA      16.52155153
	Dec     79.789772
	Dist    27.23
	AppMagn 7.02
	Class  "G0V"
	MassSol 1.17
	RadSol  0.96
	Teff    5961
	FeH    -0.01
	Age     1.17
}

Star	"HD 15082/HIP 11397/WASP-33"
{
	RA      2.4475
	Dec     37.5505556
	Dist    116
	AppMagn 8.3
	Class  "A5"
	MassSol 1.495
	RadSol  1.444
	Teff    7400
	FeH     0.1
}

Star	"HD 152079/HIP 82632"
{
	RA      16.89166667
	Dec     -46.3308333
	Dist    85.17
	AppMagn 9.18
	Class  "G6V"
	MassSol 1.023
	FeH     0.16
}

Star	"HD 152581/HIP 82651"
{
	RA      16.89543967
	Dec     11.973746
	Dist    182.82
	AppMagn 8.347
	Class  "K0"
	MassSol 0.927
	RadSol  4.8
	Teff    5155
	FeH    -0.46
	Age     12
}

Star	"HD 153950/HIP 83547"
{
	RA      17.07524213
	Dec     -43.309769
	Dist    51.87
	AppMagn 7.39
	Class  "F8V"
	MassSol 1.12
	RadSol  1.34
	Teff    6076
	FeH    -0.01
	Age     4.3
}

Star	"HD 154088"
{
	RA      17.07444445
	Dec     -28.5827778
	Dist    17.8
	AppMagn 6.58
	Class  "K0IV"
}

Star	"HD 154345/HIP 83389"
{
	RA      17.04344587
	Dec     47.081882
	Dist    18.06
	AppMagn 6.76
	Class  "G8V"
	MassSol 0.88
	Teff    5468
	FeH    -0.105
	Age     4.92
}

Star	"HD 154672/HIP 83983"
{
	RA      17.16805555
	Dec     -56.4491667
	Dist    65.8
	AppMagn 8.22
	Class  "G3IV"
	MassSol 1.06
	RadSol  1.27
	Teff    5714
	FeH     0.26
	Age     9.28
}

Star	"HD 154857/HIP 84069"
{
	RA      17.1877014
	Dec     -56.680798
	Dist    68.54
	AppMagn 7.238
	Class  "G5V"
	MassSol 1.72
	RadSol  1.76
	Teff    5605
	FeH    -0.2
	Age     5.6
}

Star	"HD 155233/HIP 84056"
{
	RA      17.18454587
	Dec     -20.65457
	Dist    75.13
	AppMagn 6.81
	Class  "K1III"
	MassSol 1.69
	RadSol  5.03
	Teff    4960
	FeH     0.08
}

Star	"HD 155358/HIP 83949"
{
	RA      17.15961507
	Dec     33.355854
	Dist    43.4
	AppMagn 7.27
	Class  "G0"
	MassSol 0.92
	Teff    5900
	FeH    -0.51
	Age     10.7
}

Star	"HD 156279/HIP 84171"
{
	RA      17.20644533
	Dec     63.352093
	Dist    35.37
	AppMagn 8.077
	Class  "K0"
	MassSol 0.93
	Teff    5453
	FeH     0.14
	Age     4
}

Star	"HD 156411/HIP 84787"
{
	RA      17.3309448
	Dec     -48.54932
	Dist    55.1
	AppMagn 6.673
	Class  "F8IV"
	MassSol 1.25
	RadSol  2.16
	Teff    5900
	FeH    -0.12
}

Star	"HD 156668/HIP 84607"
{
	RA      17.29458007
	Dec     29.227226
	Dist    24.05
	AppMagn 8.42
	Class  "K3V"
	MassSol 0.772
	RadSol  0.72
	Teff    4850
	FeH     0.05
	Age     8.6
}

Star	"HD 156846/HIP 84856"
{
	RA      17.34286293
	Dec     -19.333746
	Dist    49
	AppMagn 6.52
	Class  "G1V"
}

Star	"HD 157172"
{
	RA      17.37638889
	Dec     -19.6161111
	Dist    31.9
	AppMagn 7.86
	Class  "G8.5V"
}

Star	"HD 158038/HIP 85294"
{
	RA      17.42928673
	Dec     27.303341
	Dist    114.15
	AppMagn 7.464
	Class  "K0"
	MassSol 1.65
	RadSol  4.8
	Teff    4897
	FeH     0.28
	Age     2.5
}

Star	"HD 159243/HIP 85911"
{
	RA      17.55611111
	Dec     5.700833348
	Dist    69.2
	AppMagn 8.65
	Class  "G0V"
	MassSol 1.125
	RadSol  1.12
	Teff    6123
	FeH     0.05
	Age     1.25
}

Star	"HD 159868/HIP 86375"
{
	RA      17.65
	Dec     -43.1455556
	Dist    52.7
	AppMagn 7.24
	Class  "G5V"
	MassSol 1.09
	Teff    5395
	FeH     0
	Age     8.1
}

Star	"HD 1605/HIP 1640"
{
	RA      0.3422222229
	Dec     30.97472225
	Dist    84.6
	AppMagn 7.52
	Class  "K1IV"
	MassSol 1.31
	RadSol  3.8
	Teff    4757
	FeH     0.21
	Age     4.59
}

Star	"HD 160508"
{
	RA      17.65361111
	Dec     26.75750002
	Dist    92.3
	AppMagn 8.11
	Class  "F8V"
	MassSol 1.25
	Teff    6212
	FeH     0.01
}

Star	"HD 16141/HIP 12048"
{
	RA      2.588869
	Dec     -3.560602
	Dist    35.91
	AppMagn 6.78
	Class  "G5IV"
	MassSol 1.01
	RadSol  1
	Teff    5533
	FeH     0.02
	Age     7.76
}

Star	"HD 16175/HIP 12191"
{
	RA      2.61722222
	Dec     42.0625
	Dist    59.8
	AppMagn 7.28
	Class  "G0"
	MassSol 1.35
	RadSol  1.87
	Teff    6022
	FeH     0.37
	Age     5.3
}

Star	"HD 162020/HIP 87330"
{
	RA      17.84398807
	Dec     -40.318348
	Dist    31.26
	AppMagn 9.12
	Class  "K2V"
	MassSol 0.75
	RadSol  0.71
	Teff    4830
	FeH     0.01
	Age     0.76
}

Star	"HD 163607/HIP 87601"
{
	RA      17.89444445
	Dec     56.3919444
	Dist    69
	AppMagn 8.15
	Class  "G5IV"
	MassSol 1.09
	RadSol  1.63
	Teff    5543
	FeH     0.21
	Age     8.6
}

Star	"HD 16417/HIP 12186"
{
	RA      2.616388887
	Dec     -34.5780556
	Dist    25.5
	AppMagn 5.78
	Class  "G1V"
	MassSol 1.18
	Teff    5936
	FeH     0.19
	Age     4.3
}

Star	"HD 164509/HIP 88268"
{
	RA      18.0253418
	Dec     0.104556
	Dist    51.81
	AppMagn 8.103
	Class  "G5V"
	MassSol 1.13
	RadSol  1.06
	Teff    5922
	FeH     0.21
	Age     1.1
}

Star	"HD 164595/HIP 88194"
{
	RA      18.0108032
	Dec     29.571922
	Dist    28.93
	AppMagn 7.1
	Class  "G2V"
	MassSol 0.99
	Teff    5790
	FeH    -0.04
}

Star	"HD 164604/HIP 88414"
{
	RA      18.05194445
	Dec     -28.5605556
	Dist    38
	AppMagn 9.7
	Class  "K2V"
	MassSol 0.8
	FeH    -0.18
}

Star	"HD 164922/HIP 88348"
{
	RA      18.04190673
	Dec     26.313002
	Dist    21.92
	AppMagn 7.01
	Class  "G9V"
	MassSol 0.94
	RadSol  0.9
	Teff    5385
	FeH     0.17
	Age     13.4
}

Star	"HD 165155"
{
	RA      18.09916667
	Dec     -29.91722224
	Dist    64.98
	AppMagn 9.36
	Class  "G8V"
	MassSol 1.02
	RadSol  0.95
	Teff    5426
	FeH     0.09
	Age     11
}

Star	"HD 1666/HIP 1666"
{
	RA      0.3477777789
	Dec     -19.93111114
	Dist    110.6
	AppMagn 8.17
	Class  "F7V"
	MassSol 1.5
	RadSol  1.93
	Teff    6317
	FeH     0.37
	Age     1.76
}

Star	"HD 166724/HIP 89354"
{
	RA      18.2332438
	Dec     -42.575375
	Dist    42.99
	AppMagn 9.344
	Class  "K0IV"
	MassSol 0.81
	Teff    5127
	FeH    -0.09
}

Star	"HD 167042/HIP 89047"
{
	RA      18.17545573
	Dec     54.286552
	Dist    50
	AppMagn 5.94
	Class  "K1IV"
	MassSol 1.5
	RadSol  4.5
	Teff    4943
	FeH     0
	Age     2.2
}

Star	"HD 168443/HIP 89844"
{
	RA      18.33444445
	Dec     -9.5927778
	Dist    37.38
	AppMagn 6.92
	Class  "G5"
	MassSol 0.995
	RadSol  1.51
	Teff    5591
	FeH     0.04
	Age     9.8
}

Star	"HD 168746/HIP 90004"
{
	RA      18.36382853
	Dec     -11.922684
	Dist    43.12
	AppMagn 7.946
	Class  "G5"
	MassSol 0.93
	RadSol  1.12
	Teff    5564
	FeH     0.078
	Age     3.75
}

Star	"HD 1690/HIP 1692"
{
	RA      0.3536998
	Dec     -8.281169
	Dist    7.01
	AppMagn 9.173
	Class  "K1III"
	MassSol 1.09
	RadSol  16.7
	Teff    4393
	FeH    -0.32
	Age     6.7
}

Star	"HD 169142"
{
	RA      18.40827361
	Dec     -29.78050808
	Dist    145
	AppMagn 8.16
	Class  "A7V"
	MassSol 1.65
	RadSol  1.6
	Teff    7650
	Age     12
}

Star	"HD 169830/HIP 90485"
{
	RA      18.46374513
	Dec     -29.816866
	Dist    36.32
	AppMagn 5.902
	Class  "F8V"
	MassSol 1.4
	RadSol  1.84
	Teff    6299
	FeH     0.21
	Age     4.95
}

Star	"HD 170469/HIP 90593"
{
	RA      18.48638307
	Dec     11.695502
	Dist    64.98
	AppMagn 8.21
	Class  "G5IV"
	MassSol 1.14
	RadSol  1.22
	Teff    5810
	FeH     0.3
	Age     6.7
}

Star	"HD 17051/HIP 12653/HR 810"
{
	RA      2.709296133
	Dec     -50.800293
	Dist    17.24
	AppMagn 5.41
	Class  "G0V"
	MassSol 1.11
	RadSol  1.85
	Teff    5997
	FeH     0.25
	Age     3.6
}

Star	"HD 17092"
{
	RA      2.7728102
	Dec     49.653075
	Dist    109
	AppMagn 7.73
	Class  "K0III"
	MassSol 2.3
	Teff    4650
	FeH     0.22
}

Star	"HD 171028"
{
	RA      18.5376368
	Dec     6.945749
	Dist    90
	AppMagn 8.31
	Class  "G0"
	MassSol 0.99
	RadSol  1.95
	Teff    5663
	FeH    -0.49
	Age     8
}

Star	"HD 171238/HIP 91085"
{
	RA      18.57888889
	Dec     -28.0722222
	Dist    50.28
	AppMagn 8.66
	Class  "K0V"
	MassSol 0.943
	Teff    5467
	FeH     0.17
	Age     4.92
}

Star	"HD 17156/HIP 13192"
{
	RA      2.828888887
	Dec     71.7533333
	Dist    78.24
	AppMagn 8.17
	Class  "G0"
	MassSol 1.275
	RadSol  1.508
	Teff    6079
	FeH     0.24
	Age     3.38
}

Star	"HD 173416/HIP 91852"
{
	RA      18.7266968
	Dec     36.556606
	Dist    134.95
	AppMagn 6.057
	Class  "G8"
	MassSol 2
	RadSol  13.5
	Teff    4683
	FeH    -0.22
}

Star	"HD 175167/HIP 93281"
{
	RA      19.00027778
	Dec     -69.9441667
	Dist    67.02
	AppMagn 9.18
	Class  "G5V"
	MassSol 1.102
	FeH     0.19
}

Star	"HD 175541/HIP 92895"
{
	RA      18.92802327
	Dec     4.265325
	Dist    127.55
	AppMagn 8.03
	Class  "G8IV"
	MassSol 1.65
	RadSol  3.8
	Teff    5060
	FeH    -0.07
	Age     1.9
}

Star	"HD 175607/HIP 93373"
{
	RA      19.01805556
	Dec     -66.19277779
	Dist    45.27
	AppMagn 8.6
	Class  "G6V"
	MassSol 0.71
	RadSol  0.71
	Teff    5392
	FeH    -0.62
	Age     10.32
}

Star	"HD 177830/HIP 93746"
{
	RA      19.0891032
	Dec     25.92066
	Dist    59.03
	AppMagn 7.177
	Class  "K0"
	MassSol 1.47
	RadSol  2.99
	Teff    4948
	FeH     0.55
	Age     4.4
}

Star	"HD 179079/HIP 94256"
{
	RA      19.18606367
	Dec     -2.638385
	Dist    63.69
	AppMagn 7.95
	Class  "G5IV"
	MassSol 1.15
	RadSol  1.6
	Teff    5684
	FeH     0.25
}

Star	"HD 179949/HIP 94645"
{
	RA      19.25916667
	Dec     -24.1791667
	Dist    27
	AppMagn 6.25
	Class  "F8V"
	MassSol 1.28
	RadSol  1.19
	Teff    6260
	FeH     0.22
	Age     2.05
}

Star	"HD 180314/HIP 94576"
{
	RA      19.24727987
	Dec     31.86035
	Dist    131.75
	AppMagn 6.608
	Class  "K0"
	MassSol 2.6
	RadSol  9.2
	Teff    4917
	FeH     0.2
}

Star	"HD 180902/HIP 94951"
{
	RA      19.32158613
	Dec     -23.558155
	Dist    114.55
	AppMagn 7.778
	Class  "K0III"
	MassSol 1.52
	RadSol  4.1
	Teff    5030
	FeH     0.04
	Age     2.8
}

Star	"HD 181342/HIP 95124"
{
	RA      19.35117593
	Dec     -23.619572
	Dist    110.62
	AppMagn 7.55
	Class  "K0III"
	MassSol 1.89
	RadSol  5.12
	Teff    5040
	FeH     0.2
	Age     1.8
}

Star	"HD 181433/HIP 95467"
{
	RA      19.41944445
	Dec     -66.4688889
	Dist    26.15
	AppMagn 8.38
	Class  "K3IV"
	MassSol 0.78
	Teff    4962
	FeH     0.33
}

Star	"HD 181720/HIP 95262"
{
	RA      19.38138889
	Dec     -32.9191667
	Dist    56
	AppMagn 7.86
	Class  "G1V"
	MassSol 0.92
	RadSol  1.39
	Teff    5781
	FeH    -0.53
}

Star	"HD 183263/HIP 95740"
{
	RA      19.4734924
	Dec     8.358054
	Dist    52.83
	AppMagn 7.861
	Class  "G2IV"
	MassSol 1.17
	RadSol  1.21
	Teff    5936
	FeH     0.3
	Age     8.1
}

Star	"HD 185269/HIP 96507"
{
	RA      19.619928
	Dec     28.499865
	Dist    47.37
	AppMagn 6.67
	Class  "G0IV"
	MassSol 1.28
	RadSol  1.88
	Teff    5980
	FeH     0.11
	Age     4.2
}

Star	"HD 186641/HIP 97233"
{
	RA      19.76138889
	Dec     -0.696666691
	Dist    106.5
	AppMagn 7.34
	Class  "K0"
	MassSol 1.93
	RadSol  5.34
	Teff    5020
	FeH     0.29
}

Star	"HD 187085/HIP 97546"
{
	RA      19.82610273
	Dec     -37.780552
	Dist    44.98
	AppMagn 7.214
	Class  "G0V"
	MassSol 1.22
	Teff    6075
	FeH     0.05
	Age     3.3
}

Star	"HD 187123/HIP 97336"
{
	RA      19.7828084
	Dec     34.419525
	Dist    47.92
	AppMagn 7.832
	Class  "G3V"
	MassSol 1
	RadSol  1.17
	Teff    5830
	FeH     0.16
	Age     5.33
}

Star	"HD 18742/HIP 13993"
{
	RA      3.002960467
	Dec     -20.802603
	Dist    127.88
	AppMagn 7.814
	Class  "G8IV"
	MassSol 1.6
	RadSol  4.9
	Teff    5048
	FeH    -0.04
	Age     2.3
}

Star	"HD 188015/HIP 97769"
{
	RA      19.86792807
	Dec     28.100376
	Dist    52.63
	AppMagn 8.234
	Class  "G5IV"
	MassSol 1.09
	RadSol  1.1
	Teff    5746
	FeH     0.289
	Age     6.2
}

Star	"HD 189567"
{
	RA      20.0925
	Dec     -67.3208333
	Dist    17.7
	AppMagn 6.07
	Class  "G2V"
}

Star	"HD 189733/HIP 98505"
{
	RA      20.01194445
	Dec     22.7108333
	Dist    19.3
	AppMagn 7.67
	Class  "K2"
	MassSol 0.8
	RadSol  0.805
	Teff    4875
	FeH    -0.03
	Age     0.6
}

Star	"HD 190360/HIP 98767"
{
	RA      20.06027778
	Dec     29.8966667
	Dist    15.89
	AppMagn 5.71
	Class  "G6IV"
	MassSol 1.04
	RadSol  1.2
	Teff    5588
	FeH     0.24
	Age     12.11
}

Star	"HD 190647/HIP 99115"
{
	RA      20.12222222
	Dec     -35.5386111
	Dist    54.2
	AppMagn 7.78
	Class  "G5"
	MassSol 1.1
	Teff    5628
	FeH     0.24
	Age     2
}

Star	"HD 190984/HIP 99496"
{
	RA      20.19186607
	Dec     -64.620468
	Dist    189.39
	AppMagn 8.76
	Class  "F8V"
	MassSol 0.91
	RadSol  1.53
	Teff    5988
	FeH    -0.48
}

Star	"HD 191806"
{
	RA      20.15786111
	Dec     52.27633057
	AppMagn 8.093
	MassSol 1.14
	Teff    6010
	FeH     0.3
	Age     2.9
}

Star	"HD 192263/HIP 99711"
{
	RA      20.23333333
	Dec     -0.8669444
	Dist    19.9
	AppMagn 7.79
	Class  "K2V"
	MassSol 0.81
	RadSol  0.75
	Teff    4965
	FeH    -0.2
	Age     0.57
}

Star	"HD 192699/HIP 99894"
{
	RA      20.26833493
	Dec     4.580795
	Dist    67.39
	AppMagn 6.44
	Class  "G8IV"
	MassSol 1.68
	RadSol  3.9
	Teff    5220
	FeH    -0.15
	Age     1.8
}

Star	"HD 193334/WASP-68"
{
	RA      20.33971967
	Dec     -19.31468
	AppMagn 10.7
	Class  "G0"
	MassSol 1.24
	RadSol  1.69
	Teff    5911
	FeH     0.22
}

Star	"HD 19467"
{
	RA      3.121944445
	Dec     -13.76166669
	Dist    30.86
	AppMagn 7
	Class  "G3V"
	MassSol 0.95
	RadSol  1.15
	Teff    5680
	FeH    -0.15
	Age     7.2
}

Star	"HD 196050/HIP 101806"
{
	RA      20.63103027
	Dec     -60.634483
	Dist    46.93
	AppMagn 7.5
	Class  "G4V"
	MassSol 1.15
	RadSol  1.29
	Teff    5892
	FeH     0.229
	Age     3.17
}

Star	"HD 197037/HIP 101948"
{
	RA      20.65915527
	Dec     42.24855
	Dist    32.83
	AppMagn 6.813
	Class  "G0"
	MassSol 1.11
	Teff    6150
	FeH    -0.2
	Age     1.9
}

Star	"HD 197286/WASP-7"
{
	RA      20.73617353
	Dec     -39.225273
	Dist    140
	AppMagn 9.51
	Class  "F5V"
	MassSol 1.28
	RadSol  1.43
	Teff    6400
	FeH     0
	Age     2.4
}

Star	"HD 19994/HIP 14954"
{
	RA      3.212899
	Dec     -1.196101
	Dist    22.38
	AppMagn 5.06
	Class  "G0V"
	MassSol 1.37
	RadSol  1.93
	Teff    6190
	FeH     0.24
	Age     8.91
}

Star	"HD 20003"
{
	RA      3.12722222
	Dec     -72.3219444
	Dist    43.8
	AppMagn 8.37
	Class  "G8V"
}

Star	"HD 200964/HIP 104202"
{
	RA      21.11111111
	Dec     3.8030556
	Dist    68.4
	AppMagn 6.64
	Class  "K0"
	MassSol 1.44
	RadSol  4.3
	Teff    5164
	FeH    -0.15
	Age     3
}

Star	"HD 202206/HIP 104903"
{
	RA      21.24937947
	Dec     -20.789209
	Dist    46.34
	AppMagn 8.08
	Class  "G6V"
	MassSol 1.15
	RadSol  1.02
	Teff    5765
	FeH     0.37
	Age     2.04
}

Star	"HD 202678/WASP-73"
{
	RA      21.33
	Dec     -57.8511111
	AppMagn 10.5
	Class  "F9"
	MassSol 1.34
	RadSol  2.07
	Teff    6030
	FeH     0.14
}

Star	"HD 203030/HIP 105232"
{
	RA      21.31617227
	Dec     26.230545
	Dist    40.85
	AppMagn 8.425
	Class  "G8V"
}

Star	"HD 20367"
{
	RA      3.294444447
	Dec     31.1269444
	Dist    27
	AppMagn 6.41
	Class  "G0"
	MassSol 1.04
	RadSol  1.18
	Teff    6128
	FeH     0.1
	Age     0.87
}

Star	"HD 2039/HIP 1931"
{
	RA      0.4055555533
	Dec     -56.65
	Dist    89.8
	AppMagn 9.01
	Class  "G3V"
	MassSol 0.98
	RadSol  1.21
	Teff    5947
	FeH     0.1
	Age     5.28
}

Star	"HD 203949/HIP 105854"
{
	RA      21.43968707
	Dec     -37.82943
	Dist    84.6
	AppMagn 5.64
	Class  "K2III"
	MassSol 2.1
	Teff    4780
	FeH     0.31
}

Star	"HD 204313/HIP 106006"
{
	RA      21.4700582
	Dec     -21.726255
	Dist    47.3
	AppMagn 7.99
	Class  "G5V"
	MassSol 1.02
	Teff    5776
	FeH     0.18
	Age     3.38
}

Star	"HD 204941/HIP 106353"
{
	RA      21.53986407
	Dec     -20.957422
	Dist    26.95
	AppMagn 8.45
	Class  "K1V"
	MassSol 0.74
	RadSol  0.72
	Teff    5056
	FeH    -0.19
	Age     6.67
}

Star	"HD 205739/HIP 106824"
{
	RA      21.63566893
	Dec     -31.737484
	Dist    90.33
	AppMagn 8.56
	Class  "F7V"
	MassSol 1.22
	RadSol  1.33
	Teff    6176
	FeH     0.19
	Age     2.84
}

Star	"HD 206610/HIP 107251"
{
	RA      21.723584
	Dec     -7.408253
	Dist    170.07
	AppMagn 8.346
	Class  "K0III"
	MassSol 1.56
	RadSol  6.1
	Teff    4874
	FeH     0.14
	Age     3
}

Star	"HD 207229/HIP 107773"
{
	RA      21.83336793
	Dec     -64.71254
	Dist    106
	AppMagn 5.62
	Class  "K1III"
	MassSol 2.42
	RadSol  11.6
	Teff    4945
	FeH     0.03
}

Star	"HD 207832/HIP 107985"
{
	RA      21.8767456
	Dec     -26.02656
	Dist    55.31
	AppMagn 8.786
	Class  "G5V"
	MassSol 0.94
	RadSol  0.9
	Teff    5710
	FeH     0.06
	Age     4.5
}

Star	"HD 20794/HIP 15510"
{
	RA      3.332125067
	Dec     -43.069782
	Dist    6.06
	AppMagn 4.27
	Class  "G8V"
	MassSol 0.7
	RadSol  0.9
	Teff    5401
	FeH    -0.4
	Age     14
}

Star	"HD 208487/HIP 108375"
{
	RA      21.95551353
	Dec     -37.763622
	Dist    44
	AppMagn 7.471
	Class  "G2V"
	MassSol 1.13
	RadSol  1.15
	Teff    6067
	FeH     0.022
	Age     3.88
}

Star	"HD 208527/HIP 108296"
{
	RA      21.93999633
	Dec     21.239859
	Dist    352.11
	AppMagn 6.4
	Class  "M1III"
	MassSol 1.6
	RadSol  51.1
	Teff    4035
	FeH    -0.09
	Age     2
}

Star	"HD 20868/HIP 15578"
{
	RA      3.34527778
	Dec     -33.73
	Dist    48.9
	AppMagn 9.92
	Class  "K1V"
	MassSol 0.78
	RadSol  0.79
	Teff    4795
	FeH     0.04
	Age     4.5
}

Star	"HD 209458/HIP 108859"
{
	RA      22.05277778
	Dec     18.8844444
	Dist    47
	AppMagn 7.65
	Class  "G0V"
	MassSol 1.148
	RadSol  1.203
	Teff    6092
	FeH     0.02
	Age     4
}

Star	"HD 210277/HIP 109378"
{
	RA      22.15829673
	Dec     -7.548654
	Dist    21.29
	AppMagn 6.53
	Class  "G8V"
	MassSol 1.01
	RadSol  1.1
	Teff    5555
	FeH     0.214
	Age     6.93
}

Star	"HD 210702/HIP 109577"
{
	RA      22.19759113
	Dec     16.04055
	Dist    55.93
	AppMagn 5.93
	Class  "K1III"
	MassSol 1.68
	RadSol  5.1
	Teff    4967
	FeH     0.12
	Age     1.4
}

Star	"HD 211847"
{
	RA      22.34888889
	Dec     -41.43000002
	Dist    50.6
	AppMagn 8.78
	Class  "G5V"
	MassSol 0.94
	Teff    5715
	FeH    -0.08
	Age     3
}

Star	"HD 212301/HIP 110852"
{
	RA      22.45833333
	Dec     -77.7177778
	Dist    52.7
	AppMagn 7.77
	Class  "F8V"
	MassSol 1.05
	Teff    5998
	FeH     0.18
	Age     5.9
}

Star	"HD 212771/HIP 110813"
{
	RA      22.45085247
	Dec     -17.263659
	Dist    121.8
	AppMagn 7.596
	Class  "G8IV"
	MassSol 1.15
	RadSol  5
	Teff    5121
	FeH    -0.21
	Age     6
}

Star	"HD 213240/HIP 111143"
{
	RA      22.5167684
	Dec     -49.43327
	Dist    40.75
	AppMagn 6.814
	Class  "G0V"
	MassSol 1.22
	RadSol  1.5
	Teff    5975
	FeH     0.16
	Age     5.11
}

Star	"HD 214823"
{
	RA      22.67219444
	Dec     31.78759169
	AppMagn 8.078
	Class  "G0V"
	MassSol 1.22
	Teff    6215
	FeH     0.17
	Age     2.7
}

Star	"HD 215152"
{
	RA      22.7225
	Dec     -6.4008333
	Dist    21.5
	AppMagn 8.13
	Class  "K0"
}

Star	"HD 215456"
{
	RA      22.76888889
	Dec     -48.9677778
	Dist    38
	AppMagn 6.63
	Class  "G0.5V"
}

Star	"HD 215497/HIP 112441"
{
	RA      22.7768758
	Dec     -56.599533
	Dist    43.53
	AppMagn 8.96
	Class  "K3V"
	MassSol 0.87
	Teff    5113
	FeH     0.23
	Age     7
}

Star	"HD 216435/HIP 113044"
{
	RA      22.89361111
	Dec     -48.5980556
	Dist    33.3
	AppMagn 6.03
	Class  "G0V"
	MassSol 1.3
	RadSol  2
	Teff    5767
	FeH     0.244
	Age     5.27
}

Star	"HD 216437/HIP 113137"
{
	RA      22.910968
	Dec     -70.073708
	Dist    26.52
	AppMagn 6.05
	Class  "G2IV"
	MassSol 1.15
	RadSol  1.1
	Teff    5636
	FeH     0.21
	Age     12.96
}

Star	"HD 216536"
{
	RA      22.59666667
	Dec     44.4777778
	AppMagn 9.23
	Class  "K0"
	MassSol 1.36
	RadSol  12.5
	Teff    4639
	FeH    -0.17
	Age     3.8
}

Star	"HD 216770/HIP 113238"
{
	RA      22.93158567
	Dec     -26.658764
	Dist    37.89
	AppMagn 8.094
	Class  "K0V"
	MassSol 0.9
	RadSol  1
	Teff    5248
	FeH     0.23
	Age     3.6
}

Star	"HD 21693"
{
	RA      3.453333333
	Dec     -58.3236111
	Dist    32.4
	AppMagn 7.94
	Class  "G9IV"
}

Star	"HD 217107/HIP 113421"
{
	RA      22.97098387
	Dec     -2.395385
	Dist    19.72
	AppMagn 6.16
	Class  "G8IV"
	MassSol 1.02
	RadSol  1.08
	Teff    5646
	FeH     0.37
	Age     7.32
}

Star	"HD 217786/HIP 113834"
{
	RA      23.05227867
	Dec     -0.429622
	Dist    54.92
	AppMagn 7.779
	Class  "F8V"
	MassSol 1.02
	RadSol  1.27
	Teff    5966
	FeH    -0.135
	Age     7.6
}

Star	"HD 218396/HIP 114189/HR 8799"
{
	RA      23.12472222
	Dec     21.1341667
	Dist    39.4
	AppMagn 5.96
	Class  "A5V"
	MassSol 1.56
	RadSol  1.5
	FeH    -0.47
	Age     0.06
}

Star	"HD 218566/HIP 114322"
{
	RA      23.15298053
	Dec     -2.260742
	Dist    29.94
	AppMagn 8.63
	Class  "K3V"
	MassSol 0.85
	RadSol  0.86
	Teff    4820
	FeH     0.38
	Age     8.5
}

Star	"HD 219077/HIP 114699"
{
	RA      23.23516233
	Dec     -62.700005
	Dist    29.2
	AppMagn 6.12
	Class  "G8V"
	MassSol 1.05
	RadSol  1.91
	Teff    5362
	FeH    -0.13
	Age     8.9
}

Star	"HD 219134/HIP 114622"
{
	RA      23.22138889
	Dec     57.16833334
	Dist    6.55
	AppMagn 5.57
	Class  "K3V"
	MassSol 0.79
	RadSol  0.778
	Teff    4699
	FeH     0.11
}

Star	"HD 219415"
{
	RA      23.24828493
	Dec     56.730328
	AppMagn 8.94
	Class  "K0III"
	MassSol 1
	RadSol  2.9
	Teff    4820
	FeH    -0.04
}

Star	"HD 219828/HIP 115100"
{
	RA      23.31305555
	Dec     18.6458333
	Dist    81.1
	AppMagn 8.04
	Class  "G0IV"
	MassSol 1.24
	RadSol  1.7
	Teff    5891
	FeH     0.19
	Age     5.8
}

Star	"HD 220074/HIP 115218"
{
	RA      23.33722
	Dec     61.97
	Dist    290.2
	AppMagn 6.4
	Class  "M2III"
	MassSol 1.2
	RadSol  49.67
	Teff    3935
	FeH    -0.25
	Age     4.5
}

Star	"HD 220689/HIP 115662"
{
	RA      23.43138889
	Dec     -20.6161111
	Dist    44.6
	AppMagn 7.77
	Class  "G3V"
	MassSol 1.04
	RadSol  1.07
	Teff    5921
	FeH     0
}

Star	"HD 220773/HIP 115697"
{
	RA      23.4409566
	Dec     8.643845
	Dist    48.43
	AppMagn 7.096
	Class  "G0"
	MassSol 1.16
	Teff    5940
	FeH     0.09
	Age     4.4
}

Star	"HD 220842/HIP 115714"
{
	RA      23.4436076
	Dec     56.886528
	Dist    62.5
	AppMagn 7.99
	Class  "F8"
	MassSol 1.13
	Teff    5960
	FeH    -0.17
}

Star	"HD 221287/HIP 116084"
{
	RA      23.52222222
	Dec     -58.2097222
	Dist    52.9
	AppMagn 7.82
	Class  "F7V"
	MassSol 1.25
	Teff    6304
	FeH     0.03
	Age     1.3
}

Star	"HD 221585"
{
	RA      23.54833333
	Dec     63.15548056
	AppMagn 7.474
	Class  "G8IV"
	MassSol 1.19
	Teff    5620
	FeH     0.29
	Age     6.2
}

Star	"HD 222155/HIP 116616"
{
	RA      23.6334188
	Dec     48.996521
	Dist    50.45
	AppMagn 7.114
	Class  "G2V"
	MassSol 1.13
	RadSol  1.67
	Teff    5765
	FeH    -0.11
	Age     8.2
}

Star	"HD 222582/HIP 116906"
{
	RA      23.6975
	Dec     -5.9855556
	Dist    42
	AppMagn 7.7
	Class  "G5"
	MassSol 0.99
	RadSol  1.15
	Teff    5662
	FeH    -0.0229
	Age     6.16
}

Star	"HD 224538"
{
	RA      23.98111111
	Dec     -61.58666668
	Dist    77.76
	AppMagn 8.06
	Class  "F9V"
	MassSol 1.54
	RadSol  1.34
	Teff    6097
	FeH     0.27
	Age     2
}

Star	"HD 224693/HIP 118319"
{
	RA      23.99828693
	Dec     -22.428114
	Dist    94.07
	AppMagn 8.216
	Class  "G2IV"
	MassSol 1.33
	RadSol  1.7
	Teff    6037
	FeH     0.343
	Age     2
}

Star	"HD 22781/HIP 17187"
{
	RA      3.680423733
	Dec     31.82629
	Dist    31.79
	AppMagn 8.766
	Class  "K0"
	MassSol 0.75
	Teff    5027
	FeH    -0.37
	Age     4.75
}

Star	"HD 23079/HIP 17096"
{
	RA      3.661944447
	Dec     -52.9158333
	Dist    34.8
	AppMagn 7.1
	Class  "G0V"
	MassSol 1.1
	RadSol  1.13
	Teff    5848
	FeH    -0.24
	Age     6.53
}

Star	"HD 23127/HIP 17054"
{
	RA      3.656666667
	Dec     -60.0777778
	Dist    89.1
	AppMagn 8.58
	Class  "G2V"
	MassSol 1.13
	Teff    5927
	FeH     0.34
	Age     7.1
}

Star	"HD 231701/HIP 96078"
{
	RA      19.53444445
	Dec     16.4741667
	Dist    108.4
	AppMagn 8.97
	Class  "F8V"
	MassSol 1.14
	RadSol  1.35
	Teff    6208
	FeH     0.07
	Age     4.9
}

Star	"HD 233604"
{
	RA      9.163558933
	Dec     53.56823
	AppMagn 10.406
	Class  "K5"
	MassSol 1.5
	RadSol  10.9
	Teff    4791
	FeH    -0.36
	Age     2.4
}

Star	"HD 233731/HAT-P-22"
{
	RA      10.37888889
	Dec     50.1283333
	Dist    82
	AppMagn 9.73
	Class  "G5"
	MassSol 0.916
	RadSol  1.04
	Teff    5302
	FeH     0.24
	Age     12.4
}

Star	"HD 23596/HIP 17747"
{
	RA      3.800103733
	Dec     40.530636
	Dist    51.97
	AppMagn 7.244
	Class  "F8"
	MassSol 1.27
	RadSol  2.09
	Teff    5888
	FeH     0.32
	Age     6.89
}

Star	"HD 240210"
{
	RA      23.17472222
	Dec     57.0294444
	Dist    143
	AppMagn 8.33
	Class  "K3III"
	MassSol 1.25
	Teff    4290
	FeH    -0.18
}

Star	"HD 240237/HIP 114840"
{
	RA      23.26172893
	Dec     58.04324
	Dist    307.69
	AppMagn 8.19
	Class  "K2III"
	MassSol 1.69
	RadSol  32
	Teff    4361
	FeH    -0.26
}

Star	"HD 24040/HIP 17960"
{
	RA      3.839713267
	Dec     17.476366
	Dist    46.51
	AppMagn 7.493
	Class  "G0V"
	MassSol 1.18
	Teff    5853
	FeH     0.206
	Age     6.68
}

Star	"HD 24064/HIP 18451"
{
	RA      3.943416067
	Dec     74.080032
	Dist    264.4
	AppMagn 6.75
	Class  "K0"
	MassSol 1
	RadSol  38
	Teff    4052.5
	FeH    -0.49
	Age     9
}

Star	"HD 25171/HIP 18387"
{
	RA      3.930400067
	Dec     -65.186676
	Dist    56.05
	AppMagn 7.778
	Class  "F8V"
	MassSol 1.09
	RadSol  1.18
	Teff    6160
	FeH    -0.11
	Age     2
}

Star	"HD 262389/HIP 32209/HAT-P-56"
{
	RA      6.756666667
	Dec     27.25222223
	Dist    310.5
	AppMagn 10.91
	Class  "F"
	MassSol 1.296
	RadSol  1.428
	Teff    6566
	FeH    -0.077
	Age     2.01
}

Star	"HD 27631/HIP 20199"
{
	RA      4.3292974
	Dec     -41.960266
	Dist    44.54
	AppMagn 8.243
	Class  "G3IV"
	MassSol 0.94
	RadSol  1
	Teff    5737
	FeH    -0.12
}

Star	"HD 27894/HIP 20277"
{
	RA      4.346402
	Dec     -59.410835
	Dist    42.37
	AppMagn 9.349
	Class  "K2V"
	MassSol 0.8
	Teff    4875
	FeH     0.3
	Age     3.9
}

Star	"HD 28185/HIP 20723"
{
	RA      4.440644867
	Dec     -10.550821
	Dist    39.56
	AppMagn 7.81
	Class  "G5V"
	MassSol 1.24
	RadSol  1.03
	Teff    5482
	FeH     0.24
	Age     5.36
}

Star	"HD 28254/HIP 20606"
{
	RA      4.414084867
	Dec     -50.622192
	Dist    54.7
	AppMagn 7.684
	Class  "G1IV"
	MassSol 1.06
	RadSol  1.48
	Teff    5664
	FeH     0.06
}

Star	"HD 283668"
{
	RA      4.464722223
	Dec     24.44472224
	Dist    42.3
	AppMagn 9.44
	MassSol 0.68
	Teff    4845
	FeH    -0.75
}

Star	"HD 284149"
{
	RA      4.110833334
	Dec     20.30305556
	Dist    108.2
	AppMagn 9.63
	Class  "F8"
	MassSol 1.14
	Teff    6040
	Age     0.025
}

Star	"HD 285507/HIP 19207"
{
	RA      4.116944444
	Dec     15.33500001
	Dist    41.3
	AppMagn 10.5
	Class  "K5"
	MassSol 0.734
	RadSol  0.656
	Teff    4503
	FeH     0.13
	Age     0.625
}

Star	"HD 28678/HIP 21109"
{
	RA      4.523737067
	Dec     4.575287
	Dist    168.92
	AppMagn 8.44
	Class  "G8IV"
	MassSol 1.74
	RadSol  6.2
	Teff    5076
	FeH    -0.11
	Age     1.8
}

Star	"HD 290327/HIP 25191"
{
	RA      5.3893234
	Dec     -2.277619
	Dist    56.7
	AppMagn 8.99
	Class  "G8V"
	MassSol 0.9
	RadSol  1
	Teff    5552
	FeH    -0.11
}

Star	"HD 2952/HIP 2611"
{
	RA      0.55278
	Dec     54.895
	Dist    115.2
	AppMagn 5.93
	Class  "K0III"
	MassSol 2.54
	RadSol  12.02
	Teff    4844
	FeH     0
}

Star	"HD 30177/HIP 21850"
{
	RA      4.698333333
	Dec     -58.0205556
	Dist    55
	AppMagn 8.41
	Class  "G8V"
	MassSol 0.95
	RadSol  1.12
	Teff    5320
	FeH     0.19
	Age     8.4
}

Star	"HD 30562/HIP 22336"
{
	RA      4.810106933
	Dec     -5.674045
	Dist    26.5
	AppMagn 5.78
	Class  "F8V"
	MassSol 1.23
	RadSol  1.53
	Teff    5994
	FeH     0.29
	Age     4
}

Star	"HD 30669/HIP 22320"
{
	RA      4.808055556
	Dec     -28.41916668
	Dist    57
	AppMagn 9.11
	Class  "G9V"
	MassSol 0.92
	RadSol  0.91
	Teff    5400
	FeH     0.13
	Age     4.8
}

Star	"HD 30856/HIP 22491"
{
	RA      4.838295
	Dec     -24.368839
	Dist    121.07
	AppMagn 7.911
	Class  "K0III"
	MassSol 1.35
	RadSol  4.2
	Teff    4982
	FeH    -0.06
	Age     3.8
}

Star	"HD 31253/HIP 22826"
{
	RA      4.912126133
	Dec     12.352201
	Dist    53.82
	AppMagn 7.133
	Class  "F8"
	MassSol 1.23
	RadSol  1.71
	Teff    5960
	FeH     0.16
	Age     3
}

Star	"HD 31527"
{
	RA      4.92722222
	Dec     -23.2419444
	Dist    38.6
	AppMagn 7.48
	Class  "G0V"
}

Star	"HD 32518/HIP 24003"
{
	RA      5.1602
	Dec     69.639404
	Dist    117.37
	AppMagn 6.421
	Class  "K1III"
	MassSol 1.13
	RadSol  10.22
	Teff    4580
	FeH    -0.15
	Age     5.83
}

Star	"HD 32963/HIP 23884"
{
	RA      5.132156867
	Dec     26.327963
	Dist    35.24
	AppMagn 7.6
	Class  "G5"
	MassSol 0.94
	Teff    5727
	FeH     0.11
	Age     4.99
}

Star	"HD 330075/HIP 77517"
{
	RA      15.82694445
	Dec     -49.9633333
	Dist    50.2
	AppMagn 9.36
	Class  "G5"
	MassSol 0.95
	Teff    6295
	FeH     0.03
	Age     6.21
}

Star	"HD 33142/HIP 23844"
{
	RA      5.126539133
	Dec     -13.98648
	Dist    136.8
	AppMagn 7.956
	Class  "K0III"
	MassSol 1.48
	RadSol  4.2
	Teff    5052
	FeH     0.05
	Age     3
}

Star	"HD 33283/HIP 23889"
{
	RA      5.133611113
	Dec     -26.7972222
	Dist    86
	AppMagn 8.05
	Class  "G3V"
	MassSol 1.24
	RadSol  1.2
	Teff    5995
	FeH     0.366
	Age     3.2
}

Star	"HD 33564/HIP 25110"
{
	RA      5.375981133
	Dec     79.231148
	Dist    20.98
	AppMagn 5.08
	Class  "F7V"
	MassSol 1.25
	RadSol  1.1
	Teff    6250
	FeH    -0.12
	Age     3
}

Star	"HD 33643/HIP 24323/KELT-7"
{
	RA      5.219722222
	Dec     33.31805556
	Dist    129
	AppMagn 8.54
	Class  "F"
	MassSol 1.535
	RadSol  1.732
	Teff    6789
	FeH     0.139
	Age     1.3
}

Star	"HD 33844/HIP 24275"
{
	RA      5.210028067
	Dec     -14.951111
	Dist    100.9
	AppMagn 7.286
	Class  "K0III"
	MassSol 1.78
	RadSol  5.29
	Teff    4861
	FeH     0.27
	Age     2.1
}

Star	"HD 340099/HAT-P-49"
{
	RA      20.36277778
	Dec     26.6927778
	Dist    322
	AppMagn 10.21
	Class  "A5"
	MassSol 1.543
	RadSol  1.833
	Teff    6820
	FeH     0.074
	Age     1.5
}

Star	"HD 343246/KELT-8"
{
	RA      18.88703407
	Dec     24.12738
	Dist    236
	AppMagn 10.833
	Class  "G2V"
	MassSol 1.21
	RadSol  1.67
	Teff    5754
	FeH     0.272
	Age     5.4
}

Star	"HD 34445/HIP 24681"
{
	RA      5.29472222
	Dec     7.3533333
	Dist    46.5
	AppMagn 7.31
	Class  "G0"
	MassSol 1.07
	RadSol  1.38
	Teff    5836
	FeH     0.14
	Age     8.5
}

Star	"HD 351766/HAT-P-34"
{
	RA      20.21302287
	Dec     18.104868
	Dist    257
	AppMagn 10.16
	MassSol 1.39
	RadSol  1.53
	Teff    6442
	FeH     0.08
	Age     1.7
}

Star	"HD 35759/HIP 25883"
{
	RA      5.5259308
	Dec     64.318779
	Dist    72.5
	AppMagn 7.74
	Class  "G0"
	MassSol 1.15
	Teff    6060
	FeH     0.04
}

Star	"HD 3651/HIP 3093"
{
	RA      0.6558333333
	Dec     21.2502778
	Dist    11
	AppMagn 5.8
	Class  "K0V"
	MassSol 0.79
	RadSol  0.947
	Teff    5173
	FeH     0.05
	Age     5.13
}

Star	"HD 37124/HIP 26381"
{
	RA      5.61722222
	Dec     20.7305556
	Dist    33
	AppMagn 7.68
	Class  "G4V"
	MassSol 0.83
	RadSol  0.82
	Teff    5610
	FeH    -0.442
	Age     3.33
}

Star	"HD 37605/HIP 26664"
{
	RA      5.667147333
	Dec     6.060579
	Dist    42.88
	AppMagn 8.661
	Class  "K0V"
	MassSol 1
	RadSol  0.9
	Teff    5448
	FeH     0.336
	Age     7
}

Star	"HD 38283/HIP 26380"
{
	RA      5.6172272
	Dec     -73.699341
	Dist    37.78
	AppMagn 6.696
	Class  "G0V"
	MassSol 1.08
	Teff    5998
	FeH    -0.12
	Age     5.4
}

Star	"HD 38529/HIP 27253"
{
	RA      5.776364667
	Dec     1.168193
	Dist    42.43
	AppMagn 5.95
	Class  "G8III"
	MassSol 1.48
	RadSol  2.44
	Teff    5697
	FeH     0.27
	Age     3.28
}

Star	"HD 38801/HIP 27384"
{
	RA      5.799771133
	Dec     -8.3277
	Dist    99.4
	AppMagn 8.269
	Class  "G8IV"
	MassSol 1.36
	RadSol  2.53
	Teff    5222
	FeH     0.26
	Age     4.67
}

Star	"HD 38858"
{
	RA      5.80972222
	Dec     -4.0947222
	Dist    15.2
	AppMagn 5.97
	Class  "G4V"
}

Star	"HD 39091/HIP 26394"
{
	RA      5.619414267
	Dec     -80.469124
	Dist    18.21
	AppMagn 5.65
	Class  "G1V"
	MassSol 1.1
	RadSol  2.1
	Teff    5888
	FeH     0.09
	Age     3.83
}

Star	"HD 39194"
{
	RA      5.74222222
	Dec     -70.1436111
	Dist    25.9
	AppMagn 8.08
	Class  "K0V"
}

Star	"HD 39392"
{
	RA      5.888611112
	Dec     22.07222223
	Dist    94.2
	AppMagn 8.38
	Class  "F8"
	MassSol 1.08
	Teff    5951
	FeH     0.32
}

Star	"HD 40307/HIP 27887"
{
	RA      5.901111113
	Dec     -60.0233333
	Dist    12.8
	AppMagn 7.17
	Class  "K2.5V"
	MassSol 0.77
	Teff    4977
	FeH    -0.31
}

Star	"HD 40979/HIP 28767"
{
	RA      6.07472222
	Dec     44.2602778
	Dist    33.3
	AppMagn 6.74
	Class  "F8V"
	MassSol 1.1
	RadSol  1.21
	Teff    6205
	FeH     0.194
	Age     1.48
}

Star	"HD 4113/HIP 3391"
{
	RA      0.7201657333
	Dec     -37.982632
	Dist    44.05
	AppMagn 7.881
	Class  "G5"
	MassSol 0.99
	Teff    5688
	FeH     0.2
	Age     4.8
}

Star	"HD 4203/HIP 3502"
{
	RA      0.74472222
	Dec     20.4488889
	Dist    77.5
	AppMagn 8.68
	Class  "G5"
	MassSol 1.13
	RadSol  1.33
	Teff    5701
	FeH     0.453
	Age     9.41
}

Star	"HD 4208/HIP 3479"
{
	RA      0.7405555533
	Dec     -26.5155556
	Dist    33.9
	AppMagn 7.79
	Class  "G5V"
	MassSol 0.87
	RadSol  0.85
	Teff    5571
	FeH    -0.284
	Age     4.47
}

Star	"HD 4308/HIP 3497"
{
	RA      0.7441666667
	Dec     -65.6494444
	Dist    21.9
	AppMagn 6.54
	Class  "G5V"
	MassSol 0.85
	RadSol  0.92
	Teff    5597
	FeH    -0.34
	Age     7.1
}

Star	"HD 4313/HIP 3574"
{
	RA      0.7612106667
	Dec     7.845021
	Dist    131.41
	AppMagn 7.822
	Class  "G5"
	MassSol 1.72
	RadSol  4.9
	Teff    5035
	FeH     0.14
	Age     2
}

Star	"HD 43197/HIP 29550"
{
	RA      6.226572667
	Dec     -29.89727
	Dist    56.3
	AppMagn 8.98
	Class  "G8V"
	MassSol 0.96
	RadSol  1
	Teff    5508
	FeH     0.4
}

Star	"HD 43691/HIP 30057"
{
	RA      6.326299
	Dec     41.092304
	Dist    93.2
	AppMagn 8.03
	Class  "G0IV"
	MassSol 1.38
	Teff    6200
	FeH     0.28
	Age     2.8
}

Star	"HD 44219/HIP 30114"
{
	RA      6.3373118
	Dec     -10.725009
	Dist    50.4
	AppMagn 7.69
	Class  "G2V"
	MassSol 1
	RadSol  1.32
	Teff    5752
	FeH     0.03
}

Star	"HD 45184"
{
	RA      6.41222222
	Dec     -28.78
	Dist    21.9
	AppMagn 6.37
	Class  "G1.5V"
}

Star	"HD 45350/HIP 30860"
{
	RA      6.479364
	Dec     38.962963
	Dist    48.95
	AppMagn 7.885
	Class  "G5V"
	MassSol 1.02
	RadSol  1.27
	Teff    5616
	FeH     0.29
	Age     5.59
}

Star	"HD 45364/HIP 30579"
{
	RA      6.4273544
	Dec     -31.480953
	Dist    32.58
	AppMagn 8.062
	Class  "K0V"
	MassSol 0.82
	Teff    5434
	FeH    -0.17
}

Star	"HD 45652/HIP 30905"
{
	RA      6.486997467
	Dec     10.933891
	Dist    36.14
	AppMagn 8.127
	Class  "G9V"
	MassSol 0.83
	Teff    5312
	FeH     0.29
}

Star	"HD 47186/HIP 31540"
{
	RA      6.602440867
	Dec     -27.622297
	Dist    37.84
	AppMagn 7.626
	Class  "G5V"
	MassSol 0.99
	Teff    5675
	FeH     0.23
}

Star	"HD 4732/HIP 3834/HR 228"
{
	RA      0.8205412836
	Dec     -24.13667289
	Dist    56.5
	AppMagn 5.9
	Class  "K0IV"
	MassSol 1.74
	RadSol  5.4
	Teff    4959
	FeH     0.01
}

Star	"HD 47366"
{
	RA      6.628055556
	Dec     -12.98500002
	Dist    80
	AppMagn 6.11
	Class  "K1III"
	MassSol 1.81
	RadSol  7.3
	Teff    4866
	FeH    -0.02
	Age     1.61
}

Star	"HD 47536/HIP 31688"
{
	RA      6.629894
	Dec     -32.339733
	Dist    121.36
	AppMagn 5.25
	Class  "K1III"
	MassSol 0.91
	RadSol  22.39
	Teff    4424
	FeH     0.69
	Age     9.33
}

Star	"HD 48265/HIP 31895"
{
	RA      6.667146333
	Dec     -48.541954
	Dist    87.41
	AppMagn 8.05
	Class  "G5V"
	MassSol 1.22
	RadSol  1.82
	Teff    5789
	FeH     0.38
}

Star	"HD 49674/HIP 32916"
{
	RA      6.858476733
	Dec     40.867756
	Dist    40.73
	AppMagn 8.1
	Class  "G5V"
	MassSol 1.07
	RadSol  0.94
	Teff    5482
	FeH     0.25
	Age     2.38
}

Star	"HD 50499/HIP 32970"
{
	RA      6.8672292
	Dec     -33.915562
	Dist    47.26
	AppMagn 7.195
	Class  "G1V"
	MassSol 1.27
	RadSol  1.38
	Teff    5902
	FeH     0.23
	Age     6
}

Star	"HD 50554/HIP 33212"
{
	RA      6.911895733
	Dec     24.245558
	Dist    31.03
	AppMagn 6.84
	Class  "F8"
	MassSol 1.04
	RadSol  1.11
	Teff    5902
	FeH    -0.07
	Age     4.58
}

Star	"HD 51608"
{
	RA      6.914166667
	Dec     -55.2594444
	Dist    34.8
	AppMagn 8.17
	Class  "K0IV"
}

Star	"HD 52265/HIP 33719"
{
	RA      7.00501
	Dec     -5.367162
	Dist    28.07
	AppMagn 6.3
	Class  "G0V"
	MassSol 1.18
	RadSol  1.1
	Teff    6060
	FeH     0.21
	Age     4.88
}

Star	"HD 5319/HIP 4297"
{
	RA      0.9170557333
	Dec     0.789553
	Dist    114
	AppMagn 8.05
	Class  "K3IV"
	MassSol 1.51
	RadSol  3.85
	Teff    4958
	FeH     0.15
	Age     2.4
}

Star	"HD 5583"
{
	RA      0.9658333346
	Dec     34.98555558
	Dist    221
	AppMagn 7.6
	Class  "K0"
	MassSol 1.01
	RadSol  9.09
	Teff    4830
	FeH    -0.5
	Age     7.4
}

Star	"HD 5608/HIP 4552"
{
	RA      0.9706164
	Dec     33.950886
	Dist    58.17
	AppMagn 5.98
	Class  "K0"
	MassSol 1.55
	RadSol  5.5
	Teff    4854
	FeH     0.06
}

Star	"HD 564/HIP 801"
{
	RA      0.1646727333
	Dec     -50.267822
	Dist    53.6
	AppMagn 8.29
	Class  "G3V"
	MassSol 0.96
	RadSol  1.01
	Teff    5902
	FeH    -0.2
	Age     5.5
}

Star	"HD 5891/HIP 4715"
{
	RA      1.00922
	Dec     20.292484
	Dist    150.6
	AppMagn 8.114
	Class  "G5"
	MassSol 1.91
	RadSol  8.7
	Teff    4907
	FeH    -0.02
	Age     1.5
}

Star	"HD 59686"
{
	RA      7.53
	Dec     17.0858333
	Dist    92
	AppMagn 5.45
	Class  "K2III"
	RadSol  11.62
}

Star	"HD 60532/HIP 36795"
{
	RA      7.567550133
	Dec     -22.296066
	Dist    25.7
	AppMagn 4.45
	Class  "F6IV"
	MassSol 1.44
	Teff    6095
	FeH    -0.42
	Age     2.7
}

Star	"HD 63454/HIP 37284"
{
	RA      7.656069933
	Dec     -78.278969
	Dist    35.8
	AppMagn 9.37
	Class  "K4V"
	MassSol 0.84
	RadSol  1.05
	Teff    4840
	FeH     0.06
	Age     1
}

Star	"HD 63765/HIP 38041"
{
	RA      7.797144067
	Dec     -54.264145
	Dist    32.62
	AppMagn 8.104
	Class  "G6IV"
	MassSol 0.865
	Teff    5432
	FeH    -0.16
	Age     4.77
}

Star	"HD 6434/HIP 5054"
{
	RA      1.077819667
	Dec     -39.488216
	Dist    40.32
	AppMagn 7.71
	Class  "G3V"
	MassSol 0.89
	RadSol  1.14
	Teff    5690
	FeH    -0.48
	Age     3.8
}

Star	"HD 65216/HIP 38558"
{
	RA      7.89472222
	Dec     -63.6472222
	Dist    34.3
	AppMagn 7.98
	Class  "G5V"
	MassSol 0.92
	Teff    5666
	FeH    -0.12
}

Star	"HD 66141/HIP 39311"
{
	RA      8.0377604
	Dec     2.334571
	Dist    80.06
	AppMagn 4.38
	Class  "K2III"
	MassSol 1.1
	RadSol  21.4
	Teff    4323
	FeH    -0.323
	Age     6.84
}

Star	"HD 66428/HIP 39417"
{
	RA      8.057962533
	Dec     -1.162709
	Dist    55.04
	AppMagn 8.258
	Class  "G5V"
	MassSol 1.1
	Teff    5752
	FeH     0.31
	Age     5.56
}

Star	"HD 67087/HIP 39767"
{
	RA      8.127777779
	Dec     31.5513889
	Dist    88.8
	AppMagn 8.05
	Class  "F8V"
	MassSol 1.36
	RadSol  1.55
	Teff    6330
	FeH     0.25
	Age     1.45
}

Star	"HD 6718/HIP 5301"
{
	RA      1.130184067
	Dec     -8.233706
	Dist    54.9
	AppMagn 8.45
	Class  "G5V"
	MassSol 0.96
	RadSol  1.02
	Teff    5746
	FeH    -0.06
}

Star	"HD 68402"
{
	RA      8.090000001
	Dec     -74.41055557
	Dist    78
	AppMagn 9.11
	Class  "G5V"
	MassSol 1.12
	RadSol  1.02
	Teff    5950
	FeH     0.29
	Age     2
}

Star	"HD 68988/HIP 40687"
{
	RA      8.306111113
	Dec     61.4605556
	Dist    58
	AppMagn 8.21
	Class  "G0"
	MassSol 1.2
	RadSol  1.14
	Teff    5767
	FeH     0.24
	Age     6.78
}

Star	"HD 69830/HIP 40693"
{
	RA      8.3066518
	Dec     -12.632174
	Dist    12.58
	AppMagn 6
	Class  "K0V"
	MassSol 0.86
	RadSol  0.895
	Teff    5385
	FeH    -0.05
	Age     7
}

Star	"HD 70573"
{
	RA      8.380555553
	Dec     1.8594444
	Dist    45.7
	AppMagn 8.7
	Class  "G1.5V"
	MassSol 1
	Teff    5737
	FeH    -0.18
	Age     0.101
}

Star	"HD 70642/HIP 40952"
{
	RA      8.357815533
	Dec     -39.70541
	Dist    28.76
	AppMagn 7.18
	Class  "G5V"
	MassSol 1
	RadSol  0.84
	Teff    5670
	FeH     0.16
	Age     3.88
}

Star	"HD 7199/HIP 5529"
{
	RA      1.179784133
	Dec     -66.188164
	Dist    35.88
	AppMagn 8.027
	Class  "K0IV"
	MassSol 0.89
	RadSol  0.96
	Teff    5386
	FeH     0.28
	Age     6.79
}

Star	"HD 72659/HIP 42030"
{
	RA      8.567552667
	Dec     -1.568217
	Dist    51.4
	AppMagn 7.46
	Class  "G2V"
	MassSol 1.06
	RadSol  1.36
	Teff    5926
	FeH    -0.02
	Age     6.5
}

Star	"HD 72892"
{
	RA      8.58138889
	Dec     -14.45666668
	Dist    72.78
	AppMagn 8.83
	Class  "G5V"
	MassSol 1.02
	RadSol  1.22
	Teff    5688
	FeH     0.25
	Age     8
}

Star	"HD 73256/HIP 42214"
{
	RA      8.6063934
	Dec     -30.037626
	Dist    36.52
	AppMagn 8.08
	Class  "G9"
	MassSol 1.05
	RadSol  0.89
	Teff    5570
	FeH     0.29
	Age     0.83
}

Star	"HD 73267/HIP 42202"
{
	RA      8.604937733
	Dec     -34.45998
	Dist    54.91
	AppMagn 8.9
	Class  "G5V"
	MassSol 0.89
	RadSol  1.04
	Teff    5317
	FeH     0.03
	Age     7.4
}

Star	"HD 73526/HIP 42282"
{
	RA      8.621111113
	Dec     -41.3188889
	Dist    99
	AppMagn 9
	Class  "G6V"
	MassSol 1.08
	RadSol  1.49
	Teff    5590
	FeH     0.25
	Age     5.59
}

Star	"HD 73534/HIP 42446"
{
	RA      8.654389467
	Dec     12.960376
	Dist    81
	AppMagn 8.23
	Class  "G5IV"
	MassSol 1.23
	RadSol  2.39
	Teff    5041
	FeH     0.232
}

Star	"HD 74156/HIP 42723"
{
	RA      8.706944447
	Dec     4.5780556
	Dist    64.56
	AppMagn 7.62
	Class  "G1V"
	MassSol 1.24
	RadSol  1.64
	Teff    5960
	FeH     0.13
	Age     3.7
}

Star	"HD 7449/HIP 5806"
{
	RA      1.241388887
	Dec     -5.0475
	Dist    39
	AppMagn 7.5
	Class  "F8V"
	MassSol 1.05
	RadSol  1.01
	Teff    6024
	FeH    -0.11
	Age     2.1
}

Star	"HD 75289/HIP 43177"
{
	RA      8.7945526
	Dec     -41.736794
	Dist    28.94
	AppMagn 6.35
	Class  "G0"
	MassSol 1.21
	RadSol  1.25
	Teff    6095
	FeH     0.217
	Age     4.96
}

Star	"HD 75784/HIP 43569"
{
	RA      8.873316467
	Dec     13.233433
	Dist    68.7
	AppMagn 7.84
	Class  "K3IV"
	MassSol 1.41
	RadSol  3.3
	Teff    4917
	FeH     0.25
}

Star	"HD 75898/HIP 43674"
{
	RA      8.897445667
	Dec     33.056812
	Dist    80.58
	AppMagn 8.03
	Class  "G0V"
	MassSol 1.28
	RadSol  1.6
	Teff    6021
	FeH     0.27
	Age     3.8
}

Star	"HD 76700/HIP 43686"
{
	RA      8.898753867
	Dec     -66.800995
	Dist    59.7
	AppMagn 8.155
	Class  "G6V"
	MassSol 1
	RadSol  1.33
	Teff    5726
	FeH     0.14
	Age     4.51
}

Star	"HD 77065"
{
	RA      9.013055557
	Dec     21.45361112
	Dist    31.7
	AppMagn 8.8
	Class  "G5"
	MassSol 0.75
	Teff    4990
	FeH    -0.51
}

Star	"HD 77338/HIP 44291"
{
	RA      9.020137533
	Dec     -25.527061
	Dist    41.27
	AppMagn 8.591
	Class  "K0IV"
	MassSol 0.93
	RadSol  0.88
	Teff    5370
	FeH     0.35
	Age     3.97
}

Star	"HD 7924/HIP 6379"
{
	RA      1.366420867
	Dec     76.710281
	Dist    16.82
	AppMagn 7.185
	Class  "K0.5V"
	MassSol 0.83
	RadSol  0.78
	Teff    5075
	FeH    -0.15
}

Star	"HD 79498/HIP 45406"
{
	RA      9.252611267
	Dec     23.375549
	Dist    48.64
	AppMagn 8.02
	Class  "G5"
	MassSol 1.06
	Teff    5740
	FeH     0.24
	Age     2.7
}

Star	"HD 80606/HIP 45982"
{
	RA      9.376944447
	Dec     50.6036111
	Dist    58.4
	AppMagn 8.93
	Class  "G5"
	MassSol 0.98
	RadSol  0.98
	Teff    5645
	FeH     0.43
	Age     7.63
}

Star	"HD 81040/HIP 46076"
{
	RA      9.3964132
	Dec     20.364454
	Dist    32.56
	AppMagn 7.72
	Class  "G2V"
	MassSol 0.96
	RadSol  0.86
	Teff    5700
	FeH    -0.16
	Age     4.18
}

Star	"HD 82886/HIP 47087"
{
	RA      9.5958842
	Dec     34.780743
	Dist    112.23
	AppMagn 7.625
	Class  "G0"
	MassSol 1.06
	RadSol  4.8
	Teff    5112
	FeH    -0.31
	Age     7
}

Star	"HD 82943/HIP 47007"
{
	RA      9.580555553
	Dec     -12.1294444
	Dist    27.46
	AppMagn 6.54
	Class  "G0"
	MassSol 1.18
	RadSol  1.12
	Teff    5874
	FeH     0.32
	Age     3.08
}

Star	"HD 83443/HIP 47202"
{
	RA      9.61972222
	Dec     -43.2719444
	Dist    43.54
	AppMagn 8.23
	Class  "K0V"
	MassSol 0.9
	RadSol  1.04
	Teff    5460
	FeH     0.35
	Age     2.94
}

Star	"HD 8535/HIP 6511"
{
	RA      1.3936766
	Dec     -41.269802
	Dist    52.5
	AppMagn 7.7
	Class  "G0V"
	MassSol 1.13
	RadSol  1.19
	Teff    6136
	FeH     0.06
}

Star	"HD 85390/HIP 48235"
{
	RA      9.833888887
	Dec     -49.7902778
	Dist    33.96
	AppMagn 8.54
	Class  "K1V"
	MassSol 0.76
	Teff    5186
	FeH    -0.07
	Age     7.2
}

Star	"HD 85512/HIP 48331"
{
	RA      9.8519592
	Dec     -43.502789
	Dist    11.15
	AppMagn 7.67
	Class  "K5V"
	MassSol 0.69
	Teff    4715
	FeH    -0.33
	Age     5.61
}

Star	"HD 8574/HIP 6643"
{
	RA      1.420143533
	Dec     28.566692
	Dist    44.15
	AppMagn 7.112
	Class  "F8"
	MassSol 1.17
	RadSol  1.37
	Teff    6080
	FeH     0.05
	Age     7.13
}

Star	"HD 86081/HIP 48711"
{
	RA      9.9349772
	Dec     -3.808422
	Dist    91.16
	AppMagn 8.73
	Class  "F8V"
	MassSol 1.21
	RadSol  1.22
	Teff    6028
	FeH     0.257
	Age     6.21
}

Star	"HD 86226/HIP 48739"
{
	RA      9.941666667
	Dec     -24.0994444
	Dist    42.48
	AppMagn 7.93
	Class  "G2V"
	MassSol 1.02
	RadSol  1.02
	Teff    5903
	FeH    -0.04
}

Star	"HD 86264/HIP 48780"
{
	RA      9.9493998
	Dec     -15.895122
	Dist    72.57
	AppMagn 7.407
	Class  "F7V"
	MassSol 1.42
	RadSol  1.88
	Teff    6210
	FeH     0.202
	Age     2.24
}

Star	"HD 8673/HIP 6702"
{
	RA      1.435555553
	Dec     34.5794444
	Dist    38.25
	AppMagn 7.57
	Class  "F7V"
	MassSol 1.35
	RadSol  1.39
	Teff    6472
	FeH     0.14
	Age     1.95
}

Star	"HD 87883/HIP 49699"
{
	RA      10.1453166
	Dec     34.24226
	Dist    18.06
	AppMagn 7.55
	Class  "K2.5V"
	MassSol 0.82
	RadSol  0.76
	Teff    4980
	FeH     0.093
	Age     9.8
}

Star	"HD 88133/HIP 49813"
{
	RA      10.1687988
	Dec     18.186871
	Dist    74.46
	AppMagn 8.01
	Class  "G5IV"
	MassSol 1.2
	RadSol  1.93
	Teff    5494
	FeH     0.34
	Age     9.56
}

Star	"HD 89307/HIP 50473"
{
	RA      10.30591327
	Dec     12.621108
	Dist    30.88
	AppMagn 7.009
	Class  "G0"
	MassSol 1.028
	RadSol  1.05
	Teff    5950
	FeH    -0.14
	Age     6.76
}

Star	"HD 90156/HIP 50921"
{
	RA      10.39868773
	Dec     -29.645529
	Dist    22.09
	AppMagn 6.92
	Class  "G5V"
	MassSol 0.84
	Teff    5599
	FeH    -0.24
	Age     4.4
}

Star	"HD 9174"
{
	RA      1.500277778
	Dec     -19.60444446
	Dist    78.93
	AppMagn 8.4
	Class  "G8IV"
	MassSol 1.03
	RadSol  1.67
	Teff    5577
	FeH     0.39
	Age     9
}

Star	"HD 92788/HIP 52409"
{
	RA      10.71333333
	Dec     -2.1836111
	Dist    32.82
	AppMagn 7.31
	Class  "G5"
	MassSol 1.13
	RadSol  0.99
	Teff    5559
	FeH     0.32
	Age     3.78
}

Star	"HD 93083/HIP 52521"
{
	RA      10.73888889
	Dec     -33.5769444
	Dist    28.9
	AppMagn 8.3
	Class  "K3V"
	MassSol 0.7
	Teff    4995
	FeH     0.15
	Age     6
}

Star	"HD 93385"
{
	RA      10.77083333
	Dec     -41.4644444
	Dist    42.2
	AppMagn 7.49
	Class  "G2V"
}

Star	"HD 9446/HIP 7245"
{
	RA      1.555606733
	Dec     29.265148
	Dist    52.85
	AppMagn 8.369
	Class  "G5V"
	MassSol 1
	RadSol  1
	Teff    5793
	FeH     0.09
}

Star	"HD 95086/HIP 53524"
{
	RA      10.95083333
	Dec     -68.6672
	Dist    90.4
	AppMagn 7.36
	Class  "A8III"
	MassSol 1.6
	Teff    7550
	Age     0.017
}

Star	"HD 95089/HIP 53666"
{
	RA      10.97992653
	Dec     1.729216
	Dist    149.03
	AppMagn 7.946
	Class  "G8IV"
	MassSol 1.58
	RadSol  4.9
	Teff    5002
	FeH     0.05
	Age     2.5
}

Star	"HD 95127"
{
	RA      10.99305556
	Dec     43.81444447
	Dist    300
	AppMagn 8.15
	Class  "K0"
	MassSol 1.2
	RadSol  20
	Teff    4218
	FeH    -0.18
	Age     5.5
}

Star	"HD 9578"
{
	RA      1.55472222
	Dec     -38.245
	Dist    57.24
	AppMagn 8.21
	Class  "G1V"
	MassSol 1.12
	FeH     0.11
}

Star	"HD 95872"
{
	RA      11.0578076
	Dec     -22.093977
	Dist    7.56
	AppMagn 9.895
	Class  "K0V"
	MassSol 0.95
	Teff    5312
	FeH     0.41
	Age     10
}

Star	"HD 96063/HIP 54158"
{
	RA      11.07901507
	Dec     -2.513218
	Dist    132.8
	AppMagn 8.254
	Class  "G6V"
	MassSol 1.02
	RadSol  4.5
	Teff    5148
	FeH    -0.3
	Age     9
}

Star	"HD 96127/HIP 54232"
{
	RA      11.0960968
	Dec     44.301559
	Dist    221.24
	AppMagn 7.43
	Class  "K2III"
	MassSol 0.91
	RadSol  35
	Teff    4152
	FeH    -0.24
}

Star	"HD 96167/HIP 54195"
{
	RA      11.08751933
	Dec     -10.291301
	Dist    84.03
	AppMagn 8.08
	Class  "G3V"
	MassSol 1.31
	RadSol  1.86
	Teff    5770
	FeH     0.34
	Age     3.8
}

Star	"HD 96700"
{
	RA      11.13166667
	Dec     -30.1744444
	Dist    25.6
	AppMagn 6.5
	Class  "G0V"
}

Star	"HD 97658/HIP 54906"
{
	RA      11.2425456
	Dec     25.710384
	Dist    21.3
	AppMagn 7.71
	Class  "K1"
	MassSol 0.77
	RadSol  0.74
	Teff    5170
	FeH    -0.23
}

Star	"HD 98219/HIP 55174"
{
	RA      11.29654233
	Dec     -23.975414
	Dist    150.38
	AppMagn 8.033
	Class  "K0III"
	MassSol 1.3
	RadSol  4.5
	Teff    4992
	FeH    -0.02
	Age     4
}

Star	"HD 98649/HIP 55409"
{
	RA      11.3477132
	Dec     -23.217342
	Dist    42.77
	AppMagn 7.991
	Class  "G4V"
	MassSol 1
	RadSol  1
	Teff    5759
	FeH     0.02
}

Star	"HD 99109/HIP 55664"
{
	RA      11.4048218
	Dec     -1.529076
	Dist    60.46
	AppMagn 9.1
	Class  "G8IV"
	MassSol 0.93
	Teff    5272
	FeH     0.315
	Age     12.2
}

Star	"HD 99706/HIP 55994"
{
	RA      11.475059
	Dec     43.966579
	Dist    130.89
	AppMagn 7.637
	Class  "K0"
	MassSol 1.72
	RadSol  5.4
	Teff    4932
	FeH     0.14
	Age     2.1
}

Star	"HIP 104780/BD+14 4559"
{
	RA      21.22666667
	Dec     14.6894444
	Dist    50
	AppMagn 9.63
	Class  "K2V"
	MassSol 0.86
	RadSol  0.95
	Teff    5008
	FeH     0.1
}

Star	"HIP 109384"
{
	RA      22.1603882
	Dec     71.314331
	Dist    56.2
	AppMagn 9.63
	Class  "G5"
	MassSol 0.78
	Teff    5180
	FeH    -0.26
}

Star	"HIP 109600"
{
	RA      22.20173747
	Dec     29.065811
	Dist    58.6
	AppMagn 9.16
	Class  "G5"
	MassSol 0.87
	Teff    5530
	FeH    -0.12
}

Star	"HIP 116454"
{
	RA      23.59694445
	Dec     0.445555574
	Dist    55.2
	AppMagn 10.19
	Class  "K2"
	MassSol 0.775
	RadSol  0.716
	Teff    5089
	FeH    -0.16
}

Star	"HIP 11915"
{
	RA      2.563611112
	Dec     -19.61194447
	Dist    57.3
	AppMagn 8.58
	Class  "G5V"
	MassSol 1
	Teff    5760
	FeH    -0.059
	Age     4
}

Star	"HIP 12961"
{
	RA      2.778579467
	Dec     -23.086611
	Dist    23.8
	AppMagn 10.24
	Class  "M0"
	MassSol 0.67
	FeH    -0.07
}

Star	"HIP 14810"
{
	RA      3.187286133
	Dec     21.097359
	Dist    52.88
	AppMagn 8.52
	Class  "G5V"
	MassSol 0.99
	RadSol  1
	Teff    5485
	FeH     0.26
}

Star	"HIP 2247/BD-17 63"
{
	RA      0.4761111133
	Dec     -16.2263889
	Dist    34.6
	AppMagn 9.62
	Class  "K5V"
	MassSol 0.74
	RadSol  0.69
	Teff    4714
	FeH    -0.03
	Age     4.3
}

Star	"HIP 49067/BD-08 2823"
{
	RA      10.01333333
	Dec     -9.5166667
	Dist    42.2
	AppMagn 9.86
	Class  "K3V"
	MassSol 0.74
	Teff    4746
	FeH    -0.07
	Age     4.5
}

Star	"HIP 51260 A/KELT-4 A"
{
	RA      10.4708364
	Dec     25.573189
	Dist    210
	AppMagn 9.98
	Class  "F"
	MassSol 1.2
	RadSol  1.6
	Teff    6206
	FeH    -0.116
	Age     4.38
}

Star	"HIP 5158"
{
	RA      1.100568867
	Dec     -22.453154
	Dist    44.8
	AppMagn 10.167
	Class  "K5V"
	MassSol 0.78
	Teff    4962
	FeH     0.1
	Age     6
}

Star	"HIP 57050"
{
	RA      11.6957316
	Dec     42.751972
	Dist    11.03
	AppMagn 11.92
	Class  "M4"
	MassSol 0.34
	RadSol  0.4
	Teff    3190
	FeH     0.32
}

Star	"HIP 57274"
{
	RA      11.74471233
	Dec     30.959293
	Dist    25.87
	AppMagn 8.98
	Class  "K4V"
	MassSol 0.73
	RadSol  0.68
	Teff    4640
	FeH     0.09
	Age     7.87
}

Star	"HIP 65407"
{
	RA      13.40584413
	Dec     48.885094
	Dist    55.5
	AppMagn 9.42
	Class  "K0"
	MassSol 0.93
	Teff    5460
	FeH     0.25
}

Star	"HIP 70849"
{
	RA      14.4884898
	Dec     -46.463818
	Dist    23.98
	AppMagn 10.38
	Class  "K7V"
	MassSol 0.63
	Teff    4105
	Age     3
}

Star	"HIP 73990"
{
	RA      15.12083333
	Dec     -29.50444446
	Dist    125
	AppMagn 8.12
	Class  "A9V"
	MassSol 1.72
	Teff    7450
	Age     0.015
}

Star	"HIP 74865"
{
	RA      15.29888889
	Dec     -30.47805557
	Dist    115
	AppMagn 9
	Class  "F3V"
	MassSol 1.42
	Teff    6640
	Age     0.015
}

Star	"HIP 77900"
{
	RA      15.90833333
	Dec     -27.3386
	AppMagn 6.1
	Class  "B6"
	Teff    13700
}

Star	"HIP 78407/BD+15 2940"
{
	RA      16.00637107
	Dec     15.54693
	Dist    175.44
	AppMagn 9.046
	Class  "K0"
	MassSol 1.1
	RadSol  14.7
	Teff    4796
	FeH     0.28
	Age     7.1
}

Star	"HIP 79431"
{
	RA      16.2116038
	Dec     -18.875504
	Dist    14.9
	AppMagn 11.34
	Class  "M3V"
	MassSol 0.49
	Teff    3191
	FeH     0.4
}

Star	"HIP 90979/BD-11 4672"
{
	RA      18.55805556
	Dec     -11.63611113
	Dist    27.3
	AppMagn 10.02
	Class  "K7V"
	MassSol 0.571
	RadSol  0.52
	Teff    4475
	FeH    -0.48
	Age     4.4
}

Star	"HIP 91258"
{
	RA      18.61472222
	Dec     61.70250002
	Dist    44.9
	AppMagn 8.65
	Class  "G5V"
	MassSol 0.95
	RadSol  1
	Teff    5519
	FeH     0.23
	Age     2.4
}

Star	"HN Peg/HD 206860/HIP 107350"
{
	RA      21.74203693
	Dec     14.771939
	Dist    18.39
	AppMagn 5.95
	Class  "G0IV"
	MassSol 1
	Age     0.2
}

Star	"HR 3549"
{
	RA      8.884444445
	Dec     -56.64944447
	Dist    92.5
	AppMagn 6.01
	Class  "A0V"
	Teff    10207
	Age     0.23
}

Star	"Helvetios/51 Peg/HD 217014/HIP 113357"
{
	RA      22.9575
	Dec     20.7686111
	Dist    14.7
	AppMagn 5.49
	Class  "G2IV"
	MassSol 1.11
	RadSol  1.266
	Teff    5793
	FeH     0.2
	Age     4
}

Star	"Intercrus/HD 81688/HIP 46471"
{
	RA      9.47777778
	Dec     45.6013889
	Dist    88.26
	AppMagn 5.41
	Class  "K0III"
	MassSol 2.1
	RadSol  13
	Teff    4753
	FeH    -0.359
}

Star	"K2-10"
{
	RA      11.47479713
	Dec     1.690636
	Dist    271
	AppMagn 12.418
	MassSol 0.92
	RadSol  0.98
	Teff    5620
	FeH    -0.07
}

Star	"K2-11"
{
	RA      11.26946713
	Dec     1.98684
	Dist    2019
	AppMagn 13.386
	MassSol 1.35
	RadSol  5.15
	Teff    5433
	FeH    -0.12
}

Star	"K2-12"
{
	RA      11.54613547
	Dec     2.244884
	Dist    294
	AppMagn 12.258
	MassSol 1.01
	RadSol  1.01
	Teff    5800
	FeH     0.03
}

Star	"K2-13"
{
	RA      11.3437022
	Dec     2.502696
	Dist    290
	AppMagn 12.901
	MassSol 0.8
	RadSol  0.78
	Teff    5698
	FeH    -0.54
}

Star	"K2-14"
{
	RA      11.87046813
	Dec     2.594245
	Dist    219
	AppMagn 16.31
	MassSol 0.47
	RadSol  0.45
	Teff    3789
	FeH    -0.37
}

Star	"K2-15"
{
	RA      11.87405293
	Dec     4.254747
	Dist    437
	AppMagn 14.663
	MassSol 0.72
	RadSol  0.68
	Teff    5131
	FeH    -0.46
}

Star	"K2-16"
{
	RA      11.67315
	Dec     4.55733335
	Dist    324
	AppMagn 14.298
	Class  "K3V"
	MassSol 0.68
	RadSol  0.66
	Teff    4761
	FeH    -0.33
}

Star	"K2-17"
{
	RA      11.88865153
	Dec     6.412261
	Dist    134
	AppMagn 13.519
	MassSol 0.71
	RadSol  0.66
	Teff    4320
	FeH     0.15
}

Star	"K2-18"
{
	RA      11.50403033
	Dec     7.588391
	Dist    34
	AppMagn 13.496
	MassSol 0.41
	RadSol  0.39
	Teff    3503
	FeH     0.09
}

Star	"K2-21/EPIC 206011691"
{
	RA      22.686912
	Dec     -14.488987
	Dist    65
	AppMagn 12.85
	Class  "M0"
	MassSol 0.64
	RadSol  0.6
	Teff    4043
	FeH    -0.11
}

Star	"K2-22/EPIC 201637175"
{
	RA      11.2988546
	Dec     2.61907
	Dist    225
	AppMagn 15.597
	Class  "M0V"
	MassSol 0.6
	RadSol  0.57
	Teff    3830
	FeH     0.03
}

Star	"K2-24/EPIC 203771098"
{
	RA      16.17158127
	Dec     -24.990331
	Dist    181
	AppMagn 11.28
	Class  "G3"
	MassSol 1.12
	RadSol  1.21
	Teff    5743
	FeH     0.42
	Age     5
}

Star	"K2-25/EPIC 210490365"
{
	RA      4.2182288
	Dec     15.247763
	Dist    45.7
	AppMagn 15.881
	Class  "M4.5"
	MassSol 0.29
	RadSol  0.29
	Teff    3180
	FeH     0.15
}

Star	"K2-26"
{
	RA      6.280555557
	Dec     24.59583336
	Dist    93
	AppMagn 13
	Class  "M1"
	MassSol 0.56
	RadSol  0.52
	Teff    3785
	FeH    -0.13
}

Star	"K2-27"
{
	RA      11.43434433
	Dec     1.230738
	AppMagn 12.644
	MassSol 0.89
	RadSol  0.85
	Teff    5320
	FeH     0.14
}

Star	"K2-28"
{
	RA      22.37495893
	Dec     -7.955366
	Dist    53
	AppMagn 16.061
	Class  "M4"
	MassSol 0.26
	RadSol  0.29
	Teff    3214
	FeH     0.26
}

Star	"K2-29/EPIC 211089792"
{
	RA      4.178043133
	Dec     24.402043
	Dist    185
	AppMagn 12.526
	Class  "G7V"
	MassSol 0.94
	RadSol  0.86
	Teff    5358
	FeH     0.16
}

Star	"K2-30/EPIC 210957318/EPIC 318"
{
	RA      3.489464133
	Dec     22.299405
	Dist    278
	AppMagn 13.53
	Class  "G6V"
	MassSol 0.9
	RadSol  0.84
	Teff    5425
	FeH    -0.15
}

Star	"K2-31"
{
	RA      16.36271673
	Dec     -23.547865
	AppMagn 10.803
	MassSol 1
	RadSol  0.99
	Teff    5412
	FeH     0.2
}

Star	"K2-32"
{
	RA      16.82840553
	Dec     -19.542821
	AppMagn 12.307
	MassSol 0.87
	RadSol  0.87
	Teff    5315
	FeH     0
}

Star	"K2-34/EPIC 212110888/EPIC 888"
{
	RA      8.505251333
	Dec     22.235908
	Dist    377
	AppMagn 11.447
	Class  "F9"
	MassSol 1.31
	RadSol  1.66
	Teff    6087
	FeH     0.15
}

Star	"K2-4"
{
	RA      11.64970907
	Dec     -3.905585
	AppMagn 14.907
	MassSol 0.63
	RadSol  0.6
	Teff    4197
	FeH    -0.12
}

Star	"K2-5"
{
	RA      11.2868998
	Dec     -1.877976
	AppMagn 14.912
	MassSol 0.53
	RadSol  0.52
	Teff    4102
	FeH    -0.51
}

Star	"K2-6"
{
	RA      11.87948407
	Dec     -1.198477
	AppMagn 12.654
	MassSol 0.97
	RadSol  0.96
	Teff    5850
	FeH    -0.14
}

Star	"K2-7"
{
	RA      11.13958433
	Dec     -1.065755
	AppMagn 13.213
	MassSol 0.97
	RadSol  0.96
	Teff    5772
	FeH    -0.07
}

Star	"K2-8/EPIC 201445392"
{
	RA      11.31957778
	Dec     -0.2843888954
	AppMagn 14.384
	MassSol 0.79
	RadSol  0.74
	Teff    4890
	FeH    -0.01
}

Star	"K2-9"
{
	RA      11.75096453
	Dec     0.005301
	Dist    110
	AppMagn 15.63
	Class  "M2.5V"
	MassSol 0.3
	RadSol  0.31
	Teff    3390
	FeH    -0.25
}

Star	"KAP And/HD 222439/HIP 116805"
{
	RA      23.67361333
	Dec     44.3339
	Dist    51.6
	AppMagn 4.14
	Class  "B9IV"
	MassSol 2.8
	RadSol  2.29
	Teff    11361
	FeH    -0.36
	Age     0.03
}

Star	"KAP CrB/HD 142091/HIP 77655"
{
	RA      15.8538696
	Dec     35.657383
	Dist    30.5
	AppMagn 4.82
	Class  "K0III"
	MassSol 1.47
	RadSol  5.06
	Teff    4788
	FeH     0.15
	Age     2.5
}

Star	"KELT-1"
{
	RA      0.02388888947
	Dec     39.38361112
	Dist    263
	AppMagn 10.7
	Class  "F5"
	MassSol 1.471
	RadSol  1.335
	Teff    6516
	FeH     0.052
	Age     1.75
}

Star	"KELT-10"
{
	RA      18.96989153
	Dec     -47.003242
	Dist    183
	AppMagn 10.854
	Class  "G0V"
	MassSol 1.11
	RadSol  1.21
	Teff    5948
	FeH     0.09
	Age     4.5
}

Star	"KELT-14/WASP-122"
{
	RA      7.220099
	Dec     -42.409744
	Dist    201
	AppMagn 10.948
	Class  "G4"
	MassSol 1.18
	RadSol  1.37
	Teff    5802
	FeH     0.326
}

Star	"KELT-15"
{
	RA      7.827669133
	Dec     -52.120453
	Dist    291
	AppMagn 11.189
	MassSol 1.18
	RadSol  1.48
	Teff    6003
	FeH     0.047
}

Star	"KELT-3"
{
	RA      9.909446667
	Dec     40.3881
	Dist    178
	AppMagn 9.8
	Class  "F"
	MassSol 1.282
	RadSol  1.482
	Teff    6304
	FeH     0.048
	Age     3
}

Star	"KELT-6"
{
	RA      13.0654582
	Dec     30.640051
	Dist    222
	AppMagn 10.418
	Class  "F8"
	MassSol 1.13
	RadSol  1.53
	Teff    6272
	FeH    -0.27
	Age     4.9
}

Star	"KIC 10001893"
{
	RA      19.1592794
	Dec     46.984489
	AppMagn 16
	MassSol 0.47
	Teff    26700
}

Star	"KIC 10024862"
{
	RA      19.78694444
	Dec     46.93444446
	AppMagn 16.4
	MassSol 1.07
	RadSol  1.11
	Teff    6616
	FeH     0.07
}

Star	"KIC 10255705"
{
	RA      18.85694445
	Dec     47.37750002
	AppMagn 13.5
	MassSol 1.1
	RadSol  2.12
	Teff    5030
	FeH    -0.13
}

Star	"KIC 12454613"
{
	RA      19.21138889
	Dec     51.38222224
	AppMagn 14
	MassSol 0.87
	RadSol  0.82
	Teff    5420
	FeH     0.03
}

Star	"KIC 5010054"
{
	RA      19.43333333
	Dec     40.1828
	AppMagn 14.5
	MassSol 1.05
	RadSol  2.17
	Teff    5550
}

Star	"KIC 5522786"
{
	RA      19.22278
	Dec     40.7314
	AppMagn 9.8
	MassSol 1.79
	RadSol  1.3
	Teff    8719
	FeH    -0.03
}

Star	"KIC 5732155"
{
	RA      19.895
	Dec     40.9067
	AppMagn 15.5
	MassSol 1.13
	RadSol  1.99
	Teff    5755
	FeH    -0.03
}

Star	"KIC 8012732"
{
	RA      18.98194445
	Dec     43.8641667
	AppMagn 14.3
	MassSol 0.92
	RadSol  1.22
	Teff    6221
	FeH     0.2
}

Star	"KIC 9413313"
{
	RA      19.69444445
	Dec     45.90361113
	AppMagn 14.5
	MassSol 0.95
	RadSol  1.45
	Teff    5359
	FeH     0.02
}

Star	"KIC 9662267"
{
	RA      19.78611111
	Dec     46.35000001
	AppMagn 15.3
	MassSol 0.86
	RadSol  0.89
	Teff    5602
	FeH    -0.03
}

Star	"KIC 9704149"
{
	RA      19.2775
	Dec     46.42166668
	AppMagn 15.5
	MassSol 0.86
	RadSol  0.78
	Teff    5640
	FeH    -0.16
}

Star	"KMT-2015-1"
{
	RA      17.9775
	Dec     -28.03166668
	Dist    8200
	Class  "M"
	MassSol 0.18
}

Star	"KOI-100/KIC 4055765"
{
	RA      19.41186113
	Dec     39.19949
	AppMagn 12.598
	MassSol 1.595
	RadSol  3.079
	Teff    6638
}

Star	"KOI-102/KIC 8456679"
{
	RA      19.98031613
	Dec     44.435749
	AppMagn 12.566
	MassSol 1.016
	RadSol  1.231
	Teff    5731
}

Star	"KOI-1020/KIC 2309719"
{
	RA      19.52872313
	Dec     37.60664
	AppMagn 12.899
	MassSol 1.023
	RadSol  1.418
	Teff    6058
}

Star	"KOI-1029/KIC 2164169"
{
	RA      19.48606567
	Dec     37.580799
	AppMagn 14.757
	MassSol 1.042
	RadSol  0.973
	Teff    6000
}

Star	"KOI-103/KIC 2444412"
{
	RA      19.44555667
	Dec     37.751591
	AppMagn 12.593
	MassSol 0.952
	RadSol  0.857
	Teff    5653
}

Star	"KOI-1030/KIC 2574338"
{
	RA      19.4092326
	Dec     37.859299
	AppMagn 15.399
	MassSol 1.083
	RadSol  1.035
	Teff    6363
}

Star	"KOI-1032/KIC 2162635"
{
	RA      19.46516927
	Dec     37.532551
	AppMagn 13.862
	MassSol 1.083
	RadSol  2.283
	Teff    5009
}

Star	"KOI-1051/KIC 6131236"
{
	RA      19.61088053
	Dec     41.451801
	AppMagn 15.391
	MassSol 1.05
	RadSol  0.97
	Teff    6061
}

Star	"KOI-1063/KIC 8257407"
{
	RA      19.934727
	Dec     44.17276
	AppMagn 13.624
	MassSol 0.959
	RadSol  1.583
	Teff    6214
}

Star	"KOI-1066/KIC 8260218"
{
	RA      19.9857544
	Dec     44.16954
	AppMagn 15.623
	MassSol 0.869
	RadSol  0.842
	Teff    5695
}

Star	"KOI-1067/KIC 8246781"
{
	RA      19.7539612
	Dec     44.165741
	AppMagn 14.685
	MassSol 1.051
	RadSol  1.029
	Teff    6195
}

Star	"KOI-1081/KIC 10149023"
{
	RA      19.651237
	Dec     47.13279
	AppMagn 15.22
	MassSol 1.142
	RadSol  1.048
	Teff    6140
}

Star	"KOI-1085/KIC 10118816"
{
	RA      18.736674
	Dec     47.188148
	AppMagn 15.233
	MassSol 0.54
	RadSol  0.52
	Teff    3939
}

Star	"KOI-1095/KIC 3329204"
{
	RA      19.1744588
	Dec     38.402321
	AppMagn 15.617
	MassSol 0.95
	RadSol  0.856
	Teff    5693
}

Star	"KOI-1096/KIC 3230491"
{
	RA      19.34553627
	Dec     38.321941
	AppMagn 14.709
	MassSol 0.832
	RadSol  0.76
	Teff    5606
}

Star	"KOI-1103/KIC 2860866"
{
	RA      19.54826047
	Dec     38.033581
	AppMagn 14.96
	MassSol 1.248
	RadSol  1.2
	Teff    6444
}

Star	"KOI-1118/KIC 2853446"
{
	RA      19.443398
	Dec     38.028179
	AppMagn 13.835
	MassSol 0.982
	RadSol  1.07
	Teff    5973
}

Star	"KOI-1137/KIC 8332986"
{
	RA      20.1139486
	Dec     44.281792
	AppMagn 14.041
	MassSol 0.689
	RadSol  0.733
	Teff    5324
}

Star	"KOI-1145/KIC 8313667"
{
	RA      19.76990767
	Dec     44.264671
	AppMagn 14.143
	MassSol 1.033
	RadSol  0.952
	Teff    6075
}

Star	"KOI-1159/KIC 10354039"
{
	RA      19.8009888
	Dec     47.486431
	AppMagn 15.332
	MassSol 0.834
	RadSol  0.881
	Teff    5043
}

Star	"KOI-1166/KIC 10351231"
{
	RA      19.74209393
	Dec     47.43882
	AppMagn 15.44
	MassSol 1.079
	RadSol  1.001
	Teff    6063
}

Star	"KOI-1168/KIC 10460629"
{
	RA      19.1724528
	Dec     47.600021
	AppMagn 13.997
	MassSol 1.063
	RadSol  1.309
	Teff    6449
}

Star	"KOI-1169/KIC 10319385"
{
	RA      18.77007853
	Dec     47.469959
	AppMagn 13.248
	MassSol 1.038
	RadSol  0.918
	Teff    5676
}

Star	"KOI-1170/KIC 10482160"
{
	RA      19.7488098
	Dec     47.678959
	AppMagn 14.657
	MassSol 0.84
	RadSol  0.766
	Teff    5734
}

Star	"KOI-1174/KIC 10287723"
{
	RA      19.78810833
	Dec     47.354031
	AppMagn 13.447
	MassSol 0.717
	RadSol  0.726
	Teff    4500
}

Star	"KOI-1191/KIC 3859628"
{
	RA      19.59157513
	Dec     38.922482
	AppMagn 15.24
	MassSol 1.093
	RadSol  0.986
	Teff    5993
}

Star	"KOI-1192/KIC 3644071"
{
	RA      19.4021444
	Dec     38.703911
	AppMagn 14.215
	MassSol 0.889
	RadSol  1.048
	Teff    5609
}

Star	"KOI-1193/KIC 3942446"
{
	RA      19.19254153
	Dec     39.078709
	AppMagn 15.289
	MassSol 0.76
	RadSol  0.92
	Teff    5697
}

Star	"KOI-1201/KIC 4061149"
{
	RA      19.50513507
	Dec     39.12088
	AppMagn 15.597
	MassSol 0.48
	RadSol  0.46
	Teff    3712
}

Star	"KOI-1206/KIC 3756801"
{
	RA      19.59697267
	Dec     38.899971
	AppMagn 13.642
	MassSol 1.004
	RadSol  1.444
	Teff    5796
}

Star	"KOI-1208/KIC 3962440"
{
	RA      19.57458493
	Dec     39.022572
	AppMagn 13.594
	MassSol 1.136
	RadSol  1.118
	Teff    6487
}

Star	"KOI-1209/KIC 3534076"
{
	RA      19.22095747
	Dec     38.693291
	AppMagn 15.166
	MassSol 0.806
	RadSol  0.791
	Teff    5587
}

Star	"KOI-1226/KIC 6621116"
{
	RA      19.72446087
	Dec     42.062672
	AppMagn 15.324
	MassSol 0.809
	RadSol  0.87
	Teff    5228
}

Star	"KOI-1227/KIC 6629332"
{
	RA      19.84714153
	Dec     42.047371
	AppMagn 13.997
	MassSol 0.895
	RadSol  0.815
	Teff    5658
}

Star	"KOI-1230/KIC 6470149"
{
	RA      19.92987673
	Dec     41.812149
	AppMagn 12.263
	MassSol 1.782
	RadSol  7.062
	Teff    5015
}

Star	"KOI-1232/KIC 6665223"
{
	RA      18.782841
	Dec     42.123081
	AppMagn 14.427
	MassSol 0.602
	RadSol  0.606
	Teff    5064
}

Star	"KOI-1239/KIC 6607286"
{
	RA      19.4785726
	Dec     42.005909
	AppMagn 15.005
	MassSol 1.132
	RadSol  1.03
	Teff    6108
}

Star	"KOI-1242/KIC 6607447"
{
	RA      19.48189293
	Dec     42.03537
	AppMagn 13.75
	MassSol 1.211
	RadSol  1.189
	Teff    6459
}

Star	"KOI-1246/KIC 6441738"
{
	RA      19.4285034
	Dec     41.878159
	AppMagn 14.898
	MassSol 0.99
	RadSol  1.013
	Teff    6258
}

Star	"KOI-1255/KIC 8494263"
{
	RA      19.4296814
	Dec     44.52869
	AppMagn 15.913
	MassSol 0.969
	RadSol  0.872
	Teff    5737
}

Star	"KOI-1268/KIC 8813698"
{
	RA      19.32597453
	Dec     45.005669
	AppMagn 14.814
	MassSol 1.058
	RadSol  0.989
	Teff    6201
}

Star	"KOI-1271/KIC 8631160"
{
	RA      19.6177002
	Dec     44.7943
	AppMagn 13.632
	MassSol 1.215
	RadSol  1.389
	Teff    6628
}

Star	"KOI-1276/KIC 8804283"
{
	RA      19.0024068
	Dec     45.07106
	AppMagn 14.766
	MassSol 0.953
	RadSol  0.857
	Teff    5632
}

Star	"KOI-1281/KIC 8742590"
{
	RA      19.1311218
	Dec     44.992489
	AppMagn 14.427
	MassSol 0.937
	RadSol  0.851
	Teff    5767
}

Star	"KOI-1303/KIC 10867062"
{
	RA      19.61533813
	Dec     48.204479
	AppMagn 14.965
	MassSol 0.716
	RadSol  0.783
	Teff    5433
}

Star	"KOI-1311/KIC 10713616"
{
	RA      18.90219727
	Dec     48.094261
	AppMagn 13.498
	MassSol 1.094
	RadSol  1.401
	Teff    6190
}

Star	"KOI-1315/KIC 10928043"
{
	RA      19.68625693
	Dec     48.374802
	AppMagn 13.137
	MassSol 1.149
	RadSol  1.049
	Teff    6029
}

Star	"KOI-1316/KIC 10794087"
{
	RA      19.37015787
	Dec     48.126263
	AppMagn 11.926
	MassSol 1.23
	RadSol  2.024
	Teff    5720
}

Star	"KOI-1326/KIC 4639868"
{
	RA      19.1223246
	Dec     39.760849
	AppMagn 12.907
	MassSol 0.752
	RadSol  0.74
	Teff    5378
}

Star	"KOI-1328/KIC 4074736"
{
	RA      19.7203898
	Dec     39.17799
	AppMagn 15.671
	MassSol 0.807
	RadSol  0.737
	Teff    5610
}

Star	"KOI-1331/KIC 4274548"
{
	RA      19.63389487
	Dec     39.398682
	AppMagn 15.238
	MassSol 0.751
	RadSol  0.713
	Teff    4812
}

Star	"KOI-1351/KIC 6964043"
{
	RA      19.73429767
	Dec     42.422279
	AppMagn 15.613
	MassSol 0.832
	RadSol  0.905
	Teff    5582
}

Star	"KOI-1356/KIC 7363829"
{
	RA      19.47466027
	Dec     42.931679
	AppMagn 15.206
}

Star	"KOI-1357/KIC 6719086"
{
	RA      19.89730227
	Dec     42.187431
	AppMagn 15.673
	MassSol 0.925
	RadSol  0.953
	Teff    5209
}

Star	"KOI-1358/KIC 7376983"
{
	RA      19.7217
	Dec     42.94339
	AppMagn 15.505
	MassSol 0.778
	RadSol  0.729
	Teff    4750
}

Star	"KOI-1359/KIC 6946199"
{
	RA      19.4013794
	Dec     42.46244
	AppMagn 15.229
	MassSol 0.886
	RadSol  0.85
	Teff    5986
}

Star	"KOI-1362/KIC 6837146"
{
	RA      18.77369387
	Dec     42.390419
	AppMagn 15.406
	MassSol 0.739
	RadSol  0.695
	Teff    5305
}

Star	"KOI-1369/KIC 7287415"
{
	RA      19.56460167
	Dec     42.822411
	AppMagn 14.878
	MassSol 1.062
	RadSol  0.999
	Teff    6043
}

Star	"KOI-1375/KIC 6766634"
{
	RA      19.22136233
	Dec     42.261414
	AppMagn 13.709
	MassSol 0.869
	RadSol  0.901
	Teff    5982
}

Star	"KOI-1378/KIC 7375795"
{
	RA      19.70071207
	Dec     42.930565
	AppMagn 13.601
	MassSol 1.287
	RadSol  2.407
	Teff    5754
}

Star	"KOI-138/KIC 8506766"
{
	RA      19.72939453
	Dec     44.57835
	AppMagn 13.96
	MassSol 1.424
	RadSol  1.807
	Teff    7061
}

Star	"KOI-1385/KIC 9278553"
{
	RA      19.39223633
	Dec     45.765869
	AppMagn 15.84
	MassSol 0.974
	RadSol  0.891
	Teff    6077
}

Star	"KOI-1387/KIC 8949247"
{
	RA      19.36620487
	Dec     45.205898
	AppMagn 14.669
	MassSol 0.991
	RadSol  0.957
	Teff    5934
}

Star	"KOI-1391/KIC 8958035"
{
	RA      19.580603
	Dec     45.286388
	AppMagn 14.36
	MassSol 1.056
	RadSol  0.989
	Teff    6217
}

Star	"KOI-1393/KIC 9202151"
{
	RA      18.9037028
	Dec     45.614262
	AppMagn 15.804
	MassSol 0.569
	RadSol  0.563
	Teff    3872
}

Star	"KOI-1395/KIC 8935810"
{
	RA      18.9473104
	Dec     45.25808
	AppMagn 15.977
	MassSol 0.983
	RadSol  0.865
	Teff    5477
}

Star	"KOI-1397/KIC 9427402"
{
	RA      19.9785136
	Dec     45.972328
	AppMagn 15.369
	MassSol 0.549
	RadSol  0.542
	Teff    3957
}

Star	"KOI-1398/KIC 9269281"
{
	RA      19.06452433
	Dec     45.739071
	AppMagn 15.898
	MassSol 0.916
	RadSol  0.864
	Teff    5774
}

Star	"KOI-1399/KIC 9100484"
{
	RA      19.71738893
	Dec     45.45739
	AppMagn 15.92
	MassSol 0.884
	RadSol  0.78
	Teff    4939
}

Star	"KOI-1408/KIC 9150827"
{
	RA      19.3529704
	Dec     45.56461
	AppMagn 14.688
	MassSol 0.59
	RadSol  0.57
	Teff    4023
}

Star	"KOI-141/KIC 12105051"
{
	RA      19.20255333
	Dec     50.651611
	AppMagn 13.687
	MassSol 0.992
	RadSol  0.879
	Teff    5377
}

Star	"KOI-1411/KIC 9425139"
{
	RA      19.9330058
	Dec     45.909512
	AppMagn 13.377
	MassSol 1.09
	RadSol  1.12
	Teff    5721
}

Star	"KOI-1420/KIC 11026304"
{
	RA      19.34084673
	Dec     48.577782
	AppMagn 15.825
	MassSol 0.755
	RadSol  0.754
	Teff    4843
}

Star	"KOI-1421/KIC 11342550"
{
	RA      19.1766968
	Dec     49.156052
	AppMagn 15.305
	MassSol 1.059
	RadSol  1.021
	Teff    5923
}

Star	"KOI-1429/KIC 11030711"
{
	RA      19.49010007
	Dec     48.511082
	AppMagn 15.531
	MassSol 0.85
	RadSol  0.897
	Teff    5717
}

Star	"KOI-1431/KIC 11075279"
{
	RA      19.13481853
	Dec     48.681938
	AppMagn 13.46
	MassSol 1.054
	RadSol  0.953
	Teff    5628
}

Star	"KOI-1437/KIC 11599038"
{
	RA      18.9897746
	Dec     49.692402
	AppMagn 15.28
	MassSol 0.974
	RadSol  0.967
	Teff    6052
}

Star	"KOI-145/KIC 9904059"
{
	RA      19.78784793
	Dec     46.781509
	AppMagn 13.608
	MassSol 2.15
	RadSol  7.119
	Teff    5047
}

Star	"KOI-1452/KIC 7449844"
{
	RA      19.55210367
	Dec     43.055809
	AppMagn 13.63
	MassSol 1.46
	RadSol  1.77
	Teff    7172
}

Star	"KOI-1458/KIC 12120943"
{
	RA      19.77143553
	Dec     50.677849
	AppMagn 15.703
	MassSol 1.133
	RadSol  1.022
	Teff    5977
}

Star	"KOI-1463/KIC 7672940"
{
	RA      19.2172424
	Dec     43.376465
	AppMagn 12.328
	MassSol 1.174
	RadSol  2.173
	Teff    6340
}

Star	"KOI-1465/KIC 11702948"
{
	RA      19.0766256
	Dec     49.867512
	AppMagn 14.245
	MassSol 0.939
	RadSol  0.85
	Teff    5804
}

Star	"KOI-1466/KIC 9512981"
{
	RA      18.98999227
	Dec     46.13895
	AppMagn 15.962
	MassSol 0.718
	RadSol  0.674
	Teff    4769
}

Star	"KOI-1470/KIC 9480310"
{
	RA      19.82348833
	Dec     46.09594
	AppMagn 15.703
	MassSol 1.065
	RadSol  0.951
	Teff    5900
}

Star	"KOI-1473/KIC 7499398"
{
	RA      18.69068193
	Dec     43.12368
	AppMagn 15.573
	MassSol 1.051
	RadSol  0.95
	Teff    5610
}

Star	"KOI-1475/KIC 4770365"
{
	RA      19.8286926
	Dec     39.847839
	AppMagn 15.937
	MassSol 0.57
	RadSol  0.56
	Teff    4056
}

Star	"KOI-1476/KIC 12406749"
{
	RA      19.39027507
	Dec     51.222809
	AppMagn 15.792
	MassSol 0.824
	RadSol  0.821
	Teff    5446
}

Star	"KOI-1477/KIC 7811397"
{
	RA      19.17693073
	Dec     43.505718
	AppMagn 15.917
	MassSol 0.749
	RadSol  0.719
	Teff    5272
}

Star	"KOI-1483/KIC 11909686"
{
	RA      19.276827
	Dec     50.253159
	AppMagn 14.305
	MassSol 0.932
	RadSol  0.844
	Teff    5850
}

Star	"KOI-1484/KIC 11760959"
{
	RA      19.37445273
	Dec     49.957619
	AppMagn 15.305
	MassSol 0.726
	RadSol  0.744
	Teff    4922
}

Star	"KOI-1489/KIC 9823487"
{
	RA      19.2157776
	Dec     46.605919
	AppMagn 15.554
	MassSol 0.853
	RadSol  0.777
	Teff    5178
}

Star	"KOI-1494/KIC 11821363"
{
	RA      19.69714353
	Dec     50.077171
	AppMagn 15.858
	MassSol 0.734
	RadSol  0.747
	Teff    4723
}

Star	"KOI-1496/KIC 4828341"
{
	RA      19.30711873
	Dec     39.938332
	AppMagn 15.6
	MassSol 0.925
	RadSol  0.914
	Teff    5926
}

Star	"KOI-151/KIC 2307199"
{
	RA      19.4916504
	Dec     37.630959
	AppMagn 14
	MassSol 1.001
	RadSol  1.041
	Teff    6276
}

Star	"KOI-1510/KIC 11870545"
{
	RA      19.67228193
	Dec     50.114609
	AppMagn 15.929
	MassSol 0.784
	RadSol  0.737
	Teff    4924
}

Star	"KOI-1527/KIC 7768451"
{
	RA      19.77808633
	Dec     43.49839
	AppMagn 14.879
	MassSol 0.911
	RadSol  0.861
	Teff    5734
}

Star	"KOI-1537/KIC 9872292"
{
	RA      18.7641154
	Dec     46.789894
	AppMagn 11.74
	MassSol 1.366
	RadSol  1.824
	Teff    6260
}

Star	"KOI-1546/KIC 5475431"
{
	RA      19.90091347
	Dec     40.639622
	AppMagn 14.456
	MassSol 1.01
	RadSol  0.893
	Teff    5713
}

Star	"KOI-1547/KIC 5283458"
{
	RA      19.61339313
	Dec     40.455959
	AppMagn 15.673
	MassSol 1.092
	RadSol  1.023
	Teff    6147
}

Star	"KOI-1549/KIC 8053552"
{
	RA      19.93705647
	Dec     43.897202
	AppMagn 15.135
	MassSol 0.762
	RadSol  0.901
	Teff    5631
}

Star	"KOI-1552/KIC 7984047"
{
	RA      19.9283956
	Dec     43.75037
	AppMagn 15.915
	MassSol 0.734
	RadSol  0.755
	Teff    4812
}

Star	"KOI-1558/KIC 10019763"
{
	RA      19.66975913
	Dec     46.97459
	AppMagn 15.134
	MassSol 0.994
	RadSol  0.947
	Teff    6133
}

Star	"KOI-1561/KIC 4940438"
{
	RA      19.73556113
	Dec     40.019611
	AppMagn 15.549
	MassSol 0.825
	RadSol  0.866
	Teff    5931
}

Star	"KOI-1562/KIC 5308663"
{
	RA      19.9704
	Dec     40.456551
	AppMagn 15.59
	MassSol 0.991
	RadSol  0.904
	Teff    5997
}

Star	"KOI-1573/KIC 5031857"
{
	RA      19.78974407
	Dec     40.138611
	AppMagn 14.373
	MassSol 1.003
	RadSol  0.921
	Teff    6086
}

Star	"KOI-1582/KIC 4918309"
{
	RA      19.34190473
	Dec     40.021832
	AppMagn 15.402
	MassSol 0.815
	RadSol  0.766
	Teff    5570
}

Star	"KOI-1587/KIC 9932970"
{
	RA      18.77459107
	Dec     46.814201
	AppMagn 15.7
	MassSol 0.808
	RadSol  0.789
	Teff    5204
}

Star	"KOI-1590/KIC 5542466"
{
	RA      19.62432453
	Dec     40.720879
	AppMagn 15.674
	MassSol 0.738
	RadSol  0.767
	Teff    4962
}

Star	"KOI-1591/KIC 10028140"
{
	RA      19.84932253
	Dec     46.94191
	AppMagn 15.372
	MassSol 0.817
	RadSol  0.741
	Teff    5284
}

Star	"KOI-1597/KIC 5039228"
{
	RA      19.89125567
	Dec     40.173424
	AppMagn 12.681
	MassSol 1.339
	RadSol  1.283
	Teff    6535
}

Star	"KOI-1599/KIC 5474613"
{
	RA      19.89158933
	Dec     40.61842
	AppMagn 14.802
	MassSol 1.02
	RadSol  0.972
	Teff    5823
}

Star	"KOI-1602/KIC 4860678"
{
	RA      19.85312707
	Dec     39.921371
	AppMagn 14.943
	MassSol 0.943
	RadSol  0.854
	Teff    5806
}

Star	"KOI-1619/KIC 4276716"
{
	RA      19.6660156
	Dec     39.346378
	AppMagn 11.759
	MassSol 0.656
	RadSol  0.674
	Teff    4827
}

Star	"KOI-1622/KIC 7287683"
{
	RA      19.56992593
	Dec     42.888859
	AppMagn 12.02
	MassSol 1.774
	RadSol  2.022
	Teff    7732
}

Star	"KOI-1630/KIC 9017682"
{
	RA      19.35064293
	Dec     45.388409
	AppMagn 15.152
	MassSol 0.923
	RadSol  0.839
	Teff    5695
}

Star	"KOI-1639/KIC 10749128"
{
	RA      19.86003013
	Dec     48.0947
	AppMagn 13.538
	MassSol 1.092
	RadSol  1.139
	Teff    6273
}

Star	"KOI-1645/KIC 11045383"
{
	RA      19.8807292
	Dec     48.559158
	AppMagn 13.418
	MassSol 0.753
	RadSol  0.805
	Teff    5193
}

Star	"KOI-1646/KIC 11046025"
{
	RA      19.89771933
	Dec     48.55941
	AppMagn 14.293
	MassSol 0.76
	RadSol  0.797
	Teff    5017
}

Star	"KOI-1648/KIC 11177543"
{
	RA      18.94217527
	Dec     48.825119
	AppMagn 14.31
	MassSol 0.977
	RadSol  0.857
	Teff    5448
}

Star	"KOI-1649/KIC 11337141"
{
	RA      18.9421916
	Dec     49.142609
	AppMagn 14.963
	MassSol 0.488
	RadSol  0.479
	Teff    3767
}

Star	"KOI-1656/KIC 4471747"
{
	RA      19.57506107
	Dec     39.50631
	AppMagn 15.03
	MassSol 1.008
	RadSol  1.025
	Teff    6084
}

Star	"KOI-1659/KIC 4650733"
{
	RA      19.36621093
	Dec     39.785519
	AppMagn 15.111
	MassSol 1.31
	RadSol  1.298
	Teff    6616
}

Star	"KOI-1660/KIC 4830605"
{
	RA      19.34940187
	Dec     39.96801
	AppMagn 15.614
	MassSol 0.978
	RadSol  0.887
	Teff    5926
}

Star	"KOI-1662/KIC 4844004"
{
	RA      19.60880127
	Dec     39.981979
	AppMagn 15.479
	MassSol 0.944
	RadSol  0.83
	Teff    5463
}

Star	"KOI-1675/KIC 5360920"
{
	RA      19.42247927
	Dec     40.558201
	AppMagn 15.789
	MassSol 0.905
	RadSol  0.825
	Teff    5771
}

Star	"KOI-1681/KIC 5531953"
{
	RA      19.41900027
	Dec     40.730049
	AppMagn 15.855
	MassSol 0.417
	RadSol  0.4
	Teff    3608
}

Star	"KOI-1684/KIC 6048024"
{
	RA      19.56896567
	Dec     41.329899
	AppMagn 12.849
	MassSol 1.16
	RadSol  1.156
	Teff    6428
}

Star	"KOI-1685/KIC 6049190"
{
	RA      19.5919922
	Dec     41.393822
	AppMagn 14.811
	MassSol 1.158
	RadSol  1.142
	Teff    6458
}

Star	"KOI-1691/KIC 6611330"
{
	RA      19.5558716
	Dec     42.016312
	AppMagn 15.838
	MassSol 0.801
	RadSol  0.783
	Teff    5437
}

Star	"KOI-1693/KIC 6696462"
{
	RA      19.55061033
	Dec     42.126629
	AppMagn 14.98
	MassSol 0.909
	RadSol  0.851
	Teff    5601
}

Star	"KOI-1701/KIC 7222086"
{
	RA      19.83460487
	Dec     42.777061
	AppMagn 11.041
	MassSol 1.67
	RadSol  1.881
	Teff    7292
}

Star	"KOI-1702/KIC 7304449"
{
	RA      19.84861653
	Dec     42.86692
	AppMagn 15.722
	MassSol 0.242
	RadSol  0.26
	Teff    3304
}

Star	"KOI-1704/KIC 7386827"
{
	RA      19.867629
	Dec     42.957458
	AppMagn 14.86
	MassSol 0.946
	RadSol  1.064
	Teff    5692
}

Star	"KOI-1705/KIC 7522911"
{
	RA      19.35510053
	Dec     43.12183
	AppMagn 15.442
	MassSol 1.086
	RadSol  1.076
	Teff    6233
}

Star	"KOI-1708/KIC 7750419"
{
	RA      19.39215493
	Dec     43.47176
	AppMagn 14.758
	MassSol 1.006
	RadSol  0.914
	Teff    5911
}

Star	"KOI-1715/KIC 9836959"
{
	RA      19.61848553
	Dec     46.675282
	AppMagn 12.9
	MassSol 0.917
	RadSol  1.069
	Teff    5855
}

Star	"KOI-1720/KIC 10015937"
{
	RA      19.57627767
	Dec     46.989761
	AppMagn 15.742
	MassSol 0.746
	RadSol  0.695
	Teff    5349
}

Star	"KOI-1725/KIC 10905746"
{
	RA      18.90861111
	Dec     48.3911111
	AppMagn 13
	MassSol 0.578
	RadSol  0.548
	Teff    4240
	FeH    -0.23
}

Star	"KOI-1731/KIC 8266276"
{
	RA      20.09795327
	Dec     44.159649
	AppMagn 15.72
	MassSol 0.776
	RadSol  0.797
	Teff    4748
}

Star	"KOI-1733/KIC 8396405"
{
	RA      20.0723816
	Dec     44.380192
	AppMagn 15.73
	MassSol 0.591
	RadSol  0.587
	Teff    5214
}

Star	"KOI-1738/KIC 4365645"
{
	RA      19.4498922
	Dec     39.44688
	AppMagn 13.293
	MassSol 0.766
	RadSol  0.821
	Teff    5302
}

Star	"KOI-1739/KIC 7199906"
{
	RA      19.443339
	Dec     42.700779
	AppMagn 15.129
}

Star	"KOI-1747/KIC 7032421"
{
	RA      19.427889
	Dec     42.579819
	AppMagn 14.792
	MassSol 0.993
	RadSol  0.876
	Teff    5650
}

Star	"KOI-1754/KIC 8651389"
{
	RA      19.9971476
	Dec     44.771889
	AppMagn 13.964
	MassSol 1.202
	RadSol  1.559
	Teff    6047
}

Star	"KOI-1758/KIC 6705142"
{
	RA      19.6956238
	Dec     42.166321
	AppMagn 15.969
	MassSol 0.953
	RadSol  0.858
	Teff    5610
}

Star	"KOI-1761/KIC 4067336"
{
	RA      19.609788
	Dec     39.12706
	AppMagn 15.623
	MassSol 1.232
	RadSol  1.162
	Teff    6392
}

Star	"KOI-1762/KIC 5387843"
{
	RA      19.87559407
	Dec     40.530289
	AppMagn 14.996
	MassSol 0.94
	RadSol  0.883
	Teff    5985
}

Star	"KOI-177/KIC 6803202"
{
	RA      19.87848107
	Dec     42.237041
	AppMagn 13.182
	MassSol 0.949
	RadSol  1.068
	Teff    5757
}

Star	"KOI-1771/KIC 11342573"
{
	RA      19.17757567
	Dec     49.141499
	AppMagn 15.959
	MassSol 1.142
	RadSol  1.048
	Teff    6140
}

Star	"KOI-1772/KIC 3345675"
{
	RA      19.48671267
	Dec     38.402142
	AppMagn 15.635
	MassSol 0.688
	RadSol  0.669
	Teff    4317
}

Star	"KOI-1773/KIC 10153011"
{
	RA      19.73921307
	Dec     47.142891
	AppMagn 15.678
	MassSol 0.626
	RadSol  0.636
	Teff    5286
}

Star	"KOI-1782/KIC 8678664"
{
	RA      19.14737347
	Dec     44.849129
	AppMagn 15.596
	MassSol 0.903
	RadSol  0.88
	Teff    5468
}

Star	"KOI-1783/KIC 10005758"
{
	RA      19.28942873
	Dec     46.988239
	AppMagn 13.929
	MassSol 1.027
	RadSol  0.957
	Teff    6215
}

Star	"KOI-1784/KIC 10158418"
{
	RA      19.84307047
	Dec     47.167488
	AppMagn 13.592
	MassSol 1.075
	RadSol  0.965
	Teff    5936
}

Star	"KOI-1786/KIC 3128793"
{
	RA      19.61380007
	Dec     38.22345
	AppMagn 14.633
	MassSol 0.491
	RadSol  0.474
	Teff    4461
}

Star	"KOI-1793/KIC 5731623"
{
	RA      19.8877828
	Dec     40.996101
	AppMagn 15.28
	MassSol 1.023
	RadSol  0.945
	Teff    6131
}

Star	"KOI-1796/KIC 10019399"
{
	RA      19.6610738
	Dec     46.944977
	AppMagn 12.829
	MassSol 1.006
	RadSol  1.891
	Teff    6065
}

Star	"KOI-1798/KIC 6867766"
{
	RA      19.5464132
	Dec     42.370628
	AppMagn 14.384
	MassSol 1.093
	RadSol  1.033
	Teff    6210
}

Star	"KOI-1799/KIC 6058614"
{
	RA      19.753715
	Dec     41.31712
	AppMagn 15.505
	MassSol 1.038
	RadSol  0.955
	Teff    6045
}

Star	"KOI-1803/KIC 4349442"
{
	RA      19.10903527
	Dec     39.488621
	AppMagn 13.26
	MassSol 0.954
	RadSol  1.604
	Teff    5064
}

Star	"KOI-1808/KIC 7761918"
{
	RA      19.64955447
	Dec     43.461208
	AppMagn 12.487
	MassSol 1.035
	RadSol  1.13
	Teff    6277
}

Star	"KOI-1812/KIC 6279974"
{
	RA      19.3417684
	Dec     41.601082
	AppMagn 13.742
	MassSol 0.983
	RadSol  1.039
	Teff    6258
}

Star	"KOI-1816/KIC 8624520"
{
	RA      19.4455526
	Dec     44.75164
	AppMagn 15.408
	MassSol 0.628
	RadSol  0.64
	Teff    5227
}

Star	"KOI-1822/KIC 5124667"
{
	RA      19.862677
	Dec     40.278629
	AppMagn 12.443
	MassSol 0.936
	RadSol  1.23
	Teff    6192
}

Star	"KOI-1829/KIC 7697568"
{
	RA      19.768162
	Dec     43.363369
	AppMagn 15.911
	MassSol 0.861
	RadSol  0.822
	Teff    5383
}

Star	"KOI-1842/KIC 7779077"
{
	RA      19.95002033
	Dec     43.410439
	AppMagn 14.306
	MassSol 0.941
	RadSol  1.009
	Teff    5602
}

Star	"KOI-1856/KIC 11570749"
{
	RA      19.80524087
	Dec     49.502079
	AppMagn 14.082
	MassSol 0.898
	RadSol  1.507
	Teff    5396
}

Star	"KOI-1857/KIC 11297236"
{
	RA      19.4675598
	Dec     49.019119
	AppMagn 13.748
	MassSol 0.966
	RadSol  0.872
	Teff    5861
}

Star	"KOI-1861/KIC 3648437"
{
	RA      19.47774453
	Dec     38.739052
	AppMagn 13.926
	MassSol 1.077
	RadSol  1.011
	Teff    6177
}

Star	"KOI-1863/KIC 11126381"
{
	RA      19.04447427
	Dec     48.719559
	AppMagn 13.631
	MassSol 1.1
	RadSol  1.038
	Teff    6184
}

Star	"KOI-1864/KIC 4149450"
{
	RA      19.295874
	Dec     39.270359
	AppMagn 13.405
	MassSol 1.098
	RadSol  2.142
	Teff    5779
}

Star	"KOI-1871/KIC 9758089"
{
	RA      19.0169108
	Dec     46.582191
	AppMagn 14.897
	MassSol 0.651
	RadSol  0.624
	Teff    4528
}

Star	"KOI-1872/KIC 9883311"
{
	RA      19.22088827
	Dec     46.771431
	AppMagn 15.841
	MassSol 0.863
	RadSol  0.79
	Teff    5496
}

Star	"KOI-1878/KIC 3098810"
{
	RA      19.08154907
	Dec     38.258171
	AppMagn 12.988
	MassSol 1.115
	RadSol  1.216
	Teff    6071
}

Star	"KOI-1884/KIC 4851530"
{
	RA      19.726827
	Dec     39.918362
	AppMagn 15.462
	MassSol 0.739
	RadSol  0.796
	Teff    5275
}

Star	"KOI-1892/KIC 9030537"
{
	RA      19.65440673
	Dec     45.306122
	AppMagn 15.5
	MassSol 0.925
	RadSol  0.841
	Teff    5679
}

Star	"KOI-1897/KIC 5695524"
{
	RA      19.23829547
	Dec     40.988659
	AppMagn 13.952
	MassSol 1.101
	RadSol  1.122
	Teff    6214
}

Star	"KOI-190/KIC 5771719"
{
	RA      18.976591
	Dec     41.015018
	AppMagn 14.137
	MassSol 1.003
	RadSol  1.284
	Teff    5654
}

Star	"KOI-1901/KIC 3629967"
{
	RA      19.09348753
	Dec     38.738541
	AppMagn 13.34
	MassSol 1.074
	RadSol  0.998
	Teff    6092
}

Star	"KOI-1902/KIC 5809954"
{
	RA      19.79178873
	Dec     41.080582
	AppMagn 14.645
	MassSol 0.465
	RadSol  0.457
	Teff    3763
}

Star	"KOI-1906/KIC 11773328"
{
	RA      19.77489827
	Dec     49.979172
	AppMagn 14.816
	MassSol 0.903
	RadSol  0.809
	Teff    5417
}

Star	"KOI-1917/KIC 10074466"
{
	RA      19.4356262
	Dec     47.0425
	AppMagn 13.624
	MassSol 1.067
	RadSol  1.012
	Teff    6345
}

Star	"KOI-1928/KIC 5770074"
{
	RA      18.920636
	Dec     41.041241
	AppMagn 13.605
	MassSol 1.137
	RadSol  1.09
	Teff    6085
}

Star	"KOI-193/KIC 10799735"
{
	RA      19.52507733
	Dec     48.195309
	AppMagn 14.904
	MassSol 1.064
	RadSol  1.003
	Teff    6147
}

Star	"KOI-1934/KIC 4242147"
{
	RA      18.99797773
	Dec     39.360291
	AppMagn 14.649
	MassSol 0.617
	RadSol  0.577
	Teff    4500
}

Star	"KOI-1935/KIC 5396122"
{
	RA      19.9767802
	Dec     40.545681
	AppMagn 15.838
	MassSol 1.106
	RadSol  0.992
	Teff    5897
}

Star	"KOI-1942/KIC 2832589"
{
	RA      19.06711627
	Dec     38.009541
	AppMagn 15.409
	MassSol 0.875
	RadSol  0.779
	Teff    5252
}

Star	"KOI-1944/KIC 2438513"
{
	RA      19.35524493
	Dec     37.72311
	AppMagn 13.982
	MassSol 1.19
	RadSol  1.85
	Teff    6292
}

Star	"KOI-1946/KIC 10844890"
{
	RA      18.88961793
	Dec     48.223911
	AppMagn 14.469
	MassSol 0.969
	RadSol  0.935
	Teff    5772
}

Star	"KOI-1957/KIC 10028352"
{
	RA      19.85281573
	Dec     46.935829
	AppMagn 12.655
	MassSol 1.073
	RadSol  1.188
	Teff    6419
}

Star	"KOI-1962/KIC 5513648"
{
	RA      18.94893187
	Dec     40.79454
	AppMagn 10.77
	MassSol 1.083
	RadSol  1.47
	Teff    5904
}

Star	"KOI-1963/KIC 10917681"
{
	RA      19.37383013
	Dec     48.357182
	AppMagn 14.107
	MassSol 1.005
	RadSol  0.923
	Teff    6072
}

Star	"KOI-1964/KIC 7887791"
{
	RA      19.380247
	Dec     43.607208
	AppMagn 10.687
	MassSol 0.871
	RadSol  0.989
	Teff    5547
}

Star	"KOI-1968/KIC 7948784"
{
	RA      19.1574178
	Dec     43.738781
	AppMagn 15.079
	MassSol 1.213
	RadSol  1.137
	Teff    6343
}

Star	"KOI-1969/KIC 9244756"
{
	RA      20.02783407
	Dec     45.605518
	AppMagn 15.017
	MassSol 0.902
	RadSol  0.821
	Teff    5637
}

Star	"KOI-1974/KIC 7289577"
{
	RA      19.60559487
	Dec     42.809589
	AppMagn 14.937
	MassSol 0.843
	RadSol  0.771
	Teff    5508
}

Star	"KOI-198/KIC 10666242"
{
	RA      19.47321573
	Dec     47.940819
	AppMagn 14.288
	MassSol 1.054
	RadSol  0.955
	Teff    5671
}

Star	"KOI-1982/KIC 6862721"
{
	RA      19.4474304
	Dec     42.341499
	AppMagn 15.768
	MassSol 1.043
	RadSol  0.943
	Teff    5553
}

Star	"KOI-1984/KIC 10094670"
{
	RA      19.8995524
	Dec     47.013039
	AppMagn 13.698
	MassSol 1.195
	RadSol  1.145
	Teff    6215
}

Star	"KOI-1985/KIC 8142942"
{
	RA      18.7284078
	Dec     44.087929
	AppMagn 13.708
	MassSol 0.788
	RadSol  0.829
	Teff    5006
}

Star	"KOI-1995/KIC 5942093"
{
	RA      18.99163613
	Dec     41.203651
	AppMagn 15.264
	MassSol 0.811
	RadSol  0.859
	Teff    5830
}

Star	"KOI-2001/KIC 6061773"
{
	RA      19.80140587
	Dec     41.377171
	AppMagn 13.115
	MassSol 0.887
	RadSol  1.781
	Teff    5129
}

Star	"KOI-2009/KIC 2449431"
{
	RA      19.5182658
	Dec     37.797691
	AppMagn 13.82
	MassSol 0.804
	RadSol  0.887
	Teff    5830
}

Star	"KOI-2014/KIC 6707908"
{
	RA      19.73669433
	Dec     42.113239
	AppMagn 15.601
	MassSol 0.963
	RadSol  0.884
	Teff    5708
}

Star	"KOI-2023/KIC 8578780"
{
	RA      19.86361087
	Dec     44.66748
	AppMagn 15.15
	MassSol 0.887
	RadSol  0.974
	Teff    5442
}

Star	"KOI-2037/KIC 9634821"
{
	RA      18.95618287
	Dec     46.316551
	AppMagn 15.213
	MassSol 0.847
	RadSol  0.93
	Teff    5029
}

Star	"KOI-2040/KIC 10480915"
{
	RA      19.71947833
	Dec     47.600101
	AppMagn 14.18
	MassSol 0.916
	RadSol  0.889
	Teff    5971
}

Star	"KOI-2042/KIC 9111849"
{
	RA      19.91667887
	Dec     45.4664
	AppMagn 13.089
	MassSol 1.441
	RadSol  2.403
	Teff    6628
}

Star	"KOI-2043/KIC 3448130"
{
	RA      19.50585327
	Dec     38.52203
	AppMagn 14.087
	MassSol 1.055
	RadSol  0.973
	Teff    6032
}

Star	"KOI-2052/KIC 3248501"
{
	RA      19.64651487
	Dec     38.364159
	AppMagn 15.341
	MassSol 1.221
	RadSol  1.144
	Teff    6362
}

Star	"KOI-2056/KIC 10134152"
{
	RA      19.2709554
	Dec     47.11742
	AppMagn 14.476
	MassSol 1.008
	RadSol  0.925
	Teff    6060
}

Star	"KOI-2060/KIC 9279354"
{
	RA      19.41495567
	Dec     45.778091
	AppMagn 15.229
	MassSol 0.686
	RadSol  0.704
	Teff    4786
}

Star	"KOI-2061/KIC 12061969"
{
	RA      19.44396767
	Dec     50.583881
	AppMagn 15.753
	MassSol 0.856
	RadSol  0.784
	Teff    5093
}

Star	"KOI-2064/KIC 2579043"
{
	RA      19.4756836
	Dec     37.889622
	AppMagn 14.959
	MassSol 1.07
	RadSol  1.098
	Teff    6302
}

Star	"KOI-2065/KIC 6342333"
{
	RA      18.857546
	Dec     41.79668
	AppMagn 14.32
	MassSol 0.939
	RadSol  0.893
	Teff    5685
}

Star	"KOI-2066/KIC 3239671"
{
	RA      19.5061096
	Dec     38.399658
	AppMagn 14.904
	MassSol 0.961
	RadSol  0.875
	Teff    6008
}

Star	"KOI-2081/KIC 2853780"
{
	RA      19.4486104
	Dec     38.070019
	AppMagn 13.439
	MassSol 1.501
	RadSol  3.152
	Teff    5295
}

Star	"KOI-2082/KIC 9472000"
{
	RA      19.637795
	Dec     46.075802
	AppMagn 14.143
	MassSol 1.132
	RadSol  1.03
	Teff    6108
}

Star	"KOI-2083/KIC 7097965"
{
	RA      18.96602173
	Dec     42.648289
	AppMagn 13.516
	MassSol 0.972
	RadSol  1.168
	Teff    6218
}

Star	"KOI-2084/KIC 3967326"
{
	RA      19.6560018
	Dec     39.085991
	AppMagn 15.168
	MassSol 0.878
	RadSol  1.005
	Teff    5229
}

Star	"KOI-2091/KIC 5705819"
{
	RA      19.46085813
	Dec     40.953892
	AppMagn 15.789
	MassSol 0.845
	RadSol  0.765
	Teff    5189
}

Star	"KOI-2093/KIC 6525946"
{
	RA      19.53027753
	Dec     41.934799
	AppMagn 15.357
	MassSol 1.136
	RadSol  1.118
	Teff    6487
}

Star	"KOI-2096/KIC 9307509"
{
	RA      20.04131267
	Dec     45.788921
	AppMagn 15.246
	MassSol 0.773
	RadSol  0.816
	Teff    5052
}

Star	"KOI-2106/KIC 12017109"
{
	RA      19.5933716
	Dec     50.427052
	AppMagn 15.158
	MassSol 0.996
	RadSol  0.899
	Teff    5806
}

Star	"KOI-211/KIC 10656508"
{
	RA      19.1980204
	Dec     47.972099
	AppMagn 14.989
	MassSol 1.213
	RadSol  1.137
	Teff    6343
}

Star	"KOI-2117/KIC 4140813"
{
	RA      19.09862267
	Dec     39.269958
	AppMagn 15.637
	MassSol 0.76
	RadSol  0.706
	Teff    4491
}

Star	"KOI-212/KIC 6300348"
{
	RA      19.7426534
	Dec     41.60318
	AppMagn 14.858
	MassSol 1.013
	RadSol  0.94
	Teff    6106
}

Star	"KOI-2120/KIC 4857213"
{
	RA      19.8049764
	Dec     39.933849
	AppMagn 13.714
	MassSol 0.832
	RadSol  0.905
	Teff    5146
}

Star	"KOI-2123/KIC 8591693"
{
	RA      20.1028646
	Dec     44.60561
	AppMagn 14.385
	MassSol 1.018
	RadSol  0.949
	Teff    6036
}

Star	"KOI-2124/KIC 11462341"
{
	RA      19.68590293
	Dec     49.379791
	AppMagn 14.275
	MassSol 0.559
	RadSol  0.548
	Teff    4029
}

Star	"KOI-2125/KIC 9405595"
{
	RA      19.4976196
	Dec     45.968288
	AppMagn 15.347
	MassSol 1.069
	RadSol  1.009
	Teff    6244
}

Star	"KOI-2128/KIC 7019489"
{
	RA      19.1296102
	Dec     42.580631
	AppMagn 15.962
	MassSol 0.903
	RadSol  0.805
	Teff    5478
}

Star	"KOI-2130/KIC 2161536"
{
	RA      19.44841307
	Dec     37.5289
	AppMagn 15.661
	MassSol 0.568
	RadSol  0.565
	Teff    3972
}

Star	"KOI-2132/KIC 9661979"
{
	RA      19.77981773
	Dec     46.371712
	AppMagn 14.552
	MassSol 0.724
	RadSol  0.759
	Teff    5509
}

Star	"KOI-2150/KIC 3229150"
{
	RA      19.32285767
	Dec     38.309601
	AppMagn 15.253
	MassSol 1.028
	RadSol  0.938
	Teff    5942
}

Star	"KOI-2154/KIC 12505076"
{
	RA      19.220579
	Dec     51.478291
	AppMagn 15.844
	MassSol 1.016
	RadSol  0.921
	Teff    5831
}

Star	"KOI-2158/KIC 5211199"
{
	RA      19.84342853
	Dec     40.352551
	AppMagn 13.052
	MassSol 0.896
	RadSol  1.46
	Teff    5445
}

Star	"KOI-2159/KIC 8804455"
{
	RA      19.0092204
	Dec     45.004539
	AppMagn 13.482
	MassSol 0.956
	RadSol  1.045
	Teff    5713
}

Star	"KOI-2172/KIC 4173026"
{
	RA      19.67760007
	Dec     39.201408
	AppMagn 15.104
	MassSol 0.936
	RadSol  0.981
	Teff    5738
}

Star	"KOI-2174/KIC 8261920"
{
	RA      20.01614787
	Dec     44.141399
	AppMagn 15.673
	MassSol 0.619
	RadSol  0.608
	Teff    4141
}

Star	"KOI-2181/KIC 8591173"
{
	RA      20.08952433
	Dec     44.672211
	AppMagn 14.414
	MassSol 0.929
	RadSol  1.671
	Teff    5109
}

Star	"KOI-2184/KIC 12885212"
{
	RA      19.3450012
	Dec     52.220341
	AppMagn 15.504
	MassSol 0.717
	RadSol  0.653
	Teff    4893
}

Star	"KOI-2186/KIC 3097926"
{
	RA      19.0605652
	Dec     38.212719
	AppMagn 15.549
	MassSol 0.803
	RadSol  0.853
	Teff    5062
}

Star	"KOI-2188/KIC 10518424"
{
	RA      18.916923
	Dec     47.796951
	AppMagn 15.319
	MassSol 0.974
	RadSol  0.923
	Teff    6106
}

Star	"KOI-2189/KIC 5730445"
{
	RA      19.8716492
	Dec     40.94899
	AppMagn 15.253
	MassSol 0.763
	RadSol  0.799
	Teff    5009
}

Star	"KOI-2191/KIC 5601258"
{
	RA      19.00576987
	Dec     40.898998
	AppMagn 14.911
	MassSol 0.471
	RadSol  0.46
	Teff    3724
}

Star	"KOI-2199/KIC 11705004"
{
	RA      19.16900227
	Dec     49.801659
	AppMagn 15.901
	MassSol 0.884
	RadSol  0.788
	Teff    5311
}

Star	"KOI-2201/KIC 2141783"
{
	RA      19.091333
	Dec     37.552521
	AppMagn 13.806
	MassSol 0.951
	RadSol  1.14
	Teff    6063
}

Star	"KOI-2204/KIC 8494542"
{
	RA      19.4366272
	Dec     44.52729
	AppMagn 13.957
	MassSol 1.087
	RadSol  1.496
	Teff    6455
}

Star	"KOI-2206/KIC 11073656"
{
	RA      19.06453453
	Dec     48.67905
	AppMagn 15.198
	MassSol 0.962
	RadSol  0.958
	Teff    5751
}

Star	"KOI-2215/KIC 7050060"
{
	RA      19.75033773
	Dec     42.53022
	AppMagn 12.999
	MassSol 0.953
	RadSol  1.26
	Teff    5974
}

Star	"KOI-2216/KIC 4248120"
{
	RA      19.15283407
	Dec     39.383221
	AppMagn 15.23
	MassSol 0.773
	RadSol  0.892
	Teff    5530
}

Star	"KOI-2217/KIC 9580992"
{
	RA      19.24283447
	Dec     46.21566
	AppMagn 15.191
	MassSol 0.912
	RadSol  0.819
	Teff    5329
}

Star	"KOI-2219/KIC 5357545"
{
	RA      19.35102333
	Dec     40.548649
	AppMagn 14.099
	MassSol 0.788
	RadSol  0.738
	Teff    5003
}

Star	"KOI-2222/KIC 9289704"
{
	RA      19.68315633
	Dec     45.757401
	AppMagn 12.963
	MassSol 2.607
	RadSol  5.555
	Teff    7818
}

Star	"KOI-2226/KIC 11520459"
{
	RA      19.83502807
	Dec     49.401451
	AppMagn 15.338
	MassSol 0.896
	RadSol  0.887
	Teff    5427
}

Star	"KOI-2229/KIC 4473226"
{
	RA      19.59890547
	Dec     39.57288
	AppMagn 15.707
	MassSol 0.926
	RadSol  0.942
	Teff    5776
}

Star	"KOI-2232/KIC 2854181"
{
	RA      19.45420127
	Dec     38.088181
	AppMagn 15.331
	MassSol 0.988
	RadSol  0.939
	Teff    5783
}

Star	"KOI-2237/KIC 5005121"
{
	RA      19.331956
	Dec     40.14283
	AppMagn 15.165
	MassSol 1.045
	RadSol  0.967
	Teff    6091
}

Star	"KOI-2241/KIC 5125347"
{
	RA      19.87230227
	Dec     40.283249
	AppMagn 15.302
	MassSol 1.162
	RadSol  1.103
	Teff    6174
}

Star	"KOI-2248/KIC 11030475"
{
	RA      19.48266193
	Dec     48.51157
	AppMagn 15.498
	MassSol 0.821
	RadSol  0.746
	Teff    5290
}

Star	"KOI-225/KIC 5801571"
{
	RA      19.66088667
	Dec     41.074711
	AppMagn 14.784
	MassSol 0.997
	RadSol  0.927
	Teff    6253
}

Star	"KOI-2250/KIC 5942808"
{
	RA      19.014445
	Dec     41.282429
	AppMagn 15.622
	MassSol 0.79
	RadSol  0.823
	Teff    4922
}

Star	"KOI-2259/KIC 8126558"
{
	RA      20.0113668
	Dec     43.98497
	AppMagn 15.364
	MassSol 0.856
	RadSol  0.967
	Teff    5516
}

Star	"KOI-2269/KIC 11774303"
{
	RA      19.8013102
	Dec     49.997379
	AppMagn 15.177
	MassSol 1.332
	RadSol  1.278
	Teff    6517
}

Star	"KOI-227/KIC 6185476"
{
	RA      18.95680133
	Dec     41.519199
	AppMagn 14.267
	MassSol 0.49
	RadSol  0.47
	Teff    3745
}

Star	"KOI-2272/KIC 9654875"
{
	RA      19.61024373
	Dec     46.309681
	AppMagn 12.783
	MassSol 1.754
	RadSol  2.389
	Teff    7495
}

Star	"KOI-2283/KIC 10206675"
{
	RA      19.42516273
	Dec     47.21257
	AppMagn 15.245
	MassSol 0.595
	RadSol  0.578
	Teff    3990
}

Star	"KOI-2288/KIC 3440978"
{
	RA      19.3802002
	Dec     38.567032
	AppMagn 15.469
	MassSol 0.721
	RadSol  0.771
	Teff    5250
}

Star	"KOI-2290/KIC 12121570"
{
	RA      19.79006753
	Dec     50.698929
	AppMagn 14.447
	MassSol 0.799
	RadSol  0.716
	Teff    5120
}

Star	"KOI-2291/KIC 8410415"
{
	RA      18.80221967
	Dec     44.478008
	AppMagn 15.115
	MassSol 0.801
	RadSol  0.736
	Teff    5465
}

Star	"KOI-2293/KIC 8321314"
{
	RA      19.8966756
	Dec     44.284012
	AppMagn 14.837
	MassSol 0.909
	RadSol  1.018
	Teff    5522
}

Star	"KOI-2294/KIC 6934986"
{
	RA      19.14354653
	Dec     42.421612
	AppMagn 14.895
	MassSol 1.061
	RadSol  0.977
	Teff    6004
}

Star	"KOI-2295/KIC 4049901"
{
	RA      19.303009
	Dec     39.164429
	AppMagn 11.671
	MassSol 0.793
	RadSol  0.883
	Teff    5451
}

Star	"KOI-2297/KIC 5342473"
{
	RA      18.9552348
	Dec     40.568909
	AppMagn 14.338
	MassSol 1.021
	RadSol  1.129
	Teff    6047
}

Star	"KOI-2299/KIC 9963265"
{
	RA      19.7706706
	Dec     46.857479
	AppMagn 15.315
	MassSol 1.163
	RadSol  1.061
	Teff    6065
}

Star	"KOI-2305/KIC 10874215"
{
	RA      19.7808492
	Dec     48.272308
	AppMagn 15.728
	MassSol 1.047
	RadSol  0.931
	Teff    5841
}

Star	"KOI-2306/KIC 6666233"
{
	RA      18.81895953
	Dec     42.15419
	AppMagn 14.78
	MassSol 0.524
	RadSol  0.52
	Teff    3878
}

Star	"KOI-2307/KIC 7661065"
{
	RA      18.80994873
	Dec     43.37859
	AppMagn 14.854
	MassSol 0.895
	RadSol  0.823
	Teff    5523
}

Star	"KOI-2310/KIC 11718144"
{
	RA      19.63503013
	Dec     49.872471
	AppMagn 14.64
	MassSol 0.973
	RadSol  0.877
	Teff    5815
}

Star	"KOI-2312/KIC 10026544"
{
	RA      19.8188782
	Dec     46.90453
	AppMagn 12.982
	MassSol 1.166
	RadSol  2.251
	Teff    6146
}

Star	"KOI-2315/KIC 6062929"
{
	RA      19.8190328
	Dec     41.305592
	AppMagn 15.571
	MassSol 0.759
	RadSol  0.692
	Teff    5180
}

Star	"KOI-2319/KIC 9003401"
{
	RA      18.91698813
	Dec     45.335178
	AppMagn 13.355
	MassSol 1.125
	RadSol  1.229
	Teff    6483
}

Star	"KOI-2321/KIC 5978559"
{
	RA      19.780483
	Dec     41.203651
	AppMagn 14.71
	MassSol 1.074
	RadSol  1.102
	Teff    6289
}

Star	"KOI-2323/KIC 8872048"
{
	RA      19.07146807
	Dec     45.136711
	AppMagn 15.484
}

Star	"KOI-2324/KIC 7746958"
{
	RA      19.31185707
	Dec     43.458134
	AppMagn 11.671
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-2325/KIC 7120108"
{
	RA      19.5009318
	Dec     42.65176
	AppMagn 14.413
	MassSol 0.754
	RadSol  0.791
	Teff    5035
}

Star	"KOI-2329/KIC 11192235"
{
	RA      19.5179952
	Dec     48.89962
	AppMagn 15.655
	MassSol 0.505
	RadSol  0.498
	Teff    3815
}

Star	"KOI-2332/KIC 5534941"
{
	RA      19.48349813
	Dec     40.792721
	AppMagn 13.024
	MassSol 0.839
	RadSol  1.671
	Teff    5387
}

Star	"KOI-2343/KIC 6119141"
{
	RA      19.35834147
	Dec     41.43375
	AppMagn 14.409
	MassSol 0.928
	RadSol  1.042
	Teff    5799
}

Star	"KOI-2351/KIC 1872821"
{
	RA      19.49517213
	Dec     37.320808
	AppMagn 14.909
	MassSol 0.943
	RadSol  0.856
	Teff    5718
}

Star	"KOI-2353/KIC 12505654"
{
	RA      19.24429933
	Dec     51.498421
	AppMagn 14.988
	MassSol 0.869
	RadSol  0.781
	Teff    5231
}

Star	"KOI-2354/KIC 7215678"
{
	RA      19.73775027
	Dec     42.768219
	AppMagn 14.519
	MassSol 1.003
	RadSol  0.921
	Teff    6086
}

Star	"KOI-2357/KIC 7449554"
{
	RA      19.54691773
	Dec     43.057011
	AppMagn 15.61
	MassSol 0.967
	RadSol  0.879
	Teff    5982
}

Star	"KOI-2358/KIC 5716932"
{
	RA      19.67593993
	Dec     40.979061
	AppMagn 13.524
	MassSol 1.084
	RadSol  1.04
	Teff    6412
}

Star	"KOI-2361/KIC 11566256"
{
	RA      19.68683673
	Dec     49.589119
	AppMagn 15.049
	MassSol 1.117
	RadSol  1.012
	Teff    6063
}

Star	"KOI-2363/KIC 7987866"
{
	RA      19.99012247
	Dec     43.732182
	AppMagn 14.364
	MassSol 0.684
	RadSol  0.722
	Teff    5242
}

Star	"KOI-2364/KIC 9532710"
{
	RA      19.625647
	Dec     46.157841
	AppMagn 15.83
	MassSol 0.813
	RadSol  1.829
	Teff    5383
}

Star	"KOI-2367/KIC 9086251"
{
	RA      19.39142453
	Dec     45.410301
	AppMagn 12.618
	MassSol 1.145
	RadSol  1.37
	Teff    6047
}

Star	"KOI-2370/KIC 5385304"
{
	RA      19.83721313
	Dec     40.541309
	AppMagn 13.003
	MassSol 1.351
	RadSol  1.505
	Teff    6735
}

Star	"KOI-2373/KIC 10798331"
{
	RA      19.48764447
	Dec     48.140461
	AppMagn 14.685
	MassSol 0.874
	RadSol  0.828
	Teff    5593
}

Star	"KOI-2377/KIC 5906426"
{
	RA      19.9528178
	Dec     41.15308
	AppMagn 14.782
	MassSol 0.817
	RadSol  0.819
	Teff    5261
}

Star	"KOI-2379/KIC 9718379"
{
	RA      19.67105507
	Dec     46.466389
	AppMagn 15.04
	MassSol 0.964
	RadSol  1.023
	Teff    6237
}

Star	"KOI-2380/KIC 3002478"
{
	RA      19.61237387
	Dec     38.108669
	AppMagn 14.216
	MassSol 1.047
	RadSol  0.96
	Teff    5982
}

Star	"KOI-2386/KIC 4172013"
{
	RA      19.66267293
	Dec     39.232571
	AppMagn 14.94
	MassSol 0.843
	RadSol  0.765
	Teff    5811
}

Star	"KOI-2393/KIC 4665571"
{
	RA      19.64431353
	Dec     39.783829
	AppMagn 14.903
	MassSol 0.716
	RadSol  0.701
	Teff    4894
}

Star	"KOI-2396/KIC 12115188"
{
	RA      19.5981852
	Dec     50.645142
	AppMagn 14.672
	MassSol 0.945
	RadSol  0.936
	Teff    5529
}

Star	"KOI-2398/KIC 6199056"
{
	RA      19.32928467
	Dec     41.502659
	AppMagn 13.579
	MassSol 1.08
	RadSol  1.415
	Teff    6514
}

Star	"KOI-2400/KIC 7984574"
{
	RA      19.93744507
	Dec     43.720329
	AppMagn 15.664
	MassSol 0.926
	RadSol  0.84
	Teff    5876
}

Star	"KOI-2401/KIC 10336951"
{
	RA      19.38908487
	Dec     47.444939
	AppMagn 14.847
	MassSol 0.592
	RadSol  0.598
	Teff    4544
}

Star	"KOI-2404/KIC 6364215"
{
	RA      19.45853273
	Dec     41.769581
	AppMagn 15.656
	MassSol 0.974
	RadSol  0.918
	Teff    5815
}

Star	"KOI-2410/KIC 8676038"
{
	RA      19.04953207
	Dec     44.85783
	AppMagn 15.141
}

Star	"KOI-2411/KIC 8073806"
{
	RA      18.68765867
	Dec     43.98571
	AppMagn 15.361
	MassSol 0.922
	RadSol  0.961
	Teff    5903
}

Star	"KOI-2415/KIC 5621586"
{
	RA      19.487675
	Dec     40.838821
	AppMagn 15.659
	MassSol 1.053
	RadSol  0.987
	Teff    6123
}

Star	"KOI-2416/KIC 9210387"
{
	RA      19.2138428
	Dec     45.683479
	AppMagn 15.466
	MassSol 1.049
	RadSol  0.961
	Teff    5966
}

Star	"KOI-2417/KIC 9654468"
{
	RA      19.60036213
	Dec     46.310692
	AppMagn 16.22
	MassSol 0.672
	RadSol  0.666
	Teff    4505
}

Star	"KOI-2421/KIC 8838950"
{
	RA      19.8946208
	Dec     45.071442
	AppMagn 14.363
	MassSol 0.534
	RadSol  0.528
	Teff    4671
}

Star	"KOI-2430/KIC 3533469"
{
	RA      19.20707193
	Dec     38.659061
	AppMagn 14.338
	MassSol 0.912
	RadSol  0.985
	Teff    5495
}

Star	"KOI-2445/KIC 6516185"
{
	RA      19.32563067
	Dec     41.906551
	AppMagn 15.817
	MassSol 0.902
	RadSol  0.902
	Teff    5708
}

Star	"KOI-2449/KIC 12208631"
{
	RA      19.43670047
	Dec     50.825611
	AppMagn 15.114
	MassSol 1.033
	RadSol  0.941
	Teff    5893
}

Star	"KOI-2451/KIC 6500206"
{
	RA      18.8785868
	Dec     41.989922
	AppMagn 14.738
	MassSol 0.91
	RadSol  0.978
	Teff    5410
}

Star	"KOI-2453/KIC 8631751"
{
	RA      19.63123167
	Dec     44.75396
	AppMagn 15.63
	MassSol 0.422
	RadSol  0.4
	Teff    3565
}

Star	"KOI-2462/KIC 5042210"
{
	RA      19.93277993
	Dec     40.142422
	AppMagn 11.821
	MassSol 1.082
	RadSol  1.257
	Teff    6006
}

Star	"KOI-2467/KIC 11818607"
{
	RA      19.6149638
	Dec     50.075588
	AppMagn 14.63
	MassSol 1.03
	RadSol  0.939
	Teff    5926
}

Star	"KOI-2469/KIC 6149910"
{
	RA      19.9063212
	Dec     41.43594
	AppMagn 15.048
	MassSol 0.704
	RadSol  0.644
	Teff    4696
}

Star	"KOI-247/KIC 11852982"
{
	RA      18.9999064
	Dec     50.14679
	AppMagn 14.216
	MassSol 0.51
	RadSol  0.49
	Teff    3741
}

Star	"KOI-2470/KIC 9108085"
{
	RA      19.85243127
	Dec     45.41748
	AppMagn 13.655
	MassSol 0.969
	RadSol  0.872
	Teff    5737
}

Star	"KOI-2471/KIC 5436013"
{
	RA      19.1804586
	Dec     40.685242
	AppMagn 14.556
	MassSol 0.821
	RadSol  0.906
	Teff    5506
}

Star	"KOI-2474/KIC 8240617"
{
	RA      19.6264994
	Dec     44.124199
	AppMagn 14.182
	MassSol 0.804
	RadSol  0.797
	Teff    5592
}

Star	"KOI-2477/KIC 6846911"
{
	RA      19.0834432
	Dec     42.378479
	AppMagn 14.729
	MassSol 1.057
	RadSol  1.131
	Teff    5970
}

Star	"KOI-2479/KIC 5963582"
{
	RA      19.5256856
	Dec     41.27924
	AppMagn 12.939
	MassSol 0.932
	RadSol  1.677
	Teff    5491
}

Star	"KOI-2480/KIC 8189801"
{
	RA      19.92842613
	Dec     44.00219
	AppMagn 15.745
	MassSol 0.554
	RadSol  0.554
	Teff    3990
}

Star	"KOI-2481/KIC 4476423"
{
	RA      19.6521566
	Dec     39.596519
	AppMagn 13.605
	MassSol 1.616
	RadSol  10.472
	Teff    4553
}

Star	"KOI-2486/KIC 8074328"
{
	RA      18.71269733
	Dec     43.919182
	AppMagn 13.047
	MassSol 1.048
	RadSol  1.237
	Teff    6395
}

Star	"KOI-2489/KIC 2718778"
{
	RA      19.51269327
	Dec     37.93457
	AppMagn 15.708
	MassSol 0.941
	RadSol  0.851
	Teff    5787
}

Star	"KOI-2490/KIC 3122913"
{
	RA      19.52677407
	Dec     38.297081
	AppMagn 15.701
	MassSol 0.786
	RadSol  0.707
	Teff    4960
}

Star	"KOI-2503/KIC 8631504"
{
	RA      19.62607013
	Dec     44.762959
	AppMagn 14.146
	MassSol 0.779
	RadSol  0.741
	Teff    4832
}

Star	"KOI-2504/KIC 8110767"
{
	RA      19.7458862
	Dec     43.936852
	AppMagn 15.93
	MassSol 1.038
	RadSol  0.923
	Teff    5681
}

Star	"KOI-2507/KIC 8379705"
{
	RA      19.77342733
	Dec     44.32526
	AppMagn 15.859
	MassSol 1.041
	RadSol  0.964
	Teff    6122
}

Star	"KOI-2508/KIC 8836888"
{
	RA      19.86049193
	Dec     45.03231
	AppMagn 15.164
	MassSol 0.868
	RadSol  0.794
	Teff    5494
}

Star	"KOI-2512/KIC 9574158"
{
	RA      18.98132527
	Dec     46.25079
	AppMagn 15.523
	MassSol 0.899
	RadSol  0.824
	Teff    5583
}

Star	"KOI-2513/KIC 9653622"
{
	RA      19.5779236
	Dec     46.37925
	AppMagn 14.839
	MassSol 1.032
	RadSol  1.036
	Teff    6347
}

Star	"KOI-2516/KIC 7294743"
{
	RA      19.6969116
	Dec     42.858799
	AppMagn 13.388
	MassSol 0.98
	RadSol  1.704
	Teff    5473
}

Star	"KOI-2519/KIC 4047631"
{
	RA      19.26026
	Dec     39.154209
	AppMagn 14.452
	MassSol 0.548
	RadSol  0.524
	Teff    4329
}

Star	"KOI-252/KIC 11187837"
{
	RA      19.36009927
	Dec     48.82259
	AppMagn 15.613
	MassSol 0.51
	RadSol  0.49
	Teff    3743
}

Star	"KOI-2522/KIC 9177629"
{
	RA      19.9587728
	Dec     45.592239
	AppMagn 13.713
	MassSol 0.953
	RadSol  1.636
	Teff    4991
}

Star	"KOI-2525/KIC 5942949"
{
	RA      19.01946207
	Dec     41.255692
	AppMagn 15.699
	MassSol 0.709
	RadSol  0.729
	Teff    4806
}

Star	"KOI-2527/KIC 7879433"
{
	RA      19.14284667
	Dec     43.616051
	AppMagn 14.131
	MassSol 0.593
	RadSol  0.587
	Teff    4189
}

Star	"KOI-2528/KIC 9205907"
{
	RA      19.0449178
	Dec     45.639858
	AppMagn 15.646
	MassSol 0.967
	RadSol  0.879
	Teff    5982
}

Star	"KOI-253/KIC 11752906"
{
	RA      19.0382894
	Dec     49.962269
	AppMagn 15.254
	MassSol 0.59
	RadSol  0.56
	Teff    3769
}

Star	"KOI-2531/KIC 4172746"
{
	RA      19.67359413
	Dec     39.268749
	AppMagn 15.44
	MassSol 0.769
	RadSol  0.736
	Teff    4805
}

Star	"KOI-2532/KIC 5174858"
{
	RA      19.2019796
	Dec     40.344151
	AppMagn 15.43
	MassSol 0.927
	RadSol  0.826
	Teff    5237
}

Star	"KOI-2535/KIC 9635606"
{
	RA      18.983195
	Dec     46.373619
	AppMagn 14.985
	MassSol 0.707
	RadSol  0.732
	Teff    4930
}

Star	"KOI-2538/KIC 1849702"
{
	RA      19.08573
	Dec     37.387058
	AppMagn 14.125
	MassSol 0.708
	RadSol  0.647
	Teff    5106
}

Star	"KOI-2542/KIC 6183511"
{
	RA      18.89346313
	Dec     41.516331
	AppMagn 15.527
	MassSol 0.275
	RadSol  0.288
	Teff    3339
}

Star	"KOI-2543/KIC 12469800"
{
	RA      19.72728067
	Dec     51.347939
	AppMagn 15.351
	MassSol 0.653
	RadSol  0.674
	Teff    5014
}

Star	"KOI-2547/KIC 4484336"
{
	RA      19.76371667
	Dec     39.598591
	AppMagn 14.169
	MassSol 0.873
	RadSol  1.005
	Teff    6074
}

Star	"KOI-2548/KIC 9580167"
{
	RA      19.21213173
	Dec     46.246181
	AppMagn 14.992
	MassSol 0.745
	RadSol  0.705
	Teff    4865
}

Star	"KOI-2550/KIC 11622985"
{
	RA      19.81601153
	Dec     49.616859
	AppMagn 15.419
	MassSol 0.999
	RadSol  0.91
	Teff    5955
}

Star	"KOI-2551/KIC 11361283"
{
	RA      19.78153687
	Dec     49.106659
	AppMagn 15.846
	MassSol 0.779
	RadSol  0.73
	Teff    4911
}

Star	"KOI-2553/KIC 9832208"
{
	RA      19.48716227
	Dec     46.62664
	AppMagn 15.639
	MassSol 0.839
	RadSol  0.751
	Teff    5126
}

Star	"KOI-2554/KIC 10471621"
{
	RA      19.49198607
	Dec     47.644611
	AppMagn 15.439
	MassSol 0.514
	RadSol  0.51
	Teff    4401
}

Star	"KOI-2559/KIC 6605493"
{
	RA      19.44045
	Dec     42.035919
	AppMagn 13.799
	MassSol 0.996
	RadSol  1.101
	Teff    5806
}

Star	"KOI-256/KIC 11548140"
{
	RA      19.01234133
	Dec     49.565369
	AppMagn 15.373
	MassSol 0.43
	RadSol  0.42
	Teff    3450
}

Star	"KOI-2560/KIC 4670217"
{
	RA      19.713678
	Dec     39.75684
	AppMagn 15.486
	MassSol 0.75
	RadSol  0.774
	Teff    4905
}

Star	"KOI-2569/KIC 8247770"
{
	RA      19.77353313
	Dec     44.14082
	AppMagn 14.273
	MassSol 0.991
	RadSol  1.092
	Teff    5730
}

Star	"KOI-2571/KIC 6867588"
{
	RA      19.54247027
	Dec     42.350479
	AppMagn 14.434
	MassSol 0.86
	RadSol  0.781
	Teff    5203
}

Star	"KOI-2572/KIC 7501646"
{
	RA      18.77282307
	Dec     43.177879
	AppMagn 15.522
	MassSol 1.079
	RadSol  0.966
	Teff    5672
}

Star	"KOI-2573/KIC 8256453"
{
	RA      19.9185038
	Dec     44.119942
	AppMagn 15.894
	MassSol 0.658
	RadSol  0.685
	Teff    5316
}

Star	"KOI-2577/KIC 12257999"
{
	RA      19.41918133
	Dec     50.909149
	AppMagn 13.506
	MassSol 1.287
	RadSol  1.332
	Teff    6810
}

Star	"KOI-2578/KIC 6922203"
{
	RA      18.75067547
	Dec     42.40329
	AppMagn 14.847
	MassSol 0.976
	RadSol  1.039
	Teff    5991
}

Star	"KOI-2579/KIC 9896018"
{
	RA      19.5992472
	Dec     46.718021
	AppMagn 15.147
	MassSol 1.025
	RadSol  1.068
	Teff    6190
}

Star	"KOI-2581/KIC 11818872"
{
	RA      19.6233948
	Dec     50.081089
	AppMagn 13.463
	MassSol 0.971
	RadSol  0.87
	Teff    5650
}

Star	"KOI-2582/KIC 11771430"
{
	RA      19.7231018
	Dec     49.936131
	AppMagn 13.628
	MassSol 1.158
	RadSol  1.364
	Teff    5857
}

Star	"KOI-2583/KIC 10387742"
{
	RA      18.89527387
	Dec     47.59251
	AppMagn 12.623
	MassSol 0.874
	RadSol  0.881
	Teff    5725
}

Star	"KOI-2588/KIC 12156347"
{
	RA      19.31618447
	Dec     50.787041
	AppMagn 15.484
	MassSol 0.565
	RadSol  0.553
	Teff    4024
}

Star	"KOI-2590/KIC 12016267"
{
	RA      19.5671346
	Dec     50.450119
	AppMagn 11.638
	MassSol 1.204
	RadSol  1.655
	Teff    6440
}

Star	"KOI-2592/KIC 6765135"
{
	RA      19.18348593
	Dec     42.244781
	AppMagn 15.054
	MassSol 1.072
	RadSol  1.009
	Teff    6208
}

Star	"KOI-2598/KIC 7446631"
{
	RA      19.4882792
	Dec     43.033451
	AppMagn 14.162
	MassSol 1.069
	RadSol  1.008
	Teff    6049
}

Star	"KOI-2601/KIC 7531677"
{
	RA      19.53297933
	Dec     43.180672
	AppMagn 13.915
	MassSol 1.159
	RadSol  1.342
	Teff    6407
}

Star	"KOI-2603/KIC 2443393"
{
	RA      19.43050333
	Dec     37.742935
	AppMagn 12.643
	MassSol 1.134
	RadSol  1.336
	Teff    6431
}

Star	"KOI-2604/KIC 9019191"
{
	RA      19.3882914
	Dec     45.355019
	AppMagn 15.323
	MassSol 0.77
	RadSol  0.708
	Teff    4902
}

Star	"KOI-2607/KIC 5095635"
{
	RA      19.37897947
	Dec     40.255451
	AppMagn 14.482
	MassSol 0.985
	RadSol  0.892
	Teff    5883
}

Star	"KOI-2610/KIC 2305866"
{
	RA      19.4728882
	Dec     37.61348
	AppMagn 12.605
	MassSol 1.502
	RadSol  2.517
	Teff    6585
}

Star	"KOI-2612/KIC 9602613"
{
	RA      19.80992227
	Dec     46.296951
	AppMagn 11.83
	MassSol 0.824
	RadSol  0.924
	Teff    5461
}

Star	"KOI-2613/KIC 9712350"
{
	RA      19.513562
	Dec     46.415871
	AppMagn 15.96
	MassSol 0.921
	RadSol  0.814
	Teff    5377
}

Star	"KOI-2620/KIC 11465950"
{
	RA      19.78355913
	Dec     49.378109
	AppMagn 15.869
	MassSol 0.895
	RadSol  0.815
	Teff    5658
}

Star	"KOI-2626/KIC 11768142"
{
	RA      19.62440593
	Dec     49.915058
	AppMagn 15.931
	MassSol 0.359
	RadSol  0.35
	Teff    3482
}

Star	"KOI-2631/KIC 7584650"
{
	RA      18.815979
	Dec     43.244049
	AppMagn 13.468
	MassSol 0.953
	RadSol  1.168
	Teff    6112
}

Star	"KOI-2636/KIC 6198182"
{
	RA      19.31244713
	Dec     41.588928
	AppMagn 12.32
	MassSol 1.177
	RadSol  1.594
	Teff    6130
}

Star	"KOI-2637/KIC 9574179"
{
	RA      18.98192953
	Dec     46.206478
	AppMagn 15.016
	MassSol 1.038
	RadSol  0.955
	Teff    6045
}

Star	"KOI-2638/KIC 6211812"
{
	RA      19.59607747
	Dec     41.5905
	AppMagn 15.55
	MassSol 0.849
	RadSol  0.871
	Teff    5420
}

Star	"KOI-2639/KIC 11391755"
{
	RA      19.02434487
	Dec     49.201561
	AppMagn 15.527
	MassSol 1.049
	RadSol  1.112
	Teff    6133
}

Star	"KOI-2640/KIC 9088780"
{
	RA      19.45398967
	Dec     45.435478
	AppMagn 13.226
}

Star	"KOI-2641/KIC 8894646"
{
	RA      19.66639
	Dec     45.119579
	AppMagn 13.845
	MassSol 0.926
	RadSol  1.082
	Teff    5839
}

Star	"KOI-2656/KIC 8636539"
{
	RA      19.73369547
	Dec     44.71851
	AppMagn 15.024
	MassSol 1.083
	RadSol  1.035
	Teff    6363
}

Star	"KOI-2657/KIC 9283156"
{
	RA      19.51744993
	Dec     45.727242
	AppMagn 12.869
	MassSol 0.828
	RadSol  0.758
	Teff    5511
}

Star	"KOI-2658/KIC 8547429"
{
	RA      19.08164267
	Dec     44.654469
	AppMagn 14.406
	MassSol 1.125
	RadSol  1.024
	Teff    6089
}

Star	"KOI-2659/KIC 8803882"
{
	RA      18.9864624
	Dec     45.099091
	AppMagn 12.998
	MassSol 1.665
	RadSol  3.751
	Teff    5242
}

Star	"KOI-2666/KIC 5342061"
{
	RA      18.94131873
	Dec     40.524281
	AppMagn 15.341
	MassSol 0.814
	RadSol  0.783
	Teff    5691
}

Star	"KOI-2677/KIC 9958387"
{
	RA      19.65051267
	Dec     46.83112
	AppMagn 13.46
	MassSol 1.044
	RadSol  1.123
	Teff    6400
}

Star	"KOI-2679/KIC 6716021"
{
	RA      19.8560832
	Dec     42.118252
	AppMagn 13.455
	MassSol 1.177
	RadSol  1.155
	Teff    6528
}

Star	"KOI-268/KIC 3425851"
{
	RA      19.048586
	Dec     38.506973
	AppMagn 10.56
	MassSol 1.23
	RadSol  1.366
	Teff    6343
}

Star	"KOI-2680/KIC 8326342"
{
	RA      19.98610027
	Dec     44.281231
	AppMagn 14.599
	MassSol 0.793
	RadSol  0.733
	Teff    5433
}

Star	"KOI-2682/KIC 2436378"
{
	RA      19.3427836
	Dec     37.741367
	AppMagn 18.498
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-2683/KIC 7899070"
{
	RA      19.6359558
	Dec     43.60778
	AppMagn 15.5
	MassSol 0.876
	RadSol  0.804
	Teff    5635
}

Star	"KOI-2686/KIC 7826659"
{
	RA      19.55322467
	Dec     43.55587
	AppMagn 13.855
	MassSol 0.681
	RadSol  0.661
	Teff    4628
}

Star	"KOI-2687/KIC 7202957"
{
	RA      19.50767413
	Dec     42.764252
	AppMagn 10.158
	MassSol 1.241
	RadSol  2.014
	Teff    5895
}

Star	"KOI-2689/KIC 10265602"
{
	RA      19.21185913
	Dec     47.36668
	AppMagn 15.548
	MassSol 0.798
	RadSol  0.812
	Teff    5594
}

Star	"KOI-269/KIC 7670943"
{
	RA      19.15638227
	Dec     43.378391
	AppMagn 10.927
	MassSol 1.318
	RadSol  1.447
	Teff    6463
}

Star	"KOI-2690/KIC 5369827"
{
	RA      19.5955648
	Dec     40.59074
	AppMagn 13.461
	MassSol 0.806
	RadSol  0.978
	Teff    5587
}

Star	"KOI-2691/KIC 4552729"
{
	RA      19.27399493
	Dec     39.68539
	AppMagn 14.981
	MassSol 0.724
	RadSol  0.688
	Teff    4728
}

Star	"KOI-2696/KIC 11071200"
{
	RA      18.9610616
	Dec     48.65802
	AppMagn 12.998
	MassSol 1.411
	RadSol  1.666
	Teff    7030
}

Star	"KOI-2700/KIC 8639908"
{
	RA      19.80027778
	Dec     44.77500002
	AppMagn 15.9
	MassSol 0.632
	RadSol  0.574
	Teff    4433
	FeH    -0.2
}

Star	"KOI-2706/KIC 9697131"
{
	RA      19.0051778
	Dec     46.419601
	AppMagn 10.268
	MassSol 1.39
	RadSol  1.9
	Teff    6491
}

Star	"KOI-2712/KIC 11098013"
{
	RA      19.84981893
	Dec     48.694309
	AppMagn 11.125
	MassSol 1.159
	RadSol  1.32
	Teff    6450
}

Star	"KOI-2720/KIC 8176564"
{
	RA      19.6959778
	Dec     44.039162
	AppMagn 10.338
	MassSol 1.19
	RadSol  1.55
	Teff    6109
}

Star	"KOI-2723/KIC 3346154"
{
	RA      19.495166
	Dec     38.472912
	AppMagn 14.575
	MassSol 1.02
	RadSol  0.946
	Teff    5741
}

Star	"KOI-2733/KIC 5953297"
{
	RA      19.30353393
	Dec     41.297852
	AppMagn 14.009
	MassSol 0.949
	RadSol  1.826
	Teff    4897
}

Star	"KOI-2734/KIC 7659389"
{
	RA      18.73661093
	Dec     43.322601
	AppMagn 15.768
	MassSol 0.913
	RadSol  0.885
	Teff    5223
}

Star	"KOI-2735/KIC 9472074"
{
	RA      19.63977053
	Dec     46.048302
	AppMagn 15.6
	MassSol 0.902
	RadSol  0.798
	Teff    5154
}

Star	"KOI-2750/KIC 3663173"
{
	RA      19.7112752
	Dec     38.795841
	AppMagn 15.905
	MassSol 1.249
	RadSol  1.167
	Teff    6299
}

Star	"KOI-2755/KIC 3545135"
{
	RA      19.43828127
	Dec     38.655949
	AppMagn 12.147
	MassSol 0.916
	RadSol  0.999
	Teff    5798
}

Star	"KOI-2757/KIC 6432345"
{
	RA      19.2104472
	Dec     41.877972
	AppMagn 14.607
	MassSol 0.882
	RadSol  0.831
	Teff    5735
}

Star	"KOI-2758/KIC 8703129"
{
	RA      19.78157347
	Dec     44.853142
	AppMagn 11.893
	MassSol 2.122
	RadSol  5.949
	Teff    5177
}

Star	"KOI-2759/KIC 11076400"
{
	RA      19.1817098
	Dec     48.651379
	AppMagn 14.288
	MassSol 0.774
	RadSol  0.809
	Teff    4973
}

Star	"KOI-2760/KIC 7877978"
{
	RA      19.09145307
	Dec     43.691921
	AppMagn 14.889
	MassSol 0.667
	RadSol  0.639
	Teff    4514
}

Star	"KOI-2763/KIC 3834322"
{
	RA      19.06999307
	Dec     38.960201
	AppMagn 15.397
	MassSol 0.758
	RadSol  0.714
	Teff    4787
}

Star	"KOI-2764/KIC 10073672"
{
	RA      19.41543173
	Dec     47.033932
	AppMagn 15.794
	MassSol 0.572
	RadSol  0.55
	Teff    3952
}

Star	"KOI-2770/KIC 10917043"
{
	RA      19.35025633
	Dec     48.360821
	AppMagn 15.558
	MassSol 0.642
	RadSol  0.631
	Teff    4400
}

Star	"KOI-2775/KIC 6346809"
{
	RA      19.0065816
	Dec     41.775921
	AppMagn 14.94
	MassSol 0.819
	RadSol  0.901
	Teff    5653
}

Star	"KOI-2779/KIC 11874577"
{
	RA      19.78485513
	Dec     50.188419
	AppMagn 14.936
	MassSol 0.95
	RadSol  0.851
	Teff    6150
}

Star	"KOI-2795/KIC 5041569"
{
	RA      19.9235738
	Dec     40.131088
	AppMagn 15.273
	MassSol 1.211
	RadSol  1.165
	Teff    6237
}

Star	"KOI-2796/KIC 11246161"
{
	RA      19.52494507
	Dec     48.936569
	AppMagn 14.832
	MassSol 1.072
	RadSol  0.997
	Teff    6108
}

Star	"KOI-2797/KIC 10604521"
{
	RA      19.5789042
	Dec     47.833141
	AppMagn 15.8
	MassSol 1.202
	RadSol  1.108
	Teff    6173
}

Star	"KOI-280/KIC 4141376"
{
	RA      19.1126302
	Dec     39.21191
	AppMagn 11.072
	MassSol 1.032
	RadSol  1.042
	Teff    6134
}

Star	"KOI-2801/KIC 5905822"
{
	RA      19.9440328
	Dec     41.14373
	AppMagn 10.787
	MassSol 1.271
	RadSol  2.166
	Teff    6112
}

Star	"KOI-2802/KIC 5775129"
{
	RA      19.08362833
	Dec     41.02187
	AppMagn 14.919
	MassSol 1.221
	RadSol  1.144
	Teff    6362
}

Star	"KOI-2803/KIC 9898447"
{
	RA      19.65779213
	Dec     46.790562
	AppMagn 12.258
	MassSol 0.902
	RadSol  0.821
	Teff    5637
}

Star	"KOI-2807/KIC 2985587"
{
	RA      19.36533813
	Dec     38.136688
	AppMagn 13.91
	MassSol 1.093
	RadSol  1.224
	Teff    6303
}

Star	"KOI-2813/KIC 11197853"
{
	RA      19.6894816
	Dec     48.856152
	AppMagn 13.586
	MassSol 0.616
	RadSol  0.624
	Teff    5143
}

Star	"KOI-2821/KIC 4249611"
{
	RA      19.18988853
	Dec     39.358429
	AppMagn 15.302
	MassSol 0.892
	RadSol  0.917
	Teff    5648
}

Star	"KOI-2822/KIC 8263545"
{
	RA      20.04882607
	Dec     44.107059
	AppMagn 15.391
	MassSol 0.953
	RadSol  0.863
	Teff    5918
}

Star	"KOI-2829/KIC 6197215"
{
	RA      19.29096067
	Dec     41.53323
	AppMagn 12.824
	MassSol 1.014
	RadSol  1.064
	Teff    5934
}

Star	"KOI-2833/KIC 9109857"
{
	RA      19.88101807
	Dec     45.406891
	AppMagn 12.599
	MassSol 1.15
	RadSol  1.815
	Teff    6085
}

Star	"KOI-2835/KIC 5436338"
{
	RA      19.18842567
	Dec     40.696602
	AppMagn 15.906
	MassSol 0.524
	RadSol  0.53
	Teff    4380
}

Star	"KOI-2840/KIC 6467363"
{
	RA      19.89024047
	Dec     41.820068
	AppMagn 13.884
	MassSol 0.781
	RadSol  0.848
	Teff    5676
}

Star	"KOI-2841/KIC 8758204"
{
	RA      19.57596027
	Dec     44.982529
	AppMagn 15.822
	MassSol 0.911
	RadSol  0.812
	Teff    5418
}

Star	"KOI-2848/KIC 7749773"
{
	RA      19.37760827
	Dec     43.49984
	AppMagn 12.458
	MassSol 1.341
	RadSol  1.961
	Teff    5888
}

Star	"KOI-2849/KIC 10064256"
{
	RA      19.12828573
	Dec     47.053741
	AppMagn 14.52
	MassSol 1.012
	RadSol  0.9
	Teff    5452
}

Star	"KOI-2851/KIC 6697605"
{
	RA      19.57108967
	Dec     42.13258
	AppMagn 15.472
	MassSol 0.923
	RadSol  0.906
	Teff    5485
}

Star	"KOI-2853/KIC 12602314"
{
	RA      19.3622152
	Dec     51.626041
	AppMagn 14.946
	MassSol 0.832
	RadSol  0.83
	Teff    5179
}

Star	"KOI-2855/KIC 4547603"
{
	RA      19.14616493
	Dec     39.626148
	AppMagn 14.456
	MassSol 0.863
	RadSol  0.791
	Teff    5450
}

Star	"KOI-2860/KIC 6606438"
{
	RA      19.46150307
	Dec     42.00256
	AppMagn 15.549
	MassSol 1.086
	RadSol  1.02
	Teff    6194
}

Star	"KOI-2862/KIC 6679295"
{
	RA      19.19657387
	Dec     42.156139
	AppMagn 15.907
	MassSol 0.505
	RadSol  0.494
	Teff    3759
}

Star	"KOI-2867/KIC 9899181"
{
	RA      19.67670087
	Dec     46.772305
	AppMagn 12.912
	MassSol 0.811
	RadSol  0.778
	Teff    4865
}

Star	"KOI-2871/KIC 10793172"
{
	RA      19.34677533
	Dec     48.185822
	AppMagn 14.754
	MassSol 0.95
	RadSol  0.856
	Teff    5693
}

Star	"KOI-2874/KIC 9149789"
{
	RA      19.3239258
	Dec     45.503841
	AppMagn 14.867
	MassSol 0.838
	RadSol  0.769
	Teff    5461
}

Star	"KOI-2875/KIC 12170648"
{
	RA      19.79758707
	Dec     50.74538
	AppMagn 14.828
	MassSol 0.787
	RadSol  0.782
	Teff    5180
}

Star	"KOI-2876/KIC 4367854"
{
	RA      19.4919352
	Dec     39.435841
	AppMagn 14.937
	MassSol 0.708
	RadSol  0.738
	Teff    5044
}

Star	"KOI-2878/KIC 5106313"
{
	RA      19.5862386
	Dec     40.240929
	AppMagn 14.756
	MassSol 0.675
	RadSol  0.627
	Teff    4972
}

Star	"KOI-288/KIC 9592705"
{
	RA      19.5810974
	Dec     46.226654
	AppMagn 11.02
	MassSol 1.49
	RadSol  2.114
	Teff    6174
}

Star	"KOI-2882/KIC 5642620"
{
	RA      19.83939007
	Dec     40.81496
	AppMagn 15.398
	MassSol 0.642
	RadSol  0.614
	Teff    4467
}

Star	"KOI-2890/KIC 7463685"
{
	RA      19.78309527
	Dec     43.045441
	AppMagn 15.257
	MassSol 0.993
	RadSol  0.906
	Teff    5984
}

Star	"KOI-2899/KIC 4939533"
{
	RA      19.72316487
	Dec     40.006721
	AppMagn 15.703
	MassSol 0.977
	RadSol  0.86
	Teff    5591
}

Star	"KOI-2900/KIC 4846856"
{
	RA      19.6561198
	Dec     39.91888
	AppMagn 15.266
	MassSol 0.723
	RadSol  0.769
	Teff    5204
}

Star	"KOI-2914/KIC 6837283"
{
	RA      18.77943927
	Dec     42.397549
	AppMagn 12.199
	MassSol 1.179
	RadSol  1.525
	Teff    6469
}

Star	"KOI-2915/KIC 5613821"
{
	RA      19.32782793
	Dec     40.828606
	AppMagn 13.346
	MassSol 0.993
	RadSol  1.236
	Teff    5941
}

Star	"KOI-2916/KIC 7269881"
{
	RA      19.1823812
	Dec     42.823421
	AppMagn 14.409
	MassSol 0.762
	RadSol  0.741
	Teff    5088
}

Star	"KOI-2919/KIC 10332213"
{
	RA      19.2500488
	Dec     47.490921
	AppMagn 14.816
	MassSol 0.977
	RadSol  0.86
	Teff    5591
}

Star	"KOI-2921/KIC 6842807"
{
	RA      18.956956
	Dec     42.388371
	AppMagn 15.46
	MassSol 0.825
	RadSol  0.8
	Teff    5295
}

Star	"KOI-2923/KIC 9815053"
{
	RA      18.89321693
	Dec     46.689789
	AppMagn 14.628
	MassSol 0.854
	RadSol  0.762
	Teff    5274
}

Star	"KOI-2925/KIC 6974658"
{
	RA      19.8865458
	Dec     42.434368
	AppMagn 13.458
	MassSol 0.863
	RadSol  1.03
	Teff    5552
}

Star	"KOI-2927/KIC 5787131"
{
	RA      19.369338
	Dec     41.09304
	AppMagn 15.849
	MassSol 1.096
	RadSol  1.035
	Teff    6197
}

Star	"KOI-2933/KIC 12416987"
{
	RA      19.71186527
	Dec     51.257839
	AppMagn 15.823
	MassSol 0.646
	RadSol  0.63
	Teff    4412
}

Star	"KOI-2935/KIC 8259713"
{
	RA      19.9774068
	Dec     44.112381
	AppMagn 13.603
	MassSol 1.048
	RadSol  1.055
	Teff    6434
}

StarBarycenter	"KOI-2939"
{
	RA      19.87666667
	Dec     40.65611113
	Dist    1280
	AppMagn 13.78
	MassSol 2.1885
	RadSol  1.79
	Teff    6210
}

Star	"KOI-2942/KIC 4385148"
{
	RA      19.75097047
	Dec     39.40596
	AppMagn 15.48
	MassSol 0.915
	RadSol  0.833
	Teff    5735
}

Star	"KOI-2945/KIC 8617363"
{
	RA      19.26370033
	Dec     44.7057
	AppMagn 15.999
	MassSol 0.945
	RadSol  0.854
	Teff    5751
}

Star	"KOI-2948/KIC 6356692"
{
	RA      19.292983
	Dec     41.782349
	AppMagn 11.926
	MassSol 1.074
	RadSol  1.657
	Teff    5675
}

Star	"KOI-2949/KIC 6026737"
{
	RA      19.0583862
	Dec     41.332432
	AppMagn 13.313
	MassSol 1.187
	RadSol  1.782
	Teff    6197
}

Star	"KOI-2950/KIC 6028860"
{
	RA      19.12803753
	Dec     41.371151
	AppMagn 14.403
	MassSol 0.846
	RadSol  0.779
	Teff    5607
}

Star	"KOI-2957/KIC 10904004"
{
	RA      18.82286987
	Dec     48.340778
	AppMagn 14.48
	MassSol 0.659
	RadSol  0.654
	Teff    4871
}

Star	"KOI-2958/KIC 10597693"
{
	RA      19.39525347
	Dec     47.887249
	AppMagn 14.756
	MassSol 1.083
	RadSol  1.033
	Teff    6341
}

Star	"KOI-2959/KIC 7466270"
{
	RA      19.8181478
	Dec     43.098721
	AppMagn 15.771
	MassSol 0.528
	RadSol  0.53
	Teff    4504
}

Star	"KOI-2962/KIC 4935172"
{
	RA      19.657546
	Dec     40.007511
	AppMagn 14.229
	MassSol 1.109
	RadSol  1.045
	Teff    6164
}

Star	"KOI-2967/KIC 5980783"
{
	RA      19.81328533
	Dec     41.226429
	AppMagn 15.527
	MassSol 0.853
	RadSol  0.817
	Teff    5641
}

Star	"KOI-2968/KIC 8873090"
{
	RA      19.1053426
	Dec     45.163822
	AppMagn 11.912
	MassSol 0.997
	RadSol  1.198
	Teff    6387
}

Star	"KOI-2970/KIC 5450893"
{
	RA      19.50518593
	Dec     40.667858
	AppMagn 12.861
	MassSol 1.164
	RadSol  1.31
	Teff    6483
}

Star	"KOI-2971/KIC 4770174"
{
	RA      19.82624713
	Dec     39.829041
	AppMagn 12.742
	MassSol 1.038
	RadSol  1.028
	Teff    6234
}

Star	"KOI-2972/KIC 8949925"
{
	RA      19.3822978
	Dec     45.297791
	AppMagn 15.085
	MassSol 1.014
	RadSol  0.976
	Teff    5937
}

Star	"KOI-2975/KIC 6948480"
{
	RA      19.45250247
	Dec     42.469528
	AppMagn 15.31
	MassSol 0.995
	RadSol  0.93
	Teff    6008
}

Star	"KOI-2976/KIC 6438099"
{
	RA      19.34804487
	Dec     41.868721
	AppMagn 15.862
	MassSol 0.69
	RadSol  0.631
	Teff    5254
}

Star	"KOI-2982/KIC 8360640"
{
	RA      19.33625893
	Dec     44.370602
	AppMagn 14.264
	MassSol 0.878
	RadSol  0.818
	Teff    5516
}

Star	"KOI-2984/KIC 7918652"
{
	RA      19.98046673
	Dec     43.622601
	AppMagn 13.066
	MassSol 0.947
	RadSol  1.2
	Teff    6015
}

Star	"KOI-2989/KIC 6636320"
{
	RA      19.93873293
	Dec     42.018139
	AppMagn 15.411
	MassSol 0.849
	RadSol  0.758
	Teff    5376
}

Star	"KOI-2992/KIC 8509442"
{
	RA      19.78248293
	Dec     44.50148
	AppMagn 15.995
	MassSol 0.572
	RadSol  0.55
	Teff    3952
}

Star	"KOI-3007/KIC 10190075"
{
	RA      18.8890218
	Dec     47.208832
	AppMagn 14.528
	MassSol 1.008
	RadSol  0.916
	Teff    5896
}

Star	"KOI-3013/KIC 11565544"
{
	RA      19.6645406
	Dec     49.556511
	AppMagn 14.698
	MassSol 0.945
	RadSol  0.854
	Teff    5751
}

Star	"KOI-3017/KIC 12072872"
{
	RA      19.79061687
	Dec     50.560162
	AppMagn 13.308
	MassSol 0.848
	RadSol  0.967
	Teff    5893
}

Star	"KOI-3019/KIC 8709688"
{
	RA      19.89342447
	Dec     44.838181
	AppMagn 14.927
	MassSol 0.934
	RadSol  1.155
	Teff    5632
}

Star	"KOI-3020/KIC 8241079"
{
	RA      19.636027
	Dec     44.190979
	AppMagn 13.534
	MassSol 0.965
	RadSol  1.181
	Teff    6174
}

Star	"KOI-3022/KIC 11618601"
{
	RA      19.7057658
	Dec     49.666851
	AppMagn 15.4
	MassSol 0.999
	RadSol  0.901
	Teff    5772
}

Star	"KOI-3027/KIC 11137180"
{
	RA      19.44503987
	Dec     48.762562
	AppMagn 15.489
	MassSol 0.846
	RadSol  0.78
	Teff    5076
}

Star	"KOI-3028/KIC 9838804"
{
	RA      19.6641642
	Dec     46.676289
	AppMagn 15.983
	MassSol 0.895
	RadSol  0.816
	Teff    5536
}

Star	"KOI-3029/KIC 5903749"
{
	RA      19.91722413
	Dec     41.159882
	AppMagn 14.948
	MassSol 0.87
	RadSol  0.966
	Teff    5472
}

Star	"KOI-3031/KIC 6949898"
{
	RA      19.48182573
	Dec     42.451969
	AppMagn 15.267
	MassSol 0.952
	RadSol  0.857
	Teff    5653
}

Star	"KOI-3034/KIC 2973386"
{
	RA      19.13200887
	Dec     38.165218
	AppMagn 15.572
	MassSol 0.541
	RadSol  0.523
	Teff    3903
}

Star	"KOI-3037/KIC 6593150"
{
	RA      19.17348227
	Dec     42.075741
	AppMagn 15.861
	MassSol 0.908
	RadSol  0.827
	Teff    5614
}

Star	"KOI-3040/KIC 6357290"
{
	RA      19.30453493
	Dec     41.771561
	AppMagn 15.667
	MassSol 1.021
	RadSol  0.934
	Teff    5988
}

Star	"KOI-3041/KIC 4072955"
{
	RA      19.69750567
	Dec     39.16848
	AppMagn 14.207
	MassSol 1.011
	RadSol  1.083
	Teff    6217
}

Star	"KOI-3042/KIC 8695311"
{
	RA      19.6110962
	Dec     44.886311
	AppMagn 15.959
	MassSol 1.048
	RadSol  0.969
	Teff    6075
}

Star	"KOI-3043/KIC 9834731"
{
	RA      19.5620524
	Dec     46.692089
	AppMagn 14.829
	MassSol 0.945
	RadSol  0.856
	Teff    5959
}

Star	"KOI-3045/KIC 5092266"
{
	RA      19.31190387
	Dec     40.249641
	AppMagn 15.755
	MassSol 1.07
	RadSol  0.996
	Teff    6122
}

Star	"KOI-3048/KIC 9714550"
{
	RA      19.57461753
	Dec     46.413342
	AppMagn 14.651
	MassSol 0.865
	RadSol  0.79
	Teff    5583
}

Star	"KOI-3050/KIC 5475042"
{
	RA      19.89643147
	Dec     40.624882
	AppMagn 15.33
	MassSol 0.918
	RadSol  0.819
	Teff    5504
}

Star	"KOI-3051/KIC 9959492"
{
	RA      19.67997847
	Dec     46.832321
	AppMagn 15.276
	MassSol 0.971
	RadSol  0.889
	Teff    6089
}

Star	"KOI-3052/KIC 8827575"
{
	RA      19.67268473
	Dec     45.081181
	AppMagn 13.573
	MassSol 0.821
	RadSol  0.946
	Teff    5466
}

Star	"KOI-3061/KIC 4857058"
{
	RA      19.8028056
	Dec     39.912231
	AppMagn 14.316
	MassSol 0.797
	RadSol  0.853
	Teff    5120
}

Star	"KOI-3065/KIC 5040077"
{
	RA      19.90264487
	Dec     40.183659
	AppMagn 14.603
	MassSol 0.824
	RadSol  0.843
	Teff    5837
}

Star	"KOI-3066/KIC 4067925"
{
	RA      19.61933593
	Dec     39.126869
	AppMagn 15.911
	MassSol 0.857
	RadSol  0.78
	Teff    5172
}

Star	"KOI-3068/KIC 3230805"
{
	RA      19.3506856
	Dec     38.354988
	AppMagn 14.976
	MassSol 0.763
	RadSol  0.689
	Teff    4886
}

Star	"KOI-3069/KIC 4676964"
{
	RA      19.80261433
	Dec     39.785259
	AppMagn 14.914
	MassSol 1.017
	RadSol  1.097
	Teff    5741
}

Star	"KOI-3072/KIC 3219643"
{
	RA      19.11743167
	Dec     38.34351
	AppMagn 15.581
	MassSol 0.758
	RadSol  0.806
	Teff    5141
}

Star	"KOI-3073/KIC 8546542"
{
	RA      19.04990033
	Dec     44.632462
	AppMagn 14.449
	MassSol 0.944
	RadSol  0.83
	Teff    5463
}

Star	"KOI-3075/KIC 3328080"
{
	RA      19.14705813
	Dec     38.498055
	AppMagn 12.994
	MassSol 0.837
	RadSol  1.125
	Teff    5702
}

Star	"KOI-3077/KIC 2715695"
{
	RA      19.46889853
	Dec     37.974548
	AppMagn 15.958
	MassSol 0.759
	RadSol  0.742
	Teff    4791
}

Star	"KOI-3078/KIC 8430964"
{
	RA      19.45908813
	Dec     44.478981
	AppMagn 15.33
	MassSol 1.104
	RadSol  1.041
	Teff    6173
}

Star	"KOI-308/KIC 6291837"
{
	RA      19.59531453
	Dec     41.602871
	AppMagn 12.351
	MassSol 1.106
	RadSol  1.1
	Teff    6210
}

Star	"KOI-3083/KIC 7106173"
{
	RA      19.19859007
	Dec     42.679359
	AppMagn 12.857
	MassSol 1.028
	RadSol  0.938
	Teff    5942
}

Star	"KOI-3086/KIC 10749059"
{
	RA      19.85897627
	Dec     48.00145
	AppMagn 15.707
	MassSol 0.828
	RadSol  0.759
	Teff    5463
}

Star	"KOI-3088/KIC 9020114"
{
	RA      19.41095787
	Dec     45.318291
	AppMagn 14.953
	MassSol 1.058
	RadSol  0.975
	Teff    6018
}

Star	"KOI-3089/KIC 7668416"
{
	RA      19.07653607
	Dec     43.369202
	AppMagn 15.247
	MassSol 0.843
	RadSol  0.864
	Teff    5269
}

Star	"KOI-3091/KIC 12406807"
{
	RA      19.39255373
	Dec     51.248169
	AppMagn 15.372
	MassSol 1.065
	RadSol  1.012
	Teff    6363
}

Star	"KOI-3094/KIC 12352520"
{
	RA      19.2582906
	Dec     51.154121
	AppMagn 15.737
	MassSol 0.526
	RadSol  0.497
	Teff    3805
}

Star	"KOI-3095/KIC 9650989"
{
	RA      19.50489093
	Dec     46.36684
	AppMagn 15.067
	MassSol 0.999
	RadSol  0.91
	Teff    5955
}

Star	"KOI-3102/KIC 9605552"
{
	RA      19.864032
	Dec     46.227921
	AppMagn 15.983
	MassSol 0.376
	RadSol  0.35
	Teff    3773
}

Star	"KOI-3104/KIC 11518201"
{
	RA      19.77929687
	Dec     49.44677
	AppMagn 15.388
	MassSol 0.92
	RadSol  0.878
	Teff    5618
}

Star	"KOI-3105/KIC 12168993"
{
	RA      19.75204267
	Dec     50.755669
	AppMagn 15.277
	MassSol 0.698
	RadSol  0.7
	Teff    5116
}

Star	"KOI-3108/KIC 3756264"
{
	RA      19.588442
	Dec     38.856621
	AppMagn 14.941
	MassSol 0.987
	RadSol  0.894
	Teff    5868
}

Star	"KOI-3111/KIC 8581240"
{
	RA      19.90512493
	Dec     44.621609
	AppMagn 12.863
	MassSol 1.206
	RadSol  1.984
	Teff    6070
}

Star	"KOI-3112/KIC 7022573"
{
	RA      19.21404827
	Dec     42.556808
	AppMagn 15.855
	MassSol 0.868
	RadSol  0.794
	Teff    5494
}

Star	"KOI-3117/KIC 6523351"
{
	RA      19.4747864
	Dec     41.927029
	AppMagn 13.163
	MassSol 0.915
	RadSol  1.344
	Teff    5705
}

Star	"KOI-3119/KIC 5551672"
{
	RA      19.77247927
	Dec     40.722988
	AppMagn 16.946
	MassSol 0.266
	RadSol  0.277
	Teff    3382
}

Star	"KOI-3123/KIC 8197793"
{
	RA      20.06987507
	Dec     44.037689
	AppMagn 15.029
	MassSol 1.063
	RadSol  0.992
	Teff    6170
}

Star	"KOI-3128/KIC 7609674"
{
	RA      19.49865113
	Dec     43.227024
	AppMagn 13.371
	MassSol 1.03
	RadSol  1.281
	Teff    6099
}

Star	"KOI-3130/KIC 10252275"
{
	RA      18.7139018
	Dec     47.32806
	AppMagn 13.752
	MassSol 0.752
	RadSol  0.8
	Teff    5159
}

Star	"KOI-3136/KIC 6945786"
{
	RA      19.39262087
	Dec     42.45966
	AppMagn 15.738
	MassSol 0.663
	RadSol  0.685
	Teff    4935
}

Star	"KOI-3137/KIC 9758032"
{
	RA      19.0139628
	Dec     46.540909
	AppMagn 15.682
	MassSol 0.823
	RadSol  0.741
	Teff    5359
}

Star	"KOI-3138/KIC 6444896"
{
	RA      19.50025227
	Dec     41.830421
	AppMagn 17.131
	MassSol 0.096
	RadSol  0.118
	Teff    2703
}

Star	"KOI-3140/KIC 5978170"
{
	RA      19.77448327
	Dec     41.281189
	AppMagn 15.561
	MassSol 0.636
	RadSol  0.639
	Teff    4234
}

Star	"KOI-3142/KIC 3752110"
{
	RA      19.52048133
	Dec     38.884232
	AppMagn 15.243
	MassSol 1.306
	RadSol  1.241
	Teff    6449
}

Star	"KOI-3145/KIC 1717722"
{
	RA      19.37453207
	Dec     37.289089
	AppMagn 15.689
	MassSol 0.751
	RadSol  0.713
	Teff    4812
}

Star	"KOI-315/KIC 7700622"
{
	RA      19.8181254
	Dec     43.333309
	AppMagn 12.968
	MassSol 0.671
	RadSol  0.688
	Teff    4741
}

Star	"KOI-3161/KIC 2696703"
{
	RA      19.13716027
	Dec     37.991367
	AppMagn 9.58
	MassSol 1.474
	RadSol  1.676
	Teff    6790
}

Star	"KOI-3165/KIC 9579208"
{
	RA      19.17584027
	Dec     46.204411
	AppMagn 10.335
	MassSol 1.33
	RadSol  1.85
	Teff    6422
}

Star	"KOI-3168/KIC 4450844"
{
	RA      19.15432333
	Dec     39.538181
	AppMagn 10.455
	MassSol 1.13
	RadSol  1.59
	Teff    5968
}

Star	"KOI-3179/KIC 6153407"
{
	RA      19.95351967
	Dec     41.441017
	AppMagn 10.884
	MassSol 1.115
	RadSol  1.683
	Teff    6237
}

Star	"KOI-3184/KIC 4735826"
{
	RA      19.22635293
	Dec     39.872627
	AppMagn 11.158
	MassSol 1.173
	RadSol  2.193
	Teff    6003
}

Star	"KOI-319/KIC 8684730"
{
	RA      19.3411682
	Dec     44.87294
	AppMagn 12.711
	MassSol 1.325
	RadSol  2.064
	Teff    5882
}

Star	"KOI-3190/KIC 5985713"
{
	RA      19.88454387
	Dec     41.251663
	AppMagn 11.458
	MassSol 1.012
	RadSol  1.116
	Teff    6280
}

Star	"KOI-3194/KIC 12004971"
{
	RA      19.10856933
	Dec     50.471272
	AppMagn 11.487
	MassSol 1.302
	RadSol  1.53
	Teff    6531
}

Star	"KOI-3196/KIC 9002538"
{
	RA      18.89003093
	Dec     45.339111
	AppMagn 11.525
	MassSol 1.21
	RadSol  1.392
	Teff    6422
}

Star	"KOI-3202/KIC 4262040"
{
	RA      19.43381347
	Dec     39.323662
	AppMagn 11.784
	MassSol 0.86
	RadSol  1.672
	Teff    5316
}

Star	"KOI-3203/KIC 3122872"
{
	RA      19.5261454
	Dec     38.270512
	AppMagn 11.816
	MassSol 1.151
	RadSol  1.523
	Teff    7095
}

Star	"KOI-3204/KIC 11456279"
{
	RA      19.49608967
	Dec     49.316414
	AppMagn 11.825
	MassSol 1.553
	RadSol  1.593
	Teff    7338
}

Star	"KOI-3208/KIC 10155029"
{
	RA      19.778656
	Dec     47.173313
	AppMagn 11.893
	MassSol 1.313
	RadSol  1.986
	Teff    5884
}

Star	"KOI-3209/KIC 7017274"
{
	RA      19.06154787
	Dec     42.54985
	AppMagn 11.915
	MassSol 1.037
	RadSol  1.171
	Teff    6603
}

Star	"KOI-3214/KIC 7983117"
{
	RA      19.91158447
	Dec     43.795479
	AppMagn 12.014
	MassSol 1.502
	RadSol  3.132
	Teff    6036
}

Star	"KOI-3224/KIC 10384298"
{
	RA      18.7551636
	Dec     47.584869
	AppMagn 12.192
	MassSol 0.847
	RadSol  0.779
	Teff    5431
}

Star	"KOI-3225/KIC 3109550"
{
	RA      19.3114502
	Dec     38.297871
	AppMagn 12.207
	MassSol 0.924
	RadSol  1.366
	Teff    5511
}

Star	"KOI-3232/KIC 9569711"
{
	RA      18.8078552
	Dec     46.22393
	AppMagn 12.253
	MassSol 1.091
	RadSol  1.474
	Teff    5902
}

Star	"KOI-3236/KIC 7902003"
{
	RA      19.6959432
	Dec     43.676311
	AppMagn 12.31
	MassSol 1.124
	RadSol  1.128
	Teff    6435
}

Star	"KOI-3242/KIC 6928906"
{
	RA      18.963739
	Dec     42.439831
	AppMagn 12.374
	MassSol 1.976
	RadSol  2.804
	Teff    7382
}

Star	"KOI-3248/KIC 10917433"
{
	RA      19.3643392
	Dec     48.332249
	AppMagn 12.419
	MassSol 0.885
	RadSol  1.077
	Teff    5680
}

Star	"KOI-3258/KIC 4366323"
{
	RA      19.46250407
	Dec     39.419941
	AppMagn 15.676
	MassSol 0.895
	RadSol  0.815
	Teff    5658
}

Star	"KOI-3259/KIC 2853029"
{
	RA      19.43765053
	Dec     38.074589
	AppMagn 15.679
	MassSol 0.849
	RadSol  0.758
	Teff    5376
}

Star	"KOI-326/KIC 9880467"
{
	RA      19.1104024
	Dec     46.783543
	AppMagn 12.96
	MassSol 1.606
	RadSol  11.536
	Teff    4751
}

Star	"KOI-3263/KIC 11853130"
{
	RA      19.0063904
	Dec     50.10096
	AppMagn 15.949
	MassSol 0.407
	RadSol  0.38
	Teff    3587
}

Star	"KOI-3264/KIC 9345933"
{
	RA      19.5506022
	Dec     45.837448
	AppMagn 15.961
	MassSol 0.632
	RadSol  0.643
	Teff    4794
}

Star	"KOI-3267/KIC 8620402"
{
	RA      19.34777833
	Dec     44.779678
	AppMagn 14.706
	MassSol 1.113
	RadSol  1.11
	Teff    6202
}

Star	"KOI-3268/KIC 8379021"
{
	RA      19.76029867
	Dec     44.367458
	AppMagn 15.595
	MassSol 0.862
	RadSol  0.892
	Teff    5592
}

Star	"KOI-3271/KIC 7285757"
{
	RA      19.53054607
	Dec     42.854889
	AppMagn 15.717
	MassSol 0.776
	RadSol  0.729
	Teff    5548
}

Star	"KOI-3279/KIC 3544640"
{
	RA      19.4287618
	Dec     38.654388
	AppMagn 15.765
	MassSol 1.047
	RadSol  0.96
	Teff    5982
}

Star	"KOI-3283/KIC 9008103"
{
	RA      19.0726054
	Dec     45.369011
	AppMagn 15.322
	MassSol 0.786
	RadSol  0.721
	Teff    4944
}

Star	"KOI-3301/KIC 8301878"
{
	RA      19.5086426
	Dec     44.283119
	AppMagn 14.18
	MassSol 0.89
	RadSol  0.901
	Teff    5631
}

Star	"KOI-3307/KIC 6131130"
{
	RA      19.60908407
	Dec     41.456692
	AppMagn 15.654
	MassSol 0.788
	RadSol  0.865
	Teff    5290
}

Star	"KOI-3309/KIC 5563300"
{
	RA      19.93121947
	Dec     40.797352
	AppMagn 14.71
	MassSol 0.788
	RadSol  0.865
	Teff    5290
}

Star	"KOI-3310/KIC 12253769"
{
	RA      19.25363767
	Dec     50.99062
	AppMagn 13.55
	MassSol 0.986
	RadSol  0.894
	Teff    5624
}

Star	"KOI-3312/KIC 11905409"
{
	RA      19.1001404
	Dec     50.246189
	AppMagn 15.739
	MassSol 0.955
	RadSol  0.864
	Teff    5903
}

Star	"KOI-3313/KIC 9571186"
{
	RA      18.86984253
	Dec     46.265331
	AppMagn 14.767
	MassSol 0.855
	RadSol  0.782
	Teff    4916
}

Star	"KOI-3318/KIC 8331612"
{
	RA      20.0852458
	Dec     44.25053
	AppMagn 15.842
	MassSol 1.035
	RadSol  1.056
	Teff    6031
}

Star	"KOI-3320/KIC 6690171"
{
	RA      19.4284566
	Dec     42.164082
	AppMagn 15.954
	MassSol 0.923
	RadSol  0.875
	Teff    5223
}

Star	"KOI-3323/KIC 5193659"
{
	RA      19.58229573
	Dec     40.307201
	AppMagn 15.076
	MassSol 0.989
	RadSol  0.898
	Teff    5810
}

Star	"KOI-3329/KIC 6955671"
{
	RA      19.59616087
	Dec     42.4259
	AppMagn 15.813
	MassSol 1.088
	RadSol  1.031
	Teff    6241
}

Star	"KOI-3331/KIC 5876805"
{
	RA      19.46433107
	Dec     41.122162
	AppMagn 15.927
	MassSol 0.946
	RadSol  0.856
	Teff    5791
}

Star	"KOI-3334/KIC 11147814"
{
	RA      19.7559082
	Dec     48.75758
	AppMagn 14.401
	MassSol 0.641
	RadSol  0.653
	Teff    4523
}

Star	"KOI-3335/KIC 10922659"
{
	RA      19.5380412
	Dec     48.387741
	AppMagn 15.82
	MassSol 1.195
	RadSol  1.145
	Teff    6215
}

Star	"KOI-3337/KIC 7692093"
{
	RA      19.66039633
	Dec     43.381889
	AppMagn 15.927
	MassSol 0.922
	RadSol  0.839
	Teff    5547
}

Star	"KOI-3339/KIC 7772914"
{
	RA      19.8501282
	Dec     43.447578
	AppMagn 14.656
	MassSol 0.763
	RadSol  0.932
	Teff    5712
}

Star	"KOI-3340/KIC 3529290"
{
	RA      19.10067953
	Dec     38.618309
	AppMagn 13.776
	MassSol 0.925
	RadSol  0.947
	Teff    6168
}

Star	"KOI-3341/KIC 5621333"
{
	RA      19.48198447
	Dec     40.808949
	AppMagn 14.886
	MassSol 1.113
	RadSol  1.11
	Teff    6202
}

Star	"KOI-3342/KIC 5392897"
{
	RA      19.9379618
	Dec     40.515659
	AppMagn 15.747
	MassSol 1.036
	RadSol  0.962
	Teff    6153
}

Star	"KOI-3343/KIC 3236705"
{
	RA      19.457015
	Dec     38.393131
	AppMagn 14.97
	MassSol 1.027
	RadSol  0.956
	Teff    5996
}

Star	"KOI-3347/KIC 8824737"
{
	RA      19.60692747
	Dec     45.001419
	AppMagn 15.487
	MassSol 0.862
	RadSol  0.796
	Teff    5534
}

Star	"KOI-3354/KIC 9845909"
{
	RA      19.8251648
	Dec     46.661652
	AppMagn 15.089
	MassSol 0.89
	RadSol  0.9
	Teff    5718
}

Star	"KOI-3355/KIC 9221528"
{
	RA      19.54227293
	Dec     45.626869
	AppMagn 15.11
	MassSol 1.007
	RadSol  1.013
	Teff    6187
}

Star	"KOI-3357/KIC 7115291"
{
	RA      19.40006307
	Dec     42.622231
	AppMagn 15.193
	MassSol 0.918
	RadSol  0.894
	Teff    5830
}

Star	"KOI-3358/KIC 4263529"
{
	RA      19.45927127
	Dec     39.361771
	AppMagn 14.031
	MassSol 0.867
	RadSol  0.845
	Teff    5529
}

Star	"KOI-3361/KIC 6619815"
{
	RA      19.705072
	Dec     42.023361
	AppMagn 15.502
	MassSol 1.047
	RadSol  0.96
	Teff    5982
}

Star	"KOI-3367/KIC 10935993"
{
	RA      19.87944133
	Dec     48.396259
	AppMagn 15.056
	MassSol 0.998
	RadSol  0.966
	Teff    6195
}

Star	"KOI-3372/KIC 9785921"
{
	RA      19.83205973
	Dec     46.589142
	AppMagn 15.42
	MassSol 1.096
	RadSol  1.035
	Teff    6197
}

Star	"KOI-3375/KIC 6779726"
{
	RA      19.50203653
	Dec     42.214649
	AppMagn 15.695
	MassSol 0.967
	RadSol  0.924
	Teff    5889
}

Star	"KOI-3377/KIC 5553959"
{
	RA      19.80337727
	Dec     40.717419
	AppMagn 15.318
	MassSol 0.507
	RadSol  0.508
	Teff    4339
}

Star	"KOI-3383/KIC 8078502"
{
	RA      18.8754598
	Dec     43.955971
	AppMagn 15.848
	MassSol 0.868
	RadSol  0.818
	Teff    5513
}

Star	"KOI-3385/KIC 9489947"
{
	RA      20.00120847
	Dec     46.026272
	AppMagn 15.231
	MassSol 0.937
	RadSol  1.112
	Teff    5786
}

Star	"KOI-3386/KIC 6960487"
{
	RA      19.68025713
	Dec     42.43045
	AppMagn 15.142
	MassSol 1
	RadSol  1.038
	Teff    6122
}

Star	"KOI-3389/KIC 3848966"
{
	RA      19.4046244
	Dec     38.914909
	AppMagn 14.564
	MassSol 0.997
	RadSol  0.941
	Teff    6022
}

Star	"KOI-3391/KIC 9452897"
{
	RA      19.05625813
	Dec     46.015911
	AppMagn 15.903
	MassSol 0.531
	RadSol  0.54
	Teff    4342
}

Star	"KOI-3394/KIC 7748487"
{
	RA      19.3490682
	Dec     43.47065
	AppMagn 15.491
	MassSol 1.149
	RadSol  1.064
	Teff    6167
}

Star	"KOI-3395/KIC 3219037"
{
	RA      19.10269367
	Dec     38.3326
	AppMagn 14.634
	MassSol 0.884
	RadSol  0.924
	Teff    5912
}

Star	"KOI-3396/KIC 5710069"
{
	RA      19.54829307
	Dec     40.931931
	AppMagn 15.553
	MassSol 0.939
	RadSol  0.85
	Teff    5804
}

Star	"KOI-3397/KIC 6200810"
{
	RA      19.36328533
	Dec     41.535789
	AppMagn 15.353
	MassSol 1.19
	RadSol  1.168
	Teff    6495
}

Star	"KOI-340/KIC 10616571"
{
	RA      19.84431153
	Dec     47.801392
	AppMagn 13.057
	MassSol 1.103
	RadSol  1.183
	Teff    5774
}

Star	"KOI-3401/KIC 9966219"
{
	RA      19.83189293
	Dec     46.81575
	AppMagn 14.388
	MassSol 0.924
	RadSol  1.072
	Teff    5896
}

Star	"KOI-3408/KIC 11922778"
{
	RA      19.73379313
	Dec     50.281811
	AppMagn 14.821
	MassSol 0.998
	RadSol  0.926
	Teff    6014
}

Star	"KOI-3411/KIC 6025124"
{
	RA      19.00985313
	Dec     41.388908
	AppMagn 14.426
	MassSol 1.149
	RadSol  1.064
	Teff    6167
}

Star	"KOI-3413/KIC 4164393"
{
	RA      19.547819
	Dec     39.207809
	AppMagn 15.217
	MassSol 1.088
	RadSol  1.031
	Teff    6241
}

Star	"KOI-3414/KIC 6023859"
{
	RA      18.96641847
	Dec     41.32589
	AppMagn 15.483
	MassSol 0.559
	RadSol  0.537
	Teff    3900
}

Star	"KOI-3416/KIC 2849140"
{
	RA      19.3822184
	Dec     38.00721
	AppMagn 15.353
	MassSol 0.883
	RadSol  0.806
	Teff    5559
}

Star	"KOI-3419/KIC 11519134"
{
	RA      19.8026428
	Dec     49.469139
	AppMagn 13.061
	MassSol 1.085
	RadSol  1.332
	Teff    6391
}

Star	"KOI-3420/KIC 7289338"
{
	RA      19.60101927
	Dec     42.824371
	AppMagn 15.589
	MassSol 1.079
	RadSol  1.001
	Teff    6063
}

Star	"KOI-3421/KIC 5004909"
{
	RA      19.32798053
	Dec     40.16853
	AppMagn 13.935
	MassSol 1.339
	RadSol  1.283
	Teff    6535
}

Star	"KOI-3423/KIC 3745559"
{
	RA      19.40413613
	Dec     38.863312
	AppMagn 14.296
	MassSol 1.249
	RadSol  1.167
	Teff    6299
}

Star	"KOI-3425/KIC 9117416"
{
	RA      20.02107953
	Dec     45.49538
	AppMagn 13.266
	MassSol 1.251
	RadSol  2
	Teff    6120
}

Star	"KOI-3426/KIC 5900235"
{
	RA      19.86672567
	Dec     41.196991
	AppMagn 14.324
	MassSol 0.934
	RadSol  1.013
	Teff    6158
}

Star	"KOI-3430/KIC 7697103"
{
	RA      19.758846
	Dec     43.386589
	AppMagn 15.712
	MassSol 0.71
	RadSol  0.652
	Teff    5267
}

Star	"KOI-3433/KIC 7093401"
{
	RA      18.82307533
	Dec     42.60891
	AppMagn 15.417
	MassSol 0.83
	RadSol  0.922
	Teff    5252
}

Star	"KOI-3434/KIC 8628665"
{
	RA      19.55634767
	Dec     44.700642
	AppMagn 14.951
	MassSol 1.017
	RadSol  1.056
	Teff    6180
}

Star	"KOI-3440/KIC 3559860"
{
	RA      19.67781373
	Dec     38.637081
	AppMagn 15.606
	MassSol 0.902
	RadSol  0.83
	Teff    5853
}

Star	"KOI-3444/KIC 5384713"
{
	RA      19.82861327
	Dec     40.561909
	AppMagn 13.693
	MassSol 0.6
	RadSol  0.598
	Teff    3842
}

Star	"KOI-3448/KIC 3348216"
{
	RA      19.5306722
	Dec     38.431431
	AppMagn 14.863
	MassSol 1.043
	RadSol  0.982
	Teff    6315
}

Star	"KOI-3449/KIC 10798838"
{
	RA      19.50135293
	Dec     48.123531
	AppMagn 14.822
	MassSol 0.74
	RadSol  0.807
	Teff    5344
}

Star	"KOI-3451/KIC 10793576"
{
	RA      19.35629473
	Dec     48.147308
	AppMagn 14.056
	MassSol 1.145
	RadSol  1.154
	Teff    6426
}

Star	"KOI-3455/KIC 6947668"
{
	RA      19.43380533
	Dec     42.429878
	AppMagn 15.802
	MassSol 0.977
	RadSol  0.88
	Teff    5783
}

Star	"KOI-3459/KIC 2717158"
{
	RA      19.4886902
	Dec     37.997059
	AppMagn 15.208
	MassSol 0.95
	RadSol  0.861
	Teff    5933
}

Star	"KOI-3460/KIC 9664276"
{
	RA      19.82527467
	Dec     46.367069
	AppMagn 14.451
	MassSol 0.88
	RadSol  0.851
	Teff    5951
}

Star	"KOI-3462/KIC 9967009"
{
	RA      19.84679767
	Dec     46.823318
	AppMagn 15.916
	MassSol 1.008
	RadSol  0.916
	Teff    5896
}

Star	"KOI-3463/KIC 5294945"
{
	RA      19.79198407
	Dec     40.45536
	AppMagn 14.564
	MassSol 0.995
	RadSol  1.061
	Teff    6068
}

Star	"KOI-3467/KIC 7121885"
{
	RA      19.535378
	Dec     42.63522
	AppMagn 15.191
	MassSol 1.07
	RadSol  1.066
	Teff    6220
}

Star	"KOI-3472/KIC 9536108"
{
	RA      19.70923667
	Dec     46.132549
	AppMagn 14.412
	MassSol 1.085
	RadSol  1.031
	Teff    6277
}

Star	"KOI-3473/KIC 8905246"
{
	RA      19.87172647
	Dec     45.18903
	AppMagn 13.851
	MassSol 1.254
	RadSol  2.427
	Teff    5214
}

Star	"KOI-3474/KIC 5213230"
{
	RA      19.872227
	Dec     40.34621
	AppMagn 14.192
	MassSol 0.83
	RadSol  0.767
	Teff    5751
}

Star	"KOI-3478/KIC 7742408"
{
	RA      19.1775594
	Dec     43.471451
	AppMagn 13.354
	MassSol 0.962
	RadSol  1.688
	Teff    4928
}

Star	"KOI-3480/KIC 9843517"
{
	RA      19.77683713
	Dec     46.618809
	AppMagn 15.954
	MassSol 0.807
	RadSol  0.741
	Teff    5465
}

Star	"KOI-3481/KIC 8812045"
{
	RA      19.27323
	Dec     45.02309
	AppMagn 14.462
	MassSol 0.92
	RadSol  0.838
	Teff    6099
}

Star	"KOI-3482/KIC 7288444"
{
	RA      19.584493
	Dec     42.829208
	AppMagn 15.098
	MassSol 0.89
	RadSol  0.844
	Teff    6028
}

Star	"KOI-3483/KIC 3101923"
{
	RA      19.1548462
	Dec     38.279709
	AppMagn 14.872
	MassSol 1.054
	RadSol  0.988
	Teff    6233
}

Star	"KOI-3486/KIC 8121328"
{
	RA      19.92137453
	Dec     43.909859
	AppMagn 14.371
	MassSol 0.788
	RadSol  0.889
	Teff    5418
}

Star	"KOI-3487/KIC 9783760"
{
	RA      19.79083047
	Dec     46.54549
	AppMagn 14.294
	MassSol 0.835
	RadSol  0.75
	Teff    5791
}

Star	"KOI-349/KIC 11394027"
{
	RA      19.12351073
	Dec     49.261681
	AppMagn 13.586
	MassSol 1.081
	RadSol  1.146
	Teff    5914
}

Star	"KOI-3493/KIC 8880123"
{
	RA      19.32191973
	Dec     45.10276
	AppMagn 15.223
	MassSol 1.019
	RadSol  0.932
	Teff    6003
}

Star	"KOI-3494/KIC 8231667"
{
	RA      19.4132548
	Dec     44.166241
	AppMagn 15.654
	MassSol 0.768
	RadSol  0.832
	Teff    5256
}

Star	"KOI-3495/KIC 9474756"
{
	RA      19.70358273
	Dec     46.02911
	AppMagn 15.135
	MassSol 0.804
	RadSol  0.74
	Teff    5650
}

Star	"KOI-350/KIC 11395587"
{
	RA      19.19076133
	Dec     49.264462
	AppMagn 13.387
	MassSol 1.013
	RadSol  1.082
	Teff    6031
}

Star	"KOI-3500/KIC 6058816"
{
	RA      19.75697427
	Dec     41.33556
	AppMagn 13.214
	MassSol 0.988
	RadSol  0.962
	Teff    6085
}

Star	"KOI-3503/KIC 6368175"
{
	RA      19.54338987
	Dec     41.729252
	AppMagn 13.827
	MassSol 0.918
	RadSol  0.847
	Teff    6338
}

Star	"KOI-3504/KIC 5471158"
{
	RA      19.83865353
	Dec     40.603001
	AppMagn 15.717
}

Star	"KOI-3506/KIC 8719419"
{
	RA      20.0764018
	Dec     44.869659
	AppMagn 12.933
	MassSol 1.278
	RadSol  1.844
	Teff    6878
}

Star	"KOI-3508/KIC 6697817"
{
	RA      19.5749044
	Dec     42.129639
	AppMagn 14.322
	MassSol 1.04
	RadSol  0.992
	Teff    6362
}

Star	"KOI-3515/KIC 3240159"
{
	RA      19.514211
	Dec     38.369659
	AppMagn 12.261
	MassSol 1.023
	RadSol  1.207
	Teff    6395
}

Star	"KOI-3520/KIC 3757590"
{
	RA      19.60958047
	Dec     38.877392
	AppMagn 13.674
	MassSol 1.014
	RadSol  1.063
	Teff    6074
}

Star	"KOI-3522/KIC 12021387"
{
	RA      19.72738853
	Dec     50.40976
	AppMagn 10.656
	MassSol 2.319
	RadSol  2.259
	Teff    9541
}

Star	"KOI-3527/KIC 8733497"
{
	RA      18.800059
	Dec     44.96077
	AppMagn 14.063
	MassSol 0.855
	RadSol  0.785
	Teff    5668
}

Star	"KOI-3528/KIC 4255422"
{
	RA      19.3131368
	Dec     39.371639
	AppMagn 12.724
	MassSol 0.999
	RadSol  2.185
	Teff    6061
}

Star	"KOI-353/KIC 11566064"
{
	RA      19.68084513
	Dec     49.56218
	AppMagn 13.374
	MassSol 1.319
	RadSol  1.377
	Teff    6823
}

Star	"KOI-3531/KIC 6947164"
{
	RA      19.4237976
	Dec     42.493641
	AppMagn 14.624
	MassSol 0.98
	RadSol  0.904
	Teff    5973
}

Star	"KOI-3536/KIC 7987086"
{
	RA      19.97761027
	Dec     43.762989
	AppMagn 13.375
	MassSol 0.969
	RadSol  1.084
	Teff    6002
}

Star	"KOI-3541/KIC 8868364"
{
	RA      18.95048013
	Dec     45.118668
	AppMagn 13.769
	MassSol 1.152
	RadSol  1.708
	Teff    6235
}

Star	"KOI-3545/KIC 8244173"
{
	RA      19.70040693
	Dec     44.110538
	AppMagn 15.896
	MassSol 0.566
	RadSol  0.576
	Teff    4556
}

Star	"KOI-3554/KIC 6426592"
{
	RA      19.04010827
	Dec     41.817532
	AppMagn 15.207
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-3557/KIC 5534965"
{
	RA      19.48402913
	Dec     40.703678
	AppMagn 13.297
	MassSol 1.041
	RadSol  1.183
	Teff    6462
}

Star	"KOI-3560/KIC 4848423"
{
	RA      19.68116453
	Dec     39.910042
	AppMagn 11.825
	MassSol 0.769
	RadSol  0.989
	Teff    6466
}

Star	"KOI-3565/KIC 9592575"
{
	RA      19.57795613
	Dec     46.297459
	AppMagn 15.902
	MassSol 1.067
	RadSol  0.958
	Teff    5640
}

Star	"KOI-3573/KIC 10068919"
{
	RA      19.28427733
	Dec     47.005989
	AppMagn 13.676
	MassSol 1.072
	RadSol  1.216
	Teff    6403
}

Star	"KOI-3583/KIC 5130740"
{
	RA      19.94796347
	Dec     40.212311
	AppMagn 12.504
	MassSol 1.665
	RadSol  2.017
	Teff    7591
}

Star	"KOI-3602/KIC 10845188"
{
	RA      18.9035014
	Dec     48.222939
	AppMagn 13.867
	MassSol 0.853
	RadSol  1.02
	Teff    5940
}

Star	"KOI-3605/KIC 6137704"
{
	RA      19.72255653
	Dec     41.427319
	AppMagn 14.16
	MassSol 0.668
	RadSol  0.696
	Teff    5126
}

Star	"KOI-3606/KIC 10275074"
{
	RA      19.48451333
	Dec     47.394798
	AppMagn 14.182
	MassSol 1.23
	RadSol  1.393
	Teff    6570
}

Star	"KOI-3608/KIC 10259301"
{
	RA      18.98768313
	Dec     47.392632
	AppMagn 13.556
	MassSol 0.997
	RadSol  0.993
	Teff    6105
}

Star	"KOI-3611/KIC 6675060"
{
	RA      19.0829936
	Dec     42.146431
	AppMagn 16.51
	MassSol 0.972
	RadSol  1.005
	Teff    6137
}

Star	"KOI-3617/KIC 10735564"
{
	RA      19.57162473
	Dec     48.007439
	AppMagn 14.567
	MassSol 2.05
	RadSol  2.451
	Teff    8285
}

Star	"KOI-3620/KIC 11499263"
{
	RA      19.1603434
	Dec     49.456291
	AppMagn 15.267
	MassSol 0.687
	RadSol  0.756
	Teff    5772
}

Star	"KOI-3626/KIC 12643582"
{
	RA      19.2212504
	Dec     51.725361
	AppMagn 16.442
	MassSol 0.913
	RadSol  0.894
	Teff    5881
}

Star	"KOI-3627/KIC 10091110"
{
	RA      19.83108727
	Dec     47.023232
	AppMagn 15.232
	MassSol 1.06
	RadSol  0.991
	Teff    6185
}

Star	"KOI-364/KIC 7296438"
{
	RA      19.72482093
	Dec     42.881149
	AppMagn 10.087
}

Star	"KOI-3647/KIC 9661869"
{
	RA      19.77713827
	Dec     46.38052
	AppMagn 16.677
	MassSol 1.032
	RadSol  1.121
	Teff    6167
}

Star	"KOI-3649/KIC 6066379"
{
	RA      19.87549847
	Dec     41.33427
	AppMagn 15.475
	MassSol 1.057
	RadSol  1.343
	Teff    6282
}

Star	"KOI-3652/KIC 8256044"
{
	RA      19.91170453
	Dec     44.175732
	AppMagn 15.879
	MassSol 0.95
	RadSol  1.415
	Teff    5642
}

Star	"KOI-366/KIC 3545478"
{
	RA      19.444279
	Dec     38.619255
	AppMagn 11.714
	MassSol 1.694
	RadSol  3.354
	Teff    6201
}

Star	"KOI-3660/KIC 5103998"
{
	RA      19.5438436
	Dec     40.262711
	AppMagn 15.549
	MassSol 0.88
	RadSol  0.802
	Teff    5693
}

Star	"KOI-367/KIC 4815520"
{
	RA      18.9648112
	Dec     39.911812
	AppMagn 11.105
	MassSol 1.045
	RadSol  0.979
	Teff    5750
}

Star	"KOI-3674/KIC 2446623"
{
	RA      19.47768553
	Dec     37.794048
	AppMagn 15.62
	MassSol 0.911
	RadSol  0.825
	Teff    6024
}

Star	"KOI-3675/KIC 9596089"
{
	RA      19.66415
	Dec     46.225609
	AppMagn 16.583
	MassSol 0.741
	RadSol  0.812
	Teff    5378
}

Star	"KOI-368/KIC 6603043"
{
	RA      19.39027778
	Dec     42.08694445
	AppMagn 11.3
	Class  "F6"
	MassSol 2.17
	RadSol  2.043
	Teff    9257
	FeH     0.07
}

Star	"KOI-3680/KIC 9025971"
{
	RA      19.55210367
	Dec     45.309669
	AppMagn 14.524
	MassSol 1.004
	RadSol  0.913
	Teff    5926
}

Star	"KOI-3689/KIC 7017372"
{
	RA      19.0647868
	Dec     42.545712
	AppMagn 14.014
	MassSol 1.073
	RadSol  1.321
	Teff    6429
}

Star	"KOI-3690/KIC 9715939"
{
	RA      19.61132607
	Dec     46.425289
	AppMagn 15.517
	MassSol 1.086
	RadSol  1.408
	Teff    6387
}

Star	"KOI-3692/KIC 5903301"
{
	RA      19.910555
	Dec     41.138882
	AppMagn 15.149
	MassSol 1.009
	RadSol  1.382
	Teff    6200
}

Star	"KOI-3696/KIC 5435816"
{
	RA      19.17492067
	Dec     40.605469
	AppMagn 15.684
	MassSol 1.117
	RadSol  1.012
	Teff    6063
}

Star	"KOI-3709/KIC 2576107"
{
	RA      19.43487547
	Dec     37.887642
	AppMagn 15.247
	MassSol 1
	RadSol  0.915
	Teff    6328
}

Star	"KOI-371/KIC 5652983"
{
	RA      19.9784098
	Dec     40.856491
	AppMagn 12.193
	MassSol 1.552
	RadSol  3.207
	Teff    5198
}

Star	"KOI-3715/KIC 4937143"
{
	RA      19.6892558
	Dec     40.037289
	AppMagn 16.35
	MassSol 1.146
	RadSol  1.276
	Teff    6907
}

Star	"KOI-3717/KIC 11241814"
{
	RA      19.3721924
	Dec     48.960411
	AppMagn 14.984
	MassSol 0.959
	RadSol  1.007
	Teff    6124
}

Star	"KOI-3720/KIC 10735331"
{
	RA      19.56604413
	Dec     48.095371
	AppMagn 13.381
	MassSol 1.342
	RadSol  1.465
	Teff    6953
}

Star	"KOI-3721/KIC 7763269"
{
	RA      19.6769938
	Dec     43.444321
	AppMagn 14.078
	MassSol 1.017
	RadSol  1.194
	Teff    6261
}

Star	"KOI-3726/KIC 6973796"
{
	RA      19.8749308
	Dec     42.403172
	AppMagn 15.852
	MassSol 0.725
	RadSol  0.735
	Teff    4530
}

Star	"KOI-373/KIC 7364176"
{
	RA      19.48232827
	Dec     42.909458
	AppMagn 12.765
	MassSol 0.784
	RadSol  0.989
	Teff    5712
}

Star	"KOI-3735/KIC 2166200"
{
	RA      19.51558027
	Dec     37.559311
	AppMagn 17.637
	MassSol 1.19
	RadSol  1.418
	Teff    6572
}

Star	"KOI-3738/KIC 5478083"
{
	RA      19.9341512
	Dec     40.660034
	AppMagn 17.518
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-3742/KIC 5565486"
{
	RA      19.9585388
	Dec     40.757359
	AppMagn 14.964
	MassSol 1.155
	RadSol  1.135
	Teff    6609
}

Star	"KOI-3749/KIC 11547869"
{
	RA      19.00051473
	Dec     49.503979
	AppMagn 16.415
	MassSol 0.208
	RadSol  0.225
	Teff    3311
}

Star	"KOI-375/KIC 12356617"
{
	RA      19.41341347
	Dec     51.144279
	AppMagn 13.293
	MassSol 1.105
	RadSol  1.549
	Teff    5755
}

Star	"KOI-3765/KIC 12109845"
{
	RA      19.3946106
	Dec     50.696388
	AppMagn 16.44
	MassSol 0.492
	RadSol  0.469
	Teff    4561
}

Star	"KOI-3767/KIC 8323764"
{
	RA      19.9387044
	Dec     44.29501
	AppMagn 17.376
	MassSol 0.752
	RadSol  0.8
	Teff    5159
}

Star	"KOI-3770/KIC 5008245"
{
	RA      19.39578047
	Dec     40.12492
	AppMagn 14.103
	MassSol 1.267
	RadSol  1.217
	Teff    6357
}

Star	"KOI-3771/KIC 10555365"
{
	RA      19.91807253
	Dec     47.785412
	AppMagn 16.605
	MassSol 0.826
	RadSol  0.921
	Teff    5687
}

Star	"KOI-3780/KIC 6775985"
{
	RA      19.42578327
	Dec     42.260509
	AppMagn 14.069
	MassSol 1.204
	RadSol  1.361
	Teff    6770
}

Star	"KOI-3782/KIC 11357192"
{
	RA      19.67248333
	Dec     49.169899
	AppMagn 13.529
	MassSol 1.421
	RadSol  2.99
	Teff    5018
}

Star	"KOI-3783/KIC 9533489"
{
	RA      19.6449178
	Dec     46.122673
	AppMagn 12.962
	MassSol 1.69
	RadSol  1.935
	Teff    7214
}

Star	"KOI-3784/KIC 5688997"
{
	RA      19.0561198
	Dec     40.925449
	AppMagn 14.219
	MassSol 1.007
	RadSol  1.166
	Teff    6022
}

Star	"KOI-3787/KIC 7813039"
{
	RA      19.22927447
	Dec     43.505249
	AppMagn 13.891
	MassSol 0.996
	RadSol  1.099
	Teff    5993
}

Star	"KOI-379/KIC 2446113"
{
	RA      19.47045087
	Dec     37.776192
	AppMagn 13.319
	MassSol 1.244
	RadSol  1.594
	Teff    6546
}

Star	"KOI-3801/KIC 8827930"
{
	RA      19.68046267
	Dec     45.09819
	AppMagn 15.999
	MassSol 1.083
	RadSol  0.965
	Teff    5825
}

Star	"KOI-3811/KIC 4638237"
{
	RA      19.0768738
	Dec     39.714901
	AppMagn 13.906
	MassSol 0.7
	RadSol  0.763
	Teff    5551
}

Star	"KOI-3815/KIC 6507433"
{
	RA      19.10058393
	Dec     41.922741
	AppMagn 15.432
	MassSol 1.149
	RadSol  1.064
	Teff    6167
}

Star	"KOI-3818/KIC 6515722"
{
	RA      19.3159444
	Dec     41.965271
	AppMagn 11.721
	MassSol 2.294
	RadSol  2.471
	Teff    9174
}

Star	"KOI-3823/KIC 4820550"
{
	RA      19.11809693
	Dec     39.983822
	AppMagn 13.922
	MassSol 0.965
	RadSol  0.87
	Teff    5817
}

Star	"KOI-3830/KIC 10676927"
{
	RA      19.74330447
	Dec     47.937832
	AppMagn 17.022
	MassSol 0.817
	RadSol  0.76
	Teff    5661
}

Star	"KOI-3837/KIC 9761573"
{
	RA      19.1581136
	Dec     46.564838
	AppMagn 14.114
	MassSol 1.057
	RadSol  1.188
	Teff    6540
}

Star	"KOI-3855/KIC 2558370"
{
	RA      19.14239707
	Dec     37.838306
	AppMagn 18.55
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-3864/KIC 4164922"
{
	RA      19.5563314
	Dec     39.257809
	AppMagn 12.914
	MassSol 0.717
	RadSol  0.747
	Teff    5019
}

Star	"KOI-3875/KIC 11911561"
{
	RA      19.34327593
	Dec     50.239178
	AppMagn 13.579
	MassSol 0.888
	RadSol  1.514
	Teff    6022
}

Star	"KOI-3876/KIC 3440118"
{
	RA      19.3627116
	Dec     38.52356
	AppMagn 12.624
	MassSol 0.887
	RadSol  1.173
	Teff    5839
}

Star	"KOI-388/KIC 3831053"
{
	RA      18.9804606
	Dec     38.936821
	AppMagn 13.644
	MassSol 1.08
	RadSol  1.775
	Teff    5687
}

Star	"KOI-3880/KIC 4147444"
{
	RA      19.25782473
	Dec     39.264961
	AppMagn 10.762
	MassSol 1.054
	RadSol  1.166
	Teff    6438
}

Star	"KOI-3886/KIC 8848288"
{
	RA      20.06982013
	Dec     45.087631
	AppMagn 9.837
	MassSol 2.088
	RadSol  12.536
	Teff    4781
}

Star	"KOI-3890/KIC 8564976"
{
	RA      19.58480833
	Dec     44.63847
	AppMagn 13.226
	MassSol 1.761
	RadSol  7.506
	Teff    4991
}

Star	"KOI-3891/KIC 8765560"
{
	RA      19.74373373
	Dec     44.92009
	AppMagn 13.731
	MassSol 1.115
	RadSol  2.78
	Teff    5258
}

Star	"KOI-3907/KIC 7137213"
{
	RA      19.79985353
	Dec     42.65332
	AppMagn 12.642
	MassSol 1.11
	RadSol  1.589
	Teff    6498
}

Star	"KOI-3908/KIC 10363115"
{
	RA      19.97222493
	Dec     47.448078
	AppMagn 12.07
	MassSol 1.675
	RadSol  4.015
	Teff    5897
}

Star	"KOI-3909/KIC 5966810"
{
	RA      19.58788653
	Dec     41.21146
	AppMagn 14.948
	MassSol 1.008
	RadSol  0.921
	Teff    6351
}

Star	"KOI-3913/KIC 10281221"
{
	RA      19.64083453
	Dec     47.343262
	AppMagn 14.972
	MassSol 1.068
	RadSol  1.009
	Teff    6263
}

Star	"KOI-3923/KIC 5015459"
{
	RA      19.53835853
	Dec     40.122139
	AppMagn 15.557
	MassSol 0.557
	RadSol  0.572
	Teff    4340
}

Star	"KOI-3933/KIC 11244682"
{
	RA      19.47582193
	Dec     48.917191
	AppMagn 14.678
	MassSol 0.791
	RadSol  0.724
	Teff    5513
}

Star	"KOI-3936/KIC 4947556"
{
	RA      19.83847453
	Dec     40.02771
	AppMagn 13.336
	MassSol 0.844
	RadSol  0.844
	Teff    5083
}

Star	"KOI-3939/KIC 9593528"
{
	RA      19.60187987
	Dec     46.201771
	AppMagn 15.21
	MassSol 1.005
	RadSol  1.249
	Teff    6296
}

Star	"KOI-3943/KIC 7679812"
{
	RA      19.3914856
	Dec     43.333
	AppMagn 12.626
	MassSol 1.119
	RadSol  1.402
	Teff    6478
}

Star	"KOI-3947/KIC 5952366"
{
	RA      19.2851054
	Dec     41.259754
	AppMagn 13.38
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-3991/KIC 10352333"
{
	RA      19.76690267
	Dec     47.486919
	AppMagn 13.14
	MassSol 0.66
	RadSol  0.693
	Teff    5565
}

Star	"KOI-4002/KIC 5773121"
{
	RA      19.02210287
	Dec     41.063911
	AppMagn 15.04
	MassSol 0.978
	RadSol  0.93
	Teff    5396
}

Star	"KOI-4004/KIC 4814502"
{
	RA      18.9330058
	Dec     39.917
	AppMagn 12.697
	MassSol 0.939
	RadSol  1.916
	Teff    5759
}

Star	"KOI-4007/KIC 8376848"
{
	RA      19.71659953
	Dec     44.37476
	AppMagn 15.472
	MassSol 1.072
	RadSol  1.009
	Teff    6208
}

Star	"KOI-4011/KIC 11969988"
{
	RA      19.67021487
	Dec     50.34774
	AppMagn 12.521
	MassSol 1.092
	RadSol  1.136
	Teff    6205
}

Star	"KOI-4014/KIC 9009953"
{
	RA      19.12998047
	Dec     45.353828
	AppMagn 13.685
	MassSol 1.249
	RadSol  1.167
	Teff    6299
}

Star	"KOI-4021/KIC 11967788"
{
	RA      19.60229087
	Dec     50.371651
	AppMagn 13.166
	MassSol 1.509
	RadSol  1.937
	Teff    7232
}

Star	"KOI-4022/KIC 7733731"
{
	RA      18.875236
	Dec     43.45686
	AppMagn 13.269
	MassSol 0.929
	RadSol  1.076
	Teff    6110
}

Star	"KOI-403/KIC 4247092"
{
	RA      19.12531127
	Dec     39.378391
	AppMagn 14.169
	MassSol 0.895
	RadSol  0.945
	Teff    5782
}

Star	"KOI-4037/KIC 8264402"
{
	RA      20.06304527
	Dec     44.164688
	AppMagn 12.853
	MassSol 1.185
	RadSol  1.344
	Teff    6532
}

Star	"KOI-4053/KIC 1718958"
{
	RA      19.3946228
	Dec     37.28717
	AppMagn 12.801
	MassSol 1.061
	RadSol  1.052
	Teff    6187
}

Star	"KOI-4054/KIC 6428794"
{
	RA      19.10725913
	Dec     41.889339
	AppMagn 14.566
	MassSol 0.864
	RadSol  0.779
	Teff    5380
}

Star	"KOI-4056/KIC 4673628"
{
	RA      19.76024987
	Dec     39.722649
	AppMagn 14.368
	MassSol 0.845
	RadSol  0.899
	Teff    5570
}

Star	"KOI-4060/KIC 9086154"
{
	RA      19.3889262
	Dec     45.43565
	AppMagn 13.841
	MassSol 0.937
	RadSol  0.892
	Teff    5984
}

Star	"KOI-4062/KIC 11858979"
{
	RA      19.26059167
	Dec     50.16283
	AppMagn 14.077
	MassSol 0.986
	RadSol  1.116
	Teff    6238
}

Star	"KOI-4066/KIC 8686373"
{
	RA      19.38200073
	Dec     44.836121
	AppMagn 13.666
	MassSol 1.419
	RadSol  1.854
	Teff    6501
}

Star	"KOI-4067/KIC 5530112"
{
	RA      19.37722573
	Dec     40.778542
	AppMagn 14.158
	MassSol 1.181
	RadSol  1.222
	Teff    6450
}

Star	"KOI-4069/KIC 5906694"
{
	RA      19.9567932
	Dec     41.19574
	AppMagn 14.885
	MassSol 0.646
	RadSol  0.655
	Teff    4522
}

Star	"KOI-4097/KIC 5688683"
{
	RA      19.04600013
	Dec     40.99453
	AppMagn 13.435
	MassSol 0.643
	RadSol  0.62
	Teff    4358
}

Star	"KOI-4098/KIC 8222627"
{
	RA      19.16691693
	Dec     44.167259
	AppMagn 13.875
	MassSol 1.157
	RadSol  2.571
	Teff    5023
}

Star	"KOI-4099/KIC 8951205"
{
	RA      19.41361287
	Dec     45.238392
	AppMagn 15.309
	MassSol 0.782
	RadSol  0.725
	Teff    5435
}

Star	"KOI-410/KIC 5449777"
{
	RA      19.48320107
	Dec     40.696049
	AppMagn 14.454
	MassSol 0.974
	RadSol  1.056
	Teff    6266
}

Star	"KOI-4109/KIC 7907808"
{
	RA      19.80553387
	Dec     43.679951
	AppMagn 14.511
	MassSol 0.944
	RadSol  1.755
	Teff    4968
}

Star	"KOI-4120/KIC 9700449"
{
	RA      19.135968
	Dec     46.481701
	AppMagn 15.092
	MassSol 1.084
	RadSol  1.031
	Teff    6297
}

Star	"KOI-4123/KIC 6140059"
{
	RA      19.75710653
	Dec     41.455391
	AppMagn 13.519
	MassSol 0.998
	RadSol  1.239
	Teff    6198
}

Star	"KOI-4129/KIC 11970988"
{
	RA      19.70196533
	Dec     50.370399
	AppMagn 13.506
	MassSol 0.833
	RadSol  0.923
	Teff    5240
}

Star	"KOI-4135/KIC 5386264"
{
	RA      19.85152793
	Dec     40.589088
	AppMagn 14.844
	MassSol 0.663
	RadSol  0.613
	Teff    4750
}

Star	"KOI-4136/KIC 7256914"
{
	RA      18.78821207
	Dec     42.811169
	AppMagn 13.955
	MassSol 0.943
	RadSol  0.853
	Teff    5770
}

Star	"KOI-4145/KIC 3103212"
{
	RA      19.18393553
	Dec     38.281551
	AppMagn 14.359
	MassSol 0.92
	RadSol  0.878
	Teff    5618
}

Star	"KOI-4149/KIC 10875007"
{
	RA      19.79747313
	Dec     48.25639
	AppMagn 14.718
	MassSol 1.266
	RadSol  1.259
	Teff    6271
}

Star	"KOI-415/KIC 6289650"
{
	RA      19.5537374
	Dec     41.606369
	AppMagn 14.11
	MassSol 0.936
	RadSol  1.074
	Teff    6063
}

Star	"KOI-4150/KIC 11465651"
{
	RA      19.77513633
	Dec     49.353901
	AppMagn 14.681
	MassSol 1.241
	RadSol  1.171
	Teff    6418
}

Star	"KOI-4152/KIC 7199060"
{
	RA      19.42573447
	Dec     42.709129
	AppMagn 12.972
	MassSol 1.407
	RadSol  1.571
	Teff    6955
}

Star	"KOI-4153/KIC 8439323"
{
	RA      19.66537273
	Dec     44.425301
	AppMagn 14.667
	MassSol 0.852
	RadSol  0.797
	Teff    5834
}

Star	"KOI-4156/KIC 5881120"
{
	RA      19.5545512
	Dec     41.116669
	AppMagn 13.809
	MassSol 1.055
	RadSol  0.973
	Teff    6032
}

Star	"KOI-4157/KIC 4548098"
{
	RA      19.160671
	Dec     39.65868
	AppMagn 12.692
	MassSol 1.306
	RadSol  1.491
	Teff    6597
}

Star	"KOI-4166/KIC 4078311"
{
	RA      19.76736653
	Dec     39.173321
	AppMagn 15.308
	MassSol 1.066
	RadSol  0.974
	Teff    5589
}

Star	"KOI-417/KIC 6879865"
{
	RA      19.74996947
	Dec     42.33548
	AppMagn 14.847
	MassSol 0.985
	RadSol  0.892
	Teff    5883
}

Star	"KOI-4178/KIC 5197233"
{
	RA      19.64234413
	Dec     40.322128
	AppMagn 14.404
	MassSol 1.149
	RadSol  1.13
	Teff    6640
}

Star	"KOI-4184/KIC 6752002"
{
	RA      18.7932088
	Dec     42.28587
	AppMagn 13.473
	MassSol 0.767
	RadSol  0.804
	Teff    4991
}

Star	"KOI-4185/KIC 7257966"
{
	RA      18.82237547
	Dec     42.84544
	AppMagn 15.556
	MassSol 0.887
	RadSol  0.873
	Teff    5505
}

Star	"KOI-4188/KIC 6879171"
{
	RA      19.740271
	Dec     42.34259
	AppMagn 13.128
	MassSol 0.984
	RadSol  1.686
	Teff    6040
}

Star	"KOI-419/KIC 8219673"
{
	RA      19.05941567
	Dec     44.181728
	AppMagn 14.519
	MassSol 1.019
	RadSol  0.932
	Teff    6003
}

Star	"KOI-4198/KIC 9072639"
{
	RA      18.923527
	Dec     45.48526
	AppMagn 12.638
	MassSol 1.022
	RadSol  1.325
	Teff    6312
}

Star	"KOI-4205/KIC 3450040"
{
	RA      19.53693847
	Dec     38.54179
	AppMagn 14.391
	MassSol 0.98
	RadSol  0.889
	Teff    5912
}

Star	"KOI-4207/KIC 9456281"
{
	RA      19.18700153
	Dec     46.00116
	AppMagn 15.397
	MassSol 0.526
	RadSol  0.536
	Teff    4239
}

Star	"KOI-4208/KIC 5129453"
{
	RA      19.9323344
	Dec     40.203709
	AppMagn 15.745
	MassSol 0.723
	RadSol  0.731
	Teff    4483
}

Star	"KOI-4209/KIC 7918478"
{
	RA      19.97774453
	Dec     43.619469
	AppMagn 15.96
	MassSol 0.758
	RadSol  0.717
	Teff    5396
}

Star	"KOI-422/KIC 9214713"
{
	RA      19.35932213
	Dec     45.665329
	AppMagn 14.74
	MassSol 0.993
	RadSol  1.047
	Teff    6230
}

Star	"KOI-4226/KIC 9491832"
{
	RA      20.03749387
	Dec     46.037819
	AppMagn 12.83
	MassSol 1.131
	RadSol  1.491
	Teff    5818
}

Star	"KOI-4235/KIC 10794974"
{
	RA      19.3948466
	Dec     48.180328
	AppMagn 13.224
	MassSol 1.268
	RadSol  1.422
	Teff    6609
}

Star	"KOI-4242/KIC 9514372"
{
	RA      19.04400433
	Dec     46.143471
	AppMagn 14.41
	MassSol 1.101
	RadSol  0.993
	Teff    6014
}

Star	"KOI-4245/KIC 12737015"
{
	RA      19.36533813
	Dec     51.965012
	AppMagn 13.572
	MassSol 1.23
	RadSol  1.528
	Teff    6028
}

Star	"KOI-425/KIC 9967884"
{
	RA      19.86494953
	Dec     46.804562
	AppMagn 14.694
	MassSol 1.075
	RadSol  0.965
	Teff    5936
}

Star	"KOI-4251/KIC 8741470"
{
	RA      19.09022627
	Dec     44.961182
	AppMagn 13.795
	MassSol 0.956
	RadSol  1.143
	Teff    5751
}

Star	"KOI-4252/KIC 10525049"
{
	RA      19.15760293
	Dec     47.78521
	AppMagn 13.977
	MassSol 0.531
	RadSol  0.526
	Teff    3842
}

Star	"KOI-4253/KIC 9202434"
{
	RA      18.915035
	Dec     45.676849
	AppMagn 14.201
	MassSol 1.232
	RadSol  1.162
	Teff    6392
}

Star	"KOI-4257/KIC 7901016"
{
	RA      19.6755534
	Dec     43.631432
	AppMagn 13.34
	MassSol 1.027
	RadSol  1.763
	Teff    5745
}

Star	"KOI-4259/KIC 5785279"
{
	RA      19.3341634
	Dec     41.089989
	AppMagn 15.195
	MassSol 0.885
	RadSol  0.996
	Teff    5486
}

Star	"KOI-426/KIC 10016874"
{
	RA      19.601532
	Dec     46.99955
	AppMagn 14.733
	MassSol 1.004
	RadSol  1.138
	Teff    6072
}

Star	"KOI-4267/KIC 7450747"
{
	RA      19.56948647
	Dec     43.0261
	AppMagn 15.201
	MassSol 1.009
	RadSol  0.989
	Teff    6131
}

Star	"KOI-4269/KIC 8890924"
{
	RA      19.58645627
	Dec     45.160728
	AppMagn 13.263
	MassSol 1.373
	RadSol  3.062
	Teff    5159
}

Star	"KOI-4273/KIC 9716028"
{
	RA      19.61398927
	Dec     46.479969
	AppMagn 12.677
	MassSol 1.065
	RadSol  1.127
	Teff    6122
}

Star	"KOI-4274/KIC 6223324"
{
	RA      19.78743893
	Dec     41.51569
	AppMagn 15.276
	MassSol 1.022
	RadSol  0.947
	Teff    6065
}

Star	"KOI-4287/KIC 11081504"
{
	RA      19.36388753
	Dec     48.661369
	AppMagn 11.265
	MassSol 1.194
	RadSol  1.517
	Teff    6344
}

Star	"KOI-4294/KIC 7681230"
{
	RA      19.4242818
	Dec     43.385921
	AppMagn 14.843
	MassSol 1.088
	RadSol  1.031
	Teff    6241
}

Star	"KOI-4296/KIC 7661893"
{
	RA      18.84241127
	Dec     43.3661
	AppMagn 13.03
	MassSol 0.995
	RadSol  1.113
	Teff    6171
}

Star	"KOI-4298/KIC 2852941"
{
	RA      19.43622847
	Dec     38.048759
	AppMagn 13.458
	MassSol 1.407
	RadSol  1.662
	Teff    7051
}

Star	"KOI-4302/KIC 6290935"
{
	RA      19.5787516
	Dec     41.611969
	AppMagn 13.591
	MassSol 1.027
	RadSol  1.215
	Teff    6529
}

Star	"KOI-4303/KIC 12734396"
{
	RA      19.26063433
	Dec     51.930561
	AppMagn 15.511
	MassSol 0.935
	RadSol  0.847
	Teff    5835
}

Star	"KOI-4318/KIC 9286088"
{
	RA      19.59588827
	Dec     45.719021
	AppMagn 12.583
	MassSol 1.308
	RadSol  1.427
	Teff    6714
}

Star	"KOI-4320/KIC 5095082"
{
	RA      19.36665853
	Dec     40.287689
	AppMagn 14.216
	MassSol 0.782
	RadSol  0.9
	Teff    5497
}

Star	"KOI-4323/KIC 5385410"
{
	RA      19.838796
	Dec     40.5313
	AppMagn 13.582
	MassSol 1.123
	RadSol  1.506
	Teff    6290
}

Star	"KOI-4325/KIC 7749002"
{
	RA      19.35944827
	Dec     43.440338
	AppMagn 15.682
	MassSol 1.075
	RadSol  0.965
	Teff    5936
}

Star	"KOI-4329/KIC 12456063"
{
	RA      19.267452
	Dec     51.376019
	AppMagn 12.018
	MassSol 1.037
	RadSol  1.009
	Teff    6338
}

Star	"KOI-4331/KIC 5096053"
{
	RA      19.38757733
	Dec     40.254875
	AppMagn 13.228
	MassSol 1.299
	RadSol  1.637
	Teff    6674
}

Star	"KOI-4333/KIC 2576962"
{
	RA      19.4467
	Dec     37.843731
	AppMagn 14.205
	MassSol 1.067
	RadSol  1.057
	Teff    6060
}

Star	"KOI-4334/KIC 10140274"
{
	RA      19.43454587
	Dec     47.139301
	AppMagn 15.849
	MassSol 0.723
	RadSol  0.738
	Teff    4849
}

Star	"KOI-4341/KIC 6792908"
{
	RA      19.730839
	Dec     42.200256
	AppMagn 13.264
	MassSol 1.057
	RadSol  1.268
	Teff    6734
}

Star	"KOI-4343/KIC 8087812"
{
	RA      19.20509847
	Dec     43.958488
	AppMagn 13.694
	MassSol 0.922
	RadSol  1.305
	Teff    5973
}

Star	"KOI-4345/KIC 10534155"
{
	RA      19.43341473
	Dec     47.74773
	AppMagn 13.404
	MassSol 0.804
	RadSol  1.455
	Teff    5776
}

Star	"KOI-4346/KIC 9509343"
{
	RA      18.850708
	Dec     46.177841
	AppMagn 14.93
	MassSol 0.893
	RadSol  0.991
	Teff    5467
}

Star	"KOI-4351/KIC 5436161"
{
	RA      19.18394367
	Dec     40.65704
	AppMagn 14.999
	MassSol 0.608
	RadSol  0.612
	Teff    5136
}

Star	"KOI-4353/KIC 4571844"
{
	RA      19.62808433
	Dec     39.628471
	AppMagn 15.574
	MassSol 0.988
	RadSol  0.981
	Teff    6194
}

Star	"KOI-4357/KIC 3550372"
{
	RA      19.527181
	Dec     38.68309
	AppMagn 15.069
	MassSol 0.668
	RadSol  0.696
	Teff    5081
}

Star	"KOI-4358/KIC 7191646"
{
	RA      19.27220867
	Dec     42.70414
	AppMagn 15.716
	MassSol 1.048
	RadSol  0.969
	Teff    6075
}

Star	"KOI-436/KIC 11805075"
{
	RA      19.1104594
	Dec     50.021568
	AppMagn 14.74
	MassSol 0.974
	RadSol  0.869
	Teff    5457
}

Star	"KOI-4361/KIC 7801070"
{
	RA      18.810909
	Dec     43.510132
	AppMagn 15.183
	MassSol 0.893
	RadSol  0.972
	Teff    5579
}

Star	"KOI-4363/KIC 9776794"
{
	RA      19.62434287
	Dec     46.501759
	AppMagn 16.084
	MassSol 0.862
	RadSol  0.958
	Teff    5162
}

Star	"KOI-4366/KIC 10647452"
{
	RA      18.8609314
	Dec     47.970299
	AppMagn 15.556
	MassSol 0.781
	RadSol  0.744
	Teff    5377
}

Star	"KOI-4367/KIC 4773392"
{
	RA      19.86887007
	Dec     39.883179
	AppMagn 13.985
	MassSol 1.02
	RadSol  0.953
	Teff    6263
}

Star	"KOI-4372/KIC 9702006"
{
	RA      19.197876
	Dec     46.470612
	AppMagn 15.485
	MassSol 0.761
	RadSol  0.72
	Teff    4859
}

Star	"KOI-4374/KIC 10991114"
{
	RA      19.87889407
	Dec     48.44381
	AppMagn 14.108
	MassSol 0.848
	RadSol  0.776
	Teff    5505
}

Star	"KOI-4377/KIC 4945764"
{
	RA      19.81072593
	Dec     40.042858
	AppMagn 13.543
	MassSol 1.502
	RadSol  2.786
	Teff    6423
}

Star	"KOI-4386/KIC 8480582"
{
	RA      18.99816693
	Dec     44.567551
	AppMagn 15.789
	MassSol 0.829
	RadSol  0.744
	Teff    5243
}

Star	"KOI-4389/KIC 2997459"
{
	RA      19.5420654
	Dec     38.159679
	AppMagn 15.05
	MassSol 0.834
	RadSol  0.859
	Teff    5410
}

Star	"KOI-4390/KIC 8330207"
{
	RA      20.06165567
	Dec     44.24968
	AppMagn 16.494
	MassSol 1.39
	RadSol  3.739
	Teff    5234
}

Star	"KOI-4391/KIC 6359926"
{
	RA      19.35967
	Dec     41.78157
	AppMagn 14.955
	MassSol 0.943
	RadSol  0.917
	Teff    5952
}

Star	"KOI-4393/KIC 8324518"
{
	RA      19.95177207
	Dec     44.291981
	AppMagn 15.295
	MassSol 0.896
	RadSol  0.811
	Teff    5398
}

Star	"KOI-4395/KIC 3103473"
{
	RA      19.18933307
	Dec     38.255489
	AppMagn 15.686
	MassSol 0.829
	RadSol  0.744
	Teff    5243
}

Star	"KOI-4398/KIC 5802637"
{
	RA      19.68075153
	Dec     41.086971
	AppMagn 15.486
	MassSol 0.919
	RadSol  0.836
	Teff    5561
}

Star	"KOI-4399/KIC 8345384"
{
	RA      18.80859173
	Dec     44.303162
	AppMagn 11.965
	MassSol 0.887
	RadSol  1.946
	Teff    5654
}

Star	"KOI-4403/KIC 7703882"
{
	RA      19.866862
	Dec     43.35461
	AppMagn 15.741
	MassSol 0.935
	RadSol  0.847
	Teff    5835
}

Star	"KOI-4405/KIC 10745365"
{
	RA      19.7930664
	Dec     48.04726
	AppMagn 14.671
	MassSol 1.035
	RadSol  0.986
	Teff    6210
}

Star	"KOI-4407/KIC 8396660"
{
	RA      20.07710367
	Dec     44.379532
	AppMagn 11.179
	MassSol 1.05
	RadSol  1.536
	Teff    6331
}

Star	"KOI-4409/KIC 5308537"
{
	RA      19.968986
	Dec     40.477779
	AppMagn 12.515
	MassSol 1.066
	RadSol  1.236
	Teff    5826
}

Star	"KOI-4410/KIC 6350882"
{
	RA      19.1361572
	Dec     41.752209
	AppMagn 15.744
	MassSol 1.027
	RadSol  0.951
	Teff    6039
}

Star	"KOI-4418/KIC 2859893"
{
	RA      19.5343262
	Dec     38.012402
	AppMagn 15.954
	MassSol 1.018
	RadSol  0.903
	Teff    5743
}

Star	"KOI-4421/KIC 9836563"
{
	RA      19.6083252
	Dec     46.67289
	AppMagn 12.788
	MassSol 0.981
	RadSol  1.002
	Teff    6183
}

Star	"KOI-4423/KIC 3866536"
{
	RA      19.7001404
	Dec     38.98354
	AppMagn 13.099
	MassSol 1.014
	RadSol  0.95
	Teff    6312
}

Star	"KOI-4426/KIC 8240790"
{
	RA      19.6300252
	Dec     44.166779
	AppMagn 13.665
	MassSol 1.084
	RadSol  1.449
	Teff    6282
}

Star	"KOI-4427/KIC 4172805"
{
	RA      19.67444445
	Dec     39.27416668
	Dist    240
	AppMagn 9.34
	MassSol 0.526
	RadSol  0.505
	Teff    3813
	FeH    -0.07
	Age     3.6
}

Star	"KOI-4428/KIC 5126182"
{
	RA      19.8862264
	Dec     40.239632
	AppMagn 14.634
	MassSol 0.865
	RadSol  0.803
	Teff    5790
}

Star	"KOI-4431/KIC 9936080"
{
	RA      18.9149516
	Dec     46.879112
	AppMagn 12.674
	MassSol 1.188
	RadSol  1.394
	Teff    6350
}

Star	"KOI-4435/KIC 8278685"
{
	RA      18.79704587
	Dec     44.261532
	AppMagn 13.517
	MassSol 1.069
	RadSol  1.013
	Teff    6328
}

Star	"KOI-4442/KIC 11124436"
{
	RA      18.9568746
	Dec     48.740211
	AppMagn 14.305
	MassSol 0.909
	RadSol  0.989
	Teff    5942
}

Star	"KOI-4443/KIC 5780855"
{
	RA      19.2378194
	Dec     41.09013
	AppMagn 13.802
	MassSol 1.292
	RadSol  1.433
	Teff    6678
}

Star	"KOI-4444/KIC 11718389"
{
	RA      19.64139813
	Dec     49.89415
	AppMagn 15.583
	MassSol 0.671
	RadSol  0.682
	Teff    4391
}

Star	"KOI-4447/KIC 10604592"
{
	RA      19.58075767
	Dec     47.887539
	AppMagn 14.793
	MassSol 0.745
	RadSol  0.772
	Teff    4904
}

Star	"KOI-4451/KIC 10120548"
{
	RA      18.8130432
	Dec     47.105679
	AppMagn 15.945
	MassSol 0.781
	RadSol  0.705
	Teff    5038
}

Star	"KOI-4452/KIC 4474462"
{
	RA      19.62006633
	Dec     39.519058
	AppMagn 13.821
	MassSol 0.815
	RadSol  1.214
	Teff    5977
}

Star	"KOI-4456/KIC 3557560"
{
	RA      19.644751
	Dec     38.698971
	AppMagn 15.128
	MassSol 0.833
	RadSol  0.768
	Teff    5622
}

Star	"KOI-4457/KIC 12109267"
{
	RA      19.36749473
	Dec     50.649288
	AppMagn 13.815
	MassSol 1.027
	RadSol  1.15
	Teff    6384
}

Star	"KOI-4460/KIC 9947389"
{
	RA      19.3431498
	Dec     46.802872
	AppMagn 14.636
	MassSol 0.869
	RadSol  0.957
	Teff    5802
}

Star	"KOI-4462/KIC 9775385"
{
	RA      19.59019573
	Dec     46.590809
	AppMagn 11.069
	MassSol 1.665
	RadSol  2.015
	Teff    7675
}

Star	"KOI-4463/KIC 6197344"
{
	RA      19.29428507
	Dec     41.51004
	AppMagn 15.598
	MassSol 0.789
	RadSol  0.823
	Teff    5305
}

Star	"KOI-4464/KIC 11357664"
{
	RA      19.68710127
	Dec     49.179668
	AppMagn 15.194
	MassSol 0.627
	RadSol  0.64
	Teff    4362
}

Star	"KOI-4466/KIC 7272132"
{
	RA      19.24257407
	Dec     42.857288
	AppMagn 15.015
	MassSol 1.023
	RadSol  1.002
	Teff    6338
}

Star	"KOI-4467/KIC 5352640"
{
	RA      19.24839887
	Dec     40.531631
	AppMagn 15.907
	MassSol 0.919
	RadSol  0.819
	Teff    5436
}

Star	"KOI-4477/KIC 6276791"
{
	RA      19.27361453
	Dec     41.69014
	AppMagn 15.466
	MassSol 0.947
	RadSol  0.855
	Teff    5733
}

Star	"KOI-4478/KIC 8636600"
{
	RA      19.73481647
	Dec     44.732658
	AppMagn 14.58
	MassSol 0.768
	RadSol  0.811
	Teff    5071
}

Star	"KOI-4480/KIC 10467714"
{
	RA      19.38510333
	Dec     47.64843
	AppMagn 14.122
	MassSol 0.756
	RadSol  0.805
	Teff    5574
}

Star	"KOI-4482/KIC 7778427"
{
	RA      19.93969113
	Dec     43.439098
	AppMagn 12.642
	MassSol 1.199
	RadSol  1.378
	Teff    6362
}

Star	"KOI-4484/KIC 9898017"
{
	RA      19.646464
	Dec     46.720188
	AppMagn 15.079
	MassSol 1.083
	RadSol  1.035
	Teff    6363
}

Star	"KOI-4487/KIC 8098212"
{
	RA      19.46855267
	Dec     43.946362
	AppMagn 14.371
	MassSol 0.828
	RadSol  0.947
	Teff    5382
}

Star	"KOI-449/KIC 5779852"
{
	RA      19.213206
	Dec     41.09417
	AppMagn 14.183
	MassSol 1.016
	RadSol  1.014
	Teff    6348
}

Star	"KOI-4495/KIC 5552562"
{
	RA      19.7849426
	Dec     40.793282
	AppMagn 15.466
	MassSol 1.036
	RadSol  0.977
	Teff    5843
}

Star	"KOI-4496/KIC 6186182"
{
	RA      18.97886147
	Dec     41.592411
	AppMagn 15.602
	MassSol 1.096
	RadSol  1.009
	Teff    5922
}

Star	"KOI-4497/KIC 12645057"
{
	RA      19.28446453
	Dec     51.751221
	AppMagn 15.17
	MassSol 0.887
	RadSol  0.809
	Teff    5817
}

Star	"KOI-4498/KIC 4844367"
{
	RA      19.61475627
	Dec     39.989521
	AppMagn 14.841
	MassSol 1.025
	RadSol  0.947
	Teff    6117
}

Star	"KOI-4499/KIC 10937749"
{
	RA      19.91885173
	Dec     48.312809
	AppMagn 14.652
	MassSol 0.95
	RadSol  0.867
	Teff    6058
}

Star	"KOI-4503/KIC 10907132"
{
	RA      18.97422687
	Dec     48.37347
	AppMagn 15.683
	MassSol 1.054
	RadSol  0.942
	Teff    5869
}

Star	"KOI-4504/KIC 6520753"
{
	RA      19.41960653
	Dec     41.91283
	AppMagn 15.956
	MassSol 0.868
	RadSol  0.803
	Teff    5487
}

Star	"KOI-4505/KIC 8493354"
{
	RA      19.4066284
	Dec     44.545689
	AppMagn 13.615
	MassSol 1.165
	RadSol  1.144
	Teff    6567
}

Star	"KOI-4506/KIC 4545570"
{
	RA      19.08867393
	Dec     39.683182
	AppMagn 15.683
	MassSol 0.859
	RadSol  0.766
	Teff    5396
}

Star	"KOI-4508/KIC 5457326"
{
	RA      19.62490033
	Dec     40.65144
	AppMagn 15.352
	MassSol 0.707
	RadSol  0.72
	Teff    4705
}

Star	"KOI-4509/KIC 11350118"
{
	RA      19.446344
	Dec     49.187859
	AppMagn 15.675
	MassSol 0.58
	RadSol  0.594
	Teff    4328
}

Star	"KOI-4512/KIC 12069414"
{
	RA      19.69670613
	Dec     50.54211
	AppMagn 15.314
	MassSol 0.722
	RadSol  0.776
	Teff    5286
}

Star	"KOI-4519/KIC 10003058"
{
	RA      19.20067547
	Dec     46.978519
	AppMagn 14.744
	MassSol 1.183
	RadSol  1.17
	Teff    6434
}

Star	"KOI-4520/KIC 9031703"
{
	RA      19.68095093
	Dec     45.324509
	AppMagn 14.276
	MassSol 0.873
	RadSol  1.482
	Teff    5491
}

Star	"KOI-4523/KIC 8700895"
{
	RA      19.73628333
	Dec     44.80529
	AppMagn 14.878
	MassSol 0.906
	RadSol  0.84
	Teff    5695
}

Star	"KOI-4524/KIC 5003670"
{
	RA      19.30322673
	Dec     40.1642
	AppMagn 14.955
	MassSol 0.931
	RadSol  0.93
	Teff    5931
}

Star	"KOI-4526/KIC 3765917"
{
	RA      19.7312622
	Dec     38.867168
	AppMagn 15.271
	MassSol 1.083
	RadSol  1.015
	Teff    6148
}

Star	"KOI-4530/KIC 12647577"
{
	RA      19.3822896
	Dec     51.770962
	AppMagn 14.241
	MassSol 0.949
	RadSol  0.867
	Teff    5766
}

Star	"KOI-4541/KIC 5511659"
{
	RA      18.88341267
	Dec     40.72311
	AppMagn 15.377
	MassSol 0.958
	RadSol  0.931
	Teff    5915
}

Star	"KOI-4545/KIC 10140122"
{
	RA      19.430542
	Dec     47.15863
	AppMagn 15.357
	MassSol 0.893
	RadSol  0.788
	Teff    4979
}

Star	"KOI-4546/KIC 5033823"
{
	RA      19.81821693
	Dec     40.136761
	AppMagn 13.469
	MassSol 1.079
	RadSol  1.013
	Teff    6163
}

Star	"KOI-4548/KIC 3223433"
{
	RA      19.20836993
	Dec     38.347431
	AppMagn 14.748
	MassSol 0.718
	RadSol  0.683
	Teff    5423
}

Star	"KOI-4549/KIC 6523058"
{
	RA      19.46841433
	Dec     41.984119
	AppMagn 15.98
	MassSol 0.966
	RadSol  0.871
	Teff    5796
}

Star	"KOI-4550/KIC 5977470"
{
	RA      19.76385093
	Dec     41.266022
	AppMagn 15.429
	MassSol 0.681
	RadSol  0.696
	Teff    4771
}

Star	"KOI-4551/KIC 11769689"
{
	RA      19.67280067
	Dec     49.940079
	AppMagn 14.654
	MassSol 1.058
	RadSol  1.018
	Teff    6102
}

Star	"KOI-4554/KIC 6369131"
{
	RA      19.56231893
	Dec     41.716881
	AppMagn 14.579
	MassSol 0.94
	RadSol  0.844
	Teff    6119
}

Star	"KOI-4556/KIC 10399321"
{
	RA      19.30790407
	Dec     47.557968
	AppMagn 11.981
	MassSol 1.074
	RadSol  2.062
	Teff    5790
}

Star	"KOI-4557/KIC 10257229"
{
	RA      18.91364747
	Dec     47.385288
	AppMagn 13.666
	MassSol 1.093
	RadSol  1.033
	Teff    6210
}

Star	"KOI-4558/KIC 5431027"
{
	RA      19.0396952
	Dec     40.679722
	AppMagn 14.598
	MassSol 0.852
	RadSol  1.121
	Teff    5602
}

Star	"KOI-4563/KIC 10585749"
{
	RA      19.01062827
	Dec     47.88274
	AppMagn 14.487
	MassSol 0.824
	RadSol  1.101
	Teff    5689
}

Star	"KOI-4567/KIC 8332521"
{
	RA      20.10418907
	Dec     44.240391
	AppMagn 13.775
	MassSol 1.006
	RadSol  0.987
	Teff    6146
}

Star	"KOI-4570/KIC 4060229"
{
	RA      19.49040327
	Dec     39.11945
	AppMagn 14.638
	MassSol 1.008
	RadSol  0.925
	Teff    6060
}

Star	"KOI-4575/KIC 9893468"
{
	RA      19.52909547
	Dec     46.753021
	AppMagn 13.174
	MassSol 1.269
	RadSol  1.598
	Teff    6582
}

Star	"KOI-4577/KIC 10610039"
{
	RA      19.7113932
	Dec     47.830399
	AppMagn 14.894
	MassSol 0.926
	RadSol  0.829
	Teff    6068
}

Star	"KOI-458/KIC 7504328"
{
	RA      18.858846
	Dec     43.191952
	AppMagn 14.708
	MassSol 0.912
	RadSol  1.151
	Teff    5833
}

Star	"KOI-4580/KIC 8628761"
{
	RA      19.558254
	Dec     44.727982
	AppMagn 13.01
	MassSol 1.192
	RadSol  1.836
	Teff    6728
}

Star	"KOI-4581/KIC 2572029"
{
	RA      19.37387087
	Dec     37.801891
	AppMagn 13.549
	MassSol 1.05
	RadSol  1.16
	Teff    6103
}

Star	"KOI-4582/KIC 7905106"
{
	RA      19.75579227
	Dec     43.60009
	AppMagn 11.756
	MassSol 1.019
	RadSol  1.586
	Teff    5984
}

Star	"KOI-4583/KIC 9007151"
{
	RA      19.0445618
	Dec     45.374771
	AppMagn 15.77
	MassSol 0.838
	RadSol  0.769
	Teff    5461
}

Star	"KOI-4586/KIC 11506654"
{
	RA      19.4345052
	Dec     49.43462
	AppMagn 14.39
	MassSol 1.041
	RadSol  0.964
	Teff    6122
}

Star	"KOI-4587/KIC 5687700"
{
	RA      19.01494347
	Dec     40.958931
	AppMagn 15.567
	MassSol 0.972
	RadSol  0.883
	Teff    5955
}

Star	"KOI-4588/KIC 8806985"
{
	RA      19.10090333
	Dec     45.038044
	AppMagn 12.912
	MassSol 1.211
	RadSol  1.435
	Teff    6483
}

Star	"KOI-4590/KIC 12204137"
{
	RA      19.2580546
	Dec     50.815559
	AppMagn 15.836
	MassSol 0.839
	RadSol  0.831
	Teff    5271
}

Star	"KOI-4591/KIC 5389956"
{
	RA      19.90283813
	Dec     40.51479
	AppMagn 15.186
	MassSol 0.983
	RadSol  0.891
	Teff    5897
}

Star	"KOI-4595/KIC 12265786"
{
	RA      19.69431967
	Dec     50.979012
	AppMagn 15.509
	MassSol 0.698
	RadSol  0.633
	Teff    4985
}

Star	"KOI-4597/KIC 10873178"
{
	RA      19.7573934
	Dec     48.213001
	AppMagn 14.639
	MassSol 0.84
	RadSol  0.784
	Teff    6021
}

Star	"KOI-4601/KIC 11153476"
{
	RA      19.89565227
	Dec     48.706139
	AppMagn 13.757
	MassSol 1.075
	RadSol  1.064
	Teff    6254
}

Star	"KOI-4602/KIC 6144039"
{
	RA      19.81551513
	Dec     41.433411
	AppMagn 14.636
	MassSol 0.863
	RadSol  0.79
	Teff    5496
}

Star	"KOI-4603/KIC 8430053"
{
	RA      19.43594767
	Dec     44.44706
	AppMagn 13.629
	MassSol 1.173
	RadSol  1.211
	Teff    6453
}

Star	"KOI-4605/KIC 12458605"
{
	RA      19.36153767
	Dec     51.388729
	AppMagn 13.515
	MassSol 0.994
	RadSol  0.954
	Teff    6045
}

Star	"KOI-4613/KIC 10220837"
{
	RA      19.77250367
	Dec     47.207161
	AppMagn 13.885
	MassSol 0.915
	RadSol  0.979
	Teff    5726
}

Star	"KOI-4614/KIC 7583650"
{
	RA      18.78205767
	Dec     43.282341
	AppMagn 13.784
	MassSol 1.194
	RadSol  1.388
	Teff    6475
}

Star	"KOI-4625/KIC 11519187"
{
	RA      19.80393473
	Dec     49.4785
	AppMagn 15.877
	MassSol 0.733
	RadSol  0.71
	Teff    4798
}

Star	"KOI-4626/KIC 3539231"
{
	RA      19.326945
	Dec     38.651371
	AppMagn 14.876
	MassSol 0.845
	RadSol  1.018
	Teff    5918
}

Star	"KOI-4627/KIC 6311891"
{
	RA      19.91722413
	Dec     41.631031
	AppMagn 15.029
	MassSol 0.741
	RadSol  0.714
	Teff    5451
}

Star	"KOI-4630/KIC 7834045"
{
	RA      19.70649007
	Dec     43.596401
	AppMagn 14.875
	MassSol 0.819
	RadSol  0.859
	Teff    5834
}

Star	"KOI-4632/KIC 6070337"
{
	RA      19.9342082
	Dec     41.329311
	AppMagn 15.618
	MassSol 0.796
	RadSol  0.762
	Teff    5485
}

Star	"KOI-4633/KIC 5954001"
{
	RA      19.31863607
	Dec     41.214409
	AppMagn 13.848
	MassSol 1.072
	RadSol  1.717
	Teff    5984
}

Star	"KOI-4634/KIC 8196226"
{
	RA      20.04330647
	Dec     44.05574
	AppMagn 13.685
	MassSol 0.987
	RadSol  1.042
	Teff    6163
}

Star	"KOI-4636/KIC 9773270"
{
	RA      19.53234453
	Dec     46.506569
	AppMagn 15.511
	MassSol 1.073
	RadSol  0.981
	Teff    5623
}

Star	"KOI-4637/KIC 9457728"
{
	RA      19.239978
	Dec     46.031712
	AppMagn 10.438
	MassSol 1.21
	RadSol  1.85
	Teff    6390
}

Star	"KOI-4643/KIC 11655826"
{
	RA      19.229893
	Dec     49.714031
	AppMagn 15.308
	MassSol 1.001
	RadSol  0.933
	Teff    5874
}

Star	"KOI-4644/KIC 1721157"
{
	RA      19.43048907
	Dec     37.206841
	AppMagn 15.144
	MassSol 0.869
	RadSol  0.791
	Teff    5119
}

Star	"KOI-4647/KIC 9947653"
{
	RA      19.35062053
	Dec     46.885109
	AppMagn 13.726
	MassSol 1.042
	RadSol  1.964
	Teff    5303
}

Star	"KOI-4649/KIC 4750669"
{
	RA      19.5311076
	Dec     39.899639
	AppMagn 15.446
	MassSol 0.861
	RadSol  0.786
	Teff    5588
}

Star	"KOI-4650/KIC 9824928"
{
	RA      19.2701904
	Dec     46.67593
	AppMagn 15.928
	MassSol 0.541
	RadSol  0.554
	Teff    4289
}

Star	"KOI-4651/KIC 6717252"
{
	RA      19.8724772
	Dec     42.164349
	AppMagn 13.818
	MassSol 0.837
	RadSol  1.013
	Teff    5600
}

Star	"KOI-4653/KIC 11181260"
{
	RA      19.1040222
	Dec     48.893051
	AppMagn 13.52
	MassSol 1.221
	RadSol  1.144
	Teff    6362
}

Star	"KOI-4655/KIC 2558163"
{
	RA      19.1376892
	Dec     37.899479
	AppMagn 15.388
	MassSol 0.88
	RadSol  0.793
	Teff    5960
}

Star	"KOI-4656/KIC 8107611"
{
	RA      19.6827942
	Dec     43.972599
	AppMagn 13.821
	MassSol 1.333
	RadSol  1.642
	Teff    6714
}

Star	"KOI-4657/KIC 6527078"
{
	RA      19.5528524
	Dec     41.997589
	AppMagn 13.241
	MassSol 0.856
	RadSol  0.773
	Teff    5366
}

Star	"KOI-4659/KIC 2857607"
{
	RA      19.5009786
	Dec     38.02206
	AppMagn 13.664
	MassSol 0.929
	RadSol  0.842
	Teff    5864
}

Star	"KOI-466/KIC 9008220"
{
	RA      19.07679853
	Dec     45.332561
	AppMagn 14.663
	MassSol 1.07
	RadSol  0.996
	Teff    6122
}

Star	"KOI-4661/KIC 5962262"
{
	RA      19.49759113
	Dec     41.299068
	AppMagn 14.79
	MassSol 0.67
	RadSol  0.657
	Teff    5013
}

Star	"KOI-4663/KIC 7515336"
{
	RA      19.17803953
	Dec     43.197239
	AppMagn 12.715
	MassSol 0.902
	RadSol  1.25
	Teff    5633
}

Star	"KOI-4666/KIC 11337012"
{
	RA      18.93611453
	Dec     49.138199
	AppMagn 15.355
	MassSol 0.824
	RadSol  0.832
	Teff    5555
}

Star	"KOI-4667/KIC 8359569"
{
	RA      19.309023
	Dec     44.379711
	AppMagn 15.408
	MassSol 1.164
	RadSol  1.148
	Teff    6452
}

Star	"KOI-4670/KIC 9837828"
{
	RA      19.63871053
	Dec     46.610592
	AppMagn 16.303
	MassSol 0.81
	RadSol  0.854
	Teff    4992
}

Star	"KOI-4674/KIC 6839010"
{
	RA      18.838855
	Dec     42.346352
	AppMagn 13.59
	MassSol 0.906
	RadSol  1.056
	Teff    5762
}

Star	"KOI-4676/KIC 4953173"
{
	RA      19.91622313
	Dec     40.07214
	AppMagn 13.931
	MassSol 1.378
	RadSol  2.407
	Teff    5947
}

Star	"KOI-4680/KIC 4587135"
{
	RA      19.839976
	Dec     39.626339
	AppMagn 15.487
	MassSol 0.847
	RadSol  0.776
	Teff    5770
}

Star	"KOI-4686/KIC 5819801"
{
	RA      19.9270508
	Dec     41.04261
	AppMagn 12.327
	MassSol 0.991
	RadSol  1.366
	Teff    5619
}

Star	"KOI-469/KIC 9703198"
{
	RA      19.2425232
	Dec     46.421471
	AppMagn 14.711
	MassSol 1.091
	RadSol  1.031
	Teff    6225
}

Star	"KOI-4691/KIC 9773980"
{
	RA      19.55201007
	Dec     46.560089
	AppMagn 14.491
	MassSol 1.019
	RadSol  0.932
	Teff    6003
}

Star	"KOI-4694/KIC 9457948"
{
	RA      19.2472392
	Dec     46.018188
	AppMagn 14.851
	MassSol 1.088
	RadSol  1.031
	Teff    6241
}

Star	"KOI-4698/KIC 10663738"
{
	RA      19.40849607
	Dec     47.938801
	AppMagn 14.765
	MassSol 1.248
	RadSol  1.2
	Teff    6444
}

Star	"KOI-4699/KIC 7891294"
{
	RA      19.459198
	Dec     43.649811
	AppMagn 12.889
	MassSol 1.084
	RadSol  1.032
	Teff    6319
}

Star	"KOI-4700/KIC 9413156"
{
	RA      19.69076333
	Dec     45.914841
	AppMagn 15.972
	MassSol 0.848
	RadSol  0.776
	Teff    5505
}

Star	"KOI-4705/KIC 5642688"
{
	RA      19.84015707
	Dec     40.803219
	AppMagn 15.078
	MassSol 0.834
	RadSol  0.921
	Teff    5751
}

Star	"KOI-4709/KIC 2303903"
{
	RA      19.44286293
	Dec     37.632408
	AppMagn 15.947
	MassSol 0.864
	RadSol  0.776
	Teff    5425
}

Star	"KOI-4710/KIC 9278216"
{
	RA      19.3825134
	Dec     45.725369
	AppMagn 15.58
	MassSol 0.941
	RadSol  0.854
	Teff    5970
}

Star	"KOI-4711/KIC 8355131"
{
	RA      19.16717733
	Dec     44.31424
	AppMagn 15.642
	MassSol 0.827
	RadSol  0.755
	Teff    5609
}

Star	"KOI-4713/KIC 5253802"
{
	RA      18.92258913
	Dec     40.421974
	AppMagn 13.641
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-4714/KIC 12554634"
{
	RA      19.27876587
	Dec     51.562538
	AppMagn 15.277
	MassSol 0.878
	RadSol  0.786
	Teff    5361
}

Star	"KOI-4715/KIC 6264750"
{
	RA      18.9048462
	Dec     41.695728
	AppMagn 13.98
	MassSol 0.806
	RadSol  1.057
	Teff    6015
}

Star	"KOI-4716/KIC 11290515"
{
	RA      19.22299193
	Dec     49.021938
	AppMagn 12.322
	MassSol 0.964
	RadSol  1.093
	Teff    6177
}

Star	"KOI-4717/KIC 4902202"
{
	RA      18.9129008
	Dec     40.018021
	AppMagn 15.58
	MassSol 0.749
	RadSol  0.822
	Teff    5589
}

Star	"KOI-4725/KIC 7778621"
{
	RA      19.94251913
	Dec     43.498638
	AppMagn 13.367
	MassSol 0.996
	RadSol  1.806
	Teff    4970
}

Star	"KOI-473/KIC 10155434"
{
	RA      19.78724367
	Dec     47.17194
	AppMagn 14.673
	MassSol 0.937
	RadSol  0.85
	Teff    5582
}

Star	"KOI-4730/KIC 8752940"
{
	RA      19.43924967
	Dec     44.907509
	AppMagn 14.383
	MassSol 0.951
	RadSol  1.611
	Teff    5086
}

Star	"KOI-4733/KIC 9021075"
{
	RA      19.43387453
	Dec     45.370159
	AppMagn 15.993
	MassSol 0.845
	RadSol  0.787
	Teff    5009
}

Star	"KOI-4735/KIC 11338056"
{
	RA      18.98406167
	Dec     49.141979
	AppMagn 14.712
	MassSol 0.73
	RadSol  0.67
	Teff    4983
}

Star	"KOI-4737/KIC 7266212"
{
	RA      19.08115233
	Dec     42.86092
	AppMagn 14.726
	MassSol 1.114
	RadSol  1.05
	Teff    6156
}

Star	"KOI-4743/KIC 6468904"
{
	RA      19.91226807
	Dec     41.83149
	AppMagn 14.94
	MassSol 0.812
	RadSol  0.762
	Teff    5692
}

Star	"KOI-4744/KIC 5709906"
{
	RA      19.54495647
	Dec     40.950809
	AppMagn 13.773
	MassSol 1
	RadSol  0.914
	Teff    5896
}

Star	"KOI-4748/KIC 11513486"
{
	RA      19.6522888
	Dec     49.4921
	AppMagn 15.724
	MassSol 1.111
	RadSol  1.007
	Teff    6046
}

Star	"KOI-4749/KIC 6520519"
{
	RA      19.41410927
	Dec     41.9856
	AppMagn 15.608
	MassSol 1.015
	RadSol  0.923
	Teff    5792
}

Star	"KOI-4750/KIC 5308296"
{
	RA      19.96612547
	Dec     40.472481
	AppMagn 15.919
	MassSol 0.925
	RadSol  0.841
	Teff    5679
}

Star	"KOI-4754/KIC 10291589"
{
	RA      19.86035153
	Dec     47.33683
	AppMagn 15.274
	MassSol 1.008
	RadSol  0.925
	Teff    6060
}

Star	"KOI-4755/KIC 10118266"
{
	RA      18.7110128
	Dec     47.114059
	AppMagn 14.924
	MassSol 0.847
	RadSol  0.779
	Teff    5431
}

Star	"KOI-4756/KIC 5695615"
{
	RA      19.24070433
	Dec     40.92474
	AppMagn 15.411
	MassSol 1.08
	RadSol  1.143
	Teff    6338
}

Star	"KOI-4758/KIC 8938937"
{
	RA      19.0534566
	Dec     45.216831
	AppMagn 15.948
	MassSol 0.977
	RadSol  0.86
	Teff    5591
}

Star	"KOI-4759/KIC 7949593"
{
	RA      19.18486733
	Dec     43.73391
	AppMagn 14.971
	MassSol 0.961
	RadSol  1.048
	Teff    6018
}

Star	"KOI-4762/KIC 7098255"
{
	RA      18.97400513
	Dec     42.687431
	AppMagn 15.674
	MassSol 0.678
	RadSol  0.691
	Teff    4597
}

Star	"KOI-4763/KIC 8349399"
{
	RA      18.9588318
	Dec     44.308231
	AppMagn 14.046
	MassSol 0.989
	RadSol  1.087
	Teff    5993
}

Star	"KOI-4764/KIC 6043562"
{
	RA      19.47909747
	Dec     41.328041
	AppMagn 15.809
	MassSol 0.839
	RadSol  0.752
	Teff    5268
}

Star	"KOI-4766/KIC 4919550"
{
	RA      19.364504
	Dec     40.056438
	AppMagn 15.223
	MassSol 0.755
	RadSol  0.751
	Teff    5216
}

Star	"KOI-4768/KIC 10221505"
{
	RA      19.7859558
	Dec     47.234531
	AppMagn 15.71
	MassSol 0.638
	RadSol  0.651
	Teff    5201
}

Star	"KOI-4771/KIC 11658036"
{
	RA      19.31204833
	Dec     49.745831
	AppMagn 13.964
	MassSol 1.347
	RadSol  1.32
	Teff    6711
}

Star	"KOI-4772/KIC 8397947"
{
	RA      20.1052368
	Dec     44.31218
	AppMagn 15.514
	MassSol 0.838
	RadSol  0.768
	Teff    5775
}

Star	"KOI-4773/KIC 7906892"
{
	RA      19.78954673
	Dec     43.697441
	AppMagn 13.556
	MassSol 1.004
	RadSol  1.11
	Teff    6095
}

Star	"KOI-4774/KIC 4277304"
{
	RA      19.674825
	Dec     39.391033
	AppMagn 13.882
	MassSol 0.821
	RadSol  0.876
	Teff    5285
}

Star	"KOI-4775/KIC 8626325"
{
	RA      19.4935486
	Dec     44.782009
	AppMagn 12.999
	MassSol 1.22
	RadSol  2.098
	Teff    5346
}

Star	"KOI-4776/KIC 8054719"
{
	RA      19.95663653
	Dec     43.8503
	AppMagn 14.84
	MassSol 0.767
	RadSol  0.871
	Teff    5934
}

Star	"KOI-4780/KIC 3849187"
{
	RA      19.40904947
	Dec     38.90543
	AppMagn 15.414
	MassSol 0.977
	RadSol  0.86
	Teff    5591
}

Star	"KOI-4782/KIC 8973285"
{
	RA      19.86324667
	Dec     45.255039
	AppMagn 15.85
	MassSol 1.055
	RadSol  0.973
	Teff    6032
}

Star	"KOI-4790/KIC 8328916"
{
	RA      20.03900147
	Dec     44.2131
	AppMagn 14.458
	MassSol 1.003
	RadSol  1.114
	Teff    6119
}

Star	"KOI-4792/KIC 11618569"
{
	RA      19.70477293
	Dec     49.607479
	AppMagn 14.199
	MassSol 1.093
	RadSol  1.033
	Teff    6210
}

Star	"KOI-4793/KIC 6220312"
{
	RA      19.74150187
	Dec     41.561138
	AppMagn 15.374
	MassSol 1.007
	RadSol  0.918
	Teff    5851
}

Star	"KOI-4794/KIC 6358937"
{
	RA      19.33961793
	Dec     41.742779
	AppMagn 14.375
	MassSol 0.824
	RadSol  0.93
	Teff    5341
}

Star	"KOI-4797/KIC 7771181"
{
	RA      19.82322793
	Dec     43.421219
	AppMagn 15.693
	MassSol 0.677
	RadSol  0.696
	Teff    4810
}

Star	"KOI-4799/KIC 8278073"
{
	RA      18.7701782
	Dec     44.228531
	AppMagn 14.216
	MassSol 0.813
	RadSol  1.063
	Teff    5885
}

Star	"KOI-4801/KIC 10810859"
{
	RA      19.7885966
	Dec     48.173279
	AppMagn 15.202
	MassSol 1.178
	RadSol  1.124
	Teff    6195
}

Star	"KOI-4804/KIC 10676750"
{
	RA      19.7398946
	Dec     47.992699
	AppMagn 15.185
	MassSol 0.926
	RadSol  0.829
	Teff    6068
}

Star	"KOI-4810/KIC 4270799"
{
	RA      19.57691247
	Dec     39.31641
	AppMagn 15.259
	MassSol 0.965
	RadSol  0.87
	Teff    5817
}

Star	"KOI-4811/KIC 8811490"
{
	RA      19.2571696
	Dec     45.097691
	AppMagn 13.816
	MassSol 0.987
	RadSol  1.497
	Teff    5767
}

Star	"KOI-4813/KIC 4840672"
{
	RA      19.54935913
	Dec     39.949444
	AppMagn 13.78
	MassSol 0.608
	RadSol  0.604
	Teff    4780
}

Star	"KOI-4815/KIC 7287677"
{
	RA      19.5698222
	Dec     42.828442
	AppMagn 14.965
	MassSol 0.905
	RadSol  0.82
	Teff    5926
}

Star	"KOI-4818/KIC 9459162"
{
	RA      19.28988647
	Dec     46.05468
	AppMagn 13.008
	MassSol 1.338
	RadSol  1.405
	Teff    6828
}

Star	"KOI-4820/KIC 9969287"
{
	RA      19.8920044
	Dec     46.8894
	AppMagn 15.479
	MassSol 1.045
	RadSol  0.959
	Teff    5999
}

Star	"KOI-4822/KIC 9702945"
{
	RA      19.23380127
	Dec     46.406712
	AppMagn 13.474
	MassSol 1.058
	RadSol  0.989
	Teff    6201
}

Star	"KOI-4823/KIC 11401253"
{
	RA      19.39933673
	Dec     49.233131
	AppMagn 12.739
	MassSol 0.982
	RadSol  2.011
	Teff    5339
}

Star	"KOI-4826/KIC 10549902"
{
	RA      19.81423133
	Dec     47.775429
	AppMagn 14.58
	MassSol 1.06
	RadSol  1.03
	Teff    6191
}

Star	"KOI-4827/KIC 5651846"
{
	RA      19.96457927
	Dec     40.82999
	AppMagn 15.401
	MassSol 0.789
	RadSol  0.777
	Teff    5675
}

Star	"KOI-4829/KIC 12401132"
{
	RA      19.180131
	Dec     51.229729
	AppMagn 14.12
	MassSol 1.161
	RadSol  1.175
	Teff    6422
}

Star	"KOI-4833/KIC 10584140"
{
	RA      18.95446167
	Dec     47.887112
	AppMagn 13.6
	MassSol 0.979
	RadSol  1.31
	Teff    5992
}

Star	"KOI-4834/KIC 8233326"
{
	RA      19.45297647
	Dec     44.193531
	AppMagn 13.096
	MassSol 1.554
	RadSol  3.231
	Teff    5110
}

Star	"KOI-4837/KIC 5645170"
{
	RA      19.87477827
	Dec     40.81358
	AppMagn 15.347
	MassSol 0.73
	RadSol  0.659
	Teff    5523
}

Star	"KOI-4838/KIC 8216763"
{
	RA      18.951239
	Dec     44.19754
	AppMagn 15.073
	MassSol 0.639
	RadSol  0.614
	Teff    4349
}

Star	"KOI-4839/KIC 9110610"
{
	RA      19.89397173
	Dec     45.461639
	AppMagn 13.547
	MassSol 1.189
	RadSol  2.241
	Teff    6194
}

Star	"KOI-4840/KIC 6665860"
{
	RA      18.80620933
	Dec     42.160271
	AppMagn 14.486
	MassSol 0.934
	RadSol  0.857
	Teff    5944
}

Star	"KOI-4848/KIC 9005321"
{
	RA      18.98450927
	Dec     45.341228
	AppMagn 15.677
	MassSol 0.618
	RadSol  0.623
	Teff    4228
}

Star	"KOI-4849/KIC 2976017"
{
	RA      19.1878194
	Dec     38.194809
	AppMagn 14.261
	MassSol 0.762
	RadSol  0.698
	Teff    5475
}

Star	"KOI-4850/KIC 6786224"
{
	RA      19.6222188
	Dec     42.26413
	AppMagn 14.147
	MassSol 0.929
	RadSol  0.845
	Teff    5811
}

Star	"KOI-4852/KIC 11072016"
{
	RA      18.99615073
	Dec     48.666512
	AppMagn 14.457
	MassSol 1.104
	RadSol  1.05
	Teff    5942
}

Star	"KOI-4854/KIC 8360041"
{
	RA      19.32053627
	Dec     44.362518
	AppMagn 14.342
	MassSol 0.819
	RadSol  0.781
	Teff    5388
}

Star	"KOI-4855/KIC 9827596"
{
	RA      19.357428
	Dec     46.661331
	AppMagn 14.561
	MassSol 1.091
	RadSol  1.031
	Teff    6225
}

Star	"KOI-4856/KIC 9782748"
{
	RA      19.76809693
	Dec     46.540539
	AppMagn 15.817
	MassSol 1.111
	RadSol  1.007
	Teff    6046
}

Star	"KOI-4857/KIC 2860656"
{
	RA      19.54505207
	Dec     38.042019
	AppMagn 15.392
	MassSol 1.006
	RadSol  0.927
	Teff    6011
}

Star	"KOI-4859/KIC 7094944"
{
	RA      18.870815
	Dec     42.629002
	AppMagn 15.562
	MassSol 0.737
	RadSol  0.758
	Teff    4807
}

Star	"KOI-4862/KIC 11973517"
{
	RA      19.77319947
	Dec     50.356651
	AppMagn 15.697
	MassSol 0.638
	RadSol  0.651
	Teff    4430
}

Star	"KOI-4864/KIC 7345248"
{
	RA      19.0305908
	Dec     42.931049
	AppMagn 13.221
	MassSol 0.865
	RadSol  1.13
	Teff    5888
}

Star	"KOI-4871/KIC 6767227"
{
	RA      19.23526813
	Dec     42.27626
	AppMagn 13.05
	MassSol 1.056
	RadSol  1.247
	Teff    6532
}

Star	"KOI-4875/KIC 2986833"
{
	RA      19.38547567
	Dec     38.18779
	AppMagn 15.783
	MassSol 0.498
	RadSol  0.488
	Teff    3741
}

Star	"KOI-4877/KIC 9581589"
{
	RA      19.2647888
	Dec     46.265202
	AppMagn 14.423
	MassSol 1.084
	RadSol  1.031
	Teff    6297
}

Star	"KOI-4878/KIC 11804437"
{
	RA      19.0818746
	Dec     50.01358
	AppMagn 12.291
	MassSol 0.972
	RadSol  1.068
	Teff    6031
}

Star	"KOI-4881/KIC 8094120"
{
	RA      19.3700582
	Dec     43.994362
	AppMagn 12.892
	MassSol 1.127
	RadSol  1.585
	Teff    6514
}

Star	"KOI-4885/KIC 9935642"
{
	RA      18.89717613
	Dec     46.819538
	AppMagn 15.03
	MassSol 0.898
	RadSol  1.101
	Teff    5516
}

Star	"KOI-4886/KIC 7692248"
{
	RA      19.663383
	Dec     43.324341
	AppMagn 15.822
	MassSol 1.045
	RadSol  0.959
	Teff    5999
}

Star	"KOI-4890/KIC 6691169"
{
	RA      19.4481262
	Dec     42.117298
	AppMagn 15.765
	MassSol 1.372
	RadSol  1.325
	Teff    6622
}

Star	"KOI-4891/KIC 10747501"
{
	RA      19.83219807
	Dec     48.022499
	AppMagn 15.68
	MassSol 1.001
	RadSol  0.911
	Teff    5941
}

Star	"KOI-4892/KIC 10586744"
{
	RA      19.04713133
	Dec     47.869968
	AppMagn 14.143
	MassSol 0.846
	RadSol  1.052
	Teff    5984
}

Star	"KOI-4893/KIC 11970050"
{
	RA      19.67212933
	Dec     50.344601
	AppMagn 15.652
	MassSol 1.101
	RadSol  0.993
	Teff    6014
}

Star	"KOI-4895/KIC 12416597"
{
	RA      19.70099693
	Dec     51.203739
	AppMagn 14.732
	MassSol 0.914
	RadSol  0.958
	Teff    5861
}

Star	"KOI-4896/KIC 11135694"
{
	RA      19.3933614
	Dec     48.74614
	AppMagn 15.451
	MassSol 0.996
	RadSol  1.024
	Teff    6120
}

Star	"KOI-4898/KIC 10065053"
{
	RA      19.15659793
	Dec     47.060982
	AppMagn 15.731
	MassSol 1.149
	RadSol  1.064
	Teff    6167
}

Star	"KOI-4900/KIC 6424561"
{
	RA      18.97187093
	Dec     41.890259
	AppMagn 15.134
	MassSol 1.031
	RadSol  1.021
	Teff    6086
}

Star	"KOI-4902/KIC 10000162"
{
	RA      19.08902993
	Dec     46.917831
	AppMagn 15.149
	MassSol 0.766
	RadSol  0.799
	Teff    4955
}

Star	"KOI-4904/KIC 8803757"
{
	RA      18.9818644
	Dec     45.064968
	AppMagn 15.033
	MassSol 0.963
	RadSol  0.869
	Teff    5835
}

Star	"KOI-4907/KIC 5437762"
{
	RA      19.2265076
	Dec     40.6269
	AppMagn 13.778
	MassSol 1.066
	RadSol  1.126
	Teff    6351
}

Star	"KOI-4912/KIC 5208962"
{
	RA      19.81279907
	Dec     40.387951
	AppMagn 14.878
	MassSol 1.034
	RadSol  0.96
	Teff    6168
}

Star	"KOI-4913/KIC 5769810"
{
	RA      18.91192013
	Dec     41.096882
	AppMagn 13.36
	MassSol 1.277
	RadSol  1.48
	Teff    6543
}

Star	"KOI-4914/KIC 12071754"
{
	RA      19.76006267
	Dec     50.558338
	AppMagn 14.211
	MassSol 1.077
	RadSol  0.999
	Teff    6077
}

Star	"KOI-4923/KIC 1429589"
{
	RA      19.3837504
	Dec     37.089809
	AppMagn 13.195
	MassSol 1.026
	RadSol  1.465
	Teff    6164
}

Star	"KOI-4926/KIC 1865864"
{
	RA      19.39153647
	Dec     37.362179
	AppMagn 15.572
	MassSol 0.679
	RadSol  0.698
	Teff    4848
}

Star	"KOI-4927/KIC 1870398"
{
	RA      19.4610372
	Dec     37.322578
	AppMagn 14.756
	MassSol 1.014
	RadSol  1.035
	Teff    6204
}

Star	"KOI-4936/KIC 2305543"
{
	RA      19.468457
	Dec     37.600651
	AppMagn 12.545
	MassSol 0.811
	RadSol  0.864
	Teff    5872
}

Star	"KOI-4938/KIC 2310993"
{
	RA      19.54801227
	Dec     37.610699
	AppMagn 15.551
	MassSol 1.087
	RadSol  1.031
	Teff    6258
}

Star	"KOI-4939/KIC 2437209"
{
	RA      19.34732867
	Dec     37.725979
	AppMagn 16.353
	MassSol 0.726
	RadSol  0.743
	Teff    4822
}

Star	"KOI-4958/KIC 2861298"
{
	RA      19.5545756
	Dec     38.005466
	AppMagn 12.362
	MassSol 1.007
	RadSol  2.005
	Teff    5765
}

Star	"KOI-4959/KIC 2987433"
{
	RA      19.395931
	Dec     38.119572
	AppMagn 13.858
	MassSol 1.056
	RadSol  1.177
	Teff    6462
}

Star	"KOI-4960/KIC 2992634"
{
	RA      19.47186887
	Dec     38.153831
	AppMagn 14.395
}

Star	"KOI-4961/KIC 3001955"
{
	RA      19.60563353
	Dec     38.156319
	AppMagn 15.325
	MassSol 0.837
	RadSol  0.792
	Teff    4823
}

Star	"KOI-4967/KIC 3239171"
{
	RA      19.49802247
	Dec     38.394341
	AppMagn 15.63
	MassSol 1.091
	RadSol  1.031
	Teff    6225
}

Star	"KOI-4968/KIC 3240049"
{
	RA      19.512266
	Dec     38.36573
	AppMagn 11.557
	MassSol 2.07
	RadSol  19.255
	Teff    4584
}

Star	"KOI-4972/KIC 3340165"
{
	RA      19.3949402
	Dec     38.438339
	AppMagn 13.98
	MassSol 1.066
	RadSol  1.014
	Teff    6348
}

Star	"KOI-4975/KIC 3355104"
{
	RA      19.64206947
	Dec     38.404549
	AppMagn 15.706
	MassSol 0.992
	RadSol  0.897
	Teff    5838
}

Star	"KOI-4976/KIC 3356156"
{
	RA      19.65760907
	Dec     38.480183
	AppMagn 13.62
	MassSol 1.532
	RadSol  1.729
	Teff    7089
}

Star	"KOI-4977/KIC 3425363"
{
	RA      19.03528647
	Dec     38.548141
	AppMagn 15.573
	MassSol 0.629
	RadSol  0.635
	Teff    4445
}

Star	"KOI-4978/KIC 3428127"
{
	RA      19.1060506
	Dec     38.5583
	AppMagn 15.278
	MassSol 0.859
	RadSol  0.966
	Teff    5544
}

Star	"KOI-4980/KIC 3439031"
{
	RA      19.34217933
	Dec     38.51368
	AppMagn 11.287
	MassSol 1.09
	RadSol  1.426
	Teff    6582
}

Star	"KOI-4982/KIC 3449540"
{
	RA      19.52913007
	Dec     38.593071
	AppMagn 14.194
	MassSol 1.002
	RadSol  0.941
	Teff    6420
}

Star	"KOI-4986/KIC 3540873"
{
	RA      19.35698647
	Dec     38.672531
	AppMagn 14.795
	MassSol 0.807
	RadSol  0.726
	Teff    5776
}

Star	"KOI-4988/KIC 3542928"
{
	RA      19.3974304
	Dec     38.673439
	AppMagn 13.881
	MassSol 1.126
	RadSol  1.04
	Teff    5858
}

Star	"KOI-4991/KIC 3548645"
{
	RA      19.4987264
	Dec     38.654121
	AppMagn 15.27
	MassSol 1.001
	RadSol  0.911
	Teff    5941
}

Star	"KOI-4992/KIC 3553900"
{
	RA      19.584965
	Dec     38.654381
	AppMagn 15.133
	MassSol 0.828
	RadSol  0.763
	Teff    5627
}

Star	"KOI-4999/KIC 3646449"
{
	RA      19.4439372
	Dec     38.712158
	AppMagn 15.478
	MassSol 0.988
	RadSol  0.913
	Teff    6088
}

Star	"KOI-5/KIC 8554498"
{
	RA      19.31598107
	Dec     44.647419
	AppMagn 11.665
	MassSol 1.13
	RadSol  1.747
	Teff    5753
}

Star	"KOI-5004/KIC 3751118"
{
	RA      19.50385333
	Dec     38.8503
	AppMagn 14.505
	MassSol 1.103
	RadSol  1.022
	Teff    5762
}

Star	"KOI-5007/KIC 3758499"
{
	RA      19.62448933
	Dec     38.846889
	AppMagn 13.698
	MassSol 1.141
	RadSol  1.885
	Teff    5934
}

Star	"KOI-501/KIC 4951877"
{
	RA      19.89821373
	Dec     40.075871
	AppMagn 14.612
	MassSol 0.934
	RadSol  0.9
	Teff    5766
}

Star	"KOI-5018/KIC 3854101"
{
	RA      19.49766033
	Dec     38.907421
	AppMagn 15.184
	MassSol 0.968
	RadSol  0.854
	Teff    5561
}

Star	"KOI-5021/KIC 3863877"
{
	RA      19.66021527
	Dec     38.95647
	AppMagn 15.212
	MassSol 1.083
	RadSol  0.965
	Teff    5825
}

Star	"KOI-5023/KIC 3867593"
{
	RA      19.71316733
	Dec     38.902
	AppMagn 13.559
	MassSol 1.361
	RadSol  1.44
	Teff    7216
}

Star	"KOI-5027/KIC 3955444"
{
	RA      19.4549642
	Dec     39.00618
	AppMagn 13.172
	MassSol 2.012
	RadSol  5.615
	Teff    4999
}

Star	"KOI-5030/KIC 3968809"
{
	RA      19.67924807
	Dec     39.01865
	AppMagn 14.452
	MassSol 1.221
	RadSol  1.144
	Teff    6362
}

Star	"KOI-5033/KIC 3974928"
{
	RA      19.75719807
	Dec     39.078579
	AppMagn 13.832
	MassSol 0.865
	RadSol  2.633
	Teff    4985
}

Star	"KOI-5034/KIC 4058169"
{
	RA      19.45650633
	Dec     39.143566
	AppMagn 13.252
	MassSol 1.084
	RadSol  1.41
	Teff    6401
}

Star	"KOI-5040/KIC 4135912"
{
	RA      18.9777222
	Dec     39.252041
	AppMagn 14.385
	MassSol 1.016
	RadSol  1.021
	Teff    6316
}

Star	"KOI-5046/KIC 4164511"
{
	RA      19.5498006
	Dec     39.236691
	AppMagn 13.006
	MassSol 1.068
	RadSol  1.174
	Teff    6705
}

Star	"KOI-5047/KIC 4179201"
{
	RA      19.75495807
	Dec     39.292881
	AppMagn 14.703
	MassSol 0.789
	RadSol  0.998
	Teff    6036
}

Star	"KOI-5048/KIC 4241238"
{
	RA      18.97591753
	Dec     39.355179
	AppMagn 13.419
	MassSol 0.916
	RadSol  2.547
	Teff    4948
}

Star	"KOI-5052/KIC 4253860"
{
	RA      19.28224487
	Dec     39.38652
	AppMagn 12.649
	MassSol 1.851
	RadSol  2.737
	Teff    6910
}

Star	"KOI-5057/KIC 4346339"
{
	RA      19.02288613
	Dec     39.413849
	AppMagn 12.518
	MassSol 1.031
	RadSol  3.243
	Teff    5015
}

Star	"KOI-5058/KIC 4365461"
{
	RA      19.4460632
	Dec     39.425442
	AppMagn 13.309
	MassSol 1.274
	RadSol  1.626
	Teff    6351
}

Star	"KOI-5059/KIC 4366923"
{
	RA      19.474351
	Dec     39.49855
	AppMagn 13.03
	MassSol 1.003
	RadSol  1.193
	Teff    6484
}

Star	"KOI-5067/KIC 4478142"
{
	RA      19.67911987
	Dec     39.575691
	AppMagn 14.254
	MassSol 0.864
	RadSol  0.864
	Teff    5680
}

Star	"KOI-5068/KIC 4484179"
{
	RA      19.76151327
	Dec     39.579391
	AppMagn 13.086
	MassSol 0.916
	RadSol  1.053
	Teff    6440
}

Star	"KOI-5071/KIC 4566848"
{
	RA      19.5443176
	Dec     39.631561
	AppMagn 15.656
	MassSol 1.055
	RadSol  0.973
	Teff    6032
}

Star	"KOI-5079/KIC 4737848"
{
	RA      19.2730794
	Dec     39.827278
	AppMagn 13.228
	MassSol 0.974
	RadSol  1.332
	Teff    6116
}

Star	"KOI-5083/KIC 4750962"
{
	RA      19.53702393
	Dec     39.840069
	AppMagn 13.809
	MassSol 1.946
	RadSol  5.183
	Teff    5207
}

Star	"KOI-5085/KIC 4761427"
{
	RA      19.7083862
	Dec     39.824638
	AppMagn 15.941
	MassSol 0.98
	RadSol  0.882
	Teff    5750
}

Star	"KOI-5086/KIC 4769799"
{
	RA      19.82116087
	Dec     39.877972
	AppMagn 10.946
	MassSol 0.878
	RadSol  2.572
	Teff    5078
}

Star	"KOI-5087/KIC 4770798"
{
	RA      19.83394573
	Dec     39.88802
	AppMagn 12.524
	MassSol 0.959
	RadSol  1.261
	Teff    5696
}

Star	"KOI-5088/KIC 4813750"
{
	RA      18.91187947
	Dec     39.964279
	AppMagn 15.527
	MassSol 0.764
	RadSol  0.839
	Teff    5674
}

Star	"KOI-5092/KIC 4833409"
{
	RA      19.4072164
	Dec     39.955681
	AppMagn 13.887
	MassSol 1.151
	RadSol  1.32
	Teff    6484
}

Star	"KOI-5093/KIC 4840327"
{
	RA      19.5426046
	Dec     39.925739
	AppMagn 12.688
	MassSol 0.838
	RadSol  1.021
	Teff    6068
}

Star	"KOI-5098/KIC 4912650"
{
	RA      19.2227824
	Dec     40.09639
	AppMagn 14.855
	MassSol 0.815
	RadSol  0.9
	Teff    5313
}

Star	"KOI-5099/KIC 4914221"
{
	RA      19.2620402
	Dec     40.057339
	AppMagn 12.709
	MassSol 0.881
	RadSol  1.281
	Teff    5806
}

Star	"KOI-51/KIC 6056992"
{
	RA      19.7279236
	Dec     41.332432
	AppMagn 13.761
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-5101/KIC 4915582"
{
	RA      19.29037273
	Dec     40.068352
	AppMagn 13.026
	MassSol 0.993
	RadSol  1.497
	Teff    6499
}

Star	"KOI-5104/KIC 4918303"
{
	RA      19.3416646
	Dec     40.098381
	AppMagn 15.531
	MassSol 1.117
	RadSol  1.012
	Teff    6063
}

Star	"KOI-5107/KIC 4940376"
{
	RA      19.73456827
	Dec     40.087151
	AppMagn 13.743
	MassSol 1.839
	RadSol  7.052
	Teff    5106
}

Star	"KOI-5109/KIC 4946581"
{
	RA      19.82400513
	Dec     40.031841
	AppMagn 14.091
	MassSol 0.871
	RadSol  0.842
	Teff    5977
}

Star	"KOI-5110/KIC 4953262"
{
	RA      19.9173604
	Dec     40.052792
	AppMagn 11.653
	MassSol 1.307
	RadSol  4.806
	Teff    5069
}

Star	"KOI-5115/KIC 5016163"
{
	RA      19.55187787
	Dec     40.157082
	AppMagn 15.768
	MassSol 1.054
	RadSol  0.988
	Teff    6233
}

Star	"KOI-5117/KIC 5027859"
{
	RA      19.7345886
	Dec     40.108009
	AppMagn 15.986
	MassSol 0.868
	RadSol  0.794
	Teff    5494
}

Star	"KOI-5119/KIC 5036052"
{
	RA      19.85255533
	Dec     40.130909
	AppMagn 12.644
	MassSol 2.394
	RadSol  7.653
	Teff    5145
}

Star	"KOI-5121/KIC 5039053"
{
	RA      19.88859047
	Dec     40.147171
	AppMagn 12.616
	MassSol 1.389
	RadSol  1.912
	Teff    6079
}

Star	"KOI-5124/KIC 5094412"
{
	RA      19.35333333
	Dec     40.2878
	AppMagn 16
	MassSol 0.82
	RadSol  0.8
	Teff    5313
	FeH    -0.327
}

Star	"KOI-5126/KIC 5110453"
{
	RA      19.6565348
	Dec     40.240879
	AppMagn 13.637
	MassSol 1.668
	RadSol  5.469
	Teff    5110
}

Star	"KOI-5127/KIC 5113146"
{
	RA      19.6937988
	Dec     40.242409
	AppMagn 15.115
	MassSol 0.784
	RadSol  0.884
	Teff    6477
}

Star	"KOI-5129/KIC 5131276"
{
	RA      19.95477093
	Dec     40.265339
	AppMagn 11.598
	MassSol 1.134
	RadSol  149.058
	Teff    3299
}

Star	"KOI-5131/KIC 5174677"
{
	RA      19.197583
	Dec     40.310322
	AppMagn 15.223
	MassSol 1.251
	RadSol  1.427
	Teff    6669
}

Star	"KOI-5132/KIC 5179609"
{
	RA      19.30742593
	Dec     40.335838
	AppMagn 12.776
	MassSol 1.979
	RadSol  6.443
	Teff    4977
}

Star	"KOI-5135/KIC 5184144"
{
	RA      19.3956238
	Dec     40.358158
	AppMagn 15.578
	MassSol 0.836
	RadSol  0.755
	Teff    5228
}

Star	"KOI-5138/KIC 5199426"
{
	RA      19.6787252
	Dec     40.339882
	AppMagn 14.08
	MassSol 0.947
	RadSol  0.985
	Teff    5938
}

Star	"KOI-5142/KIC 5255259"
{
	RA      18.96979373
	Dec     40.468529
	AppMagn 15.805
	MassSol 0.756
	RadSol  0.808
	Teff    5184
}

Star	"KOI-5149/KIC 5283728"
{
	RA      19.6182658
	Dec     40.462078
	AppMagn 15.649
	MassSol 0.915
	RadSol  0.833
	Teff    5735
}

Star	"KOI-5155/KIC 5374838"
{
	RA      19.680837
	Dec     40.516911
	AppMagn 15.469
	MassSol 1.011
	RadSol  1.007
	Teff    6085
}

Star	"KOI-5156/KIC 5390913"
{
	RA      19.91449993
	Dec     40.541969
	AppMagn 12.075
	MassSol 0.747
	RadSol  1.246
	Teff    6423
}

Star	"KOI-5158/KIC 5394585"
{
	RA      19.9587138
	Dec     40.535671
	AppMagn 11.867
	MassSol 1.349
	RadSol  2.302
	Teff    6768
}

Star	"KOI-5164/KIC 5436455"
{
	RA      19.1916158
	Dec     40.630409
	AppMagn 12.489
	MassSol 1.085
	RadSol  1.042
	Teff    6437
}

Star	"KOI-5169/KIC 5443320"
{
	RA      19.34703167
	Dec     40.66993
	AppMagn 15.47
	MassSol 0.736
	RadSol  0.786
	Teff    5204
}

Star	"KOI-5176/KIC 5529385"
{
	RA      19.36232707
	Dec     40.777241
	AppMagn 13.372
	MassSol 0.804
	RadSol  0.856
	Teff    5790
}

Star	"KOI-5179/KIC 5563057"
{
	RA      19.92783813
	Dec     40.716961
	AppMagn 12.519
	MassSol 1.469
	RadSol  1.667
	Teff    7479
}

Star	"KOI-5192/KIC 5697395"
{
	RA      19.28181967
	Dec     40.94949
	AppMagn 14.867
	MassSol 0.698
	RadSol  0.687
	Teff    4895
}

Star	"KOI-5196/KIC 5734702"
{
	RA      19.9284444
	Dec     40.970451
	AppMagn 12.361
	MassSol 1.149
	RadSol  1.13
	Teff    6640
}

Star	"KOI-5202/KIC 5793275"
{
	RA      19.50396727
	Dec     41.090012
	AppMagn 14.679
	MassSol 1.043
	RadSol  0.958
	Teff    6014
}

Star	"KOI-5205/KIC 5857656"
{
	RA      18.9773478
	Dec     41.10894
	AppMagn 12.842
	MassSol 1.072
	RadSol  1.185
	Teff    6218
}

Star	"KOI-5206/KIC 5858519"
{
	RA      19.00689493
	Dec     41.112469
	AppMagn 14.74
	MassSol 1.02
	RadSol  1.166
	Teff    6188
}

Star	"KOI-5207/KIC 5859725"
{
	RA      19.04594113
	Dec     41.18961
	AppMagn 13.048
	MassSol 0.79
	RadSol  0.825
	Teff    5830
}

Star	"KOI-521/KIC 8162789"
{
	RA      19.38234453
	Dec     44.09132
	AppMagn 14.633
	MassSol 0.999
	RadSol  1.06
	Teff    6032
}

Star	"KOI-5211/KIC 5946568"
{
	RA      19.1338908
	Dec     41.289101
	AppMagn 12.936
	MassSol 0.894
	RadSol  0.817
	Teff    5461
}

Star	"KOI-5216/KIC 5965629"
{
	RA      19.5642436
	Dec     41.290939
	AppMagn 15.495
	MassSol 0.983
	RadSol  0.891
	Teff    5897
}

Star	"KOI-5219/KIC 5981058"
{
	RA      19.817454
	Dec     41.255508
	AppMagn 15.197
	MassSol 0.667
	RadSol  0.701
	Teff    5457
}

Star	"KOI-5220/KIC 5986270"
{
	RA      19.8920288
	Dec     41.296391
	AppMagn 12.224
	MassSol 2.309
	RadSol  15.15
	Teff    4961
}

Star	"KOI-5223/KIC 6023571"
{
	RA      18.95657347
	Dec     41.319389
	AppMagn 13.682
	MassSol 1.227
	RadSol  3.035
	Teff    4842
}

Star	"KOI-5224/KIC 6025174"
{
	RA      19.0117086
	Dec     41.342499
	AppMagn 14.892
	MassSol 0.971
	RadSol  1.074
	Teff    6054
}

Star	"KOI-5228/KIC 6036286"
{
	RA      19.32104493
	Dec     41.396439
	AppMagn 15.347
	MassSol 0.368
	RadSol  0.36
	Teff    3434
}

Star	"KOI-5230/KIC 6043490"
{
	RA      19.47769573
	Dec     41.329342
	AppMagn 13.381
	MassSol 1.248
	RadSol  2.453
	Teff    5458
}

Star	"KOI-5231/KIC 6045404"
{
	RA      19.5160156
	Dec     41.37896
	AppMagn 15.819
	MassSol 1.011
	RadSol  0.927
	Teff    6046
}

Star	"KOI-5236/KIC 6067545"
{
	RA      19.89319867
	Dec     41.314892
	AppMagn 13.093
	MassSol 1.088
	RadSol  1.031
	Teff    6241
}

Star	"KOI-5237/KIC 6115356"
{
	RA      19.280011
	Dec     41.430752
	AppMagn 15.326
	MassSol 0.823
	RadSol  0.745
	Teff    5772
}

Star	"KOI-524/KIC 8934495"
{
	RA      18.90294393
	Dec     45.225552
	AppMagn 14.868
	MassSol 0.889
	RadSol  0.799
	Teff    5361
}

Star	"KOI-5241/KIC 6139220"
{
	RA      19.7453532
	Dec     41.413071
	AppMagn 15.233
	MassSol 0.9
	RadSol  0.976
	Teff    6126
}

Star	"KOI-5243/KIC 6145939"
{
	RA      19.84510093
	Dec     41.428589
	AppMagn 12.366
	MassSol 1.2
	RadSol  2.216
	Teff    6337
}

Star	"KOI-5247/KIC 6197658"
{
	RA      19.30171307
	Dec     41.500488
	AppMagn 14.81
	MassSol 1.213
	RadSol  1.137
	Teff    6343
}

Star	"KOI-5248/KIC 6198670"
{
	RA      19.3218058
	Dec     41.524811
	AppMagn 15.142
	MassSol 0.77
	RadSol  0.82
	Teff    5692
}

Star	"KOI-5249/KIC 6203955"
{
	RA      19.433726
	Dec     41.550388
	AppMagn 14.518
	MassSol 1.066
	RadSol  1.015
	Teff    6372
}

Star	"KOI-525/KIC 9119458"
{
	RA      20.0605184
	Dec     45.45787
	AppMagn 14.539
	MassSol 0.942
	RadSol  1.152
	Teff    5770
}

Star	"KOI-5254/KIC 6266866"
{
	RA      18.97277627
	Dec     41.639271
	AppMagn 10.926
	MassSol 1.046
	RadSol  1.496
	Teff    5807
}

Star	"KOI-5255/KIC 6277594"
{
	RA      19.2928772
	Dec     41.696701
	AppMagn 13.164
	MassSol 1.058
	RadSol  1.102
	Teff    6354
}

Star	"KOI-5267/KIC 6350031"
{
	RA      19.11019087
	Dec     41.756142
	AppMagn 14.326
	MassSol 1.049
	RadSol  1.226
	Teff    6302
}

Star	"KOI-5269/KIC 6359929"
{
	RA      19.35986327
	Dec     41.75079
	AppMagn 15.392
	MassSol 0.965
	RadSol  0.924
	Teff    5696
}

Star	"KOI-5274/KIC 6366559"
{
	RA      19.5088664
	Dec     41.749222
	AppMagn 12.746
	MassSol 1.177
	RadSol  2.581
	Teff    5376
}

Star	"KOI-5275/KIC 6367663"
{
	RA      19.5329956
	Dec     41.712749
	AppMagn 14.531
	MassSol 0.951
	RadSol  1.216
	Teff    6318
}

Star	"KOI-5278/KIC 6372194"
{
	RA      19.6225
	Dec     41.7475
	AppMagn 16.3
	MassSol 0.8
	RadSol  0.75
	Teff    5233
	FeH    -0.37
}

Star	"KOI-5279/KIC 6387557"
{
	RA      19.87423707
	Dec     41.712749
	AppMagn 14.775
	MassSol 0.888
	RadSol  0.841
	Teff    5721
}

Star	"KOI-5281/KIC 6425377"
{
	RA      18.99890953
	Dec     41.881351
	AppMagn 13.485
	MassSol 1.902
	RadSol  6.247
	Teff    5094
}

Star	"KOI-5283/KIC 6442735"
{
	RA      19.450942
	Dec     41.86013
	AppMagn 14.043
	MassSol 0.991
	RadSol  0.94
	Teff    5919
}

Star	"KOI-5284/KIC 6443093"
{
	RA      19.45935667
	Dec     41.816818
	AppMagn 14.57
	MassSol 0.921
	RadSol  0.958
	Teff    5731
}

Star	"KOI-5287/KIC 6509282"
{
	RA      19.15536093
	Dec     41.974899
	AppMagn 13.56
	MassSol 3.192
	RadSol  16.187
	Teff    4998
}

Star	"KOI-5288/KIC 6511182"
{
	RA      19.20849
	Dec     41.952801
	AppMagn 15.684
	MassSol 0.911
	RadSol  0.83
	Teff    5601
}

Star	"KOI-5290/KIC 6517200"
{
	RA      19.34671227
	Dec     41.946289
	AppMagn 15.667
	MassSol 0.98
	RadSol  0.882
	Teff    5750
}

Star	"KOI-5296/KIC 6527229"
{
	RA      19.555601
	Dec     41.937321
	AppMagn 15.814
	MassSol 1.008
	RadSol  0.916
	Teff    5896
}

Star	"KOI-5297/KIC 6543192"
{
	RA      19.8283854
	Dec     41.932991
	AppMagn 14.441
	MassSol 0.926
	RadSol  0.924
	Teff    5533
}

Star	"KOI-5298/KIC 6543674"
{
	RA      19.83610433
	Dec     41.950901
	AppMagn 13.535
	MassSol 1.15
	RadSol  2.264
	Teff    6047
}

Star	"KOI-5300/KIC 6594945"
{
	RA      19.21874793
	Dec     42.072079
	AppMagn 13.039
	MassSol 1.065
	RadSol  1.196
	Teff    6391
}

Star	"KOI-5308/KIC 6634112"
{
	RA      19.90950113
	Dec     42.092831
	AppMagn 14.099
	MassSol 0.775
	RadSol  0.843
	Teff    5268
}

Star	"KOI-531/KIC 10395543"
{
	RA      19.17941287
	Dec     47.546902
	AppMagn 14.418
	MassSol 0.62
	RadSol  0.6
	Teff    4030
}

Star	"KOI-5310/KIC 6675757"
{
	RA      19.10196127
	Dec     42.167511
	AppMagn 13.993
	MassSol 0.742
	RadSol  0.833
	Teff    5696
}

Star	"KOI-5317/KIC 6699562"
{
	RA      19.60431313
	Dec     42.112869
	AppMagn 13.529
	MassSol 1.054
	RadSol  1.075
	Teff    6354
}

Star	"KOI-532/KIC 10454313"
{
	RA      18.95048013
	Dec     47.68895
	AppMagn 14.708
	MassSol 1.053
	RadSol  0.987
	Teff    6123
}

Star	"KOI-5321/KIC 6721603"
{
	RA      19.9304362
	Dec     42.156315
	AppMagn 13.793
	MassSol 1.03
	RadSol  1.568
	Teff    6163
}

Star	"KOI-5322/KIC 6756369"
{
	RA      18.93152873
	Dec     42.276588
	AppMagn 13.907
	MassSol 1.653
	RadSol  5.127
	Teff    5029
}

Star	"KOI-5323/KIC 6762188"
{
	RA      19.1034078
	Dec     42.234798
	AppMagn 13.672
	MassSol 2.096
	RadSol  8.052
	Teff    4992
}

Star	"KOI-5324/KIC 6765563"
{
	RA      19.19379067
	Dec     42.208721
	AppMagn 13.705
	MassSol 1.051
	RadSol  3.055
	Teff    5203
}

Star	"KOI-5327/KIC 6776555"
{
	RA      19.4371114
	Dec     42.214169
	AppMagn 15.808
	MassSol 0.569
	RadSol  0.569
	Teff    3702
}

Star	"KOI-5328/KIC 6784887"
{
	RA      19.59940593
	Dec     42.26086
	AppMagn 14.965
	MassSol 0.999
	RadSol  0.941
	Teff    6185
}

Star	"KOI-5329/KIC 6805414"
{
	RA      19.90966187
	Dec     42.285831
	AppMagn 15.392
	MassSol 1.072
	RadSol  0.997
	Teff    6108
}

Star	"KOI-5331/KIC 6869373"
{
	RA      19.57784833
	Dec     42.320541
	AppMagn 15.164
	MassSol 0.82
	RadSol  0.733
	Teff    5314
}

Star	"KOI-5332/KIC 6875342"
{
	RA      19.68255007
	Dec     42.322361
	AppMagn 14.296
	MassSol 1.084
	RadSol  1.059
	Teff    6190
}

Star	"KOI-5333/KIC 6879183"
{
	RA      19.74043173
	Dec     42.354279
	AppMagn 15.529
	MassSol 1.095
	RadSol  1.057
	Teff    5922
}

Star	"KOI-5335/KIC 6891512"
{
	RA      19.91992593
	Dec     42.390888
	AppMagn 11.388
	MassSol 1.101
	RadSol  1.795
	Teff    5853
}

Star	"KOI-5336/KIC 6934045"
{
	RA      19.1198364
	Dec     42.42091
	AppMagn 13.491
	MassSol 1.277
	RadSol  1.48
	Teff    6543
}

Star	"KOI-5339/KIC 6948815"
{
	RA      19.45913693
	Dec     42.430149
	AppMagn 15.348
	MassSol 1.564
	RadSol  1.937
	Teff    7631
}

Star	"KOI-5341/KIC 7009548"
{
	RA      18.8194214
	Dec     42.545509
	AppMagn 12.493
	MassSol 1.05
	RadSol  1.339
	Teff    6311
}

Star	"KOI-5344/KIC 7018210"
{
	RA      19.09016113
	Dec     42.58577
	AppMagn 13.735
	MassSol 1.454
	RadSol  1.755
	Teff    7202
}

Star	"KOI-5351/KIC 7047299"
{
	RA      19.70737713
	Dec     42.578369
	AppMagn 14.295
	MassSol 0.904
	RadSol  0.827
	Teff    5857
}

Star	"KOI-5358/KIC 7125794"
{
	RA      19.61015627
	Dec     42.61898
	AppMagn 12.968
	MassSol 1.057
	RadSol  1.249
	Teff    6611
}

Star	"KOI-5359/KIC 7130612"
{
	RA      19.69423827
	Dec     42.663071
	AppMagn 16.56
	MassSol 0.55
	RadSol  0.527
	Teff    3939
}

Star	"KOI-5360/KIC 7132462"
{
	RA      19.72394
	Dec     42.642189
	AppMagn 13.67
	MassSol 1.027
	RadSol  1.699
	Teff    6014
}

Star	"KOI-5369/KIC 7198587"
{
	RA      19.4177226
	Dec     42.739491
	AppMagn 12.888
	MassSol 2.123
	RadSol  6.261
	Teff    5122
}

Star	"KOI-5372/KIC 7205717"
{
	RA      19.56324053
	Dec     42.744911
	AppMagn 14.01
	MassSol 1.022
	RadSol  1.207
	Teff    5834
}

Star	"KOI-5373/KIC 7206422"
{
	RA      19.576121
	Dec     42.736019
	AppMagn 11.509
	MassSol 1.47
	RadSol  3.859
	Teff    5031
}

Star	"KOI-5375/KIC 7213311"
{
	RA      19.70117593
	Dec     42.758942
	AppMagn 13.863
	MassSol 0.817
	RadSol  2.756
	Teff    5142
}

Star	"KOI-5379/KIC 7282470"
{
	RA      19.46151327
	Dec     42.892921
	AppMagn 12.518
	MassSol 1.419
	RadSol  4.313
	Teff    5227
}

Star	"KOI-5380/KIC 7289139"
{
	RA      19.5974304
	Dec     42.806419
	AppMagn 15.524
	MassSol 1.08
	RadSol  1.024
	Teff    6158
}

Star	"KOI-5384/KIC 7377343"
{
	RA      19.72726033
	Dec     42.988209
	AppMagn 14.406
	MassSol 1.052
	RadSol  1.196
	Teff    6217
}

Star	"KOI-5387/KIC 7416016"
{
	RA      18.69030153
	Dec     43.056671
	AppMagn 14.587
	MassSol 0.577
	RadSol  0.59
	Teff    4192
}

Star	"KOI-5388/KIC 7416306"
{
	RA      18.70142213
	Dec     43.077068
	AppMagn 13.668
	MassSol 1.304
	RadSol  2.655
	Teff    5425
}

Star	"KOI-5390/KIC 7440715"
{
	RA      19.36713667
	Dec     43.015041
	AppMagn 14.457
	MassSol 0.857
	RadSol  2.024
	Teff    5087
}

Star	"KOI-5393/KIC 7458743"
{
	RA      19.70967813
	Dec     43.065338
	AppMagn 13.586
	MassSol 1.533
	RadSol  6.428
	Teff    4895
}

Star	"KOI-5398/KIC 7539277"
{
	RA      19.6686564
	Dec     43.129421
	AppMagn 14.465
	MassSol 1.003
	RadSol  0.887
	Teff    5691
}

Star	"KOI-5403/KIC 7599004"
{
	RA      19.26069133
	Dec     43.21846
	AppMagn 14.777
	MassSol 1.072
	RadSol  1.332
	Teff    6363
}

Star	"KOI-5406/KIC 7625138"
{
	RA      19.7773112
	Dec     43.27029
	AppMagn 11.331
	MassSol 1.227
	RadSol  1.865
	Teff    6356
}

Star	"KOI-5408/KIC 7631138"
{
	RA      19.86893513
	Dec     43.228271
	AppMagn 14.03
	MassSol 0.912
	RadSol  1.534
	Teff    5324
}

Star	"KOI-5409/KIC 7658229"
{
	RA      18.67950033
	Dec     43.302479
	AppMagn 14.824
	MassSol 0.901
	RadSol  1.321
	Teff    5696
}

Star	"KOI-5410/KIC 7662502"
{
	RA      18.86540933
	Dec     43.300407
	AppMagn 13.664
	MassSol 1.073
	RadSol  1.095
	Teff    6223
}

Star	"KOI-5411/KIC 7672215"
{
	RA      19.19583127
	Dec     43.377659
	AppMagn 13.335
	MassSol 1.552
	RadSol  1.752
	Teff    7372
}

Star	"KOI-5412/KIC 7674050"
{
	RA      19.24957273
	Dec     43.351089
	AppMagn 15.911
	MassSol 0.929
	RadSol  0.848
	Teff    5763
}

Star	"KOI-5413/KIC 7690782"
{
	RA      19.634021
	Dec     43.322319
	AppMagn 14.105
	MassSol 0.798
	RadSol  0.953
	Teff    5574
}

Star	"KOI-5417/KIC 7743464"
{
	RA      19.21020507
	Dec     43.47356
	AppMagn 14.925
	MassSol 1.117
	RadSol  1.012
	Teff    6063
}

Star	"KOI-5418/KIC 7747091"
{
	RA      19.315212
	Dec     43.488239
	AppMagn 15.181
	MassSol 0.944
	RadSol  0.837
	Teff    5475
}

Star	"KOI-5423/KIC 7762153"
{
	RA      19.65466307
	Dec     43.471111
	AppMagn 15.2
	MassSol 1.116
	RadSol  1.1
	Teff    5857
}

Star	"KOI-5426/KIC 7770901"
{
	RA      19.8193644
	Dec     43.467789
	AppMagn 13.701
	MassSol 0.898
	RadSol  1.234
	Teff    6103
}

Star	"KOI-5433/KIC 7829836"
{
	RA      19.62031047
	Dec     43.509701
	AppMagn 14.573
	MassSol 1.113
	RadSol  1.11
	Teff    6202
}

Star	"KOI-5435/KIC 7836096"
{
	RA      19.7457764
	Dec     43.581379
	AppMagn 15.951
	MassSol 0.85
	RadSol  0.78
	Teff    4948
}

Star	"KOI-5436/KIC 7837526"
{
	RA      19.7744222
	Dec     43.529301
	AppMagn 12.796
	MassSol 0.924
	RadSol  1.256
	Teff    6324
}

Star	"KOI-5440/KIC 7888863"
{
	RA      19.40511067
	Dec     43.61208
	AppMagn 15.335
	MassSol 1.011
	RadSol  0.937
	Teff    6187
}

Star	"KOI-5445/KIC 7916058"
{
	RA      19.94019573
	Dec     43.69421
	AppMagn 15.71
	MassSol 0.895
	RadSol  0.815
	Teff    5658
}

Star	"KOI-5451/KIC 7950158"
{
	RA      19.2024048
	Dec     43.796139
	AppMagn 13.156
	MassSol 1.144
	RadSol  2.504
	Teff    5283
}

Star	"KOI-5458/KIC 8007174"
{
	RA      18.7885132
	Dec     43.808689
	AppMagn 15.602
	MassSol 0.819
	RadSol  0.785
	Teff    5025
}

Star	"KOI-5459/KIC 8009811"
{
	RA      18.89158933
	Dec     43.801361
	AppMagn 11.47
	MassSol 1.157
	RadSol  1.552
	Teff    6185
}

Star	"KOI-5461/KIC 8016650"
{
	RA      19.12828367
	Dec     43.82943
	AppMagn 13.468
	MassSol 2.573
	RadSol  8.984
	Teff    4849
}

Star	"KOI-5471/KIC 8075618"
{
	RA      18.77319333
	Dec     43.976479
	AppMagn 15.674
	MassSol 0.924
	RadSol  0.832
	Teff    5487
}

Star	"KOI-5472/KIC 8076215"
{
	RA      18.7969706
	Dec     43.98061
	AppMagn 12.603
	MassSol 1.372
	RadSol  3.18
	Teff    5437
}

Star	"KOI-5476/KIC 8105719"
{
	RA      19.64041953
	Dec     43.937141
	AppMagn 15.563
	MassSol 1.019
	RadSol  0.932
	Teff    6003
}

Star	"KOI-5478/KIC 8108437"
{
	RA      19.6995402
	Dec     43.99353
	AppMagn 15.703
	MassSol 1.006
	RadSol  0.914
	Teff    5911
}

Star	"KOI-5479/KIC 8125917"
{
	RA      19.99920047
	Dec     43.917721
	AppMagn 14.261
	MassSol 0.983
	RadSol  1.702
	Teff    5465
}

Star	"KOI-5480/KIC 8129333"
{
	RA      20.058136
	Dec     43.973541
	AppMagn 16.558
	MassSol 0.986
	RadSol  1.46
	Teff    5936
}

Star	"KOI-5482/KIC 8158429"
{
	RA      19.28193967
	Dec     44.09166
	AppMagn 15.197
	MassSol 0.966
	RadSol  0.872
	Teff    5861
}

Star	"KOI-5483/KIC 8179747"
{
	RA      19.76113487
	Dec     44.04821
	AppMagn 14.933
	MassSol 0.872
	RadSol  1.722
	Teff    5228
}

Star	"KOI-5485/KIC 8197176"
{
	RA      20.05901487
	Dec     44.081329
	AppMagn 17.054
	MassSol 1.583
	RadSol  4.521
	Teff    5188
}

Star	"KOI-5486/KIC 8197406"
{
	RA      20.06279093
	Dec     44.023651
	AppMagn 12.572
	MassSol 1.405
	RadSol  1.65
	Teff    7025
}

Star	"KOI-5487/KIC 8223445"
{
	RA      19.194574
	Dec     44.1213
	AppMagn 15.861
	MassSol 1.113
	RadSol  1.11
	Teff    6202
}

Star	"KOI-5497/KIC 8279146"
{
	RA      18.81642047
	Dec     44.28228
	AppMagn 10.926
	MassSol 1.224
	RadSol  1.673
	Teff    6809
}

Star	"KOI-5498/KIC 8288404"
{
	RA      19.14744667
	Dec     44.283192
	AppMagn 12.651
	MassSol 1.075
	RadSol  1.064
	Teff    6254
}

Star	"KOI-5499/KIC 8294683"
{
	RA      19.3343648
	Dec     44.205582
	AppMagn 15.443
	MassSol 0.654
	RadSol  0.669
	Teff    5003
}

Star	"KOI-5500/KIC 8295087"
{
	RA      19.3436788
	Dec     44.254017
	AppMagn 13.67
	MassSol 1.016
	RadSol  1.395
	Teff    6290
}

Star	"KOI-5506/KIC 8352009"
{
	RA      19.05304767
	Dec     44.35051
	AppMagn 14.152
	MassSol 1.085
	RadSol  1.031
	Teff    6277
}

Star	"KOI-5508/KIC 8364969"
{
	RA      19.43982547
	Dec     44.398521
	AppMagn 15.45
	MassSol 0.746
	RadSol  0.871
	Teff    5645
}

Star	"KOI-5509/KIC 8378278"
{
	RA      19.74566247
	Dec     44.342991
	AppMagn 15.423
	MassSol 0.952
	RadSol  0.936
	Teff    6085
}

Star	"KOI-5511/KIC 8395870"
{
	RA      20.0621582
	Dec     44.34454
	AppMagn 12.395
	MassSol 1.07
	RadSol  1.807
	Teff    5933
}

Star	"KOI-5514/KIC 8415353"
{
	RA      18.9842936
	Dec     44.485004
	AppMagn 13.845
	MassSol 1.358
	RadSol  1.83
	Teff    6359
}

Star	"KOI-5515/KIC 8429817"
{
	RA      19.4301514
	Dec     44.431751
	AppMagn 13.952
	MassSol 0.936
	RadSol  1.194
	Teff    6247
}

Star	"KOI-5517/KIC 8432249"
{
	RA      19.492926
	Dec     44.476212
	AppMagn 13.938
	MassSol 1.679
	RadSol  4.721
	Teff    5172
}

Star	"KOI-5520/KIC 8474892"
{
	RA      18.7842082
	Dec     44.57719
	AppMagn 14.372
	MassSol 0.971
	RadSol  1.17
	Teff    5869
}

Star	"KOI-5521/KIC 8480642"
{
	RA      19.00002647
	Dec     44.544991
	AppMagn 13.687
	MassSol 0.995
	RadSol  2.295
	Teff    5178
}

Star	"KOI-5527/KIC 8507073"
{
	RA      19.73564653
	Dec     44.56221
	AppMagn 14.174
	MassSol 1.003
	RadSol  1.033
	Teff    6131
}

Star	"KOI-5528/KIC 8507586"
{
	RA      19.74608153
	Dec     44.542122
	AppMagn 15.169
	MassSol 0.945
	RadSol  0.923
	Teff    5919
}

Star	"KOI-5529/KIC 8509781"
{
	RA      19.7886678
	Dec     44.549149
	AppMagn 11.701
	MassSol 1.019
	RadSol  1.306
	Teff    6082
}

Star	"KOI-5532/KIC 8525101"
{
	RA      20.0556844
	Dec     44.560661
	AppMagn 13.434
	MassSol 1.225
	RadSol  5.058
	Teff    4995
}

Star	"KOI-5533/KIC 8525286"
{
	RA      20.06009727
	Dec     44.597328
	AppMagn 13.43
}

Star	"KOI-554/KIC 5443837"
{
	RA      19.35674233
	Dec     40.687
	AppMagn 14.545
	MassSol 1.072
	RadSol  0.997
	Teff    6108
}

Star	"KOI-5541/KIC 8548454"
{
	RA      19.1203776
	Dec     44.63987
	AppMagn 14.699
	MassSol 0.984
	RadSol  0.901
	Teff    5823
}

Star	"KOI-5543/KIC 8560475"
{
	RA      19.4652954
	Dec     44.69516
	AppMagn 13.56
	MassSol 3.366
	RadSol  18.266
	Teff    4989
}

Star	"KOI-5545/KIC 8570210"
{
	RA      19.70646567
	Dec     44.613892
	AppMagn 13.607
	MassSol 0.879
	RadSol  0.802
	Teff    5829
}

Star	"KOI-5546/KIC 8571421"
{
	RA      19.73151853
	Dec     44.645088
	AppMagn 14.848
	MassSol 1.213
	RadSol  1.137
	Teff    6343
}

Star	"KOI-5552/KIC 8644545"
{
	RA      19.8759094
	Dec     44.744061
	AppMagn 13.344
	MassSol 0.822
	RadSol  1.769
	Teff    5364
}

Star	"KOI-5553/KIC 8644911"
{
	RA      19.88218587
	Dec     44.756432
	AppMagn 15.54
	MassSol 0.777
	RadSol  0.843
	Teff    5456
}

Star	"KOI-5554/KIC 8652997"
{
	RA      20.02612913
	Dec     44.78532
	AppMagn 11.189
	MassSol 0.874
	RadSol  1.277
	Teff    6113
}

Star	"KOI-5556/KIC 8656535"
{
	RA      20.1004374
	Dec     44.711842
	AppMagn 13.415
	MassSol 0.901
	RadSol  1.006
	Teff    5594
}

Star	"KOI-5564/KIC 8718273"
{
	RA      20.051239
	Dec     44.83062
	AppMagn 10.565
	MassSol 2.017
	RadSol  16.215
	Teff    4724
}

Star	"KOI-5566/KIC 8741367"
{
	RA      19.086086
	Dec     44.920082
	AppMagn 12.551
	MassSol 1.49
	RadSol  2.773
	Teff    6456
}

Star	"KOI-5567/KIC 8742270"
{
	RA      19.11950687
	Dec     44.968369
	AppMagn 14.857
	MassSol 0.923
	RadSol  0.949
	Teff    5753
}

Star	"KOI-5570/KIC 8747910"
{
	RA      19.30854287
	Dec     44.942421
	AppMagn 14.789
	MassSol 0.879
	RadSol  0.821
	Teff    5596
}

Star	"KOI-5572/KIC 8807988"
{
	RA      19.1374308
	Dec     45.03043
	AppMagn 13.596
	MassSol 0.896
	RadSol  0.802
	Teff    5192
}

Star	"KOI-5574/KIC 8814872"
{
	RA      19.35384927
	Dec     45.01141
	AppMagn 15.85
	MassSol 0.599
	RadSol  0.612
	Teff    4236
}

Star	"KOI-5577/KIC 8841297"
{
	RA      19.93855387
	Dec     45.05481
	AppMagn 13.5
	MassSol 1.062
	RadSol  1.634
	Teff    6043
}

Star	"KOI-5578/KIC 8868481"
{
	RA      18.95434573
	Dec     45.132259
	AppMagn 11.084
	MassSol 1.29
	RadSol  2.46
	Teff    5779
}

Star	"KOI-5579/KIC 8888745"
{
	RA      19.534375
	Dec     45.16674
	AppMagn 15.592
	MassSol 0.764
	RadSol  0.801
	Teff    4999
}

Star	"KOI-558/KIC 5978361"
{
	RA      19.77751667
	Dec     41.261238
	AppMagn 14.874
	MassSol 0.859
	RadSol  0.795
	Teff    5500
}

Star	"KOI-5583/KIC 8915379"
{
	RA      20.0637268
	Dec     45.11108
	AppMagn 15.306
	MassSol 0.695
	RadSol  0.753
	Teff    5523
}

Star	"KOI-5585/KIC 8937555"
{
	RA      19.00666507
	Dec     45.23811
	AppMagn 12.397
	MassSol 1.067
	RadSol  2.233
	Teff    5155
}

Star	"KOI-5587/KIC 8939650"
{
	RA      19.07501627
	Dec     45.276932
	AppMagn 14.268
	MassSol 1.063
	RadSol  1.093
	Teff    6329
}

Star	"KOI-5591/KIC 8959240"
{
	RA      19.6060852
	Dec     45.21767
	AppMagn 13.555
	MassSol 1.15
	RadSol  2.27
	Teff    5066
}

Star	"KOI-5592/KIC 8971044"
{
	RA      19.83220827
	Dec     45.291142
	AppMagn 15.054
	MassSol 1.034
	RadSol  0.96
	Teff    6168
}

Star	"KOI-5597/KIC 9011877"
{
	RA      19.18845213
	Dec     45.331322
	AppMagn 13.725
	MassSol 0.907
	RadSol  1.134
	Teff    5243
}

Star	"KOI-5602/KIC 9026007"
{
	RA      19.552891
	Dec     45.342541
	AppMagn 14.624
	MassSol 1.003
	RadSol  0.921
	Teff    6086
}

Star	"KOI-5603/KIC 9026248"
{
	RA      19.55866293
	Dec     45.31385
	AppMagn 12.472
	MassSol 1.245
	RadSol  3.098
	Teff    5138
}

Star	"KOI-5604/KIC 9044060"
{
	RA      19.88553873
	Dec     45.373589
	AppMagn 12.952
	MassSol 1.257
	RadSol  1.725
	Teff    6282
}

Star	"KOI-5605/KIC 9047416"
{
	RA      19.94611407
	Dec     45.34354
	AppMagn 14.321
	MassSol 1.103
	RadSol  1.735
	Teff    5627
}

Star	"KOI-5606/KIC 9049550"
{
	RA      19.98525593
	Dec     45.394032
	AppMagn 14.488
	MassSol 0.803
	RadSol  1.89
	Teff    5421
}

Star	"KOI-5608/KIC 9073549"
{
	RA      18.95499267
	Dec     45.482319
	AppMagn 15.212
	MassSol 1.121
	RadSol  1.069
	Teff    6064
}

Star	"KOI-5612/KIC 9087853"
{
	RA      19.43101193
	Dec     45.47007
	AppMagn 15.871
	MassSol 0.92
	RadSol  0.82
	Teff    5438
}

Star	"KOI-5613/KIC 9097470"
{
	RA      19.65518393
	Dec     45.469952
	AppMagn 15.612
	MassSol 1.008
	RadSol  0.946
	Teff    5754
}

Star	"KOI-5623/KIC 9142225"
{
	RA      19.0533976
	Dec     45.571739
	AppMagn 14.495
	MassSol 1.073
	RadSol  1.118
	Teff    6328
}

Star	"KOI-5625/KIC 9147012"
{
	RA      19.22854613
	Dec     45.566269
	AppMagn 16.017
	MassSol 0.697
	RadSol  0.736
	Teff    5197
}

Star	"KOI-5626/KIC 9147029"
{
	RA      19.2290548
	Dec     45.519852
	AppMagn 15.312
	MassSol 1.296
	RadSol  1.231
	Teff    6423
}

Star	"KOI-5628/KIC 9157030"
{
	RA      19.5209432
	Dec     45.546501
	AppMagn 15.712
	MassSol 0.742
	RadSol  0.694
	Teff    4810
}

Star	"KOI-5629/KIC 9157523"
{
	RA      19.53432413
	Dec     45.577831
	AppMagn 12.534
	MassSol 1.126
	RadSol  1.569
	Teff    6065
}

Star	"KOI-5632/KIC 9166700"
{
	RA      19.75587567
	Dec     45.545109
	AppMagn 11.154
	MassSol 1.427
	RadSol  2.04
	Teff    6543
}

Star	"KOI-5633/KIC 9173014"
{
	RA      19.87424313
	Dec     45.563419
	AppMagn 11.141
	MassSol 1.542
	RadSol  3.134
	Teff    6328
}

Star	"KOI-5638/KIC 9209981"
{
	RA      19.2007446
	Dec     45.68716
	AppMagn 14.737
	MassSol 1.164
	RadSol  1.148
	Teff    6452
}

Star	"KOI-5639/KIC 9210738"
{
	RA      19.22678833
	Dec     45.677029
	AppMagn 13.845
	MassSol 1.101
	RadSol  2.604
	Teff    5159
}

Star	"KOI-5640/KIC 9214176"
{
	RA      19.34354247
	Dec     45.635471
	AppMagn 12.038
	MassSol 1.276
	RadSol  4.89
	Teff    5183
}

Star	"KOI-5642/KIC 9217583"
{
	RA      19.4383036
	Dec     45.618389
	AppMagn 12.401
	MassSol 1.268
	RadSol  1.531
	Teff    6543
}

Star	"KOI-5645/KIC 9229807"
{
	RA      19.74199013
	Dec     45.681862
	AppMagn 15.927
}

Star	"KOI-5649/KIC 9274092"
{
	RA      19.25265707
	Dec     45.727459
	AppMagn 15.218
	MassSol 0.685
	RadSol  0.669
	Teff    5126
}

Star	"KOI-5651/KIC 9282853"
{
	RA      19.5095052
	Dec     45.732342
	AppMagn 15.726
	MassSol 0.731
	RadSol  0.773
	Teff    5141
}

Star	"KOI-5652/KIC 9292100"
{
	RA      19.7371114
	Dec     45.76976
	AppMagn 14.969
	MassSol 0.616
	RadSol  0.626
	Teff    5040
}

Star	"KOI-5653/KIC 9300066"
{
	RA      19.89241333
	Dec     45.764229
	AppMagn 15.545
	MassSol 0.655
	RadSol  0.672
	Teff    4788
}

Star	"KOI-5656/KIC 9330740"
{
	RA      19.07483113
	Dec     45.84251
	AppMagn 12.687
}

Star	"KOI-5657/KIC 9334027"
{
	RA      19.20196327
	Dec     45.800098
	AppMagn 14.403
	MassSol 1.023
	RadSol  1.028
	Teff    6054
}

Star	"KOI-5660/KIC 9363944"
{
	RA      19.9356852
	Dec     45.869289
	AppMagn 13.66
	MassSol 1.067
	RadSol  4.649
	Teff    4961
}

Star	"KOI-5663/KIC 9391817"
{
	RA      19.04045
	Dec     45.990318
	AppMagn 13.06
	MassSol 1.029
	RadSol  0.958
	Teff    6200
}

Star	"KOI-5665/KIC 9394953"
{
	RA      19.15698647
	Dec     45.948662
	AppMagn 11.484
	MassSol 1.24
	RadSol  1.75
	Teff    6018
}

Star	"KOI-5666/KIC 9397862"
{
	RA      19.26817013
	Dec     45.926022
	AppMagn 13.872
	MassSol 0.952
	RadSol  0.927
	Teff    6164
}

Star	"KOI-5671/KIC 9417931"
{
	RA      19.79824627
	Dec     45.995209
	AppMagn 13.574
	MassSol 0.976
	RadSol  1.131
	Teff    6098
}

Star	"KOI-5672/KIC 9418508"
{
	RA      19.80961913
	Dec     45.950981
	AppMagn 14.333
	MassSol 0.813
	RadSol  1.678
	Teff    5515
}

Star	"KOI-5677/KIC 9456887"
{
	RA      19.20912273
	Dec     46.03838
	AppMagn 14.9
	MassSol 0.817
	RadSol  0.75
	Teff    5465
}

Star	"KOI-5680/KIC 9466486"
{
	RA      19.50006513
	Dec     46.037479
	AppMagn 13.263
	MassSol 0.792
	RadSol  1.844
	Teff    5553
}

Star	"KOI-5682/KIC 9472341"
{
	RA      19.64632567
	Dec     46.077
	AppMagn 16.224
	MassSol 0.824
	RadSol  1.717
	Teff    5401
}

Star	"KOI-5683/KIC 9474485"
{
	RA      19.69763387
	Dec     46.016998
	AppMagn 14.884
	MassSol 0.591
	RadSol  0.604
	Teff    4612
}

Star	"KOI-5684/KIC 9475697"
{
	RA      19.72486167
	Dec     46.014462
	AppMagn 11.128
	MassSol 2.571
	RadSol  8.611
	Teff    5048
}

Star	"KOI-5685/KIC 9481235"
{
	RA      19.8398702
	Dec     46.04377
	AppMagn 13.814
	MassSol 0.936
	RadSol  6.502
	Teff    4883
}

Star	"KOI-5688/KIC 9532603"
{
	RA      19.62335613
	Dec     46.14957
	AppMagn 16.897
	MassSol 0.821
	RadSol  0.735
	Teff    5183
}

Star	"KOI-5689/KIC 9534832"
{
	RA      19.67873127
	Dec     46.179401
	AppMagn 15.983
	MassSol 0.795
	RadSol  0.823
	Teff    4816
}

Star	"KOI-5692/KIC 9575728"
{
	RA      19.04241947
	Dec     46.247269
	AppMagn 14.137
	MassSol 0.551
	RadSol  0.542
	Teff    3901
}

Star	"KOI-5694/KIC 9579606"
{
	RA      19.19126587
	Dec     46.26936
	AppMagn 14.295
	MassSol 0.879
	RadSol  0.802
	Teff    5565
}

Star	"KOI-5695/KIC 9591728"
{
	RA      19.55647987
	Dec     46.25544
	AppMagn 14.916
	MassSol 0.9
	RadSol  1.23
	Teff    6201
}

Star	"KOI-5702/KIC 9659022"
{
	RA      19.71298627
	Dec     46.319328
	AppMagn 15.462
	MassSol 1.046
	RadSol  1.007
	Teff    6141
}

Star	"KOI-5704/KIC 9674789"
{
	RA      20.031602
	Dec     46.332039
	AppMagn 13.419
	MassSol 0.779
	RadSol  0.716
	Teff    5147
}

Star	"KOI-5707/KIC 9723746"
{
	RA      19.79602053
	Dec     46.494099
	AppMagn 15.239
	MassSol 1.175
	RadSol  1.168
	Teff    6208
}

Star	"KOI-5708/KIC 9724993"
{
	RA      19.82087607
	Dec     46.448212
	AppMagn 12.524
	MassSol 1.136
	RadSol  1.954
	Teff    5738
}

Star	"KOI-5712/KIC 9776907"
{
	RA      19.6269796
	Dec     46.56572
	AppMagn 16.925
	MassSol 0.856
	RadSol  0.781
	Teff    4965
}

Star	"KOI-5713/KIC 9780149"
{
	RA      19.70684
	Dec     46.517567
	AppMagn 12.294
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-5717/KIC 9838414"
{
	RA      19.65397747
	Dec     46.613079
	AppMagn 17.511
	MassSol 0.748
	RadSol  0.76
	Teff    4611
}

Star	"KOI-5718/KIC 9838582"
{
	RA      19.6584188
	Dec     46.607254
	AppMagn 17.106
	MassSol 1
	RadSol  1
	Teff    5780
}

Star	"KOI-5719/KIC 9839030"
{
	RA      19.67034507
	Dec     46.66975
	AppMagn 14.71
	MassSol 1.082
	RadSol  1.126
	Teff    6300
}

Star	"KOI-5722/KIC 9847239"
{
	RA      19.84940793
	Dec     46.660488
	AppMagn 14.876
	MassSol 1.023
	RadSol  0.945
	Teff    6131
}

Star	"KOI-5727/KIC 9881660"
{
	RA      19.15782473
	Dec     46.76865
	AppMagn 15.676
	MassSol 0.755
	RadSol  0.764
	Teff    4703
}

Star	"KOI-5732/KIC 9910043"
{
	RA      19.9046468
	Dec     46.753971
	AppMagn 15.453
	MassSol 0.878
	RadSol  0.794
	Teff    5911
}

Star	"KOI-5736/KIC 9935983"
{
	RA      18.91156413
	Dec     46.82272
	AppMagn 13.756
	MassSol 0.92
	RadSol  0.838
	Teff    5850
}

Star	"KOI-5737/KIC 9941136"
{
	RA      19.10871173
	Dec     46.843369
	AppMagn 13.772
	MassSol 0.976
	RadSol  0.96
	Teff    5916
}

Star	"KOI-5740/KIC 9942658"
{
	RA      19.17157387
	Dec     46.822159
	AppMagn 14.82
	MassSol 1.041
	RadSol  0.964
	Teff    6122
}

Star	"KOI-5744/KIC 9957668"
{
	RA      19.6318868
	Dec     46.863811
	AppMagn 12.508
	MassSol 0.897
	RadSol  1.061
	Teff    6340
}

Star	"KOI-5745/KIC 9962595"
{
	RA      19.75519613
	Dec     46.83963
	AppMagn 14.585
	MassSol 0.838
	RadSol  0.808
	Teff    5297
}

Star	"KOI-5747/KIC 9968924"
{
	RA      19.88499147
	Dec     46.837372
	AppMagn 13.81
	MassSol 1.311
	RadSol  1.672
	Teff    6519
}

Star	"KOI-5748/KIC 9993683"
{
	RA      18.8333476
	Dec     46.918571
	AppMagn 14.489
	MassSol 0.794
	RadSol  0.871
	Teff    5268
}

Star	"KOI-5749/KIC 9994381"
{
	RA      18.8623006
	Dec     46.994869
	AppMagn 15.399
	MassSol 0.746
	RadSol  0.692
	Teff    4864
}

Star	"KOI-5752/KIC 10004772"
{
	RA      19.25704547
	Dec     46.997261
	AppMagn 13.71
	MassSol 0.885
	RadSol  59.684
	Teff    3749
}

Star	"KOI-5753/KIC 10006096"
{
	RA      19.29994507
	Dec     46.92865
	AppMagn 15.284
	MassSol 0.773
	RadSol  0.789
	Teff    5511
}

Star	"KOI-5758/KIC 10027861"
{
	RA      19.8442912
	Dec     46.94482
	AppMagn 15.142
	MassSol 0.871
	RadSol  0.791
	Teff    5166
}

Star	"KOI-5761/KIC 10083325"
{
	RA      19.66488647
	Dec     47.015369
	AppMagn 13.421
	MassSol 1.06
	RadSol  1.149
	Teff    6140
}

Star	"KOI-5762/KIC 10090854"
{
	RA      19.8262146
	Dec     47.011459
	AppMagn 15.633
	MassSol 0.874
	RadSol  0.798
	Teff    5571
}

Star	"KOI-5769/KIC 10146103"
{
	RA      19.58308307
	Dec     47.15406
	AppMagn 14.498
	MassSol 0.783
	RadSol  0.721
	Teff    5632
}

Star	"KOI-5772/KIC 10186761"
{
	RA      18.75469767
	Dec     47.214809
	AppMagn 13.825
	MassSol 1.054
	RadSol  0.994
	Teff    6072
}

Star	"KOI-5774/KIC 10191056"
{
	RA      18.92442013
	Dec     47.228271
	AppMagn 10.811
	MassSol 1.337
	RadSol  1.751
	Teff    6782
}

Star	"KOI-5776/KIC 10199984"
{
	RA      19.231545
	Dec     47.247921
	AppMagn 13.183
	MassSol 1.014
	RadSol  2.522
	Teff    5357
}

Star	"KOI-5782/KIC 10272858"
{
	RA      19.4241964
	Dec     47.328709
	AppMagn 11.367
	MassSol 1.37
	RadSol  3.62
	Teff    5208
}

Star	"KOI-5785/KIC 10319834"
{
	RA      18.792216
	Dec     47.41605
	AppMagn 14.942
}

Star	"KOI-5786/KIC 10320341"
{
	RA      18.81313473
	Dec     47.419579
	AppMagn 14.482
	MassSol 1.085
	RadSol  1.031
	Teff    6277
}

Star	"KOI-5787/KIC 10339000"
{
	RA      19.4425944
	Dec     47.474972
	AppMagn 14.333
	MassSol 0.91
	RadSol  0.983
	Teff    6224
}

Star	"KOI-5790/KIC 10394802"
{
	RA      19.15275473
	Dec     47.598251
	AppMagn 15.518
	MassSol 0.847
	RadSol  0.777
	Teff    4972
}

Star	"KOI-5792/KIC 10416390"
{
	RA      19.7499064
	Dec     47.526539
	AppMagn 15.705
	MassSol 0.718
	RadSol  0.724
	Teff    4889
}

Star	"KOI-5795/KIC 10459749"
{
	RA      19.14117433
	Dec     47.61618
	AppMagn 15.952
}

Star	"KOI-5796/KIC 10470779"
{
	RA      19.46901447
	Dec     47.684391
	AppMagn 14.712
	MassSol 1.074
	RadSol  0.998
	Teff    6092
}

Star	"KOI-5797/KIC 10480952"
{
	RA      19.7203084
	Dec     47.670906
	AppMagn 12.22
	MassSol 1.244
	RadSol  2.056
	Teff    6456
}

Star	"KOI-5798/KIC 10487228"
{
	RA      19.84635007
	Dec     47.605862
	AppMagn 15.714
	MassSol 0.833
	RadSol  0.759
	Teff    5108
}

Star	"KOI-5799/KIC 10519727"
{
	RA      18.96246133
	Dec     47.750332
	AppMagn 13.609
	MassSol 1.042
	RadSol  1.621
	Teff    5620
}

Star	"KOI-5800/KIC 10525077"
{
	RA      19.15853847
	Dec     47.771187
	AppMagn 15.355
	MassSol 1.01
	RadSol  1.01
	Teff    6091
	FeH    -0.04
}

Star	"KOI-5801/KIC 10535708"
{
	RA      19.47429807
	Dec     47.729462
	AppMagn 15.609
	MassSol 1.014
	RadSol  0.919
	Teff    5849
}

Star	"KOI-5802/KIC 10547378"
{
	RA      19.76507367
	Dec     47.703018
	AppMagn 13.945
	MassSol 1.049
	RadSol  2.087
	Teff    5485
}

Star	"KOI-5805/KIC 10552151"
{
	RA      19.85592653
	Dec     47.751709
	AppMagn 14.519
	MassSol 0.616
	RadSol  0.624
	Teff    5192
}

Star	"KOI-5806/KIC 10552263"
{
	RA      19.85800173
	Dec     47.771091
	AppMagn 12.355
	MassSol 0.981
	RadSol  0.973
	Teff    5914
}

Star	"KOI-5807/KIC 10554421"
{
	RA      19.89974973
	Dec     47.738918
	AppMagn 14.466
}

Star	"KOI-5810/KIC 10581308"
{
	RA      18.84580893
	Dec     47.816978
	AppMagn 13.766
	MassSol 0.931
	RadSol  1.441
	Teff    5458
}

Star	"KOI-5812/KIC 10601163"
{
	RA      19.48862913
	Dec     47.835629
	AppMagn 14.122
	MassSol 0.863
	RadSol  1.159
	Teff    6070
}

Star	"KOI-5814/KIC 10616656"
{
	RA      19.8462972
	Dec     47.87896
	AppMagn 12.138
	MassSol 1.048
	RadSol  1.486
	Teff    6475
}

Star	"KOI-5815/KIC 10618044"
{
	RA      19.87121787
	Dec     47.867809
	AppMagn 13.744
	MassSol 0.976
	RadSol  1.849
	Teff    5210
}

Star	"KOI-5816/KIC 10656842"
{
	RA      19.20880127
	Dec     47.995541
	AppMagn 12.594
	MassSol 2.231
	RadSol  7.733
	Teff    4986
}

Star	"KOI-5817/KIC 10658177"
{
	RA      19.24842933
	Dec     47.906872
	AppMagn 13.336
	MassSol 1.051
	RadSol  1.271
	Teff    6522
}

Star	"KOI-5819/KIC 10663976"
{
	RA      19.41450807
	Dec     47.95216
	AppMagn 14.182
	MassSol 0.796
	RadSol  0.729
	Teff    5513
}

Star	"KOI-5822/KIC 10685764"
{
	RA      19.9161438
	Dec     47.945278
	AppMagn 12.31
	MassSol 0.933
	RadSol  1.979
	Teff    4885
}

Star	"KOI-5825/KIC 10737437"
{
	RA      19.61900227
	Dec     48.059448
	AppMagn 13.934
	MassSol 0.784
	RadSol  1.2
	Teff    5991
}

Star	"KOI-5826/KIC 10747162"
{
	RA      19.826062
	Dec     48.03928
	AppMagn 15.871
	MassSol 0.654
	RadSol  0.664
	Teff    4294
}

Star	"KOI-5829/KIC 10802364"
{
	RA      19.59402467
	Dec     48.192081
	AppMagn 14.857
	MassSol 0.977
	RadSol  0.86
	Teff    5591
}

Star	"KOI-5830/KIC 10809888"
{
	RA      19.76999307
	Dec     48.186661
	AppMagn 13.628
	MassSol 2.049
	RadSol  7.317
	Teff    5099
}

Star	"KOI-5831/KIC 10813078"
{
	RA      19.83011067
	Dec     48.15691
	AppMagn 15.712
	MassSol 0.578
	RadSol  0.584
	Teff    4029
}

Star	"KOI-5833/KIC 10850327"
{
	RA      19.10611111
	Dec     48.22027779
	AppMagn 13.4
	MassSol 0.98
	RadSol  1
	Teff    6277
	FeH    -0.46
}

Star	"KOI-5834/KIC 10855545"
{
	RA      19.2811544
	Dec     48.204311
	AppMagn 15.769
	MassSol 1.165
	RadSol  1.072
	Teff    6077
}

Star	"KOI-5835/KIC 10858504"
{
	RA      19.3719828
	Dec     48.214218
	AppMagn 15.087
	MassSol 1.002
	RadSol  0.962
	Teff    6287
}

Star	"KOI-5837/KIC 10878117"
{
	RA      19.8609802
	Dec     48.224411
	AppMagn 15.261
}

Star	"KOI-5839/KIC 10879899"
{
	RA      19.89849653
	Dec     48.222031
	AppMagn 12.427
	MassSol 1.199
	RadSol  1.378
	Teff    6362
}

Star	"KOI-5842/KIC 10933306"
{
	RA      19.8129496
	Dec     48.322891
	AppMagn 14.753
	MassSol 1.092
	RadSol  1.083
	Teff    6224
}

Star	"KOI-5849/KIC 10989620"
{
	RA      19.84113767
	Dec     48.408089
	AppMagn 14.489
	MassSol 0.962
	RadSol  0.997
	Teff    5611
}

Star	"KOI-5850/KIC 10991389"
{
	RA      19.8861206
	Dec     48.465691
	AppMagn 14.897
	MassSol 0.982
	RadSol  0.955
	Teff    5952
}

Star	"KOI-5852/KIC 11021266"
{
	RA      19.15736287
	Dec     48.5564
	AppMagn 15.583
	MassSol 1.073
	RadSol  1.001
	Teff    6028
}

Star	"KOI-5854/KIC 11026582"
{
	RA      19.35005693
	Dec     48.558701
	AppMagn 14.466
	MassSol 1.02
	RadSol  0.943
	Teff    6146
}

Star	"KOI-5855/KIC 11036168"
{
	RA      19.6531006
	Dec     48.557861
	AppMagn 15.138
	MassSol 0.937
	RadSol  0.848
	Teff    5821
}

Star	"KOI-5863/KIC 11080702"
{
	RA      19.33347167
	Dec     48.655361
	AppMagn 14.219
	MassSol 0.893
	RadSol  0.882
	Teff    5620
}

Star	"KOI-5868/KIC 11098704"
{
	RA      19.8680908
	Dec     48.626141
	AppMagn 13.787
	MassSol 1.153
	RadSol  1.477
	Teff    6538
}

Star	"KOI-5869/KIC 11100170"
{
	RA      19.90501507
	Dec     48.668362
	AppMagn 15.746
	MassSol 0.677
	RadSol  0.691
	Teff    4641
}

Star	"KOI-5874/KIC 11152511"
{
	RA      19.87083333
	Dec     48.72500002
	AppMagn 14
	MassSol 1.01
	RadSol  2.08
	Teff    5273
	FeH    -0.1
}

Star	"KOI-5877/KIC 11183752"
{
	RA      19.21456907
	Dec     48.886742
	AppMagn 15.571
	MassSol 0.83
	RadSol  0.884
	Teff    5803
}

Star	"KOI-5885/KIC 11340218"
{
	RA      19.0749044
	Dec     49.105289
	AppMagn 14.889
	MassSol 1.063
	RadSol  0.948
	Teff    5763
}

Star	"KOI-5888/KIC 11348610"
{
	RA      19.39125367
	Dec     49.105068
	AppMagn 15.491
	MassSol 0.893
	RadSol  0.803
	Teff    5463
}

Star	"KOI-5889/KIC 11351454"
{
	RA      19.49328407
	Dec     49.173641
	AppMagn 15.429
	MassSol 1.178
	RadSol  1.124
	Teff    6195
}

Star	"KOI-5892/KIC 11393248"
{
	RA      19.0867228
	Dec     49.211319
	AppMagn 15.337
	MassSol 0.902
	RadSol  0.827
	Teff    5573
}

Star	"KOI-5895/KIC 11407847"
{
	RA      19.62005613
	Dec     49.240311
	AppMagn 15.337
	MassSol 0.862
	RadSol  0.958
	Teff    5550
}

Star	"KOI-5899/KIC 11446961"
{
	RA      19.14358113
	Dec     49.33197
	AppMagn 13.899
	MassSol 0.961
	RadSol  0.986
	Teff    5548
}

Star	"KOI-5901/KIC 11456256"
{
	RA      19.4954244
	Dec     49.368561
	AppMagn 12.332
	MassSol 1.177
	RadSol  1.328
	Teff    6540
}

Star	"KOI-5902/KIC 11457664"
{
	RA      19.54420573
	Dec     49.383331
	AppMagn 14.396
	MassSol 0.967
	RadSol  0.871
	Teff    5778
}

Star	"KOI-5909/KIC 11520114"
{
	RA      19.82633053
	Dec     49.48494
	AppMagn 15.975
	MassSol 0.785
	RadSol  0.806
	Teff    4808
}

Star	"KOI-5911/KIC 11559493"
{
	RA      19.47185873
	Dec     49.52961
	AppMagn 15.388
	MassSol 1.086
	RadSol  1.076
	Teff    6233
}

Star	"KOI-5913/KIC 11598894"
{
	RA      18.9832316
	Dec     49.606258
	AppMagn 15.409
	MassSol 0.929
	RadSol  0.875
	Teff    5861
}

Star	"KOI-5918/KIC 11601633"
{
	RA      19.09979047
	Dec     49.614578
	AppMagn 14.258
	MassSol 0.869
	RadSol  0.866
	Teff    5360
}

Star	"KOI-5919/KIC 11601972"
{
	RA      19.1154968
	Dec     49.683189
	AppMagn 13.511
	MassSol 1.234
	RadSol  1.488
	Teff    6256
}

Star	"KOI-592/KIC 9957627"
{
	RA      19.63084513
	Dec     46.821449
	AppMagn 14.292
	MassSol 0.96
	RadSol  1.01
	Teff    6072
}

Star	"KOI-5924/KIC 11616434"
{
	RA      19.64605713
	Dec     49.626991
	AppMagn 15.789
	MassSol 0.72
	RadSol  0.748
	Teff    5031
}

Star	"KOI-5925/KIC 11651240"
{
	RA      19.0272278
	Dec     49.763641
	AppMagn 12.979
	MassSol 1.04
	RadSol  1.742
	Teff    5518
}

Star	"KOI-5929/KIC 11716643"
{
	RA      19.59111111
	Dec     49.80027779
	AppMagn 15.2
	MassSol 0.86
	RadSol  0.82
	Teff    5830
	FeH    -0.14
}

Star	"KOI-5932/KIC 11803074"
{
	RA      19.022522
	Dec     50.066132
	AppMagn 15.887
	MassSol 0.871
	RadSol  0.799
	Teff    5734
}

Star	"KOI-5935/KIC 11818566"
{
	RA      19.61375327
	Dec     50.045399
	AppMagn 15.69
}

Star	"KOI-5936/KIC 11819396"
{
	RA      19.63782553
	Dec     50.069721
	AppMagn 15.025
}

Star	"KOI-5938/KIC 11860294"
{
	RA      19.31023153
	Dec     50.12801
	AppMagn 12.812
	MassSol 1.073
	RadSol  1.155
	Teff    6273
}

Star	"KOI-5939/KIC 11868941"
{
	RA      19.62351687
	Dec     50.185989
	AppMagn 13.724
	MassSol 1.147
	RadSol  1.13
	Teff    6471
}

Star	"KOI-5940/KIC 11905398"
{
	RA      19.09932453
	Dec     50.230068
	AppMagn 15.627
	MassSol 0.853
	RadSol  0.781
	Teff    5503
}

Star	"KOI-5941/KIC 11910670"
{
	RA      19.31010133
	Dec     50.282619
	AppMagn 13.783
	MassSol 0.727
	RadSol  0.811
	Teff    5509
}

Star	"KOI-5943/KIC 11923213"
{
	RA      19.74697267
	Dec     50.236328
	AppMagn 14.172
	MassSol 0.979
	RadSol  1
	Teff    6353
}

Star	"KOI-5944/KIC 11924426"
{
	RA      19.78025513
	Dec     50.281551
	AppMagn 13.882
	MassSol 0.952
	RadSol  0.974
	Teff    6175
}

Star	"KOI-5948/KIC 12007270"
{
	RA      19.2121704
	Dec     50.49836
	AppMagn 13.843
	MassSol 0.83
	RadSol  0.759
	Teff    5776
}

Star	"KOI-5949/KIC 12009917"
{
	RA      19.31236573
	Dec     50.409229
	AppMagn 13.295
	MassSol 1.011
	RadSol  1.111
	Teff    6201
}

Star	"KOI-5950/KIC 12020376"
{
	RA      19.69867353
	Dec     50.42128
	AppMagn 13.718
	MassSol 0.823
	RadSol  0.741
	Teff    5359
}

Star	"KOI-5952/KIC 12071775"
{
	RA      19.76059167
	Dec     50.585171
	AppMagn 15.025
	MassSol 0.916
	RadSol  1.02
	Teff    5866
}

Star	"KOI-5953/KIC 12102775"
{
	RA      19.09329633
	Dec     50.625679
	AppMagn 15.479
	MassSol 0.989
	RadSol  0.886
	Teff    5291
}

Star	"KOI-5954/KIC 12105086"
{
	RA      19.203715
	Dec     50.65369
	AppMagn 13.144
	MassSol 1.012
	RadSol  0.918
	Teff    5865
}

Star	"KOI-5959/KIC 12168895"
{
	RA      19.74943647
	Dec     50.78051
	AppMagn 14.495
	MassSol 0.984
	RadSol  0.902
	Teff    5979
}

Star	"KOI-5960/KIC 12170767"
{
	RA      19.80144653
	Dec     50.769112
	AppMagn 13.325
	MassSol 0.84
	RadSol  1.441
	Teff    5622
}

Star	"KOI-5961/KIC 12253490"
{
	RA      19.24288333
	Dec     50.90118
	AppMagn 15.053
	MassSol 0.518
	RadSol  0.516
	Teff    4492
}

Star	"KOI-5964/KIC 12300524"
{
	RA      19.13933713
	Dec     51.01606
	AppMagn 13.186
	MassSol 1.108
	RadSol  1.005
	Teff    6039
}

Star	"KOI-5965/KIC 12349560"
{
	RA      19.12918907
	Dec     51.123508
	AppMagn 15.944
	MassSol 0.774
	RadSol  0.723
	Teff    4877
}

Star	"KOI-5966/KIC 12350136"
{
	RA      19.15724893
	Dec     51.158321
	AppMagn 14.63
}

Star	"KOI-5968/KIC 12402588"
{
	RA      19.23584593
	Dec     51.280384
	AppMagn 11.366
	MassSol 1.217
	RadSol  2.284
	Teff    5997
}

Star	"KOI-5971/KIC 12418418"
{
	RA      19.750883
	Dec     51.26609
	AppMagn 13.771
	MassSol 0.544
	RadSol  0.548
	Teff    4558
}

Star	"KOI-5974/KIC 12554212"
{
	RA      19.26107993
	Dec     51.534962
	AppMagn 13.442
	MassSol 0.638
	RadSol  0.649
	Teff    4680
}

Star	"KOI-5976/KIC 12645761"
{
	RA      19.3135966
	Dec     51.714401
	AppMagn 13.368
	MassSol 1.498
	RadSol  5.208
	Teff    5030
}

Star	"KOI-599/KIC 10676824"
{
	RA      19.74138187
	Dec     47.921478
	AppMagn 14.854
	MassSol 1.016
	RadSol  0.943
	Teff    6092
}

Star	"KOI-6028/KIC 6606934"
{
	RA      19.47144367
	Dec     42.076382
	AppMagn 14.898
	MassSol 1.16
	RadSol  1.156
	Teff    6428
}

Star	"KOI-6036/KIC 7362852"
{
	RA      19.45397747
	Dec     42.981609
	AppMagn 15.168
	MassSol 1.058
	RadSol  0.989
	Teff    6201
}

Star	"KOI-6047/KIC 7914906"
{
	RA      19.9210978
	Dec     43.673321
	AppMagn 11.961
	MassSol 1.8
	RadSol  2.624
	Teff    7279
}

Star	"KOI-6064/KIC 9214712"
{
	RA      19.35930787
	Dec     45.681438
	AppMagn 15.518
	MassSol 0.959
	RadSol  0.867
	Teff    5870
}

Star	"KOI-6066/KIC 9221398"
{
	RA      19.53952433
	Dec     45.691841
	AppMagn 12.14
	MassSol 1.23
	RadSol  1.441
	Teff    6654
}

Star	"KOI-607/KIC 5441980"
{
	RA      19.32060547
	Dec     40.615841
	AppMagn 14.377
	MassSol 0.83
	RadSol  0.755
	Teff    5729
}

Star	"KOI-6079/KIC 10659313"
{
	RA      19.28151653
	Dec     47.913891
	AppMagn 13.593
	MassSol 1.062
	RadSol  1.189
	Teff    6385
}

Star	"KOI-6093/KIC 2019477"
{
	RA      19.50346273
	Dec     37.421211
	AppMagn 13.33
	MassSol 0.739
	RadSol  0.834
	Teff    5529
}

Star	"KOI-6101/KIC 3230787"
{
	RA      19.35032347
	Dec     38.34166
	AppMagn 12.553
	MassSol 0.901
	RadSol  0.963
	Teff    5892
}

Star	"KOI-6102/KIC 3545840"
{
	RA      19.45013633
	Dec     38.66254
	AppMagn 10.915
	MassSol 1.353
	RadSol  1.565
	Teff    6711
}

Star	"KOI-6103/KIC 3634051"
{
	RA      19.19836427
	Dec     38.74028
	AppMagn 13.436
	MassSol 1.038
	RadSol  1.179
	Teff    6109
}

Star	"KOI-6108/KIC 4139254"
{
	RA      19.0575134
	Dec     39.20528
	AppMagn 12.12
	MassSol 0.811
	RadSol  0.957
	Teff    5551
}

Star	"KOI-6109/KIC 4144236"
{
	RA      19.1888896
	Dec     39.221272
	AppMagn 11.856
	MassSol 1.531
	RadSol  2.641
	Teff    6620
}

Star	"KOI-611/KIC 6309763"
{
	RA      19.88626913
	Dec     41.6838
	AppMagn 14.022
	MassSol 1.069
	RadSol  1.115
	Teff    6343
}

Star	"KOI-6111/KIC 4255944"
{
	RA      19.32321167
	Dec     39.331463
	AppMagn 12.914
	MassSol 1.843
	RadSol  2.674
	Teff    6845
}

Star	"KOI-6112/KIC 4285087"
{
	RA      19.77658893
	Dec     39.318588
	AppMagn 12.785
	MassSol 0.923
	RadSol  1.444
	Teff    6181
}

Star	"KOI-6115/KIC 4464394"
{
	RA      19.43984987
	Dec     39.53606
	AppMagn 13.497
}

Star	"KOI-6118/KIC 4739229"
{
	RA      19.30222373
	Dec     39.836639
	AppMagn 12.767
	MassSol 1.387
	RadSol  1.619
	Teff    7081
}

Star	"KOI-6120/KIC 4742420"
{
	RA      19.3633504
	Dec     39.862011
	AppMagn 15.416
	MassSol 1.04
	RadSol  0.991
	Teff    6123
}

Star	"KOI-6121/KIC 4826439"
{
	RA      19.2686544
	Dec     39.951889
	AppMagn 13.82
	MassSol 1.094
	RadSol  1.024
	Teff    6131
}

Star	"KOI-6130/KIC 5428657"
{
	RA      18.962734
	Dec     40.625
	AppMagn 15.121
	MassSol 0.537
	RadSol  0.539
	Teff    4530
}

Star	"KOI-6134/KIC 5738698"
{
	RA      19.9813192
	Dec     40.903961
	AppMagn 11.941
	MassSol 1.011
	RadSol  1.21
	Teff    6466
}

Star	"KOI-6137/KIC 5816144"
{
	RA      19.87960813
	Dec     41.029331
	AppMagn 14.191
	MassSol 1.055
	RadSol  1.021
	Teff    6174
}

Star	"KOI-6141/KIC 6032730"
{
	RA      19.2395264
	Dec     41.307339
	AppMagn 8.655
	MassSol 1.793
	RadSol  2.955
	Teff    7343
}

Star	"KOI-6150/KIC 6946681"
{
	RA      19.41286213
	Dec     42.49445
	AppMagn 12.182
}

Star	"KOI-6151/KIC 6946708"
{
	RA      19.4133972
	Dec     42.449989
	AppMagn 14.401
	MassSol 0.811
	RadSol  0.747
	Teff    5642
}

Star	"KOI-6164/KIC 7835312"
{
	RA      19.73138633
	Dec     43.52969
	AppMagn 15.334
	MassSol 0.848
	RadSol  0.867
	Teff    5774
}

Star	"KOI-617/KIC 9846086"
{
	RA      19.8279114
	Dec     46.64426
	AppMagn 14.608
	MassSol 1.056
	RadSol  0.963
	Teff    5858
}

Star	"KOI-6172/KIC 8163784"
{
	RA      19.40446573
	Dec     44.071201
	AppMagn 14.458
	MassSol 0.848
	RadSol  0.776
	Teff    5505
}

Star	"KOI-6175/KIC 8197761"
{
	RA      20.06925047
	Dec     44.071098
	AppMagn 10.656
	MassSol 1.384
	RadSol  1.717
	Teff    7301
}

Star	"KOI-6176/KIC 8223568"
{
	RA      19.19903973
	Dec     44.147202
	AppMagn 11.538
	MassSol 1.354
	RadSol  1.31
	Teff    6725
}

Star	"KOI-6178/KIC 8355178"
{
	RA      19.1687846
	Dec     44.30801
	AppMagn 15.863
	MassSol 1.07
	RadSol  0.996
	Teff    6122
}

Star	"KOI-6179/KIC 8374077"
{
	RA      19.65710653
	Dec     44.322041
	AppMagn 15.735
	MassSol 1.117
	RadSol  1.012
	Teff    6063
}

Star	"KOI-6180/KIC 8494783"
{
	RA      19.4424886
	Dec     44.56422
	AppMagn 12.044
}

Star	"KOI-6182/KIC 8590149"
{
	RA      20.0601644
	Dec     44.61261
	AppMagn 15.099
	MassSol 0.761
	RadSol  0.821
	Teff    5243
}

Star	"KOI-6183/KIC 8590780"
{
	RA      20.07794393
	Dec     44.645962
	AppMagn 13.253
	MassSol 0.984
	RadSol  1.501
	Teff    6231
}

Star	"KOI-6188/KIC 8822421"
{
	RA      19.5498006
	Dec     45.056461
	AppMagn 15.517
	MassSol 0.822
	RadSol  0.759
	Teff    5423
}

Star	"KOI-6189/KIC 8957954"
{
	RA      19.57906087
	Dec     45.238609
	AppMagn 13.96
	MassSol 1.043
	RadSol  0.966
	Teff    6106
}

Star	"KOI-6191/KIC 9093086"
{
	RA      19.56021527
	Dec     45.493809
	AppMagn 14.752
	MassSol 1.087
	RadSol  1.031
	Teff    6258
}

Star	"KOI-6194/KIC 9145861"
{
	RA      19.1893616
	Dec     45.599751
	AppMagn 12.057
	MassSol 1.996
	RadSol  7.056
	Teff    4902
}

Star	"KOI-6195/KIC 9153823"
{
	RA      19.43233033
	Dec     45.54567
	AppMagn 15.356
	MassSol 0.553
	RadSol  0.559
	Teff    4569
}

Star	"KOI-6202/KIC 9389245"
{
	RA      18.94274293
	Dec     45.944641
	AppMagn 11.543
}

Star	"KOI-6209/KIC 9655711"
{
	RA      19.6296
	Dec     46.335972
	AppMagn 16.154
	MassSol 1.022
	RadSol  0.962
	Teff    5947
}

Star	"KOI-6210/KIC 9727765"
{
	RA      19.87103273
	Dec     46.436298
	AppMagn 13.173
}

Star	"KOI-6216/KIC 10198662"
{
	RA      19.18564047
	Dec     47.228043
	AppMagn 12.655
}

Star	"KOI-6217/KIC 10200627"
{
	RA      19.25303547
	Dec     47.203651
	AppMagn 15.268
	MassSol 0.55
	RadSol  0.543
	Teff    4822
}

Star	"KOI-6219/KIC 10228942"
{
	RA      19.9218262
	Dec     47.25774
	AppMagn 13.079
	MassSol 1.213
	RadSol  1.855
	Teff    6632
}

Star	"KOI-622/KIC 12417486"
{
	RA      19.725352
	Dec     51.26379
	AppMagn 14.932
	MassSol 0.766
	RadSol  0.768
	Teff    5307
}

Star	"KOI-6223/KIC 10385682"
{
	RA      18.8126424
	Dec     47.523762
	AppMagn 15.001
	MassSol 1.143
	RadSol  1.122
	Teff    6077
}

Star	"KOI-6224/KIC 10414727"
{
	RA      19.71212767
	Dec     47.591881
	AppMagn 12.962
}

Star	"KOI-6235/KIC 11147460"
{
	RA      19.74700113
	Dec     48.766811
	AppMagn 13.912
	MassSol 1.014
	RadSol  4.089
	Teff    5051
}

Star	"KOI-6238/KIC 11341164"
{
	RA      19.11526487
	Dec     49.154945
	AppMagn 12.366
}

Star	"KOI-6239/KIC 11462969"
{
	RA      19.70445553
	Dec     49.378029
	AppMagn 13.893
	MassSol 0.956
	RadSol  0.884
	Teff    5847
}

Star	"KOI-6242/KIC 11656928"
{
	RA      19.26918133
	Dec     49.712601
	AppMagn 12.914
}

Star	"KOI-6245/KIC 11775507"
{
	RA      19.83452147
	Dec     49.917702
	AppMagn 12.431
	MassSol 1.046
	RadSol  1.26
	Teff    6528
}

Star	"KOI-6246/KIC 11856178"
{
	RA      19.14433593
	Dec     50.113232
	AppMagn 11.767
	MassSol 1.041
	RadSol  0.964
	Teff    6122
}

Star	"KOI-6248/KIC 11975363"
{
	RA      19.82227987
	Dec     50.311138
	AppMagn 15.409
	MassSol 0.956
	RadSol  0.961
	Teff    5721
}

Star	"KOI-625/KIC 4449034"
{
	RA      19.10425213
	Dec     39.53447
	AppMagn 13.592
	MassSol 1.456
	RadSol  2.343
	Teff    6481
}

Star	"KOI-6251/KIC 12470041"
{
	RA      19.73432213
	Dec     51.34697
	AppMagn 13.415
	MassSol 1.98
	RadSol  3.226
	Teff    7517
}

Star	"KOI-635/KIC 5020319"
{
	RA      19.62490233
	Dec     40.19463
	AppMagn 13.034
	MassSol 1.132
	RadSol  1.03
	Teff    6108
}

Star	"KOI-641/KIC 5131180"
{
	RA      19.95329793
	Dec     40.235069
	AppMagn 13.583
	MassSol 0.584
	RadSol  0.594
	Teff    4137
}

Star	"KOI-650/KIC 5786676"
{
	RA      19.35974527
	Dec     41.040081
	AppMagn 13.594
	MassSol 0.746
	RadSol  0.787
	Teff    5098
}

Star	"KOI-682/KIC 7619236"
{
	RA      19.68
	Dec     43.26944445
	AppMagn 14.2
	MassSol 1.02
	RadSol  1.17
	Teff    5589
	FeH     0.34
}

Star	"KOI-683/KIC 7630229"
{
	RA      19.854954
	Dec     43.258381
	AppMagn 13.714
	MassSol 1.058
	RadSol  1.098
	Teff    5877
}

Star	"KOI-684/KIC 7730747"
{
	RA      18.75268553
	Dec     43.413342
	AppMagn 13.831
	MassSol 1.079
	RadSol  1.793
	Teff    5548
}

Star	"KOI-686/KIC 7906882"
{
	RA      19.78938393
	Dec     43.647121
	AppMagn 13.579
	MassSol 0.845
	RadSol  0.885
	Teff    5559
}

Star	"KOI-687/KIC 7976520"
{
	RA      19.8078084
	Dec     43.71143
	AppMagn 13.813
	MassSol 0.956
	RadSol  0.933
	Teff    5891
}

Star	"KOI-698/KIC 8891278"
{
	RA      19.59424233
	Dec     45.189793
	AppMagn 13.816
	MassSol 1.009
	RadSol  1.596
	Teff    6120
}

Star	"KOI-704/KIC 9266431"
{
	RA      18.95907793
	Dec     45.719711
	AppMagn 13.704
	MassSol 0.854
	RadSol  0.884
	Teff    5470
}

Star	"KOI-716/KIC 9846348"
{
	RA      19.83281047
	Dec     46.694519
	AppMagn 13.754
	MassSol 0.975
	RadSol  0.908
	Teff    6096
}

Star	"KOI-728/KIC 10221013"
{
	RA      19.77615353
	Dec     47.230331
	AppMagn 15.356
	MassSol 1.149
	RadSol  1.064
	Teff    6167
}

Star	"KOI-735/KIC 10287242"
{
	RA      19.77955727
	Dec     47.392151
	AppMagn 15.637
	MassSol 0.674
	RadSol  0.707
	Teff    5237
}

Star	"KOI-744/KIC 10480982"
{
	RA      19.72096967
	Dec     47.69035
	AppMagn 15.341
	MassSol 1.025
	RadSol  0.947
	Teff    6117
}

Star	"KOI-75/KIC 7199397"
{
	RA      19.4331482
	Dec     42.728481
	AppMagn 10.775
	MassSol 1.33
	RadSol  2.527
	Teff    5896
}

Star	"KOI-753/KIC 10811496"
{
	RA      19.80032147
	Dec     48.134129
	AppMagn 15.436
	MassSol 0.961
	RadSol  0.868
	Teff    5853
}

Star	"KOI-760/KIC 11138155"
{
	RA      19.47780353
	Dec     48.727589
	AppMagn 15.263
	MassSol 1.097
	RadSol  1.025
	Teff    6117
}

Star	"KOI-763/KIC 11242721"
{
	RA      19.4062602
	Dec     48.933842
	AppMagn 15.536
	MassSol 1.014
	RadSol  1.063
	Teff    6074
}

Star	"KOI-771/KIC 11465813"
{
	RA      19.78
	Dec     49.31638891
	AppMagn 15.2
	MassSol 0.95
	RadSol  0.94
	Teff    5520
	FeH     0.48
}

Star	"KOI-772/KIC 11493732"
{
	RA      18.91506147
	Dec     49.479519
	AppMagn 15.25
	MassSol 1.093
	RadSol  1.091
	Teff    6144
}

Star	"KOI-774/KIC 11656840"
{
	RA      19.26578773
	Dec     49.733742
	AppMagn 15.27
	MassSol 0.981
	RadSol  0.956
	Teff    6108
}

Star	"KOI-777/KIC 11818800"
{
	RA      19.62112427
	Dec     50.080231
	AppMagn 15.487
	MassSol 0.714
	RadSol  0.781
	Teff    5446
}

Star	"KOI-797/KIC 3115833"
{
	RA      19.4187968
	Dec     38.241669
	AppMagn 15.657
	MassSol 0.884
	RadSol  0.847
	Teff    5995
}

Star	"KOI-802/KIC 3453214"
{
	RA      19.5877462
	Dec     38.563568
	AppMagn 15.562
	MassSol 0.845
	RadSol  0.77
	Teff    5733
}

Star	"KOI-804/KIC 3641726"
{
	RA      19.35557453
	Dec     38.72823
	AppMagn 15.387
	MassSol 0.824
	RadSol  0.82
	Teff    5349
}

Star	"KOI-805/KIC 3734868"
{
	RA      19.17978313
	Dec     38.886452
	AppMagn 15.646
	MassSol 0.874
	RadSol  1.024
	Teff    5627
}

Star	"KOI-810/KIC 3940418"
{
	RA      19.1395996
	Dec     39.060719
	AppMagn 15.119
	MassSol 0.891
	RadSol  0.807
	Teff    5170
}

Star	"KOI-815/KIC 4544670"
{
	RA      19.0613342
	Dec     39.624828
	AppMagn 15.684
	MassSol 0.84
	RadSol  0.871
	Teff    5509
}

Star	"KOI-823/KIC 5115978"
{
	RA      19.73379927
	Dec     40.295429
	AppMagn 15.202
	MassSol 0.959
	RadSol  0.99
	Teff    6228
}

Star	"KOI-833/KIC 5376067"
{
	RA      19.700293
	Dec     40.505489
	AppMagn 15.446
	MassSol 0.953
	RadSol  0.869
	Teff    6046
}

Star	"KOI-838/KIC 5534814"
{
	RA      19.480957
	Dec     40.759762
	AppMagn 15.311
	MassSol 1.038
	RadSol  0.983
	Teff    6061
}

Star	"KOI-856/KIC 6526710"
{
	RA      19.54528607
	Dec     41.969238
	AppMagn 15.344
	MassSol 1.041
	RadSol  0.964
	Teff    6122
}

Star	"KOI-858/KIC 6599919"
{
	RA      19.32651773
	Dec     42.009151
	AppMagn 15.06
	MassSol 0.857
	RadSol  0.903
	Teff    5697
}

Star	"KOI-865/KIC 6862328"
{
	RA      19.43891807
	Dec     42.36816
	AppMagn 15.085
	MassSol 0.966
	RadSol  0.871
	Teff    5796
}

Star	"KOI-868/KIC 6867155"
{
	RA      19.53386433
	Dec     42.307201
	AppMagn 15.172
	MassSol 0.55
	RadSol  0.53
	Teff    3822
}

Star	"KOI-871/KIC 7031517"
{
	RA      19.40797933
	Dec     42.507069
	AppMagn 15.215
	MassSol 0.875
	RadSol  0.797
	Teff    5834
}

Star	"KOI-875/KIC 7135852"
{
	RA      19.77959593
	Dec     42.62611
	AppMagn 15.692
	MassSol 0.55
	RadSol  0.52
	Teff    3861
}

Star	"KOI-883/KIC 7380537"
{
	RA      19.77887167
	Dec     42.967869
	AppMagn 15.766
	MassSol 0.702
	RadSol  0.643
	Teff    4809
}

Star	"KOI-887/KIC 7458762"
{
	RA      19.71009927
	Dec     43.029831
	AppMagn 15.031
	MassSol 1.014
	RadSol  0.919
	Teff    5849
}

Star	"KOI-895/KIC 7767559"
{
	RA      19.76067913
	Dec     43.455391
	AppMagn 15.403
	MassSol 0.811
	RadSol  0.975
	Teff    5600
}

Star	"KOI-900/KIC 7938496"
{
	RA      18.79737547
	Dec     43.70311
	AppMagn 15.425
	MassSol 1.009
	RadSol  1.142
	Teff    5942
}

Star	"KOI-901/KIC 8013419"
{
	RA      19.01116533
	Dec     43.876339
	AppMagn 15.75
	MassSol 0.56
	RadSol  0.54
	Teff    3945
}

Star	"KOI-902/KIC 8018547"
{
	RA      19.19015907
	Dec     43.897991
	AppMagn 15.754
	MassSol 0.53
	RadSol  0.51
	Teff    3960
}

Star	"KOI-914/KIC 8552202"
{
	RA      19.2484436
	Dec     44.60751
	AppMagn 15.371
	MassSol 0.801
	RadSol  0.737
	Teff    5654
}

Star	"KOI-92/KIC 7941200"
{
	RA      18.89165447
	Dec     43.788219
	AppMagn 11.667
	MassSol 1.057
	RadSol  0.971
	Teff    5952
}

Star	"KOI-924/KIC 8951215"
{
	RA      19.4138692
	Dec     45.244389
	AppMagn 15.229
	MassSol 1.091
	RadSol  1.031
	Teff    6225
}

Star	"KOI-928/KIC 9140402"
{
	RA      18.983962
	Dec     45.599129
	AppMagn 15.251
	MassSol 0.917
	RadSol  0.834
	Teff    5575
}

Star	"KOI-945/KIC 9605514"
{
	RA      19.86343993
	Dec     46.264721
	AppMagn 15.083
	MassSol 1.084
	RadSol  1.031
	Teff    6297
}

Star	"KOI-969/KIC 4044005"
{
	RA      19.1744222
	Dec     39.127239
	AppMagn 12.336
	MassSol 0.998
	RadSol  1.132
	Teff    6224
}

Star	"KOI-972/KIC 11013201"
{
	RA      18.80002033
	Dec     48.542221
	AppMagn 9.275
	MassSol 2.018
	RadSol  4.24
	Teff    7221
}

Star	"KOI-974/KIC 9414417"
{
	RA      19.7201782
	Dec     45.988079
	AppMagn 9.582
	MassSol 1.27
	RadSol  1.851
	Teff    6253
}

Star	"KOI-976/KIC 3441784"
{
	RA      19.39629107
	Dec     38.538868
	AppMagn 9.729
	MassSol 1.594
	RadSol  1.658
	Teff    7201
}

Star	"KOI-977/KIC 11192141"
{
	RA      19.51464233
	Dec     48.852016
	AppMagn 10.523
	MassSol 0.931
	RadSol  15.76
	Teff    4283
}

Star	"KOI-984/KIC 1161345"
{
	RA      19.4032532
	Dec     36.839882
	AppMagn 11.631
	MassSol 0.992
	RadSol  0.871
	Teff    5505
}

Star	"KOI-989/KIC 10743597"
{
	RA      19.7588196
	Dec     48.045311
	AppMagn 15.488
	MassSol 0.956
	RadSol  0.874
	Teff    5619
}

Star	"KOI-99/KIC 8505215"
{
	RA      19.69562173
	Dec     44.53112
	AppMagn 12.96
	MassSol 0.709
	RadSol  0.736
	Teff    4965
}

Star	"KOI-994/KIC 1431122"
{
	RA      19.40949913
	Dec     37.061321
	AppMagn 14.613
	MassSol 0.915
	RadSol  0.919
	Teff    5518
}

Star	"Kepler-1/KOI-1/KIC 11446443/TrES-2"
{
	RA      19.12056513
	Dec     49.316407
	Dist    213
	AppMagn 11.411
	Class  "G0V"
	MassSol 0.98
	RadSol  1
	Teff    5850
	FeH    -0.15
	Age     5.1
}

Star	"Kepler-10/KOI-72/KIC 11904151"
{
	RA      19.04527778
	Dec     50.2413889
	Dist    173
	AppMagn 11.16
	Class  "G"
	MassSol 0.91
	RadSol  1.065
	Teff    5708
	FeH    -0.15
	Age     10.6
}

Star	"Kepler-100/KOI-41/KIC 6521045"
{
	RA      19.42572222
	Dec     41.99000003
	Dist    310.34
	AppMagn 11.197
	MassSol 1.109
	RadSol  1.5131
	Teff    5825
	FeH     0.02
	Age     6.5
}

Star	"Kepler-1000"
{
	RA      19.1123682
	Dec     47.098221
	Dist    925
	AppMagn 12.137 // not V mag
	MassSol 1.4
	RadSol  1.51
	Teff    6453
	FeH     0.35
}

Star	"Kepler-1001/KOI-1889/KIC 11074178"
{
	RA      19.08492473
	Dec     48.618706
	Dist    1009
	AppMagn 15.338
	MassSol 0.9
	RadSol  0.88
	Teff    5491
	FeH    -0.03
}

Star	"Kepler-1002/KOI-1890/KIC 7449136"
{
	RA      19.538633
	Dec     43.073715
	Dist    425
	AppMagn 11.704
	MassSol 1.22
	RadSol  1.57
	Teff    6144
	FeH     0.04
}

Star	"Kepler-1003/KOI-1893/KIC 8689793"
{
	RA      19.4680304
	Dec     44.876217
	Dist    873
	AppMagn 14.053
	MassSol 1.11
	RadSol  1.17
	Teff    6109
	FeH     0.01
}

Star	"Kepler-1004/KOI-1894/KIC 11673802"
{
	RA      19.82395327
	Dec     49.79755
	Dist    1080
	AppMagn 13.427
	MassSol 1.11
	RadSol  3.39
	Teff    4972
	FeH    -0.04
}

Star	"Kepler-1005/KOI-1898/KIC 7668663"
{
	RA      19.08573427
	Dec     43.320461
	Dist    515
	AppMagn 13.25
	MassSol 1
	RadSol  1.06
	Teff    5782
	FeH     0.02
}

Star	"Kepler-1006/KOI-1899/KIC 7047922"
{
	RA      19.7169418
	Dec     42.537476
	Dist    496
	AppMagn 14.563
	MassSol 0.78
	RadSol  0.74
	Teff    5328
	FeH    -0.4
}

Star	"Kepler-1007/KOI-1900/KIC 9353314"
{
	RA      19.72710347
	Dec     45.80912
	Dist    365
	AppMagn 14.744
	MassSol 0.73
	RadSol  0.7
	Teff    4587
	FeH     0.03
}

Star	"Kepler-1008/KOI-1904/KIC 8766650"
{
	RA      19.769835
	Dec     44.941933
	Dist    299
	AppMagn 13.395
	MassSol 0.81
	RadSol  0.78
	Teff    5066
	FeH    -0.01
}

Star	"Kepler-1009/KOI-1907/KIC 7094486"
{
	RA      18.85732867
	Dec     42.665764
	Dist    281
	AppMagn 15.278
	MassSol 0.59
	RadSol  0.57
	Teff    4027
	FeH    -0.12
}

Star	"Kepler-101/KOI-46/KIC 10905239"
{
	RA      18.88369954
	Dec     48.355228
	AppMagn 13.8
	Class  "G3IV"
	MassSol 1.12
	RadSol  1.67
	Teff    5570
	FeH     0.33
}

Star	"Kepler-1010/KOI-1910/KIC 8226050"
{
	RA      19.27950907
	Dec     44.149326
	Dist    610
	AppMagn 14.685
	MassSol 0.86
	RadSol  0.82
	Teff    5253
	FeH    -0.01
}

Star	"Kepler-1011/KOI-1911/KIC 9965957"
{
	RA      19.82676973
	Dec     46.824001
	Dist    860
	AppMagn 15.196
	MassSol 0.91
	RadSol  0.88
	Teff    5416
	FeH     0.08
}

Star	"Kepler-1012/KOI-1913/KIC 9704384"
{
	RA      19.286418
	Dec     46.457954
	Dist    420
	AppMagn 13.317
	MassSol 0.95
	RadSol  0.91
	Teff    5556
	FeH     0.05
}

Star	"Kepler-1013/KOI-1914/KIC 8426567"
{
	RA      19.34987147
	Dec     44.435242
	Dist    433
	AppMagn 14.417
	MassSol 0.81
	RadSol  0.76
	Teff    4954
	FeH     0.04
}

Star	"Kepler-1014/KOI-1920/KIC 8218379"
{
	RA      19.00813553
	Dec     44.110603
	Dist    672
	AppMagn 14.64
	MassSol 0.88
	RadSol  0.84
	Teff    5388
	FeH    -0.06
}

Star	"Kepler-1015/KOI-1921/KIC 7755636"
{
	RA      19.51715533
	Dec     43.42691
	Dist    932
	AppMagn 12.818
	MassSol 1.49
	RadSol  1.81
	Teff    6769
	FeH     0.06
}

Star	"Kepler-1016/KOI-1922/KIC 9411166"
{
	RA      19.64090967
	Dec     45.984623
	Dist    1239
	AppMagn 15.356
	MassSol 0.99
	RadSol  1
	Teff    5821
	FeH    -0.03
}

Star	"Kepler-1017/KOI-1923/KIC 4989057"
{
	RA      18.89795747
	Dec     40.132607
	Dist    554
	AppMagn 14.139
	MassSol 0.93
	RadSol  0.87
	Teff    5473
	FeH     0.04
}

Star	"Kepler-1018/KOI-1933/KIC 9072190"
{
	RA      18.9064464
	Dec     45.407879
	Dist    894
	AppMagn 15.041
	MassSol 0.91
	RadSol  0.88
	Teff    5518
	FeH    -0.05
}

Star	"Kepler-1019/KOI-1937/KIC 10190777"
{
	RA      18.91450173
	Dec     47.204449
	Dist    198
	AppMagn 13.59
	MassSol 0.7
	RadSol  0.67
	Teff    4433
	FeH     0.01
}

Star	"Kepler-102/KOI-82/KIC 10187017"
{
	RA      18.76551513
	Dec     47.208031
	AppMagn 11.492
	MassSol 0.81
	RadSol  0.76
	Teff    4809
	FeH     0.18
	Age     1.41
}

Star	"Kepler-1020/KOI-1938/KIC 9651234"
{
	RA      19.5115034
	Dec     46.377422
	Dist    446
	AppMagn 14.031
	MassSol 0.87
	RadSol  0.8
	Teff    5227
	FeH     0
}

Star	"Kepler-1021/KOI-1939/KIC 7045496"
{
	RA      19.680327
	Dec     42.559681
	Dist    837
	AppMagn 15.164
	MassSol 0.89
	RadSol  0.86
	Teff    5431
	FeH    -0.05
}

Star	"Kepler-1022/KOI-1940/KIC 10005788"
{
	RA      19.29013367
	Dec     46.973728
	Dist    455
	AppMagn 15.389
	MassSol 0.71
	RadSol  0.68
	Teff    4445
	FeH     0.06
}

Star	"Kepler-1023/KOI-1945/KIC 11656918"
{
	RA      19.26864947
	Dec     49.769707
	Dist    686
	AppMagn 14.52
	MassSol 0.93
	RadSol  0.89
	Teff    5494
	FeH     0.05
}

Star	"Kepler-1024/KOI-1950/KIC 3118797"
{
	RA      19.4633994
	Dec     38.251698
	Dist    1017
	AppMagn 15.983
	MassSol 0.81
	RadSol  0.78
	Teff    5143
	FeH    -0.1
}

Star	"Kepler-1025/KOI-1951/KIC 8081187"
{
	RA      18.96734673
	Dec     43.961666
	Dist    716
	AppMagn 13.573
	MassSol 1.09
	RadSol  1.13
	Teff    6089
	FeH    -0.03
}

Star	"Kepler-1026/KOI-1959/KIC 4813563"
{
	RA      18.90701753
	Dec     39.99798
	Dist    389
	AppMagn 14.254
	MassSol 0.79
	RadSol  0.75
	Teff    4948
	FeH    -0.02
}

Star	"Kepler-1027/KOI-1961/KIC 7269493"
{
	RA      19.17141233
	Dec     42.813923
	Dist    291
	AppMagn 12.852
	MassSol 0.91
	RadSol  0.82
	Teff    5436
	FeH    -0.06
}

Star	"Kepler-1028/KOI-1965/KIC 11657891"
{
	RA      19.30620647
	Dec     49.781158
	Dist    633
	AppMagn 14.325
	MassSol 0.9
	RadSol  0.87
	Teff    5522
	FeH    -0.09
}

Star	"Kepler-1029/KOI-1967/KIC 6205897"
{
	RA      19.47553173
	Dec     41.54754
	Dist    422
	AppMagn 14.31
	MassSol 0.82
	RadSol  0.77
	Teff    5030
	FeH     0.01
}

Star	"Kepler-103/KOI-108/KIC 4914423"
{
	RA      19.25730278
	Dec     40.06452779
	Dist    473.56
	AppMagn 12.287
	MassSol 1.099
	RadSol  1.455
	Teff    5845
	FeH     0.07
	Age     6.67
}

Star	"Kepler-1030/KOI-1971/KIC 9347009"
{
	RA      19.57879433
	Dec     45.817559
	Dist    795
	AppMagn 15.719
	MassSol 0.8
	RadSol  0.76
	Teff    4983
	FeH    -0.01
}

Star	"Kepler-1031/KOI-1972/KIC 11253711"
{
	RA      19.73931647
	Dec     48.955376
	Dist    741
	AppMagn 13.8
	MassSol 1.09
	RadSol  1.12
	Teff    6011
	FeH     0.03
}

Star	"Kepler-1032/KOI-1973/KIC 4917596"
{
	RA      19.3287248
	Dec     40.097751
	Dist    607
	AppMagn 15.753
	MassSol 0.77
	RadSol  0.71
	Teff    4647
	FeH     0.16
}

Star	"Kepler-1033/KOI-1975/KIC 8543100"
{
	RA      18.92300947
	Dec     44.609093
	Dist    1425
	AppMagn 15.986
	MassSol 0.94
	RadSol  0.92
	Teff    5547
	FeH     0.06
}

Star	"Kepler-1034/KOI-1976/KIC 2693736"
{
	RA      19.07435787
	Dec     37.966997
	Dist    706
	AppMagn 15.09
	MassSol 0.83
	RadSol  0.8
	Teff    5198
	FeH    -0.06
}

Star	"Kepler-1035/KOI-1979/KIC 7273277"
{
	RA      19.26948167
	Dec     42.882488
	Dist    408
	AppMagn 12.987
	MassSol 0.98
	RadSol  0.97
	Teff    5763
	FeH    -0.03
}

Star	"Kepler-1036/KOI-1980/KIC 11769890"
{
	RA      19.67877587
	Dec     49.945786
	Dist    507
	AppMagn 13.8
	MassSol 0.95
	RadSol  0.89
	Teff    5533
	FeH     0.04
}

Star	"Kepler-1037/KOI-1981/KIC 10153855"
{
	RA      19.7560686
	Dec     47.170856
	Dist    451
	AppMagn 14.229
	MassSol 0.82
	RadSol  0.78
	Teff    5105
	FeH    -0.03
}

Star	"Kepler-1038/KOI-1986/KIC 8257205"
{
	RA      19.93147893
	Dec     44.132378
	Dist    622
	AppMagn 14.839
	MassSol 0.87
	RadSol  0.83
	Teff    5335
	FeH    -0.04
}

Star	"Kepler-1039/KOI-1988/KIC 9044228"
{
	RA      19.8884394
	Dec     45.315514
	Dist    324
	AppMagn 14.145
	MassSol 0.79
	RadSol  0.74
	Teff    4870
	FeH     0.01
}

Star	"Kepler-104/KOI-111/KIC 6678383"
{
	RA      19.17364095
	Dec     42.166779
	AppMagn 12.596
	MassSol 0.81
	RadSol  1.35
	Teff    5711
	FeH    -0.777
}

Star	"Kepler-1040/KOI-1989/KIC 10779233"
{
	RA      18.87425227
	Dec     48.131393
	Dist    473
	AppMagn 13.328
	MassSol 0.98
	RadSol  0.96
	Teff    5694
	FeH     0.01
}

Star	"Kepler-1041/KOI-1990/KIC 11614617"
{
	RA      19.59211787
	Dec     49.683155
	Dist    979
	AppMagn 14.49
	MassSol 1.06
	RadSol  1.08
	Teff    5957
	FeH     0.01
}

Star	"Kepler-1042/KOI-1996/KIC 4736569"
{
	RA      19.24459553
	Dec     39.824006
	Dist    659
	AppMagn 15.629
	MassSol 0.75
	RadSol  0.72
	Teff    4815
	FeH    -0.1
}

Star	"Kepler-1043/KOI-1997/KIC 10384798"
{
	RA      18.7775322
	Dec     47.568584
	Dist    838
	AppMagn 14.777
	MassSol 0.92
	RadSol  0.9
	Teff    5629
	FeH    -0.11
}

Star	"Kepler-1044/KOI-1998/KIC 9834040"
{
	RA      19.54296373
	Dec     46.666237
	Dist    1507
	AppMagn 15.368
	MassSol 1.08
	RadSol  1.11
	Teff    5985
	FeH     0.04
}

Star	"Kepler-1045/KOI-2000/KIC 8802693"
{
	RA      18.94555307
	Dec     45.074104
	Dist    971
	AppMagn 15.593
	MassSol 0.86
	RadSol  0.82
	Teff    5301
	FeH    -0.03
}

Star	"Kepler-1046/KOI-2002/KIC 10024701"
{
	RA      19.78371727
	Dec     46.998291
	Dist    518
	AppMagn 13.286
	MassSol 1.04
	RadSol  1.04
	Teff    5913
	FeH     0
}

Star	"Kepler-1047/KOI-2004/KIC 12154526"
{
	RA      19.2430836
	Dec     50.788982
	Dist    566
	AppMagn 13.351
	MassSol 1.08
	RadSol  1.13
	Teff    5754
	FeH     0.29
}

Star	"Kepler-1048/KOI-2005/KIC 6665512"
{
	RA      18.79322347
	Dec     42.165787
	Dist    415
	AppMagn 14.832
	MassSol 0.75
	RadSol  0.7
	Teff    4651
	FeH     0.01
}

Star	"Kepler-1049/KOI-2006/KIC 10525027"
{
	RA      19.1564494
	Dec     47.772957
	Dist    129
	AppMagn 14.22
	MassSol 0.51
	RadSol  0.49
	Teff    3864
	FeH    -0.33
}

Star	"Kepler-105/KOI-115/KIC 9579641"
{
	RA      19.19248833
	Dec     46.276237
	AppMagn 12.791
	MassSol 0.96
	RadSol  0.89
	Teff    5827
	FeH    -0.19
}

Star	"Kepler-1050/KOI-2007/KIC 11069176"
{
	RA      18.8616664
	Dec     48.626392
	Dist    555
	AppMagn 13.127
	MassSol 1.09
	RadSol  1.13
	Teff    6010
	FeH     0.03
}

Star	"Kepler-1051/KOI-2010/KIC 5631630"
{
	RA      19.67720707
	Dec     40.898849
	Dist    1021
	AppMagn 13.2
	MassSol 1.43
	RadSol  1.73
	Teff    6675
	FeH     0.04
}

Star	"Kepler-1052/KOI-2012/KIC 9839821"
{
	RA      19.6895154
	Dec     46.602264
	Dist    1051
	AppMagn 14.876
	MassSol 1.03
	RadSol  1.03
	Teff    5888
	FeH     0
}

Star	"Kepler-1053/KOI-2013/KIC 4056616"
{
	RA      19.427909
	Dec     39.127415
	Dist    171
	AppMagn 13.156
	MassSol 0.74
	RadSol  0.69
	Teff    4529
	FeH     0.1
}

Star	"Kepler-1054/KOI-2016/KIC 8492026"
{
	RA      19.37341013
	Dec     44.556385
	Dist    1050
	AppMagn 14.136
	MassSol 1.22
	RadSol  1.34
	Teff    6209
	FeH     0.09
}

Star	"Kepler-1055/KOI-2017/KIC 8750043"
{
	RA      19.36578527
	Dec     44.932617
	Dist    422
	AppMagn 13.09
	MassSol 0.98
	RadSol  0.94
	Teff    5723
	FeH    -0.02
}

Star	"Kepler-1056/KOI-2018/KIC 9973109"
{
	RA      19.96839867
	Dec     46.899261
	Dist    971
	AppMagn 14.55
	MassSol 1.12
	RadSol  1.2
	Teff    6127
	FeH     0.02
}

Star	"Kepler-1057/KOI-2019/KIC 6226290"
{
	RA      19.83014347
	Dec     41.558124
	Dist    1462
	AppMagn 15.624
	MassSol 1.07
	RadSol  1.1
	Teff    5987
	FeH     0.01
}

Star	"Kepler-1058/KOI-2020/KIC 9349482"
{
	RA      19.63971887
	Dec     45.875034
	Dist    525
	AppMagn 15.498
	MassSol 0.73
	RadSol  0.69
	Teff    4644
	FeH    -0.06
}

Star	"Kepler-1059/KOI-2021/KIC 6356207"
{
	RA      19.28134727
	Dec     41.706486
	Dist    673
	AppMagn 15.484
	MassSol 0.75
	RadSol  0.72
	Teff    4906
	FeH    -0.15
}

Star	"Kepler-106/KOI-116/KIC 8395660"
{
	RA      20.05759722
	Dec     44.33755557
	AppMagn 12.882
	MassSol 1
	RadSol  1.04
	Teff    5858
	FeH    -0.12
	Age     4.83
}

Star	"Kepler-1060/KOI-2024/KIC 4544907"
{
	RA      19.06834593
	Dec     39.630929
	Dist    861
	AppMagn 14.632
	MassSol 0.99
	RadSol  0.99
	Teff    5797
	FeH    -0.03
}

Star	"Kepler-1061/KOI-2026/KIC 11923284"
{
	RA      19.74866693
	Dec     50.27523
	Dist    585
	AppMagn 13.263
	MassSol 1.09
	RadSol  1.07
	Teff    6067
	FeH    -0.03
}

Star	"Kepler-1062/KOI-2031/KIC 5940165"
{
	RA      18.9266268
	Dec     41.221607
	Dist    388
	AppMagn 14.796
	MassSol 0.75
	RadSol  0.7
	Teff    4597
	FeH     0.11
}

Star	"Kepler-1063/KOI-2032/KIC 2985767"
{
	RA      19.36845
	Dec     38.142973
	Dist    365
	AppMagn 12.261
	MassSol 1.09
	RadSol  1.14
	Teff    5945
	FeH     0.09
}

Star	"Kepler-1064/KOI-2033/KIC 2304320"
{
	RA      19.44944247
	Dec     37.688934
	Dist    374
	AppMagn 13.755
	MassSol 0.85
	RadSol  0.79
	Teff    5153
	FeH     0
}

Star	"Kepler-1065/KOI-2034/KIC 3657758"
{
	RA      19.63408387
	Dec     38.790501
	Dist    1078
	AppMagn 15.54
	MassSol 0.94
	RadSol  0.93
	Teff    5635
	FeH    -0.01
}

Star	"Kepler-1066/KOI-2035/KIC 9790806"
{
	RA      19.9244376
	Dec     46.502239
	Dist    399
	AppMagn 13.007
	MassSol 0.98
	RadSol  0.98
	Teff    5762
	FeH    -0.03
}

Star	"Kepler-1067/KOI-2039/KIC 8804845"
{
	RA      19.02582727
	Dec     45.049053
	Dist    689
	AppMagn 14.305
	MassSol 0.95
	RadSol  0.93
	Teff    5592
	FeH     0.03
}

Star	"Kepler-1068/KOI-2044/KIC 9656252"
{
	RA      19.64321093
	Dec     46.392365
	Dist    1532
	AppMagn 15.818
	MassSol 1.01
	RadSol  1.01
	Teff    5806
	FeH     0.03
}

Star	"Kepler-1069/KOI-2046/KIC 10663396"
{
	RA      19.39862193
	Dec     47.989002
	Dist    435
	AppMagn 13.153
	MassSol 0.99
	RadSol  0.98
	Teff    5722
	FeH     0.04
}

Star	"Kepler-107/KOI-117/KIC 10875245"
{
	RA      19.80188395
	Dec     48.208611
	AppMagn 12.487
	MassSol 1.142
	RadSol  1.41
	Teff    5851
	FeH    -0.092
}

Star	"Kepler-1070/KOI-2047/KIC 11457726"
{
	RA      19.54635827
	Dec     49.316502
	Dist    1040
	AppMagn 13.977
	MassSol 1.21
	RadSol  1.32
	Teff    6261
	FeH     0.03
}

Star	"Kepler-1071/KOI-2048/KIC 8956206"
{
	RA      19.53719973
	Dec     45.248817
	Dist    964
	AppMagn 15.801
	MassSol 0.86
	RadSol  0.81
	Teff    5215
	FeH     0.01
}

Star	"Kepler-1072/KOI-2049/KIC 9649706"
{
	RA      19.46962533
	Dec     46.329025
	Dist    976
	AppMagn 13.93
	MassSol 1.2
	RadSol  1.32
	Teff    6199
	FeH     0.07
}

Star	"Kepler-1073/KOI-2055/KIC 3128552"
{
	RA      19.61018
	Dec     38.233048
	Dist    837
	AppMagn 14.523
	MassSol 1
	RadSol  1
	Teff    5792
	FeH     0
}

Star	"Kepler-1074/KOI-2057/KIC 9573685"
{
	RA      18.965103
	Dec     46.252579
	Dist    245
	AppMagn 15.026
	MassSol 0.6
	RadSol  0.57
	Teff    4002
	FeH    -0.06
}

Star	"Kepler-1075/KOI-2058/KIC 10329835"
{
	RA      19.16674527
	Dec     47.469269
	Dist    265
	AppMagn 15.313
	MassSol 0.56
	RadSol  0.54
	Teff    3959
	FeH    -0.17
}

Star	"Kepler-1076/KOI-2059/KIC 12301181"
{
	RA      19.1726732
	Dec     51.060574
	Dist    199
	AppMagn 12.906
	MassSol 0.79
	RadSol  0.74
	Teff    4868
	FeH    -0.01
}

Star	"Kepler-1077/KOI-2062/KIC 6774880"
{
	RA      19.4022424
	Dec     42.26786
	Dist    1098
	AppMagn 14.998
	MassSol 1.02
	RadSol  1.02
	Teff    5816
	FeH     0.03
}

Star	"Kepler-1078/KOI-2063/KIC 7449541"
{
	RA      19.54670593
	Dec     43.050037
	Dist    1215
	AppMagn 15.62
	MassSol 0.94
	RadSol  0.92
	Teff    5612
	FeH    -0.01
}

Star	"Kepler-1079/KOI-2067/KIC 9304101"
{
	RA      19.9699666
	Dec     45.769753
	Dist    481
	AppMagn 12.584
	MassSol 1.08
	RadSol  1.36
	Teff    5758
	FeH     0.21
}

Star	"Kepler-108/KOI-119/KIC 9471974"
{
	RA      19.63727824
	Dec     46.062325
	AppMagn 12.654
	MassSol 0.87
	RadSol  2.19
	Teff    5854
	FeH    -0.026
}

Star	"Kepler-1080/KOI-2069/KIC 11360571"
{
	RA      19.76430147
	Dec     49.182915
	Dist    688
	AppMagn 13.754
	MassSol 1.1
	RadSol  1.16
	Teff    5956
	FeH     0.09
}

Star	"Kepler-1081/KOI-2071/KIC 6035124"
{
	RA      19.29630133
	Dec     41.317757
	Dist    425
	AppMagn 13.746
	MassSol 0.88
	RadSol  0.84
	Teff    5345
	FeH     0.01
}

Star	"Kepler-1082/KOI-2072/KIC 12058147"
{
	RA      19.29057813
	Dec     50.598484
	Dist    628
	AppMagn 13.38
	MassSol 1.03
	RadSol  1.14
	Teff    5923
	FeH    -0.06
}

Star	"Kepler-1083/KOI-2074/KIC 8866137"
{
	RA      18.8774634
	Dec     45.198315
	Dist    912
	AppMagn 15.824
	MassSol 0.81
	RadSol  0.77
	Teff    5049
	FeH    -0.02
}

Star	"Kepler-1084/KOI-2075/KIC 10857519"
{
	RA      19.3401314
	Dec     48.251137
	Dist    427
	AppMagn 12.217
	MassSol 1.12
	RadSol  1.28
	Teff    6113
	FeH    -0.02
}

Star	"Kepler-1085/KOI-2076/KIC 9517393"
{
	RA      19.16517653
	Dec     46.141186
	Dist    1518
	AppMagn 15.273
	MassSol 1.11
	RadSol  1.14
	Teff    6000
	FeH     0.08
}

Star	"Kepler-1086/KOI-2078/KIC 9351316"
{
	RA      19.68341033
	Dec     45.842972
	Dist    464
	AppMagn 15.561
	MassSol 0.7
	RadSol  0.66
	Teff    4350
	FeH     0.06
}

Star	"Kepler-1087/KOI-2079/KIC 9473078"
{
	RA      19.665255
	Dec     46.005653
	Dist    354
	AppMagn 12.953
	MassSol 0.96
	RadSol  0.94
	Teff    5589
	FeH     0.01
}

Star	"Kepler-1088/KOI-2087/KIC 6922710"
{
	RA      18.77076353
	Dec     42.450504
	Dist    300
	AppMagn 11.863
	MassSol 1.08
	RadSol  1.08
	Teff    5975
	FeH     0.05
}

Star	"Kepler-1089/KOI-2090/KIC 11348997"
{
	RA      19.4061828
	Dec     49.190059
	Dist    227
	AppMagn 15.535
	MassSol 0.52
	RadSol  0.49
	Teff    3753
	FeH    -0.09
}

Star	"Kepler-109/KOI-123/KIC 5094751"
{
	RA      19.35951389
	Dec     40.28486112
	Dist    464.73
	AppMagn 12.365
	MassSol 1.069
	RadSol  1.339
	Teff    5952
	FeH    -0.08
	Age     6.35
}

Star	"Kepler-1090/KOI-2094/KIC 8505920"
{
	RA      19.71085813
	Dec     44.525845
	Dist    702
	AppMagn 15.001
	MassSol 0.86
	RadSol  0.82
	Teff    5321
	FeH    -0.04
}

Star	"Kepler-1091/KOI-2095/KIC 7918992"
{
	RA      19.98569767
	Dec     43.670753
	Dist    915
	AppMagn 14.691
	MassSol 1.01
	RadSol  1.03
	Teff    5851
	FeH     0
}

Star	"Kepler-1092/KOI-2097/KIC 10158729"
{
	RA      19.84820933
	Dec     47.112659
	Dist    914
	AppMagn 14.649
	MassSol 0.99
	RadSol  1
	Teff    5862
	FeH    -0.09
}

Star	"Kepler-1093/KOI-2098/KIC 6105462"
{
	RA      18.9985342
	Dec     41.420166
	Dist    848
	AppMagn 13.838
	MassSol 1.13
	RadSol  1.2
	Teff    6166
	FeH    -0.01
}

Star	"Kepler-1094/KOI-2099/KIC 3120355"
{
	RA      19.4867502
	Dec     38.267041
	Dist    1371
	AppMagn 14.999
	MassSol 1.14
	RadSol  1.21
	Teff    6112
	FeH     0.06
}

Star	"Kepler-1095/KOI-2100/KIC 6047072"
{
	RA      19.5508298
	Dec     41.365114
	Dist    758
	AppMagn 14.553
	MassSol 0.94
	RadSol  0.92
	Teff    5658
	FeH    -0.09
}

Star	"Kepler-1096/KOI-2101/KIC 9411412"
{
	RA      19.647292
	Dec     45.969501
	Dist    344
	AppMagn 15.068
	MassSol 0.66
	RadSol  0.63
	Teff    4306
	FeH    -0.1
}

Star	"Kepler-1097/KOI-2102/KIC 7008211"
{
	RA      18.7729432
	Dec     42.596416
	Dist    738
	AppMagn 15.206
	MassSol 0.82
	RadSol  0.79
	Teff    5211
	FeH    -0.11
}

Star	"Kepler-1098/KOI-2103/KIC 7620413"
{
	RA      19.70018033
	Dec     43.232796
	Dist    876
	AppMagn 14.736
	MassSol 0.99
	RadSol  0.99
	Teff    5794
	FeH    -0.02
}

Star	"Kepler-1099/KOI-2104/KIC 10854546"
{
	RA      19.24999747
	Dec     48.277176
	Dist    1209
	AppMagn 15.141
	MassSol 1.01
	RadSol  1
	Teff    5837
	FeH    -0.02
}

Star	"Kepler-11/KOI-157/KIC 6541920"
{
	RA      19.80777778
	Dec     41.9091667
	Dist    613
	AppMagn 13.7
	Class  "G"
	MassSol 0.95
	RadSol  1.1
	Teff    5680
	FeH     0
	Age     8
}

Star	"Kepler-110/KOI-124/KIC 11086270"
{
	RA      19.52860921
	Dec     48.602814
	AppMagn 12.935
	MassSol 1.075
	RadSol  1.15
	Teff    5960
	FeH    -0.151
}

Star	"Kepler-1100/KOI-2105/KIC 8165946"
{
	RA      19.4580904
	Dec     44.087376
	Dist    940
	AppMagn 13.862
	MassSol 1.21
	RadSol  1.34
	Teff    6247
	FeH     0.05
}

Star	"Kepler-1101/KOI-2107/KIC 9225395"
{
	RA      19.6379586
	Dec     45.671257
	Dist    897
	AppMagn 15.111
	MassSol 0.94
	RadSol  0.91
	Teff    5614
	FeH    -0.04
}

Star	"Kepler-1102/KOI-2108/KIC 10709622"
{
	RA      18.75483767
	Dec     48.066505
	Dist    986
	AppMagn 14.955
	MassSol 0.96
	RadSol  0.94
	Teff    5724
	FeH    -0.08
}

Star	"Kepler-1103/KOI-2109/KIC 11499228"
{
	RA      19.158806
	Dec     49.452396
	Dist    921
	AppMagn 14.09
	MassSol 1.11
	RadSol  1.15
	Teff    6092
	FeH    -0.01
}

Star	"Kepler-1104/KOI-2110/KIC 11460462"
{
	RA      19.63123693
	Dec     49.331024
	Dist    516
	AppMagn 12.189
	MassSol 1.3
	RadSol  1.41
	Teff    6417
	FeH     0.13
}

Star	"Kepler-1105/KOI-2114/KIC 6921944"
{
	RA      18.74078473
	Dec     42.454931
	Dist    369
	AppMagn 15.18
	MassSol 0.71
	RadSol  0.68
	Teff    4299
	FeH     0.28
}

Star	"Kepler-1106/KOI-2116/KIC 8164012"
{
	RA      19.40968007
	Dec     44.062546
	Dist    1168
	AppMagn 14.69
	MassSol 1.11
	RadSol  1.17
	Teff    6104
	FeH     0
}

Star	"Kepler-1107/KOI-2119/KIC 4055304"
{
	RA      19.40332847
	Dec     39.141674
	Dist    457
	AppMagn 14.098
	MassSol 0.86
	RadSol  0.82
	Teff    5268
	FeH     0.01
}

Star	"Kepler-1108/KOI-2121/KIC 9415108"
{
	RA      19.73615593
	Dec     45.985146
	Dist    764
	AppMagn 14.979
	MassSol 0.88
	RadSol  0.84
	Teff    5406
	FeH    -0.09
}

Star	"Kepler-1109/KOI-2122/KIC 4262581"
{
	RA      19.44308293
	Dec     39.396624
	Dist    797
	AppMagn 14.288
	MassSol 1.05
	RadSol  1.06
	Teff    5893
	FeH     0.04
}

Star	"Kepler-111/KOI-139/KIC 8559644"
{
	RA      19.44354451
	Dec     44.688274
	AppMagn 13.492
	MassSol 1.098
	RadSol  1.16
	Teff    5952
	FeH     0.005
}

Star	"Kepler-1110/KOI-2126/KIC 3546060"
{
	RA      19.45386813
	Dec     38.622703
	Dist    726
	AppMagn 15.914
	MassSol 0.73
	RadSol  0.7
	Teff    4781
	FeH    -0.16
}

Star	"Kepler-1111/KOI-2129/KIC 9351920"
{
	RA      19.69755813
	Dec     45.812744
	Dist    1142
	AppMagn 15.159
	MassSol 1.1
	RadSol  1.15
	Teff    6077
	FeH     0.02
}

Star	"Kepler-1112/KOI-2131/KIC 10549023"
{
	RA      19.797921
	Dec     47.751488
	Dist    1734
	AppMagn 14.612
	MassSol 1.34
	RadSol  1.54
	Teff    6496
	FeH     0.04
}

Star	"Kepler-1113/KOI-2134/KIC 4254466"
{
	RA      19.29377967
	Dec     39.338834
	Dist    1127
	AppMagn 14.766
	MassSol 1.12
	RadSol  1.17
	Teff    5931
	FeH     0.18
}

Star	"Kepler-1114/KOI-2137/KIC 9364609"
{
	RA      19.94912887
	Dec     45.834698
	Dist    427
	AppMagn 13.747
	MassSol 0.87
	RadSol  0.83
	Teff    5374
	FeH    -0.08
}

Star	"Kepler-1115/KOI-2138/KIC 5022828"
{
	RA      19.66611813
	Dec     40.144409
	Dist    935
	AppMagn 11.98
	MassSol 1.6
	RadSol  1.73
	Teff    8480
	FeH    -0.51
}

Star	"Kepler-1116/KOI-2140/KIC 8233702"
{
	RA      19.46224367
	Dec     44.115505
	Dist    1017
	AppMagn 15.265
	MassSol 0.95
	RadSol  0.93
	Teff    5641
	FeH     0.01
}

Star	"Kepler-1117/KOI-2143/KIC 11403339"
{
	RA      19.47231867
	Dec     49.23748
	Dist    619
	AppMagn 14.102
	MassSol 0.95
	RadSol  0.93
	Teff    5612
	FeH     0.03
}

Star	"Kepler-1118/KOI-2144/KIC 8260902"
{
	RA      19.99771093
	Dec     44.160896
	Dist    818
	AppMagn 14.94
	MassSol 0.96
	RadSol  0.97
	Teff    5688
	FeH     0
}

Star	"Kepler-1119/KOI-2145/KIC 8381204"
{
	RA      19.8012754
	Dec     44.327522
	Dist    1288
	AppMagn 15.06
	MassSol 1.11
	RadSol  1.17
	Teff    6083
	FeH     0.03
}

Star	"Kepler-112/KOI-150/KIC 7626506"
{
	RA      19.79873454
	Dec     43.209751
	AppMagn 13.771
	MassSol 0.766
	RadSol  0.84
	Teff    5544
	FeH    -0.588
}

Star	"Kepler-1120/KOI-2146/KIC 6774537"
{
	RA      19.39429887
	Dec     42.286579
	Dist    635
	AppMagn 15.333
	MassSol 0.78
	RadSol  0.74
	Teff    4904
	FeH    -0.04
}

Star	"Kepler-1121/KOI-2149/KIC 10617017"
{
	RA      19.8524404
	Dec     47.886127
	Dist    529
	AppMagn 12.071
	MassSol 1.29
	RadSol  1.59
	Teff    6231
	FeH     0.12
}

Star	"Kepler-1122/KOI-2152/KIC 9641481"
{
	RA      19.21870233
	Dec     46.340904
	Dist    924
	AppMagn 15.06
	MassSol 0.92
	RadSol  0.89
	Teff    5544
	FeH    -0.03
}

Star	"Kepler-1123/KOI-2155/KIC 12116380"
{
	RA      19.63451113
	Dec     50.670399
	Dist    796
	AppMagn 14.822
	MassSol 0.93
	RadSol  0.9
	Teff    5500
	FeH     0.05
}

Star	"Kepler-1124/KOI-2156/KIC 2556650"
{
	RA      19.10628487
	Dec     37.891266
	Dist    177
	AppMagn 15.959
	MassSol 0.35
	RadSol  0.34
	Teff    3658
	FeH    -0.59
}

Star	"Kepler-1125/KOI-2160/KIC 5546761"
{
	RA      19.6987482
	Dec     40.73198
	Dist    910
	AppMagn 14.874
	MassSol 0.95
	RadSol  0.94
	Teff    5683
	FeH    -0.09
}

Star	"Kepler-1126/KOI-2162/KIC 9205938"
{
	RA      19.0461328
	Dec     45.689396
	Dist    668
	AppMagn 14.033
	MassSol 0.92
	RadSol  0.93
	Teff    5798
	FeH    -0.26
}

Star	"Kepler-1127/KOI-2164/KIC 7204981"
{
	RA      19.5478256
	Dec     42.720707
	Dist    996
	AppMagn 15.162
	MassSol 0.97
	RadSol  0.95
	Teff    5664
	FeH     0.04
}

Star	"Kepler-1128/KOI-2166/KIC 4370527"
{
	RA      19.53755587
	Dec     39.403444
	Dist    1163
	AppMagn 15.722
	MassSol 0.94
	RadSol  0.91
	Teff    5543
	FeH     0.04
}

Star	"Kepler-1129/KOI-2167/KIC 6041734"
{
	RA      19.44029967
	Dec     41.309361
	Dist    1258
	AppMagn 15.28
	MassSol 1
	RadSol  1
	Teff    5831
	FeH    -0.04
}

Star	"Kepler-113/KOI-153/KIC 12252424"
{
	RA      19.19985833
	Dec     50.94433336
	AppMagn 13.461
	MassSol 0.75
	RadSol  0.69
	Teff    4725
	FeH     0.05
	Age     6.89
}

Star	"Kepler-1130/KOI-2169/KIC 9006186"
{
	RA      19.01383233
	Dec     45.38435
	Dist    234
	AppMagn 12.404
	MassSol 0.9
	RadSol  0.81
	Teff    5403
	FeH    -0.06
}

Star	"Kepler-1131/KOI-2171/KIC 11410904"
{
	RA      19.7100996
	Dec     49.261295
	Dist    1109
	AppMagn 14.972
	MassSol 1.03
	RadSol  1.04
	Teff    5851
	FeH     0.05
}

Star	"Kepler-1132/KOI-2177/KIC 10965588"
{
	RA      19.0911642
	Dec     48.423935
	Dist    940
	AppMagn 15.481
	MassSol 0.87
	RadSol  0.83
	Teff    5298
	FeH    -0.01
}

Star	"Kepler-1133/KOI-2180/KIC 7286911"
{
	RA      19.55482693
	Dec     42.86747
	Dist    821
	AppMagn 14.816
	MassSol 0.93
	RadSol  0.9
	Teff    5569
	FeH    -0.02
}

Star	"Kepler-1134/KOI-2182/KIC 6962109"
{
	RA      19.70453213
	Dec     42.478287
	Dist    997
	AppMagn 15.842
	MassSol 0.84
	RadSol  0.81
	Teff    5281
	FeH    -0.1
}

Star	"Kepler-1135/KOI-2185/KIC 8611781"
{
	RA      19.06686453
	Dec     44.756592
	Dist    728
	AppMagn 14.353
	MassSol 0.96
	RadSol  0.94
	Teff    5656
	FeH     0.02
}

Star	"Kepler-1136/KOI-2193/KIC 8282651"
{
	RA      18.94051973
	Dec     44.245808
	Dist    545
	AppMagn 15.658
	MassSol 0.72
	RadSol  0.68
	Teff    4512
	FeH     0.03
}

Star	"Kepler-1137/KOI-2198/KIC 11075429"
{
	RA      19.14201813
	Dec     48.665375
	Dist    971
	AppMagn 12.768
	MassSol 1.5
	RadSol  1.84
	Teff    6807
	FeH     0.05
}

Star	"Kepler-1138/KOI-2200/KIC 10909127"
{
	RA      19.05994947
	Dec     48.307301
	Dist    1101
	AppMagn 15.353
	MassSol 0.95
	RadSol  0.92
	Teff    5582
	FeH     0.04
}

Star	"Kepler-1139/KOI-2202/KIC 4144576"
{
	RA      19.19637447
	Dec     39.230568
	Dist    555
	AppMagn 14.113
	MassSol 0.94
	RadSol  0.91
	Teff    5550
	FeH     0.05
}

Star	"Kepler-114/KOI-156/KIC 10925104"
{
	RA      19.60809527
	Dec     48.349525
	AppMagn 13.738
	MassSol 0.56
	RadSol  0.67
	Teff    4605
	FeH    -0.003
}

Star	"Kepler-1140/KOI-2205/KIC 9992325"
{
	RA      18.77959873
	Dec     46.946449
	Dist    657
	AppMagn 15.464
	MassSol 0.76
	RadSol  0.73
	Teff    4850
	FeH    -0.08
}

Star	"Kepler-1141/KOI-2208/KIC 10531955"
{
	RA      19.36957633
	Dec     47.72588
	Dist    365
	AppMagn 12.589
	MassSol 1.01
	RadSol  1.07
	Teff    5791
	FeH     0.04
}

Star	"Kepler-1142/KOI-2209/KIC 8168187"
{
	RA      19.51429567
	Dec     44.082336
	Dist    697
	AppMagn 14.31
	MassSol 0.97
	RadSol  0.96
	Teff    5685
	FeH     0.02
}

Star	"Kepler-1143/KOI-2210/KIC 4142847"
{
	RA      19.1535214
	Dec     39.289688
	Dist    632
	AppMagn 15.195
	MassSol 0.81
	RadSol  0.77
	Teff    5053
	FeH    -0.06
}

Star	"Kepler-1144/KOI-2212/KIC 10203349"
{
	RA      19.33621953
	Dec     47.257977
	Dist    1012
	AppMagn 14.941
	MassSol 0.98
	RadSol  0.96
	Teff    5753
	FeH    -0.03
}

Star	"Kepler-1145/KOI-2213/KIC 7457296"
{
	RA      19.68721073
	Dec     43.044415
	Dist    714
	AppMagn 15.443
	MassSol 0.79
	RadSol  0.75
	Teff    5064
	FeH    -0.13
}

Star	"Kepler-1146/KOI-2214/KIC 10328458"
{
	RA      19.11444173
	Dec     47.425633
	Dist    694
	AppMagn 15.848
	MassSol 0.74
	RadSol  0.7
	Teff    4692
	FeH    -0.06
}

Star	"Kepler-1147/KOI-2221/KIC 6287313"
{
	RA      19.50316913
	Dec     41.642956
	Dist    1476
	AppMagn 15.401
	MassSol 1.09
	RadSol  1.14
	Teff    5941
	FeH     0.11
}

Star	"Kepler-1148/KOI-2223/KIC 9278725"
{
	RA      19.3969038
	Dec     45.719536
	Dist    682
	AppMagn 15.277
	MassSol 0.81
	RadSol  0.77
	Teff    5054
	FeH    -0.02
}

Star	"Kepler-1149/KOI-2224/KIC 8892157"
{
	RA      19.61261733
	Dec     45.151577
	Dist    1023
	AppMagn 14.966
	MassSol 1.02
	RadSol  1.01
	Teff    5833
	FeH     0.02
}

Star	"Kepler-115/KOI-159/KIC 8972058"
{
	RA      19.84745687
	Dec     45.261925
	AppMagn 13.431
	MassSol 1
	RadSol  1.21
	Teff    5979
	FeH    -0.081
}

Star	"Kepler-1150/KOI-2225/KIC 11569782"
{
	RA      19.7816328
	Dec     49.532715
	Dist    373
	AppMagn 14.435
	MassSol 0.76
	RadSol  0.72
	Teff    4754
	FeH     0.01
}

Star	"Kepler-1151/KOI-2227/KIC 10600955"
{
	RA      19.4831862
	Dec     47.878452
	Dist    763
	AppMagn 14.872
	MassSol 0.88
	RadSol  0.85
	Teff    5470
	FeH    -0.11
}

Star	"Kepler-1152/KOI-2238/KIC 8229458"
{
	RA      19.36226887
	Dec     44.107651
	Dist    184
	AppMagn 14.634
	MassSol 0.55
	RadSol  0.53
	Teff    3964
	FeH    -0.25
}

Star	"Kepler-1153/KOI-2242/KIC 9336200"
{
	RA      19.27648113
	Dec     45.866181
	Dist    1185
	AppMagn 15.758
	MassSol 0.91
	RadSol  0.88
	Teff    5470
	FeH     0.03
}

Star	"Kepler-1154/KOI-2243/KIC 4770617"
{
	RA      19.83180847
	Dec     39.877247
	Dist    1531
	AppMagn 14.806
	MassSol 1.26
	RadSol  1.43
	Teff    6327
	FeH     0.04
}

Star	"Kepler-1155/KOI-2245/KIC 4454934"
{
	RA      19.2547058
	Dec     39.522827
	Dist    987
	AppMagn 14.74
	MassSol 1.03
	RadSol  1.03
	Teff    5842
	FeH     0.04
}

Star	"Kepler-1156/KOI-2246/KIC 9458343"
{
	RA      19.2616016
	Dec     46.057632
	Dist    759
	AppMagn 14.152
	MassSol 1
	RadSol  1
	Teff    5778
	FeH     0.02
}

Star	"Kepler-1157/KOI-2247/KIC 7802719"
{
	RA      18.8747366
	Dec     43.525642
	Dist    346
	AppMagn 14.374
	MassSol 0.76
	RadSol  0.71
	Teff    4679
	FeH     0.05
}

Star	"Kepler-1158/KOI-2252/KIC 6206214"
{
	RA      19.48226307
	Dec     41.575213
	Dist    1258
	AppMagn 13.628
	MassSol 1.41
	RadSol  1.95
	Teff    6203
	FeH     0.18
}

Star	"Kepler-1159/KOI-2253/KIC 8959839"
{
	RA      19.61775567
	Dec     45.204315
	Dist    1238
	AppMagn 14.574
	MassSol 1.19
	RadSol  1.28
	Teff    6217
	FeH     0.04
}

Star	"Kepler-116/KOI-171/KIC 7831264"
{
	RA      19.64947103
	Dec     43.536835
	AppMagn 13.717
	MassSol 1.16
	RadSol  1.45
	Teff    6142
	FeH    -0.064
}

Star	"Kepler-1160/KOI-2255/KIC 7672097"
{
	RA      19.19195893
	Dec     43.364075
	Dist    1293
	AppMagn 15.833
	MassSol 0.92
	RadSol  0.89
	Teff    5519
	FeH     0.01
}

Star	"Kepler-1161/KOI-2256/KIC 9112931"
{
	RA      19.93847353
	Dec     45.44064
	Dist    428
	AppMagn 15.813
	MassSol 0.59
	RadSol  0.57
	Teff    4253
	FeH    -0.35
}

Star	"Kepler-1162/KOI-2257/KIC 9071593"
{
	RA      18.886142
	Dec     45.434116
	Dist    989
	AppMagn 15.48
	MassSol 0.89
	RadSol  0.84
	Teff    5390
	FeH    -0.03
}

Star	"Kepler-1163/KOI-2260/KIC 11811193"
{
	RA      19.3490562
	Dec     50.030087
	Dist    487
	AppMagn 12.168
	MassSol 1.22
	RadSol  1.35
	Teff    6302
	FeH     0.02
}

Star	"Kepler-1164/KOI-2261/KIC 3734418"
{
	RA      19.16864227
	Dec     38.894513
	Dist    447
	AppMagn 14.11
	MassSol 0.85
	RadSol  0.79
	Teff    5183
	FeH    -0.03
}

Star	"Kepler-1165/KOI-2263/KIC 8613535"
{
	RA      19.1314178
	Dec     44.708302
	Dist    1081
	AppMagn 14.456
	MassSol 1.13
	RadSol  1.18
	Teff    6080
	FeH     0.05
}

Star	"Kepler-1166/KOI-2264/KIC 12256520"
{
	RA      19.35656793
	Dec     50.902855
	Dist    648
	AppMagn 14.477
	MassSol 0.9
	RadSol  0.86
	Teff    5446
	FeH    -0.02
}

Star	"Kepler-1167/KOI-2266/KIC 10489345"
{
	RA      19.8868476
	Dec     47.694023
	Dist    811
	AppMagn 15.942
	MassSol 0.79
	RadSol  0.75
	Teff    4971
	FeH    -0.05
}

Star	"Kepler-1168/KOI-2271/KIC 10329469"
{
	RA      19.1531796
	Dec     47.455437
	Dist    911
	AppMagn 15.624
	MassSol 0.87
	RadSol  0.82
	Teff    5157
	FeH     0.13
}

Star	"Kepler-1169/KOI-2273/KIC 9717943"
{
	RA      19.66077153
	Dec     46.491463
	Dist    538
	AppMagn 12.716
	MassSol 1.24
	RadSol  1.23
	Teff    6191
	FeH     0.26
}

Star	"Kepler-117/KOI-209/KIC 10723750"
{
	RA      19.25286865
	Dec     48.040234
	Dist    1430
	AppMagn 14.274
	Class  "F8V"
	MassSol 1.13
	RadSol  1.47
	Teff    6169
	FeH    -0.038
}

Star	"Kepler-1170/KOI-2274/KIC 7960980"
{
	RA      19.47790533
	Dec     43.779675
	Dist    911
	AppMagn 15.909
	MassSol 0.8
	RadSol  0.76
	Teff    5069
	FeH    -0.09
}

Star	"Kepler-1171/KOI-2276/KIC 3458028"
{
	RA      19.66392833
	Dec     38.591578
	Dist    615
	AppMagn 11.558
	MassSol 1.58
	RadSol  1.95
	Teff    7044
	FeH    -0.01
}

Star	"Kepler-1172/KOI-2280/KIC 2439243"
{
	RA      19.36496713
	Dec     37.766598
	Dist    1292
	AppMagn 15.889
	MassSol 0.92
	RadSol  0.89
	Teff    5558
	FeH    -0.04
}

Star	"Kepler-1173/KOI-2281/KIC 9221517"
{
	RA      19.542073
	Dec     45.663548
	Dist    402
	AppMagn 13.829
	MassSol 0.86
	RadSol  0.82
	Teff    5252
	FeH     0
}

Star	"Kepler-1174/KOI-2282/KIC 6751874"
{
	RA      18.788763
	Dec     42.298916
	Dist    829
	AppMagn 14.207
	MassSol 1.04
	RadSol  1.04
	Teff    5936
	FeH    -0.04
}

Star	"Kepler-1175/KOI-2285/KIC 9945370"
{
	RA      19.27618013
	Dec     46.812897
	Dist    1244
	AppMagn 15.939
	MassSol 0.9
	RadSol  0.86
	Teff    5453
	FeH    -0.04
}

Star	"Kepler-1176/KOI-2286/KIC 8973129"
{
	RA      19.8613152
	Dec     45.274162
	Dist    1023
	AppMagn 15.056
	MassSol 1.01
	RadSol  1.02
	Teff    5844
	FeH    -0.01
}

Star	"Kepler-1177/KOI-2296/KIC 11498128"
{
	RA      19.11142913
	Dec     49.406288
	Dist    829
	AppMagn 14.552
	MassSol 0.98
	RadSol  0.97
	Teff    5712
	FeH     0.02
}

Star	"Kepler-1178/KOI-2298/KIC 9334893"
{
	RA      19.23040413
	Dec     45.802124
	Dist    336
	AppMagn 13.831
	MassSol 0.8
	RadSol  0.75
	Teff    4990
	FeH    -0.05
}

Star	"Kepler-1179/KOI-2300/KIC 10583761"
{
	RA      18.93984267
	Dec     47.810638
	Dist    454
	AppMagn 14.077
	MassSol 0.84
	RadSol  0.81
	Teff    5212
	FeH    -0.03
}

Star	"Kepler-118/KOI-216/KIC 6152974"
{
	RA      19.94754435
	Dec     41.424824
	AppMagn 14.711
	MassSol 0.86
	RadSol  1.09
	Teff    5274
	FeH     0.18
}

Star	"Kepler-1180/KOI-2302/KIC 7542813"
{
	RA      19.725834
	Dec     43.156063
	Dist    1284
	AppMagn 14.989
	MassSol 1.09
	RadSol  1.14
	Teff    6077
	FeH     0
}

Star	"Kepler-1181/KOI-2303/KIC 4458082"
{
	RA      19.3164876
	Dec     39.523468
	Dist    867
	AppMagn 13.827
	MassSol 1.17
	RadSol  1.3
	Teff    6176
	FeH     0.03
}

Star	"Kepler-1182/KOI-2304/KIC 8042453"
{
	RA      19.75386327
	Dec     43.82135
	Dist    1258
	AppMagn 15.356
	MassSol 1.04
	RadSol  1.05
	Teff    5924
	FeH     0.01
}

Star	"Kepler-1183/KOI-2308/KIC 3749978"
{
	RA      19.48216167
	Dec     38.892222
	Dist    1378
	AppMagn 15.778
	MassSol 1
	RadSol  0.99
	Teff    5765
	FeH     0.04
}

Star	"Kepler-1184/KOI-2309/KIC 10010440"
{
	RA      19.41880367
	Dec     46.965996
	Dist    1193
	AppMagn 14.953
	MassSol 1.05
	RadSol  1.07
	Teff    5983
	FeH    -0.04
}

Star	"Kepler-1185/KOI-2311/KIC 4247991"
{
	RA      19.1494116
	Dec     39.332757
	Dist    296
	AppMagn 12.57
	MassSol 0.96
	RadSol  0.87
	Teff    5622
	FeH    -0.04
}

Star	"Kepler-1186/KOI-2313/KIC 10132832"
{
	RA      19.23197607
	Dec     47.101768
	Dist    1112
	AppMagn 15.306
	MassSol 0.95
	RadSol  0.93
	Teff    5635
	FeH     0
}

Star	"Kepler-1187/KOI-2314/KIC 3219995"
{
	RA      19.12613367
	Dec     38.318556
	Dist    1029
	AppMagn 14.562
	MassSol 1.06
	RadSol  1.09
	Teff    5975
	FeH    -0.01
}

Star	"Kepler-1188/KOI-2316/KIC 7504778"
{
	RA      18.8735892
	Dec     43.148045
	Dist    1202
	AppMagn 15.004
	MassSol 1.04
	RadSol  1.06
	Teff    5913
	FeH     0
}

Star	"Kepler-1189/KOI-2317/KIC 10684670"
{
	RA      19.89508953
	Dec     47.946785
	Dist    883
	AppMagn 14.285
	MassSol 1.11
	RadSol  1.16
	Teff    6012
	FeH     0.08
}

Star	"Kepler-119/KOI-220/KIC 7132798"
{
	RA      19.72976074
	Dec     42.658924
	AppMagn 14.236
	MassSol 0.914
	RadSol  0.84
	Teff    5595
	FeH    -0.083
}

Star	"Kepler-1190/KOI-2318/KIC 11495458"
{
	RA      18.99997473
	Dec     49.479977
	Dist    384
	AppMagn 14.471
	MassSol 0.76
	RadSol  0.72
	Teff    4730
	FeH    -0.02
}

Star	"Kepler-1191/KOI-2327/KIC 10730703"
{
	RA      19.44385173
	Dec     48.009315
	Dist    876
	AppMagn 15.378
	MassSol 0.85
	RadSol  0.81
	Teff    5308
	FeH    -0.08
}

Star	"Kepler-1192/KOI-2328/KIC 8007644"
{
	RA      18.80937107
	Dec     43.89658
	Dist    1108
	AppMagn 15.684
	MassSol 0.86
	RadSol  0.83
	Teff    5438
	FeH    -0.16
}

Star	"Kepler-1193/KOI-2331/KIC 12401863"
{
	RA      19.2096506
	Dec     51.275627
	Dist    695
	AppMagn 13.467
	MassSol 1.08
	RadSol  1.21
	Teff    5908
	FeH     0.12
}

Star	"Kepler-1194/KOI-2335/KIC 2990873"
{
	RA      19.44663587
	Dec     38.145265
	Dist    616
	AppMagn 14.129
	MassSol 0.94
	RadSol  0.92
	Teff    5590
	FeH     0
}

Star	"Kepler-1195/KOI-2337/KIC 5599774"
{
	RA      18.95673913
	Dec     40.852979
	Dist    812
	AppMagn 15.888
	MassSol 0.74
	RadSol  0.71
	Teff    4965
	FeH    -0.25
}

Star	"Kepler-1196/KOI-2338/KIC 8099138"
{
	RA      19.49130407
	Dec     43.910809
	Dist    946
	AppMagn 14.862
	MassSol 0.98
	RadSol  0.97
	Teff    5756
	FeH     0
}

Star	"Kepler-1197/KOI-2339/KIC 7033233"
{
	RA      19.44461813
	Dec     42.59071
	Dist    505
	AppMagn 15.13
	MassSol 0.78
	RadSol  0.72
	Teff    4708
	FeH     0.06
}

Star	"Kepler-1198/KOI-2340/KIC 8681734"
{
	RA      19.25560053
	Dec     44.838249
	Dist    777
	AppMagn 14.776
	MassSol 0.93
	RadSol  0.9
	Teff    5517
	FeH     0.03
}

Star	"Kepler-1199/KOI-2342/KIC 10212441"
{
	RA      19.5817248
	Dec     47.247044
	Dist    540
	AppMagn 13.037
	MassSol 0.94
	RadSol  1.17
	Teff    5889
	FeH    -0.27
}

Star	"Kepler-12/KOI-20/KIC 11804465"
{
	RA      19.08289593
	Dec     50.040382
	Dist    600
	AppMagn 13.8
	Class  "G0"
	MassSol 1.17
	RadSol  1.48
	Teff    5947
	FeH     0.07
	Age     4
}

Star	"Kepler-120/KOI-222/KIC 4249725"
{
	RA      19.19277547
	Dec     39.339123
	AppMagn 14.735
	MassSol 0.59
	RadSol  0.53
	Teff    4096
	FeH    -0.449
}

Star	"Kepler-1200/KOI-2344/KIC 8247771"
{
	RA      19.7735634
	Dec     44.129257
	Dist    579
	AppMagn 15.793
	MassSol 0.74
	RadSol  0.7
	Teff    4612
	FeH     0.04
}

Star	"Kepler-1201/KOI-2345/KIC 5629538"
{
	RA      19.64098847
	Dec     40.833172
	Dist    1202
	AppMagn 14.724
	MassSol 1.15
	RadSol  1.24
	Teff    6177
	FeH     0.03
}

Star	"Kepler-1202/KOI-2346/KIC 8561231"
{
	RA      19.4860408
	Dec     44.653255
	Dist    1393
	AppMagn 15.658
	MassSol 1.03
	RadSol  1.04
	Teff    5834
	FeH     0.06
}

Star	"Kepler-1203/KOI-2347/KIC 8235924"
{
	RA      19.5182256
	Dec     44.178127
	Dist    269
	AppMagn 14.934
	MassSol 0.64
	RadSol  0.61
	Teff    4105
	FeH     0.01
}

Star	"Kepler-1204/KOI-2348/KIC 6941084"
{
	RA      19.29609887
	Dec     42.498135
	Dist    1282
	AppMagn 15.301
	MassSol 1.03
	RadSol  1.03
	Teff    5825
	FeH     0.06
}

Star	"Kepler-1205/KOI-2350/KIC 6200235"
{
	RA      19.3519806
	Dec     41.515049
	Dist    766
	AppMagn 15.143
	MassSol 0.84
	RadSol  0.81
	Teff    5226
	FeH    -0.04
}

Star	"Kepler-1206/KOI-2355/KIC 11670125"
{
	RA      19.72922713
	Dec     49.791145
	Dist    807
	AppMagn 15.975
	MassSol 0.8
	RadSol  0.75
	Teff    4877
	FeH     0.07
}

Star	"Kepler-1207/KOI-2356/KIC 11461844"
{
	RA      19.67094953
	Dec     49.358994
	Dist    946
	AppMagn 14.5
	MassSol 1.06
	RadSol  1.06
	Teff    5909
	FeH     0.05
}

Star	"Kepler-1208/KOI-2362/KIC 8495415"
{
	RA      19.45875087
	Dec     44.555729
	Dist    877
	AppMagn 15.938
	MassSol 0.8
	RadSol  0.76
	Teff    5001
	FeH    -0.03
}

Star	"Kepler-1209/KOI-2366/KIC 11342416"
{
	RA      19.17232607
	Dec     49.154793
	Dist    558
	AppMagn 12.476
	MassSol 1.23
	RadSol  1.38
	Teff    6210
	FeH     0.12
}

Star	"Kepler-121/KOI-223/KIC 4545187"
{
	RA      19.07747192
	Dec     39.677994
	AppMagn 14.708
	MassSol 0.774
	RadSol  0.7
	Teff    5311
	FeH    -0.38
}

Star	"Kepler-1210/KOI-2368/KIC 10863608"
{
	RA      19.522143
	Dec     48.219357
	Dist    1155
	AppMagn 15.553
	MassSol 0.94
	RadSol  0.92
	Teff    5568
	FeH     0.04
}

Star	"Kepler-1211/KOI-2369/KIC 5602588"
{
	RA      19.04805253
	Dec     40.856961
	Dist    1486
	AppMagn 15.832
	MassSol 0.96
	RadSol  0.94
	Teff    5705
	FeH    -0.08
}

Star	"Kepler-1212/KOI-2371/KIC 11824786"
{
	RA      19.7902288
	Dec     50.037354
	Dist    1304
	AppMagn 15.012
	MassSol 1.1
	RadSol  1.15
	Teff    6051
	FeH     0.03
}

Star	"Kepler-1213/KOI-2372/KIC 12254909"
{
	RA      19.2990548
	Dec     50.944164
	Dist    685
	AppMagn 13.386
	MassSol 1.14
	RadSol  1.21
	Teff    6050
	FeH     0.13
}

Star	"Kepler-1214/KOI-2376/KIC 11701407"
{
	RA      19.0095092
	Dec     49.800667
	Dist    757
	AppMagn 15.279
	MassSol 0.85
	RadSol  0.8
	Teff    5130
	FeH     0.05
}

Star	"Kepler-1215/KOI-2378/KIC 10813132"
{
	RA      19.83090813
	Dec     48.181416
	Dist    701
	AppMagn 14.431
	MassSol 0.95
	RadSol  0.93
	Teff    5616
	FeH     0.01
}

Star	"Kepler-1216/KOI-2383/KIC 9395024"
{
	RA      19.16035473
	Dec     45.918007
	Dist    1124
	AppMagn 15.133
	MassSol 0.99
	RadSol  0.98
	Teff    5743
	FeH     0.03
}

Star	"Kepler-1217/KOI-2387/KIC 12254378"
{
	RA      19.27911173
	Dec     50.937557
	Dist    1363
	AppMagn 15.298
	MassSol 1.06
	RadSol  1.08
	Teff    5905
	FeH     0.07
}

Star	"Kepler-1218/KOI-2389/KIC 8494617"
{
	RA      19.4385988
	Dec     44.531715
	Dist    667
	AppMagn 13.578
	MassSol 1.06
	RadSol  1.1
	Teff    5986
	FeH    -0.02
}

Star	"Kepler-1219/KOI-2390/KIC 10289119"
{
	RA      19.81438727
	Dec     47.378515
	Dist    622
	AppMagn 12.249
	MassSol 1.25
	RadSol  1.94
	Teff    5944
	FeH     0.05
}

Star	"Kepler-122/KOI-232/KIC 4833421"
{
	RA      19.4074585
	Dec     39.949104
	AppMagn 14.247
	MassSol 0.99
	RadSol  1.22
	Teff    6050
	FeH    -0.202
}

Star	"Kepler-1220/KOI-2392/KIC 7382313"
{
	RA      19.80469127
	Dec     42.977741
	Dist    958
	AppMagn 14.985
	MassSol 1
	RadSol  0.99
	Teff    5842
	FeH    -0.04
}

Star	"Kepler-1221/KOI-2397/KIC 9269042"
{
	RA      19.05482327
	Dec     45.711891
	Dist    909
	AppMagn 15.563
	MassSol 0.87
	RadSol  0.82
	Teff    5194
	FeH     0.09
}

Star	"Kepler-1222/KOI-2399/KIC 11461433"
{
	RA      19.65931033
	Dec     49.379768
	Dist    455
	AppMagn 14.1
	MassSol 0.84
	RadSol  0.8
	Teff    5239
	FeH    -0.04
}

Star	"Kepler-1223/KOI-2402/KIC 8481129"
{
	RA      19.01971667
	Dec     44.552753
	Dist    455
	AppMagn 14.61
	MassSol 0.8
	RadSol  0.75
	Teff    4870
	FeH     0.04
}

Star	"Kepler-1224/KOI-2403/KIC 2142522"
{
	RA      19.1083842
	Dec     37.537304
	Dist    578
	AppMagn 12.867
	MassSol 1.18
	RadSol  1.22
	Teff    6155
	FeH     0.14
}

Star	"Kepler-1225/KOI-2406/KIC 5007345"
{
	RA      19.37555273
	Dec     40.136994
	Dist    1241
	AppMagn 14.689
	MassSol 1.13
	RadSol  1.19
	Teff    6140
	FeH     0.01
}

Star	"Kepler-1226/KOI-2407/KIC 12120484"
{
	RA      19.7584606
	Dec     50.621468
	Dist    779
	AppMagn 14.15
	MassSol 1.02
	RadSol  1.02
	Teff    5923
	FeH    -0.08
}

Star	"Kepler-1227/KOI-2408/KIC 6429812"
{
	RA      19.13775853
	Dec     41.874908
	Dist    667
	AppMagn 14.183
	MassSol 0.97
	RadSol  0.95
	Teff    5747
	FeH    -0.04
}

Star	"Kepler-1228/KOI-2409/KIC 10024051"
{
	RA      19.77020553
	Dec     46.96629
	Dist    547
	AppMagn 14.859
	MassSol 0.78
	RadSol  0.74
	Teff    5063
	FeH    -0.18
}

Star	"Kepler-1229/KOI-2418/KIC 10027247"
{
	RA      19.83244607
	Dec     46.996716
	Dist    236
	AppMagn 15.474
	MassSol 0.54
	RadSol  0.51
	Teff    3784
	FeH    -0.06
}

Star	"Kepler-123/KOI-238/KIC 7219825"
{
	RA      19.79990845
	Dec     42.781956
	AppMagn 14.061
	MassSol 1.03
	RadSol  1.26
	Teff    6089
	FeH    -0.199
}

Star	"Kepler-1230/KOI-2419/KIC 6343170"
{
	RA      18.8843
	Dec     41.711449
	Dist    1433
	AppMagn 15.309
	MassSol 1.06
	RadSol  1.08
	Teff    5961
	FeH     0.01
}

Star	"Kepler-1231/KOI-2420/KIC 7107802"
{
	RA      19.2392238
	Dec     42.605659
	Dist    948
	AppMagn 14.746
	MassSol 1.01
	RadSol  1
	Teff    5778
	FeH     0.06
}

Star	"Kepler-1232/KOI-2422/KIC 11360805"
{
	RA      19.77000287
	Dec     49.102322
	Dist    740
	AppMagn 14.803
	MassSol 0.92
	RadSol  0.89
	Teff    5471
	FeH     0.06
}

Star	"Kepler-1233/KOI-2423/KIC 9845898"
{
	RA      19.82500673
	Dec     46.662216
	Dist    1281
	AppMagn 14.689
	MassSol 1.16
	RadSol  1.25
	Teff    6198
	FeH     0.02
}

Star	"Kepler-1234/KOI-2424/KIC 12453581"
{
	RA      19.168135
	Dec     51.37586
	Dist    866
	AppMagn 15.912
	MassSol 0.8
	RadSol  0.76
	Teff    4967
	FeH     0.01
}

Star	"Kepler-1235/KOI-2426/KIC 8081899"
{
	RA      18.99353433
	Dec     43.95396
	Dist    533
	AppMagn 13.889
	MassSol 0.93
	RadSol  0.9
	Teff    5541
	FeH     0.01
}

Star	"Kepler-1236/KOI-2432/KIC 7047363"
{
	RA      19.70831373
	Dec     42.545898
	Dist    1078
	AppMagn 15.956
	MassSol 0.86
	RadSol  0.82
	Teff    5337
	FeH    -0.09
}

Star	"Kepler-1237/KOI-2436/KIC 8570333"
{
	RA      19.70861773
	Dec     44.69062
	Dist    1121
	AppMagn 15.758
	MassSol 0.94
	RadSol  0.9
	Teff    5472
	FeH     0.12
}

Star	"Kepler-1238/KOI-2437/KIC 5036705"
{
	RA      19.86038633
	Dec     40.162858
	Dist    1533
	AppMagn 14.725
	MassSol 1.3
	RadSol  1.48
	Teff    6386
	FeH     0.05
}

Star	"Kepler-1239/KOI-2439/KIC 6867555"
{
	RA      19.5418254
	Dec     42.320103
	Dist    2511
	AppMagn 15.438
	MassSol 1.4
	RadSol  1.57
	Teff    6564
	FeH     0.22
}

Star	"Kepler-124/KOI-241/KIC 11288051"
{
	RA      19.11685384
	Dec     49.064911
	AppMagn 14.139
	MassSol 0.724
	RadSol  0.64
	Teff    4984
	FeH    -0.535
}

Star	"Kepler-1240/KOI-2440/KIC 5339567"
{
	RA      18.86664767
	Dec     40.55745
	Dist    614
	AppMagn 13.987
	MassSol 0.98
	RadSol  0.96
	Teff    5682
	FeH     0.04
}

Star	"Kepler-1241/KOI-2444/KIC 3354846"
{
	RA      19.63841653
	Dec     38.456974
	Dist    936
	AppMagn 15.714
	MassSol 0.84
	RadSol  0.8
	Teff    5261
	FeH    -0.09
}

Star	"Kepler-1242/KOI-2448/KIC 5857540"
{
	RA      18.97374733
	Dec     41.196384
	Dist    682
	AppMagn 15.462
	MassSol 0.77
	RadSol  0.74
	Teff    4895
	FeH    -0.05
}

Star	"Kepler-1243/KOI-2450/KIC 7289317"
{
	RA      19.6006308
	Dec     42.880772
	Dist    877
	AppMagn 14.834
	MassSol 0.96
	RadSol  0.94
	Teff    5667
	FeH     0.01
}

Star	"Kepler-1244/KOI-2457/KIC 9753154"
{
	RA      18.82008107
	Dec     46.516201
	Dist    764
	AppMagn 12.402
	MassSol 1.46
	RadSol  1.77
	Teff    6680
	FeH     0.05
}

Star	"Kepler-1245/KOI-2458/KIC 7604328"
{
	RA      19.38295513
	Dec     43.260777
	Dist    861
	AppMagn 15.404
	MassSol 0.86
	RadSol  0.83
	Teff    5306
	FeH    -0.01
}

Star	"Kepler-1246/KOI-2460/KIC 11236244"
{
	RA      19.17716013
	Dec     48.982166
	Dist    435
	AppMagn 15.006
	MassSol 0.73
	RadSol  0.69
	Teff    4611
	FeH    -0.03
}

Star	"Kepler-1247/KOI-2461/KIC 9837685"
{
	RA      19.6355702
	Dec     46.618271
	Dist    1094
	AppMagn 15.935
	MassSol 0.86
	RadSol  0.82
	Teff    5303
	FeH    -0.05
}

Star	"Kepler-1248/KOI-2463/KIC 12454461"
{
	RA      19.2039546
	Dec     51.354454
	Dist    540
	AppMagn 12.77
	MassSol 1.21
	RadSol  1.21
	Teff    6149
	FeH     0.24
}

Star	"Kepler-1249/KOI-2468/KIC 8380709"
{
	RA      19.7929904
	Dec     44.37178
	Dist    1674
	AppMagn 15.373
	MassSol 1.19
	RadSol  1.28
	Teff    6202
	FeH     0.06
}

Star	"Kepler-125/KOI-251/KIC 10489206"
{
	RA      19.88387451
	Dec     47.604946
	AppMagn 14.752
	MassSol 0.55
	RadSol  0.51
	Teff    3810
	FeH     0.126
}

Star	"Kepler-1250/KOI-2472/KIC 9395719"
{
	RA      19.18625747
	Dec     45.98024
	Dist    1371
	AppMagn 15.618
	MassSol 0.99
	RadSol  0.98
	Teff    5717
	FeH     0.04
}

Star	"Kepler-1251/KOI-2482/KIC 11403389"
{
	RA      19.47434353
	Dec     49.256428
	Dist    863
	AppMagn 14.976
	MassSol 0.92
	RadSol  0.89
	Teff    5545
	FeH    -0.04
}

Star	"Kepler-1252/KOI-2483/KIC 9851662"
{
	RA      19.9300212
	Dec     46.692799
	Dist    828
	AppMagn 14.503
	MassSol 1.06
	RadSol  1.09
	Teff    5949
	FeH     0.03
}

Star	"Kepler-1253/KOI-2484/KIC 10453588"
{
	RA      18.92567433
	Dec     47.637222
	Dist    390
	AppMagn 12.464
	MassSol 0.97
	RadSol  1.1
	Teff    5850
	FeH    -0.14
}

Star	"Kepler-1254/KOI-2485/KIC 11125613"
{
	RA      19.01155507
	Dec     48.770042
	Dist    676
	AppMagn 15.311
	MassSol 0.78
	RadSol  0.75
	Teff    4985
	FeH    -0.1
}

Star	"Kepler-1255/KOI-2487/KIC 7212184"
{
	RA      19.68261833
	Dec     42.726479
	Dist    1344
	AppMagn 15.251
	MassSol 1.08
	RadSol  1.12
	Teff    6018
	FeH     0.02
}

Star	"Kepler-1256/KOI-2488/KIC 8559152"
{
	RA      19.43162027
	Dec     44.683514
	Dist    862
	AppMagn 13.539
	MassSol 1.17
	RadSol  1.36
	Teff    6129
	FeH     0.05
}

Star	"Kepler-1257/KOI-2491/KIC 9229657"
{
	RA      19.7383784
	Dec     45.627056
	Dist    1081
	AppMagn 15.553
	MassSol 0.9
	RadSol  0.87
	Teff    5502
	FeH    -0.09
}

Star	"Kepler-1258/KOI-2492/KIC 11752632"
{
	RA      19.02699607
	Dec     49.994747
	Dist    651
	AppMagn 13.835
	MassSol 0.99
	RadSol  0.99
	Teff    5839
	FeH    -0.07
}

Star	"Kepler-1259/KOI-2493/KIC 10028535"
{
	RA      19.85609927
	Dec     46.967682
	Dist    704
	AppMagn 15.304
	MassSol 0.8
	RadSol  0.77
	Teff    5053
	FeH    -0.07
}

Star	"Kepler-126/KOI-260/KIC 8292840"
{
	RA      19.28981934
	Dec     44.208553
	AppMagn 10.5
	MassSol 1.188
	RadSol  1.36
	Teff    6239
}

Star	"Kepler-1260/KOI-2494/KIC 7047207"
{
	RA      19.7060836
	Dec     42.555241
	Dist    1041
	AppMagn 14.838
	MassSol 1.06
	RadSol  1.08
	Teff    5961
	FeH     0.01
}

Star	"Kepler-1261/KOI-2497/KIC 11179076"
{
	RA      19.01549667
	Dec     48.806721
	Dist    795
	AppMagn 15.605
	MassSol 0.82
	RadSol  0.77
	Teff    5006
	FeH     0.03
}

Star	"Kepler-1262/KOI-2506/KIC 6767840"
{
	RA      19.25145427
	Dec     42.213219
	Dist    1153
	AppMagn 15.18
	MassSol 0.99
	RadSol  0.98
	Teff    5771
	FeH    -0.02
}

Star	"Kepler-1263/KOI-2509/KIC 9880190"
{
	RA      19.09891007
	Dec     46.752617
	Dist    695
	AppMagn 15.035
	MassSol 0.84
	RadSol  0.8
	Teff    5213
	FeH    -0.03
}

Star	"Kepler-1264/KOI-2517/KIC 8947520"
{
	RA      19.3256252
	Dec     45.211502
	Dist    814
	AppMagn 14.511
	MassSol 0.99
	RadSol  0.98
	Teff    5791
	FeH    -0.02
}

Star	"Kepler-1265/KOI-2520/KIC 10059645"
{
	RA      18.97238593
	Dec     47.079533
	Dist    581
	AppMagn 15.602
	MassSol 0.71
	RadSol  0.69
	Teff    4630
	FeH    -0.1
}

Star	"Kepler-1266/KOI-2521/KIC 7183745"
{
	RA      19.05795247
	Dec     42.728096
	Dist    901
	AppMagn 15.86
	MassSol 0.8
	RadSol  0.76
	Teff    5044
	FeH    -0.07
}

Star	"Kepler-1267/KOI-2523/KIC 7778767"
{
	RA      19.94463553
	Dec     43.441094
	Dist    1628
	AppMagn 15.829
	MassSol 1.15
	RadSol  1.2
	Teff    6096
	FeH     0.07
}

Star	"Kepler-1268/KOI-2524/KIC 7515762"
{
	RA      19.18923207
	Dec     43.153236
	Dist    1406
	AppMagn 15.272
	MassSol 1.06
	RadSol  1.09
	Teff    5904
	FeH     0.05
}

Star	"Kepler-1269/KOI-2530/KIC 9011825"
{
	RA      19.18703873
	Dec     45.340549
	Dist    710
	AppMagn 13.611
	MassSol 1.1
	RadSol  1.15
	Teff    5998
	FeH     0.07
}

Star	"Kepler-127/KOI-271/KIC 9451706"
{
	RA      19.01266479
	Dec     46.027962
	AppMagn 11.485
	MassSol 1.24
	RadSol  1.36
	Teff    6106
	FeH    -0.154
}

Star	"Kepler-1270/KOI-2533/KIC 11074835"
{
	RA      19.1143756
	Dec     48.645279
	Dist    1204
	AppMagn 13.274
	MassSol 1.28
	RadSol  3.38
	Teff    5047
	FeH    -0.02
}

Star	"Kepler-1271/KOI-2534/KIC 1996180"
{
	RA      19.08961913
	Dec     37.411973
	Dist    885
	AppMagn 13.925
	MassSol 1.13
	RadSol  1.23
	Teff    6143
	FeH    -0.01
}

Star	"Kepler-1272/KOI-2536/KIC 3728701"
{
	RA      19.0146562
	Dec     38.805878
	Dist    896
	AppMagn 14.423
	MassSol 1.06
	RadSol  1.09
	Teff    5926
	FeH     0.06
}

Star	"Kepler-1273/KOI-2544/KIC 8676148"
{
	RA      19.0535484
	Dec     44.873428
	Dist    1355
	AppMagn 15.826
	MassSol 0.94
	RadSol  0.91
	Teff    5566
	FeH     0.03
}

Star	"Kepler-1274/KOI-2545/KIC 9696358"
{
	RA      18.97291433
	Dec     46.449776
	Dist    609
	AppMagn 11.752
	MassSol 1.45
	RadSol  2.17
	Teff    6179
	FeH     0.11
}

Star	"Kepler-1275/KOI-2552/KIC 8757824"
{
	RA      19.5666998
	Dec     44.932457
	Dist    1280
	AppMagn 14.46
	MassSol 1.23
	RadSol  1.36
	Teff    6296
	FeH     0.04
}

Star	"Kepler-1276/KOI-2555/KIC 5350244"
{
	RA      19.19046733
	Dec     40.547181
	Dist    587
	AppMagn 12.885
	MassSol 1.14
	RadSol  1.21
	Teff    6188
	FeH    -0.02
}

Star	"Kepler-1277/KOI-2556/KIC 5374403"
{
	RA      19.6734942
	Dec     40.572396
	Dist    606
	AppMagn 14.05
	MassSol 0.94
	RadSol  0.92
	Teff    5578
	FeH    -0.01
}

Star	"Kepler-1278/KOI-2561/KIC 7259298"
{
	RA      18.86379567
	Dec     42.825619
	Dist    743
	AppMagn 13.658
	MassSol 1.11
	RadSol  1.16
	Teff    6074
	FeH     0.02
}

Star	"Kepler-1279/KOI-2563/KIC 5175024"
{
	RA      19.20637567
	Dec     40.365964
	Dist    1017
	AppMagn 13.973
	MassSol 1.21
	RadSol  1.33
	Teff    6221
	FeH     0.06
}

Star	"Kepler-128/KOI-274/KIC 8077137"
{
	RA      18.83278
	Dec     43.9803
	AppMagn 11.4
	MassSol 1.17
	RadSol  1.55
	Teff    6013
	FeH    -0.048
}

Star	"Kepler-1280/KOI-2564/KIC 9026749"
{
	RA      19.57159567
	Dec     45.384541
	Dist    1006
	AppMagn 14.074
	MassSol 1.2
	RadSol  1.32
	Teff    6227
	FeH     0.04
}

Star	"Kepler-1281/KOI-2580/KIC 11037511"
{
	RA      19.69029713
	Dec     48.515404
	Dist    1090
	AppMagn 15.79
	MassSol 0.87
	RadSol  0.83
	Teff    5353
	FeH    -0.04
}

Star	"Kepler-1282/KOI-2586/KIC 9827149"
{
	RA      19.3450782
	Dec     46.698338
	Dist    1126
	AppMagn 15.545
	MassSol 0.92
	RadSol  0.89
	Teff    5504
	FeH     0.01
}

Star	"Kepler-1283/KOI-2587/KIC 5546691"
{
	RA      19.69748913
	Dec     40.776969
	Dist    1452
	AppMagn 15.079
	MassSol 1.16
	RadSol  1.25
	Teff    6175
	FeH     0.04
}

Star	"Kepler-1284/KOI-2589/KIC 10468885"
{
	RA      19.41860013
	Dec     47.687649
	Dist    852
	AppMagn 15.645
	MassSol 0.84
	RadSol  0.79
	Teff    5123
	FeH     0.03
}

Star	"Kepler-1285/KOI-2593/KIC 8212002"
{
	RA      18.78902367
	Dec     44.155926
	Dist    364
	AppMagn 11.714
	MassSol 1.2
	RadSol  1.28
	Teff    6170
	FeH     0.16
}

Star	"Kepler-1286/KOI-2594/KIC 8004903"
{
	RA      18.68389213
	Dec     43.835766
	Dist    1150
	AppMagn 15.166
	MassSol 1
	RadSol  0.98
	Teff    5753
	FeH     0.03
}

Star	"Kepler-1287/KOI-2602/KIC 10068659"
{
	RA      19.27564407
	Dec     47.062996
	Dist    1027
	AppMagn 15.051
	MassSol 0.96
	RadSol  0.94
	Teff    5715
	FeH    -0.05
}

Star	"Kepler-1288/KOI-2608/KIC 6269070"
{
	RA      19.04756587
	Dec     41.605873
	Dist    715
	AppMagn 13.321
	MassSol 1.2
	RadSol  1.29
	Teff    6132
	FeH     0.14
}

Star	"Kepler-1289"
{
	RA      19.7592538
	Dec     41.040571
	Dist    1059
	AppMagn 13.109 // not V mag
	MassSol 1.1
	RadSol  1.17
	Teff    6080
	FeH     0.02
}

Star	"Kepler-129/KOI-275/KIC 10586004"
{
	RA      19.02075195
	Dec     47.848595
	AppMagn 11.696
	MassSol 1.18
	RadSol  1.64
	Teff    5770
}

Star	"Kepler-1290/KOI-2615/KIC 8025596"
{
	RA      19.3790166
	Dec     43.859638
	Dist    1321
	AppMagn 15.711
	MassSol 0.95
	RadSol  0.93
	Teff    5660
	FeH    -0.02
}

Star	"Kepler-1291/KOI-2617/KIC 4915638"
{
	RA      19.29180213
	Dec     40.001151
	Dist    982
	AppMagn 15.868
	MassSol 0.84
	RadSol  0.8
	Teff    5216
	FeH    -0.04
}

Star	"Kepler-1292/KOI-2619/KIC 8081905"
{
	RA      18.99371467
	Dec     43.949169
	Dist    1406
	AppMagn 15.934
	MassSol 0.95
	RadSol  0.93
	Teff    5556
	FeH     0.08
}

Star	"Kepler-1293/KOI-2623/KIC 10916600"
{
	RA      19.3350614
	Dec     48.335949
	Dist    770
	AppMagn 13.383
	MassSol 1.18
	RadSol  1.28
	Teff    6241
	FeH     0
}

Star	"Kepler-1294/KOI-2624/KIC 8429314"
{
	RA      19.4178734
	Dec     44.488194
	Dist    1120
	AppMagn 15.174
	MassSol 0.99
	RadSol  0.97
	Teff    5776
	FeH    -0.03
}

Star	"Kepler-1295/KOI-2625/KIC 9153570"
{
	RA      19.42652427
	Dec     45.588559
	Dist    1257
	AppMagn 15.89
	MassSol 0.92
	RadSol  0.89
	Teff    5486
	FeH     0.04
}

Star	"Kepler-1296/KOI-2627/KIC 6124512"
{
	RA      19.4750126
	Dec     41.407814
	Dist    631
	AppMagn 14.667
	MassSol 0.87
	RadSol  0.83
	Teff    5359
	FeH    -0.04
}

Star	"Kepler-1297/KOI-2628/KIC 10070468"
{
	RA      19.3304334
	Dec     47.020393
	Dist    996
	AppMagn 14.812
	MassSol 0.99
	RadSol  0.99
	Teff    5818
	FeH    -0.04
}

Star	"Kepler-1298/KOI-2632/KIC 11337566"
{
	RA      18.96151567
	Dec     49.106224
	Dist    498
	AppMagn 11.392
	MassSol 1.45
	RadSol  2
	Teff    6339
	FeH     0.13
}

Star	"Kepler-1299/KOI-2634/KIC 1995519"
{
	RA      19.076677
	Dec     37.411377
	Dist    1352
	AppMagn 15.922
	MassSol 0.94
	RadSol  0.91
	Teff    5609
	FeH    -0.01
}

Star	"Kepler-13 A/KOI-13/KIC 9941662"
{
	RA      19.13138889
	Dec     46.8683333
	AppMagn 10
	MassSol 2.05
	RadSol  2.55
	Teff    8500
	FeH    -0.14
}

Star	"Kepler-130/KOI-282/KIC 5088536"
{
	RA      19.23004354
	Dec     40.245304
	AppMagn 11.529
	MassSol 1
	RadSol  1.13
	Teff    5884
	FeH     0.02
}

Star	"Kepler-1300/KOI-2635/KIC 4914566"
{
	RA      19.26886813
	Dec     40.086887
	Dist    757
	AppMagn 12.816
	MassSol 1.29
	RadSol  1.79
	Teff    6130
	FeH     0.05
}

Star	"Kepler-1301"
{
	RA      19.10694553
	Dec     42.440319
	Dist    816
	AppMagn 13.535 // not V mag
	MassSol 0.85
	RadSol  0.81
	Teff    5188
	FeH     0.01
}

Star	"Kepler-1302/KOI-2647/KIC 11962284"
{
	RA      19.39928273
	Dec     50.30806
	Dist    727
	AppMagn 15.102
	MassSol 0.86
	RadSol  0.82
	Teff    5236
	FeH     0.04
}

Star	"Kepler-1303/KOI-2649/KIC 6842682"
{
	RA      18.95247707
	Dec     42.355614
	Dist    905
	AppMagn 14.64
	MassSol 1.01
	RadSol  1
	Teff    5771
	FeH     0.04
}

Star	"Kepler-1304/KOI-2652/KIC 4346178"
{
	RA      19.01842853
	Dec     39.446916
	Dist    682
	AppMagn 15.022
	MassSol 0.85
	RadSol  0.81
	Teff    5259
	FeH    -0.05
}

Star	"Kepler-1305/KOI-2654/KIC 9664142"
{
	RA      19.82262973
	Dec     46.347252
	Dist    1343
	AppMagn 15.785
	MassSol 0.97
	RadSol  0.96
	Teff    5701
	FeH     0.01
}

Star	"Kepler-1306/KOI-2655/KIC 10018233"
{
	RA      19.6318894
	Dec     46.945862
	Dist    1130
	AppMagn 15.243
	MassSol 0.98
	RadSol  0.97
	Teff    5727
	FeH     0
}

Star	"Kepler-1307/KOI-2660/KIC 9893318"
{
	RA      19.524656
	Dec     46.741859
	Dist    1396
	AppMagn 15.394
	MassSol 1.06
	RadSol  1.08
	Teff    5884
	FeH     0.06
}

Star	"Kepler-1308/KOI-2662/KIC 3426367"
{
	RA      19.0619264
	Dec     38.520962
	Dist    73
	AppMagn 14.488
	MassSol 0.35
	RadSol  0.34
	Teff    3468
	FeH    -0.13
}

Star	"Kepler-1309/KOI-2664/KIC 5562090"
{
	RA      19.91568233
	Dec     40.764155
	Dist    845
	AppMagn 15.652
	MassSol 0.85
	RadSol  0.8
	Teff    5235
	FeH    -0.03
}

Star	"Kepler-131/KOI-283/KIC 5695396"
{
	RA      19.23538889
	Dec     40.94230558
	AppMagn 11.525
	MassSol 1.02
	RadSol  1.03
	Teff    5685
	FeH     0.12
	Age     3.66
}

Star	"Kepler-1310/KOI-2668/KIC 5513012"
{
	RA      18.92800233
	Dec     40.740123
	Dist    583
	AppMagn 14.159
	MassSol 0.91
	RadSol  0.88
	Teff    5549
	FeH    -0.07
}

Star	"Kepler-1311/KOI-2674/KIC 8022489"
{
	RA      19.3100842
	Dec     43.824417
	Dist    705
	AppMagn 13.349
	MassSol 1.05
	RadSol  1.4
	Teff    5748
	FeH     0.09
}

Star	"Kepler-1312/KOI-2675/KIC 5794570"
{
	RA      19.53141607
	Dec     41.035764
	Dist    305
	AppMagn 12.43
	MassSol 0.99
	RadSol  0.92
	Teff    5719
	FeH    -0.02
}

Star	"Kepler-1313/KOI-2678/KIC 6779260"
{
	RA      19.49256973
	Dec     42.233261
	Dist    187
	AppMagn 11.799
	MassSol 0.92
	RadSol  0.85
	Teff    5453
	FeH     0
}

Star	"Kepler-1314/KOI-2688/KIC 8892303"
{
	RA      19.61586253
	Dec     45.197322
	Dist    462
	AppMagn 16.406
	MassSol 0.6
	RadSol  0.59
	Teff    4188
	FeH    -0.22
}

Star	"Kepler-1315/KOI-2694/KIC 9475552"
{
	RA      19.72142987
	Dec     46.053029
	Dist    505
	AppMagn 14.975
	MassSol 0.8
	RadSol  0.75
	Teff    4861
	FeH     0.07
}

Star	"Kepler-1316/KOI-2698/KIC 5128673"
{
	RA      19.9223914
	Dec     40.293136
	Dist    753
	AppMagn 14
	MassSol 1.04
	RadSol  1.12
	Teff    5884
	FeH     0.03
}

Star	"Kepler-1317/KOI-2699/KIC 6690836"
{
	RA      19.44079207
	Dec     42.115971
	Dist    734
	AppMagn 15.23
	MassSol 0.83
	RadSol  0.79
	Teff    5144
	FeH    -0.01
}

Star	"Kepler-1318/KOI-2703/KIC 5871985"
{
	RA      19.35842087
	Dec     41.150741
	Dist    475
	AppMagn 15.165
	MassSol 0.73
	RadSol  0.7
	Teff    4598
	FeH    -0.01
}

Star	"Kepler-1319/KOI-2705/KIC 11453592"
{
	RA      19.3970712
	Dec     49.366306
	Dist    114
	AppMagn 14.717
	MassSol 0.56
	RadSol  0.54
	Teff    3655
	FeH     0.44
}

Star	"Kepler-1320/KOI-2708/KIC 5175986"
{
	RA      19.22890607
	Dec     40.380875
	Dist    771
	AppMagn 15.898
	MassSol 0.8
	RadSol  0.74
	Teff    4817
	FeH     0.1
}

Star	"Kepler-1321/KOI-2715/KIC 9837661"
{
	RA      19.63523953
	Dec     46.640962
	Dist    547
	AppMagn 16.835
	MassSol 0.54
	RadSol  0.53
	Teff    4094
	FeH    -0.45
}

Star	"Kepler-1322/KOI-2716/KIC 9092504"
{
	RA      19.54696807
	Dec     45.435402
	Dist    1217
	AppMagn 15.81
	MassSol 0.9
	RadSol  0.87
	Teff    5488
	FeH    -0.07
}

Star	"Kepler-1323/KOI-2717/KIC 9467404"
{
	RA      19.52481893
	Dec     46.098885
	Dist    530
	AppMagn 12.41
	MassSol 1.18
	RadSol  1.4
	Teff    6169
	FeH     0.02
}

Star	"Kepler-1324/KOI-2719/KIC 5184911"
{
	RA      19.41233133
	Dec     40.311214
	Dist    522
	AppMagn 15.141
	MassSol 0.78
	RadSol  0.73
	Teff    4776
	FeH     0.05
}

Star	"Kepler-1325/KOI-2721/KIC 6587105"
{
	RA      19.00114847
	Dec     42.085384
	Dist    955
	AppMagn 15.16
	MassSol 0.93
	RadSol  0.91
	Teff    5550
	FeH     0.01
}

Star	"Kepler-1326/KOI-2728/KIC 4178606"
{
	RA      19.74814293
	Dec     39.268958
	Dist    910
	AppMagn 12.852
	MassSol 1.45
	RadSol  1.74
	Teff    6725
	FeH     0.02
}

Star	"Kepler-1327/KOI-2729/KIC 12008872"
{
	RA      19.27099127
	Dec     50.460976
	Dist    688
	AppMagn 13.914
	MassSol 1.02
	RadSol  1.03
	Teff    5885
	FeH    -0.03
}

Star	"Kepler-1328/KOI-2730/KIC 8415200"
{
	RA      18.9783592
	Dec     44.41777
	Dist    630
	AppMagn 13.836
	MassSol 1
	RadSol  0.99
	Teff    5780
	FeH     0
}

Star	"Kepler-1329/KOI-2736/KIC 10842192"
{
	RA      18.77651613
	Dec     48.271046
	Dist    624
	AppMagn 15.911
	MassSol 0.72
	RadSol  0.69
	Teff    4500
	FeH     0.02
}

Star	"Kepler-133/KOI-291/KIC 10933561"
{
	RA      19.81853231
	Dec     48.320328
	AppMagn 12.848
	MassSol 0.998
	RadSol  1.43
	Teff    5736
	FeH    -0.16
}

Star	"Kepler-1330/KOI-2739/KIC 4831728"
{
	RA      19.37178247
	Dec     39.956893
	Dist    939
	AppMagn 15.017
	MassSol 0.97
	RadSol  0.94
	Teff    5608
	FeH     0.08
}

Star	"Kepler-1331/KOI-2742/KIC 5980208"
{
	RA      19.80491927
	Dec     41.22448
	Dist    365
	AppMagn 15.031
	MassSol 0.72
	RadSol  0.69
	Teff    4508
	FeH     0.05
}

Star	"Kepler-1332/KOI-2743/KIC 8095441"
{
	RA      19.401906
	Dec     43.913673
	Dist    515
	AppMagn 13.756
	MassSol 0.95
	RadSol  0.9
	Teff    5581
	FeH     0
}

Star	"Kepler-1333/KOI-2744/KIC 5881813"
{
	RA      19.56850407
	Dec     41.111437
	Dist    958
	AppMagn 15.162
	MassSol 0.94
	RadSol  0.92
	Teff    5628
	FeH    -0.04
}

Star	"Kepler-1334/KOI-2745/KIC 12456601"
{
	RA      19.287432
	Dec     51.320866
	Dist    1047
	AppMagn 15.241
	MassSol 0.94
	RadSol  0.91
	Teff    5614
	FeH    -0.03
}

Star	"Kepler-1335/KOI-2747/KIC 6586746"
{
	RA      18.9892272
	Dec     42.070431
	Dist    628
	AppMagn 15.329
	MassSol 0.77
	RadSol  0.74
	Teff    4903
	FeH    -0.07
}

Star	"Kepler-1336/KOI-2748/KIC 9962455"
{
	RA      19.7518474
	Dec     46.899857
	Dist    822
	AppMagn 14.056
	MassSol 0.94
	RadSol  1.3
	Teff    5512
	FeH     0.05
}

Star	"Kepler-1337/KOI-2751/KIC 9881077"
{
	RA      19.13393987
	Dec     46.796101
	Dist    588
	AppMagn 15.858
	MassSol 0.7
	RadSol  0.67
	Teff    4523
	FeH    -0.09
}

Star	"Kepler-1338/KOI-2753/KIC 6265792"
{
	RA      18.93615567
	Dec     41.699139
	Dist    619
	AppMagn 13.615
	MassSol 1.04
	RadSol  1.05
	Teff    5909
	FeH     0
}

Star	"Kepler-1339/KOI-2754/KIC 10905911"
{
	RA      18.91638627
	Dec     48.373394
	Dist    267
	AppMagn 12.299
	MassSol 0.94
	RadSol  0.93
	Teff    5586
	FeH     0.01
}

Star	"Kepler-134/KOI-295/KIC 11547513"
{
	RA      18.98260091
	Dec     49.598396
	AppMagn 12.324
	MassSol 1.263
	RadSol  1.18
	Teff    5983
}

Star	"Kepler-1340/KOI-2756/KIC 6964929"
{
	RA      19.7488538
	Dec     42.47279
	Dist    1421
	AppMagn 14.758
	MassSol 1.27
	RadSol  1.42
	Teff    6331
	FeH     0.07
}

Star	"Kepler-1341/KOI-2762/KIC 8210018"
{
	RA      18.7007846
	Dec     44.159351
	Dist    466
	AppMagn 15.028
	MassSol 0.79
	RadSol  0.72
	Teff    4662
	FeH     0.19
}

Star	"Kepler-1342/KOI-2778/KIC 7769819"
{
	RA      19.80133793
	Dec     43.432549
	Dist    941
	AppMagn 15.392
	MassSol 0.93
	RadSol  0.9
	Teff    5527
	FeH     0.03
}

Star	"Kepler-1343/KOI-2780/KIC 12164564"
{
	RA      19.61963553
	Dec     50.725376
	Dist    1307
	AppMagn 15.526
	MassSol 0.95
	RadSol  0.93
	Teff    5759
	FeH    -0.16
}

Star	"Kepler-1344/KOI-2785/KIC 10001368"
{
	RA      19.13908647
	Dec     46.945816
	Dist    851
	AppMagn 14.083
	MassSol 1.09
	RadSol  1.13
	Teff    5981
	FeH     0.06
}

Star	"Kepler-1345/KOI-2786/KIC 9466429"
{
	RA      19.498531
	Dec     46.022835
	Dist    1164
	AppMagn 13.791
	MassSol 1.32
	RadSol  1.55
	Teff    6449
	FeH     0.04
}

Star	"Kepler-1346/KOI-2789/KIC 8885643"
{
	RA      19.4560872
	Dec     45.179176
	Dist    1123
	AppMagn 14.497
	MassSol 1.14
	RadSol  1.21
	Teff    6133
	FeH     0.04
}

Star	"Kepler-1347/KOI-2790/KIC 5652893"
{
	RA      19.977307
	Dec     40.843853
	Dist    321
	AppMagn 13.38
	MassSol 0.82
	RadSol  0.79
	Teff    5193
	FeH    -0.11
}

Star	"Kepler-1348/KOI-2791/KIC 11662184"
{
	RA      19.47249733
	Dec     49.788765
	Dist    1033
	AppMagn 14.718
	MassSol 1.04
	RadSol  1.04
	Teff    5911
	FeH    -0.01
}

Star	"Kepler-1349/KOI-2792/KIC 11127479"
{
	RA      19.0892246
	Dec     48.744099
	Dist    260
	AppMagn 11.126
	MassSol 1.16
	RadSol  1.28
	Teff    6086
	FeH     0.03
}

Star	"Kepler-135/KOI-301/KIC 3642289"
{
	RA      19.36634115
	Dec     38.795479
	AppMagn 12.73
	MassSol 1.187
	RadSol  1.27
	Teff    6090
	FeH     0.045
}

Star	"Kepler-1350/KOI-2793/KIC 9823519"
{
	RA      19.21670547
	Dec     46.679602
	Dist    350
	AppMagn 16.283
	MassSol 0.55
	RadSol  0.53
	Teff    3827
	FeH    -0.06
}

Star	"Kepler-1351/KOI-2798/KIC 6697756"
{
	RA      19.57391467
	Dec     42.197678
	Dist    241
	AppMagn 14.107
	MassSol 0.7
	RadSol  0.67
	Teff    4439
	FeH    -0.03
}

Star	"Kepler-1352/KOI-2805/KIC 11135308"
{
	RA      19.3795824
	Dec     48.701477
	Dist    637
	AppMagn 13.295
	MassSol 1.11
	RadSol  1.16
	Teff    6118
	FeH     0
}

Star	"Kepler-1353/KOI-2806/KIC 7047824"
{
	RA      19.715689
	Dec     42.576252
	Dist    596
	AppMagn 15.514
	MassSol 0.76
	RadSol  0.72
	Teff    4776
	FeH    -0.06
}

Star	"Kepler-1354/KOI-2812/KIC 2442448"
{
	RA      19.4163458
	Dec     37.759052
	Dist    1057
	AppMagn 14.357
	MassSol 1.16
	RadSol  1.24
	Teff    6168
	FeH     0.03
}

Star	"Kepler-1355/KOI-2816/KIC 11283615"
{
	RA      18.9160944
	Dec     49.067978
	Dist    963
	AppMagn 15.471
	MassSol 0.88
	RadSol  0.83
	Teff    5352
	FeH    -0.04
}

Star	"Kepler-1356/KOI-2817/KIC 7605093"
{
	RA      19.39968973
	Dec     43.243938
	Dist    881
	AppMagn 15.76
	MassSol 0.82
	RadSol  0.78
	Teff    5106
	FeH    -0.02
}

Star	"Kepler-1357/KOI-2820/KIC 11963206"
{
	RA      19.4365396
	Dec     50.353313
	Dist    1026
	AppMagn 15.273
	MassSol 0.93
	RadSol  0.9
	Teff    5597
	FeH    -0.06
}

Star	"Kepler-1358/KOI-2827/KIC 7428736"
{
	RA      19.0780362
	Dec     43.008911
	Dist    558
	AppMagn 14.572
	MassSol 0.82
	RadSol  0.79
	Teff    5181
	FeH    -0.08
}

Star	"Kepler-1359/KOI-2828/KIC 6436029"
{
	RA      19.30258793
	Dec     41.892825
	Dist    669
	AppMagn 16.2
	MassSol 0.78
	RadSol  0.72
	Teff    4709
	FeH     0.11
}

Star	"Kepler-136/KOI-312/KIC 7050989"
{
	RA      19.76448771
	Dec     42.59877
	AppMagn 12.459
	MassSol 1.2
	RadSol  1.35
	Teff    6165
}

Star	"Kepler-1360/KOI-2830/KIC 9244508"
{
	RA      20.0229384
	Dec     45.623219
	Dist    1405
	AppMagn 13.913
	MassSol 1.51
	RadSol  1.83
	Teff    6778
	FeH     0.06
}

Star	"Kepler-1361/KOI-2832/KIC 9995402"
{
	RA      18.90435427
	Dec     46.904255
	Dist    404
	AppMagn 13.93
	MassSol 0.83
	RadSol  0.79
	Teff    5131
	FeH     0
}

Star	"Kepler-1362/KOI-2834/KIC 5609593"
{
	RA      19.2359028
	Dec     40.877113
	Dist    767
	AppMagn 15.839
	MassSol 0.8
	RadSol  0.74
	Teff    4857
	FeH     0.06
}

Star	"Kepler-1363/KOI-2836/KIC 11414465"
{
	RA      19.79977053
	Dec     49.256413
	Dist    559
	AppMagn 15.29
	MassSol 0.76
	RadSol  0.72
	Teff    4839
	FeH    -0.09
}

Star	"Kepler-1364/KOI-2837/KIC 11565924"
{
	RA      19.6768134
	Dec     49.587605
	Dist    1149
	AppMagn 13.228
	MassSol 1.49
	RadSol  1.79
	Teff    6805
	FeH     0.04
}

Star	"Kepler-1365/KOI-2838/KIC 6607357"
{
	RA      19.47998067
	Dec     42.046089
	Dist    541
	AppMagn 13.421
	MassSol 1
	RadSol  1.05
	Teff    5770
	FeH     0.03
}

Star	"Kepler-1366/KOI-2839/KIC 6186964"
{
	RA      19.0043276
	Dec     41.554874
	Dist    395
	AppMagn 15.877
	MassSol 0.62
	RadSol  0.6
	Teff    4070
	FeH    -0.02
}

Star	"Kepler-1367/KOI-2845/KIC 10591855"
{
	RA      19.22776853
	Dec     47.878731
	Dist    357
	AppMagn 15.571
	MassSol 0.62
	RadSol  0.6
	Teff    4106
	FeH    -0.06
}

Star	"Kepler-1368/KOI-2852/KIC 6294819"
{
	RA      19.65113233
	Dec     41.64468
	Dist    1750
	AppMagn 15.892
	MassSol 1.07
	RadSol  1.08
	Teff    5906
	FeH     0.1
}

Star	"Kepler-1369/KOI-2856/KIC 5688910"
{
	RA      19.05314893
	Dec     40.936186
	Dist    1236
	AppMagn 15.323
	MassSol 0.99
	RadSol  0.99
	Teff    5761
	FeH     0
}

Star	"Kepler-137/KOI-313/KIC 7419318"
{
	RA      18.80903524
	Dec     43.039101
	AppMagn 12.99
	MassSol 0.907
	RadSol  0.8
	Teff    5187
	FeH    -0.12
}

Star	"Kepler-1370/KOI-2857/KIC 6345732"
{
	RA      18.971045
	Dec     41.778484
	Dist    878
	AppMagn 13.701
	MassSol 1.19
	RadSol  1.29
	Teff    6202
	FeH     0.05
}

Star	"Kepler-1371/KOI-2859/KIC 10397751"
{
	RA      19.25542553
	Dec     47.551994
	Dist    450
	AppMagn 13.851
	MassSol 0.87
	RadSol  0.83
	Teff    5361
	FeH    -0.07
}

Star	"Kepler-1372/KOI-2865/KIC 8681833"
{
	RA      19.259109
	Dec     44.83955
	Dist    1161
	AppMagn 15.371
	MassSol 0.98
	RadSol  0.97
	Teff    5677
	FeH     0.05
}

Star	"Kepler-1373/KOI-2866/KIC 4138951"
{
	RA      19.0501366
	Dec     39.249205
	Dist    1112
	AppMagn 14.135
	MassSol 1.22
	RadSol  1.33
	Teff    6299
	FeH     0.03
}

Star	"Kepler-1374/KOI-2868/KIC 8884274"
{
	RA      19.4233322
	Dec     45.172267
	Dist    1135
	AppMagn 15.97
	MassSol 0.85
	RadSol  0.81
	Teff    5323
	FeH    -0.13
}

Star	"Kepler-1375/KOI-2869/KIC 7767162"
{
	RA      19.75290387
	Dec     43.403267
	Dist    1238
	AppMagn 13.749
	MassSol 1.47
	RadSol  1.78
	Teff    6704
	FeH     0.09
}

Star	"Kepler-1376/KOI-2877/KIC 7019524"
{
	RA      19.13056247
	Dec     42.541386
	Dist    864
	AppMagn 14.699
	MassSol 0.98
	RadSol  0.97
	Teff    5659
	FeH     0.07
}

Star	"Kepler-1377"
{
	RA      19.2796972
	Dec     46.651703
	Dist    1019
	AppMagn 13.949 // not V mag
	MassSol 0.86
	RadSol  0.82
	Teff    5218
	FeH     0.05
}

Star	"Kepler-1378/KOI-2883/KIC 5209845"
{
	RA      19.82488753
	Dec     40.366398
	Dist    562
	AppMagn 15.911
	MassSol 0.7
	RadSol  0.67
	Teff    4407
	FeH     0.03
}

Star	"Kepler-1379/KOI-2886/KIC 6129524"
{
	RA      19.5780314
	Dec     41.410248
	Dist    951
	AppMagn 15.919
	MassSol 0.83
	RadSol  0.79
	Teff    5188
	FeH    -0.04
}

Star	"Kepler-138/KOI-314/KIC 7603200"
{
	RA      19.35888889
	Dec     43.29305557
	AppMagn 13.5
	Class  "M1V"
	MassSol 0.57
	RadSol  0.54
	Teff    3871
	FeH    -0.28
}

Star	"Kepler-1380/KOI-2894/KIC 6937402"
{
	RA      19.20773687
	Dec     42.440422
	Dist    1209
	AppMagn 15.619
	MassSol 0.96
	RadSol  0.94
	Teff    5570
	FeH     0.1
}

Star	"Kepler-1381/KOI-2898/KIC 11129258"
{
	RA      19.16905093
	Dec     48.727791
	Dist    1306
	AppMagn 15.535
	MassSol 0.96
	RadSol  0.94
	Teff    5747
	FeH    -0.1
}

Star	"Kepler-1382/KOI-2904/KIC 3969687"
{
	RA      19.69182527
	Dec     39.048031
	Dist    730
	AppMagn 12.683
	MassSol 1.36
	RadSol  1.72
	Teff    6161
	FeH     0.3
}

Star	"Kepler-1383/KOI-2906/KIC 6716545"
{
	RA      19.86298527
	Dec     42.191882
	Dist    961
	AppMagn 13.716
	MassSol 1.26
	RadSol  1.44
	Teff    6370
	FeH     0.03
}

Star	"Kepler-1384/KOI-2910/KIC 4483138"
{
	RA      19.74767773
	Dec     39.527049
	Dist    618
	AppMagn 15.384
	MassSol 0.78
	RadSol  0.74
	Teff    4919
	FeH    -0.06
}

Star	"Kepler-1385/KOI-2913/KIC 9693006"
{
	RA      18.84209127
	Dec     46.481106
	Dist    527
	AppMagn 12.858
	MassSol 1.15
	RadSol  1.29
	Teff    5732
	FeH     0.41
}

Star	"Kepler-1386/KOI-2920/KIC 7090524"
{
	RA      18.7215596
	Dec     42.636056
	Dist    838
	AppMagn 14.455
	MassSol 1.02
	RadSol  1.03
	Teff    5733
	FeH     0.11
}

Star	"Kepler-1387/KOI-2924/KIC 7609553"
{
	RA      19.4960264
	Dec     43.209431
	Dist    491
	AppMagn 14.589
	MassSol 0.82
	RadSol  0.77
	Teff    5046
	FeH     0.02
}

Star	"Kepler-1388/KOI-2926/KIC 10122538"
{
	RA      18.88906933
	Dec     47.174535
	Dist    492
	AppMagn 16.279
	MassSol 0.63
	RadSol  0.61
	Teff    4098
	FeH     0.02
}

Star	"Kepler-1389/KOI-2931/KIC 8611257"
{
	RA      19.04782847
	Dec     44.758423
	Dist    521
	AppMagn 14.699
	MassSol 0.81
	RadSol  0.74
	Teff    5078
	FeH    -0.14
}

Star	"Kepler-139/KOI-316/KIC 8008067"
{
	RA      18.82613118
	Dec     43.889351
	AppMagn 12.701
	MassSol 1.08
	RadSol  1.3
	Teff    5594
	FeH     0.154
}

Star	"Kepler-1390/KOI-2936/KIC 10880507"
{
	RA      19.910823
	Dec     48.248764
	Dist    760
	AppMagn 14.421
	MassSol 0.98
	RadSol  0.98
	Teff    5753
	FeH    -0.01
}

Star	"Kepler-1391/KOI-2943/KIC 9838468"
{
	RA      19.65540153
	Dec     46.659592
	Dist    721
	AppMagn 13.852
	MassSol 1.03
	RadSol  1.1
	Teff    5840
	FeH     0.04
}

Star	"Kepler-1392/KOI-2946/KIC 9642292"
{
	RA      19.25113173
	Dec     46.394424
	Dist    1117
	AppMagn 15.679
	MassSol 0.88
	RadSol  0.85
	Teff    5479
	FeH    -0.11
}

Star	"Kepler-1393/KOI-2951/KIC 4991208"
{
	RA      18.96396387
	Dec     40.142553
	Dist    462
	AppMagn 13.348
	MassSol 0.95
	RadSol  0.92
	Teff    5697
	FeH    -0.09
}

Star	"Kepler-1394/KOI-2956/KIC 8801316"
{
	RA      18.89688
	Dec     45.084141
	Dist    820
	AppMagn 11.801
	MassSol 1.64
	RadSol  2.55
	Teff    6481
	FeH     0.06
}

Star	"Kepler-1395/KOI-2961/KIC 10471515"
{
	RA      19.48917007
	Dec     47.6642
	Dist    507
	AppMagn 12.581
	MassSol 1.17
	RadSol  1.23
	Teff    6138
	FeH     0.12
}

Star	"Kepler-1396/KOI-2963/KIC 8760040"
{
	RA      19.6224312
	Dec     44.918293
	Dist    1236
	AppMagn 14.544
	MassSol 1.18
	RadSol  1.27
	Teff    6195
	FeH     0.04
}

Star	"Kepler-1397/KOI-2964/KIC 10098844"
{
	RA      19.9783906
	Dec     47.075844
	Dist    770
	AppMagn 14.089
	MassSol 1.09
	RadSol  1.12
	Teff    6026
	FeH     0
}

Star	"Kepler-1398/KOI-2977/KIC 11090556"
{
	RA      19.65774567
	Dec     48.638985
	Dist    793
	AppMagn 13.71
	MassSol 1.13
	RadSol  1.18
	Teff    6126
	FeH     0.01
}

Star	"Kepler-1399/KOI-2980/KIC 9468551"
{
	RA      19.55411207
	Dec     46.041714
	Dist    1256
	AppMagn 15.49
	MassSol 0.97
	RadSol  0.96
	Teff    5735
	FeH    -0.03
}

Star	"Kepler-140/KOI-327/KIC 9881662"
{
	RA      19.15796509
	Dec     46.768211
	AppMagn 12.996
	MassSol 1.149
	RadSol  1.29
	Teff    6077
	FeH    -0.094
}

Star	"Kepler-1400/KOI-2981/KIC 9076971"
{
	RA      19.0847768
	Dec     45.440807
	Dist    879
	AppMagn 15.737
	MassSol 0.83
	RadSol  0.78
	Teff    5044
	FeH     0.04
}

Star	"Kepler-1401/KOI-2990/KIC 5520547"
{
	RA      19.1644028
	Dec     40.758452
	Dist    1242
	AppMagn 14.982
	MassSol 1.07
	RadSol  1.1
	Teff    5964
	FeH     0.04
}

Star	"Kepler-1402/KOI-2994/KIC 11244137"
{
	RA      19.4565216
	Dec     48.968132
	Dist    681
	AppMagn 14.621
	MassSol 0.9
	RadSol  0.87
	Teff    5416
	FeH     0.03
}

Star	"Kepler-1403/KOI-2995/KIC 3848275"
{
	RA      19.39118047
	Dec     38.960119
	Dist    1801
	AppMagn 15.598
	MassSol 1.11
	RadSol  1.15
	Teff    6060
	FeH     0.03
}

Star	"Kepler-1404/KOI-2996/KIC 12021625"
{
	RA      19.733962
	Dec     50.498386
	Dist    946
	AppMagn 15.688
	MassSol 0.84
	RadSol  0.8
	Teff    5261
	FeH    -0.09
}

Star	"Kepler-1405/KOI-2998/KIC 4175630"
{
	RA      19.7123228
	Dec     39.256142
	Dist    1605
	AppMagn 15.873
	MassSol 1.05
	RadSol  1.07
	Teff    5925
	FeH     0.03
}

Star	"Kepler-1406"
{
	RA      19.4721242
	Dec     38.915023
	Dist    587
	AppMagn 11.908 // not V mag
	MassSol 1.05
	RadSol  1.12
	Teff    5892
	FeH     0.04
}

Star	"Kepler-1407/KOI-3004/KIC 6103377"
{
	RA      18.92949547
	Dec     41.4716
	Dist    1275
	AppMagn 14.935
	MassSol 1.1
	RadSol  1.15
	Teff    6010
	FeH     0.05
}

Star	"Kepler-1408/KOI-3008/KIC 9070666"
{
	RA      18.8466628
	Dec     45.42577
	Dist    426
	AppMagn 12.003
	MassSol 1.21
	RadSol  1.35
	Teff    6170
	FeH     0
}

Star	"Kepler-1409/KOI-3009/KIC 12405333"
{
	RA      19.33898573
	Dec     51.208603
	Dist    722
	AppMagn 15.168
	MassSol 0.83
	RadSol  0.79
	Teff    5160
	FeH    -0.03
}

Star	"Kepler-141/KOI-338/KIC 10552611"
{
	RA      19.86472575
	Dec     47.731678
	AppMagn 13.448
	MassSol 1
	RadSol  0.79
	Teff    4910
	FeH     0.538
}

Star	"Kepler-1410/KOI-3010/KIC 3642335"
{
	RA      19.36734653
	Dec     38.743544
	Dist    367
	AppMagn 15.757
	MassSol 0.63
	RadSol  0.6
	Teff    4092
	FeH     0.01
}

Star	"Kepler-1411/KOI-3014/KIC 7347246"
{
	RA      19.09077193
	Dec     42.963924
	Dist    1431
	AppMagn 15.831
	MassSol 0.95
	RadSol  0.92
	Teff    5664
	FeH    -0.04
}

Star	"Kepler-1412/KOI-3015/KIC 11403530"
{
	RA      19.47867467
	Dec     49.20248
	Dist    639
	AppMagn 13.219
	MassSol 1.06
	RadSol  1.27
	Teff    5880
	FeH     0.04
}

Star	"Kepler-1413"
{
	RA      19.6227766
	Dec     46.498767
	Dist    1162
	AppMagn 14.385 // not V mag
	MassSol 0.84
	RadSol  0.8
	Teff    5196
	FeH    -0.05
}

Star	"Kepler-1414/KOI-3026/KIC 6929841"
{
	RA      18.99523867
	Dec     42.42231
	Dist    534
	AppMagn 14.897
	MassSol 0.8
	RadSol  0.75
	Teff    4951
	FeH    -0.02
}

Star	"Kepler-1415"
{
	RA      19.01046087
	Dec     47.873333
	Dist    1066
	AppMagn 13.972 // not V mag
	MassSol 0.89
	RadSol  0.84
	Teff    5267
	FeH     0.12
}

Star	"Kepler-1416/KOI-3038/KIC 8051946"
{
	RA      19.91089787
	Dec     43.894073
	Dist    807
	AppMagn 14.22
	MassSol 1.09
	RadSol  1.15
	Teff    6019
	FeH     0.03
}

Star	"Kepler-1417/KOI-3039/KIC 5445681"
{
	RA      19.3966592
	Dec     40.605215
	Dist    656
	AppMagn 13.914
	MassSol 1.02
	RadSol  1.02
	Teff    5839
	FeH     0.02
}

Star	"Kepler-1418/KOI-3049/KIC 6263593"
{
	RA      18.86649853
	Dec     41.678551
	Dist    499
	AppMagn 15.037
	MassSol 0.77
	RadSol  0.72
	Teff    4770
	FeH     0
}

Star	"Kepler-1419/KOI-3053/KIC 2716801"
{
	RA      19.48364233
	Dec     37.97142
	Dist    1444
	AppMagn 15.761
	MassSol 1.01
	RadSol  1.01
	Teff    5796
	FeH     0.04
}

Star	"Kepler-142/KOI-343/KIC 10982872"
{
	RA      19.6745931
	Dec     48.481281
	AppMagn 13.203
	MassSol 0.99
	RadSol  1.27
	Teff    5790
	FeH    -0.274
}

Star	"Kepler-1420/KOI-3056/KIC 7216284"
{
	RA      19.74692067
	Dec     42.777832
	Dist    923
	AppMagn 15.883
	MassSol 0.82
	RadSol  0.79
	Teff    5187
	FeH    -0.1
}

Star	"Kepler-1421/KOI-3060/KIC 11019987"
{
	RA      19.1053728
	Dec     48.544197
	Dist    675
	AppMagn 12.788
	MassSol 1.25
	RadSol  1.42
	Teff    6335
	FeH     0.05
}

Star	"Kepler-1422/KOI-3063/KIC 10924562"
{
	RA      19.59267853
	Dec     48.336121
	Dist    2081
	AppMagn 15.665
	MassSol 1.15
	RadSol  1.23
	Teff    6194
	FeH     0
}

Star	"Kepler-1423/KOI-3071/KIC 5865654"
{
	RA      19.21625213
	Dec     41.110081
	Dist    449
	AppMagn 14.553
	MassSol 0.79
	RadSol  0.75
	Teff    4939
	FeH    -0.02
}

Star	"Kepler-1424/KOI-3093/KIC 5096590"
{
	RA      19.39944433
	Dec     40.22932
	Dist    620
	AppMagn 13.619
	MassSol 1.02
	RadSol  1.07
	Teff    5838
	FeH     0.01
}

Star	"Kepler-1425/KOI-3096/KIC 7455981"
{
	RA      19.6634024
	Dec     43.012436
	Dist    499
	AppMagn 13.572
	MassSol 0.97
	RadSol  0.95
	Teff    5718
	FeH    -0.03
}

Star	"Kepler-1426/KOI-3101/KIC 11508644"
{
	RA      19.50305093
	Dec     49.416973
	Dist    1211
	AppMagn 15.192
	MassSol 1.02
	RadSol  1.02
	Teff    5831
	FeH     0.03
}

Star	"Kepler-1427/KOI-3106/KIC 8895758"
{
	RA      19.6899778
	Dec     45.114548
	Dist    1220
	AppMagn 15.415
	MassSol 1.01
	RadSol  1.01
	Teff    5793
	FeH     0.06
}

Star	"Kepler-1428/KOI-3109/KIC 11572193"
{
	RA      19.84281747
	Dec     49.594978
	Dist    802
	AppMagn 13.688
	MassSol 1.28
	RadSol  1.36
	Teff    6184
	FeH     0.35
}

Star	"Kepler-1429/KOI-3110/KIC 11285870"
{
	RA      19.02441633
	Dec     49.044868
	Dist    1156
	AppMagn 14.879
	MassSol 1.05
	RadSol  1.07
	Teff    5902
	FeH     0.04
}

Star	"Kepler-143/KOI-352/KIC 11521793"
{
	RA      19.87118123
	Dec     49.412605
	AppMagn 13.77
	MassSol 0.987
	RadSol  1.36
	Teff    5848
	FeH    -0.167
}

Star	"Kepler-1430/KOI-3113/KIC 7676423"
{
	RA      19.31316627
	Dec     43.372093
	Dist    541
	AppMagn 15.245
	MassSol 0.77
	RadSol  0.72
	Teff    4796
	FeH    -0.03
}

Star	"Kepler-1431/KOI-3115/KIC 11714231"
{
	RA      19.51055967
	Dec     49.865192
	Dist    1270
	AppMagn 15.273
	MassSol 1.03
	RadSol  1.03
	Teff    5806
	FeH     0.07
}

Star	"Kepler-1432/KOI-3116/KIC 11720424"
{
	RA      19.70161167
	Dec     49.829548
	Dist    1552
	AppMagn 15.376
	MassSol 1.09
	RadSol  1.13
	Teff    6031
	FeH     0.02
}

Star	"Kepler-1433/KOI-3120/KIC 11499192"
{
	RA      19.15755327
	Dec     49.45689
	Dist    1328
	AppMagn 14.826
	MassSol 1.14
	RadSol  1.19
	Teff    6097
	FeH     0.07
}

Star	"Kepler-1434/KOI-3122/KIC 12416661"
{
	RA      19.70255867
	Dec     51.202957
	Dist    680
	AppMagn 12.086
	MassSol 1.47
	RadSol  2.04
	Teff    6291
	FeH     0.19
}

Star	"Kepler-1435/KOI-3125/KIC 8751796"
{
	RA      19.41155327
	Dec     44.921131
	Dist    681
	AppMagn 12.938
	MassSol 1.21
	RadSol  1.32
	Teff    6356
	FeH    -0.03
}

Star	"Kepler-1436/KOI-3127/KIC 9907129"
{
	RA      19.84743767
	Dec     46.768021
	Dist    1142
	AppMagn 14.93
	MassSol 1.06
	RadSol  1.09
	Teff    5972
	FeH    -0.01
}

Star	"Kepler-1437/KOI-3131/KIC 11455181"
{
	RA      19.457662
	Dec     49.32592
	Dist    1182
	AppMagn 15.591
	MassSol 0.93
	RadSol  0.9
	Teff    5557
	FeH    -0.02
}

Star	"Kepler-1438/KOI-3141/KIC 5440317"
{
	RA      19.28598727
	Dec     40.681665
	Dist    866
	AppMagn 14.869
	MassSol 0.97
	RadSol  0.96
	Teff    5530
	FeH     0.2
}

Star	"Kepler-1439/KOI-3144/KIC 5688790"
{
	RA      19.0493204
	Dec     40.980036
	Dist    215
	AppMagn 16.109
	MassSol 0.46
	RadSol  0.43
	Teff    3578
	FeH    -0.03
}

Star	"Kepler-144/KOI-369/KIC 7175184"
{
	RA      18.79437866
	Dec     42.775513
	AppMagn 11.992
	MassSol 1.03
	RadSol  1.24
	Teff    6075
	FeH    -0.326
}

Star	"Kepler-1440/KOI-3146/KIC 10908248"
{
	RA      19.0231292
	Dec     48.312252
	Dist    685
	AppMagn 14.131
	MassSol 0.98
	RadSol  0.96
	Teff    5698
	FeH     0.04
}

Star	"Kepler-1441/KOI-3147/KIC 7534267"
{
	RA      19.58127507
	Dec     43.12459
	Dist    751
	AppMagn 14.268
	MassSol 1
	RadSol  1
	Teff    5802
	FeH     0.01
}

Star	"Kepler-1442"
{
	RA      19.41703967
	Dec     48.84697
	Dist    525
	AppMagn 11.031 // not V mag
	MassSol 1.34
	RadSol  1.44
	Teff    6394
	FeH     0.26
}

Star	"Kepler-1443/KOI-3234/KIC 10057494"
{
	RA      18.8957174
	Dec     47.066855
	Dist    475
	AppMagn 12.278
	MassSol 1.19
	RadSol  1.27
	Teff    6289
	FeH     0
}

Star	"Kepler-1444/KOI-3237/KIC 6587796"
{
	RA      19.022041
	Dec     42.040436
	Dist    340
	AppMagn 12.325
	MassSol 1.03
	RadSol  1.05
	Teff    5810
	FeH     0.06
}

Star	"Kepler-1445/KOI-3245/KIC 8073705"
{
	RA      18.68329713
	Dec     43.915066
	Dist    482
	AppMagn 12.405
	MassSol 1.13
	RadSol  1.26
	Teff    6150
	FeH    -0.03
}

Star	"Kepler-1446/KOI-3246/KIC 9885417"
{
	RA      19.29493067
	Dec     46.72617
	Dist    162
	AppMagn 12.411
	MassSol 0.81
	RadSol  0.75
	Teff    4865
	FeH     0.11
}

Star	"Kepler-1447/KOI-3260/KIC 12156174"
{
	RA      19.3095626
	Dec     50.727089
	Dist    871
	AppMagn 14.682
	MassSol 0.97
	RadSol  0.95
	Teff    5722
	FeH    -0.03
}

Star	"Kepler-1448/KOI-3261/KIC 12055539"
{
	RA      19.19115927
	Dec     50.595585
	Dist    786
	AppMagn 14.411
	MassSol 0.95
	RadSol  0.93
	Teff    5774
	FeH    -0.16
}

Star	"Kepler-1449/KOI-3262/KIC 12056139"
{
	RA      19.21544873
	Dec     50.567886
	Dist    1321
	AppMagn 15.05
	MassSol 1.08
	RadSol  1.1
	Teff    5979
	FeH     0.04
}

Star	"Kepler-145/KOI-370/KIC 8494142"
{
	RA      19.42583333
	Dec     44.5292
	Dist    584.1
	AppMagn 11.93
	MassSol 1.418
	RadSol  1.887
	Teff    6144
	FeH     0.13
	Age     2.62
}

Star	"Kepler-1450/KOI-3266/KIC 8826007"
{
	RA      19.63692187
	Dec     45.08139
	Dist    490
	AppMagn 15.498
	MassSol 0.71
	RadSol  0.68
	Teff    4524
	FeH    -0.02
}

Star	"Kepler-1451/KOI-3274/KIC 5280587"
{
	RA      19.563095
	Dec     40.409892
	Dist    1159
	AppMagn 15.332
	MassSol 1
	RadSol  0.99
	Teff    5782
	FeH     0.01
}

Star	"Kepler-1452/KOI-3277/KIC 3120904"
{
	RA      19.49485533
	Dec     38.266328
	Dist    974
	AppMagn 13.062
	MassSol 1.41
	RadSol  2.06
	Teff    6101
	FeH     0.14
}

Star	"Kepler-1453/KOI-3280/KIC 10653179"
{
	RA      19.07503633
	Dec     47.947613
	Dist    1284
	AppMagn 15.57
	MassSol 0.97
	RadSol  0.94
	Teff    5665
	FeH     0.01
}

Star	"Kepler-1454/KOI-3281/KIC 11177676"
{
	RA      18.94822207
	Dec     48.831772
	Dist    795
	AppMagn 14.904
	MassSol 0.9
	RadSol  0.86
	Teff    5448
	FeH    -0.02
}

Star	"Kepler-1455/KOI-3282/KIC 12066569"
{
	RA      19.605537
	Dec     50.502777
	Dist    392
	AppMagn 15.855
	MassSol 0.62
	RadSol  0.6
	Teff    4075
	FeH    -0.02
}

Star	"Kepler-1456/KOI-3286/KIC 8016691"
{
	RA      19.12968807
	Dec     43.822773
	Dist    379
	AppMagn 15.464
	MassSol 0.64
	RadSol  0.62
	Teff    4231
	FeH    -0.09
}

Star	"Kepler-1457/KOI-3287/KIC 6584273"
{
	RA      18.91804007
	Dec     42.027245
	Dist    728
	AppMagn 14.06
	MassSol 1.01
	RadSol  1.01
	Teff    5866
	FeH    -0.05
}

Star	"Kepler-1458/KOI-3288/KIC 5768816"
{
	RA      18.88077427
	Dec     41.038063
	Dist    642
	AppMagn 14.19
	MassSol 0.96
	RadSol  0.94
	Teff    5653
	FeH     0.02
}

Star	"Kepler-1459/KOI-3296/KIC 9447166"
{
	RA      18.82820167
	Dec     46.014019
	Dist    435
	AppMagn 14.591
	MassSol 0.78
	RadSol  0.74
	Teff    4828
	FeH     0.01
}

Star	"Kepler-146/KOI-386/KIC 3656121"
{
	RA      19.60738322
	Dec     38.710228
	AppMagn 13.838
	MassSol 0.986
	RadSol  1.21
	Teff    5948
	FeH    -0.302
}

Star	"Kepler-1460/KOI-3298/KIC 8151055"
{
	RA      19.0371864
	Dec     44.010788
	Dist    574
	AppMagn 15.947
	MassSol 0.7
	RadSol  0.67
	Teff    4422
	FeH    -0.02
}

Star	"Kepler-1461/KOI-3303/KIC 7510820"
{
	RA      19.05536387
	Dec     43.198395
	Dist    752
	AppMagn 15.689
	MassSol 0.79
	RadSol  0.74
	Teff    4919
	FeH    -0.04
}

Star	"Kepler-1462/KOI-3305/KIC 6880517"
{
	RA      19.75983513
	Dec     42.396918
	Dist    1368
	AppMagn 15.858
	MassSol 1
	RadSol  1
	Teff    5756
	FeH     0.06
}

Star	"Kepler-1463/KOI-3306/KIC 6615511"
{
	RA      19.63248693
	Dec     42.00692
	Dist    1341
	AppMagn 15.759
	MassSol 0.96
	RadSol  0.95
	Teff    5679
	FeH     0
}

Star	"Kepler-1464/KOI-3308/KIC 3632089"
{
	RA      19.14904513
	Dec     38.754161
	Dist    692
	AppMagn 14.159
	MassSol 1.02
	RadSol  1.01
	Teff    5828
	FeH     0.03
}

Star	"Kepler-1465/KOI-3311/KIC 12735830"
{
	RA      19.3212894
	Dec     51.90485
	Dist    350
	AppMagn 14.41
	MassSol 0.75
	RadSol  0.71
	Teff    4726
	FeH    -0.06
}

Star	"Kepler-1466/KOI-3315/KIC 8554701"
{
	RA      19.32208147
	Dec     44.609863
	Dist    686
	AppMagn 13.926
	MassSol 1.01
	RadSol  1.02
	Teff    5884
	FeH    -0.07
}

Star	"Kepler-1467/KOI-3316/KIC 9031209"
{
	RA      19.66990267
	Dec     45.342686
	Dist    890
	AppMagn 15.549
	MassSol 0.86
	RadSol  0.82
	Teff    5332
	FeH    -0.07
}

Star	"Kepler-1468/KOI-3319/KIC 5965819"
{
	RA      19.5679896
	Dec     41.277405
	Dist    1130
	AppMagn 15.024
	MassSol 1.04
	RadSol  1.05
	Teff    5893
	FeH     0.03
}

Star	"Kepler-1469/KOI-3324/KIC 4271474"
{
	RA      19.58809047
	Dec     39.39135
	Dist    1255
	AppMagn 15.965
	MassSol 0.92
	RadSol  0.89
	Teff    5507
	FeH     0.02
}

Star	"Kepler-147/KOI-392/KIC 3942670"
{
	RA      19.1983846
	Dec     39.087181
	AppMagn 13.954
	MassSol 1.01
	RadSol  1.47
	Teff    6012
	FeH     0.078
}

Star	"Kepler-1470/KOI-3330/KIC 4736644"
{
	RA      19.2463338
	Dec     39.883191
	Dist    569
	AppMagn 15.061
	MassSol 0.8
	RadSol  0.76
	Teff    4961
	FeH    -0.01
}

Star	"Kepler-1471/KOI-3344/KIC 11810124"
{
	RA      19.31099187
	Dec     50.020046
	Dist    1059
	AppMagn 15.254
	MassSol 0.95
	RadSol  0.93
	Teff    5660
	FeH    -0.03
}

Star	"Kepler-1472/KOI-3345/KIC 11303322"
{
	RA      19.6568432
	Dec     49.057472
	Dist    1269
	AppMagn 14.633
	MassSol 1.16
	RadSol  1.25
	Teff    6159
	FeH     0.03
}

Star	"Kepler-1473/KOI-3346/KIC 11241912"
{
	RA      19.37577127
	Dec     48.996082
	Dist    625
	AppMagn 13.359
	MassSol 1.09
	RadSol  1.09
	Teff    6046
	FeH    -0.01
}

Star	"Kepler-1474/KOI-3348/KIC 9349757"
{
	RA      19.64626993
	Dec     45.866837
	Dist    1214
	AppMagn 15.246
	MassSol 1.04
	RadSol  1.04
	Teff    5870
	FeH     0.04
}

Star	"Kepler-1475/KOI-3349/KIC 8636333"
{
	RA      19.72988487
	Dec     44.753124
	Dist    1714
	AppMagn 15.292
	MassSol 1.18
	RadSol  1.28
	Teff    6214
	FeH     0.03
}

Star	"Kepler-1476/KOI-3352/KIC 8081239"
{
	RA      18.9688064
	Dec     43.989956
	Dist    1218
	AppMagn 15.408
	MassSol 0.98
	RadSol  0.96
	Teff    5663
	FeH     0.06
}

Star	"Kepler-1477/KOI-3353/KIC 7091432"
{
	RA      18.75323567
	Dec     42.685753
	Dist    525
	AppMagn 14.598
	MassSol 0.81
	RadSol  0.78
	Teff    5100
	FeH    -0.06
}

Star	"Kepler-1478/KOI-3356/KIC 6368230"
{
	RA      19.5443386
	Dec     41.746235
	Dist    1405
	AppMagn 15.44
	MassSol 1.04
	RadSol  1.06
	Teff    5904
	FeH     0.03
}

Star	"Kepler-1479/KOI-3363/KIC 11651712"
{
	RA      19.04746127
	Dec     49.706657
	Dist    619
	AppMagn 13.785
	MassSol 0.99
	RadSol  0.98
	Teff    5796
	FeH    -0.02
}

Star	"Kepler-148/KOI-398/KIC 9946525"
{
	RA      19.31908162
	Dec     46.858788
	AppMagn 15.342
	MassSol 0.893
	RadSol  0.85
	Teff    5272
	FeH     0.143
}

Star	"Kepler-1480/KOI-3365/KIC 11455428"
{
	RA      19.4666514
	Dec     49.301811
	Dist    540
	AppMagn 14.523
	MassSol 0.85
	RadSol  0.81
	Teff    5156
	FeH     0.07
}

Star	"Kepler-1481/KOI-3370/KIC 11657614"
{
	RA      19.2959314
	Dec     49.73122
	Dist    493
	AppMagn 14.779
	MassSol 0.8
	RadSol  0.75
	Teff    4908
	FeH     0.04
}

Star	"Kepler-1482/KOI-3371/KIC 11125797"
{
	RA      19.02092033
	Dec     48.725254
	Dist    442
	AppMagn 13.747
	MassSol 0.88
	RadSol  0.84
	Teff    5381
	FeH    -0.04
}

Star	"Kepler-1483/KOI-3374/KIC 6705026"
{
	RA      19.69398507
	Dec     42.150831
	Dist    1327
	AppMagn 14.44
	MassSol 1.25
	RadSol  1.4
	Teff    6337
	FeH     0.04
}

Star	"Kepler-1484/KOI-3379/KIC 2995392"
{
	RA      19.51228567
	Dec     38.126286
	Dist    1095
	AppMagn 15.268
	MassSol 0.94
	RadSol  0.92
	Teff    5730
	FeH    -0.17
}

Star	"Kepler-1485/KOI-3384/KIC 8644365"
{
	RA      19.8730282
	Dec     44.737057
	Dist    550
	AppMagn 13.204
	MassSol 1.11
	RadSol  1.12
	Teff    6087
	FeH     0.02
}

Star	"Kepler-1486/KOI-3393/KIC 9085563"
{
	RA      19.37269213
	Dec     45.439713
	Dist    1465
	AppMagn 15.335
	MassSol 1.08
	RadSol  1.12
	Teff    5965
	FeH     0.06
}

Star	"Kepler-1487/KOI-3398/KIC 3561464"
{
	RA      19.69987387
	Dec     38.644501
	Dist    1094
	AppMagn 13.489
	MassSol 1.38
	RadSol  1.63
	Teff    6541
	FeH     0.04
}

Star	"Kepler-1488/KOI-3403/KIC 11754430"
{
	RA      19.10976113
	Dec     49.937778
	Dist    618
	AppMagn 13.102
	MassSol 1.05
	RadSol  1.31
	Teff    5820
	FeH     0.06
}

Star	"Kepler-1489/KOI-3404/KIC 8409295"
{
	RA      18.7530554
	Dec     44.465405
	Dist    870
	AppMagn 14.828
	MassSol 0.93
	RadSol  0.9
	Teff    5655
	FeH    -0.13
}

Star	"Kepler-149/KOI-401/KIC 3217264"
{
	RA      19.05691121
	Dec     38.384121
	AppMagn 14.001
	MassSol 0.848
	RadSol  0.95
	Teff    5381
	FeH     0.147
}

Star	"Kepler-1490/KOI-3407/KIC 7131760"
{
	RA      19.71290487
	Dec     42.609512
	Dist    968
	AppMagn 15.449
	MassSol 0.9
	RadSol  0.87
	Teff    5515
	FeH    -0.08
}

Star	"Kepler-1491/KOI-3410/KIC 9285265"
{
	RA      19.57531707
	Dec     45.740651
	Dist    1312
	AppMagn 15.589
	MassSol 1
	RadSol  0.99
	Teff    5728
	FeH     0.06
}

Star	"Kepler-1492/KOI-3412/KIC 5780930"
{
	RA      19.23980647
	Dec     41.03642
	Dist    371
	AppMagn 14.534
	MassSol 0.77
	RadSol  0.72
	Teff    4712
	FeH     0.06
}

Star	"Kepler-1493/KOI-3415/KIC 3433668"
{
	RA      19.23660987
	Dec     38.565232
	Dist    572
	AppMagn 13.109
	MassSol 1.06
	RadSol  1.29
	Teff    5863
	FeH     0.06
}

Star	"Kepler-1494/KOI-3417/KIC 7503885"
{
	RA      18.84382673
	Dec     43.162518
	Dist    1059
	AppMagn 15.214
	MassSol 0.96
	RadSol  0.94
	Teff    5659
	FeH     0.01
}

Star	"Kepler-1495/KOI-3418/KIC 3629330"
{
	RA      19.0753838
	Dec     38.779631
	Dist    1307
	AppMagn 15.417
	MassSol 1.03
	RadSol  1.04
	Teff    5831
	FeH     0.06
}

Star	"Kepler-1496/KOI-3428/KIC 9027909"
{
	RA      19.5982624
	Dec     45.350704
	Dist    1293
	AppMagn 14.694
	MassSol 1.18
	RadSol  1.27
	Teff    6182
	FeH     0.05
}

Star	"Kepler-1497/KOI-3429/KIC 9230021"
{
	RA      19.74640933
	Dec     45.634331
	Dist    1122
	AppMagn 15.364
	MassSol 0.96
	RadSol  0.95
	Teff    5675
	FeH     0.01
}

Star	"Kepler-1498/KOI-3432/KIC 8738775"
{
	RA      18.98520733
	Dec     44.916782
	Dist    740
	AppMagn 15.033
	MassSol 0.86
	RadSol  0.81
	Teff    5256
	FeH    -0.01
}

Star	"Kepler-1499/KOI-3436/KIC 6265665"
{
	RA      18.93242247
	Dec     41.650406
	Dist    310
	AppMagn 13.509
	MassSol 0.82
	RadSol  0.78
	Teff    5097
	FeH    -0.01
}

Star	"Kepler-15/KOI-128/KIC 11359879"
{
	RA      19.74670613
	Dec     49.140125
	AppMagn 13.8
	MassSol 1.018
	RadSol  0.992
	Teff    5595
	FeH     0.36
}

Star	"Kepler-150/KOI-408/KIC 5351250"
{
	RA      19.21560465
	Dec     40.520905
	AppMagn 14.985
	MassSol 0.963
	RadSol  0.94
	Teff    5560
	FeH    -0.136
}

Star	"Kepler-1500/KOI-3437/KIC 4645174"
{
	RA      19.25888893
	Dec     39.744572
	Dist    904
	AppMagn 14.606
	MassSol 1
	RadSol  1
	Teff    5845
	FeH    -0.05
}

Star	"Kepler-1501/KOI-3438/KIC 6599975"
{
	RA      19.32790127
	Dec     42.001431
	Dist    888
	AppMagn 13.71
	MassSol 1.2
	RadSol  1.3
	Teff    6229
	FeH     0.04
}

Star	"Kepler-1502/KOI-3439/KIC 4282191"
{
	RA      19.74052793
	Dec     39.319913
	Dist    1540
	AppMagn 14.155
	MassSol 1.44
	RadSol  1.72
	Teff    6666
	FeH     0.05
}

Star	"Kepler-1503/KOI-3443/KIC 7288306"
{
	RA      19.58181167
	Dec     42.806759
	Dist    850
	AppMagn 15.796
	MassSol 0.77
	RadSol  0.74
	Teff    5069
	FeH    -0.19
}

Star	"Kepler-1504/KOI-3445/KIC 11860395"
{
	RA      19.31413287
	Dec     50.128212
	Dist    1029
	AppMagn 15.654
	MassSol 0.85
	RadSol  0.81
	Teff    5393
	FeH    -0.17
}

Star	"Kepler-1505/KOI-3456/KIC 6364582"
{
	RA      19.46680347
	Dec     41.786961
	Dist    359
	AppMagn 12.988
	MassSol 0.93
	RadSol  0.86
	Teff    5686
	FeH    -0.18
}

Star	"Kepler-1506/KOI-3458/KIC 6118370"
{
	RA      19.3433256
	Dec     41.464595
	Dist    1318
	AppMagn 15.652
	MassSol 0.95
	RadSol  0.93
	Teff    5676
	FeH    -0.05
}

Star	"Kepler-1507/KOI-3465/KIC 9763612"
{
	RA      19.237435
	Dec     46.536053
	Dist    342
	AppMagn 13.136
	MassSol 0.89
	RadSol  0.85
	Teff    5410
	FeH    -0.03
}

Star	"Kepler-1508/KOI-3468/KIC 5213404"
{
	RA      19.87459233
	Dec     40.375047
	Dist    892
	AppMagn 14.276
	MassSol 1.14
	RadSol  1.22
	Teff    6158
	FeH     0.01
}

Star	"Kepler-1509/KOI-3470/KIC 9995771"
{
	RA      18.9198542
	Dec     46.931004
	Dist    1277
	AppMagn 15.386
	MassSol 1
	RadSol  0.99
	Teff    5780
	FeH     0.03
}

Star	"Kepler-151/KOI-413/KIC 5791986"
{
	RA      19.47751872
	Dec     41.023235
	AppMagn 14.769
	MassSol 0.83
	RadSol  0.83
	Teff    5460
	FeH    -0.102
}

Star	"Kepler-1510/KOI-3484/KIC 10881457"
{
	RA      19.9306092
	Dec     48.257824
	Dist    1615
	AppMagn 15.169
	MassSol 1.19
	RadSol  1.28
	Teff    6200
	FeH     0.04
}

Star	"Kepler-1511/KOI-3496/KIC 7517261"
{
	RA      19.2280812
	Dec     43.179798
	Dist    897
	AppMagn 13.932
	MassSol 1.17
	RadSol  1.29
	Teff    6064
	FeH     0.14
}

Star	"Kepler-1512/KOI-3497/KIC 8424002"
{
	RA      19.28496687
	Dec     44.470253
	Dist    162
	AppMagn 13.393
	MassSol 0.73
	RadSol  0.67
	Teff    4372
	FeH     0.2
}

Star	"Kepler-1513/KOI-3678/KIC 4150804"
{
	RA      19.31944227
	Dec     39.285277
	Dist    384
	AppMagn 12.888
	MassSol 0.99
	RadSol  0.97
	Teff    5617
	FeH     0.14
}

Star	"Kepler-1514/KOI-3681/KIC 2581316"
{
	RA      19.50849773
	Dec     37.860133
	Dist    379
	AppMagn 11.69
	MassSol 1.21
	RadSol  1.22
	Teff    6251
	FeH     0.14
}

Star	"Kepler-1515/KOI-3683/KIC 10795103"
{
	RA      19.398262
	Dec     48.178162
	Dist    504
	AppMagn 12.04
	MassSol 1.3
	RadSol  1.41
	Teff    6511
	FeH     0.07
}

Star	"Kepler-1516/KOI-3685/KIC 8494410"
{
	RA      19.43297353
	Dec     44.523502
	Dist    872
	AppMagn 14.461
	MassSol 1.04
	RadSol  1.07
	Teff    5904
	FeH     0.03
}

Star	"Kepler-1517/KOI-3728/KIC 7515679"
{
	RA      19.187148
	Dec     43.188778
	Dist    869
	AppMagn 12.252
	MassSol 1.58
	RadSol  1.95
	Teff    7010
	FeH     0.01
}

Star	"Kepler-1518/KOI-3741/KIC 8780959"
{
	RA      20.022159
	Dec     44.986137
	Dist    1140
	AppMagn 13.306
	MassSol 1.54
	RadSol  1.88
	Teff    6846
	FeH     0.06
}

Star	"Kepler-1519/KOI-3762/KIC 11518142"
{
	RA      19.7778602
	Dec     49.461861
	Dist    858
	AppMagn 14.822
	MassSol 0.94
	RadSol  0.91
	Teff    5644
	FeH    -0.07
}

Star	"Kepler-152/KOI-416/KIC 6508221"
{
	RA      19.12436523
	Dec     41.989086
	AppMagn 14.29
	MassSol 0.846
	RadSol  0.72
	Teff    5088
	FeH    -0.138
}

Star	"Kepler-1520/KOI-3794/KIC 12557548"
{
	RA      19.3977476
	Dec     51.504723
	Dist    636
	AppMagn 16
	Class  "K4V"
	MassSol 0.76
	RadSol  0.71
	Teff    4677
	FeH     0.04
}

Star	"Kepler-1521/KOI-3835/KIC 2581554"
{
	RA      19.51268673
	Dec     37.835001
	Dist    227
	AppMagn 12.86
	MassSol 0.81
	RadSol  0.76
	Teff    5042
	FeH    -0.05
}

Star	"Kepler-1522/KOI-3848/KIC 12784167"
{
	RA      19.32288173
	Dec     52.07016
	Dist    690
	AppMagn 14.216
	MassSol 0.96
	RadSol  0.93
	Teff    5706
	FeH    -0.07
}

Star	"Kepler-1523/KOI-3867/KIC 9353742"
{
	RA      19.73693747
	Dec     45.827049
	Dist    918
	AppMagn 14.86
	MassSol 0.97
	RadSol  0.96
	Teff    5708
	FeH     0
}

Star	"Kepler-1524/KOI-3878/KIC 4472818"
{
	RA      19.59235987
	Dec     39.519818
	Dist    506
	AppMagn 12.72
	MassSol 1.17
	RadSol  1.25
	Teff    6179
	FeH     0.04
}

Star	"Kepler-1525/KOI-3892/KIC 11760860"
{
	RA      19.37063447
	Dec     49.943016
	Dist    396
	AppMagn 12.737
	MassSol 1.07
	RadSol  1.04
	Teff    5748
	FeH     0.27
}

Star	"Kepler-1526/KOI-3893/KIC 3728432"
{
	RA      19.0079804
	Dec     38.866428
	Dist    576
	AppMagn 15.646
	MassSol 0.73
	RadSol  0.69
	Teff    4601
	FeH    -0.01
}

Star	"Kepler-1527/KOI-3901/KIC 9480535"
{
	RA      19.8276276
	Dec     46.060818
	Dist    1560
	AppMagn 15.13
	MassSol 1.21
	RadSol  1.32
	Teff    6224
	FeH     0.07
}

Star	"Kepler-1528/KOI-3911/KIC 9761615"
{
	RA      19.1601962
	Dec     46.573986
	Dist    916
	AppMagn 14.496
	MassSol 1.03
	RadSol  1.03
	Teff    5857
	FeH     0.03
}

Star	"Kepler-1529/KOI-3916/KIC 5784777"
{
	RA      19.3247144
	Dec     41.040728
	Dist    683
	AppMagn 15.362
	MassSol 0.81
	RadSol  0.77
	Teff    5048
	FeH    -0.03
}

Star	"Kepler-153/KOI-431/KIC 10843590"
{
	RA      18.83070068
	Dec     48.257118
	AppMagn 14.262
	MassSol 0.774
	RadSol  0.89
	Teff    5404
	FeH    -0.255
}

Star	"Kepler-1530/KOI-3925/KIC 10788461"
{
	RA      19.21083347
	Dec     48.165154
	Dist    552
	AppMagn 14.026
	MassSol 0.92
	RadSol  0.88
	Teff    5477
	FeH     0.03
}

Star	"Kepler-1531/KOI-3928/KIC 4242692"
{
	RA      19.0097718
	Dec     39.370798
	Dist    670
	AppMagn 13.194
	MassSol 1.16
	RadSol  1.27
	Teff    6260
	FeH    -0.03
}

Star	"Kepler-1532/KOI-3935/KIC 5895158"
{
	RA      19.79352087
	Dec     41.198191
	Dist    824
	AppMagn 14.815
	MassSol 0.91
	RadSol  0.88
	Teff    5559
	FeH    -0.1
}

Star	"Kepler-1533/KOI-3946/KIC 8636434"
{
	RA      19.73170373
	Dec     44.713445
	Dist    852
	AppMagn 13.215
	MassSol 1.31
	RadSol  1.51
	Teff    6431
	FeH     0.03
}

Star	"Kepler-1534/KOI-3954/KIC 8030339"
{
	RA      19.49302607
	Dec     43.869072
	Dist    1107
	AppMagn 15.665
	MassSol 0.9
	RadSol  0.86
	Teff    5442
	FeH    -0.01
}

Star	"Kepler-1535/KOI-3966/KIC 3732035"
{
	RA      19.10757987
	Dec     38.891969
	Dist    879
	AppMagn 14.208
	MassSol 1.08
	RadSol  1.11
	Teff    6021
	FeH     0
}

Star	"Kepler-1536/KOI-3975/KIC 9280239"
{
	RA      19.43901247
	Dec     45.71579
	Dist    401
	AppMagn 15.188
	MassSol 0.71
	RadSol  0.67
	Teff    4434
	FeH     0.05
}

Star	"Kepler-1537/KOI-3984/KIC 8036287"
{
	RA      19.6256932
	Dec     43.82547
	Dist    503
	AppMagn 14.536
	MassSol 0.81
	RadSol  0.77
	Teff    5079
	FeH    -0.08
}

Star	"Kepler-1538/KOI-4009/KIC 8934103"
{
	RA      18.88971427
	Dec     45.274456
	Dist    1291
	AppMagn 15.245
	MassSol 1.03
	RadSol  1.03
	Teff    5837
	FeH     0.02
}

Star	"Kepler-1539/KOI-4015/KIC 8282846"
{
	RA      18.9479622
	Dec     44.268543
	Dist    788
	AppMagn 15.307
	MassSol 0.84
	RadSol  0.8
	Teff    5176
	FeH    -0.01
}

Star	"Kepler-154/KOI-435/KIC 11709124"
{
	RA      19.31870117
	Dec     49.89653
	AppMagn 14.534
	MassSol 0.89
	RadSol  1
	Teff    5690
	FeH    -0.391
}

Star	"Kepler-1540/KOI-4016/KIC 5938970"
{
	RA      18.88963313
	Dec     41.201741
	Dist    262
	AppMagn 14.073
	MassSol 0.74
	RadSol  0.69
	Teff    4540
	FeH     0.1
}

Star	"Kepler-1541/KOI-4024/KIC 10714072"
{
	RA      18.9191336
	Dec     48.029564
	Dist    414
	AppMagn 13.801
	MassSol 0.86
	RadSol  0.81
	Teff    5282
	FeH    -0.04
}

Star	"Kepler-1542/KOI-4032/KIC 7100673"
{
	RA      19.04856633
	Dec     42.65453
	Dist    336
	AppMagn 12.639
	MassSol 0.94
	RadSol  0.99
	Teff    5564
	FeH     0.06
}

Star	"Kepler-1543/KOI-4034/KIC 10089911"
{
	RA      19.80828747
	Dec     47.037025
	Dist    1114
	AppMagn 13.487
	MassSol 1.39
	RadSol  1.65
	Teff    6561
	FeH     0.07
}

Star	"Kepler-1544/KOI-4036/KIC 11415243"
{
	RA      19.81899933
	Dec     49.212456
	Dist    349
	AppMagn 14.061
	MassSol 0.81
	RadSol  0.74
	Teff    4886
	FeH     0.02
}

Star	"Kepler-1545/KOI-4051/KIC 10360722"
{
	RA      19.9265842
	Dec     47.463093
	Dist    688
	AppMagn 15.031
	MassSol 0.84
	RadSol  0.8
	Teff    5201
	FeH    -0.06
}

Star	"Kepler-1546/KOI-4068/KIC 6226908"
{
	RA      19.83892947
	Dec     41.541227
	Dist    994
	AppMagn 15.412
	MassSol 0.95
	RadSol  0.93
	Teff    5623
	FeH     0.01
}

Star	"Kepler-1547/KOI-4072/KIC 6755944"
{
	RA      18.91760493
	Dec     42.222172
	Dist    665
	AppMagn 13.447
	MassSol 1.12
	RadSol  1.18
	Teff    6078
	FeH     0.04
}

Star	"Kepler-1548/KOI-4076/KIC 9455677"
{
	RA      19.16474887
	Dec     46.080666
	Dist    1150
	AppMagn 15.259
	MassSol 0.99
	RadSol  0.97
	Teff    5706
	FeH     0.05
}

Star	"Kepler-1549/KOI-4084/KIC 3937814"
{
	RA      19.07016173
	Dec     39.096053
	Dist    792
	AppMagn 15.188
	MassSol 0.88
	RadSol  0.84
	Teff    5324
	FeH     0.02
}

Star	"Kepler-155/KOI-438/KIC 12302530"
{
	RA      19.23305461
	Dec     51.081947
	AppMagn 14.258
	MassSol 0.58
	RadSol  0.62
	Teff    4508
	FeH    -0.363
}

Star	"Kepler-1550/KOI-4091/KIC 3103227"
{
	RA      19.184304
	Dec     38.294704
	Dist    1202
	AppMagn 14.9
	MassSol 1.07
	RadSol  1.11
	Teff    5991
	FeH     0.01
}

Star	"Kepler-1551/KOI-4092/KIC 4850961"
{
	RA      19.71903427
	Dec     39.907921
	Dist    1560
	AppMagn 15.152
	MassSol 1.14
	RadSol  1.22
	Teff    6136
	FeH     0.01
}

Star	"Kepler-1552/KOI-4103/KIC 3747817"
{
	RA      19.44512207
	Dec     38.874915
	Dist    618
	AppMagn 14.838
	MassSol 0.85
	RadSol  0.78
	Teff    5202
	FeH    -0.07
}

Star	"Kepler-1553/KOI-4117/KIC 3955817"
{
	RA      19.46127727
	Dec     39.022273
	Dist    719
	AppMagn 14.955
	MassSol 0.85
	RadSol  0.81
	Teff    5288
	FeH    -0.09
}

Star	"Kepler-1554/KOI-4121/KIC 6349881"
{
	RA      19.1050776
	Dec     41.741473
	Dist    982
	AppMagn 15.717
	MassSol 0.84
	RadSol  0.81
	Teff    5297
	FeH    -0.1
}

Star	"Kepler-1555/KOI-4126/KIC 9272070"
{
	RA      19.1756982
	Dec     45.716061
	Dist    1382
	AppMagn 15.353
	MassSol 1.04
	RadSol  1.06
	Teff    5866
	FeH     0.03
}

Star	"Kepler-1556/KOI-4127/KIC 5088400"
{
	RA      19.2264668
	Dec     40.2132
	Dist    1060
	AppMagn 15.247
	MassSol 0.97
	RadSol  0.95
	Teff    5608
	FeH     0.08
}

Star	"Kepler-1557/KOI-4139/KIC 9956082"
{
	RA      19.5920942
	Dec     46.838879
	Dist    1532
	AppMagn 15.331
	MassSol 1.11
	RadSol  1.17
	Teff    6099
	FeH     0.02
}

Star	"Kepler-1558/KOI-4146/KIC 10000941"
{
	RA      19.12129113
	Dec     46.911694
	Dist    343
	AppMagn 13.632
	MassSol 0.83
	RadSol  0.79
	Teff    5101
	FeH     0
}

Star	"Kepler-1559/KOI-4159/KIC 6607644"
{
	RA      19.485772
	Dec     42.072456
	Dist    580
	AppMagn 14.5
	MassSol 0.86
	RadSol  0.82
	Teff    5316
	FeH    -0.04
}

Star	"Kepler-156/KOI-440/KIC 2438264"
{
	RA      19.35310059
	Dec     37.749489
	AppMagn 14.172
	MassSol 0.801
	RadSol  0.81
	Teff    5094
	FeH    -0.014
}

Star	"Kepler-1560/KOI-4160/KIC 7610663"
{
	RA      19.51897387
	Dec     43.215984
	Dist    529
	AppMagn 13.421
	MassSol 1.02
	RadSol  1.02
	Teff    5815
	FeH     0.04
}

Star	"Kepler-1561/KOI-4169/KIC 7838675"
{
	RA      19.79490693
	Dec     43.566467
	Dist    993
	AppMagn 14.658
	MassSol 1.07
	RadSol  1.11
	Teff    5957
	FeH     0.04
}

Star	"Kepler-1562/KOI-4189/KIC 9897364"
{
	RA      19.6303806
	Dec     46.743614
	Dist    1315
	AppMagn 15.589
	MassSol 1.02
	RadSol  1.05
	Teff    5760
	FeH     0.11
}

Star	"Kepler-1563/KOI-4190/KIC 12505503"
{
	RA      19.2382392
	Dec     51.472755
	Dist    547
	AppMagn 13.583
	MassSol 1
	RadSol  0.99
	Teff    5765
	FeH     0.02
}

Star	"Kepler-1564/KOI-4192/KIC 9828127"
{
	RA      19.37240827
	Dec     46.642689
	Dist    872
	AppMagn 15.004
	MassSol 0.93
	RadSol  0.9
	Teff    5528
	FeH     0.03
}

Star	"Kepler-1565/KOI-4194/KIC 5644412"
{
	RA      19.86353113
	Dec     40.806808
	Dist    657
	AppMagn 15.329
	MassSol 0.76
	RadSol  0.73
	Teff    4940
	FeH    -0.16
}

Star	"Kepler-1566/KOI-4199/KIC 5340878"
{
	RA      18.90584093
	Dec     40.574927
	Dist    511
	AppMagn 14.311
	MassSol 0.84
	RadSol  0.81
	Teff    5254
	FeH    -0.07
}

Star	"Kepler-1567/KOI-4202/KIC 5084171"
{
	RA      19.11301333
	Dec     40.291819
	Dist    1226
	AppMagn 15.672
	MassSol 0.95
	RadSol  0.93
	Teff    5655
	FeH    -0.03
}

Star	"Kepler-1568/KOI-4204/KIC 10593535"
{
	RA      19.27884427
	Dec     47.873383
	Dist    883
	AppMagn 13.966
	MassSol 1.09
	RadSol  1.19
	Teff    5956
	FeH     0.09
}

Star	"Kepler-1569/KOI-4212/KIC 1724719"
{
	RA      19.48031373
	Dec     37.22122
	Dist    1050
	AppMagn 13.96
	MassSol 1.25
	RadSol  1.4
	Teff    6319
	FeH     0.06
}

Star	"Kepler-157/KOI-442/KIC 3745690"
{
	RA      19.40648193
	Dec     38.87561
	AppMagn 14.002
	MassSol 1.021
	RadSol  1.04
	Teff    5774
	FeH    -0.108
}

Star	"Kepler-1570/KOI-4215/KIC 9366617"
{
	RA      19.99078887
	Dec     45.827354
	Dist    463
	AppMagn 13.961
	MassSol 0.92
	RadSol  0.89
	Teff    5550
	FeH    -0.04
}

Star	"Kepler-1571/KOI-4222/KIC 9183378"
{
	RA      20.0623604
	Dec     45.596546
	Dist    802
	AppMagn 13.767
	MassSol 1.23
	RadSol  1.39
	Teff    6297
	FeH     0.04
}

Star	"Kepler-1572/KOI-4230/KIC 9872831"
{
	RA      18.79315167
	Dec     46.722633
	Dist    600
	AppMagn 13.95
	MassSol 0.97
	RadSol  0.95
	Teff    5618
	FeH     0.08
}

Star	"Kepler-1573/KOI-4232/KIC 11509504"
{
	RA      19.53255653
	Dec     49.48497
	Dist    1180
	AppMagn 15.18
	MassSol 1.01
	RadSol  1
	Teff    5808
	FeH     0.02
}

Star	"Kepler-1574/KOI-4234/KIC 11611275"
{
	RA      19.47724427
	Dec     49.63776
	Dist    1275
	AppMagn 15.158
	MassSol 1.06
	RadSol  1.08
	Teff    5892
	FeH     0.08
}

Star	"Kepler-1575"
{
	RA      19.58288333
	Dec     45.761597
	Dist    1170
	AppMagn 13.871 // not V mag
	MassSol 0.95
	RadSol  0.92
	Teff    5667
	FeH    -0.07
}

Star	"Kepler-1576/KOI-4246/KIC 5177859"
{
	RA      19.27159833
	Dec     40.366015
	Dist    539
	AppMagn 13.382
	MassSol 1.05
	RadSol  1.06
	Teff    5876
	FeH     0.05
}

Star	"Kepler-1577/KOI-4255/KIC 10407482"
{
	RA      19.53035167
	Dec     47.573105
	Dist    543
	AppMagn 15.056
	MassSol 0.78
	RadSol  0.74
	Teff    4862
	FeH     0
}

Star	"Kepler-1578/KOI-4261/KIC 10526887"
{
	RA      19.22013333
	Dec     47.775555
	Dist    1016
	AppMagn 15.369
	MassSol 0.9
	RadSol  0.86
	Teff    5545
	FeH    -0.13
}

Star	"Kepler-1579/KOI-4268/KIC 7826620"
{
	RA      19.55253393
	Dec     43.514988
	Dist    466
	AppMagn 15.22
	MassSol 0.75
	RadSol  0.7
	Teff    4584
	FeH     0.11
}

Star	"Kepler-158/KOI-446/KIC 4633570"
{
	RA      18.93548381
	Dec     39.781349
	AppMagn 14.427
	MassSol 0.656
	RadSol  0.62
	Teff    4623
	FeH    -0.232
}

Star	"Kepler-1580/KOI-4276/KIC 6026924"
{
	RA      19.06458147
	Dec     41.363559
	Dist    872
	AppMagn 12.561
	MassSol 1.47
	RadSol  2.15
	Teff    6228
	FeH     0.12
}

Star	"Kepler-1581/KOI-4288/KIC 4548011"
{
	RA      19.15808407
	Dec     39.603581
	Dist    443
	AppMagn 12.4
	MassSol 1.12
	RadSol  1.23
	Teff    6022
	FeH     0.07
}

Star	"Kepler-1582/KOI-4290/KIC 5868793"
{
	RA      19.29177667
	Dec     41.158613
	Dist    112
	AppMagn 17.058
	MassSol 0.28
	RadSol  0.3
	Teff    3208
	FeH     0.48
}

Star	"Kepler-1583/KOI-4292/KIC 10063208"
{
	RA      19.09246227
	Dec     47.016628
	Dist    357
	AppMagn 12.897
	MassSol 0.94
	RadSol  0.91
	Teff    5645
	FeH    -0.07
}

Star	"Kepler-1584/KOI-4295/KIC 7596240"
{
	RA      19.18417887
	Dec     43.274429
	Dist    1325
	AppMagn 14.924
	MassSol 1.1
	RadSol  1.13
	Teff    6069
	FeH     0
}

Star	"Kepler-1585/KOI-4300/KIC 8507475"
{
	RA      19.74393367
	Dec     44.563114
	Dist    1269
	AppMagn 15.965
	MassSol 0.94
	RadSol  0.91
	Teff    5538
	FeH     0.08
}

Star	"Kepler-1586/KOI-4301/KIC 8773015"
{
	RA      19.88017393
	Dec     44.925827
	Dist    864
	AppMagn 13.096
	MassSol 1.45
	RadSol  1.75
	Teff    6681
	FeH     0.06
}

Star	"Kepler-1587/KOI-4304/KIC 11612280"
{
	RA      19.5118484
	Dec     49.66391
	Dist    907
	AppMagn 14.09
	MassSol 1.08
	RadSol  1.22
	Teff    5933
	FeH     0.07
}

Star	"Kepler-1588/KOI-4312/KIC 10722485"
{
	RA      19.21551433
	Dec     48.002178
	Dist    658
	AppMagn 13.858
	MassSol 0.96
	RadSol  0.99
	Teff    5817
	FeH    -0.14
}

Star	"Kepler-1589/KOI-4327/KIC 5371777"
{
	RA      19.6294528
	Dec     40.571686
	Dist    1418
	AppMagn 14.978
	MassSol 1.18
	RadSol  1.25
	Teff    6166
	FeH     0.08
}

Star	"Kepler-159/KOI-448/KIC 5640085"
{
	RA      19.80467733
	Dec     40.868786
	AppMagn 14.902
	MassSol 0.52
	RadSol  0.66
	Teff    4625
	FeH    -0.911
}

Star	"Kepler-1590/KOI-4335/KIC 10730070"
{
	RA      19.42718747
	Dec     48.017891
	Dist    900
	AppMagn 14.11
	MassSol 1.11
	RadSol  1.16
	Teff    6053
	FeH     0.03
}

Star	"Kepler-1591/KOI-4337/KIC 8573193"
{
	RA      19.76777727
	Dec     44.608608
	Dist    1090
	AppMagn 14.686
	MassSol 1.1
	RadSol  1.16
	Teff    6082
	FeH     0.01
}

Star	"Kepler-1592/KOI-4347/KIC 3244792"
{
	RA      19.59004307
	Dec     38.397749
	Dist    1349
	AppMagn 14.803
	MassSol 1.18
	RadSol  1.28
	Teff    6213
	FeH     0.04
}

Star	"Kepler-1593/KOI-4356/KIC 8459663"
{
	RA      20.03254533
	Dec     44.46067
	Dist    755
	AppMagn 15.873
	MassSol 0.81
	RadSol  0.77
	Teff    4995
	FeH     0.02
}

Star	"Kepler-1594/KOI-4360/KIC 10669994"
{
	RA      19.57487267
	Dec     47.961914
	Dist    1100
	AppMagn 14.801
	MassSol 1.06
	RadSol  1.08
	Teff    5946
	FeH     0.03
}

Star	"Kepler-1595/KOI-4364/KIC 7427764"
{
	RA      19.0481814
	Dec     43.00948
	Dist    841
	AppMagn 15.448
	MassSol 0.84
	RadSol  0.8
	Teff    5203
	FeH    -0.02
}

Star	"Kepler-1596/KOI-4371/KIC 11444514"
{
	RA      19.0371674
	Dec     49.330074
	Dist    1166
	AppMagn 15.37
	MassSol 0.95
	RadSol  0.92
	Teff    5706
	FeH    -0.11
}

Star	"Kepler-1597/KOI-4382/KIC 6937529"
{
	RA      19.21093153
	Dec     42.481083
	Dist    1255
	AppMagn 14.144
	MassSol 1.25
	RadSol  1.39
	Teff    6377
	FeH     0.02
}

Star	"Kepler-1598/KOI-4383/KIC 9883606"
{
	RA      19.23127347
	Dec     46.78368
	Dist    734
	AppMagn 13.874
	MassSol 1.07
	RadSol  1.09
	Teff    5940
	FeH     0.04
}

Star	"Kepler-1599/KOI-4384/KIC 5860968"
{
	RA      19.0813926
	Dec     41.151251
	Dist    1004
	AppMagn 14.945
	MassSol 0.99
	RadSol  0.99
	Teff    5767
	FeH     0.02
}

Star	"Kepler-160/KOI-456/KIC 7269974"
{
	RA      19.18490601
	Dec     42.869286
	AppMagn 14.619
	MassSol 0.887
	RadSol  0.88
	Teff    5857
	FeH    -0.361
}

Star	"Kepler-1600/KOI-4385/KIC 3645438"
{
	RA      19.4266256
	Dec     38.787752
	Dist    992
	AppMagn 15.825
	MassSol 0.86
	RadSol  0.82
	Teff    5214
	FeH     0.07
}

Star	"Kepler-1601/KOI-4400/KIC 2831055"
{
	RA      19.0341962
	Dec     38.079748
	Dist    660
	AppMagn 13.764
	MassSol 1.04
	RadSol  1.07
	Teff    5869
	FeH     0.05
}

Star	"Kepler-1602/KOI-4411/KIC 5281113"
{
	RA      19.5720572
	Dec     40.427478
	Dist    815
	AppMagn 13.352
	MassSol 1.22
	RadSol  1.36
	Teff    6296
	FeH     0.02
}

Star	"Kepler-1603/KOI-4424/KIC 7046035"
{
	RA      19.6886562
	Dec     42.534966
	Dist    1751
	AppMagn 15.332
	MassSol 1.21
	RadSol  1.31
	Teff    6241
	FeH     0.07
}

Star	"Kepler-1604"
{
	RA      19.02737553
	Dec     44.412212
	Dist    562
	AppMagn 12.924 // not V mag
	MassSol 0.81
	RadSol  0.76
	Teff    4976
	FeH     0.02
}

Star	"Kepler-1605/KOI-4446/KIC 10329196"
{
	RA      19.14232633
	Dec     47.488621
	Dist    224
	AppMagn 12.429
	MassSol 0.86
	RadSol  0.82
	Teff    5280
	FeH    -0.01
}

Star	"Kepler-1606/KOI-4450/KIC 7429240"
{
	RA      19.09188427
	Dec     43.07325
	Dist    880
	AppMagn 15.139
	MassSol 0.9
	RadSol  0.86
	Teff    5422
	FeH     0.01
}

Star	"Kepler-1607/KOI-4473/KIC 7133294"
{
	RA      19.7373246
	Dec     42.656051
	Dist    735
	AppMagn 13.897
	MassSol 1.14
	RadSol  1.21
	Teff    6116
	FeH     0.05
}

Star	"Kepler-1608/KOI-4474/KIC 4381429"
{
	RA      19.7042372
	Dec     39.417606
	Dist    832
	AppMagn 15.889
	MassSol 0.75
	RadSol  0.72
	Teff    4992
	FeH    -0.24
}

Star	"Kepler-1609/KOI-4491/KIC 4556468"
{
	RA      19.34310367
	Dec     39.665821
	Dist    1483
	AppMagn 15.015
	MassSol 1.18
	RadSol  1.27
	Teff    6132
	FeH     0.1
}

Star	"Kepler-161/KOI-457/KIC 7440748"
{
	RA      19.3677653
	Dec     43.083824
	AppMagn 14.196
	MassSol 0.77
	RadSol  0.81
	Teff    5078
	FeH    -0.093
}

Star	"Kepler-1610/KOI-4500/KIC 9100953"
{
	RA      19.72700067
	Dec     45.405434
	Dist    1063
	AppMagn 15.85
	MassSol 0.91
	RadSol  0.87
	Teff    5383
	FeH     0.1
}

Star	"Kepler-1611/KOI-4510/KIC 11671579"
{
	RA      19.76746993
	Dec     49.727764
	Dist    686
	AppMagn 14.435
	MassSol 0.94
	RadSol  0.93
	Teff    5605
	FeH     0.01
}

Star	"Kepler-1612/KOI-4513/KIC 9216775"
{
	RA      19.41668527
	Dec     45.655075
	Dist    837
	AppMagn 14.75
	MassSol 0.96
	RadSol  0.94
	Teff    5643
	FeH     0.03
}

Star	"Kepler-1613/KOI-4561/KIC 7747457"
{
	RA      19.32500273
	Dec     43.420963
	Dist    855
	AppMagn 14.118
	MassSol 1.08
	RadSol  1.12
	Teff    6005
	FeH     0.01
}

Star	"Kepler-1614/KOI-4566/KIC 11650401"
{
	RA      18.99142227
	Dec     49.775913
	Dist    982
	AppMagn 15.923
	MassSol 0.79
	RadSol  0.76
	Teff    5121
	FeH    -0.17
}

Star	"Kepler-1615/KOI-4571/KIC 6761777"
{
	RA      19.09061507
	Dec     42.227478
	Dist    940
	AppMagn 14.553
	MassSol 1.04
	RadSol  1.05
	Teff    5865
	FeH     0.06
}

Star	"Kepler-1616/KOI-4585/KIC 9009036"
{
	RA      19.10290913
	Dec     45.304874
	Dist    862
	AppMagn 13.499
	MassSol 1.21
	RadSol  1.34
	Teff    6266
	FeH     0.02
}

Star	"Kepler-1617/KOI-4617/KIC 9701962"
{
	RA      19.1958146
	Dec     46.418491
	Dist    813
	AppMagn 13.63
	MassSol 1.15
	RadSol  1.22
	Teff    6167
	FeH     0.01
}

Star	"Kepler-1618/KOI-4640/KIC 9412623"
{
	RA      19.6783594
	Dec     45.930908
	Dist    1238
	AppMagn 13.606
	MassSol 1.41
	RadSol  1.65
	Teff    6620
	FeH     0.04
}

Star	"Kepler-1619/KOI-4693/KIC 8417078"
{
	RA      19.04689813
	Dec     44.422001
	Dist    520
	AppMagn 13.341
	MassSol 1
	RadSol  1
	Teff    5852
	FeH    -0.07
}

Star	"Kepler-162/KOI-459/KIC 7977197"
{
	RA      19.81859334
	Dec     43.724018
	AppMagn 14.248
	MassSol 0.875
	RadSol  0.96
	Teff    5816
	FeH    -0.301
}

Star	"Kepler-1620/KOI-4706/KIC 10026502"
{
	RA      19.8180584
	Dec     46.928417
	Dist    773
	AppMagn 13.658
	MassSol 1.15
	RadSol  1.23
	Teff    6157
	FeH     0.03
}

Star	"Kepler-1621/KOI-4747/KIC 8047428"
{
	RA      19.83923453
	Dec     43.841221
	Dist    1461
	AppMagn 15.015
	MassSol 1.15
	RadSol  1.24
	Teff    6158
	FeH     0.03
}

Star	"Kepler-1622/KOI-4765/KIC 10615440"
{
	RA      19.82192733
	Dec     47.815472
	Dist    927
	AppMagn 13.385
	MassSol 1.31
	RadSol  1.5
	Teff    6436
	FeH     0.04
}

Star	"Kepler-1623/KOI-4803/KIC 4473613"
{
	RA      19.605513
	Dec     39.556103
	Dist    986
	AppMagn 14.951
	MassSol 1
	RadSol  1
	Teff    5772
	FeH     0.04
}

Star	"Kepler-1624/KOI-4928/KIC 1873513"
{
	RA      19.505324
	Dec     37.376411
	Dist    199
	AppMagn 15.669
	MassSol 0.5
	RadSol  0.47
	Teff    3636
	FeH     0.06
}

Star	"Kepler-1625/KOI-5084/KIC 4760478"
{
	RA      19.6952898
	Dec     39.886547
	Dist    1213
	AppMagn 15.756
	MassSol 0.96
	RadSol  0.94
	Teff    5677
	FeH     0.01
}

Star	"Kepler-1626/KOI-5178/KIC 5551240"
{
	RA      19.76669633
	Dec     40.72123
	Dist    1718
	AppMagn 14.275
	MassSol 1.51
	RadSol  1.85
	Teff    6826
	FeH     0.04
}

Star	"Kepler-1627/KOI-5245/KIC 6184894"
{
	RA      18.93711227
	Dec     41.576733
	Dist    311
	AppMagn 13.028
	MassSol 0.87
	RadSol  0.84
	Teff    5445
	FeH    -0.1
}

Star	"Kepler-1628/KOI-5416/KIC 7731281"
{
	RA      18.77558
	Dec     43.411579
	Dist    352
	AppMagn 16.595
	MassSol 0.55
	RadSol  0.52
	Teff    3724
	FeH     0.17
}

Star	"Kepler-1629"
{
	RA      18.6804414
	Dec     43.774297
	Dist    390
	AppMagn 11.302 // not V mag
	MassSol 1.01
	RadSol  1.01
	Teff    5776
	FeH     0.05
}

Star	"Kepler-163/KOI-471/KIC 10019643"
{
	RA      19.66685384
	Dec     46.987328
	AppMagn 14.415
	MassSol 0.96
	RadSol  0.92
	Teff    5776
	FeH    -0.016
}

Star	"Kepler-1630/KOI-5454/KIC 7978202"
{
	RA      19.83388627
	Dec     43.710953
	Dist    278
	AppMagn 14.15
	MassSol 0.66
	RadSol  0.63
	Teff    4736
	FeH    -0.46
}

Star	"Kepler-1631/KOI-5466/KIC 8037038"
{
	RA      19.64217133
	Dec     43.807671
	Dist    1190
	AppMagn 15.524
	MassSol 0.97
	RadSol  0.95
	Teff    5679
	FeH     0.04
}

Star	"Kepler-1632"
{
	RA      19.6329906
	Dec     43.91362
	Dist    584
	AppMagn 11.731 // not V mag
	MassSol 1.12
	RadSol  1.19
	Teff    6137
	FeH     0
}

Star	"Kepler-1633/KOI-5568/KIC 8745553"
{
	RA      19.2343468
	Dec     44.923225
	Dist    811
	AppMagn 13.435
	MassSol 1.2
	RadSol  1.32
	Teff    6256
	FeH     0.02
}

Star	"Kepler-1634/KOI-5581/KIC 8891684"
{
	RA      19.60289393
	Dec     45.139786
	Dist    654
	AppMagn 14.508
	MassSol 0.92
	RadSol  0.89
	Teff    5474
	FeH     0.02
}

Star	"Kepler-1635/KOI-5622/KIC 9141355"
{
	RA      19.0232662
	Dec     45.556183
	Dist    1084
	AppMagn 15.696
	MassSol 0.89
	RadSol  0.85
	Teff    5347
	FeH     0.06
}

Star	"Kepler-1636/KOI-5706/KIC 9715631"
{
	RA      19.60384167
	Dec     46.441031
	Dist    1567
	AppMagn 15.807
	MassSol 1.01
	RadSol  1.02
	Teff    5797
	FeH     0.03
}

Star	"Kepler-1637/KOI-5827/KIC 10777591"
{
	RA      18.81578987
	Dec     48.154297
	Dist    506
	AppMagn 13.328
	MassSol 1.02
	RadSol  1.02
	Teff    5789
	FeH     0.07
}

Star	"Kepler-1638/KOI-5856/KIC 11037818"
{
	RA      19.69882713
	Dec     48.524445
	Dist    879
	AppMagn 14.759
	MassSol 0.97
	RadSol  0.95
	Teff    5710
	FeH    -0.01
}

Star	"Kepler-1639/KOI-5875/KIC 11176166"
{
	RA      18.87124213
	Dec     48.802086
	Dist    1168
	AppMagn 14.496
	MassSol 1.12
	RadSol  1.18
	Teff    6150
	FeH    -0.03
}

Star	"Kepler-164/KOI-474/KIC 10460984"
{
	RA      19.18538818
	Dec     47.629913
	AppMagn 14.282
	MassSol 1.11
	RadSol  1.15
	Teff    5888
	FeH    -0.125
}

Star	"Kepler-1640/KOI-6132/KIC 5629353"
{
	RA      19.63719267
	Dec     40.850498
	Dist    1379
	AppMagn 14.624
	MassSol 1.27
	RadSol  1.43
	Teff    6324
	FeH     0.1
}

Star	"Kepler-1641/KOI-6145/KIC 6221385"
{
	RA      19.757296
	Dec     41.574532
	Dist    961
	AppMagn 14.263
	MassSol 1.12
	RadSol  1.19
	Teff    6152
	FeH    -0.02
}

Star	"Kepler-1642/KOI-6166/KIC 7908367"
{
	RA      19.814144
	Dec     43.643719
	Dist    447
	AppMagn 14.13
	MassSol 0.88
	RadSol  0.84
	Teff    5355
	FeH    -0.01
}

Star	"Kepler-1643/KOI-6186/KIC 8653134"
{
	RA      20.02873333
	Dec     44.751011
	Dist    414
	AppMagn 13.116
	MassSol 0.92
	RadSol  0.88
	Teff    5508
	FeH    -0.01
}

Star	"Kepler-1644/KOI-6228/KIC 10717220"
{
	RA      19.03167033
	Dec     48.034935
	Dist    592
	AppMagn 14.223
	MassSol 0.89
	RadSol  0.86
	Teff    5499
	FeH    -0.1
}

Star	"Kepler-1645"
{
	RA      19.83196487
	Dec     48.418571
	Dist    844
	AppMagn 12.949 // not V mag
	MassSol 1.02
	RadSol  1.02
	Teff    5812
	FeH     0.04
}

Star	"Kepler-1646"
{
	RA      19.16842813
	Dec     42.912908
	Dist    81
	AppMagn 12.298 // not V mag
	MassSol 0.24
	RadSol  0.26
	Teff    3299
	FeH     0.04
}

Star	"Kepler-165/KOI-475/KIC 10577994"
{
	RA      18.71273397
	Dec     47.809734
	AppMagn 14.802
	MassSol 0.733
	RadSol  0.77
	Teff    5211
	FeH    -0.28
}

Star	"Kepler-166/KOI-481/KIC 11192998"
{
	RA      19.54401042
	Dec     48.881191
	AppMagn 14.701
	MassSol 0.819
	RadSol  0.74
	Teff    5413
	FeH    -0.286
}

Star	"Kepler-167/KOI-490/KIC 3239945"
{
	RA      19.51056273
	Dec     38.345413
	Dist    330
	AppMagn 14.023
	Class  "K4"
	MassSol 0.77
	RadSol  0.73
	Teff    4890
	FeH    -0.03
}

Star	"Kepler-168/KOI-497/KIC 4757437"
{
	RA      19.64734497
	Dec     39.825104
	AppMagn 14.606
	MassSol 1.089
	RadSol  1.11
	Teff    6282
	FeH    -0.012
}

Star	"Kepler-169/KOI-505/KIC 5689351"
{
	RA      19.06665853
	Dec     40.919331
	AppMagn 14.194
	MassSol 0.86
	RadSol  0.76
	Teff    4997
	FeH     0.238
}

Star	"Kepler-17/KOI-203/KIC 10619192"
{
	RA      19.89305555
	Dec     47.815
	Dist    800
	AppMagn 14
	Class  "G2V"
	MassSol 1.16
	RadSol  1.05
	Teff    5781
	FeH     0.26
	Age     1.78
}

Star	"Kepler-170/KOI-508/KIC 6266741"
{
	RA      18.96807861
	Dec     41.629604
	AppMagn 14.387
	MassSol 1.081
	RadSol  1.03
	Teff    5679
	FeH     0.234
}

Star	"Kepler-171/KOI-509/KIC 6381846"
{
	RA      19.78479411
	Dec     41.755539
	AppMagn 14.883
	MassSol 0.908
	RadSol  0.84
	Teff    5642
	FeH    -0.151
}

Star	"Kepler-172/KOI-510/KIC 6422155"
{
	RA      18.89122721
	Dec     41.821857
	AppMagn 14.532
	MassSol 0.86
	RadSol  1.08
	Teff    5526
	FeH     0.012
}

Star	"Kepler-173/KOI-511/KIC 6451936"
{
	RA      19.6431132
	Dec     41.884106
	AppMagn 14.209
	MassSol 0.78
	RadSol  0.95
	Teff    6031
	FeH    -0.786
}

Star	"Kepler-174/KOI-518/KIC 8017703"
{
	RA      19.16261393
	Dec     43.832092
	AppMagn 14.287
	MassSol 0.583
	RadSol  0.62
	Teff    4880
	FeH    -0.556
}

Star	"Kepler-175/KOI-519/KIC 8022244"
{
	RA      19.30355225
	Dec     43.876183
	AppMagn 14.939
	MassSol 1.04
	RadSol  1.01
	Teff    6064
	FeH    -0.023
}

Star	"Kepler-176/KOI-520/KIC 8037145"
{
	RA      19.64453125
	Dec     43.85326
	AppMagn 14.55
	MassSol 0.826
	RadSol  0.89
	Teff    5232
	FeH     0.072
}

Star	"Kepler-177/KOI-523/KIC 8806123"
{
	RA      19.06972
	Dec     45.0533
	AppMagn 15
	MassSol 0.93
	RadSol  0.98
	Teff    5942
	FeH     0.091
}

Star	"Kepler-178/KOI-528/KIC 9941859"
{
	RA      19.14007161
	Dec     46.896477
	AppMagn 14.598
	MassSol 0.861
	RadSol  1.07
	Teff    5676
	FeH    -0.188
}

Star	"Kepler-179/KOI-534/KIC 10554999"
{
	RA      19.91091512
	Dec     47.762043
	AppMagn 14.613
	MassSol 0.849
	RadSol  0.76
	Teff    5302
	FeH    -0.01
}

Star	"Kepler-18/KOI-137/KIC 8644288"
{
	RA      19.87194445
	Dec     44.7463889
	AppMagn 14
	MassSol 0.972
	RadSol  1.108
	Teff    5383
	FeH     0.2
	Age     10
}

Star	"Kepler-180/KOI-542/KIC 11669239"
{
	RA      19.70475667
	Dec     49.774586
	AppMagn 14.35
	MassSol 0.84
	RadSol  1.06
	Teff    5731
	FeH    -0.194
}

Star	"Kepler-181/KOI-543/KIC 11823054"
{
	RA      19.74342651
	Dec     50.095806
	AppMagn 14.707
	MassSol 0.84
	RadSol  0.75
	Teff    5333
	FeH    -0.162
}

Star	"Kepler-182/KOI-546/KIC 12058931"
{
	RA      19.32200724
	Dec     50.586246
	AppMagn 14.896
	MassSol 1.14
	RadSol  1.15
	Teff    6250
	FeH     0.077
}

Star	"Kepler-183/KOI-551/KIC 4270253"
{
	RA      19.56872355
	Dec     39.315899
	AppMagn 14.943
	MassSol 1.037
	RadSol  0.96
	Teff    5888
	FeH     0.026
}

Star	"Kepler-184/KOI-567/KIC 7445445"
{
	RA      19.46346029
	Dec     43.074715
	AppMagn 14.338
	MassSol 0.869
	RadSol  0.87
	Teff    5788
	FeH    -0.338
}

Star	"Kepler-185/KOI-569/KIC 8008206"
{
	RA      18.83120728
	Dec     43.889915
	AppMagn 14.458
	MassSol 0.79
	RadSol  0.81
	Teff    5208
	FeH    -0.051
}

Star	"Kepler-186/KOI-571/KIC 8120608"
{
	RA      19.91018066
	Dec     43.955017
	Dist    151
	AppMagn 14.625
	Class  "M1"
	MassSol 0.478
	RadSol  0.472
	Teff    3788
	FeH    -0.28
}

Star	"Kepler-187/KOI-572/KIC 8193178"
{
	RA      19.98642985
	Dec     44.089306
	AppMagn 14.173
	MassSol 0.85
	RadSol  1.29
	Teff    6105
	FeH    -0.345
}

Star	"Kepler-188/KOI-573/KIC 8344004"
{
	RA      18.75198161
	Dec     44.315533
	AppMagn 14.674
	MassSol 0.989
	RadSol  1.14
	Teff    6021
	FeH     0.1
}

Star	"Kepler-189/KOI-574/KIC 8355239"
{
	RA      19.17098185
	Dec     44.305004
	AppMagn 14.859
	MassSol 0.79
	RadSol  0.75
	Teff    5235
	FeH    -0.134
}

Star	"Kepler-19/KOI-84/KIC 2571238"
{
	RA      19.36138913
	Dec     37.851788
	Dist    2119
	AppMagn 11.898
	MassSol 0.94
	RadSol  0.85
	Teff    5541
	FeH    -0.13
	Age     1.9
}

Star	"Kepler-190/KOI-579/KIC 8616637"
{
	RA      19.23893636
	Dec     44.733799
	AppMagn 14.137
	MassSol 0.84
	RadSol  0.8
	Teff    5106
	FeH     0.009
}

Star	"Kepler-191/KOI-582/KIC 9020160"
{
	RA      19.41222534
	Dec     45.323177
	AppMagn 14.808
	MassSol 0.85
	RadSol  0.79
	Teff    5282
	FeH     0.006
}

Star	"Kepler-192/KOI-584/KIC 9146018"
{
	RA      19.19452922
	Dec     45.592876
	AppMagn 14.129
	MassSol 0.891
	RadSol  1.01
	Teff    5479
	FeH    -0.153
}

Star	"Kepler-193/KOI-590/KIC 9782691"
{
	RA      19.76657308
	Dec     46.577244
	AppMagn 14.615
	MassSol 1.213
	RadSol  1.15
	Teff    6335
	FeH    -0.011
}

Star	"Kepler-194/KOI-597/KIC 10600261"
{
	RA      19.46476237
	Dec     47.864174
	AppMagn 14.915
	MassSol 0.962
	RadSol  1.02
	Teff    6089
	FeH    -0.298
}

Star	"Kepler-195/KOI-598/KIC 10656823"
{
	RA      19.20806478
	Dec     47.966667
	AppMagn 14.813
	MassSol 0.884
	RadSol  0.78
	Teff    5329
	FeH    -0.052
}

Star	"Kepler-196/KOI-612/KIC 6587002"
{
	RA      18.99790039
	Dec     42.079205
	AppMagn 14.157
	MassSol 0.926
	RadSol  0.78
	Teff    5128
	FeH     0.071
}

Star	"Kepler-197/KOI-623/KIC 12068975"
{
	RA      19.6817627
	Dec     50.559006
	AppMagn 11.811
	MassSol 0.922
	RadSol  1.12
	Teff    6004
	FeH    -0.533
}

Star	"Kepler-198/KOI-624/KIC 3541946"
{
	RA      19.37820841
	Dec     38.69101
	AppMagn 13.597
	MassSol 0.93
	RadSol  0.94
	Teff    5574
	FeH    -0.14
}

Star	"Kepler-199/KOI-638/KIC 5113822"
{
	RA      19.70396118
	Dec     40.236271
	AppMagn 13.595
	MassSol 0.979
	RadSol  0.97
	Teff    5644
	FeH    -0.157
}

Star	"Kepler-2/KOI-2/KIC 10666592/HAT-P-7"
{
	RA      19.48315427
	Dec     47.969513
	Dist    320
	AppMagn 10.5
	MassSol 1.47
	RadSol  1.84
	Teff    6350
	FeH     0.26
	Age     2.07
}

Star	"Kepler-20/KOI-70/KIC 6850504"
{
	RA      19.18
	Dec     42.3386111
	Dist    290
	AppMagn 12.5
	Class  "G8"
	MassSol 0.912
	RadSol  0.944
	Teff    5466
	FeH     0.02
	Age     8.8
}

Star	"Kepler-200/KOI-654/KIC 5941160"
{
	RA      18.96066081
	Dec     41.237465
	AppMagn 13.984
	MassSol 1.038
	RadSol  0.94
	Teff    5678
	FeH    -0.118
}

Star	"Kepler-201/KOI-655/KIC 5966154"
{
	RA      19.57506917
	Dec     41.272827
	AppMagn 13.004
	MassSol 1.17
	RadSol  1.23
	Teff    6065
	FeH    -0.279
}

Star	"Kepler-202/KOI-657/KIC 6020753"
{
	RA      18.86489461
	Dec     41.322006
	AppMagn 13.872
	MassSol 0.758
	RadSol  0.67
	Teff    4668
	FeH     0.012
}

Star	"Kepler-203/KOI-658/KIC 6062088"
{
	RA      19.80599772
	Dec     41.388039
	AppMagn 13.989
	MassSol 0.98
	RadSol  1.11
	Teff    5821
	FeH    -0.107
}

Star	"Kepler-204/KOI-661/KIC 6347299"
{
	RA      19.02314657
	Dec     41.761925
	AppMagn 13.909
	MassSol 0.96
	RadSol  1.24
	Teff    5812
	FeH    -0.213
}

Star	"Kepler-205/KOI-663/KIC 6425957"
{
	RA      19.01914062
	Dec     41.861172
	AppMagn 13.506
	MassSol 0.51
	RadSol  0.55
	Teff    4321
	FeH    -0.149
}

Star	"Kepler-206/KOI-664/KIC 6442340"
{
	RA      19.4423116
	Dec     41.833866
	AppMagn 13.484
	MassSol 0.94
	RadSol  1.19
	Teff    5764
	FeH    -0.149
}

Star	"Kepler-207/KOI-665/KIC 6685609"
{
	RA      19.33536784
	Dec     42.16605
	AppMagn 13.182
	MassSol 1.065
	RadSol  1.59
	Teff    5920
	FeH    -0.023
}

Star	"Kepler-208/KOI-671/KIC 7040629"
{
	RA      19.59267985
	Dec     42.528008
	AppMagn 13.749
	MassSol 1.03
	RadSol  1.31
	Teff    6092
}

Star	"Kepler-209/KOI-672/KIC 7115785"
{
	RA      19.41130168
	Dec     42.640812
	AppMagn 13.998
	MassSol 0.876
	RadSol  0.94
	Teff    5513
	FeH     0.008
}

Star	"Kepler-21/KOI-975/KIC 3632418/HD 179070/HIP 94112"
{
	RA      19.1574544
	Dec     38.714016
	Dist    108
	AppMagn 8.25
	Class  "F6IV"
	MassSol 1.34
	RadSol  1.86
	Teff    6131
	FeH    -0.15
	Age     2.84
}

Star	"Kepler-210/KOI-676/KIC 7447200"
{
	RA      19.50027778
	Dec     43.08305557
	AppMagn 14.4
	Class  "K"
	MassSol 0.63
	RadSol  0.69
	Teff    4300
	FeH    -0.748
}

Star	"Kepler-211/KOI-678/KIC 7509886"
{
	RA      19.02927653
	Dec     43.168484
	AppMagn 13.283
	MassSol 0.97
	RadSol  0.82
	Teff    5123
	FeH     0.106
}

Star	"Kepler-212/KOI-679/KIC 7515212"
{
	RA      19.17472127
	Dec     43.141678
	AppMagn 13.178
	MassSol 1.16
	RadSol  1.46
	Teff    5852
}

Star	"Kepler-213/KOI-692/KIC 8557374"
{
	RA      19.38827922
	Dec     44.647186
	AppMagn 13.648
	MassSol 0.94
	RadSol  1.2
	Teff    5696
	FeH    -0.051
}

Star	"Kepler-214/KOI-693/KIC 8738735"
{
	RA      18.98365682
	Dec     44.956032
	AppMagn 13.949
	MassSol 1.041
	RadSol  1.35
	Teff    6169
	FeH    -0.359
}

Star	"Kepler-215/KOI-700/KIC 8962094"
{
	RA      19.66490072
	Dec     45.213688
	AppMagn 13.58
	MassSol 0.77
	RadSol  1.03
	Teff    5739
	FeH    -0.618
}

Star	"Kepler-216/KOI-708/KIC 9530945"
{
	RA      19.58187052
	Dec     46.129154
	AppMagn 13.998
	MassSol 1.085
	RadSol  1.26
	Teff    6091
	FeH    -0.183
}

Star	"Kepler-217/KOI-710/KIC 9590976"
{
	RA      19.53585002
	Dec     46.277508
	AppMagn 13.294
	MassSol 1.426
	RadSol  1.8
	Teff    6171
}

Star	"Kepler-218/KOI-711/KIC 9597345"
{
	RA      19.69418742
	Dec     46.266472
	AppMagn 13.967
	MassSol 0.983
	RadSol  1.06
	Teff    5502
	FeH     0.194
}

Star	"Kepler-219/KOI-718/KIC 9884104"
{
	RA      19.24926554
	Dec     46.762558
	AppMagn 13.764
	MassSol 1.154
	RadSol  1.49
	Teff    5786
	FeH     0.02
}

Star	"Kepler-22/KOI-87/KIC 10593626"
{
	RA      19.28111111
	Dec     47.8844444
	Dist    190
	AppMagn 12
	Class  "G5"
	MassSol 0.97
	RadSol  0.979
	Teff    5518
	FeH    -0.29
}

Star	"Kepler-220/KOI-719/KIC 9950612"
{
	RA      19.43374837
	Dec     46.895779
	AppMagn 13.177
	MassSol 0.731
	RadSol  0.67
	Teff    4632
}

Star	"Kepler-221/KOI-720/KIC 9963524"
{
	RA      19.77698364
	Dec     46.83527
	AppMagn 13.749
	MassSol 0.72
	RadSol  0.82
	Teff    5243
	FeH    -0.413
}

Star	"Kepler-222/KOI-723/KIC 10002866"
{
	RA      19.19373983
	Dec     46.937767
	AppMagn 15.063
	MassSol 0.945
	RadSol  0.87
	Teff    5433
	FeH     0.15
}

Star	"Kepler-223/KOI-730/KIC 10227020"
{
	RA      19.88789063
	Dec     47.279495
	AppMagn 15.344
	MassSol 0.902
	RadSol  1.02
	Teff    5829
	FeH    -0.211
}

Star	"Kepler-224/KOI-733/KIC 10271806"
{
	RA      19.39561971
	Dec     47.357601
	AppMagn 15.644
	MassSol 0.74
	RadSol  0.68
	Teff    5018
	FeH    -0.309
}

Star	"Kepler-225/KOI-736/KIC 10340423"
{
	RA      19.47959798
	Dec     47.457096
	AppMagn 15.962
	MassSol 0.46
	RadSol  0.48
	Teff    3682
	FeH    -0.185
}

Star	"Kepler-226/KOI-749/KIC 10601284"
{
	RA      19.49174194
	Dec     47.880989
	AppMagn 15.416
	MassSol 0.86
	RadSol  0.8
	Teff    5571
	FeH    -0.145
}

Star	"Kepler-227/KOI-752/KIC 10797460"
{
	RA      19.46228231
	Dec     48.141651
	AppMagn 15.347
	MassSol 1.051
	RadSol  1.09
	Teff    5854
	FeH     0.136
}

Star	"Kepler-228/KOI-756/KIC 10872983"
{
	RA      19.75240885
	Dec     48.224667
	AppMagn 15.714
	MassSol 1.053
	RadSol  1.01
	Teff    6043
	FeH    -0.067
}

Star	"Kepler-229/KOI-757/KIC 10910878"
{
	RA      19.13329875
	Dec     48.375797
	AppMagn 15.841
	MassSol 0.827
	RadSol  0.73
	Teff    5120
	FeH    -0.109
}

Star	"Kepler-23/KOI-168/KIC 11512246"
{
	RA      19.61444445
	Dec     49.4791667
	Dist    800
	AppMagn 14
	MassSol 1.11
	RadSol  1.52
	Teff    5760
	FeH    -0.09
}

Star	"Kepler-230/KOI-759/KIC 11018648"
{
	RA      19.04790243
	Dec     48.505859
	AppMagn 15.082
	MassSol 0.846
	RadSol  0.82
	Teff    5588
	FeH    -0.291
}

Star	"Kepler-231/KOI-784/KIC 12066335"
{
	RA      19.59822388
	Dec     50.531914
	AppMagn 15.385
	MassSol 0.58
	RadSol  0.49
	Teff    3767
	FeH    -0.011
}

Star	"Kepler-232/KOI-787/KIC 12366084"
{
	RA      19.72107747
	Dec     51.121742
	AppMagn 15.367
	MassSol 1.047
	RadSol  0.97
	Teff    5847
	FeH     0.083
}

Star	"Kepler-233/KOI-790/KIC 12470844"
{
	RA      19.75776774
	Dec     51.319523
	AppMagn 15.339
	MassSol 0.884
	RadSol  0.76
	Teff    5360
	FeH    -0.067
}

Star	"Kepler-234/KOI-800/KIC 3342970"
{
	RA      19.44356689
	Dec     38.494659
	AppMagn 15.541
	MassSol 1.149
	RadSol  1.11
	Teff    6224
	FeH     0.075
}

Star	"Kepler-235/KOI-812/KIC 4139816"
{
	RA      19.0719401
	Dec     39.278313
	AppMagn 15.954
	MassSol 0.59
	RadSol  0.55
	Teff    4255
	FeH     0.087
}

Star	"Kepler-236/KOI-817/KIC 4725681"
{
	RA      18.92442424
	Dec     39.89809
	AppMagn 15.414
	MassSol 0.56
	RadSol  0.51
	Teff    3750
	FeH     0.119
}

Star	"Kepler-237/KOI-825/KIC 5252423"
{
	RA      18.88142497
	Dec     40.421833
	AppMagn 15.289
	MassSol 0.7
	RadSol  0.72
	Teff    4861
	FeH    -0.077
}

Star	"Kepler-238/KOI-834/KIC 5436502"
{
	RA      19.19305333
	Dec     40.6378
	AppMagn 15.084
	MassSol 1.43
	RadSol  0.9
	Teff    5614
	FeH     0.143
}

Star	"Kepler-239/KOI-835/KIC 5456651"
{
	RA      19.61347656
	Dec     40.663406
	AppMagn 15.208
	MassSol 0.74
	RadSol  0.76
	Teff    4914
	FeH    -0.016
}

Star	"Kepler-24/KOI-1102/KIC 3231341"
{
	RA      19.3608846
	Dec     38.343754
	Dist    1200
	AppMagn 14.925
	MassSol 1.03
	RadSol  1.29
	Teff    5897
	FeH    -0.24
}

Star	"Kepler-240/KOI-837/KIC 5531576"
{
	RA      19.41058553
	Dec     40.750263
	AppMagn 15.66
	MassSol 0.823
	RadSol  0.74
	Teff    4985
	FeH     0.089
}

Star	"Kepler-241/KOI-842/KIC 5794379"
{
	RA      19.5275411
	Dec     41.060921
	AppMagn 15.389
	MassSol 0.67
	RadSol  0.67
	Teff    4699
	FeH    -0.243
}

Star	"Kepler-242/KOI-853/KIC 6428700"
{
	RA      19.10438029
	Dec     41.808403
	AppMagn 15.376
	MassSol 0.785
	RadSol  0.85
	Teff    5020
	FeH     0.103
}

Star	"Kepler-243/KOI-857/KIC 6587280"
{
	RA      19.00736491
	Dec     42.033958
	AppMagn 15.086
	MassSol 0.89
	RadSol  0.84
	Teff    5228
	FeH     0.241
}

Star	"Kepler-244/KOI-864/KIC 6849310"
{
	RA      19.14951172
	Dec     42.301369
	AppMagn 15.604
	MassSol 0.879
	RadSol  0.8
	Teff    5554
	FeH    -0.191
}

Star	"Kepler-245/KOI-869/KIC 6948054"
{
	RA      19.44259847
	Dec     42.436317
	AppMagn 15.599
	MassSol 0.8
	RadSol  0.8
	Teff    5100
	FeH    -0.028
}

Star	"Kepler-246/KOI-874/KIC 7134976"
{
	RA      19.76556193
	Dec     42.663429
	AppMagn 15.024
	MassSol 0.86
	RadSol  0.83
	Teff    5206
	FeH     0.143
}

Star	"Kepler-247/KOI-884/KIC 7434875"
{
	RA      19.24283447
	Dec     43.039291
	AppMagn 15.067
	MassSol 0.884
	RadSol  0.791
	Teff    5094
	FeH     0.21
}

Star	"Kepler-248/KOI-896/KIC 7825899"
{
	RA      19.53742472
	Dec     43.581356
	AppMagn 15.258
	MassSol 0.936
	RadSol  0.83
	Teff    5190
	FeH     0.171
}

Star	"Kepler-249/KOI-899/KIC 7907423"
{
	RA      19.79900513
	Dec     43.658524
	AppMagn 15.234
	MassSol 0.44
	RadSol  0.48
	Teff    3568
	FeH     0.221
}

Star	"Kepler-25/KOI-244/KIC 4349452"
{
	RA      19.10916667
	Dec     39.4877778
	AppMagn 11
	MassSol 1.22
	RadSol  1.36
	Teff    6190
	FeH     0.01
}

Star	"Kepler-250/KOI-906/KIC 8226994"
{
	RA      19.30631714
	Dec     44.141953
	AppMagn 15.46
	MassSol 0.8
	RadSol  0.81
	Teff    5160
	FeH     0.063
}

Star	"Kepler-251/KOI-907/KIC 8247638"
{
	RA      19.77108154
	Dec     44.105865
	AppMagn 15.223
	MassSol 0.91
	RadSol  0.89
	Teff    5526
	FeH    -0.156
}

Star	"Kepler-252/KOI-912/KIC 8505670"
{
	RA      19.70528971
	Dec     44.545963
	AppMagn 15.058
	MassSol 0.52
	RadSol  0.55
	Teff    4208
	FeH    -0.67
}

Star	"Kepler-253/KOI-921/KIC 8689373"
{
	RA      19.456132
	Dec     44.858089
	AppMagn 15.532
	MassSol 0.874
	RadSol  0.79
	Teff    5208
	FeH     0.052
}

Star	"Kepler-254/KOI-934/KIC 9334289"
{
	RA      19.21098022
	Dec     45.816505
	AppMagn 15.843
	MassSol 0.975
	RadSol  0.91
	Teff    5957
	FeH    -0.191
}

Star	"Kepler-255/KOI-938/KIC 9415172"
{
	RA      19.73761597
	Dec     45.976841
	AppMagn 15.596
	MassSol 0.97
	RadSol  0.93
	Teff    5573
	FeH     0.212
}

Star	"Kepler-256/KOI-939/KIC 9466668"
{
	RA      19.50536296
	Dec     46.097389
	AppMagn 15.065
	MassSol 1.02
	RadSol  1.3
	Teff    5551
	FeH     0.061
}

Star	"Kepler-257/KOI-941/KIC 9480189"
{
	RA      19.82106527
	Dec     46.02327
	AppMagn 15.471
	MassSol 0.868
	RadSol  1.04
	Teff    5180
	FeH     0.315
}

Star	"Kepler-258/KOI-951/KIC 9775938"
{
	RA      19.60456543
	Dec     46.57933
	AppMagn 15.223
	MassSol 0.8
	RadSol  0.92
	Teff    4942
	FeH     0.415
}

Star	"Kepler-259/KOI-954/KIC 9823457"
{
	RA      19.2141276
	Dec     46.615005
	AppMagn 15.219
	MassSol 0.978
	RadSol  0.9
	Teff    5938
	FeH    -0.165
}

Star	"Kepler-26/KOI-250/KIC 9757613"
{
	RA      18.99606647
	Dec     46.56654
	AppMagn 16
	MassSol 0.54
	RadSol  0.51
	Teff    3914
	FeH    -0.13
}

Star	"Kepler-260/KOI-986/KIC 2854698"
{
	RA      19.46173096
	Dec     38.014122
	AppMagn 14.138
	MassSol 0.88
	RadSol  0.86
	Teff    5250
	FeH    -0.034
}

Star	"Kepler-261/KOI-988/KIC 2302548"
{
	RA      19.42431844
	Dec     37.609184
	AppMagn 13.562
	MassSol 0.87
	RadSol  0.79
	Teff    5098
	FeH     0.14
}

Star	"Kepler-262/KOI-993/KIC 1718189"
{
	RA      19.38191121
	Dec     37.252651
	AppMagn 14.246
	MassSol 0.97
	RadSol  0.88
	Teff    5841
	FeH    -0.115
}

Star	"Kepler-263/KOI-999/KIC 2165002"
{
	RA      19.49798381
	Dec     37.567795
	AppMagn 15.391
	MassSol 0.829
	RadSol  0.79
	Teff    5265
	FeH    -0.11
}

Star	"Kepler-264/KOI-1001/KIC 1871056"
{
	RA      19.46964111
	Dec     37.376247
	AppMagn 13.038
	MassSol 1.32
	RadSol  1.55
	Teff    6158
	FeH    -0.19
}

Star	"Kepler-265/KOI-1052/KIC 5956342"
{
	RA      19.3673645
	Dec     41.24482
	AppMagn 15.381
	MassSol 1.03
	RadSol  1.1
	Teff    5835
	FeH    -0.311
}

Star	"Kepler-266/KOI-1070/KIC 8240904"
{
	RA      19.63229167
	Dec     44.166916
	AppMagn 15.59
	MassSol 0.99
	RadSol  1.03
	Teff    5885
	FeH     0.106
}

Star	"Kepler-267/KOI-1078/KIC 10166274"
{
	RA      19.98869222
	Dec     47.157459
	AppMagn 15.438
	MassSol 0.56
	RadSol  0.56
	Teff    4258
	FeH     0.028
}

Star	"Kepler-268/KOI-1113/KIC 2854914"
{
	RA      19.46507772
	Dec     38.055077
	AppMagn 13.703
	MassSol 1.074
	RadSol  1.27
	Teff    6081
	FeH    -0.114
}

Star	"Kepler-269/KOI-1127/KIC 6359320"
{
	RA      19.34767863
	Dec     41.775967
	AppMagn 15.808
	MassSol 0.98
	RadSol  0.96
	Teff    5847
	FeH     0.02
}

Star	"Kepler-27/KOI-841/KIC 5792202"
{
	RA      19.48245033
	Dec     41.085876
	AppMagn 15.855
	MassSol 0.65
	RadSol  0.59
	Teff    5400
	FeH     0.41
}

Star	"Kepler-270/KOI-1148/KIC 8410727"
{
	RA      18.81334025
	Dec     44.422302
	AppMagn 13.908
	MassSol 1.155
	RadSol  1.46
	Teff    6067
	FeH    -0.151
}

Star	"Kepler-271/KOI-1151/KIC 8280511"
{
	RA      18.86686605
	Dec     44.284233
	AppMagn 13.404
	MassSol 0.82
	RadSol  0.88
	Teff    5524
	FeH    -0.951
}

Star	"Kepler-272/KOI-1161/KIC 10426656"
{
	RA      19.94183553
	Dec     47.59383
	AppMagn 14.678
	MassSol 0.79
	RadSol  0.93
	Teff    5297
	FeH    -0.161
}

Star	"Kepler-273/KOI-1163/KIC 10468940"
{
	RA      19.42014771
	Dec     47.697758
	AppMagn 14.968
	MassSol 0.777
	RadSol  0.81
	Teff    5626
	FeH    -0.478
}

Star	"Kepler-274/KOI-1196/KIC 3348082"
{
	RA      19.528184
	Dec     38.477276
	AppMagn 15.035
	MassSol 0.987
	RadSol  1.01
	Teff    6023
	FeH    -0.188
}

Star	"Kepler-275/KOI-1198/KIC 3447722"
{
	RA      19.49864705
	Dec     38.514927
	AppMagn 15.319
	MassSol 1.24
	RadSol  1.38
	Teff    6165
	FeH     0.184
}

Star	"Kepler-276/KOI-1203/KIC 3962243"
{
	RA      19.57111333
	Dec     39.0364
	AppMagn 15.368
	MassSol 0.96
	RadSol  0.95
	Teff    5812
	FeH     0.012
}

Star	"Kepler-277/KOI-1215/KIC 3939150"
{
	RA      19.10555333
	Dec     39.0772
	AppMagn 13.4
	MassSol 1.19
	RadSol  1.65
	Teff    6306
	FeH    -0.315
}

Star	"Kepler-278/KOI-1221/KIC 3640905"
{
	RA      19.34047852
	Dec     38.702236
	AppMagn 11.584
	MassSol 1.298
	RadSol  2.94
	Teff    4991
	FeH     0.422
}

Star	"Kepler-279/KOI-1236/KIC 6677841"
{
	RA      19.15944667
	Dec     42.195
	AppMagn 13.7
	MassSol 1.23
	RadSol  1.27
	Teff    6562
	FeH    -0.57
}

Star	"Kepler-28/KOI-870/KIC 6949607"
{
	RA      19.4758016
	Dec     42.42942
	AppMagn 15.036
	MassSol 0.75
	RadSol  0.7
	Teff    4590
	FeH     0.34
}

Star	"Kepler-280/KOI-1240/KIC 6690082"
{
	RA      19.42603353
	Dec     42.180588
	AppMagn 14.466
	MassSol 0.91
	RadSol  0.89
	Teff    5744
	FeH    -0.169
}

Star	"Kepler-281/KOI-1258/KIC 8630788"
{
	RA      19.60721232
	Dec     44.770699
	AppMagn 15.773
	MassSol 0.98
	RadSol  0.9
	Teff    5723
	FeH     0.012
}

Star	"Kepler-282/KOI-1278/KIC 8609450"
{
	RA      17.97861333
	Dec     44.7975
	AppMagn 15.2
	MassSol 1.09
	RadSol  1.01
	Teff    5876
	FeH    -0.374
}

Star	"Kepler-283/KOI-1298/KIC 10604335"
{
	RA      19.57424927
	Dec     47.838997
	AppMagn 15.847
	MassSol 0.76
	RadSol  0.57
	Teff    4351
	FeH    -0.26
}

Star	"Kepler-284/KOI-1301/KIC 10538176"
{
	RA      19.54309896
	Dec     47.729649
	AppMagn 15.824
	MassSol 0.908
	RadSol  0.81
	Teff    5615
	FeH    -0.145
}

Star	"Kepler-285/KOI-1305/KIC 10730034"
{
	RA      19.42605998
	Dec     48.065609
	AppMagn 15.173
	MassSol 0.85
	RadSol  0.81
	Teff    5411
	FeH    -0.063
}

Star	"Kepler-286/KOI-1306/KIC 10858691"
{
	RA      19.37840983
	Dec     48.294289
	AppMagn 15.587
	MassSol 0.996
	RadSol  0.86
	Teff    5580
	FeH    -0.165
}

Star	"Kepler-287/KOI-1307/KIC 10973814"
{
	RA      19.39516398
	Dec     48.44355
	AppMagn 14.775
	MassSol 0.947
	RadSol  1.03
	Teff    5806
	FeH    -0.077
}

Star	"Kepler-288/KOI-1332/KIC 4455231"
{
	RA      19.26109416
	Dec     39.594715
	AppMagn 15.151
	MassSol 0.89
	RadSol  1.09
	Teff    5918
	FeH    -0.219
}

Star	"Kepler-289/KOI-1353/KIC 7303287"
{
	RA      19.83102214
	Dec     42.882851
	Dist    700
	AppMagn 12.9
	MassSol 1.08
	RadSol  1
	Teff    5990
	FeH     0.05
	Age     0.65
}

Star	"Kepler-29/KOI-738/KIC 10358759"
{
	RA      19.88988827
	Dec     47.491226
	Dist    1400
	AppMagn 15.5
	MassSol 0.98
	RadSol  0.93
	Teff    5701
	FeH    -0.04
}

Star	"Kepler-290/KOI-1360/KIC 7102227"
{
	RA      19.09399821
	Dec     42.681553
	AppMagn 15.596
	MassSol 0.848
	RadSol  0.74
	Teff    5147
	FeH    -0.061
}

Star	"Kepler-291/KOI-1363/KIC 6936909"
{
	RA      19.19442342
	Dec     42.437302
	AppMagn 15.934
	MassSol 1.03
	RadSol  1.02
	Teff    6002
	FeH     0.07
}

Star	"Kepler-292/KOI-1364/KIC 6962977"
{
	RA      19.71774292
	Dec     42.424286
	AppMagn 15.956
	MassSol 0.88
	RadSol  0.83
	Teff    5299
	FeH     0.077
}

Star	"Kepler-293/KOI-1366/KIC 6932987"
{
	RA      19.09053752
	Dec     42.406509
	AppMagn 15.368
	MassSol 1.01
	RadSol  0.96
	Teff    5804
	FeH     0.134
}

Star	"Kepler-294/KOI-1396/KIC 9455556"
{
	RA      19.15946655
	Dec     46.059311
	AppMagn 15.843
	MassSol 1.032
	RadSol  0.98
	Teff    5913
	FeH    -0.001
}

Star	"Kepler-295/KOI-1413/KIC 9006449"
{
	RA      19.02305705
	Dec     45.367786
	AppMagn 14.447
	MassSol 0.8
	RadSol  0.9
	Teff    5603
	FeH    -0.332
}

Star	"Kepler-297/KOI-1426/KIC 11122894"
{
	RA      18.88061117
	Dec     48.777645
	AppMagn 14.232
	MassSol 1.04
	RadSol  0.92
	Teff    5619
	FeH    -0.12
}

Star	"Kepler-298/KOI-1430/KIC 11176127"
{
	RA      18.86931966
	Dec     48.825359
	AppMagn 15.415
	MassSol 0.65
	RadSol  0.58
	Teff    4465
	FeH    -0.121
}

Star	"Kepler-299/KOI-1432/KIC 11014932"
{
	RA      18.88046468
	Dec     48.580502
	AppMagn 15.017
	MassSol 0.97
	RadSol  1.03
	Teff    5617
	FeH    -0.052
}

Star	"Kepler-3/KOI-3/KIC 10748390/HIP 97657/HAT-P-11"
{
	RA      19.84722222
	Dec     48.0808333
	Dist    38
	AppMagn 9.59
	Class  "K4"
	MassSol 0.81
	RadSol  0.75
	Teff    4780
	FeH     0.31
	Age     6.5
}

Star	"Kepler-30/KOI-806/KIC 3832474"
{
	RA      19.01888889
	Dec     38.9472222
	Dist    1400
	AppMagn 15.5
	MassSol 0.99
	RadSol  0.95
	Teff    5498
	FeH     0.18
}

Star	"Kepler-300/KOI-1435/KIC 11037335"
{
	RA      19.68591309
	Dec     48.59972
	AppMagn 14.201
	MassSol 0.94
	RadSol  0.9
	Teff    5986
	FeH    -0.238
}

Star	"Kepler-301/KOI-1436/KIC 11389771"
{
	RA      18.93219808
	Dec     49.23299
	AppMagn 14.271
	MassSol 0.91
	RadSol  0.9
	Teff    5815
	FeH    -0.178
}

Star	"Kepler-302/KOI-1486/KIC 7898352"
{
	RA      19.62113241
	Dec     43.629345
	AppMagn 15.505
	MassSol 0.966
	RadSol  1.22
	Teff    5740
	FeH    -0.238
}

Star	"Kepler-303/KOI-1515/KIC 7871954"
{
	RA      18.87569784
	Dec     43.657055
	AppMagn 14.39
	MassSol 0.59
	RadSol  0.48
	Teff    3944
	FeH     0.102
}

Star	"Kepler-304/KOI-1557/KIC 5371776"
{
	RA      19.6294515
	Dec     40.557587
	AppMagn 14.84
	MassSol 0.8
	RadSol  0.69
	Teff    4731
	FeH     0.523
}

Star	"Kepler-305/KOI-1563/KIC 5219234"
{
	RA      19.94833333
	Dec     40.3431
	AppMagn 15.8
	MassSol 0.83
	RadSol  0.87
	Teff    4918
	FeH    -0.071
}

Star	"Kepler-306/KOI-1567/KIC 5438099"
{
	RA      19.23591105
	Dec     40.616138
	AppMagn 15.565
	MassSol 0.82
	RadSol  0.72
	Teff    4954
	FeH     0.155
}

Star	"Kepler-307/KOI-1576/KIC 5299459"
{
	RA      19.8530088
	Dec     40.417703
	AppMagn 14.1
	MassSol 0.91
	RadSol  0.81
	Teff    5367
	FeH     0.19
}

Star	"Kepler-308/KOI-1593/KIC 5289854"
{
	RA      19.71901042
	Dec     40.439548
	AppMagn 15.809
	MassSol 1
	RadSol  0.94
	Teff    5895
	FeH    -0.112
}

Star	"Kepler-309/KOI-1596/KIC 10027323"
{
	RA      19.83399048
	Dec     46.961281
	AppMagn 15.157
	MassSol 0.51
	RadSol  0.72
	Teff    4713
	FeH     0.415
}

Star	"Kepler-31/KOI-935/KIC 9347899"
{
	RA      19.60153427
	Dec     45.853081
	Dist    2100
	AppMagn 15.5
	MassSol 1.21
	RadSol  1.22
	Teff    6340
	FeH    -0.076
}

Star	"Kepler-310/KOI-1598/KIC 10004738"
{
	RA      19.25595703
	Dec     46.986744
	AppMagn 14.279
	MassSol 0.85
	RadSol  0.88
	Teff    5797
	FeH    -0.299
}

Star	"Kepler-311/KOI-1608/KIC 10055126"
{
	RA      18.80408529
	Dec     47.085491
	AppMagn 13.797
	MassSol 1.06
	RadSol  1.19
	Teff    5905
	FeH    -0.057
}

Star	"Kepler-312/KOI-1628/KIC 6975129"
{
	RA      19.89305216
	Dec     42.459755
	AppMagn 12.949
	MassSol 1.23
	RadSol  1.47
	Teff    6115
	FeH     0.076
}

Star	"Kepler-313/KOI-1647/KIC 11153121"
{
	RA      19.88632812
	Dec     48.775459
	AppMagn 14.167
	MassSol 0.9
	RadSol  1.54
	Teff    5727
	FeH    -0.112
}

Star	"Kepler-314/KOI-1692/KIC 6616218"
{
	RA      19.64494019
	Dec     42.075588
	AppMagn 12.557
	MassSol 1.02
	RadSol  0.95
	Teff    5378
	FeH     0.157
}

Star	"Kepler-315/KOI-1707/KIC 7703955"
{
	RA      19.86820679
	Dec     43.363522
	AppMagn 15.321
	MassSol 0.78
	RadSol  1.04
	Teff    5796
	FeH    -0.403
}

Star	"Kepler-316/KOI-1713/KIC 8230616"
{
	RA      19.38840129
	Dec     44.184109
	AppMagn 15.224
	MassSol 0.53
	RadSol  0.52
	Teff    4204
	FeH    -0.48
}

Star	"Kepler-317/KOI-1760/KIC 3967760"
{
	RA      19.66292521
	Dec     39.032063
	AppMagn 15.377
	MassSol 0.95
	RadSol  0.94
	Teff    5497
	FeH     0.258
}

Star	"Kepler-318/KOI-1779/KIC 9909735"
{
	RA      19.89885457
	Dec     46.793617
	AppMagn 13.297
	MassSol 1.05
	RadSol  1.19
	Teff    5746
	FeH     0.145
}

Star	"Kepler-319/KOI-1805/KIC 4644952"
{
	RA      19.25413005
	Dec     39.770657
	AppMagn 13.828
	MassSol 1.29
	RadSol  0.9
	Teff    5526
	FeH     0.487
}

Star	"Kepler-32/KOI-952/KIC 9787239"
{
	RA      19.85615987
	Dec     46.574281
	Dist    303
	AppMagn 16.452
	Class  "M1V"
	MassSol 0.58
	RadSol  0.53
	Teff    3900
	FeH     0
}

Star	"Kepler-320/KOI-1806/KIC 9529744"
{
	RA      19.5475708
	Dec     46.175125
	AppMagn 13.474
	MassSol 1.084
	RadSol  1.11
	Teff    6435
	FeH    -0.244
}

Star	"Kepler-321/KOI-1809/KIC 8240797"
{
	RA      19.63024495
	Dec     44.145756
	AppMagn 12.706
	MassSol 1.01
	RadSol  1.19
	Teff    5740
}

Star	"Kepler-322/KOI-1820/KIC 8277797"
{
	RA      18.75658773
	Dec     44.295242
	AppMagn 13.53
	MassSol 0.91
	RadSol  0.89
	Teff    5388
	FeH    -0.06
}

Star	"Kepler-323/KOI-1824/KIC 2989404"
{
	RA      19.42548218
	Dec     38.127472
	AppMagn 12.722
	MassSol 1.09
	RadSol  1.18
	Teff    5987
	FeH    -0.078
}

Star	"Kepler-324/KOI-1831/KIC 11601584"
{
	RA      19.09809774
	Dec     49.649021
	AppMagn 14.122
	MassSol 0.86
	RadSol  0.84
	Teff    5194
	FeH    -0.009
}

Star	"Kepler-325/KOI-1832/KIC 11709244"
{
	RA      19.32236328
	Dec     49.825626
	AppMagn 15.009
	MassSol 0.87
	RadSol  1
	Teff    5752
	FeH    -0.171
}

Star	"Kepler-326/KOI-1835/KIC 9471268"
{
	RA      19.62170207
	Dec     46.002254
	AppMagn 13.693
	MassSol 0.98
	RadSol  0.8
	Teff    5105
	FeH     0.133
}

Star	"Kepler-327/KOI-1867/KIC 8167996"
{
	RA      19.50949097
	Dec     44.087673
	AppMagn 15.018
	MassSol 0.55
	RadSol  0.49
	Teff    3799
	FeH    -0.042
}

Star	"Kepler-328/KOI-1873/KIC 4939346"
{
	RA      19.22083333
	Dec     46.7714
	AppMagn 15.674
	MassSol 0.98
	RadSol  0.97
	Teff    5314
	FeH    -0.186
}

Star	"Kepler-329/KOI-1874/KIC 8978528"
{
	RA      19.95120239
	Dec     45.227428
	AppMagn 15.434
	MassSol 0.53
	RadSol  0.52
	Teff    4257
	FeH    -0.572
}

Star	"Kepler-33/KOI-707/KIC 9458613"
{
	RA      19.27183633
	Dec     46.005222
	AppMagn 13.988
	MassSol 1.29
	RadSol  1.82
	Teff    5904
	FeH     0.025
	Age     4.27
}

Star	"Kepler-330/KOI-1891/KIC 8680979"
{
	RA      19.22982585
	Dec     44.801685
	AppMagn 15.261
	MassSol 0.78
	RadSol  0.72
	Teff    5117
	FeH    -0.097
}

Star	"Kepler-331/KOI-1895/KIC 4263293"
{
	RA      19.45562134
	Dec     39.307358
	AppMagn 15.862
	MassSol 0.51
	RadSol  0.49
	Teff    4347
	FeH    -0.85
}

Star	"Kepler-332/KOI-1905/KIC 10328393"
{
	RA      19.11086426
	Dec     47.4137
	AppMagn 14.017
	MassSol 0.8
	RadSol  0.72
	Teff    4955
	FeH     0.05
}

Star	"Kepler-333/KOI-1908/KIC 5706966"
{
	RA      19.48573812
	Dec     40.913586
	AppMagn 14.731
	MassSol 0.54
	RadSol  0.53
	Teff    4259
	FeH    -0.472
}

Star	"Kepler-334/KOI-1909/KIC 10130039"
{
	RA      19.14271037
	Dec     47.115196
	AppMagn 12.776
	MassSol 1
	RadSol  1.07
	Teff    5828
	FeH    -0.074
}

Star	"Kepler-335/KOI-1915/KIC 9101496"
{
	RA      19.73762004
	Dec     45.428623
	AppMagn 13.996
	MassSol 0.99
	RadSol  1.85
	Teff    5877
	FeH    -0.106
}

Star	"Kepler-336/KOI-1916/KIC 6037581"
{
	RA      19.34917603
	Dec     41.331371
	AppMagn 13.598
	MassSol 0.89
	RadSol  1.3
	Teff    5867
	FeH    -0.401
}

Star	"Kepler-337/KOI-1929/KIC 10136549"
{
	RA      19.33736572
	Dec     47.163956
	AppMagn 12.727
	MassSol 0.96
	RadSol  1.76
	Teff    5684
	FeH    -0.131
}

Star	"Kepler-338/KOI-1930/KIC 5511081"
{
	RA      18.86526286
	Dec     40.784348
	AppMagn 12.119
	MassSol 1.1
	RadSol  1.74
	Teff    5923
	FeH    -0.106
}

Star	"Kepler-339/KOI-1931/KIC 10978763"
{
	RA      19.55678101
	Dec     48.444641
	AppMagn 14.531
	MassSol 0.84
	RadSol  0.8
	Teff    5631
	FeH    -0.237
}

Star	"Kepler-340/KOI-1932/KIC 5202905"
{
	RA      19.72889811
	Dec     40.300571
	AppMagn 12.345
	MassSol 2.11
	RadSol  1.85
	Teff    6620
	FeH    -0.094
}

Star	"Kepler-341/KOI-1952/KIC 7747425"
{
	RA      19.32410482
	Dec     43.472775
	AppMagn 14.601
	MassSol 0.94
	RadSol  1.02
	Teff    6012
	FeH    -0.139
}

Star	"Kepler-342/KOI-1955/KIC 9892816"
{
	RA      19.51187134
	Dec     46.726715
	AppMagn 13.147
	MassSol 1.13
	RadSol  1.47
	Teff    6175
	FeH    -0.053
}

Star	"Kepler-343/KOI-1960/KIC 6949061"
{
	RA      19.46404622
	Dec     42.433006
	AppMagn 14.128
	MassSol 1.04
	RadSol  1.43
	Teff    5807
	FeH    -0.138
}

Star	"Kepler-344/KOI-1970/KIC 9650808"
{
	RA      19.49997559
	Dec     46.324406
	AppMagn 15.378
	MassSol 0.9
	RadSol  0.98
	Teff    5774
	FeH    -0.097
}

Star	"Kepler-345/KOI-1977/KIC 9412760"
{
	RA      19.68191935
	Dec     45.97102
	AppMagn 14.028
	MassSol 0.59
	RadSol  0.62
	Teff    4504
	FeH    -0.266
}

Star	"Kepler-346/KOI-1978/KIC 9518318"
{
	RA      19.20079346
	Dec     46.117607
	AppMagn 15.214
	MassSol 0.97
	RadSol  1.02
	Teff    6033
	FeH    -0.031
}

Star	"Kepler-347/KOI-1992/KIC 11450414"
{
	RA      19.27997233
	Dec     49.305717
	AppMagn 14.513
	MassSol 1.04
	RadSol  1
	Teff    6088
	FeH    -0.068
}

Star	"Kepler-348/KOI-2011/KIC 5384079"
{
	RA      19.81700236
	Dec     40.548374
	AppMagn 12.556
	MassSol 1.15
	RadSol  1.36
	Teff    6177
	FeH    -0.039
}

Star	"Kepler-349/KOI-2022/KIC 8564674"
{
	RA      19.57843221
	Dec     44.615578
	AppMagn 14.746
	MassSol 0.97
	RadSol  0.93
	Teff    5956
	FeH    -0.091
}

Star	"Kepler-350/KOI-2025/KIC 4636578"
{
	RA      19.02805333
	Dec     39.7061
	AppMagn 13.8
	MassSol 1.03
	RadSol  1.33
	Teff    6215
	FeH    -0.308
}

Star	"Kepler-351/KOI-2028/KIC 7102316"
{
	RA      19.09684652
	Dec     42.657879
	AppMagn 15.99
	MassSol 0.89
	RadSol  0.85
	Teff    5643
	FeH    -0.134
}

Star	"Kepler-352/KOI-2029/KIC 9489524"
{
	RA      19.99310099
	Dec     46.051975
	AppMagn 12.957
	MassSol 0.79
	RadSol  0.78
	Teff    5212
	FeH    -0.175
}

Star	"Kepler-353/KOI-2036/KIC 6382217"
{
	RA      19.79044189
	Dec     41.758179
	AppMagn 15.773
	MassSol 0.54
	RadSol  0.5
	Teff    3903
	FeH    -0.194
}

Star	"Kepler-354/KOI-2045/KIC 6026438"
{
	RA      19.05009766
	Dec     41.33564
	AppMagn 15.549
	MassSol 0.65
	RadSol  0.67
	Teff    4648
	FeH    -0.036
}

Star	"Kepler-355/KOI-2051/KIC 7265298"
{
	RA      19.05329793
	Dec     42.811783
	AppMagn 15.087
	MassSol 1.05
	RadSol  1.07
	Teff    6184
	FeH    -0.051
}

Star	"Kepler-356/KOI-2053/KIC 2307415"
{
	RA      19.49473877
	Dec     37.682819
	AppMagn 12.992
	MassSol 0.97
	RadSol  1.33
	Teff    6133
	FeH    -0.325
}

Star	"Kepler-357/KOI-2073/KIC 8164257"
{
	RA      19.41620687
	Dec     44.00872
	AppMagn 15.565
	MassSol 0.78
	RadSol  0.83
	Teff    5036
	FeH     0.051
}

Star	"Kepler-358/KOI-2080/KIC 10864531"
{
	RA      19.54868164
	Dec     48.281376
	AppMagn 15.375
	MassSol 0.95
	RadSol  0.95
	Teff    5908
	FeH    -0.027
}

Star	"Kepler-359/KOI-2092/KIC 6696580"
{
	RA      19.55290934
	Dec     42.196354
	AppMagn 15.886
	MassSol 1.07
	RadSol  1.09
	Teff    6248
	FeH    -0.039
}

Star	"Kepler-36/KOI-277/KIC 11401755"
{
	RA      19.41666667
	Dec     49.2319444
	Dist    470
	AppMagn 12
	MassSol 1.113
	RadSol  1.66
	Teff    5900
	FeH    -0.2
	Age     6.923
}

Star	"Kepler-360/KOI-2111/KIC 8612275"
{
	RA      19.0856486
	Dec     44.781555
	AppMagn 14.866
	MassSol 0.95
	RadSol  1.06
	Teff    6053
	FeH    -0.12
}

Star	"Kepler-361/KOI-2135/KIC 9904006"
{
	RA      19.78689779
	Dec     46.741154
	AppMagn 13.573
	MassSol 1.07
	RadSol  1.34
	Teff    6169
	FeH    -0.137
}

Star	"Kepler-362/KOI-2147/KIC 10404582"
{
	RA      19.45144246
	Dec     47.529903
	AppMagn 14.5
	MassSol 0.77
	RadSol  0.72
	Teff    5788
	FeH    -0.718
}

Star	"Kepler-363/KOI-2148/KIC 6021193"
{
	RA      18.87947184
	Dec     41.305393
	AppMagn 13.353
	MassSol 1.23
	RadSol  1.49
	Teff    5593
	FeH     0.299
}

Star	"Kepler-364/KOI-2153/KIC 10253547"
{
	RA      18.77132975
	Dec     47.398697
	AppMagn 13.66
	MassSol 1.2
	RadSol  1.28
	Teff    6108
	FeH    -0.026
}

Star	"Kepler-365/KOI-2163/KIC 11358389"
{
	RA      19.70843913
	Dec     49.130436
	AppMagn 14.651
	MassSol 0.99
	RadSol  1.05
	Teff    6012
	FeH    -0.046
}

Star	"Kepler-366/KOI-2168/KIC 11308499"
{
	RA      19.79013672
	Dec     49.084446
	AppMagn 14.842
	MassSol 1.05
	RadSol  1.05
	Teff    6209
	FeH    -0.081
}

Star	"Kepler-367/KOI-2173/KIC 11774991"
{
	RA      19.81949463
	Dec     49.981632
	AppMagn 12.879
	MassSol 0.75
	RadSol  0.69
	Teff    4710
	FeH     0.247
}

Star	"Kepler-368/KOI-2175/KIC 9022166"
{
	RA      19.45866903
	Dec     45.387936
	AppMagn 12.848
	MassSol 0.71
	RadSol  2.02
	Teff    5502
	FeH    -0.489
}

Star	"Kepler-369/KOI-2179/KIC 10670119"
{
	RA      19.57828166
	Dec     47.908466
	AppMagn 15.673
	MassSol 0.54
	RadSol  0.47
	Teff    3591
	FeH     0.207
}

Star	"Kepler-37/KOI-245/KIC 8478994"
{
	RA      18.97308333
	Dec     44.51817
	Dist    66
	AppMagn 10.3
	MassSol 0.803
	RadSol  0.77
	Teff    5417
	FeH    -0.32
	Age     6
}

Star	"Kepler-370/KOI-2183/KIC 5706595"
{
	RA      19.47807414
	Dec     40.916306
	AppMagn 15.198
	MassSol 0.94
	RadSol  0.9
	Teff    5852
	FeH    -0.124
}

Star	"Kepler-371/KOI-2194/KIC 3548044"
{
	RA      19.4884318
	Dec     38.657589
	AppMagn 13.865
	MassSol 0.94
	RadSol  0.99
	Teff    5666
	FeH    -0.223
}

Star	"Kepler-372/KOI-2195/KIC 11401767"
{
	RA      19.41707967
	Dec     49.258953
	AppMagn 14.881
	MassSol 1.15
	RadSol  1.14
	Teff    6509
	FeH    -0.137
}

Star	"Kepler-373/KOI-2218/KIC 12058204"
{
	RA      19.29253337
	Dec     50.59705
	AppMagn 14.514
	MassSol 0.87
	RadSol  0.84
	Teff    5787
	FeH    -0.272
}

Star	"Kepler-374/KOI-2220/KIC 6871071"
{
	RA      19.60919596
	Dec     42.370502
	AppMagn 14.686
	MassSol 0.84
	RadSol  0.91
	Teff    5977
	FeH    -0.441
}

Star	"Kepler-375/KOI-2236/KIC 10723367"
{
	RA      19.24119466
	Dec     48.098415
	AppMagn 15.699
	MassSol 0.89
	RadSol  0.84
	Teff    5826
	FeH    -0.197
}

Star	"Kepler-376/KOI-2278/KIC 3342794"
{
	RA      19.44047852
	Dec     38.410385
	AppMagn 13.776
	MassSol 1.05
	RadSol  1.18
	Teff    5900
	FeH    -0.151
}

Star	"Kepler-377/KOI-2279/KIC 3661886"
{
	RA      19.6947998
	Dec     38.735691
	AppMagn 13.86
	MassSol 0.88
	RadSol  1.22
	Teff    5949
	FeH    -0.497
}

Star	"Kepler-378/KOI-2287/KIC 9718066"
{
	RA      19.66323853
	Dec     46.438641
	AppMagn 12.485
	MassSol 0.96
	RadSol  0.67
	Teff    4661
	FeH     0.553
}

Star	"Kepler-379/KOI-2289/KIC 3867615"
{
	RA      19.71340739
	Dec     38.945831
	AppMagn 13.358
	MassSol 1.08
	RadSol  1.31
	Teff    6054
	FeH    -0.045
}

Star	"Kepler-380/KOI-2333/KIC 11121752"
{
	RA      18.82630819
	Dec     48.75914
	AppMagn 13.652
	MassSol 1.05
	RadSol  1.22
	Teff    6045
	FeH    -0.144
}

Star	"Kepler-381/KOI-2352/KIC 8013439"
{
	RA      19.01218669
	Dec     43.831089
	AppMagn 10.421
	MassSol 1.34
	RadSol  1.57
	Teff    6152
}

Star	"Kepler-382/KOI-2374/KIC 9364290"
{
	RA      19.9424113
	Dec     45.869934
	AppMagn 14.623
	MassSol 0.8
	RadSol  0.94
	Teff    5600
	FeH    -0.314
}

Star	"Kepler-383/KOI-2413/KIC 3234598"
{
	RA      19.42283936
	Dec     38.363132
	AppMagn 15.07
	MassSol 0.67
	RadSol  0.67
	Teff    4710
	FeH    -0.157
}

Star	"Kepler-384/KOI-2414/KIC 8611832"
{
	RA      19.0684082
	Dec     44.782871
	AppMagn 13.584
	MassSol 0.76
	RadSol  0.88
	Teff    5577
	FeH    -0.567
}

Star	"Kepler-385/KOI-2433/KIC 11968463"
{
	RA      19.6225647
	Dec     50.336544
	AppMagn 15.212
	MassSol 1.09
	RadSol  1.13
	Teff    6326
	FeH    -0.034
}

Star	"Kepler-386/KOI-2442/KIC 11080405"
{
	RA      19.32392375
	Dec     48.693855
	AppMagn 15.629
	MassSol 0.74
	RadSol  0.77
	Teff    5178
	FeH    -0.225
}

Star	"Kepler-387/KOI-2443/KIC 9209624"
{
	RA      19.18654582
	Dec     45.656715
	AppMagn 13.987
	MassSol 1.03
	RadSol  1.05
	Teff    5774
	FeH    -0.233
}

Star	"Kepler-388/KOI-2466/KIC 8544992"
{
	RA      18.98853556
	Dec     44.60873
	AppMagn 14.993
	MassSol 0.59
	RadSol  0.59
	Teff    4498
	FeH    -0.329
}

Star	"Kepler-389/KOI-2473/KIC 8753896"
{
	RA      19.46399943
	Dec     44.900024
	AppMagn 15.77
	MassSol 0.78
	RadSol  0.79
	Teff    5376
	FeH    -0.191
}

Star	"Kepler-39/KOI-423/KIC 9478990"
{
	RA      19.79722222
	Dec     46.0344444
	Dist    1200
	AppMagn 14.3
	Class  "F7IV"
	MassSol 1.1
	RadSol  1.39
	Teff    6260
	FeH    -0.29
	Age     5.08
}

Star	"Kepler-390/KOI-2498/KIC 5959719"
{
	RA      19.44191895
	Dec     41.208603
	AppMagn 13.942
	MassSol 0.67
	RadSol  0.78
	Teff    5166
	FeH    -0.539
}

Star	"Kepler-391/KOI-2541/KIC 12306058"
{
	RA      19.37478841
	Dec     51.057304
	AppMagn 13.007
	MassSol 1.22
	RadSol  3.57
	Teff    4940
	FeH     0.02
}

Star	"Kepler-392/KOI-2585/KIC 7673841"
{
	RA      19.24405111
	Dec     43.368084
	AppMagn 13.455
	MassSol 1.13
	RadSol  1.13
	Teff    5938
	FeH    -0.297
}

Star	"Kepler-393/KOI-2595/KIC 8883329"
{
	RA      19.39968465
	Dec     45.192215
	AppMagn 13.223
	MassSol 1.32
	RadSol  1.38
	Teff    6189
	FeH    -0.217
}

Star	"Kepler-394/KOI-2597/KIC 12120307"
{
	RA      19.75346273
	Dec     50.672318
	AppMagn 14.79
	MassSol 1.11
	RadSol  1.13
	Teff    6402
	FeH    -0.129
}

Star	"Kepler-395/KOI-2650/KIC 8890150"
{
	RA      19.56740723
	Dec     45.136597
	AppMagn 15.987
	MassSol 0.53
	RadSol  0.56
	Teff    4262
	FeH    -0.163
}

Star	"Kepler-396/KOI-2672/KIC 11253827"
{
	RA      19.74222
	Dec     48.8106
	AppMagn 11.921
	MassSol 0.81
	RadSol  1.04
	Teff    5384
	FeH    -0.129
}

Star	"Kepler-397/KOI-2681/KIC 6878240"
{
	RA      19.7262736
	Dec     42.380451
	AppMagn 15.996
	MassSol 0.736
	RadSol  0.77
	Teff    5307
	FeH    -0.035
}

Star	"Kepler-398/KOI-2693/KIC 5185897"
{
	RA      19.4312439
	Dec     40.343853
	AppMagn 13.256
	MassSol 0.698
	RadSol  0.61
	Teff    4493
	FeH    -0.046
}

Star	"Kepler-399/KOI-2707/KIC 5480640"
{
	RA      19.96678263
	Dec     40.670807
	AppMagn 14.467
	MassSol 0.707
	RadSol  0.68
	Teff    5502
	FeH    -0.827
}

Star	"Kepler-4/KOI-7/KIC 11853905"
{
	RA      19.04111111
	Dec     50.1358333
	Dist    550
	AppMagn 12.7
	Class  "G0"
	MassSol 1.223
	RadSol  1.487
	Teff    5857
	FeH     0.17
	Age     4.5
}

Star	"Kepler-40/KOI-428/KIC 10418224"
{
	RA      19.7875
	Dec     47.5266667
	Dist    2700
	AppMagn 14.76
	Class  "F5IV"
	MassSol 1.48
	RadSol  2.13
	Teff    6510
	FeH     0.1
	Age     2.8
}

Star	"Kepler-400/KOI-2711/KIC 5272233"
{
	RA      19.39629924
	Dec     40.480034
	AppMagn 13.642
	MassSol 1.07
	RadSol  1.15
	Teff    5886
	FeH     0.009
}

Star	"Kepler-401/KOI-2714/KIC 12206313"
{
	RA      19.33885091
	Dec     50.863483
	AppMagn 13.312
	MassSol 1.051
	RadSol  1.33
	Teff    6117
	FeH    -0.297
}

Star	"Kepler-402/KOI-2722/KIC 7673192"
{
	RA      19.22468262
	Dec     43.35461
	AppMagn 13.268
	MassSol 1.14
	RadSol  1.26
	Teff    6090
	FeH    -0.22
}

Star	"Kepler-403/KOI-2732/KIC 9886361"
{
	RA      19.32809652
	Dec     46.74456
	AppMagn 12.805
	MassSol 1.102
	RadSol  1.33
	Teff    6090
	FeH    -0.145
}

Star	"Kepler-404/KOI-2768/KIC 9008737"
{
	RA      19.09324137
	Dec     45.343533
	AppMagn 15.228
	MassSol 0.952
	RadSol  0.88
	Teff    5654
	FeH    -0.009
}

Star	"Kepler-405/KOI-3057/KIC 3234843"
{
	RA      19.42729696
	Dec     38.340031
	AppMagn 15.855
	MassSol 0.965
	RadSol  0.89
	Teff    5818
	FeH    -0.131
}

Star	"Kepler-406/KOI-321/KIC 8753657"
{
	RA      19.45653611
	Dec     44.96822224
	AppMagn 12.52
	MassSol 1.07
	RadSol  1.07
	Teff    5538
	FeH     0.18
	Age     5.84
}

Star	"Kepler-407/KOI-1442/KIC 11600889"
{
	RA      19.06908973
	Dec     49.614506
	AppMagn 12.521
	MassSol 1
	RadSol  1.01
	Teff    5476
	FeH     0.33
}

Star	"Kepler-408/KOI-1612/KIC 10963065"
{
	RA      18.98583333
	Dec     48.42305557
	AppMagn 9
	MassSol 1.08
	RadSol  1.23
	Teff    6104
	FeH    -0.2
	Age     6.68
}

Star	"Kepler-409/KOI-1925/KIC 9955598"
{
	RA      19.57861389
	Dec     46.8527778
	Dist    66.8
	AppMagn 9.439
	MassSol 0.92
	RadSol  0.89
	Teff    5460
	FeH     0.08
	Age     6.98
}

Star	"Kepler-41/KOI-196/KIC 9410930"
{
	RA      19.63416667
	Dec     45.9816667
	Dist    730
	AppMagn 14.5
	Class  "G2V"
	MassSol 0.94
	RadSol  0.966
	Teff    5660
	FeH    -0.09
	Age     7.4
}

Star	"Kepler-411/KOI-1781/KIC 11551692"
{
	RA      19.17370547
	Dec     49.523262
	AppMagn 12.5
	MassSol 0.83
	RadSol  0.79
	Teff    4974
	FeH     0.23
}

Star	"Kepler-412/KOI-202/KIC 7877496"
{
	RA      19.0740214
	Dec     43.680958
	Dist    1056
	AppMagn 13.73
	Class  "G3V"
	MassSol 1.17
	RadSol  1.29
	Teff    5750
	FeH     0.27
	Age     5.1
}

Star	"Kepler-414/KOI-341/KIC 10878263"
{
	RA      19.8641052
	Dec     48.244362
	AppMagn 13.338
	MassSol 0.89
	RadSol  0.95
	Teff    5523
}

Star	"Kepler-415/KOI-1194/KIC 3554031"
{
	RA      19.58696287
	Dec     38.63913
	AppMagn 15.842
	MassSol 0.67
	RadSol  0.64
	Teff    4523
}

Star	"Kepler-416/KOI-1860/KIC 4157325"
{
	RA      19.43713173
	Dec     39.227287
	AppMagn 14.028
	MassSol 1
	RadSol  1.07
	Teff    5977
}

Star	"Kepler-417/KOI-2113/KIC 7207061"
{
	RA      19.58828733
	Dec     42.779705
	AppMagn 15.886
	MassSol 0.9
	RadSol  0.81
	Teff    5376
}

Star	"Kepler-418/KOI-1089/KIC 3247268"
{
	RA      19.62888889
	Dec     38.35555557
	AppMagn 15
	MassSol 0.98
	RadSol  1.094
	Teff    5820
	FeH    -0.05
	Age     7
}

Star	"Kepler-419/KOI-1474/KIC 12365184"
{
	RA      19.69444445
	Dec     51.1847222
	AppMagn 14
	MassSol 1.22
	RadSol  1.4
	Teff    6230
	FeH     0
	Age     2.8
}

Star	"Kepler-42/KOI-961/KIC 8561063"
{
	RA      19.48138889
	Dec     44.6194444
	Dist    38.7
	AppMagn 16.12
	Class  "M"
	MassSol 0.13
	RadSol  0.17
	Teff    3068
	FeH    -0.48
}

Star	"Kepler-421/KOI-1274/KIC 8800954"
{
	RA      18.88378907
	Dec     45.087776
	Dist    320
	AppMagn 13.354
	Class  "G9"
	MassSol 0.79
	RadSol  0.76
	Teff    5308
	FeH    -0.25
	Age     4
}

Star	"Kepler-422/KOI-22/KIC 9631995"
{
	RA      18.841975
	Dec     46.32336112
	AppMagn 13.642
	MassSol 1.15
	RadSol  1.24
	Teff    5972
	FeH     0.23
}

Star	"Kepler-423/KOI-183/KIC 9651668"
{
	RA      19.52371111
	Dec     46.39117779
	Dist    725
	AppMagn 14.499
	Class  "G4V"
	MassSol 1.07
	RadSol  0.99
	Teff    5790
	FeH     0.26
}

Star	"Kepler-424/KOI-214/KIC 11046458"
{
	RA      19.90833056
	Dec     48.57745002
	AppMagn 14.497
	MassSol 1.01
	RadSol  0.94
	Teff    5460
	FeH     0.44
}

Star	"Kepler-425/KOI-188/KIC 5357901"
{
	RA      19.35722222
	Dec     40.56777779
	Dist    650
	AppMagn 15
	Class  "K1V"
	MassSol 0.93
	RadSol  0.86
	Teff    5170
	FeH     0.24
	Age     5
}

Star	"Kepler-426/KOI-195/KIC 11502867"
{
	RA      19.29555556
	Dec     49.47333335
	Dist    880
	AppMagn 15
	Class  "G1V"
	MassSol 0.91
	RadSol  0.92
	Teff    5725
	FeH    -0.21
	Age     6
}

Star	"Kepler-427/KOI-192/KIC 7950644"
{
	RA      19.21694444
	Dec     43.70500002
	Dist    1100
	AppMagn 14.5
	Class  "G2V"
	MassSol 0.96
	RadSol  1.35
	Teff    5800
	FeH    -0.19
	Age     7
}

Star	"Kepler-428/KOI-830/KIC 5358624"
{
	RA      19.37222222
	Dec     40.57750002
	Dist    730
	AppMagn 15.5
	Class  "K1V"
	MassSol 0.87
	RadSol  0.8
	Teff    5150
	FeH     0.09
	Age     5
}

Star	"Kepler-43/KOI-135/KIC 9818381"
{
	RA      19.01611111
	Dec     46.6683333
	Dist    1950
	AppMagn 14
	Class  "G0V"
	MassSol 1.32
	RadSol  1.42
	Teff    6041
	FeH     0.33
	Age     2.8
}

Star	"Kepler-430/KOI-2365/KIC 11560897"
{
	RA      19.52058333
	Dec     49.57944447
	AppMagn 13.848
	MassSol 1.166
	RadSol  1.485
	Teff    5884
	FeH     0.2
}

Star	"Kepler-431/KOI-3097/KIC 7582689"
{
	RA      18.74080556
	Dec     43.22780557
	AppMagn 11.973
	MassSol 1.071
	RadSol  1.092
	Teff    6004
	FeH     0.07
}

Star	"Kepler-432/KOI-1299/KIC 10864656"
{
	RA      19.5521464
	Dec     48.2859
	Dist    870
	AppMagn 12.465
	Class  "K2III"
	MassSol 1.32
	RadSol  4.06
	Teff    4995
	FeH    -0.07
	Age     3.6
}

Star	"Kepler-433/KOI-206/KIC 5728139"
{
	RA      19.8395772
	Dec     40.977268
	Dist    1870
	AppMagn 14.463
	MassSol 1.46
	RadSol  2.26
	Teff    6360
	FeH    -0.01
}

Star	"Kepler-434/KOI-614/KIC 7368664"
{
	RA      19.57242633
	Dec     42.928913
	Dist    1240
	AppMagn 14.517
	MassSol 1.2
	RadSol  1.38
	Teff    5977
	FeH     0.25
}

Star	"Kepler-435/KOI-680/KIC 7529266"
{
	RA      19.48582153
	Dec     43.197281
	Dist    2070
	AppMagn 13.643
	MassSol 1.54
	RadSol  3.21
	Teff    6161
	FeH    -0.18
}

Star	"Kepler-436/KOI-2529/KIC 8463346"
{
	RA      20.11472222
	Dec     44.41194446
	Dist    618
	AppMagn 16.3
	MassSol 0.729
	RadSol  0.697
	Teff    4551
	FeH     0.01
	Age     3
}

Star	"Kepler-437/KOI-3255/KIC 8183288"
{
	RA      19.82305556
	Dec     44.02694445
	Dist    417
	AppMagn 7.2
	MassSol 0.707
	RadSol  0.68
	Teff    4551
	FeH     0
	Age     2.9
}

Star	"Kepler-438/KOI-3284/KIC 6497146"
{
	RA      18.77638889
	Dec     41.95111113
	Dist    145
	AppMagn 9.55
	MassSol 0.544
	RadSol  0.52
	Teff    3748
	FeH     0.16
	Age     4.4
}

Star	"Kepler-439/KOI-4005/KIC 8142787"
{
	RA      18.72
	Dec     44.03388889
	Dist    693
	AppMagn 14.56
	MassSol 0.884
	RadSol  0.866
	Teff    5431
	FeH     0.02
	Age     7.2
}

Star	"Kepler-44/KOI-204/KIC 9305831"
{
	RA      20.00694445
	Dec     45.7622222
	Dist    2250
	AppMagn 15
	Class  "G2IV"
	MassSol 1.19
	RadSol  1.52
	Teff    5757
	FeH     0.26
	Age     6.95
}

Star	"Kepler-440/KOI-4087/KIC 6106282"
{
	RA      19.02333333
	Dec     41.45222223
	Dist    261
	AppMagn 8.33
	MassSol 0.575
	RadSol  0.559
	Teff    4134
	FeH    -0.3
	Age     1.3
}

Star	"Kepler-441/KOI-4622/KIC 11284772"
{
	RA      18.97111111
	Dec     49.01277779
	Dist    284
	AppMagn 8.02
	MassSol 0.572
	RadSol  0.55
	Teff    4340
	FeH    -0.57
	Age     1.9
}

Star	"Kepler-442/KOI-4742/KIC 4138008"
{
	RA      19.02444445
	Dec     39.28000002
	Dist    342
	AppMagn 7.73
	MassSol 0.609
	RadSol  0.598
	Teff    4402
	FeH    -0.37
	Age     2.9
}

Star	"Kepler-443/KOI-4745/KIC 11757451"
{
	RA      19.24083333
	Dec     49.96861113
	Dist    779
	AppMagn 6.83
	MassSol 0.738
	RadSol  0.706
	Teff    4723
	FeH    -0.01
	Age     3.2
}

Star	"Kepler-445/KOI-2704/KIC 9730163"
{
	RA      19.91573687
	Dec     46.498554
	Dist    90
	AppMagn 17.475
	Class  "M4"
	MassSol 0.18
	RadSol  0.21
	Teff    3157
	FeH     0.27
}

Star	"Kepler-446/KOI-2842/KIC 8733898"
{
	RA      18.81666667
	Dec     44.92111113
	Dist    120
	AppMagn 16.5
	Class  "M4"
	MassSol 0.22
	RadSol  0.24
	Teff    3359
	FeH    -0.3
}

Star	"Kepler-447/KOI-1800/KIC 11017901"
{
	RA      19.01790567
	Dec     48.560013
	AppMagn 12.394
	Class  "G8V"
	MassSol 1
	RadSol  1.05
	Teff    5493
	FeH     0.07
}

Star	"Kepler-448/KOI-12/KIC 5812701"
{
	RA      19.83024778
	Dec     41.01099723
	Dist    426
	AppMagn 11.51
	MassSol 1.452
	RadSol  1.63
	Teff    6820
	FeH     0.09
	Age     1.5
}

Star	"Kepler-449/KOI-270/KIC 6528464"
{
	RA      19.58218889
	Dec     41.90083335
	AppMagn 11.411
	MassSol 0.969
	RadSol  1.467
	Teff    5552
}

Star	"Kepler-45/KOI-254/KIC 5794240"
{
	RA      19.525
	Dec     41.0641667
	Dist    333
	AppMagn 16.88
	Class  "M"
	MassSol 0.59
	RadSol  0.55
	Teff    3820
	FeH     0.08
}

Star	"Kepler-450/KOI-279/KIC 12314973"
{
	RA      19.6991
	Dec     51.01350001
	AppMagn 11.684
	MassSol 1.346
	RadSol  1.57
	Teff    6152
	FeH    -0.342
}

Star	"Kepler-452"
{
	RA      19.73357861
	Dec     44.27756113
	AppMagn 13.7
	Class  "G2"
	MassSol 1.037
	RadSol  1.11
	Teff    5757
	FeH     0.21
	Age     6
}

Star	"Kepler-454/KOI-273/KIC 3102384"
{
	RA      19.16523527
	Dec     38.228866
	AppMagn 11.57
	MassSol 1.03
	RadSol  1.07
	Teff    5701
	FeH     0.27
	Age     5.25
}

Star	"Kepler-455/KOI-4307/KIC 3558849"
{
	RA      19.66332195
	Dec     38.6051889
	AppMagn 14.218
	MassSol 0.98
	RadSol  1.005
	Teff    6175
	FeH    -0.42
}

Star	"Kepler-456/KIC 5951458"
{
	RA      19.266105
	Dec     41.22303334
	AppMagn 11.382 // not V mag
	MassSol 0.98
	RadSol  1.52
	Teff    6258
	FeH    -0.5
}

Star	"Kepler-457/KIC 8540376"
{
	RA      18.82516917
	Dec     44.69458891
	AppMagn 13.014 // not V mag
	MassSol 1.04
	RadSol  1.26
	Teff    6474
	FeH    -0.16
}

Star	"Kepler-458/KOI-179/KIC 9663113"
{
	RA      19.80302807
	Dec     46.328701
	AppMagn 13.955
	MassSol 0.98
	RadSol  1.03
	Teff    6065
	FeH    -0.28
}

Star	"Kepler-46/KOI-872/KIC 7109675"
{
	RA      19.28472222
	Dec     42.6041667
	Dist    857
	AppMagn 15.3
	MassSol 0.902
	RadSol  0.94
	Teff    5155
	FeH     0.41
	Age     9.9
}

Star	"Kepler-460/KOI-3791/KIC 5437945"
{
	RA      19.23165713
	Dec     40.651357
	AppMagn 13.771
	MassSol 1.07
	RadSol  1.24
	Teff    6340
	FeH    -0.38
}

Star	"Kepler-461/KOI-49/KIC 9527334"
{
	RA      19.48327127
	Dec     46.164867
	Dist    468
	AppMagn 13.704
	MassSol 0.98
	RadSol  0.91
	Teff    5634
	FeH     0.04
}

Star	"Kepler-462/KOI-89/KIC 8056665"
{
	RA      19.988077
	Dec     43.814274
	Dist    733
	AppMagn 11.73
	MassSol 1.59
	RadSol  2.04
	Teff    7070
	FeH    -0.06
}

Star	"Kepler-463/KOI-105/KIC 8711794"
{
	RA      19.9291364
	Dec     44.85791
	Dist    336
	AppMagn 12.87
	MassSol 0.87
	RadSol  0.9
	Teff    5661
	FeH    -0.28
}

Star	"Kepler-464/KOI-107/KIC 11250587"
{
	RA      19.6556782
	Dec     48.982361
	Dist    653
	AppMagn 12.702
	MassSol 1.21
	RadSol  1.59
	Teff    5933
	FeH     0.19
}

Star	"Kepler-465/KOI-110/KIC 9450647"
{
	RA      18.97038133
	Dec     46.063828
	Dist    587
	AppMagn 12.663
	MassSol 1.23
	RadSol  1.29
	Teff    6310
	FeH     0.09
}

Star	"Kepler-466/KOI-112/KIC 10984090"
{
	RA      19.70991407
	Dec     48.495564
	Dist    436
	AppMagn 12.772
	MassSol 1.04
	RadSol  1.05
	Teff    5927
	FeH    -0.01
}

Star	"Kepler-467/KOI-118/KIC 3531558"
{
	RA      19.15752107
	Dec     38.649619
	Dist    458
	AppMagn 12.377
	MassSol 1.05
	RadSol  1.37
	Teff    5809
	FeH     0.06
}

Star	"Kepler-468"
{
	RA      19.26014933
	Dec     49.370487
	Dist    474
	AppMagn 12.115 // not V mag
	MassSol 0.96
	RadSol  0.87
	Teff    5498
	FeH     0.1
}

Star	"Kepler-469"
{
	RA      19.83172473
	Dec     41.114289
	Dist    714
	AppMagn 11.656 // not V mag
	MassSol 1.14
	RadSol  1.53
	Teff    5892
	FeH     0.14
}

Star	"Kepler-470/KOI-129/KIC 11974540"
{
	RA      19.80062933
	Dec     50.372314
	Dist    989
	AppMagn 13.224
	MassSol 1.4
	RadSol  1.66
	Teff    6613
	FeH     0.04
}

Star	"Kepler-471/KOI-131/KIC 7778437"
{
	RA      19.939836
	Dec     43.497593
	Dist    1373
	AppMagn 13.797
	MassSol 1.49
	RadSol  1.8
	Teff    6733
	FeH     0.07
}

Star	"Kepler-472/KOI-144/KIC 4180280"
{
	RA      19.76828707
	Dec     39.249776
	Dist    302
	AppMagn 13.698
	MassSol 0.85
	RadSol  0.78
	Teff    4996
	FeH     0.16
}

Star	"Kepler-473/KOI-149/KIC 3835670"
{
	RA      19.10867293
	Dec     38.945605
	Dist    641
	AppMagn 13.397
	MassSol 1.06
	RadSol  1.34
	Teff    5816
	FeH     0.12
}

Star	"Kepler-474/KOI-155/KIC 8030148"
{
	RA      19.48810107
	Dec     43.881168
	Dist    568
	AppMagn 13.494
	MassSol 0.99
	RadSol  1.08
	Teff    5785
	FeH    -0.01
}

Star	"Kepler-475/KOI-161/KIC 5084942"
{
	RA      19.13678047
	Dec     40.211542
	Dist    280
	AppMagn 13.341
	MassSol 0.86
	RadSol  0.79
	Teff    5009
	FeH     0.21
}

Star	"Kepler-476/KOI-162/KIC 8107380"
{
	RA      19.6775878
	Dec     43.963047
	Dist    687
	AppMagn 13.837
	MassSol 1.03
	RadSol  1.09
	Teff    5837
	FeH     0.04
}

Star	"Kepler-477"
{
	RA      19.20450627
	Dec     42.355367
	Dist    367
	AppMagn 11.832 // not V mag
	MassSol 0.87
	RadSol  0.79
	Teff    5240
	FeH    -0.04
}

Star	"Kepler-478/KOI-165/KIC 9527915"
{
	RA      19.4991296
	Dec     46.196213
	Dist    420
	AppMagn 13.938
	MassSol 0.85
	RadSol  0.8
	Teff    5210
	FeH    -0.03
}

Star	"Kepler-479/KOI-166/KIC 2441495"
{
	RA      19.4014568
	Dec     37.769803
	Dist    371
	AppMagn 13.575
	MassSol 0.86
	RadSol  0.81
	Teff    5247
	FeH    -0.02
}

Star	"Kepler-48/KOI-148/KIC 5735762"
{
	RA      19.9425
	Dec     40.9489
	AppMagn 13.04
	MassSol 0.88
	RadSol  0.89
	Teff    5194
	FeH     0.17
	Age     3.14
}

Star	"Kepler-480/KOI-167/KIC 11666881"
{
	RA      19.63092667
	Dec     49.765047
	Dist    806
	AppMagn 13.273
	MassSol 1.25
	RadSol  1.34
	Teff    6322
	FeH     0.11
}

Star	"Kepler-481/KOI-173/KIC 11402995"
{
	RA      19.4604688
	Dec     49.262054
	Dist    713
	AppMagn 13.844
	MassSol 1.01
	RadSol  1.09
	Teff    5802
	FeH     0.03
}

Star	"Kepler-482/KOI-174/KIC 10810838"
{
	RA      19.7881932
	Dec     48.107555
	Dist    290
	AppMagn 13.779
	MassSol 0.75
	RadSol  0.72
	Teff    4871
	FeH    -0.13
}

Star	"Kepler-483/KOI-176/KIC 6442377"
{
	RA      19.4431172
	Dec     41.884663
	Dist    953
	AppMagn 13.432
	MassSol 1.28
	RadSol  1.47
	Teff    6346
	FeH     0.09
}

Star	"Kepler-484/KOI-180/KIC 9573539"
{
	RA      18.95962027
	Dec     46.249081
	Dist    377
	AppMagn 13.024
	MassSol 0.96
	RadSol  0.87
	Teff    5668
	FeH    -0.1
}

Star	"Kepler-485/KOI-186/KIC 12019440"
{
	RA      19.66642087
	Dec     50.470066
	Dist    1173
	AppMagn 14.952
	MassSol 1.07
	RadSol  1.09
	Teff    5958
	FeH     0.04
}

Star	"Kepler-486/KOI-189/KIC 11391018"
{
	RA      18.9919976
	Dec     49.266994
	Dist    428
	AppMagn 14.388
	MassSol 0.79
	RadSol  0.75
	Teff    4926
	FeH    -0.04
}

Star	"Kepler-487/KOI-191/KIC 5972334"
{
	RA      19.6858148
	Dec     41.22197
	Dist    835
	AppMagn 14.991
	MassSol 0.91
	RadSol  0.88
	Teff    5444
	FeH     0
}

Star	"Kepler-488"
{
	RA      18.86441153
	Dec     48.34507
	Dist    1157
	AppMagn 13.403 // not V mag
	MassSol 1.07
	RadSol  1.09
	Teff    5970
	FeH     0.03
}

Star	"Kepler-489/KOI-197/KIC 2987027"
{
	RA      19.3888772
	Dec     38.184334
	Dist    379
	AppMagn 14.018
	MassSol 0.82
	RadSol  0.76
	Teff    5014
	FeH     0
}

Star	"Kepler-49/KOI-248/KIC 5364071"
{
	RA      19.48630573
	Dec     40.591801
	AppMagn 15.264
	MassSol 0.55
	RadSol  0.56
	Teff    4252
	FeH    -0.151
}

Star	"Kepler-490/KOI-199/KIC 10019708"
{
	RA      19.66837847
	Dec     46.956005
	Dist    1249
	AppMagn 14.879
	MassSol 1.08
	RadSol  1.12
	Teff    6045
	FeH    -0.02
}

Star	"Kepler-491/KOI-201/KIC 6849046"
{
	RA      19.14203833
	Dec     42.350155
	Dist    657
	AppMagn 14.014
	MassSol 1.04
	RadSol  1.03
	Teff    5582
	FeH     0.37
}

Star	"Kepler-492/KOI-205/KIC 7046804"
{
	RA      19.69977707
	Dec     42.537888
	Dist    642
	AppMagn 14.518
	MassSol 0.94
	RadSol  0.91
	Teff    5527
	FeH     0.07
}

Star	"Kepler-493/KOI-208/KIC 3762468"
{
	RA      19.68716933
	Dec     38.881639
	Dist    1942
	AppMagn 14.996
	MassSol 1.36
	RadSol  1.54
	Teff    6457
	FeH     0.11
}

Star	"Kepler-494/KOI-219/KIC 6305192"
{
	RA      19.8142726
	Dec     41.664039
	Dist    862
	AppMagn 14.153
	MassSol 1.1
	RadSol  1.26
	Teff    6007
	FeH     0.02
}

Star	"Kepler-495/KOI-221/KIC 3937519"
{
	RA      19.06204713
	Dec     39.098134
	Dist    630
	AppMagn 14.622
	MassSol 0.86
	RadSol  0.83
	Teff    5346
	FeH    -0.07
}

Star	"Kepler-496/KOI-226/KIC 5959753"
{
	RA      19.4427264
	Dec     41.241049
	Dist    655
	AppMagn 14.817
	MassSol 0.86
	RadSol  0.82
	Teff    5293
	FeH    -0.03
}

Star	"Kepler-497"
{
	RA      19.38439213
	Dec     38.927952
	Dist    1070
	AppMagn 13.287 // not V mag
	MassSol 1.09
	RadSol  1.11
	Teff    5834
	FeH     0.24
}

Star	"Kepler-498/KOI-234/KIC 8491277"
{
	RA      19.35720853
	Dec     44.518753
	Dist    746
	AppMagn 14.283
	MassSol 0.98
	RadSol  0.96
	Teff    5744
	FeH    -0.04
}

Star	"Kepler-499/KOI-235/KIC 8107225"
{
	RA      19.67399633
	Dec     43.915207
	Dist    523
	AppMagn 14.353
	MassSol 0.87
	RadSol  0.83
	Teff    5312
	FeH     0
}

Star	"Kepler-5/KOI-18/KIC 8191672"
{
	RA      19.96046753
	Dec     44.035046
	AppMagn 13.369
	MassSol 1.37
	RadSol  1.79
	Teff    6297
	FeH     0.04
}

Star	"Kepler-50/KOI-262/KIC 11807274"
{
	RA      19.20666667
	Dec     50.0336
	AppMagn 11
	MassSol 1.24
	RadSol  1.58
	Teff    6225
	FeH    -0.354
	Age     3.8
}

Star	"Kepler-500/KOI-237/KIC 8041216"
{
	RA      19.73009107
	Dec     43.852051
	Dist    747
	AppMagn 14.176
	MassSol 1.02
	RadSol  1.03
	Teff    5813
	FeH     0.03
}

Star	"Kepler-501/KOI-239/KIC 6383785"
{
	RA      19.81343693
	Dec     41.730206
	Dist    1044
	AppMagn 14.762
	MassSol 1.03
	RadSol  1.04
	Teff    5904
	FeH    -0.03
}

Star	"Kepler-502/KOI-240/KIC 8026752"
{
	RA      19.405342
	Dec     43.860203
	Dist    1433
	AppMagn 14.982
	MassSol 1.15
	RadSol  1.22
	Teff    6125
	FeH     0.05
}

Star	"Kepler-503/KOI-242/KIC 3642741"
{
	RA      19.3757656
	Dec     38.707669
	Dist    888
	AppMagn 14.747
	MassSol 1.01
	RadSol  1.01
	Teff    5754
	FeH     0.09
}

Star	"Kepler-504/KOI-249/KIC 9390653"
{
	RA      18.99478953
	Dec     45.972398
	Dist    75
	AppMagn 14.486
	MassSol 0.33
	RadSol  0.33
	Teff    3519
	FeH    -0.31
}

Star	"Kepler-505/KOI-255/KIC 7021681"
{
	RA      19.19054127
	Dec     42.542629
	Dist    222
	AppMagn 15.108
	MassSol 0.55
	RadSol  0.53
	Teff    3931
	FeH    -0.19
}

Star	"Kepler-506/KOI-257/KIC 5514383"
{
	RA      18.97567913
	Dec     40.719832
	Dist    231
	AppMagn 10.868
	MassSol 1.19
	RadSol  1.19
	Teff    6236
	FeH     0.09
}

Star	"Kepler-507/KOI-265/KIC 12024120"
{
	RA      19.8012556
	Dec     50.408981
	Dist    410
	AppMagn 11.994
	MassSol 1.16
	RadSol  1.32
	Teff    6113
	FeH     0.06
}

Star	"Kepler-508/KOI-266/KIC 7375348"
{
	RA      19.69362333
	Dec     42.981423
	Dist    325
	AppMagn 11.472
	MassSol 1.16
	RadSol  1.25
	Teff    6025
	FeH     0.18
}

Star	"Kepler-509/KOI-276/KIC 11133306"
{
	RA      19.31095987
	Dec     48.706207
	Dist    339
	AppMagn 11.854
	MassSol 1.1
	RadSol  1.2
	Teff    6060
	FeH     0.01
}

Star	"Kepler-51/KOI-620/KIC 11773022"
{
	RA      19.76528
	Dec     49.9378
	AppMagn 15
	MassSol 1
	RadSol  0.91
	Teff    5803
	FeH    -0.079
}

Star	"Kepler-510/KOI-281/KIC 4143755"
{
	RA      19.17700053
	Dec     39.24428
	Dist    378
	AppMagn 11.947
	MassSol 0.91
	RadSol  1.41
	Teff    5746
	FeH    -0.35
}

Star	"Kepler-511/KOI-289/KIC 10386922"
{
	RA      18.8630462
	Dec     47.574875
	Dist    448
	AppMagn 12.747
	MassSol 1
	RadSol  1.2
	Teff    5770
	FeH     0.01
}

Star	"Kepler-512/KOI-294/KIC 11259686"
{
	RA      19.88459733
	Dec     48.91674
	Dist    531
	AppMagn 12.674
	MassSol 1.17
	RadSol  1.3
	Teff    5997
	FeH     0.22
}

Star	"Kepler-513/KOI-296/KIC 11802615"
{
	RA      19.00277907
	Dec     50.075375
	Dist    467
	AppMagn 12.935
	MassSol 1.02
	RadSol  1.06
	Teff    5849
	FeH    -0.01
}

Star	"Kepler-514/KOI-297/KIC 11905011"
{
	RA      19.08314587
	Dec     50.242409
	Dist    489
	AppMagn 12.182
	MassSol 1.28
	RadSol  1.44
	Teff    6106
	FeH     0.36
}

Star	"Kepler-515/KOI-298/KIC 12785320"
{
	RA      19.36626087
	Dec     52.055611
	Dist    255
	AppMagn 12.713
	MassSol 0.9
	RadSol  0.83
	Teff    5293
	FeH     0.08
}

Star	"Kepler-516"
{
	RA      19.70725193
	Dec     38.735736
	Dist    777
	AppMagn 11.053 // not V mag
	MassSol 1.62
	RadSol  2.02
	Teff    7099
	FeH     0.01
}

Star	"Kepler-517/KOI-303/KIC 5966322"
{
	RA      19.57835567
	Dec     41.295348
	Dist    284
	AppMagn 12.193
	MassSol 0.95
	RadSol  0.98
	Teff    5690
	FeH    -0.06
}

Star	"Kepler-518/KOI-304/KIC 6029239"
{
	RA      19.13933147
	Dec     41.373873
	Dist    324
	AppMagn 12.549
	MassSol 0.96
	RadSol  0.88
	Teff    5842
	FeH    -0.23
}

Star	"Kepler-519/KOI-306/KIC 6071903"
{
	RA      19.95463587
	Dec     41.384647
	Dist    234
	AppMagn 12.63
	MassSol 0.89
	RadSol  0.8
	Teff    5260
	FeH     0.01
}

Star	"Kepler-52/KOI-775/KIC 11754553"
{
	RA      19.11583333
	Dec     49.9758
	AppMagn 15.5
	MassSol 0.54
	RadSol  0.52
	Teff    4075
	FeH    -0.289
}

Star	"Kepler-520/KOI-307/KIC 6289257"
{
	RA      19.5453548
	Dec     41.617763
	Dist    492
	AppMagn 12.797
	MassSol 1.1
	RadSol  1.09
	Teff    6112
	FeH    -0.03
}

Star	"Kepler-521/KOI-317/KIC 8121310"
{
	RA      19.92109173
	Dec     43.998039
	Dist    737
	AppMagn 12.885
	MassSol 1.34
	RadSol  1.46
	Teff    6406
	FeH     0.25
}

Star	"Kepler-522/KOI-318/KIC 8156120"
{
	RA      19.2102664
	Dec     44.068821
	Dist    749
	AppMagn 12.211
	MassSol 1.54
	RadSol  1.98
	Teff    6392
	FeH     0.41
}

Star	"Kepler-523/KOI-323/KIC 9139084"
{
	RA      18.93740867
	Dec     45.506855
	Dist    270
	AppMagn 12.465
	MassSol 0.93
	RadSol  0.86
	Teff    5515
	FeH    -0.03
}

Star	"Kepler-524/KOI-330/KIC 11361646"
{
	RA      19.79061447
	Dec     49.162048
	Dist    730
	AppMagn 13.928
	MassSol 1.09
	RadSol  1.1
	Teff    6014
	FeH     0.02
}

Star	"Kepler-525/KOI-331/KIC 10285631"
{
	RA      19.7455622
	Dec     47.358761
	Dist    566
	AppMagn 13.497
	MassSol 0.95
	RadSol  1.15
	Teff    5573
	FeH     0.11
}

Star	"Kepler-526/KOI-332/KIC 10290666"
{
	RA      19.84339553
	Dec     47.396294
	Dist    504
	AppMagn 13.046
	MassSol 1.15
	RadSol  1.14
	Teff    5894
	FeH     0.34
}

Star	"Kepler-527/KOI-333/KIC 10337258"
{
	RA      19.39719407
	Dec     47.406284
	Dist    901
	AppMagn 13.39
	MassSol 1.28
	RadSol  1.45
	Teff    6388
	FeH     0.03
}

Star	"Kepler-528/KOI-337/KIC 10545066"
{
	RA      19.71232093
	Dec     47.748081
	Dist    711
	AppMagn 13.936
	MassSol 1.01
	RadSol  1.06
	Teff    5807
	FeH     0.02
}

Star	"Kepler-529/KOI-339/KIC 10587105"
{
	RA      19.0592246
	Dec     47.880386
	Dist    787
	AppMagn 13.763
	MassSol 1.07
	RadSol  1.14
	Teff    6087
	FeH    -0.1
}

Star	"Kepler-53/KOI-829/KIC 5358241"
{
	RA      19.36416667
	Dec     40.5625
	AppMagn 16
	MassSol 0.98
	RadSol  0.89
	Teff    5858
	FeH    -0.204
}

Star	"Kepler-530/KOI-344/KIC 11015108"
{
	RA      18.88935253
	Dec     48.549046
	Dist    464
	AppMagn 13.4
	MassSol 0.97
	RadSol  0.89
	Teff    5697
	FeH    -0.08
}

Star	"Kepler-531/KOI-345/KIC 11074541"
{
	RA      19.10165413
	Dec     48.683601
	Dist    254
	AppMagn 13.34
	MassSol 0.78
	RadSol  0.75
	Teff    4893
	FeH    -0.03
}

Star	"Kepler-532/KOI-346/KIC 11100383"
{
	RA      19.91072767
	Dec     48.606373
	Dist    325
	AppMagn 13.524
	MassSol 0.87
	RadSol  0.79
	Teff    5192
	FeH     0
}

Star	"Kepler-533/KOI-348/KIC 11194032"
{
	RA      19.57904907
	Dec     48.825146
	Dist    305
	AppMagn 13.933
	MassSol 0.78
	RadSol  0.72
	Teff    4758
	FeH     0.01
}

Star	"Kepler-534/KOI-354/KIC 11568987"
{
	RA      19.76123727
	Dec     49.540104
	Dist    473
	AppMagn 13.235
	MassSol 1.05
	RadSol  0.98
	Teff    5884
	FeH     0.01
}

Star	"Kepler-535/KOI-355/KIC 11621223"
{
	RA      19.7711094
	Dec     49.696251
	Dist    678
	AppMagn 13.174
	MassSol 1.18
	RadSol  1.27
	Teff    6123
	FeH     0.13
}

Star	"Kepler-536/KOI-356/KIC 11624249"
{
	RA      19.849092
	Dec     49.637154
	Dist    446
	AppMagn 13.807
	MassSol 0.92
	RadSol  0.89
	Teff    5524
	FeH     0
}

Star	"Kepler-537/KOI-361/KIC 12404954"
{
	RA      19.3253756
	Dec     51.277081
	Dist    465
	AppMagn 13.1
	MassSol 1.07
	RadSol  0.99
	Teff    5763
	FeH     0.23
}

Star	"Kepler-538/KOI-365/KIC 11623629"
{
	RA      19.83246007
	Dec     49.623455
	Dist    165
	AppMagn 11.195
	MassSol 0.96
	RadSol  0.9
	Teff    5650
	FeH    -0.05
}

Star	"Kepler-539/KOI-372/KIC 6471021"
{
	RA      19.94149693
	Dec     41.86676
	Dist    313
	AppMagn 13
	Class  "G2V"
	MassSol 1.05
	RadSol  0.95
	Teff    5820
	FeH    -0.01
	Age     1
}

Star	"Kepler-54/KOI-886/KIC 7455287"
{
	RA      19.65159507
	Dec     43.056293
	AppMagn 15.847
	MassSol 0.51
	RadSol  0.55
	Teff    4252
	FeH    -0.036
}

Star	"Kepler-540/KOI-374/KIC 8686097"
{
	RA      19.3750168
	Dec     44.873962
	Dist    350
	AppMagn 12.209
	MassSol 1.02
	RadSol  1.08
	Teff    5946
	FeH    -0.1
}

Star	"Kepler-541/KOI-384/KIC 3353050"
{
	RA      19.60997793
	Dec     38.458259
	Dist    1020
	AppMagn 13.281
	MassSol 1.41
	RadSol  2.06
	Teff    6166
	FeH     0.07
}

Star	"Kepler-542/KOI-385/KIC 3446746"
{
	RA      19.48100593
	Dec     38.548588
	Dist    439
	AppMagn 13.435
	MassSol 0.93
	RadSol  0.9
	Teff    5526
	FeH     0.02
}

Star	"Kepler-543/KOI-387/KIC 3733628"
{
	RA      19.14791513
	Dec     38.862513
	Dist    212
	AppMagn 13.577
	MassSol 0.7
	RadSol  0.67
	Teff    4671
	FeH    -0.19
}

Star	"Kepler-544/KOI-393/KIC 3964109"
{
	RA      19.60193987
	Dec     39.051846
	Dist    797
	AppMagn 13.542
	MassSol 1.16
	RadSol  1.22
	Teff    6206
	FeH     0.02
}

Star	"Kepler-545/KOI-409/KIC 5444548"
{
	RA      19.37108687
	Dec     40.692045
	Dist    831
	AppMagn 14.15
	MassSol 1.04
	RadSol  1.07
	Teff    5882
	FeH     0.03
}

Star	"Kepler-546/KOI-412/KIC 5683743"
{
	RA      18.88383993
	Dec     40.990498
	Dist    896
	AppMagn 14.288
	MassSol 1.11
	RadSol  1.15
	Teff    5967
	FeH     0.14
}

Star	"Kepler-547/KOI-420/KIC 8352537"
{
	RA      19.0745782
	Dec     44.34528
	Dist    361
	AppMagn 14.247
	MassSol 0.78
	RadSol  0.73
	Teff    4828
	FeH     0.01
}

Star	"Kepler-548/KOI-421/KIC 9115800"
{
	RA      19.99372733
	Dec     45.439678
	Dist    776
	AppMagn 14.995
	MassSol 0.93
	RadSol  0.9
	Teff    5535
	FeH     0
}

Star	"Kepler-549/KOI-427/KIC 10189546"
{
	RA      18.86818593
	Dec     47.261135
	Dist    648
	AppMagn 14.621
	MassSol 0.88
	RadSol  0.84
	Teff    5360
	FeH    -0.03
}

Star	"Kepler-55/KOI-904/KIC 8150320"
{
	RA      19.01122233
	Dec     44.026466
	AppMagn 15.791
	MassSol 0.62
	RadSol  0.62
	Teff    4503
	FeH    -0.201
}

Star	"Kepler-550/KOI-429/KIC 10616679"
{
	RA      19.84668267
	Dec     47.86375
	Dist    563
	AppMagn 14.486
	MassSol 0.87
	RadSol  0.83
	Teff    5322
	FeH    -0.02
}

Star	"Kepler-551/KOI-430/KIC 10717241"
{
	RA      19.0323362
	Dec     48.054325
	Dist    312
	AppMagn 14.897
	MassSol 0.65
	RadSol  0.63
	Teff    4286
	FeH    -0.09
}

Star	"Kepler-552/KOI-432/KIC 10858832"
{
	RA      19.38317913
	Dec     48.242012
	Dist    834
	AppMagn 14.279
	MassSol 1.03
	RadSol  1.04
	Teff    5863
	FeH     0.01
}

Star	"Kepler-553/KOI-433/KIC 10937029"
{
	RA      19.9033886
	Dec     48.332455
	Dist    725
	AppMagn 14.924
	MassSol 0.92
	RadSol  0.85
	Teff    5266
	FeH     0.21
}

Star	"Kepler-554/KOI-439/KIC 12470954"
{
	RA      19.76045687
	Dec     51.358154
	Dist    642
	AppMagn 14.313
	MassSol 0.93
	RadSol  0.92
	Teff    5447
	FeH     0.14
}

Star	"Kepler-555/KOI-443/KIC 3833007"
{
	RA      19.0344568
	Dec     38.932408
	Dist    772
	AppMagn 14.2
	MassSol 1.03
	RadSol  1.04
	Teff    5894
	FeH     0
}

Star	"Kepler-556/KOI-444/KIC 3847138"
{
	RA      19.3686296
	Dec     38.942671
	Dist    729
	AppMagn 14.112
	MassSol 1
	RadSol  0.98
	Teff    5740
	FeH     0.03
}

Star	"Kepler-557/KOI-452/KIC 6291033"
{
	RA      19.58056387
	Dec     41.615135
	Dist    1126
	AppMagn 14.641
	MassSol 1.11
	RadSol  1.16
	Teff    6068
	FeH     0.02
}

Star	"Kepler-558/KOI-454/KIC 7098355"
{
	RA      18.97719253
	Dec     42.652676
	Dist    652
	AppMagn 14.805
	MassSol 0.85
	RadSol  0.81
	Teff    5242
	FeH    -0.06
}

Star	"Kepler-559/KOI-460/KIC 8043638"
{
	RA      19.77578893
	Dec     43.802792
	Dist    793
	AppMagn 14.743
	MassSol 0.96
	RadSol  0.95
	Teff    5630
	FeH     0.03
}

Star	"Kepler-56/KOI-1241/KIC 6448890"
{
	RA      19.58388667
	Dec     41.8719
	AppMagn 13
	MassSol 1.32
	RadSol  4.23
	Teff    4840
	FeH     0.2
	Age     3.5
}

Star	"Kepler-560/KOI-463/KIC 8845205"
{
	RA      20.01373967
	Dec     45.018147
	Dist    88
	AppMagn 14.708
	MassSol 0.34
	RadSol  0.33
	Teff    3556
	FeH    -0.39
}

Star	"Kepler-561/KOI-464/KIC 8890783"
{
	RA      19.58313973
	Dec     45.10722
	Dist    667
	AppMagn 14.361
	MassSol 0.96
	RadSol  0.94
	Teff    5646
	FeH     0.02
}

Star	"Kepler-562/KOI-467/KIC 9583881"
{
	RA      19.34130847
	Dec     46.273811
	Dist    822
	AppMagn 14.794
	MassSol 0.93
	RadSol  0.9
	Teff    5575
	FeH    -0.04
}

Star	"Kepler-563/KOI-468/KIC 9589524"
{
	RA      19.49641813
	Dec     46.289776
	Dist    557
	AppMagn 14.767
	MassSol 0.8
	RadSol  0.77
	Teff    5066
	FeH    -0.08
}

Star	"Kepler-564/KOI-470/KIC 9844088"
{
	RA      19.78922527
	Dec     46.626404
	Dist    830
	AppMagn 14.749
	MassSol 0.95
	RadSol  0.92
	Teff    5626
	FeH    -0.01
}

Star	"Kepler-565"
{
	RA      18.90786307
	Dec     47.196686
	Dist    1041
	AppMagn 13.52 // not V mag
	MassSol 0.98
	RadSol  0.95
	Teff    5735
	FeH    -0.02
}

Star	"Kepler-566/KOI-476/KIC 10599206"
{
	RA      19.4369664
	Dec     47.81448
	Dist    628
	AppMagn 14.958
	MassSol 0.83
	RadSol  0.79
	Teff    5132
	FeH    -0.01
}

Star	"Kepler-567/KOI-477/KIC 10934674"
{
	RA      19.844841
	Dec     48.302315
	Dist    568
	AppMagn 14.687
	MassSol 0.84
	RadSol  0.79
	Teff    5148
	FeH     0
}

Star	"Kepler-568/KOI-478/KIC 10990886"
{
	RA      19.87371387
	Dec     48.40115
	Dist    126
	AppMagn 14.273
	MassSol 0.55
	RadSol  0.53
	Teff    3768
	FeH     0.11
}

Star	"Kepler-569/KOI-479/KIC 11015323"
{
	RA      18.9004852
	Dec     48.552605
	Dist    645
	AppMagn 14.106
	MassSol 0.95
	RadSol  0.93
	Teff    5616
	FeH     0.01
}

Star	"Kepler-57/KOI-1270/KIC 8564587"
{
	RA      19.57611333
	Dec     44.6569
	AppMagn 15.5
	MassSol 0.83
	RadSol  0.73
	Teff    5145
	FeH    -0.045
}

Star	"Kepler-570/KOI-480/KIC 11134879"
{
	RA      19.36250573
	Dec     48.791885
	Dist    642
	AppMagn 14.332
	MassSol 0.93
	RadSol  0.9
	Teff    5496
	FeH     0.06
}

Star	"Kepler-571/KOI-483/KIC 11497977"
{
	RA      19.10340133
	Dec     49.418743
	Dist    756
	AppMagn 14.675
	MassSol 0.93
	RadSol  0.9
	Teff    5527
	FeH     0.01
}

Star	"Kepler-572/KOI-484/KIC 12061222"
{
	RA      19.41473873
	Dec     50.581303
	Dist    532
	AppMagn 14.472
	MassSol 0.83
	RadSol  0.79
	Teff    5212
	FeH    -0.1
}

Star	"Kepler-573/KOI-486/KIC 12404305"
{
	RA      19.3014108
	Dec     51.237316
	Dist    758
	AppMagn 14.118
	MassSol 0.99
	RadSol  1.02
	Teff    5746
	FeH     0.02
}

Star	"Kepler-574/KOI-487/KIC 12834874"
{
	RA      19.34980287
	Dec     52.149136
	Dist    747
	AppMagn 14.528
	MassSol 0.95
	RadSol  0.91
	Teff    5612
	FeH    -0.01
}

Star	"Kepler-575/KOI-488/KIC 2557816"
{
	RA      19.13092593
	Dec     37.8297
	Dist    852
	AppMagn 14.72
	MassSol 0.97
	RadSol  0.95
	Teff    5710
	FeH     0
}

Star	"Kepler-576/KOI-492/KIC 3559935"
{
	RA      19.67886133
	Dec     38.654231
	Dist    698
	AppMagn 14.424
	MassSol 0.99
	RadSol  0.97
	Teff    5672
	FeH     0.09
}

Star	"Kepler-577/KOI-494/KIC 3966801"
{
	RA      19.6474618
	Dec     39.073762
	Dist    549
	AppMagn 14.885
	MassSol 0.78
	RadSol  0.73
	Teff    4984
	FeH    -0.14
}

Star	"Kepler-578/KOI-496/KIC 4454752"
{
	RA      19.25033
	Dec     39.563656
	Dist    568
	AppMagn 14.411
	MassSol 0.87
	RadSol  0.83
	Teff    5334
	FeH    -0.03
}

Star	"Kepler-579/KOI-499/KIC 4847534"
{
	RA      19.6668026
	Dec     39.952923
	Dist    663
	AppMagn 14.272
	MassSol 0.99
	RadSol  0.96
	Teff    5636
	FeH     0.13
}

Star	"Kepler-58/KOI-1336/KIC 4077526"
{
	RA      19.75722
	Dec     39.1153
	AppMagn 15.3
	MassSol 0.95
	RadSol  1.03
	Teff    5843
	FeH    -0.12
}

Star	"Kepler-580/KOI-503/KIC 5340644"
{
	RA      18.89998767
	Dec     40.552805
	Dist    333
	AppMagn 15
	MassSol 0.67
	RadSol  0.64
	Teff    4298
	FeH    -0.06
}

Star	"Kepler-581/KOI-504/KIC 5461440"
{
	RA      19.6955188
	Dec     40.648247
	Dist    833
	AppMagn 14.56
	MassSol 1
	RadSol  1
	Teff    5772
	FeH     0.03
}

Star	"Kepler-582/KOI-507/KIC 5812960"
{
	RA      19.83357913
	Dec     41.057021
	Dist    751
	AppMagn 14.915
	MassSol 0.93
	RadSol  0.91
	Teff    5564
	FeH     0.01
}

Star	"Kepler-583/KOI-512/KIC 6838050"
{
	RA      18.807422
	Dec     42.354504
	Dist    805
	AppMagn 14.825
	MassSol 0.94
	RadSol  0.91
	Teff    5523
	FeH     0.07
}

Star	"Kepler-584/KOI-513/KIC 6937692"
{
	RA      19.21537287
	Dec     42.413624
	Dist    1445
	AppMagn 14.856
	MassSol 1.17
	RadSol  1.24
	Teff    6195
	FeH     0.02
}

Star	"Kepler-585/KOI-517/KIC 8015907"
{
	RA      19.10189993
	Dec     43.873405
	Dist    604
	AppMagn 14.034
	MassSol 0.96
	RadSol  0.93
	Teff    5593
	FeH     0.03
}

Star	"Kepler-586/KOI-526/KIC 9157634"
{
	RA      19.537148
	Dec     45.551193
	Dist    707
	AppMagn 14.427
	MassSol 0.94
	RadSol  0.92
	Teff    5575
	FeH     0
}

Star	"Kepler-587/KOI-530/KIC 10266615"
{
	RA      19.24471267
	Dec     47.399143
	Dist    852
	AppMagn 14.909
	MassSol 0.92
	RadSol  0.89
	Teff    5549
	FeH    -0.05
}

Star	"Kepler-588"
{
	RA      18.95048067
	Dec     47.688953
	Dist    972
	AppMagn 13.277 // not V mag
	MassSol 1.01
	RadSol  1
	Teff    5835
	FeH     0
}

Star	"Kepler-589/KOI-533/KIC 10513530"
{
	RA      18.70942447
	Dec     47.751954
	Dist    643
	AppMagn 14.68
	MassSol 0.88
	RadSol  0.83
	Teff    5296
	FeH     0.01
}

Star	"Kepler-59/KOI-1529/KIC 9821454"
{
	RA      19.13583333
	Dec     46.64
	AppMagn 14.8
	MassSol 1.04
	RadSol  0.94
	Teff    6074
	FeH    -0.253
}

Star	"Kepler-590/KOI-535/KIC 10873260"
{
	RA      19.75903627
	Dec     48.233448
	Dist    986
	AppMagn 14.434
	MassSol 1.1
	RadSol  1.15
	Teff    6000
	FeH     0.07
}

Star	"Kepler-591/KOI-536/KIC 10965008"
{
	RA      19.06826833
	Dec     48.43177
	Dist    793
	AppMagn 14.499
	MassSol 0.97
	RadSol  0.94
	Teff    5677
	FeH     0.01
}

Star	"Kepler-592/KOI-537/KIC 11073351"
{
	RA      19.05271233
	Dec     48.683262
	Dist    1034
	AppMagn 14.665
	MassSol 1.04
	RadSol  1.04
	Teff    5913
	FeH    -0.03
}

Star	"Kepler-593/KOI-538/KIC 11090765"
{
	RA      19.66343007
	Dec     48.651188
	Dist    1016
	AppMagn 14.56
	MassSol 1.08
	RadSol  1.1
	Teff    5967
	FeH     0.04
}

Star	"Kepler-594/KOI-541/KIC 11656721"
{
	RA      19.26143907
	Dec     49.762035
	Dist    742
	AppMagn 14.748
	MassSol 0.91
	RadSol  0.87
	Teff    5485
	FeH    -0.03
}

Star	"Kepler-595/KOI-547/KIC 12116489"
{
	RA      19.6380262
	Dec     50.673023
	Dist    639
	AppMagn 14.773
	MassSol 0.87
	RadSol  0.83
	Teff    5247
	FeH     0.08
}

Star	"Kepler-596/KOI-548/KIC 12600735"
{
	RA      19.30004507
	Dec     51.68573
	Dist    1083
	AppMagn 14.02
	MassSol 1.21
	RadSol  1.32
	Teff    6267
	FeH     0.03
}

Star	"Kepler-597/KOI-550/KIC 4165473"
{
	RA      19.56467373
	Dec     39.252808
	Dist    660
	AppMagn 14.07
	MassSol 0.97
	RadSol  0.95
	Teff    5683
	FeH    -0.01
}

Star	"Kepler-598/KOI-555/KIC 5709725"
{
	RA      19.54156153
	Dec     40.934766
	Dist    686
	AppMagn 14.759
	MassSol 0.87
	RadSol  0.86
	Teff    5307
	FeH     0.02
}

Star	"Kepler-599/KOI-557/KIC 5774349"
{
	RA      19.06076727
	Dec     41.069443
	Dist    627
	AppMagn 14.97
	MassSol 0.83
	RadSol  0.79
	Teff    5127
	FeH    -0.02
}

Star	"Kepler-6/KOI-17/KIC 10874614"
{
	RA      19.78915
	Dec     48.239964
	AppMagn 13.303
	MassSol 1.21
	RadSol  1.39
	Teff    5647
	FeH     0.34
	Age     3.8
}

Star	"Kepler-60/KOI-2086/KIC 6768394"
{
	RA      19.2640828
	Dec     42.265011
	AppMagn 14.5
	MassSol 1.04
	RadSol  1.26
	Teff    5905
	FeH    -0.09
}

Star	"Kepler-600/KOI-560/KIC 6501635"
{
	RA      18.92220393
	Dec     41.978649
	Dist    624
	AppMagn 14.721
	MassSol 0.84
	RadSol  0.81
	Teff    5279
	FeH    -0.09
}

Star	"Kepler-601/KOI-561/KIC 6665695"
{
	RA      18.80030747
	Dec     42.176533
	Dist    429
	AppMagn 14.005
	MassSol 0.85
	RadSol  0.79
	Teff    5160
	FeH    -0.02
}

Star	"Kepler-602/KOI-563/KIC 6707833"
{
	RA      19.73546553
	Dec     42.141949
	Dist    971
	AppMagn 14.519
	MassSol 1.08
	RadSol  1.13
	Teff    6062
	FeH    -0.02
}

Star	"Kepler-603/KOI-564/KIC 6786037"
{
	RA      19.61873213
	Dec     42.29097
	Dist    967
	AppMagn 14.854
	MassSol 1.01
	RadSol  1.01
	Teff    5808
	FeH     0.03
}

Star	"Kepler-604/KOI-566/KIC 7119481"
{
	RA      19.48773447
	Dec     42.626255
	Dist    981
	AppMagn 14.718
	MassSol 1.02
	RadSol  1.03
	Teff    5890
	FeH    -0.02
}

Star	"Kepler-605/KOI-568/KIC 7595157"
{
	RA      19.15302907
	Dec     43.279873
	Dist    570
	AppMagn 14.14
	MassSol 0.91
	RadSol  0.88
	Teff    5462
	FeH     0.02
}

Star	"Kepler-606/KOI-575/KIC 8367113"
{
	RA      19.49515853
	Dec     44.381268
	Dist    1208
	AppMagn 14.686
	MassSol 1.13
	RadSol  1.22
	Teff    6161
	FeH     0.01
}

Star	"Kepler-607/KOI-577/KIC 8558011"
{
	RA      19.40381373
	Dec     44.632381
	Dist    500
	AppMagn 14.405
	MassSol 0.84
	RadSol  0.8
	Teff    5196
	FeH    -0.02
}

Star	"Kepler-608/KOI-578/KIC 8565266"
{
	RA      19.5921954
	Dec     44.638096
	Dist    926
	AppMagn 14.684
	MassSol 1
	RadSol  1.01
	Teff    5820
	FeH    -0.02
}

Star	"Kepler-609/KOI-580/KIC 8625925"
{
	RA      19.4813542
	Dec     44.700031
	Dist    1143
	AppMagn 14.856
	MassSol 1.09
	RadSol  1.14
	Teff    5971
	FeH     0.06
}

Star	"Kepler-61/KOI-1361/KIC 6960913"
{
	RA      19.68694667
	Dec     42.4753
	AppMagn 15
	Class  "K7V"
	MassSol 0.635
	RadSol  0.62
	Teff    4017
	FeH     0.03
	Age     1
}

Star	"Kepler-610/KOI-581/KIC 8822216"
{
	RA      19.5447562
	Dec     45.065605
	Dist    1113
	AppMagn 14.807
	MassSol 1.1
	RadSol  1.13
	Teff    5943
	FeH     0.12
}

Star	"Kepler-611/KOI-583/KIC 9076513"
{
	RA      19.06699747
	Dec     45.480392
	Dist    906
	AppMagn 14.573
	MassSol 1.01
	RadSol  1.01
	Teff    5761
	FeH     0.06
}

Star	"Kepler-612/KOI-585/KIC 9279669"
{
	RA      19.4236426
	Dec     45.747898
	Dist    932
	AppMagn 14.911
	MassSol 0.98
	RadSol  0.96
	Teff    5693
	FeH     0.04
}

Star	"Kepler-613/KOI-586/KIC 9570741"
{
	RA      18.85245493
	Dec     46.244992
	Dist    864
	AppMagn 14.608
	MassSol 0.98
	RadSol  0.96
	Teff    5723
	FeH    -0.01
}

Star	"Kepler-614/KOI-587/KIC 9607164"
{
	RA      19.89232153
	Dec     46.276043
	Dist    571
	AppMagn 14.574
	MassSol 0.85
	RadSol  0.81
	Teff    5268
	FeH    -0.07
}

Star	"Kepler-615/KOI-588/KIC 9631762"
{
	RA      18.8300402
	Dec     46.321404
	Dist    330
	AppMagn 14.337
	MassSol 0.73
	RadSol  0.69
	Teff    4655
	FeH    -0.07
}

Star	"Kepler-616/KOI-593/KIC 9958962"
{
	RA      19.66594207
	Dec     46.838329
	Dist    1019
	AppMagn 14.957
	MassSol 0.98
	RadSol  0.97
	Teff    5753
	FeH    -0.02
}

Star	"Kepler-617/KOI-596/KIC 10388286"
{
	RA      18.91604733
	Dec     47.516293
	Dist    150
	AppMagn 14.818
	MassSol 0.51
	RadSol  0.48
	Teff    3712
	FeH    -0.07
}

Star	"Kepler-618/KOI-600/KIC 10718726"
{
	RA      19.08332113
	Dec     48.06094
	Dist    1115
	AppMagn 14.827
	MassSol 1.05
	RadSol  1.08
	Teff    5860
	FeH     0.08
}

Star	"Kepler-619/KOI-601/KIC 10973664"
{
	RA      19.3899372
	Dec     48.416016
	Dist    1111
	AppMagn 14.697
	MassSol 1.09
	RadSol  1.11
	Teff    5980
	FeH     0.05
}

Star	"Kepler-62/KOI-701/KIC 9002278"
{
	RA      18.88083333
	Dec     45.3499
	Dist    368
	AppMagn 14
	Class  "K2V"
	MassSol 0.69
	RadSol  0.63
	Teff    4869
	FeH    -0.21
}

Star	"Kepler-620/KOI-602/KIC 12459913"
{
	RA      19.41062607
	Dec     51.334866
	Dist    1241
	AppMagn 14.647
	MassSol 1.15
	RadSol  1.22
	Teff    6155
	FeH     0.03
}

Star	"Kepler-621/KOI-605/KIC 4832837"
{
	RA      19.3951524
	Dec     39.914145
	Dist    389
	AppMagn 14.915
	MassSol 0.72
	RadSol  0.68
	Teff    4521
	FeH    -0.02
}

Star	"Kepler-622/KOI-610/KIC 5686174"
{
	RA      18.96523147
	Dec     40.93311
	Dist    259
	AppMagn 14.672
	MassSol 0.64
	RadSol  0.61
	Teff    4201
	FeH    -0.09
}

Star	"Kepler-623/KOI-618/KIC 10353968"
{
	RA      19.79911473
	Dec     47.47739
	Dist    811
	AppMagn 14.959
	MassSol 0.9
	RadSol  0.86
	Teff    5443
	FeH    -0.03
}

Star	"Kepler-624/KOI-626/KIC 4478168"
{
	RA      19.67955927
	Dec     39.539677
	Dist    731
	AppMagn 13.49
	MassSol 1.1
	RadSol  1.18
	Teff    6117
	FeH    -0.06
}

Star	"Kepler-625/KOI-627/KIC 4563268"
{
	RA      19.47669727
	Dec     39.637581
	Dist    502
	AppMagn 13.307
	MassSol 1.04
	RadSol  0.96
	Teff    5789
	FeH     0.1
}

Star	"Kepler-626/KOI-628/KIC 4644604"
{
	RA      19.24657673
	Dec     39.708288
	Dist    690
	AppMagn 13.946
	MassSol 1.01
	RadSol  1.05
	Teff    5813
	FeH     0.01
}

Star	"Kepler-627/KOI-629/KIC 4656049"
{
	RA      19.4736186
	Dec     39.767914
	Dist    1143
	AppMagn 13.949
	MassSol 1.3
	RadSol  1.49
	Teff    6424
	FeH     0.05
}

Star	"Kepler-628"
{
	RA      19.3632838
	Dec     39.854802
	Dist    579
	AppMagn 11.662 // not V mag
	MassSol 1
	RadSol  1.28
	Teff    5721
	FeH     0.04
}

Star	"Kepler-629/KOI-632/KIC 4827723"
{
	RA      19.29452213
	Dec     39.945013
	Dist    383
	AppMagn 13.359
	MassSol 0.93
	RadSol  0.84
	Teff    5444
	FeH     0.01
}

Star	"Kepler-630/KOI-633/KIC 4841374"
{
	RA      19.56180287
	Dec     39.942437
	Dist    657
	AppMagn 13.871
	MassSol 1.02
	RadSol  1.04
	Teff    5829
	FeH     0.03
}

Star	"Kepler-631/KOI-639/KIC 5120087"
{
	RA      19.7923838
	Dec     40.228233
	Dist    843
	AppMagn 13.5
	MassSol 1.24
	RadSol  1.33
	Teff    6185
	FeH     0.23
}

Star	"Kepler-632/KOI-640/KIC 5121511"
{
	RA      19.81684087
	Dec     40.288605
	Dist    349
	AppMagn 13.332
	MassSol 0.91
	RadSol  0.84
	Teff    5322
	FeH     0.11
}

Star	"Kepler-633/KOI-645/KIC 5374854"
{
	RA      19.68116247
	Dec     40.592251
	Dist    634
	AppMagn 13.716
	MassSol 1.02
	RadSol  1.15
	Teff    5899
	FeH    -0.05
}

Star	"Kepler-634/KOI-647/KIC 5531694"
{
	RA      19.41300433
	Dec     40.702706
	Dist    757
	AppMagn 13.55
	MassSol 1.03
	RadSol  1.24
	Teff    6075
	FeH    -0.18
}

Star	"Kepler-635/KOI-649/KIC 5613330"
{
	RA      19.31821647
	Dec     40.800724
	Dist    826
	AppMagn 13.31
	MassSol 1.33
	RadSol  1.51
	Teff    6174
	FeH     0.41
}

Star	"Kepler-636/KOI-652/KIC 5796675"
{
	RA      19.5727926
	Dec     41.095161
	Dist    341
	AppMagn 13.653
	MassSol 0.85
	RadSol  0.8
	Teff    5203
	FeH    -0.02
}

Star	"Kepler-637/KOI-659/KIC 6125481"
{
	RA      19.4944822
	Dec     41.416882
	Dist    1575
	AppMagn 13.413
	MassSol 1.64
	RadSol  2.56
	Teff    6096
	FeH     0.38
}

Star	"Kepler-638/KOI-660/KIC 6267535"
{
	RA      18.9946286
	Dec     41.617195
	Dist    426
	AppMagn 13.532
	MassSol 0.88
	RadSol  0.93
	Teff    5382
	FeH     0.04
}

Star	"Kepler-639/KOI-662/KIC 6365156"
{
	RA      19.47912587
	Dec     41.727039
	Dist    680
	AppMagn 13.336
	MassSol 1.14
	RadSol  1.29
	Teff    5896
	FeH     0.23
}

Star	"Kepler-640/KOI-666/KIC 6707835"
{
	RA      19.7354794
	Dec     42.13168
	Dist    538
	AppMagn 13.721
	MassSol 1.01
	RadSol  0.94
	Teff    5653
	FeH     0.15
}

Star	"Kepler-641/KOI-670/KIC 7033671"
{
	RA      19.4548988
	Dec     42.516216
	Dist    673
	AppMagn 13.774
	MassSol 1.02
	RadSol  1.13
	Teff    5713
	FeH     0.15
}

Star	"Kepler-642/KOI-673/KIC 7124613"
{
	RA      19.5889706
	Dec     42.624962
	Dist    1022
	AppMagn 13.343
	MassSol 1.4
	RadSol  1.66
	Teff    6570
	FeH     0.06
}

Star	"Kepler-643/KOI-674/KIC 7277317"
{
	RA      19.355155
	Dec     42.898281
	Dist    1029
	AppMagn 13.781
	MassSol 1
	RadSol  2.52
	Teff    4908
	FeH     0.13
}

Star	"Kepler-644/KOI-685/KIC 7764367"
{
	RA      19.69838287
	Dec     43.493137
	Dist    1413
	AppMagn 13.949
	MassSol 1.49
	RadSol  1.81
	Teff    6747
	FeH     0.08
}

Star	"Kepler-645/KOI-688/KIC 8161561"
{
	RA      19.35485107
	Dec     44.035809
	Dist    901
	AppMagn 13.992
	MassSol 1.13
	RadSol  1.21
	Teff    6170
	FeH    -0.01
}

Star	"Kepler-646/KOI-689/KIC 8361905"
{
	RA      19.36475593
	Dec     44.387085
	Dist    513
	AppMagn 13.766
	MassSol 0.93
	RadSol  0.91
	Teff    5634
	FeH    -0.07
}

Star	"Kepler-647/KOI-691/KIC 8480285"
{
	RA      18.98588633
	Dec     44.591675
	Dist    789
	AppMagn 13.965
	MassSol 1.03
	RadSol  1.07
	Teff    6020
	FeH    -0.14
}

Star	"Kepler-648/KOI-694/KIC 8802165"
{
	RA      18.92664367
	Dec     45.016888
	Dist    665
	AppMagn 13.939
	MassSol 1.05
	RadSol  0.98
	Teff    5741
	FeH     0.21
}

Star	"Kepler-649/KOI-695/KIC 8805348"
{
	RA      19.04372907
	Dec     45.079556
	Dist    525
	AppMagn 13.437
	MassSol 0.97
	RadSol  0.94
	Teff    5871
	FeH    -0.17
}

Star	"Kepler-65/KOI-85/KIC 5866724"
{
	RA      19.24583333
	Dec     41.15113583
	Dist    312.43
	AppMagn 11.018
	Class  "B"
	MassSol 1.199
	RadSol  1.399
	Teff    6211
	FeH     0.17
	Age     3.89
}

Star	"Kepler-650/KOI-697/KIC 8878187"
{
	RA      19.266725
	Dec     45.15427
	Dist    805
	AppMagn 13.684
	MassSol 1.08
	RadSol  1.35
	Teff    5849
	FeH     0.13
}

Star	"Kepler-651/KOI-709/KIC 9578686"
{
	RA      19.15551933
	Dec     46.2035
	Dist    537
	AppMagn 13.94
	MassSol 0.92
	RadSol  0.87
	Teff    5522
	FeH    -0.04
}

Star	"Kepler-652/KOI-714/KIC 9702072"
{
	RA      19.20054067
	Dec     46.473557
	Dist    423
	AppMagn 13.393
	MassSol 0.97
	RadSol  0.88
	Teff    5490
	FeH     0.17
}

Star	"Kepler-653/KOI-717/KIC 9873254"
{
	RA      18.81419533
	Dec     46.717819
	Dist    593
	AppMagn 13.387
	MassSol 1.02
	RadSol  1.19
	Teff    5665
	FeH     0.23
}

Star	"Kepler-654/KOI-721/KIC 9964801"
{
	RA      19.8045608
	Dec     46.834278
	Dist    661
	AppMagn 13.645
	MassSol 1.04
	RadSol  1.11
	Teff    5865
	FeH     0.04
}

Star	"Kepler-655/KOI-722/KIC 9965439"
{
	RA      19.8172728
	Dec     46.843193
	Dist    783
	AppMagn 13.489
	MassSol 1.15
	RadSol  1.24
	Teff    6170
	FeH     0
}

Star	"Kepler-656/KOI-732/KIC 10265898"
{
	RA      19.22185993
	Dec     47.381592
	Dist    867
	AppMagn 15.342
	MassSol 0.86
	RadSol  0.82
	Teff    5281
	FeH    -0.04
}

Star	"Kepler-657/KOI-734/KIC 10272442"
{
	RA      19.41315327
	Dec     47.3078
	Dist    1244
	AppMagn 15.344
	MassSol 1.01
	RadSol  1.01
	Teff    5808
	FeH     0.03
}

Star	"Kepler-658/KOI-739/KIC 10386984"
{
	RA      18.865586
	Dec     47.57859
	Dist    341
	AppMagn 15.488
	MassSol 0.63
	RadSol  0.6
	Teff    4103
	FeH    -0.04
}

Star	"Kepler-659/KOI-740/KIC 10395381"
{
	RA      19.17388013
	Dec     47.509686
	Dist    688
	AppMagn 15.556
	MassSol 0.79
	RadSol  0.74
	Teff    4870
	FeH     0.02
}

Star	"Kepler-66/KOI-1958/KIC 9836149"
{
	RA      19.59877113
	Dec     46.687748
	Dist    1107
	AppMagn 15.3
	Class  "G0V"
	MassSol 1.04
	RadSol  0.97
	Teff    5962
	FeH    -0.2
	Age     1
}

Star	"Kepler-660/KOI-746/KIC 10526549"
{
	RA      19.20921747
	Dec     47.724453
	Dist    564
	AppMagn 15.302
	MassSol 0.75
	RadSol  0.71
	Teff    4779
	FeH    -0.07
}

Star	"Kepler-661/KOI-747/KIC 10583066"
{
	RA      18.91405873
	Dec     47.86327
	Dist    558
	AppMagn 15.784
	MassSol 0.7
	RadSol  0.67
	Teff    4483
	FeH    -0.05
}

Star	"Kepler-662/KOI-750/KIC 10662202"
{
	RA      19.36434227
	Dec     47.92918
	Dist    641
	AppMagn 15.377
	MassSol 0.79
	RadSol  0.74
	Teff    4897
	FeH    -0.03
}

Star	"Kepler-663/KOI-751/KIC 10682541"
{
	RA      19.85388413
	Dec     47.946671
	Dist    1030
	AppMagn 15.861
	MassSol 0.86
	RadSol  0.82
	Teff    5264
	FeH     0.03
}

Star	"Kepler-664/KOI-755/KIC 10854555"
{
	RA      19.2503258
	Dec     48.2262
	Dist    1386
	AppMagn 15.509
	MassSol 1.01
	RadSol  1.02
	Teff    5754
	FeH     0.07
}

Star	"Kepler-665/KOI-758/KIC 10987985"
{
	RA      19.80170867
	Dec     48.478596
	Dist    651
	AppMagn 15.39
	MassSol 0.79
	RadSol  0.74
	Teff    4913
	FeH    -0.03
}

Star	"Kepler-666/KOI-762/KIC 11153539"
{
	RA      19.89712267
	Dec     48.791592
	Dist    1330
	AppMagn 15.395
	MassSol 1.03
	RadSol  1.05
	Teff    5887
	FeH     0.01
}

Star	"Kepler-667/KOI-764/KIC 11304958"
{
	RA      19.70366993
	Dec     49.017342
	Dist    907
	AppMagn 15.4
	MassSol 0.91
	RadSol  0.87
	Teff    5327
	FeH     0.15
}

Star	"Kepler-668/KOI-765/KIC 11391957"
{
	RA      19.03328333
	Dec     49.277348
	Dist    877
	AppMagn 15.317
	MassSol 0.87
	RadSol  0.82
	Teff    5352
	FeH    -0.06
}

Star	"Kepler-669/KOI-766/KIC 11403044"
{
	RA      19.46241153
	Dec     49.253986
	Dist    1778
	AppMagn 15.506
	MassSol 1.15
	RadSol  1.2
	Teff    6038
	FeH     0.14
}

Star	"Kepler-67/KOI-2115/KIC 9532052"
{
	RA      19.6102234
	Dec     46.166439
	Dist    1107
	AppMagn 16.4
	Class  "G9V"
	MassSol 0.86
	RadSol  0.78
	Teff    5331
	FeH    -0.2
	Age     1
}

Star	"Kepler-670/KOI-767/KIC 11414511"
{
	RA      19.8010312
	Dec     49.225292
	Dist    980
	AppMagn 15.052
	MassSol 0.99
	RadSol  0.99
	Teff    5709
	FeH     0.07
}

Star	"Kepler-671/KOI-769/KIC 11460018"
{
	RA      19.61772053
	Dec     49.314091
	Dist    1139
	AppMagn 15.356
	MassSol 0.97
	RadSol  0.95
	Teff    5624
	FeH     0.08
}

Star	"Kepler-672/KOI-773/KIC 11507101"
{
	RA      19.44813387
	Dec     49.480877
	Dist    1011
	AppMagn 15.172
	MassSol 0.95
	RadSol  0.92
	Teff    5627
	FeH    -0.01
}

Star	"Kepler-673/KOI-776/KIC 11812062"
{
	RA      19.38571727
	Dec     50.054119
	Dist    978
	AppMagn 15.523
	MassSol 0.88
	RadSol  0.84
	Teff    5355
	FeH     0
}

Star	"Kepler-674/KOI-778/KIC 11853255"
{
	RA      19.0117474
	Dec     50.149818
	Dist    302
	AppMagn 15.135
	MassSol 0.6
	RadSol  0.57
	Teff    4192
	FeH    -0.27
}

Star	"Kepler-675/KOI-780/KIC 11918099"
{
	RA      19.5888884
	Dec     50.230354
	Dist    651
	AppMagn 15.334
	MassSol 0.79
	RadSol  0.75
	Teff    4945
	FeH    -0.05
}

Star	"Kepler-676/KOI-781/KIC 11923270"
{
	RA      19.74813133
	Dec     50.287237
	Dist    243
	AppMagn 15.937
	MassSol 0.51
	RadSol  0.49
	Teff    3701
	FeH    -0.02
}

Star	"Kepler-677/KOI-782/KIC 11960862"
{
	RA      19.33987113
	Dec     50.321609
	Dist    1180
	AppMagn 15.312
	MassSol 1
	RadSol  0.99
	Teff    5723
	FeH     0.06
}

Star	"Kepler-678/KOI-783/KIC 12020329"
{
	RA      19.69701953
	Dec     50.49456
	Dist    875
	AppMagn 15.08
	MassSol 0.94
	RadSol  0.91
	Teff    5520
	FeH     0.07
}

Star	"Kepler-679/KOI-785/KIC 12070811"
{
	RA      19.73475613
	Dec     50.567783
	Dist    968
	AppMagn 15.505
	MassSol 0.87
	RadSol  0.84
	Teff    5403
	FeH    -0.09
}

Star	"Kepler-68/KOI-246/KIC 11295426"
{
	RA      19.40222222
	Dec     49.04027778
	Dist    135
	AppMagn 9.99
	MassSol 1.079
	RadSol  1.243
	Teff    5793
	FeH     0.12
	Age     6.3
}

Star	"Kepler-680/KOI-786/KIC 12110942"
{
	RA      19.441494
	Dec     50.618237
	Dist    1342
	AppMagn 15.242
	MassSol 1.08
	RadSol  1.11
	Teff    5890
	FeH     0.13
}

Star	"Kepler-681/KOI-788/KIC 12404086"
{
	RA      19.29331473
	Dec     51.250324
	Dist    666
	AppMagn 15.234
	MassSol 0.8
	RadSol  0.76
	Teff    5021
	FeH    -0.04
}

Star	"Kepler-682/KOI-791/KIC 12644822"
{
	RA      19.27414813
	Dec     51.737381
	Dist    951
	AppMagn 15.14
	MassSol 0.92
	RadSol  0.89
	Teff    5559
	FeH    -0.05
}

Star	"Kepler-683/KOI-794/KIC 2713049"
{
	RA      19.42933213
	Dec     37.905656
	Dist    976
	AppMagn 15.026
	MassSol 0.96
	RadSol  0.95
	Teff    5703
	FeH    -0.03
}

Star	"Kepler-684/KOI-795/KIC 3114167"
{
	RA      19.3913678
	Dec     38.273635
	Dist    1066
	AppMagn 15.591
	MassSol 0.89
	RadSol  0.86
	Teff    5493
	FeH    -0.11
}

Star	"Kepler-685/KOI-801/KIC 3351888"
{
	RA      19.591462
	Dec     38.422949
	Dist    1145
	AppMagn 15.001
	MassSol 1.11
	RadSol  1.16
	Teff    5963
	FeH     0.15
}

Star	"Kepler-686/KOI-809/KIC 3935914"
{
	RA      19.0142538
	Dec     39.027485
	Dist    1203
	AppMagn 15.53
	MassSol 0.94
	RadSol  0.92
	Teff    5649
	FeH    -0.07
}

Star	"Kepler-687/KOI-811/KIC 4049131"
{
	RA      19.2876968
	Dec     39.153285
	Dist    628
	AppMagn 15.398
	MassSol 0.77
	RadSol  0.73
	Teff    4841
	FeH    -0.04
}

Star	"Kepler-688/KOI-813/KIC 4275191"
{
	RA      19.6436828
	Dec     39.308366
	Dist    1247
	AppMagn 15.725
	MassSol 0.98
	RadSol  0.96
	Teff    5715
	FeH     0.02
}

Star	"Kepler-689/KOI-814/KIC 4476123"
{
	RA      19.64737493
	Dec     39.521744
	Dist    1044
	AppMagn 15.583
	MassSol 0.91
	RadSol  0.88
	Teff    5518
	FeH    -0.01
}

Star	"Kepler-69/KOI-172/KIC 8692861"
{
	RA      19.55083333
	Dec     44.8689
	AppMagn 13.7
	Class  "G4V"
	MassSol 0.81
	RadSol  0.93
	Teff    5638
	FeH    -0.29
}

Star	"Kepler-690/KOI-816/KIC 4664847"
{
	RA      19.6326604
	Dec     39.771446
	Dist    1653
	AppMagn 15.67
	MassSol 1.11
	RadSol  1.16
	Teff    5913
	FeH     0.19
}

Star	"Kepler-691/KOI-818/KIC 4913852"
{
	RA      19.25413353
	Dec     40.033398
	Dist    239
	AppMagn 15.877
	MassSol 0.53
	RadSol  0.5
	Teff    3715
	FeH     0.04
}

Star	"Kepler-692/KOI-821/KIC 5021899"
{
	RA      19.65178933
	Dec     40.153738
	Dist    1000
	AppMagn 15.54
	MassSol 0.9
	RadSol  0.86
	Teff    5440
	FeH    -0.01
}

Star	"Kepler-693/KOI-824/KIC 5164255"
{
	RA      18.88357047
	Dec     40.358196
	Dist    1002
	AppMagn 16.422
	MassSol 0.76
	RadSol  0.72
	Teff    4881
	FeH    -0.1
}

Star	"Kepler-694/KOI-826/KIC 5272878"
{
	RA      19.40996713
	Dec     40.420518
	Dist    1023
	AppMagn 15.09
	MassSol 0.97
	RadSol  0.95
	Teff    5700
	FeH     0
}

Star	"Kepler-695"
{
	RA      19.95440647
	Dec     40.822362
	Dist    620
	AppMagn 13.016 // not V mag
	MassSol 0.84
	RadSol  0.8
	Teff    5181
	FeH    -0.01
}

Star	"Kepler-696/KOI-843/KIC 5881688"
{
	RA      19.56644067
	Dec     41.137592
	Dist    1285
	AppMagn 15.27
	MassSol 1.06
	RadSol  1.08
	Teff    5903
	FeH     0.07
}

Star	"Kepler-697/KOI-844/KIC 6022556"
{
	RA      18.92429267
	Dec     41.346458
	Dist    1091
	AppMagn 15.581
	MassSol 0.92
	RadSol  0.88
	Teff    5513
	FeH    -0.01
}

Star	"Kepler-698/KOI-845/KIC 6032497"
{
	RA      19.2339998
	Dec     41.301769
	Dist    1135
	AppMagn 15.447
	MassSol 0.94
	RadSol  0.91
	Teff    5612
	FeH    -0.03
}

Star	"Kepler-699/KOI-846/KIC 6061119"
{
	RA      19.79254673
	Dec     41.396091
	Dist    888
	AppMagn 15.482
	MassSol 0.81
	RadSol  0.78
	Teff    5330
	FeH    -0.26
}

Star	"Kepler-7/KOI-97/KIC 5780885"
{
	RA      19.23876747
	Dec     41.089798
	AppMagn 12.885
	MassSol 1.36
	RadSol  1.97
	Teff    5933
	FeH     0.11
	Age     3.5
}

Star	"Kepler-70/KOI-55"
{
	RA      19.75694445
	Dec     41.0927778
	Dist    1180
	AppMagn 14.87
	Class  "sdB"
	MassSol 0.496
	RadSol  0.203
	Teff    27730
	FeH    -0.106
	Age     0.0184
}

Star	"Kepler-700/KOI-847/KIC 6191521"
{
	RA      19.14362
	Dec     41.565788
	Dist    1061
	AppMagn 15.201
	MassSol 0.98
	RadSol  0.96
	Teff    5692
	FeH     0.04
}

Star	"Kepler-701/KOI-849/KIC 6276477"
{
	RA      19.2662788
	Dec     41.633278
	Dist    755
	AppMagn 15.018
	MassSol 0.88
	RadSol  0.84
	Teff    5343
	FeH     0
}

Star	"Kepler-702/KOI-850/KIC 6291653"
{
	RA      19.59187413
	Dec     41.66177
	Dist    892
	AppMagn 15.305
	MassSol 0.9
	RadSol  0.86
	Teff    5419
	FeH     0
}

Star	"Kepler-703/KOI-851/KIC 6392727"
{
	RA      19.94579073
	Dec     41.742682
	Dist    1482
	AppMagn 15.287
	MassSol 1.18
	RadSol  1.27
	Teff    6185
	FeH     0.05
}

Star	"Kepler-704/KOI-852/KIC 6422070"
{
	RA      18.8877594
	Dec     41.83712
	Dist    1054
	AppMagn 15.257
	MassSol 0.97
	RadSol  0.96
	Teff    5616
	FeH     0.09
}

Star	"Kepler-705/KOI-854/KIC 6435936"
{
	RA      19.3005668
	Dec     41.812107
	Dist    251
	AppMagn 15.849
	MassSol 0.53
	RadSol  0.51
	Teff    3722
	FeH     0.07
}

Star	"Kepler-706/KOI-855/KIC 6522242"
{
	RA      19.45069373
	Dec     41.944077
	Dist    810
	AppMagn 15.196
	MassSol 0.87
	RadSol  0.84
	Teff    5394
	FeH    -0.06
}

Star	"Kepler-707/KOI-861/KIC 6685526"
{
	RA      19.333838
	Dec     42.116459
	Dist    626
	AppMagn 15.001
	MassSol 0.8
	RadSol  0.76
	Teff    5099
	FeH    -0.12
}

Star	"Kepler-708/KOI-863/KIC 6784235"
{
	RA      19.5877644
	Dec     42.212498
	Dist    1241
	AppMagn 15.533
	MassSol 0.97
	RadSol  0.96
	Teff    5692
	FeH     0.01
}

Star	"Kepler-709/KOI-867/KIC 6863998"
{
	RA      19.47368047
	Dec     42.380318
	Dist    668
	AppMagn 15.219
	MassSol 0.8
	RadSol  0.77
	Teff    5071
	FeH    -0.08
}

Star	"Kepler-71/KOI-217/KIC 9595827"
{
	RA      19.6577006
	Dec     46.285851
	Dist    800
	AppMagn 15.386
	MassSol 0.923
	RadSol  0.816
	Teff    5591
	FeH    -0.2
}

Star	"Kepler-710/KOI-873/KIC 7118364"
{
	RA      19.4642774
	Dec     42.696144
	Dist    919
	AppMagn 15.024
	MassSol 0.94
	RadSol  0.91
	Teff    5611
	FeH    -0.04
}

Star	"Kepler-711/KOI-878/KIC 7303253"
{
	RA      19.83066767
	Dec     42.839924
	Dist    664
	AppMagn 15.316
	MassSol 0.84
	RadSol  0.8
	Teff    5222
	FeH    -0.04
}

Star	"Kepler-712/KOI-881/KIC 7373451"
{
	RA      19.66064893
	Dec     42.935261
	Dist    944
	AppMagn 15.859
	MassSol 0.84
	RadSol  0.78
	Teff    5148
	FeH    -0.03
}

Star	"Kepler-713"
{
	RA      19.71010013
	Dec     43.029831
	Dist    1003
	AppMagn 13.454 // not V mag
	MassSol 0.98
	RadSol  0.99
	Teff    5785
	FeH    -0.03
}

Star	"Kepler-714/KOI-890/KIC 7585481"
{
	RA      18.8466354
	Dec     43.272743
	Dist    1460
	AppMagn 15.261
	MassSol 1.09
	RadSol  1.12
	Teff    5995
	FeH     0.04
}

Star	"Kepler-715/KOI-891/KIC 7663691"
{
	RA      18.9087178
	Dec     43.379398
	Dist    1214
	AppMagn 15.063
	MassSol 1.04
	RadSol  1.04
	Teff    5871
	FeH     0.02
}

Star	"Kepler-716/KOI-892/KIC 7678434"
{
	RA      19.3595476
	Dec     43.363899
	Dist    675
	AppMagn 15.193
	MassSol 0.83
	RadSol  0.78
	Teff    5099
	FeH     0
}

Star	"Kepler-717/KOI-893/KIC 7685981"
{
	RA      19.53103567
	Dec     43.34639
	Dist    1126
	AppMagn 15.662
	MassSol 0.88
	RadSol  0.85
	Teff    5485
	FeH    -0.12
}

Star	"Kepler-718/KOI-897/KIC 7849854"
{
	RA      19.9707918
	Dec     43.503559
	Dist    1520
	AppMagn 15.257
	MassSol 1.18
	RadSol  1.3
	Teff    6191
	FeH     0.06
}

Star	"Kepler-719"
{
	RA      19.70240907
	Dec     43.884453
	Dist    1427
	AppMagn 14.207 // not V mag
	MassSol 0.99
	RadSol  0.98
	Teff    5777
	FeH    -0.02
}

Star	"Kepler-720/KOI-908/KIC 8255887"
{
	RA      19.90904327
	Dec     44.170944
	Dist    880
	AppMagn 15.113
	MassSol 0.95
	RadSol  0.92
	Teff    5618
	FeH     0
}

Star	"Kepler-721/KOI-910/KIC 8414716"
{
	RA      18.96203373
	Dec     44.480534
	Dist    848
	AppMagn 15.651
	MassSol 0.82
	RadSol  0.78
	Teff    5075
	FeH    -0.01
}

Star	"Kepler-722/KOI-911/KIC 8490993"
{
	RA      19.35088567
	Dec     44.55645
	Dist    1375
	AppMagn 15.399
	MassSol 1.03
	RadSol  1.05
	Teff    5863
	FeH     0.02
}

Star	"Kepler-723/KOI-913/KIC 8544996"
{
	RA      18.98869787
	Dec     44.658142
	Dist    965
	AppMagn 15.198
	MassSol 0.92
	RadSol  0.89
	Teff    5539
	FeH     0
}

Star	"Kepler-724/KOI-916/KIC 8628973"
{
	RA      19.56365587
	Dec     44.792797
	Dist    862
	AppMagn 15.142
	MassSol 0.9
	RadSol  0.86
	Teff    5437
	FeH    -0.02
}

Star	"Kepler-725/KOI-918/KIC 8672910"
{
	RA      18.9318328
	Dec     44.811562
	Dist    778
	AppMagn 15.011
	MassSol 0.88
	RadSol  0.84
	Teff    5363
	FeH    -0.01
}

Star	"Kepler-726/KOI-920/KIC 8689031"
{
	RA      19.44782073
	Dec     44.887306
	Dist    838
	AppMagn 15.067
	MassSol 0.88
	RadSol  0.85
	Teff    5452
	FeH    -0.09
}

Star	"Kepler-727/KOI-922/KIC 8826878"
{
	RA      19.65646053
	Dec     45.034416
	Dist    892
	AppMagn 15.365
	MassSol 0.89
	RadSol  0.86
	Teff    5441
	FeH    -0.01
}

Star	"Kepler-728/KOI-923/KIC 8883593"
{
	RA      19.40615707
	Dec     45.115528
	Dist    1236
	AppMagn 15.543
	MassSol 0.95
	RadSol  0.93
	Teff    5660
	FeH    -0.03
}

Star	"Kepler-729/KOI-926/KIC 9077124"
{
	RA      19.09067413
	Dec     45.414295
	Dist    1271
	AppMagn 15.603
	MassSol 0.94
	RadSol  0.91
	Teff    5633
	FeH    -0.05
}

Star	"Kepler-730/KOI-929/KIC 9141746"
{
	RA      19.03698693
	Dec     45.578857
	Dist    1455
	AppMagn 15.649
	MassSol 1
	RadSol  1.01
	Teff    5726
	FeH     0.07
}

Star	"Kepler-731/KOI-931/KIC 9166862"
{
	RA      19.75954493
	Dec     45.568558
	Dist    1311
	AppMagn 15.272
	MassSol 1.03
	RadSol  1.06
	Teff    5849
	FeH     0.04
}

Star	"Kepler-732/KOI-936/KIC 9388479"
{
	RA      18.91546807
	Dec     45.958771
	Dist    150
	AppMagn 15.073
	MassSol 0.49
	RadSol  0.46
	Teff    3631
	FeH    -0.01
}

Star	"Kepler-733/KOI-937/KIC 9406990"
{
	RA      19.53455233
	Dec     45.914692
	Dist    980
	AppMagn 15.412
	MassSol 0.9
	RadSol  0.86
	Teff    5418
	FeH     0.01
}

Star	"Kepler-734/KOI-940/KIC 9479273"
{
	RA      19.80304253
	Dec     46.027363
	Dist    553
	AppMagn 15.017
	MassSol 0.85
	RadSol  0.78
	Teff    5326
	FeH    -0.17
}

Star	"Kepler-735/KOI-942/KIC 9512687"
{
	RA      18.97925893
	Dec     46.172249
	Dist    790
	AppMagn 15.386
	MassSol 0.85
	RadSol  0.8
	Teff    5107
	FeH     0.07
}

Star	"Kepler-736/KOI-943/KIC 9513865"
{
	RA      19.02608807
	Dec     46.180939
	Dist    1007
	AppMagn 15.733
	MassSol 0.86
	RadSol  0.81
	Teff    5217
	FeH     0.03
}

Star	"Kepler-737/KOI-947/KIC 9710326"
{
	RA      19.45752313
	Dec     46.429256
	Dist    195
	AppMagn 15.19
	MassSol 0.51
	RadSol  0.48
	Teff    3813
	FeH    -0.24
}

Star	"Kepler-738/KOI-948/KIC 9761882"
{
	RA      19.17131093
	Dec     46.567859
	Dist    992
	AppMagn 15.598
	MassSol 0.86
	RadSol  0.82
	Teff    5327
	FeH    -0.09
}

Star	"Kepler-739/KOI-949/KIC 9766437"
{
	RA      19.33786567
	Dec     46.57914
	Dist    1128
	AppMagn 15.485
	MassSol 0.93
	RadSol  0.9
	Teff    5601
	FeH    -0.08
}

Star	"Kepler-74/KOI-200/KIC 6046540"
{
	RA      19.53944445
	Dec     41.3555556
	Dist    1330
	AppMagn 14.23
	Class  "F8V"
	MassSol 1.4
	RadSol  1.51
	Teff    6050
	FeH     0.34
	Age     2.9
}

Star	"Kepler-740/KOI-953/KIC 9820483"
{
	RA      19.09881693
	Dec     46.692451
	Dist    1262
	AppMagn 15.954
	MassSol 0.91
	RadSol  0.87
	Teff    5438
	FeH     0.03
}

Star	"Kepler-741/KOI-955/KIC 9825625"
{
	RA      19.29544687
	Dec     46.617531
	Dist    1530
	AppMagn 15.067
	MassSol 1.16
	RadSol  1.24
	Teff    6129
	FeH     0.07
}

Star	"Kepler-742/KOI-956/KIC 9875711"
{
	RA      18.92440127
	Dec     46.789589
	Dist    499
	AppMagn 15.223
	MassSol 0.76
	RadSol  0.71
	Teff    4642
	FeH     0.07
}

Star	"Kepler-743/KOI-987/KIC 7295235"
{
	RA      19.70494453
	Dec     42.806436
	Dist    258
	AppMagn 12.55
	MassSol 0.94
	RadSol  0.85
	Teff    5486
	FeH     0.01
}

Star	"Kepler-744/KOI-991/KIC 10154388"
{
	RA      19.76640907
	Dec     47.182865
	Dist    486
	AppMagn 13.581
	MassSol 0.94
	RadSol  0.93
	Teff    5594
	FeH     0
}

Star	"Kepler-745/KOI-992/KIC 1432789"
{
	RA      19.43329533
	Dec     37.059283
	Dist    1199
	AppMagn 15.214
	MassSol 1.04
	RadSol  1.04
	Teff    5849
	FeH     0.06
}

Star	"Kepler-746/KOI-1002/KIC 1865042"
{
	RA      19.3788162
	Dec     37.355117
	Dist    450
	AppMagn 13.615
	MassSol 0.91
	RadSol  0.93
	Teff    5418
	FeH     0.09
}

Star	"Kepler-747/KOI-1005/KIC 5780460"
{
	RA      19.22776687
	Dec     41.029804
	Dist    855
	AppMagn 15.703
	MassSol 0.82
	RadSol  0.78
	Teff    5096
	FeH    -0.03
}

Star	"Kepler-748/KOI-1007/KIC 1725016"
{
	RA      19.48419327
	Dec     37.236992
	Dist    1271
	AppMagn 15.242
	MassSol 1.07
	RadSol  1.1
	Teff    5934
	FeH     0.08
}

Star	"Kepler-749/KOI-1014/KIC 8125580"
{
	RA      19.99314867
	Dec     43.903908
	Dist    753
	AppMagn 15.759
	MassSol 0.79
	RadSol  0.75
	Teff    5009
	FeH    -0.11
}

Star	"Kepler-75/KOI-889/KIC 757450"
{
	RA      19.40916667
	Dec     36.5775
	Dist    1140
	AppMagn 15
	Class  "G8V"
	MassSol 0.88
	RadSol  0.88
	Teff    5330
	FeH    -0.07
	Age     6
}

Star	"Kepler-750/KOI-1015/KIC 8158127"
{
	RA      19.27312493
	Dec     44.004379
	Dist    1181
	AppMagn 14.5
	MassSol 1.15
	RadSol  1.23
	Teff    6160
	FeH     0.03
}

Star	"Kepler-751/KOI-1017/KIC 8174625"
{
	RA      19.6562554
	Dec     44.077686
	Dist    748
	AppMagn 15.007
	MassSol 0.87
	RadSol  0.84
	Teff    5387
	FeH    -0.06
}

Star	"Kepler-752/KOI-1022/KIC 2716853"
{
	RA      19.48454187
	Dec     37.955654
	Dist    1075
	AppMagn 15.762
	MassSol 0.87
	RadSol  0.83
	Teff    5373
	FeH    -0.08
}

Star	"Kepler-753/KOI-1024/KIC 2715135"
{
	RA      19.4602182
	Dec     37.902288
	Dist    278
	AppMagn 14.496
	MassSol 0.68
	RadSol  0.65
	Teff    4346
	FeH    -0.03
}

Star	"Kepler-754/KOI-1031/KIC 2584163"
{
	RA      19.5502736
	Dec     37.846192
	Dist    1192
	AppMagn 15.16
	MassSol 1.06
	RadSol  1.08
	Teff    5935
	FeH     0.05
}

Star	"Kepler-755/KOI-1050/KIC 5809890"
{
	RA      19.7907332
	Dec     41.097338
	Dist    368
	AppMagn 13.999
	MassSol 0.82
	RadSol  0.77
	Teff    5043
	FeH    -0.01
}

Star	"Kepler-756/KOI-1053/KIC 5956656"
{
	RA      19.3738626
	Dec     41.201093
	Dist    852
	AppMagn 15.376
	MassSol 0.82
	RadSol  0.79
	Teff    5282
	FeH    -0.19
}

Star	"Kepler-757/KOI-1059/KIC 6060203"
{
	RA      19.77869587
	Dec     41.386515
	Dist    1016
	AppMagn 14.803
	MassSol 1.08
	RadSol  1.13
	Teff    6014
	FeH     0.02
}

Star	"Kepler-758/KOI-1060/KIC 5880320"
{
	RA      19.53897373
	Dec     41.135436
	Dist    1353
	AppMagn 14.348
	MassSol 1.16
	RadSol  1.42
	Teff    6228
	FeH    -0.1
}

Star	"Kepler-759/KOI-1061/KIC 6037187"
{
	RA      19.34210007
	Dec     41.381498
	Dist    892
	AppMagn 14.502
	MassSol 1.04
	RadSol  1.04
	Teff    5860
	FeH     0.06
}

Star	"Kepler-76/KOI-1658/KIC 4570949"
{
	RA      19.6128072
	Dec     39.619003
	AppMagn 13.308
	Class  "F"
	MassSol 1.2
	RadSol  1.32
	Teff    6409
	FeH    -0.1
}

Star	"Kepler-760/KOI-1069/KIC 8222813"
{
	RA      19.1728806
	Dec     44.179417
	Dist    782
	AppMagn 15.07
	MassSol 0.89
	RadSol  0.85
	Teff    5322
	FeH     0.08
}

Star	"Kepler-761/KOI-1072/KIC 8229696"
{
	RA      19.36690693
	Dec     44.143581
	Dist    867
	AppMagn 14.743
	MassSol 0.95
	RadSol  0.93
	Teff    5706
	FeH    -0.09
}

Star	"Kepler-762/KOI-1074/KIC 10272640"
{
	RA      19.4183756
	Dec     47.329491
	Dist    1465
	AppMagn 15.439
	MassSol 1.06
	RadSol  1.08
	Teff    5944
	FeH     0.02
}

Star	"Kepler-763/KOI-1082/KIC 10141900"
{
	RA      19.47629847
	Dec     47.157352
	Dist    902
	AppMagn 15.692
	MassSol 0.84
	RadSol  0.8
	Teff    5166
	FeH     0.01
}

Star	"Kepler-764/KOI-1083/KIC 10157458"
{
	RA      19.8262122
	Dec     47.164627
	Dist    1013
	AppMagn 15.302
	MassSol 0.92
	RadSol  0.89
	Teff    5557
	FeH    -0.06
}

Star	"Kepler-765/KOI-1086/KIC 10122255"
{
	RA      18.87897413
	Dec     47.15567
	Dist    1000
	AppMagn 14.609
	MassSol 1.05
	RadSol  1.06
	Teff    5901
	FeH     0.04
}

Star	"Kepler-766/KOI-1094/KIC 2721030"
{
	RA      19.5456354
	Dec     37.969851
	Dist    1614
	AppMagn 15.678
	MassSol 1.1
	RadSol  1.15
	Teff    5992
	FeH     0.09
}

Star	"Kepler-767/KOI-1099/KIC 2853093"
{
	RA      19.43861153
	Dec     38.035828
	Dist    1185
	AppMagn 15.435
	MassSol 0.96
	RadSol  0.94
	Teff    5694
	FeH    -0.05
}

Star	"Kepler-768/KOI-1101/KIC 3245969"
{
	RA      19.6077104
	Dec     38.393485
	Dist    795
	AppMagn 15.681
	MassSol 0.82
	RadSol  0.78
	Teff    5108
	FeH    -0.03
}

Star	"Kepler-769/KOI-1106/KIC 3240158"
{
	RA      19.51420673
	Dec     38.358213
	Dist    1362
	AppMagn 14.818
	MassSol 1.19
	RadSol  1.28
	Teff    6186
	FeH     0.06
}

Star	"Kepler-77/KOI-127/KIC 8359498"
{
	RA      19.30719807
	Dec     44.345421
	Dist    570
	AppMagn 15
	Class  "G5V"
	MassSol 0.95
	RadSol  0.99
	Teff    5520
	FeH     0.2
	Age     7.5
}

Star	"Kepler-770/KOI-1108/KIC 3218908"
{
	RA      19.09936187
	Dec     38.374907
	Dist    761
	AppMagn 14.604
	MassSol 0.94
	RadSol  0.92
	Teff    5598
	FeH    -0.01
}

Star	"Kepler-771/KOI-1110/KIC 2837111"
{
	RA      19.16293933
	Dec     38.088431
	Dist    1000
	AppMagn 14.794
	MassSol 1.03
	RadSol  1.05
	Teff    5906
	FeH     0.01
}

Star	"Kepler-772/KOI-1115/KIC 3116412"
{
	RA      19.42823887
	Dec     38.216591
	Dist    689
	AppMagn 13.974
	MassSol 0.98
	RadSol  1.11
	Teff    5714
	FeH     0.03
}

Star	"Kepler-773/KOI-1116/KIC 2849805"
{
	RA      19.39231113
	Dec     38.057567
	Dist    528
	AppMagn 13.333
	MassSol 1.04
	RadSol  1.01
	Teff    5850
	FeH     0.05
}

Star	"Kepler-774/KOI-1117/KIC 3114811"
{
	RA      19.40212867
	Dec     38.211956
	Dist    1190
	AppMagn 12.808
	MassSol 1.57
	RadSol  2.42
	Teff    6403
	FeH     0.04
}

Star	"Kepler-775/KOI-1128/KIC 6362874"
{
	RA      19.42888647
	Dec     41.703438
	Dist    400
	AppMagn 13.507
	MassSol 0.92
	RadSol  0.84
	Teff    5468
	FeH    -0.04
}

Star	"Kepler-776/KOI-1129/KIC 6272413"
{
	RA      19.15150933
	Dec     41.635559
	Dist    727
	AppMagn 15.456
	MassSol 0.83
	RadSol  0.78
	Teff    5071
	FeH     0.05
}

Star	"Kepler-777/KOI-1141/KIC 8346392"
{
	RA      18.8482706
	Dec     44.346478
	Dist    383
	AppMagn 15.95
	MassSol 0.58
	RadSol  0.56
	Teff    4043
	FeH    -0.17
}

Star	"Kepler-778/KOI-1142/KIC 8288947"
{
	RA      19.16516247
	Dec     44.237514
	Dist    899
	AppMagn 15.764
	MassSol 0.81
	RadSol  0.77
	Teff    5102
	FeH    -0.09
}

Star	"Kepler-779/KOI-1146/KIC 8351704"
{
	RA      19.04190213
	Dec     44.310889
	Dist    224
	AppMagn 15.649
	MassSol 0.46
	RadSol  0.44
	Teff    3804
	FeH    -0.43
}

Star	"Kepler-78"
{
	RA      19.58278
	Dec     44.4483
	AppMagn 12
	Class  "G"
	MassSol 0.81
	RadSol  0.74
	Teff    5089
	FeH    -0.14
}

Star	"Kepler-780/KOI-1150/KIC 8278371"
{
	RA      18.78442593
	Dec     44.292549
	Dist    520
	AppMagn 13.326
	MassSol 1.01
	RadSol  1.02
	Teff    5769
	FeH     0.05
}

Star	"Kepler-781/KOI-1160/KIC 10330115"
{
	RA      19.17690793
	Dec     47.414811
	Dist    1036
	AppMagn 15.987
	MassSol 0.81
	RadSol  0.78
	Teff    5162
	FeH    -0.1
}

Star	"Kepler-782/KOI-1162/KIC 10528068"
{
	RA      19.25788207
	Dec     47.759434
	Dist    412
	AppMagn 12.783
	MassSol 0.98
	RadSol  1.01
	Teff    5867
	FeH    -0.14
}

Star	"Kepler-783/KOI-1165/KIC 10337517"
{
	RA      19.40419573
	Dec     47.484803
	Dist    544
	AppMagn 13.916
	MassSol 0.93
	RadSol  0.89
	Teff    5521
	FeH     0.01
}

Star	"Kepler-784/KOI-1175/KIC 10350571"
{
	RA      19.7280442
	Dec     47.448616
	Dist    604
	AppMagn 13.29
	MassSol 1
	RadSol  1.32
	Teff    5674
	FeH     0.07
}

Star	"Kepler-785/KOI-1176/KIC 3749365"
{
	RA      19.47122027
	Dec     38.842261
	Dist    666
	AppMagn 15.715
	MassSol 0.77
	RadSol  0.71
	Teff    4739
	FeH    -0.02
}

Star	"Kepler-786/KOI-1199/KIC 3859079"
{
	RA      19.5829292
	Dec     38.939276
	Dist    512
	AppMagn 14.887
	MassSol 0.81
	RadSol  0.74
	Teff    4838
	FeH     0.09
}

Star	"Kepler-787/KOI-1202/KIC 3444588"
{
	RA      19.44616433
	Dec     38.572907
	Dist    468
	AppMagn 15.854
	MassSol 0.65
	RadSol  0.62
	Teff    4248
	FeH    -0.09
}

Star	"Kepler-788/KOI-1204/KIC 3438507"
{
	RA      19.33336093
	Dec     38.539892
	Dist    1649
	AppMagn 15.291
	MassSol 1.16
	RadSol  1.23
	Teff    6159
	FeH     0.05
}

Star	"Kepler-789/KOI-1205/KIC 3869014"
{
	RA      19.73167687
	Dec     38.946652
	Dist    915
	AppMagn 14.507
	MassSol 1.01
	RadSol  1.02
	Teff    5870
	FeH    -0.06
}

Star	"Kepler-79/KOI-152/KIC 8394721"
{
	RA      20.0344754
	Dec     44.38158
	AppMagn 14.11
	MassSol 1.17
	RadSol  1.3
	Teff    6174
	FeH    -0.073
	Age     3.44
}

Star	"Kepler-790/KOI-1207/KIC 3732821"
{
	RA      19.1278078
	Dec     38.872221
	Dist    727
	AppMagn 15.187
	MassSol 0.84
	RadSol  0.8
	Teff    5208
	FeH    -0.05
}

Star	"Kepler-791/KOI-1210/KIC 3962357"
{
	RA      19.57305607
	Dec     39.029477
	Dist    1447
	AppMagn 14.377
	MassSol 1.3
	RadSol  1.47
	Teff    6383
	FeH     0.06
}

Star	"Kepler-792/KOI-1212/KIC 3749134"
{
	RA      19.46712087
	Dec     38.820733
	Dist    1205
	AppMagn 14.981
	MassSol 1.09
	RadSol  1.12
	Teff    5971
	FeH     0.08
}

Star	"Kepler-793/KOI-1214/KIC 3660924"
{
	RA      19.68110933
	Dec     38.774343
	Dist    794
	AppMagn 14.621
	MassSol 0.98
	RadSol  0.97
	Teff    5745
	FeH     0
}

Star	"Kepler-794/KOI-1216/KIC 3839488"
{
	RA      19.2089134
	Dec     38.996881
	Dist    763
	AppMagn 13.459
	MassSol 1.19
	RadSol  1.38
	Teff    5839
	FeH     0.34
}

Star	"Kepler-795/KOI-1218/KIC 3442055"
{
	RA      19.40126973
	Dec     38.54558
	Dist    458
	AppMagn 13.331
	MassSol 0.94
	RadSol  0.96
	Teff    5631
	FeH    -0.02
}

Star	"Kepler-796/KOI-1220/KIC 4043190"
{
	RA      19.15385713
	Dec     39.144731
	Dist    377
	AppMagn 12.988
	MassSol 0.93
	RadSol  1.09
	Teff    5475
	FeH     0.09
}

Star	"Kepler-797/KOI-1238/KIC 6383821"
{
	RA      19.813931
	Dec     41.781708
	Dist    752
	AppMagn 14.556
	MassSol 0.96
	RadSol  0.95
	Teff    5680
	FeH    -0.02
}

Star	"Kepler-798/KOI-1245/KIC 6693640"
{
	RA      19.49854727
	Dec     42.142291
	Dist    1085
	AppMagn 14.2
	MassSol 1.19
	RadSol  1.29
	Teff    6224
	FeH     0.03
}

Star	"Kepler-799/KOI-1261/KIC 8678594"
{
	RA      19.14499293
	Dec     44.878571
	Dist    1029
	AppMagn 15.12
	MassSol 0.95
	RadSol  0.93
	Teff    5681
	FeH    -0.07
}

Star	"Kepler-8/KOI-10/KIC 6922244"
{
	RA      18.75254107
	Dec     42.45108
	Dist    1330
	AppMagn 13.9
	MassSol 1.21
	RadSol  1.49
	Teff    6213
	FeH    -0.055
	Age     3.84
}

Star	"Kepler-80/KOI-500/KIC 4852528"
{
	RA      19.7408376
	Dec     39.978779
	AppMagn 14.804
	MassSol 0.72
	RadSol  0.64
	Teff    4613
	FeH    -0.562
}

Star	"Kepler-800/KOI-1264/KIC 8612847"
{
	RA      19.1049882
	Dec     44.795204
	Dist    1049
	AppMagn 15.762
	MassSol 0.85
	RadSol  0.82
	Teff    5315
	FeH    -0.09
}

Star	"Kepler-801/KOI-1266/KIC 8547140"
{
	RA      19.07168287
	Dec     44.664639
	Dist    419
	AppMagn 15.314
	MassSol 0.67
	RadSol  0.63
	Teff    4435
	FeH    -0.17
}

Star	"Kepler-802/KOI-1273/KIC 8806072"
{
	RA      19.06772367
	Dec     45.007767
	Dist    828
	AppMagn 14.862
	MassSol 0.93
	RadSol  0.9
	Teff    5507
	FeH     0.06
}

Star	"Kepler-803/KOI-1275/KIC 8583696"
{
	RA      19.948107
	Dec     44.693874
	Dist    615
	AppMagn 13.672
	MassSol 1.05
	RadSol  1.12
	Teff    5919
	FeH     0.02
}

Star	"Kepler-804/KOI-1279/KIC 8628758"
{
	RA      19.55815133
	Dec     44.785137
	Dist    648
	AppMagn 13.749
	MassSol 1.01
	RadSol  1.05
	Teff    5817
	FeH     0
}

Star	"Kepler-805/KOI-1282/KIC 8822366"
{
	RA      19.548663
	Dec     45.053314
	Dist    657
	AppMagn 12.547
	MassSol 1.19
	RadSol  1.65
	Teff    6112
	FeH    -0.06
}

Star	"Kepler-806/KOI-1283/KIC 8700771"
{
	RA      19.73380287
	Dec     44.853443
	Dist    260
	AppMagn 11.731
	MassSol 0.99
	RadSol  1.16
	Teff    5770
	FeH     0
}

Star	"Kepler-807/KOI-1288/KIC 10790387"
{
	RA      19.26801147
	Dec     48.119812
	Dist    1312
	AppMagn 15.128
	MassSol 1.04
	RadSol  1.06
	Teff    5965
	FeH    -0.04
}

Star	"Kepler-808/KOI-1300/KIC 10975146"
{
	RA      19.439606
	Dec     48.445614
	Dist    321
	AppMagn 14.285
	MassSol 0.76
	RadSol  0.71
	Teff    4653
	FeH     0.05
}

Star	"Kepler-809/KOI-1302/KIC 10724369"
{
	RA      19.27224287
	Dec     48.018131
	Dist    933
	AppMagn 14.755
	MassSol 0.99
	RadSol  0.98
	Teff    5734
	FeH     0.04
}

Star	"Kepler-81/KOI-877/KIC 7287995"
{
	RA      19.57579753
	Dec     42.82497
	AppMagn 15.019
	MassSol 0.64
	RadSol  0.59
	Teff    4500
	FeH    -0.524
}

Star	"Kepler-810/KOI-1304/KIC 10744335"
{
	RA      19.77432393
	Dec     48.082645
	Dist    1554
	AppMagn 15.803
	MassSol 1.03
	RadSol  1.04
	Teff    5803
	FeH     0.1
}

Star	"Kepler-811/KOI-1308/KIC 10586208"
{
	RA      19.02828487
	Dec     47.834614
	Dist    847
	AppMagn 13.971
	MassSol 1.01
	RadSol  1.24
	Teff    5747
	FeH     0.05
}

Star	"Kepler-812/KOI-1309/KIC 10854768"
{
	RA      19.25701933
	Dec     48.208538
	Dist    1482
	AppMagn 13.832
	MassSol 1.45
	RadSol  1.71
	Teff    6761
	FeH     0.02
}

Star	"Kepler-813/KOI-1310/KIC 10964440"
{
	RA      19.0441796
	Dec     48.435371
	Dist    840
	AppMagn 14.569
	MassSol 0.95
	RadSol  0.93
	Teff    5743
	FeH    -0.13
}

Star	"Kepler-814/KOI-1312/KIC 10963242"
{
	RA      18.9940324
	Dec     48.431644
	Dist    1327
	AppMagn 14.706
	MassSol 1.15
	RadSol  1.22
	Teff    6162
	FeH     0.01
}

Star	"Kepler-815/KOI-1314/KIC 10585852"
{
	RA      19.01474067
	Dec     47.881382
	Dist    1199
	AppMagn 13.242
	MassSol 1.25
	RadSol  3.42
	Teff    5028
	FeH    -0.03
}

Star	"Kepler-816/KOI-1320/KIC 4164994"
{
	RA      19.5575228
	Dec     39.212452
	Dist    1059
	AppMagn 15.95
	MassSol 0.9
	RadSol  0.85
	Teff    5286
	FeH     0.16
}

Star	"Kepler-817/KOI-1323/KIC 4076098"
{
	RA      19.7387904
	Dec     39.161617
	Dist    1401
	AppMagn 15.572
	MassSol 1.03
	RadSol  1.03
	Teff    5861
	FeH     0.02
}

Star	"Kepler-818/KOI-1325/KIC 4282872"
{
	RA      19.749007
	Dec     39.370343
	Dist    967
	AppMagn 15.062
	MassSol 0.94
	RadSol  0.92
	Teff    5638
	FeH    -0.08
}

Star	"Kepler-819/KOI-1329/KIC 4072526"
{
	RA      19.69138647
	Dec     39.177218
	Dist    722
	AppMagn 15.03
	MassSol 0.86
	RadSol  0.81
	Teff    5279
	FeH    -0.06
}

Star	"Kepler-82/KOI-880/KIC 7366258"
{
	RA      19.5248922
	Dec     42.966137
	AppMagn 15.158
	MassSol 0.85
	RadSol  0.94
	Teff    5428
	FeH    -0.014
}

Star	"Kepler-820/KOI-1335/KIC 4155328"
{
	RA      19.401343
	Dec     39.220678
	Dist    989
	AppMagn 13.968
	MassSol 1.23
	RadSol  1.36
	Teff    6260
	FeH     0.09
}

Star	"Kepler-821/KOI-1337/KIC 4243911"
{
	RA      19.04116247
	Dec     39.37953
	Dist    619
	AppMagn 14.829
	MassSol 0.84
	RadSol  0.8
	Teff    5191
	FeH    -0.03
}

Star	"Kepler-822/KOI-1338/KIC 4466677"
{
	RA      19.48507453
	Dec     39.550179
	Dist    956
	AppMagn 14.609
	MassSol 1.06
	RadSol  1.08
	Teff    5928
	FeH     0.04
}

Star	"Kepler-823/KOI-1339/KIC 4135665"
{
	RA      18.9721718
	Dec     39.220204
	Dist    896
	AppMagn 14.801
	MassSol 0.98
	RadSol  0.96
	Teff    5643
	FeH     0.06
}

Star	"Kepler-824/KOI-1341/KIC 4650674"
{
	RA      19.3651608
	Dec     39.732009
	Dist    1352
	AppMagn 14.946
	MassSol 1.15
	RadSol  1.22
	Teff    6035
	FeH     0.14
}

Star	"Kepler-825/KOI-1342/KIC 4275721"
{
	RA      19.6513272
	Dec     39.398514
	Dist    820
	AppMagn 14.207
	MassSol 1.03
	RadSol  1.08
	Teff    5976
	FeH    -0.08
}

Star	"Kepler-826/KOI-1344/KIC 4136466"
{
	RA      18.99067593
	Dec     39.240548
	Dist    649
	AppMagn 13.446
	MassSol 1.05
	RadSol  1.15
	Teff    6079
	FeH    -0.12
}

Star	"Kepler-827/KOI-1355/KIC 7211141"
{
	RA      19.66440307
	Dec     42.708569
	Dist    1352
	AppMagn 15.897
	MassSol 0.93
	RadSol  0.91
	Teff    5602
	FeH    -0.06
}

Star	"Kepler-828/KOI-1367/KIC 6934291"
{
	RA      19.12581833
	Dec     42.471256
	Dist    625
	AppMagn 15.055
	MassSol 0.81
	RadSol  0.77
	Teff    5039
	FeH    -0.02
}

Star	"Kepler-829/KOI-1370/KIC 6924203"
{
	RA      18.8221862
	Dec     42.463825
	Dist    954
	AppMagn 14.931
	MassSol 0.98
	RadSol  0.97
	Teff    5698
	FeH     0.03
}

Star	"Kepler-83/KOI-898/KIC 7870390"
{
	RA      18.81550087
	Dec     43.665627
	AppMagn 15.777
	MassSol 0.66
	RadSol  0.59
	Teff    4648
	FeH    -0.195
}

Star	"Kepler-830/KOI-1377/KIC 7211469"
{
	RA      19.67028573
	Dec     42.756847
	Dist    1122
	AppMagn 14.788
	MassSol 1.07
	RadSol  1.11
	Teff    6037
	FeH    -0.02
}

Star	"Kepler-831/KOI-1379/KIC 7211221"
{
	RA      19.6656994
	Dec     42.727669
	Dist    577
	AppMagn 13.687
	MassSol 0.99
	RadSol  0.97
	Teff    5732
	FeH     0.02
}

Star	"Kepler-832/KOI-1402/KIC 9034103"
{
	RA      19.72840627
	Dec     45.383862
	Dist    1346
	AppMagn 15.906
	MassSol 0.92
	RadSol  0.9
	Teff    5596
	FeH    -0.08
}

Star	"Kepler-833/KOI-1403/KIC 9214942"
{
	RA      19.36533027
	Dec     45.6007
	Dist    421
	AppMagn 15.473
	MassSol 0.64
	RadSol  0.62
	Teff    4339
	FeH    -0.18
}

Star	"Kepler-834/KOI-1404/KIC 8874090"
{
	RA      19.13696773
	Dec     45.180374
	Dist    620
	AppMagn 15.931
	MassSol 0.7
	RadSol  0.66
	Teff    4554
	FeH    -0.13
}

Star	"Kepler-835/KOI-1405/KIC 9264949"
{
	RA      18.90494887
	Dec     45.734802
	Dist    2011
	AppMagn 15.965
	MassSol 1.08
	RadSol  1.11
	Teff    5954
	FeH     0.08
}

Star	"Kepler-836/KOI-1406/KIC 9271752"
{
	RA      19.16351853
	Dec     45.704399
	Dist    1003
	AppMagn 14.63
	MassSol 1.03
	RadSol  1.04
	Teff    5895
	FeH    -0.01
}

Star	"Kepler-837/KOI-1409/KIC 9391208"
{
	RA      19.01644467
	Dec     45.950195
	Dist    846
	AppMagn 15.198
	MassSol 0.85
	RadSol  0.81
	Teff    5403
	FeH    -0.18
}

Star	"Kepler-838/KOI-1410/KIC 9391506"
{
	RA      19.02903413
	Dec     45.976021
	Dist    1210
	AppMagn 15.3
	MassSol 0.98
	RadSol  0.96
	Teff    5770
	FeH    -0.06
}

Star	"Kepler-839/KOI-1412/KIC 8950853"
{
	RA      19.4049784
	Dec     45.242584
	Dist    833
	AppMagn 13.601
	MassSol 1.22
	RadSol  1.31
	Teff    6058
	FeH     0.29
}

Star	"Kepler-84/KOI-1589/KIC 5301750"
{
	RA      19.88346967
	Dec     40.496075
	AppMagn 14.764
	MassSol 1
	RadSol  1.17
	Teff    6031
	FeH    -0.131
}

Star	"Kepler-840"
{
	RA      19.7671596
	Dec     49.457291
	Dist    778
	AppMagn 12.682 // not V mag
	MassSol 1.04
	RadSol  1.06
	Teff    5920
	FeH     0
}

Star	"Kepler-841/KOI-1423/KIC 11177707"
{
	RA      18.95008707
	Dec     48.809612
	Dist    1052
	AppMagn 15.74
	MassSol 0.85
	RadSol  0.81
	Teff    5324
	FeH    -0.09
}

Star	"Kepler-842/KOI-1424/KIC 11611600"
{
	RA      19.48857207
	Dec     49.653538
	Dist    552
	AppMagn 15.127
	MassSol 0.78
	RadSol  0.73
	Teff    4848
	FeH    -0.02
}

Star	"Kepler-843/KOI-1425/KIC 11254382"
{
	RA      19.7547996
	Dec     48.971478
	Dist    1247
	AppMagn 15.269
	MassSol 1.02
	RadSol  1.03
	Teff    5830
	FeH     0.05
}

Star	"Kepler-844/KOI-1427/KIC 11129738"
{
	RA      19.19051527
	Dec     48.774113
	Dist    394
	AppMagn 15.84
	MassSol 0.59
	RadSol  0.57
	Teff    4128
	FeH    -0.24
}

Star	"Kepler-845/KOI-1428/KIC 11401182"
{
	RA      19.397171
	Dec     49.203812
	Dist    471
	AppMagn 14.631
	MassSol 0.79
	RadSol  0.75
	Teff    4913
	FeH     0.01
}

Star	"Kepler-846/KOI-1433/KIC 11288505"
{
	RA      19.1371344
	Dec     49.046021
	Dist    1233
	AppMagn 15.65
	MassSol 0.94
	RadSol  0.91
	Teff    5579
	FeH     0
}

Star	"Kepler-847/KOI-1434/KIC 11493431"
{
	RA      18.90031987
	Dec     49.451015
	Dist    529
	AppMagn 14.782
	MassSol 0.83
	RadSol  0.77
	Teff    4940
	FeH     0.15
}

Star	"Kepler-848/KOI-1438/KIC 11193263"
{
	RA      19.55255153
	Dec     48.811619
	Dist    797
	AppMagn 14.056
	MassSol 1.01
	RadSol  1.2
	Teff    5695
	FeH     0.15
}

Star	"Kepler-849/KOI-1439/KIC 11027624"
{
	RA      19.3901186
	Dec     48.521339
	Dist    747
	AppMagn 12.849
	MassSol 1.23
	RadSol  1.64
	Teff    6059
	FeH     0.12
}

Star	"Kepler-85/KOI-2038/KIC 8950568"
{
	RA      19.39822793
	Dec     45.290318
	AppMagn 14.779
	MassSol 0.92
	RadSol  0.89
	Teff    5436
	FeH    -0.031
}

Star	"Kepler-850/KOI-1440/KIC 11032227"
{
	RA      19.53896413
	Dec     48.57539
	Dist    1535
	AppMagn 15.451
	MassSol 1.06
	RadSol  1.09
	Teff    5932
	FeH     0.03
}

Star	"Kepler-851/KOI-1441/KIC 11356260"
{
	RA      19.6453524
	Dec     49.14016
	Dist    869
	AppMagn 15.135
	MassSol 0.89
	RadSol  0.85
	Teff    5455
	FeH    -0.07
}

Star	"Kepler-852/KOI-1444/KIC 11043167"
{
	RA      19.8261062
	Dec     48.560692
	Dist    854
	AppMagn 13.949
	MassSol 1.19
	RadSol  1.16
	Teff    6100
	FeH     0.22
}

Star	"Kepler-853/KOI-1445/KIC 11336883"
{
	RA      18.9291216
	Dec     49.110325
	Dist    610
	AppMagn 12.32
	MassSol 1.3
	RadSol  1.55
	Teff    6350
	FeH     0.07
}

Star	"Kepler-854"
{
	RA      19.55675287
	Dec     43.13464
	Dist    741
	AppMagn 12.106 // not V mag
	MassSol 1.17
	RadSol  1.27
	Teff    6179
	FeH     0.04
}

Star	"Kepler-855/KOI-1456/KIC 7832356"
{
	RA      19.67299933
	Dec     43.537586
	Dist    1043
	AppMagn 15.014
	MassSol 1.03
	RadSol  1.03
	Teff    5835
	FeH     0.06
}

Star	"Kepler-856/KOI-1457/KIC 9643874"
{
	RA      19.3069224
	Dec     46.314953
	Dist    1175
	AppMagn 15.57
	MassSol 0.96
	RadSol  0.93
	Teff    5535
	FeH     0.12
}

Star	"Kepler-857/KOI-1472/KIC 7761545"
{
	RA      19.64215927
	Dec     43.400467
	Dist    1039
	AppMagn 15.061
	MassSol 0.99
	RadSol  0.99
	Teff    5773
	FeH     0.02
}

Star	"Kepler-858/KOI-1478/KIC 12403119"
{
	RA      19.2565754
	Dec     51.209049
	Dist    296
	AppMagn 12.45
	MassSol 0.96
	RadSol  0.91
	Teff    5653
	FeH    -0.04
}

Star	"Kepler-859/KOI-1480/KIC 7512982"
{
	RA      19.11612487
	Dec     43.190108
	Dist    915
	AppMagn 15.887
	MassSol 0.81
	RadSol  0.77
	Teff    5020
	FeH    -0.02
}

Star	"Kepler-86/KOI-3663/KIC 12735740"
{
	RA      19.3175
	Dec     51.9625
	AppMagn 12.62
	MassSol 0.94
	RadSol  1
	Teff    5629
	FeH    -0.078
}

Star	"Kepler-860/KOI-1481/KIC 9597806"
{
	RA      19.705151
	Dec     46.254742
	Dist    1295
	AppMagn 15.455
	MassSol 1.04
	RadSol  1.06
	Teff    5836
	FeH     0.09
}

Star	"Kepler-861/KOI-1488/KIC 9589323"
{
	RA      19.49026193
	Dec     46.22628
	Dist    806
	AppMagn 15.623
	MassSol 0.82
	RadSol  0.78
	Teff    5047
	FeH     0.01
}

Star	"Kepler-862/KOI-1491/KIC 9726659"
{
	RA      19.85195107
	Dec     46.492741
	Dist    806
	AppMagn 15.297
	MassSol 0.88
	RadSol  0.84
	Teff    5333
	FeH     0.04
}

Star	"Kepler-863/KOI-1495/KIC 7629518"
{
	RA      19.84430153
	Dec     43.248962
	Dist    1145
	AppMagn 15.43
	MassSol 0.96
	RadSol  0.95
	Teff    5678
	FeH    -0.03
}

Star	"Kepler-864/KOI-1498/KIC 9636135"
{
	RA      19.00380613
	Dec     46.320675
	Dist    1573
	AppMagn 15.776
	MassSol 1
	RadSol  1
	Teff    5754
	FeH     0.04
}

Star	"Kepler-865/KOI-1499/KIC 7841925"
{
	RA      19.84828553
	Dec     43.527435
	Dist    664
	AppMagn 14.48
	MassSol 0.93
	RadSol  0.92
	Teff    5570
	FeH    -0.01
}

Star	"Kepler-866/KOI-1501/KIC 7439316"
{
	RA      19.34148913
	Dec     43.08556
	Dist    690
	AppMagn 15.835
	MassSol 0.75
	RadSol  0.71
	Teff    4751
	FeH    -0.07
}

Star	"Kepler-867/KOI-1503/KIC 12400538"
{
	RA      19.1523542
	Dec     51.249981
	Dist    824
	AppMagn 14.827
	MassSol 0.92
	RadSol  0.91
	Teff    5541
	FeH    -0.02
}

Star	"Kepler-868/KOI-1505/KIC 9813499"
{
	RA      18.82423413
	Dec     46.67524
	Dist    1269
	AppMagn 15.695
	MassSol 0.93
	RadSol  0.89
	Teff    5614
	FeH    -0.08
}

Star	"Kepler-869/KOI-1506/KIC 12254792"
{
	RA      19.29497273
	Dec     50.994122
	Dist    957
	AppMagn 14.982
	MassSol 0.97
	RadSol  0.95
	Teff    5664
	FeH     0.02
}

Star	"Kepler-87/KOI-1574/KIC 10028792"
{
	RA      19.86112467
	Dec     46.96513
	AppMagn 14.6
	MassSol 1.1
	RadSol  1.82
	Teff    5600
	FeH    -0.17
	Age     7.5
}

Star	"Kepler-870/KOI-1507/KIC 12020218"
{
	RA      19.69350293
	Dec     50.478634
	Dist    1231
	AppMagn 15.259
	MassSol 1.01
	RadSol  1.02
	Teff    5857
	FeH    -0.01
}

Star	"Kepler-871/KOI-1508/KIC 7690844"
{
	RA      19.63514067
	Dec     43.36816
	Dist    1695
	AppMagn 15.689
	MassSol 1.11
	RadSol  1.14
	Teff    5993
	FeH     0.09
}

Star	"Kepler-872/KOI-1511/KIC 7901948"
{
	RA      19.6944974
	Dec     43.60564
	Dist    1114
	AppMagn 15.106
	MassSol 1.05
	RadSol  1.08
	Teff    5902
	FeH     0.04
}

Star	"Kepler-873/KOI-1516/KIC 12418724"
{
	RA      19.76021413
	Dec     51.271339
	Dist    1397
	AppMagn 14.829
	MassSol 1.18
	RadSol  1.27
	Teff    6163
	FeH     0.07
}

Star	"Kepler-874/KOI-1517/KIC 7456001"
{
	RA      19.66379067
	Dec     43.014328
	Dist    1072
	AppMagn 14.683
	MassSol 1.09
	RadSol  1.13
	Teff    6020
	FeH     0.03
}

Star	"Kepler-875/KOI-1518/KIC 7549209"
{
	RA      19.82008667
	Dec     43.141888
	Dist    1244
	AppMagn 15.219
	MassSol 1.06
	RadSol  1.11
	Teff    5958
	FeH     0.03
}

Star	"Kepler-876/KOI-1519/KIC 7663405"
{
	RA      18.8985466
	Dec     43.383781
	Dist    735
	AppMagn 15.369
	MassSol 0.81
	RadSol  0.77
	Teff    5060
	FeH    -0.03
}

Star	"Kepler-877/KOI-1520/KIC 9765975"
{
	RA      19.32394193
	Dec     46.522667
	Dist    572
	AppMagn 14.516
	MassSol 0.85
	RadSol  0.81
	Teff    5261
	FeH    -0.06
}

Star	"Kepler-878/KOI-1521/KIC 9818462"
{
	RA      19.01974647
	Dec     46.603439
	Dist    567
	AppMagn 14.817
	MassSol 0.81
	RadSol  0.77
	Teff    5044
	FeH    -0.03
}

Star	"Kepler-879/KOI-1522/KIC 12266636"
{
	RA      19.7204382
	Dec     50.909798
	Dist    772
	AppMagn 14.264
	MassSol 1.02
	RadSol  1.02
	Teff    5792
	FeH     0.05
}

Star	"Kepler-88/KOI-142/KIC 5446285"
{
	RA      19.41
	Dec     40.6694
	Dist    385
	AppMagn 13.5
	Class  "B"
	MassSol 1.022
	RadSol  0.961
	Teff    5513
	FeH     0.37
	Age     2.45
}

Star	"Kepler-880/KOI-1525/KIC 7869917"
{
	RA      18.798083
	Dec     43.672771
	Dist    673
	AppMagn 12.082
	MassSol 1.46
	RadSol  1.74
	Teff    6761
	FeH     0.03
}

Star	"Kepler-881/KOI-1526/KIC 9824805"
{
	RA      19.26617253
	Dec     46.670753
	Dist    1364
	AppMagn 15.216
	MassSol 1.06
	RadSol  1.09
	Teff    5961
	FeH     0
}

Star	"Kepler-882/KOI-1528/KIC 7691260"
{
	RA      19.64332567
	Dec     43.335587
	Dist    525
	AppMagn 14.083
	MassSol 0.9
	RadSol  0.87
	Teff    5476
	FeH    -0.03
}

Star	"Kepler-883/KOI-1530/KIC 11954842"
{
	RA      19.0955782
	Dec     50.300327
	Dist    549
	AppMagn 13.029
	MassSol 1.06
	RadSol  1.09
	Teff    6116
	FeH    -0.13
}

Star	"Kepler-884/KOI-1531/KIC 11764462"
{
	RA      19.50562953
	Dec     49.923161
	Dist    420
	AppMagn 13.069
	MassSol 1
	RadSol  0.94
	Teff    5715
	FeH     0.05
}

Star	"Kepler-885/KOI-1532/KIC 11656246"
{
	RA      19.24410393
	Dec     49.737206
	Dist    632
	AppMagn 12.841
	MassSol 1.21
	RadSol  1.35
	Teff    6187
	FeH     0.11
}

Star	"Kepler-886/KOI-1533/KIC 7808587"
{
	RA      19.084783
	Dec     43.595234
	Dist    857
	AppMagn 13.939
	MassSol 1.1
	RadSol  1.16
	Teff    6098
	FeH    -0.01
}

Star	"Kepler-887/KOI-1534/KIC 4741126"
{
	RA      19.33938713
	Dec     39.816989
	Dist    831
	AppMagn 13.47
	MassSol 1.19
	RadSol  1.29
	Teff    6194
	FeH     0.08
}

Star	"Kepler-888/KOI-1535/KIC 11669125"
{
	RA      19.70141373
	Dec     49.738632
	Dist    413
	AppMagn 13.046
	MassSol 0.97
	RadSol  0.9
	Teff    5875
	FeH    -0.21
}

Star	"Kepler-889/KOI-1536/KIC 12159249"
{
	RA      19.4311546
	Dec     50.759489
	Dist    513
	AppMagn 12.71
	MassSol 1.14
	RadSol  1.25
	Teff    5961
	FeH     0.19
}

Star	"Kepler-89/KOI-94/KIC 6462863"
{
	RA      19.82222
	Dec     41.8911
	AppMagn 12.4
	MassSol 1.25
	RadSol  1.656
	Teff    6116
	FeH    -0.01
	Age     3.9
}

Star	"Kepler-890/KOI-1553/KIC 7951018"
{
	RA      19.22904967
	Dec     43.763496
	Dist    1387
	AppMagn 15.182
	MassSol 1.09
	RadSol  1.13
	Teff    5954
	FeH     0.09
}

Star	"Kepler-891/KOI-1564/KIC 5184584"
{
	RA      19.40558647
	Dec     40.355255
	Dist    1372
	AppMagn 15.287
	MassSol 1.06
	RadSol  1.07
	Teff    5887
	FeH     0.09
}

Star	"Kepler-892/KOI-1569/KIC 8009350"
{
	RA      18.8753094
	Dec     43.888241
	Dist    640
	AppMagn 15.587
	MassSol 0.75
	RadSol  0.72
	Teff    4747
	FeH    -0.04
}

Star	"Kepler-893/KOI-1570/KIC 8082001"
{
	RA      18.9975354
	Dec     43.913006
	Dist    1216
	AppMagn 15.182
	MassSol 1
	RadSol  0.99
	Teff    5820
	FeH    -0.03
}

Star	"Kepler-894/KOI-1572/KIC 10004519"
{
	RA      19.2489392
	Dec     46.939396
	Dist    1090
	AppMagn 15.439
	MassSol 0.87
	RadSol  0.85
	Teff    5603
	FeH    -0.25
}

Star	"Kepler-895/KOI-1577/KIC 12506770"
{
	RA      19.28604353
	Dec     51.408891
	Dist    516
	AppMagn 15.988
	MassSol 0.65
	RadSol  0.61
	Teff    4315
	FeH    -0.16
}

Star	"Kepler-896/KOI-1581/KIC 7939330"
{
	RA      18.8292788
	Dec     43.734486
	Dist    896
	AppMagn 15.481
	MassSol 0.84
	RadSol  0.81
	Teff    5262
	FeH    -0.1
}

Star	"Kepler-897/KOI-1583/KIC 12602568"
{
	RA      19.3724558
	Dec     51.69582
	Dist    1147
	AppMagn 15.068
	MassSol 1.03
	RadSol  1.04
	Teff    5839
	FeH     0.04
}

Star	"Kepler-898/KOI-1584/KIC 9941066"
{
	RA      19.1056926
	Dec     46.87093
	Dist    479
	AppMagn 15.961
	MassSol 0.65
	RadSol  0.62
	Teff    4223
	FeH    -0.06
}

Star	"Kepler-899/KOI-1585/KIC 5470739"
{
	RA      19.832172
	Dec     40.68078
	Dist    1038
	AppMagn 15.401
	MassSol 0.93
	RadSol  0.91
	Teff    5595
	FeH    -0.06
}

Star	"Kepler-9/KOI-377/KIC 3323887"
{
	RA      19.03833333
	Dec     38.4008333
	Dist    650
	AppMagn 13.9
	MassSol 1
	RadSol  1.1
	Teff    5722
	FeH     0.17
	Age     3
}

Star	"Kepler-90/KOI-351/KIC 11442793"
{
	RA      18.96223347
	Dec     49.305161
	Dist    780
	AppMagn 14
	MassSol 1.13
	RadSol  1.2
	Teff    5930
	FeH    -0.17
}

Star	"Kepler-900/KOI-1586/KIC 10022908"
{
	RA      19.74515313
	Dec     46.99902
	Dist    505
	AppMagn 14.94
	MassSol 0.78
	RadSol  0.73
	Teff    4836
	FeH    -0.01
}

Star	"Kepler-901/KOI-1588/KIC 5617854"
{
	RA      19.41019673
	Dec     40.887497
	Dist    241
	AppMagn 14.699
	MassSol 0.59
	RadSol  0.57
	Teff    4184
	FeH    -0.3
}

Star	"Kepler-902/KOI-1595/KIC 10006581"
{
	RA      19.31544613
	Dec     46.953823
	Dist    904
	AppMagn 14.904
	MassSol 0.95
	RadSol  0.93
	Teff    5647
	FeH     0
}

Star	"Kepler-903/KOI-1601/KIC 5438757"
{
	RA      19.2514012
	Dec     40.664176
	Dist    829
	AppMagn 14.659
	MassSol 0.98
	RadSol  0.97
	Teff    5682
	FeH     0.05
}

Star	"Kepler-904/KOI-1603/KIC 5177104"
{
	RA      19.25486107
	Dec     40.389049
	Dist    1151
	AppMagn 14.429
	MassSol 1.16
	RadSol  1.25
	Teff    6160
	FeH     0.05
}

Star	"Kepler-905/KOI-1606/KIC 9886661"
{
	RA      19.33674153
	Dec     46.713375
	Dist    521
	AppMagn 13.984
	MassSol 0.95
	RadSol  0.86
	Teff    5461
	FeH     0.09
}

Star	"Kepler-906/KOI-1609/KIC 5009743"
{
	RA      19.4270374
	Dec     40.125487
	Dist    758
	AppMagn 13.956
	MassSol 1.06
	RadSol  1.02
	Teff    6035
	FeH    -0.09
}

Star	"Kepler-907/KOI-1613/KIC 6268648"
{
	RA      19.0317726
	Dec     41.63274
	Dist    352
	AppMagn 11.049
	MassSol 1.08
	RadSol  1.38
	Teff    6106
	FeH    -0.15
}

Star	"Kepler-908/KOI-1615/KIC 4278221"
{
	RA      19.6881678
	Dec     39.376484
	Dist    250
	AppMagn 11.524
	MassSol 1.11
	RadSol  1.12
	Teff    5973
	FeH     0.15
}

Star	"Kepler-909/KOI-1616/KIC 9015738"
{
	RA      19.30042387
	Dec     45.370998
	Dist    318
	AppMagn 11.538
	MassSol 1.17
	RadSol  1.23
	Teff    6154
	FeH     0.08
}

Star	"Kepler-91/KOI-2133/KIC 8219268"
{
	RA      19.0448588
	Dec     44.116734
	Dist    1030
	AppMagn 12.9
	Class  "K3"
	MassSol 1.31
	RadSol  6.3
	Teff    4550
	FeH     0.11
	Age     4.86
}

Star	"Kepler-910/KOI-1618/KIC 7215603"
{
	RA      19.73649053
	Dec     42.743006
	Dist    402
	AppMagn 11.6
	MassSol 1.26
	RadSol  1.5
	Teff    6230
	FeH     0.12
}

Star	"Kepler-911/KOI-1621/KIC 5561278"
{
	RA      19.90594573
	Dec     40.750689
	Dist    567
	AppMagn 11.855
	MassSol 1.34
	RadSol  1.99
	Teff    6112
	FeH     0.03
}

Star	"Kepler-912/KOI-1626/KIC 6387542"
{
	RA      19.8740804
	Dec     41.758333
	Dist    1265
	AppMagn 15.341
	MassSol 1.07
	RadSol  1.11
	Teff    5998
	FeH     0.02
}

Star	"Kepler-913/KOI-1627/KIC 6543893"
{
	RA      19.8388748
	Dec     41.952431
	Dist    597
	AppMagn 15.767
	MassSol 0.63
	RadSol  0.61
	Teff    4687
	FeH    -0.52
}

Star	"Kepler-914/KOI-1629/KIC 8685497"
{
	RA      19.36080007
	Dec     44.89933
	Dist    678
	AppMagn 13.574
	MassSol 1.1
	RadSol  1.15
	Teff    5877
	FeH     0.22
}

Star	"Kepler-915/KOI-1632/KIC 9277896"
{
	RA      19.37280513
	Dec     45.737137
	Dist    806
	AppMagn 13.298
	MassSol 1.21
	RadSol  1.38
	Teff    6173
	FeH     0.08
}

Star	"Kepler-916/KOI-1633/KIC 9401997"
{
	RA      19.39888813
	Dec     45.973301
	Dist    769
	AppMagn 15.2
	MassSol 0.85
	RadSol  0.81
	Teff    5248
	FeH    -0.05
}

Star	"Kepler-917/KOI-1637/KIC 10686864"
{
	RA      19.93675067
	Dec     47.949284
	Dist    1027
	AppMagn 15.759
	MassSol 0.8
	RadSol  0.76
	Teff    5418
	FeH    -0.38
}

Star	"Kepler-918/KOI-1641/KIC 10879038"
{
	RA      19.88004793
	Dec     48.267838
	Dist    1245
	AppMagn 14.971
	MassSol 1.11
	RadSol  1.14
	Teff    6028
	FeH     0.06
}

Star	"Kepler-919/KOI-1643/KIC 10990917"
{
	RA      19.87431813
	Dec     48.494404
	Dist    1219
	AppMagn 14.681
	MassSol 1.15
	RadSol  1.21
	Teff    6113
	FeH     0.07
}

Star	"Kepler-92/KOI-285/KIC 6196457"
{
	RA      19.2725
	Dec     41.5631
	Dist    448.57
	AppMagn 11.6
	MassSol 1.209
	RadSol  1.716
	Teff    5871
	FeH     0.17
	Age     5.52
}

Star	"Kepler-920/KOI-1650/KIC 11337372"
{
	RA      18.95312993
	Dec     49.158676
	Dist    926
	AppMagn 15.28
	MassSol 0.89
	RadSol  0.85
	Teff    5403
	FeH     0
}

Star	"Kepler-921/KOI-1651/KIC 11337833"
{
	RA      18.97441367
	Dec     49.190811
	Dist    847
	AppMagn 14.739
	MassSol 0.93
	RadSol  0.91
	Teff    5663
	FeH    -0.12
}

Star	"Kepler-922/KOI-1655/KIC 11547505"
{
	RA      18.98209747
	Dec     49.533195
	Dist    558
	AppMagn 13.757
	MassSol 0.95
	RadSol  0.93
	Teff    5671
	FeH    -0.05
}

Star	"Kepler-923/KOI-1665/KIC 4932442"
{
	RA      19.61140567
	Dec     40.055165
	Dist    966
	AppMagn 14.042
	MassSol 1.11
	RadSol  1.26
	Teff    5988
	FeH     0.07
}

Star	"Kepler-924/KOI-1669/KIC 5183357"
{
	RA      19.3779008
	Dec     40.397718
	Dist    995
	AppMagn 14.171
	MassSol 1.14
	RadSol  1.23
	Teff    6167
	FeH     0.01
}

Star	"Kepler-925/KOI-1672/KIC 5269467"
{
	RA      19.34043593
	Dec     40.490657
	Dist    623
	AppMagn 15.81
	MassSol 0.77
	RadSol  0.72
	Teff    4673
	FeH     0.12
}

Star	"Kepler-926/KOI-1677/KIC 5526717"
{
	RA      19.3119562
	Dec     40.700466
	Dist    771
	AppMagn 14.279
	MassSol 1.01
	RadSol  1.01
	Teff    5806
	FeH     0.03
}

Star	"Kepler-927/KOI-1683/KIC 6034945"
{
	RA      19.292234
	Dec     41.392695
	Dist    879
	AppMagn 14.63
	MassSol 0.99
	RadSol  0.99
	Teff    5743
	FeH     0.03
}

Star	"Kepler-928/KOI-1687/KIC 6198999"
{
	RA      19.3280478
	Dec     41.542828
	Dist    532
	AppMagn 15.32
	MassSol 0.73
	RadSol  0.7
	Teff    4700
	FeH    -0.11
}

Star	"Kepler-929/KOI-1688/KIC 6310636"
{
	RA      19.8987416
	Dec     41.615332
	Dist    820
	AppMagn 14.542
	MassSol 1.01
	RadSol  1.02
	Teff    5869
	FeH    -0.04
}

Star	"Kepler-93/KOI-69/KIC 3544595"
{
	RA      19.42805556
	Dec     38.67250002
	AppMagn 9.931
	MassSol 0.911
	RadSol  0.919
	Teff    5669
	FeH    -0.18
	Age     6.6
}

Star	"Kepler-930/KOI-1695/KIC 6803855"
{
	RA      19.8876296
	Dec     42.247434
	Dist    905
	AppMagn 13.781
	MassSol 1.25
	RadSol  1.4
	Teff    6335
	FeH     0.04
}

Star	"Kepler-931/KOI-1700/KIC 7220429"
{
	RA      19.80884273
	Dec     42.768253
	Dist    490
	AppMagn 14.471
	MassSol 0.86
	RadSol  0.81
	Teff    5241
	FeH    -0.01
}

Star	"Kepler-932/KOI-1706/KIC 7626370"
{
	RA      19.79680413
	Dec     43.271969
	Dist    478
	AppMagn 14.131
	MassSol 0.87
	RadSol  0.84
	Teff    5331
	FeH    -0.01
}

Star	"Kepler-933/KOI-1710/KIC 7815744"
{
	RA      19.30457727
	Dec     43.538612
	Dist    922
	AppMagn 15.469
	MassSol 0.87
	RadSol  0.84
	Teff    5346
	FeH    -0.02
}

Star	"Kepler-934/KOI-1711/KIC 7955580"
{
	RA      19.35256447
	Dec     43.755322
	Dist    603
	AppMagn 15.061
	MassSol 0.81
	RadSol  0.77
	Teff    5001
	FeH     0.01
}

Star	"Kepler-935/KOI-1716/KIC 9838949"
{
	RA      19.6681112
	Dec     46.619217
	Dist    482
	AppMagn 14.925
	MassSol 0.78
	RadSol  0.73
	Teff    4830
	FeH    -0.01
}

Star	"Kepler-936/KOI-1717/KIC 9895006"
{
	RA      19.5718506
	Dec     46.736347
	Dist    687
	AppMagn 14.581
	MassSol 0.92
	RadSol  0.89
	Teff    5482
	FeH     0.05
}

Star	"Kepler-937/KOI-1718/KIC 9896558"
{
	RA      19.61125367
	Dec     46.714611
	Dist    1482
	AppMagn 15.224
	MassSol 1.15
	RadSol  1.22
	Teff    6095
	FeH     0.08
}

Star	"Kepler-938/KOI-1721/KIC 10019065"
{
	RA      19.65260953
	Dec     46.98399
	Dist    861
	AppMagn 15.004
	MassSol 0.92
	RadSol  0.89
	Teff    5533
	FeH    -0.03
}

Star	"Kepler-939/KOI-1722/KIC 10080248"
{
	RA      19.59104087
	Dec     47.026829
	Dist    1029
	AppMagn 15.534
	MassSol 0.88
	RadSol  0.85
	Teff    5471
	FeH    -0.12
}

Star	"Kepler-94/KOI-104/KIC 10318874"
{
	RA      18.74631667
	Dec     47.49713891
	AppMagn 12.895
	MassSol 0.81
	RadSol  0.76
	Teff    4781
	FeH     0.34
	Age     1.41
}

Star	"Kepler-940/KOI-1723/KIC 10213902"
{
	RA      19.6160862
	Dec     47.275982
	Dist    1317
	AppMagn 15.517
	MassSol 0.97
	RadSol  0.96
	Teff    5769
	FeH    -0.08
}

Star	"Kepler-941/KOI-1724/KIC 10214162"
{
	RA      19.62175707
	Dec     47.217613
	Dist    1105
	AppMagn 15.601
	MassSol 0.89
	RadSol  0.86
	Teff    5539
	FeH    -0.15
}

Star	"Kepler-942/KOI-1726/KIC 8242434"
{
	RA      19.66367427
	Dec     44.149818
	Dist    218
	AppMagn 13.054
	MassSol 0.81
	RadSol  0.75
	Teff    4861
	FeH     0.09
}

Star	"Kepler-943/KOI-1727/KIC 6185331"
{
	RA      18.95159767
	Dec     41.535023
	Dist    1239
	AppMagn 15
	MassSol 0.93
	RadSol  0.91
	Teff    5612
	FeH    -0.07
	Age     8.7
}

Star	"Kepler-944/KOI-1732/KIC 6869184"
{
	RA      19.57341747
	Dec     42.379761
	Dist    1035
	AppMagn 15.737
	MassSol 0.86
	RadSol  0.83
	Teff    5409
	FeH    -0.11
}

Star	"Kepler-945/KOI-1736/KIC 6604328"
{
	RA      19.4179832
	Dec     42.096046
	Dist    1543
	AppMagn 15.898
	MassSol 0.97
	RadSol  0.97
	Teff    5718
	FeH    -0.01
}

Star	"Kepler-946/KOI-1746/KIC 8197343"
{
	RA      20.06197373
	Dec     44.02879
	Dist    918
	AppMagn 14.941
	MassSol 0.94
	RadSol  0.93
	Teff    5665
	FeH    -0.09
}

Star	"Kepler-947/KOI-1749/KIC 6786348"
{
	RA      19.62444847
	Dec     42.252678
	Dist    1188
	AppMagn 15.789
	MassSol 0.9
	RadSol  0.87
	Teff    5508
	FeH    -0.07
}

Star	"Kepler-948/KOI-1750/KIC 6209677"
{
	RA      19.55334873
	Dec     41.523338
	Dist    884
	AppMagn 14.8
	MassSol 0.96
	RadSol  0.94
	Teff    5679
	FeH    -0.02
}

Star	"Kepler-949/KOI-1751/KIC 9729691"
{
	RA      19.90719173
	Dec     46.453682
	Dist    572
	AppMagn 14.548
	MassSol 0.89
	RadSol  0.86
	Teff    5403
	FeH     0.01
}

Star	"Kepler-95/KOI-122/KIC 8349582"
{
	RA      18.96549722
	Dec     44.3980278
	AppMagn 12.346
	MassSol 1.08
	RadSol  1.41
	Teff    5699
	FeH     0.3
	Age     5.63
}

Star	"Kepler-950/KOI-1787/KIC 5864975"
{
	RA      19.1971044
	Dec     41.130329
	Dist    1489
	AppMagn 15.7
	MassSol 1.02
	RadSol  1.02
	Teff    5857
	FeH     0.02
}

Star	"Kepler-951/KOI-1788/KIC 2975770"
{
	RA      19.182504
	Dec     38.114567
	Dist    408
	AppMagn 14.521
	MassSol 0.77
	RadSol  0.73
	Teff    4834
	FeH    -0.01
}

Star	"Kepler-952/KOI-1790/KIC 6504954"
{
	RA      19.0247966
	Dec     41.993912
	Dist    1167
	AppMagn 15.254
	MassSol 1
	RadSol  0.99
	Teff    5730
	FeH     0.06
}

Star	"Kepler-953/KOI-1792/KIC 8552719"
{
	RA      19.26477747
	Dec     44.624531
	Dist    240
	AppMagn 12.16
	MassSol 0.95
	RadSol  0.99
	Teff    5416
	FeH     0.26
}

Star	"Kepler-954/KOI-1797/KIC 10676014"
{
	RA      19.72395853
	Dec     47.93951
	Dist    224
	AppMagn 12.971
	MassSol 0.82
	RadSol  0.76
	Teff    4990
	FeH     0.02
}

Star	"Kepler-955/KOI-1801/KIC 5088591"
{
	RA      19.23143053
	Dec     40.269795
	Dist    637
	AppMagn 14.625
	MassSol 0.89
	RadSol  0.84
	Teff    5350
	FeH     0.02
}

Star	"Kepler-956/KOI-1802/KIC 11298298"
{
	RA      19.50205373
	Dec     49.061707
	Dist    631
	AppMagn 13.345
	MassSol 1.1
	RadSol  1.15
	Teff    6040
	FeH     0.02
}

Star	"Kepler-957/KOI-1804/KIC 11187436"
{
	RA      19.3437564
	Dec     48.818996
	Dist    749
	AppMagn 15.625
	MassSol 0.81
	RadSol  0.75
	Teff    4963
	FeH    -0.01
}

Star	"Kepler-958/KOI-1813/KIC 9455325"
{
	RA      19.15044567
	Dec     46.066769
	Dist    467
	AppMagn 13.766
	MassSol 0.91
	RadSol  0.86
	Teff    5421
	FeH     0.01
}

Star	"Kepler-959/KOI-1814/KIC 5621125"
{
	RA      19.47807787
	Dec     40.811382
	Dist    1003
	AppMagn 12.538
	MassSol 1.6
	RadSol  2.01
	Teff    7005
	FeH     0.02
}

Star	"Kepler-96/KOI-261/KIC 5383248"
{
	RA      19.80464167
	Dec     40.52513891
	AppMagn 10.297
	MassSol 1
	RadSol  1.02
	Teff    5690
	FeH     0.04
	Age     2.34
}

Star	"Kepler-960/KOI-1815/KIC 9872283"
{
	RA      18.76381087
	Dec     46.746468
	Dist    298
	AppMagn 13.884
	MassSol 0.77
	RadSol  0.72
	Teff    4755
	FeH     0.02
}

Star	"Kepler-961/KOI-1818/KIC 7870032"
{
	RA      18.8023664
	Dec     43.631268
	Dist    607
	AppMagn 14.101
	MassSol 0.96
	RadSol  0.9
	Teff    5582
	FeH     0.05
}

Star	"Kepler-962/KOI-1819/KIC 9597058"
{
	RA      19.687543
	Dec     46.237488
	Dist    439
	AppMagn 13.576
	MassSol 0.93
	RadSol  0.86
	Teff    5478
	FeH     0.01
}

Star	"Kepler-963/KOI-1821/KIC 8832512"
{
	RA      19.78353153
	Dec     45.0411
	Dist    786
	AppMagn 14.943
	MassSol 0.91
	RadSol  0.87
	Teff    5461
	FeH    -0.02
}

Star	"Kepler-964/KOI-1825/KIC 5375194"
{
	RA      19.68667267
	Dec     40.556591
	Dist    478
	AppMagn 13.895
	MassSol 0.93
	RadSol  0.84
	Teff    5427
	FeH     0.03
}

Star	"Kepler-965/KOI-1826/KIC 6468138"
{
	RA      19.90102253
	Dec     41.891205
	Dist    618
	AppMagn 13.35
	MassSol 1.05
	RadSol  1.15
	Teff    5886
	FeH     0.03
}

Star	"Kepler-966/KOI-1828/KIC 11875734"
{
	RA      19.81803853
	Dec     50.121811
	Dist    773
	AppMagn 14.422
	MassSol 1.02
	RadSol  1.02
	Teff    5840
	FeH     0.04
}

Star	"Kepler-967/KOI-1830/KIC 3326377"
{
	RA      19.10387167
	Dec     38.40536
	Dist    499
	AppMagn 14.443
	MassSol 0.84
	RadSol  0.8
	Teff    5178
	FeH    -0.03
}

Star	"Kepler-968/KOI-1833/KIC 11853878"
{
	RA      19.04016853
	Dec     50.112038
	Dist    312
	AppMagn 14.265
	MassSol 0.76
	RadSol  0.7
	Teff    4598
	FeH     0.13
}

Star	"Kepler-969/KOI-1837/KIC 10657406"
{
	RA      19.22483387
	Dec     47.933556
	Dist    411
	AppMagn 13.733
	MassSol 0.92
	RadSol  0.82
	Teff    5214
	FeH     0.22
}

Star	"Kepler-97/KOI-292/KIC 11075737"
{
	RA      19.15510867
	Dec     48.673431
	AppMagn 12.872
	MassSol 0.94
	RadSol  0.98
	Teff    5779
	FeH    -0.2
}

Star	"Kepler-970/KOI-1838/KIC 5526527"
{
	RA      19.30834867
	Dec     40.708726
	Dist    350
	AppMagn 14.786
	MassSol 0.7
	RadSol  0.67
	Teff    4511
	FeH    -0.08
}

Star	"Kepler-971/KOI-1839/KIC 5856571"
{
	RA      18.93963913
	Dec     41.182821
	Dist    345
	AppMagn 13.237
	MassSol 0.88
	RadSol  0.85
	Teff    5431
	FeH    -0.06
}

Star	"Kepler-972/KOI-1840/KIC 7765528"
{
	RA      19.72191353
	Dec     43.425495
	Dist    1304
	AppMagn 14.915
	MassSol 1.15
	RadSol  1.22
	Teff    6146
	FeH     0.04
}

Star	"Kepler-973/KOI-1841/KIC 11760231"
{
	RA      19.34435053
	Dec     49.923862
	Dist    297
	AppMagn 13.218
	MassSol 0.86
	RadSol  0.78
	Teff    5213
	FeH    -0.06
}

Star	"Kepler-974/KOI-1843/KIC 5080636"
{
	RA      19.00087347
	Dec     40.220753
	Dist    121
	AppMagn 14.404
	MassSol 0.52
	RadSol  0.5
	Teff    3687
	FeH     0.07
}

Star	"Kepler-975/KOI-1845/KIC 3338885"
{
	RA      19.36990333
	Dec     38.495275
	Dist    404
	AppMagn 14.438
	MassSol 0.8
	RadSol  0.75
	Teff    4897
	FeH     0.07
}

Star	"Kepler-976/KOI-1846/KIC 9886255"
{
	RA      19.32464273
	Dec     46.729706
	Dist    1020
	AppMagn 15.795
	MassSol 0.87
	RadSol  0.83
	Teff    5232
	FeH     0.07
}

Star	"Kepler-977/KOI-1847/KIC 6776401"
{
	RA      19.434414
	Dec     42.248196
	Dist    664
	AppMagn 14.812
	MassSol 0.87
	RadSol  0.83
	Teff    5315
	FeH    -0.01
}

Star	"Kepler-978/KOI-1848/KIC 7430034"
{
	RA      19.1140482
	Dec     43.043453
	Dist    624
	AppMagn 13.429
	MassSol 1.07
	RadSol  1.09
	Teff    6002
	FeH    -0.01
}

Star	"Kepler-979/KOI-1849/KIC 9735426"
{
	RA      20.02475207
	Dec     46.408276
	Dist    606
	AppMagn 14.624
	MassSol 0.87
	RadSol  0.83
	Teff    5310
	FeH    -0.02
}

Star	"Kepler-98/KOI-299/KIC 2692377"
{
	RA      19.04411013
	Dec     37.964504
	AppMagn 12.899
	MassSol 0.99
	RadSol  1.11
	Teff    5539
	FeH     0.18
}

Star	"Kepler-980/KOI-1850/KIC 8826168"
{
	RA      19.6408672
	Dec     45.060169
	Dist    804
	AppMagn 14.138
	MassSol 1.05
	RadSol  1.06
	Teff    5935
	FeH     0.01
}

Star	"Kepler-981/KOI-1851/KIC 10464050"
{
	RA      19.28326047
	Dec     47.650101
	Dist    913
	AppMagn 14.769
	MassSol 0.98
	RadSol  0.96
	Teff    5718
	FeH     0.01
}

Star	"Kepler-982/KOI-1852/KIC 9763348"
{
	RA      19.22784533
	Dec     46.590427
	Dist    702
	AppMagn 13.205
	MassSol 1.16
	RadSol  1.29
	Teff    6139
	FeH     0.05
}

Star	"Kepler-983/KOI-1853/KIC 8804397"
{
	RA      19.00693733
	Dec     45.008167
	Dist    655
	AppMagn 13.43
	MassSol 1.13
	RadSol  1.08
	Teff    6052
	FeH     0.12
}

Star	"Kepler-984/KOI-1854/KIC 9662811"
{
	RA      19.79725787
	Dec     46.394127
	Dist    461
	AppMagn 13.534
	MassSol 0.96
	RadSol  0.93
	Teff    5610
	FeH     0.04
}

Star	"Kepler-985/KOI-1858/KIC 8160953"
{
	RA      19.34295387
	Dec     44.049953
	Dist    741
	AppMagn 14.767
	MassSol 0.91
	RadSol  0.85
	Teff    5434
	FeH     0
}

Star	"Kepler-986/KOI-1862/KIC 7286173"
{
	RA      19.53960047
	Dec     42.896431
	Dist    563
	AppMagn 13.668
	MassSol 0.96
	RadSol  0.98
	Teff    5642
	FeH     0.04
}

Star	"Kepler-987/KOI-1866/KIC 9520838"
{
	RA      19.29407133
	Dec     46.130848
	Dist    936
	AppMagn 14.986
	MassSol 0.97
	RadSol  0.91
	Teff    5637
	FeH     0.01
}

Star	"Kepler-988/KOI-1868/KIC 6773862"
{
	RA      19.38055907
	Dec     42.237251
	Dist    248
	AppMagn 15.22
	MassSol 0.55
	RadSol  0.53
	Teff    4005
	FeH    -0.32
}

Star	"Kepler-989/KOI-1870/KIC 10187159"
{
	RA      18.77219393
	Dec     47.233631
	Dist    484
	AppMagn 14.425
	MassSol 0.82
	RadSol  0.78
	Teff    5074
	FeH     0.01
}

Star	"Kepler-99/KOI-305/KIC 6063220"
{
	RA      19.82360027
	Dec     41.300049
	AppMagn 12.97
	MassSol 0.79
	RadSol  0.73
	Teff    4782
	FeH     0.18
}

Star	"Kepler-990/KOI-1875/KIC 9967771"
{
	RA      19.86254727
	Dec     46.881393
	Dist    933
	AppMagn 14.498
	MassSol 1.05
	RadSol  1.08
	Teff    5948
	FeH     0.01
}

Star	"Kepler-991/KOI-1876/KIC 11622600"
{
	RA      19.80604367
	Dec     49.626572
	Dist    370
	AppMagn 15.187
	MassSol 0.64
	RadSol  0.61
	Teff    4392
	FeH    -0.25
}

Star	"Kepler-992/KOI-1877/KIC 10454632"
{
	RA      18.96201867
	Dec     47.641785
	Dist    268
	AppMagn 13.389
	MassSol 0.8
	RadSol  0.74
	Teff    4944
	FeH    -0.04
}

Star	"Kepler-993/KOI-1879/KIC 8367644"
{
	RA      19.50760673
	Dec     44.394661
	Dist    298
	AppMagn 15.967
	MassSol 0.57
	RadSol  0.54
	Teff    3843
	FeH     0.03
}

Star	"Kepler-994/KOI-1880/KIC 10332883"
{
	RA      19.27148167
	Dec     47.40707
	Dist    170
	AppMagn 14.44
	MassSol 0.56
	RadSol  0.54
	Teff    3934
	FeH    -0.13
}

Star	"Kepler-995/KOI-1881/KIC 4035640"
{
	RA      18.9743818
	Dec     39.131038
	Dist    659
	AppMagn 14.907
	MassSol 0.83
	RadSol  0.8
	Teff    5206
	FeH    -0.07
}

Star	"Kepler-996/KOI-1882/KIC 6205228"
{
	RA      19.4608526
	Dec     41.533611
	Dist    1098
	AppMagn 14.668
	MassSol 1.09
	RadSol  1.14
	Teff    6014
	FeH     0.03
}

Star	"Kepler-997/KOI-1883/KIC 11758544"
{
	RA      19.2822246
	Dec     49.938934
	Dist    470
	AppMagn 11.894
	MassSol 1.22
	RadSol  1.56
	Teff    6150
	FeH     0.05
}

Star	"Kepler-998/KOI-1885/KIC 11413812"
{
	RA      19.78361007
	Dec     49.208744
	Dist    996
	AppMagn 14.377
	MassSol 1.12
	RadSol  1.18
	Teff    6058
	FeH     0.07
}

Star	"Kepler-999/KOI-1886/KIC 9549648"
{
	RA      19.9773644
	Dec     46.198418
	Dist    568
	AppMagn 12.239
	MassSol 1.29
	RadSol  1.65
	Teff    6237
	FeH     0.05
}

Star	"LKCA 15/LkCa 15"
{
	RA      4.6549432
	Dec     22.350967
	Dist    145
	AppMagn 11.91
	Class  "K5V"
	MassSol 0.97
	Age     0.002
}

Star	"Libertas/KSI Aql/HD 188310/HIP 97938"
{
	RA      19.90416667
	Dec     8.4613889
	Dist    62.7
	AppMagn 4.72
	Class  "G9IIIb"
	MassSol 2.2
	RadSol  12
	Teff    4780
	FeH    -0.205
}

Star	"Lupus-TR-3"
{
	RA      15.50517173
	Dec     -42.979908
	Dist    2000
	AppMagn 15.841
	MassSol 0.87
	RadSol  0.82
	Teff    5000
}

Star	"MOA-2003-BLG-053L/OGLE-2003-BLG-235L"
{
	RA      18.08777778
	Dec     -28.895
	Dist    5200
	AppMagn 19.7
	Class  "K"
	MassSol 0.63
}

Star	"MOA-2007-BLG-192L"
{
	RA      18.13438833
	Dec     -27.150075
	Dist    1000
	AppMagn 19.81
	Class  "M"
	MassSol 0.06
}

Star	"MOA-2007-BLG-197L"
{
	RA      18.11805556
	Dec     -31.94638892
	Dist    4170
	MassSol 0.82
}

Star	"MOA-2007-BLG-400L"
{
	RA      18.16166113
	Dec     -29.224153
	Dist    5800
	Class  "K2V"
	MassSol 0.3
}

Star	"MOA-2008-BLG-310L"
{
	RA      17.90403613
	Dec     -34.778053
	Dist    6000
	AppMagn 23.38
	Class  "K8V"
	MassSol 0.67
}

Star	"MOA-2008-BLG-379L"
{
	RA      17.98027778
	Dec     -29.80305554
	Dist    3600
	Class  "K"
	MassSol 0.66
}

Star	"MOA-2009-BLG-232L/OGLE-2009-BLG-151L"
{
	RA      17.90611333
	Dec     -29.0558
	Dist    390
	AppMagn 15.84
	MassSol 0.018
}

Star	"MOA-2009-BLG-266L"
{
	RA      17.80054167
	Dec     -35.005411
	Dist    3040
	Class  "M"
	MassSol 0.56
}

Star	"MOA-2009-BLG-319L"
{
	RA      18.1161472
	Dec     -26.819692
	Dist    6100
	Class  "K"
	MassSol 0.38
}

Star	"MOA-2009-BLG-387L"
{
	RA      17.89744167
	Dec     -33.990333
	Dist    5690
	Class  "M"
	MassSol 0.19
}

Star	"MOA-2010-BLG-073L"
{
	RA      18.16981813
	Dec     -26.522932
	Dist    2800
	Class  "M"
	MassSol 0.16
}

Star	"MOA-2010-BLG-328L"
{
	RA      17.96642253
	Dec     -30.715176
	Dist    810
	Class  "M"
	MassSol 0.11
}

Star	"MOA-2010-BLG-353L"
{
	RA      18.08694444
	Dec     -27.29333335
	Dist    6430
	Class  "M"
	MassSol 0.18
}

Star	"MOA-2010-BLG-477L"
{
	RA      18.10194445
	Dec     -31.4544444
	Dist    2300
	Class  "K"
	MassSol 0.67
}

Star	"MOA-2011-BLG-028L"
{
	RA      18.05693333
	Dec     -29.213417
	Dist    7380
	MassSol 0.75
}

Star	"MOA-2011-BLG-262L"
{
	RA      18.0065226
	Dec     -31.245258
	Dist    7000
	Class  "M"
	MassSol 0.12
}

StarBarycenter	"MOA-2011-BLG-274L"
{
	RA      17.91166667
	Dec     -28.91638892
	Dist    800
	Class  "P"
}

Star	"MOA-2011-BLG-293L"
{
	RA      17.92759807
	Dec     -28.476847
	Dist    7720
	AppMagn 19.16
	Class  "G"
	MassSol 0.86
}

Star	"MOA-2011-BLG-322L"
{
	RA      18.08166667
	Dec     -27.2208
	Dist    7740
	Class  "M"
	MassSol 0.31
}

Star	"MOA-2013-BLG-220L"
{
	RA      18.06583333
	Dec     -28.45527776
	Dist    2000
	Class  "L"
	MassSol 0.05
}

Star	"MOA-2013-BLG-605L"
{
	RA      17.97861111
	Dec     -29.39833335
	Dist    3600
	MassSol 0.19
}

Star	"MOA-bin-1L"
{
	RA      17.45283407
	Dec     -29.793972
	Dist    5100
	AppMagn 23
	MassSol 0.75
}

Star	"MU Leo/HD 85503/HIP 48455"
{
	RA      9.879393533
	Dec     26.006952
	Dist    40.78
	AppMagn 3.88
	Class  "K2III"
	MassSol 1.5
	RadSol  11.4
	Teff    4538.2
	FeH     0.36
	Age     3.35
}

Star	"Musica/18 Del/HD 199665/HIP 103527"
{
	RA      20.97387087
	Dec     10.839286
	Dist    73.1
	AppMagn 5.52
	Class  "G6III"
	MassSol 2.3
	RadSol  8.5
	Teff    4979
	FeH    -0.052
}

Star	"NGC 2423 3/BD-13 2130"
{
	RA      7.6192328
	Dec     -13.906663
	Dist    766
	AppMagn 9.45
	Class  "G5V"
	MassSol 2.4
	FeH     0.14
	Age     0.75
}

Star	"NGC 2682 Sand 364"
{
	RA      8.832450333
	Dec     11.692484
	AppMagn 9.8
	Class  "K3III"
	MassSol 1.35
	RadSol  21.8
	Teff    4284
	FeH    -0.02
}

Star	"NGC 2682 YBP 1194"
{
	RA      8.8502238
	Dec     11.814655
	AppMagn 14.6
	Class  "G5V"
	MassSol 1.01
	RadSol  0.99
	Teff    5780
	FeH     0.023
}

Star	"NGC 2682 YBP 1514"
{
	RA      8.8502126
	Dec     11.88653
	AppMagn 14.77
	Class  "G5V"
	MassSol 0.96
	RadSol  0.89
	Teff    5725
	FeH     0.03
}

Star	"NGC 4349 127"
{
	RA      12.40985413
	Dec     -61.820004
	Dist    2200
	AppMagn 10.88
	MassSol 3.9
	FeH    -0.12
	Age     0.21
}

Star	"NLTT 41135"
{
	RA      15.76777778
	Dec     4.691666687
	Dist    22.7
	AppMagn 18
	Class  "M5.1"
	MassSol 0.188
	RadSol  0.21
	Teff    3230
	FeH     0
}

Star	"NU Oph/HD 163917/HIP 88048"
{
	RA      17.9837748
	Dec     -9.773632
	Dist    46.84
	AppMagn 3.34
	Class  "K1III"
	MassSol 3.04
	RadSol  15.1
	Teff    4928
	FeH     0.13
}

Star	"OGLE-2005-BLG-071L"
{
	RA      17.83583333
	Dec     -34.6730556
	Dist    3300
	AppMagn 19.5
	MassSol 0.46
}

Star	"OGLE-2005-BLG-169L"
{
	RA      18.10138889
	Dec     -30.7325
	Dist    4100
	AppMagn 20.4
	Class  "K5"
	MassSol 0.69
}

Star	"OGLE-2005-BLG-390L"
{
	RA      17.90527778
	Dec     -30.3772222
	Dist    6500
	AppMagn 15.7
	Class  "M"
	MassSol 0.22
}

Star	"OGLE-2006-BLG-109L"
{
	RA      17.87638889
	Dec     -30.0877778
	Dist    1510
	AppMagn 17.17
	MassSol 0.51
}

Star	"OGLE-2007-BLG-368L"
{
	RA      17.94054447
	Dec     -32.237417
	Dist    5900
	AppMagn 17.71
	MassSol 0.64
}

Star	"OGLE-2008-BLG-092L"
{
	RA      17.79150593
	Dec     -34.726555
	Dist    8100
	AppMagn 13.9
	MassSol 0.71
}

Star	"OGLE-2008-BLG-355L"
{
	RA      17.98578056
	Dec     -29.24052776
	Dist    6800
	Class  "M"
	MassSol 0.37
}

Star	"OGLE-2011-BLG-251L"
{
	RA      17.63727222
	Dec     -27.13613889
	Dist    4090
	Class  "M"
	MassSol 0.47
}

Star	"OGLE-2011-BLG-265L"
{
	RA      17.96333333
	Dec     -27.39444446
	Dist    4380
	MassSol 0.211
}

Star	"OGLE-2011-BLG-420L"
{
	RA      17.84888667
	Dec     -29.825
	Dist    1990
	AppMagn 14.7
	MassSol 0.025
}

Star	"OGLE-2012-BLG-026L"
{
	RA      17.57186073
	Dec     -27.14275
	Dist    4080
	Class  "G5V"
	MassSol 0.82
}

Star	"OGLE-2012-BLG-358L"
{
	RA      17.71299233
	Dec     -24.261
	Dist    1760
	MassSol 0.02
}

Star	"OGLE-2012-BLG-406L"
{
	RA      17.88838093
	Dec     -30.471167
	Dist    4970
	MassSol 0.44
}

Star	"OGLE-2012-BLG-563L"
{
	RA      18.09936727
	Dec     -27.712
	Dist    1300
	MassSol 0.34
	Teff    5907
	FeH    -0.66
}

Star	"OGLE-2012-BLG-724L"
{
	RA      17.93121947
	Dec     -29.818528
	Dist    6700
	Class  "M"
	MassSol 0.29
}

Star	"OGLE-2013-BLG-102L"
{
	RA      17.868634
	Dec     -31.690584
	Dist    3040
	AppMagn 17
	MassSol 0.1
}

Star	"OGLE-2013-BLG-341L"
{
	RA      17.86874793
	Dec     -29.846111
	Dist    1161
	MassSol 0.15
}

Star	"OGLE-2013-BLG-723LB"
{
	RA      17.57805556
	Dec     -27.44805558
	Dist    490
	MassSol 0.031
}

Star	"OGLE-2014-BLG-124L"
{
	RA      18.04144693
	Dec     -28.39625
	Dist    4100
	MassSol 0.71
}

Star	"OGLE-2014-BLG-1760L"
{
	RA      17.96055556
	Dec     -28.96305558
	Dist    6060
	MassSol 0.51
}

Star	"OGLE-2014-BLG-257L"
{
	RA      18.03
	Dec     -28.26194446
	Dist    1250
	Class  "M"
	MassSol 0.19
}

Star	"OGLE-2015-BLG-954L"
{
	RA      18.01222222
	Dec     -28.66083336
	Dist    600
	MassSol 0.37
}

Star	"OGLE-2015-BLG-966L"
{
	RA      17.91695
	Dec     -29.047111
	Dist    2500
	Class  "M"
	MassSol 0.38
}

Star	"OGLE-TR-10"
{
	RA      17.85777778
	Dec     -29.8761111
	Dist    1500
	AppMagn 14.93
	Class  "G"
	MassSol 1.18
	RadSol  1.16
	Teff    6075
	FeH     0.28
	Age     1.1
}

Star	"OGLE-TR-111"
{
	RA      10.88833333
	Dec     -61.4055556
	Dist    1500
	AppMagn 15.55
	Class  "G"
	MassSol 0.82
	RadSol  0.831
	Teff    5070
	FeH     0.12
	Age     1.1
}

Star	"OGLE-TR-113"
{
	RA      10.87333333
	Dec     -61.4466667
	Dist    1500
	AppMagn 14.42
	Class  "K"
	MassSol 0.78
	RadSol  0.765
	Teff    4752
	FeH     0.14
	Age     0.7
}

Star	"OGLE-TR-132"
{
	RA      10.8429778
	Dec     -61.957194
	Dist    2500
	AppMagn 15.72
	Class  "F5V"
	MassSol 1.3
	RadSol  1.32
	Teff    6210
	FeH     0.37
}

Star	"OGLE-TR-182"
{
	RA      11.15519713
	Dec     -61.095257
	AppMagn 16.84
	MassSol 1.14
	RadSol  1.14
	Teff    5924
	FeH     0.37
}

Star	"OGLE-TR-211"
{
	RA      10.67066347
	Dec     -62.455601
	AppMagn 14.3
	MassSol 1.33
	RadSol  1.64
	Teff    6325
	FeH     0.11
}

Star	"OGLE-TR-56"
{
	RA      17.94305555
	Dec     -29.5391667
	Dist    1500
	AppMagn 16.6
	Class  "G"
	MassSol 1.17
	RadSol  1.32
	Teff    6050
	Age     2
}

Star	"OGLE2-TR-L9"
{
	RA      11.1319946
	Dec     -61.146263
	Dist    900
	AppMagn 13.97
	Class  "F3"
	MassSol 1.52
	RadSol  1.53
	Teff    6933
	FeH    -0.05
	Age     0.66
}

Star	"OME Ser/HD 141680/HIP 77578"
{
	RA      15.83833333
	Dec     2.1964
	Dist    80.6
	AppMagn 5.21
	Class  "G8III"
	MassSol 2.17
	RadSol  12.3
	Teff    4770
	FeH    -0.24
}

Star	"OMI CrB/HD 136512/HIP 75049"
{
	RA      15.33571067
	Dec     29.616209
	Dist    84.03
	AppMagn 5.51
	Class  "K0"
	MassSol 2.13
	RadSol  10.5
	Teff    4749
	FeH    -0.29
}

Star	"OMI UMa/HD 71369/HIP 41704"
{
	RA      8.504408267
	Dec     60.71817
	Dist    56.31
	AppMagn 3.36
	Class  "G5III"
	MassSol 3.09
	RadSol  14.1
	Teff    5242
	FeH    -0.09
}

Star	"OY Car"
{
	RA      10.10611111
	Dec     -70.23472223
	AppMagn 12.2
	Class  "M5"
}

Star	"Ogma/HD 149026/HIP 80838"
{
	RA      16.50805555
	Dec     38.3472222
	Dist    78.9
	AppMagn 8.15
	Class  "G0IV"
	MassSol 1.3
	RadSol  1.497
	Teff    6147
	FeH     0.36
	Age     2
}

Star	"POTS-1"
{
	RA      13.57388667
	Dec     -66.5811
	Dist    1200
	AppMagn 17.94
	Class  "K5"
	MassSol 0.695
	RadSol  0.59
	Teff    4400
	FeH    -0.03
}

Star	"PSI Dra B/HD 162004/HIP 86620"
{
	RA      17.69947307
	Dec     72.156914
	Dist    22.16
	AppMagn 5.699
	Class  "G0V"
	MassSol 1.19
	Teff    6212
	FeH     0.01
	Age     3.3
}

Star	"PSR B1957+20"
{
	RA      19.99361111
	Dec     20.80416669
	Dist    1530
	Class  "Q"
	MassSol 1.4
	Age     2.2
}

Star	"PSR J1807-2459 A"
{
	RA      10.12222222
	Dec     -24.99805559
	Dist    2790
	Class  "Q"
	MassSol 1.4
}

Star	"PSR J2051-0827"
{
	RA      20.85222222
	Dec     -8.460555573
	Dist    1280
	Class  "Q"
	MassSol 1.4
	Age     5.61
}

Star	"PSR J2241-5236"
{
	RA      22.695
	Dec     -52.61000002
	Dist    500
	Class  "Q"
	MassSol 1.35
	Age     5.22
}

Star	"PZ Tel"
{
	RA      18.885
	Dec     -50.1805556
	Dist    51.49
	AppMagn 8.43
	Class  "G6.5"
	MassSol 1.13
	RadSol  1.23
	Teff    5338
	FeH     0.05
	Age     0.023
}

Star	"Pollux/BET Gem/HD 62509/HIP 37826"
{
	RA      7.755
	Dec     28.0261111
	Dist    10.34
	AppMagn 1.15
	Class  "K0IIIb"
	MassSol 1.47
	RadSol  9.3
	Teff    4666
	FeH     0.19
}

Star	"Pr 0201"
{
	RA      8.695553333
	Dec     20.2269
	Dist    170
	AppMagn 10.33
	Class  "F7"
	MassSol 1.234
	RadSol  1.167
	Teff    6174
	FeH     0.187
	Age     0.578
}

Star	"Pr 0211"
{
	RA      8.703055556
	Dec     19.27694446
	Dist    170
	AppMagn 12.15
	Class  "G9"
	MassSol 0.935
	RadSol  0.827
	Teff    5300
	FeH     0.18
	Age     0.79
}

Star	"Qatar-1"
{
	RA      20.22544553
	Dec     65.162041
	AppMagn 12.843
	Class  "K"
	MassSol 0.8
	RadSol  0.78
	Teff    4861
	FeH     0.2
	Age     4
}

Star	"Qatar-2"
{
	RA      13.8437246
	Dec     -6.804028
	AppMagn 13.3
	Class  "K"
	MassSol 0.74
	RadSol  0.78
	Teff    4645
	FeH     0.02
}

Star	"RHO CrB/HD 143761/HIP 78459"
{
	RA      16.0174062
	Dec     33.303509
	Dist    17.43
	AppMagn 5.4
	Class  "G0V"
	MassSol 1
	RadSol  1.31
	Teff    5777
	FeH    -0.19
}

Star	"ROXs 12"
{
	RA      16.44104107
	Dec     -25.456865
	Dist    120
	AppMagn 15.595
	Class  "M0"
	MassSol 0.87
	Teff    3850
	Age     0.0076
}

Star	"Ran/EPS Eri/HD 22049/HIP 16537"
{
	RA      3.548845667
	Dec     -9.458262
	Dist    3.21
	AppMagn 3.82
	Class  "K2V"
	MassSol 0.83
	RadSol  0.895
	Teff    5116
	FeH    -0.13
	Age     0.66
}

Star	"SIG Per"
{
	RA      3.509722223
	Dec     47.99527781
	Dist    108.3
	AppMagn 4.36
	Class  "K3III"
	MassSol 2.25
	RadSol  28
	Teff    4367
	FeH    -0.22
}

Star	"SWEEPS-04"
{
	RA      17.98164447
	Dec     -29.189056
	Dist    8500
	AppMagn 18.8
	MassSol 1.24
	RadSol  1.18
}

Star	"SWEEPS-11"
{
	RA      17.98388887
	Dec     -29.198194
	Dist    8500
	AppMagn 19.83
	MassSol 1.1
	RadSol  1.45
}

Star	"TAU Gem/HD 54719/HIP 34693"
{
	RA      7.185555553
	Dec     30.2452778
	Dist    98.4
	AppMagn 4.4
	Class  "K2III"
	MassSol 2.3
	RadSol  26.8
	Teff    4388
	FeH     0.14
	Age     1.22
}

Star	"TRAPPIST-1/2MASSW 23062-05022"
{
	RA      23.1081342
	Dec     -5.041274
	Dist    12.1
	AppMagn 18.8
	Class  "M8"
	MassSol 0.08
	RadSol  0.12
	Teff    2550
	FeH     0.04
	Age     0.5
}

StarBarycenter	"TWA 5"
{
	RA      11.53194445
	Dec     -34.6075
	Dist    25
	AppMagn 12.12
	Class  "M1.5"
	MassSol 0.4
	Age     0.1
}

Star	"TYC 1422-614-1"
{
	RA      10.2851868
	Dec     19.558472
	Dist    759
	AppMagn 10.21
	MassSol 1.15
	RadSol  6.85
	Teff    4806
	FeH    -0.2
}

Star	"TYC 3550-458-1/Kepler-63/KOI-63/KIC 11554435"
{
	RA      19.28166667
	Dec     49.54819722
	Dist    200
	AppMagn 12.02
	MassSol 0.984
	RadSol  0.901
	Teff    5576
	FeH     0.05
}

Star	"TYC 3667-1280-1"
{
	RA      0.8591562667
	Dec     58.426167
	Dist    481
	AppMagn 9.86
	MassSol 1.87
	RadSol  6.26
	Teff    5130
	FeH    -0.08
}

Star	"TYC-3667-1280-1"
{
	RA      5.225000001
	Dec     58.42611113
	Dist    431
	AppMagn 9.9
	MassSol 1.87
	RadSol  6.26
	Teff    5130
	FeH    -0.08
}

Star	"Tonatiuh/HD 104985/HIP 58952"
{
	RA      12.0875
	Dec     76.9055556
	Dist    102
	AppMagn 5.79
	Class  "G9III"
	MassSol 1.6
	RadSol  10.87
	Teff    4786
	FeH    -0.35
	Age     2.95
}

Star	"TrES-1"
{
	RA      19.06916667
	Dec     36.6325
	Dist    157
	AppMagn 11.79
	Class  "K0V"
	MassSol 0.88
	RadSol  0.85
	Teff    5230
	FeH     0.001
	Age     2.5
}

Star	"TrES-3"
{
	RA      17.86861111
	Dec     37.5461111
	Dist    228
	AppMagn 12.4
	Class  "G"
	MassSol 0.924
	RadSol  0.813
	Teff    5720
	FeH    -0.19
}

Star	"TrES-4"
{
	RA      17.88695693
	Dec     37.211849
	Dist    492
	AppMagn 11.592
	Class  "F8V"
	MassSol 1.45
	RadSol  1.81
	Teff    6295
	FeH     0.28
	Age     2.9
}

Star	"TrES-5"
{
	RA      20.34812213
	Dec     59.448788
	Dist    360
	AppMagn 13.718
	MassSol 0.9
	RadSol  0.87
	Teff    5171
	FeH     0.2
	Age     7.38
}

Star	"USco1602-2401"
{
	RA      16.0475
	Dec     -24.030666
	AppMagn 12.5
	Class  "K4"
	Teff    4550
}

Star	"USco1610-1913"
{
	RA      16.17555333
	Dec     -19.219055
	AppMagn 13.9
	Class  "K7"
	Teff    4140
}

Star	"USco1612-1800"
{
	RA      16.21361333
	Dec     -18.01375
	AppMagn 13.2
	Class  "M3"
	Teff    3410
}

Star	"UScoCTIO 108/USco CTIO 108"
{
	RA      16.09835513
	Dec     -18.312332
	Dist    145
	AppMagn 15.65
	Class  "M7"
	MassSol 0.06
	Teff    2700
	Age     0.011
}

StarBarycenter	"UZ For"
{
	RA      3.591388887
	Dec     -25.7394444
	AppMagn 18.2
	Class  "DA1"
	MassSol 0.84
}

Star	"V391 Peg/V0391 Peg"
{
	RA      22.07002933
	Dec     26.41886
	Dist    1400
	AppMagn 14.57
	Class  "B1VI"
	MassSol 0.5
	RadSol  0.23
	Teff    29300
	Age     10
}

Star	"VHS J125601.92-125723.9/VHS 1256-1257"
{
	RA      12.93393047
	Dec     -12.956031
	Dist    12.7
	AppMagn 17.759
	Class  "M7.5"
	MassSol 0.07
	Teff    2620
	Age     0.2
}

Star	"Veritate/14 And/HD 221345/HIP 116076"
{
	RA      23.52150473
	Dec     39.236198
	Dist    76.39
	AppMagn 5.22
	Class  "G8III"
	MassSol 2.2
	RadSol  11
	Teff    4813
	FeH    -0.24
}

Star	"WASP-1"
{
	RA      0.3444444467
	Dec     31.99
	Dist    408
	AppMagn 11.79
	Class  "F7V"
	MassSol 1.24
	RadSol  1.382
	Teff    6200
}

Star	"WASP-10"
{
	RA      23.26611111
	Dec     31.4627778
	Dist    90
	AppMagn 12.7
	Class  "K5"
	MassSol 0.71
	RadSol  0.783
	Teff    4675
	FeH     0.03
	Age     0.8
}

Star	"WASP-100"
{
	RA      4.59722
	Dec     -64.0269
	AppMagn 10.8
	Class  "F2"
	MassSol 1.57
	RadSol  2
	Teff    6900
	FeH    -0.03
}

Star	"WASP-101"
{
	RA      6.556740333
	Dec     -23.48621
	AppMagn 10.3
	Class  "F6"
	MassSol 1.34
	RadSol  1.29
	Teff    6400
	FeH     0.2
	Age     0.9
}

Star	"WASP-103"
{
	RA      16.62111111
	Dec     7.183333337
	Dist    470
	AppMagn 12
	Class  "F8V"
	MassSol 1.22
	RadSol  1.436
	Teff    6110
	FeH     0.06
	Age     4
}

Star	"WASP-104"
{
	RA      10.70683611
	Dec     7.435083343
	Dist    143
	AppMagn 11.12
	Class  "G8"
	MassSol 1.02
	RadSol  0.93
	Teff    5450
	FeH     0.32
}

Star	"WASP-106"
{
	RA      11.09531389
	Dec     -5.079416678
	Dist    283
	AppMagn 11.21
	Class  "F9"
	MassSol 1.27
	RadSol  1.85
	Teff    6000
	FeH    -0.09
}

Star	"WASP-108"
{
	RA      13.05527778
	Dec     -49.63972224
	Dist    220
	AppMagn 11.2
	Class  "F9"
	MassSol 1.167
	RadSol  1.215
	Teff    6000
	FeH     0.05
	Age     4.6
}

Star	"WASP-109"
{
	RA      15.47027778
	Dec     -16.41083335
	Dist    330
	AppMagn 11.4
	Class  "F4"
	MassSol 1.203
	RadSol  1.346
	Teff    6520
	FeH    -0.22
	Age     2.6
}

Star	"WASP-110"
{
	RA      20.39166667
	Dec     -44.05833334
	Dist    320
	AppMagn 12.3
	Class  "G9"
	MassSol 0.892
	RadSol  0.881
	Teff    5400
	FeH    -0.06
	Age     8.6
}

Star	"WASP-111"
{
	RA      21.91777778
	Dec     -22.61250002
	Dist    210
	AppMagn 10.3
	Class  "F5"
	MassSol 1.5
	RadSol  1.85
	Teff    6400
	FeH     0.08
	Age     2.6
}

Star	"WASP-112"
{
	RA      22.6325
	Dec     -35.1538889
	Dist    450
	AppMagn 13.3
	Class  "G6"
	MassSol 0.807
	RadSol  1.002
	Teff    5610
	FeH    -0.64
	Age     10.6
}

Star	"WASP-117"
{
	RA      2.451695533
	Dec     -50.284519
	AppMagn 10.15
	Class  "F9"
	MassSol 1.13
	RadSol  1.17
	Teff    6038
	FeH    -0.11
	Age     4.6
}

Star	"WASP-119"
{
	RA      3.728896067
	Dec     -65.193855
	Dist    333
	AppMagn 12.2
	Class  "G5"
	MassSol 1.02
	RadSol  1.2
	Teff    5650
	FeH     0.14
	Age     8
}

Star	"WASP-12"
{
	RA      6.509166667
	Dec     29.6722222
	Dist    427
	AppMagn 11.69
	Class  "G0"
	MassSol 1.35
	RadSol  1.599
	Teff    6300
	FeH     0.3
	Age     1.7
}

Star	"WASP-120"
{
	RA      4.174444445
	Dec     -45.89833336
	AppMagn 11
	Class  "F5"
	MassSol 1.45
	RadSol  1.93
	Teff    6450
	FeH    -0.05
}

Star	"WASP-121"
{
	RA      7.173333334
	Dec     -39.09750001
	Dist    270
	AppMagn 10.4
	Class  "F6V"
	MassSol 1.353
	RadSol  1.458
	Teff    6460
	FeH     0.13
}

Star	"WASP-123"
{
	RA      19.29861111
	Dec     -32.86000002
	AppMagn 11.1
	Class  "G5"
	MassSol 1.207
	RadSol  1.296
	Teff    5730
	FeH     0.18
}

Star	"WASP-124"
{
	RA      22.18095487
	Dec     -30.749672
	Dist    433
	AppMagn 12.7
	Class  "F9"
	MassSol 1.07
	RadSol  1.02
	Teff    6050
	FeH    -0.02
	Age     2.1
}

Star	"WASP-126"
{
	RA      4.224924333
	Dec     -69.226807
	Dist    234
	AppMagn 10.8
	Class  "G2"
	MassSol 1.12
	RadSol  1.27
	Teff    5800
	FeH     0.17
	Age     6.4
}

Star	"WASP-129"
{
	RA      11.75326433
	Dec     -42.063927
	Dist    246
	AppMagn 12.3
	Class  "G1"
	MassSol 1
	RadSol  0.9
	Teff    5900
	FeH     0.15
	Age     1
}

Star	"WASP-13"
{
	RA      9.34027778
	Dec     33.8825
	Dist    156
	AppMagn 10.42
	Class  "G1V"
	MassSol 1.09
	RadSol  1.56
	Teff    5826
	FeH     0
}

Star	"WASP-133"
{
	RA      20.97169153
	Dec     -35.796555
	Dist    547
	AppMagn 12.9
	Class  "G4"
	MassSol 1.16
	RadSol  1.44
	Teff    5700
	FeH     0.29
	Age     6.8
}

Star	"WASP-135"
{
	RA      17.81899827
	Dec     29.879107
	Dist    300
	AppMagn 13.28
	Class  "G5V"
	MassSol 0.98
	RadSol  0.96
	Teff    5675
	FeH     0.02
	Age     4.4
}

Star	"WASP-14"
{
	RA      14.55166667
	Dec     21.8947222
	Dist    160
	AppMagn 9.75
	Class  "F5V"
	MassSol 1.211
	RadSol  1.306
	Teff    6475
	FeH     0
	Age     0.75
}

Star	"WASP-15"
{
	RA      13.92861111
	Dec     -32.1597222
	Dist    308
	AppMagn 10.9
	Class  "F7"
	MassSol 1.18
	RadSol  1.477
	Teff    6300
	FeH    -0.17
	Age     3.9
}

Star	"WASP-157"
{
	RA      13.44361111
	Dec     -8.317500007
	AppMagn 12.9
	Class  "G2V"
	MassSol 1.26
	RadSol  1.11
	Teff    5840
	FeH     0.34
	Age     1
}

Star	"WASP-16"
{
	RA      14.31222222
	Dec     -20.2755556
	AppMagn 11.3
	Class  "G3V"
	MassSol 1.022
	RadSol  0.946
	Teff    5550
	FeH     0.01
	Age     2.3
}

Star	"WASP-17"
{
	RA      15.9975
	Dec     -28.0616667
	Dist    400
	AppMagn 11.6
	Class  "F4"
	MassSol 1.2
	RadSol  1.38
	Teff    6650
	FeH    -0.19
	Age     3
}

Star	"WASP-19"
{
	RA      9.894444447
	Dec     -45.6591667
	Dist    250
	AppMagn 12.3
	Class  "G8V"
	MassSol 0.904
	RadSol  1.004
	Teff    5500
	FeH     0.02
	Age     11.5
}

Star	"WASP-2"
{
	RA      20.515
	Dec     6.4294444
	Dist    144
	AppMagn 11.98
	Class  "K1V"
	MassSol 0.84
	RadSol  0.834
	Teff    5150
	FeH    -0.08
}

Star	"WASP-20"
{
	RA      0.3440372667
	Dec     -23.935728
	Dist    210
	AppMagn 10.68
	Class  "F9"
	MassSol 1.2
	RadSol  1.39
	Teff    5940
	FeH    -0.008
	Age     7
}

Star	"WASP-21"
{
	RA      23.16611111
	Dec     18.3961111
	Dist    230
	AppMagn 11.6
	Class  "G3V"
	MassSol 1.01
	RadSol  1.06
	Teff    5800
	FeH    -0.4
}

Star	"WASP-22"
{
	RA      3.521202867
	Dec     -23.819702
	Dist    300
	AppMagn 12
	MassSol 1.25
	RadSol  1.25
	Teff    6153
	FeH     0.26
}

Star	"WASP-23"
{
	RA      6.741944447
	Dec     -42.7619444
	AppMagn 12.7
	Class  "K1V"
	MassSol 0.78
	RadSol  0.765
	Teff    5150
}

Star	"WASP-24"
{
	RA      15.14777778
	Dec     2.3433333
	Dist    330
	AppMagn 11.3
	Class  "F8"
	MassSol 1.129
	RadSol  1.147
	Teff    6075
	FeH     0.07
	Age     1.6
}

Star	"WASP-25"
{
	RA      13.02388889
	Dec     -27.5222222
	Dist    169
	AppMagn 11.9
	Class  "G4"
	MassSol 1
	RadSol  0.95
	Teff    5750
	FeH    -0.05
}

Star	"WASP-26"
{
	RA      0.3069444467
	Dec     -15.2672222
	Dist    250
	AppMagn 11.3
	Class  "G0"
	MassSol 1.12
	RadSol  1.34
	Teff    5950
	FeH    -0.02
	Age     6
}

Star	"WASP-28"
{
	RA      23.57441
	Dec     -1.580064
	Dist    410
	AppMagn 12.03
	Class  "F8"
	MassSol 1.02
	RadSol  1.09
	Teff    6150
	FeH    -0.29
	Age     5
}

Star	"WASP-29"
{
	RA      23.85861111
	Dec     -39.9066667
	Dist    80
	AppMagn 11.3
	Class  "K4V"
	MassSol 0.825
	RadSol  0.846
	Teff    4800
	FeH     0.11
	Age     15
}

Star	"WASP-3"
{
	RA      18.57545367
	Dec     35.661533
	Dist    220
	AppMagn 10.5
	Class  "F7V"
	MassSol 1.24
	RadSol  1.31
	Teff    6400
	FeH     0
}

Star	"WASP-31"
{
	RA      11.29583333
	Dec     -19.0547222
	Dist    400
	AppMagn 11.7
	Class  "F"
	MassSol 1.16
	RadSol  1.24
	Teff    6200
	FeH    -0.19
}

Star	"WASP-32"
{
	RA      0.2641121333
	Dec     1.200451
	AppMagn 11.3
	Class  "G"
	MassSol 1.1
	RadSol  1.11
	Teff    6100
	FeH    -0.13
}

Star	"WASP-34"
{
	RA      11.0266378
	Dec     -23.860636
	Dist    120
	AppMagn 10.4
	Class  "G5"
	MassSol 1.01
	RadSol  0.93
	Teff    5700
	FeH    -0.02
}

Star	"WASP-35"
{
	RA      5.0721186
	Dec     -6.229821
	AppMagn 11.01
	MassSol 1.07
	RadSol  1.09
	Teff    5990
}

Star	"WASP-36"
{
	RA      8.772027
	Dec     -8.026946
	Dist    450
	AppMagn 12.7
	Class  "G2"
	MassSol 1.08
	RadSol  0.98
	Teff    5959
	FeH    -0.26
	Age     3
}

Star	"WASP-37"
{
	RA      14.79638889
	Dec     1.065
	Dist    338
	AppMagn 12.7
	Class  "G2"
	MassSol 0.849
	RadSol  0.977
	Teff    5800
	FeH    -0.4
	Age     11
}

Star	"WASP-39"
{
	RA      14.48844707
	Dec     -3.444534
	Dist    230
	AppMagn 12.11
	Class  "G8"
	MassSol 0.93
	RadSol  0.9
	Teff    5400
	FeH    -0.12
}

Star	"WASP-4"
{
	RA      23.57085573
	Dec     -42.061428
	Dist    300
	AppMagn 12.5
	Class  "G7V"
	MassSol 0.89
	RadSol  0.92
	Teff    5436
	FeH    -0.05
}

Star	"WASP-41"
{
	RA      12.70791527
	Dec     -30.63987
	Dist    180
	AppMagn 11.6
	Class  "G8V"
	MassSol 0.93
	RadSol  0.87
	Teff    5545
	FeH     0.06
}

Star	"WASP-42"
{
	RA      12.86543633
	Dec     -42.073608
	Dist    160
	AppMagn 12.57
	MassSol 0.95
	RadSol  0.89
	Teff    5315
	FeH     0.29
}

Star	"WASP-43"
{
	RA      10.32722222
	Dec     -9.8063889
	Dist    80
	AppMagn 12.4
	Class  "K7V"
	MassSol 0.717
	RadSol  0.667
	Teff    4520
	FeH    -0.01
	Age     0.4
}

Star	"WASP-44"
{
	RA      0.260211
	Dec     -11.938115
	AppMagn 12.9
	Class  "G8V"
	MassSol 0.95
	RadSol  0.93
	Teff    5410
	FeH     0.06
	Age     0.9
}

Star	"WASP-45"
{
	RA      0.3491664667
	Dec     -35.99826
	AppMagn 12
	Class  "K2V"
	MassSol 0.9
	RadSol  0.92
	Teff    5100
	FeH     0.5
	Age     1.4
}

Star	"WASP-46"
{
	RA      21.24913207
	Dec     -55.87178
	AppMagn 12.9
	Class  "G6V"
	MassSol 0.83
	RadSol  0.86
	Teff    5600
	FeH    -0.3
	Age     1.4
}

Star	"WASP-47"
{
	RA      22.0802022
	Dec     -12.018885
	Dist    200
	AppMagn 11.9
	Class  "G9V"
	MassSol 1.04
	RadSol  1.15
	Teff    5576
	FeH     0.36
}

Star	"WASP-48"
{
	RA      19.41082153
	Dec     55.47316
	AppMagn 11.72
	MassSol 1.06
	RadSol  1.52
	Teff    6000
	FeH    -0.12
}

Star	"WASP-49"
{
	RA      6.072628267
	Dec     -16.965294
	Dist    170
	AppMagn 11.36
	MassSol 0.94
	RadSol  0.98
	Teff    5600
}

Star	"WASP-5"
{
	RA      23.95666667
	Dec     -41.2772222
	Dist    297
	AppMagn 12.26
	Class  "G5"
	MassSol 1
	RadSol  1.084
	Teff    5700
	FeH     0.09
	Age     3
}

Star	"WASP-50"
{
	RA      2.9125
	Dec     -10.8980556
	Dist    230
	AppMagn 11.6
	Class  "G9"
	MassSol 0.861
	RadSol  0.855
	Teff    5400
	FeH    -0.12
	Age     8.1
}

Star	"WASP-52"
{
	RA      23.2329834
	Dec     8.761262
	Dist    140
	AppMagn 12
	Class  "K2V"
	MassSol 0.87
	RadSol  0.79
	Teff    5000
	FeH     0.03
	Age     0.4
}

Star	"WASP-54"
{
	RA      13.69695433
	Dec     -0.128076
	Dist    200
	AppMagn 10.42
	Class  "F9"
	MassSol 1.21
	RadSol  1.83
	Teff    6100
	FeH    -0.27
}

Star	"WASP-55"
{
	RA      13.58387427
	Dec     -17.503464
	Dist    330
	AppMagn 11.8
	Class  "G1"
	MassSol 1.16
	RadSol  1.1
	Teff    6070
	FeH     0.09
	Age     3
}

Star	"WASP-56"
{
	RA      12.22441913
	Dec     23.055698
	Dist    255
	AppMagn 11.484
	Class  "G6"
	MassSol 1.02
	RadSol  1.11
	Teff    5600
	FeH     0.12
}

Star	"WASP-57"
{
	RA      14.92133993
	Dec     -2.057665
	Dist    455
	AppMagn 13.04
	Class  "G6"
	MassSol 0.89
	RadSol  0.93
	Teff    5600
	FeH    -0.25
}

Star	"WASP-58"
{
	RA      18.31340333
	Dec     45.172016
	Dist    300
	AppMagn 11.66
	Class  "G2V"
	MassSol 0.94
	RadSol  1.17
	Teff    5800
	FeH    -0.45
	Age     3.2
}

Star	"WASP-59"
{
	RA      23.3082092
	Dec     24.88929
	Dist    125
	AppMagn 13
	Class  "K5V"
	MassSol 0.72
	RadSol  0.61
	Teff    4650
	FeH    -0.15
	Age     0.5
}

Star	"WASP-6"
{
	RA      23.2104838
	Dec     -22.673937
	Dist    307
	AppMagn 11.9
	Class  "G8"
	MassSol 0.84
	RadSol  0.86
	Teff    5375
	FeH    -0.15
	Age     11
}

Star	"WASP-60"
{
	RA      23.777771
	Dec     31.155935
	Dist    400
	AppMagn 12.18
	Class  "G1V"
	MassSol 1.08
	RadSol  1.14
	Teff    5900
	FeH    -0.04
	Age     3.6
}

Star	"WASP-61"
{
	RA      5.019977333
	Dec     -26.054144
	Dist    480
	AppMagn 12.5
	Class  "F7"
	MassSol 1.22
	RadSol  1.36
	Teff    6320
	FeH    -0.1
}

Star	"WASP-62"
{
	RA      5.809330733
	Dec     -63.988434
	Dist    160
	AppMagn 10.3
	Class  "F7"
	MassSol 1.25
	RadSol  1.28
	Teff    6280
	FeH     0.04
}

Star	"WASP-63"
{
	RA      6.289095533
	Dec     -38.323257
	Dist    330
	AppMagn 11.2
	Class  "G8"
	MassSol 1.32
	RadSol  1.88
	Teff    5570
	FeH     0.08
}

Star	"WASP-64"
{
	RA      6.741002933
	Dec     -32.858402
	Dist    350
	AppMagn 12.29
	Class  "G7"
	MassSol 1
	RadSol  1.06
	Teff    5400
	FeH    -0.08
}

Star	"WASP-65"
{
	RA      8.888287333
	Dec     8.523038
	Dist    310
	AppMagn 11.9
	Class  "G6"
	MassSol 0.93
	RadSol  1.01
	Teff    5600
	FeH    -0.07
}

Star	"WASP-66"
{
	RA      10.54833333
	Dec     -34.9897222
	Dist    380
	AppMagn 11.6
	Class  "F4"
	MassSol 1.3
	RadSol  1.75
	Teff    6600
	FeH    -0.31
}

Star	"WASP-67"
{
	RA      19.71625567
	Dec     -19.949596
	Dist    225
	AppMagn 12.5
	Class  "K0V"
	MassSol 0.87
	RadSol  0.87
	Teff    5240
	FeH    -0.07
}

Star	"WASP-69"
{
	RA      21.00166667
	Dec     -5.094444455
	Dist    50
	AppMagn 9.87
	Class  "K5"
	MassSol 0.826
	RadSol  0.813
	Teff    4715
	FeH     0.144
	Age     2
}

Star	"WASP-71"
{
	RA      1.9508892
	Dec     0.758834
	Dist    345
	AppMagn 10.56
	Class  "F8"
	MassSol 1.56
	RadSol  2.26
	Teff    6059
	FeH     0.14
}

Star	"WASP-72"
{
	RA      2.736113333
	Dec     -30.16920556
	Dist    340
	AppMagn 9.6
	Class  "F7"
	MassSol 1.386
	RadSol  1.98
	Teff    6250
	FeH    -0.06
}

Star	"WASP-74"
{
	RA      20.30258787
	Dec     -1.075676
	Dist    120
	AppMagn 9.7
	Class  "F9"
	MassSol 1.48
	RadSol  1.64
	Teff    5970
	FeH     0.39
	Age     2
}

Star	"WASP-75"
{
	RA      22.82583333
	Dec     -10.6755
	Dist    260
	AppMagn 11.45
	Class  "F9"
	MassSol 1.14
	RadSol  1.26
	Teff    6100
	FeH     0.07
}

Star	"WASP-76"
{
	RA      1.7755164
	Dec     2.700539
	Dist    120
	AppMagn 9.5
	Class  "F7"
	MassSol 1.46
	RadSol  1.73
	Teff    6250
	FeH     0.23
}

Star	"WASP-78"
{
	RA      4.250416067
	Dec     -22.116434
	Dist    550
	AppMagn 12
	Class  "F8"
	MassSol 1.17
	RadSol  1.6
	Teff    6100
	FeH    -0.35
}

Star	"WASP-79"
{
	RA      4.42472222
	Dec     -30.6005556
	Dist    240
	AppMagn 10.1
	Class  "F3"
	MassSol 1.56
	RadSol  1.64
	Teff    6600
	FeH     0.03
}

Star	"WASP-8"
{
	RA      23.99333333
	Dec     -35.0313889
	Dist    87
	AppMagn 9.9
	Class  "G6"
	MassSol 1.033
	RadSol  0.953
	Teff    5600
	FeH     0.17
	Age     4
}

Star	"WASP-80"
{
	RA      20.21116127
	Dec     -2.144208
	Dist    60
	AppMagn 11.87
	Class  "K7V"
	MassSol 0.58
	RadSol  0.59
	Teff    4143
	FeH    -0.13
}

Star	"WASP-82"
{
	RA      4.844044733
	Dec     1.893921
	Dist    200
	AppMagn 10.1
	Class  "F5"
	MassSol 1.63
	RadSol  2.18
	Teff    6490
	FeH     0.12
}

Star	"WASP-83"
{
	RA      12.67694445
	Dec     -19.28416667
	Dist    300
	AppMagn 12.9
	Class  "G8"
	MassSol 1.11
	RadSol  1.05
	Teff    5480
	FeH     0.29
	Age     5
}

Star	"WASP-84"
{
	RA      8.740553333
	Dec     1.8433
	Dist    120
	AppMagn 10.83
	Class  "K0"
	MassSol 0.842
	RadSol  0.748
	Teff    5314
	FeH     0
	Age     1
}

Star	"WASP-85"
{
	RA      11.72722222
	Dec     6.563611133
	AppMagn 11.2
	Class  "G8"
	MassSol 1.09
	RadSol  0.935
	Teff    6112
}

Star	"WASP-88"
{
	RA      20.63416667
	Dec     -47.53805554
	AppMagn 10.4
	Class  "F6"
	MassSol 1.45
	RadSol  2.08
	Teff    6431
	FeH    -0.008
}

Star	"WASP-89"
{
	RA      20.9266642
	Dec     -18.971106
	AppMagn 13.1
	Class  "K3"
	MassSol 0.92
	RadSol  0.88
	Teff    5130
	FeH     0.15
	Age     1.3
}

Star	"WASP-90"
{
	RA      21.03546473
	Dec     7.056235
	Dist    340
	AppMagn 11.7
	Class  "F6"
	MassSol 1.55
	RadSol  1.98
	Teff    6430
	FeH     0.11
}

Star	"WASP-95"
{
	RA      22.49722
	Dec     -48.0031
	AppMagn 10.1
	Class  "G2"
	MassSol 1.11
	RadSol  1.13
	Teff    5630
	FeH     0.14
	Age     2.4
}

Star	"WASP-96"
{
	RA      0.06975673333
	Dec     -47.360626
	AppMagn 12.2
	Class  "G8"
	MassSol 1.06
	RadSol  1.05
	Teff    5540
	FeH     0.14
	Age     8
}

Star	"WASP-97"
{
	RA      1.64028
	Dec     -55.7719
	AppMagn 10.6
	Class  "G5"
	MassSol 1.12
	RadSol  1.06
	Teff    5640
	FeH     0.23
	Age     11.9
}

Star	"WASP-98"
{
	RA      3.895253
	Dec     -34.328194
	AppMagn 13
	Class  "G7"
	MassSol 0.69
	RadSol  0.7
	Teff    5525
	FeH    -0.6
	Age     3
}

Star	"WASP-99"
{
	RA      2.65972
	Dec     -50.0081
	AppMagn 9.5
	Class  "F8"
	MassSol 1.48
	RadSol  1.76
	Teff    6180
	FeH     0.21
	Age     1.4
}

Star	"WD 0806-661 B"
{
	RA      8.115
	Dec     -66.3047222
	Dist    19.2
	AppMagn 13.739
	Class  "DQ"
	MassSol 0.62
	Age     1.5
}

Star	"WD 1145+017"
{
	RA      11.80916667
	Dec     1.483055578
	Dist    174
	AppMagn 17
	Class  "WD"
	Teff    15900
}

Star	"WISE 1711+3500"
{
	RA      17.18472222
	Dec     35.01027779
	Dist    19
	AppMagn 18
	Class  "T8"
	MassSol 0.034
	Teff    770
	Age     3
}

Star	"WTS-1"
{
	RA      19.59944667
	Dec     36.2903
	Dist    3200
	AppMagn 16.3
	Class  "F6V"
	MassSol 1.2
	RadSol  1.15
	Teff    6250
	FeH    -0.25
	Age     2.5
}

Star	"WTS-2"
{
	RA      19.58218587
	Dec     36.815491
	Dist    1000
	AppMagn 15.9
	Class  "K2V"
	MassSol 0.82
	RadSol  0.75
	Teff    5000
	FeH     0.2
	Age     0.6
}

Star	"Wolf 1061/HIP 80824"
{
	RA      16.50501607
	Dec     -12.662594
	Dist    4.29
	AppMagn 10.1
	Class  "M3.5V"
	MassSol 0.25
	Teff    3393
}

Star	"XO-1"
{
	RA      16.03666667
	Dec     28.1697222
	Dist    200
	AppMagn 11.3
	Class  "G1V"
	MassSol 1
	RadSol  0.928
	Teff    5750
	Age     4.5
}

Star	"XO-3"
{
	RA      4.36472222
	Dec     57.8169444
	Dist    260
	AppMagn 9.8
	Class  "F5V"
	MassSol 1.41
	RadSol  1.49
	Teff    6781
	FeH    -0.08
	Age     2.82
}

Star	"XO-4"
{
	RA      7.359166667
	Dec     58.2680556
	Dist    293
	AppMagn 10.7
	Class  "F5V"
	MassSol 1.32
	RadSol  1.55
	Teff    5700
	FeH    -0.04
	Age     2.1
}

Star	"XO-5"
{
	RA      7.781102
	Dec     39.094578
	Dist    260
	AppMagn 12.13
	Class  "G8V"
	MassSol 1.04
	RadSol  1.13
	Teff    5430
	FeH     0.05
	Age     8.5
}

// 4079 stars
