////////////////////////////////////////////////////////////
//                                                        //
//         Exoplanet catalog for SpaceEngine 0.974        //
//                                                        //
//             Last update : 2016-05-13                   //
//                                                        //
// Catalog of confirmed exoplanets                        //
//                                                        //
// Original data from:                                    //
//                                                        //
// 1) NASA Exoplanet Archive                              //
//    http://exoplanetarchive.ipac.caltech.edu/index.html //
// 2) Interactive Exoplanet Catalog                       //
//    http://exoplanet.eu/catalog/                        //
//    Jean Schneider (CNRS-LUTH, Paris Observatory)       //
//                                                        //
////////////////////////////////////////////////////////////

// Star solver log level:
// 0 - do not log
// 1 - log errors and warnings only
// 2 - log everything
LogLevel    1


Planet	"11 Com A b"
{
	ParentBody     "11 Com A"
	Msini           6173.08
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452899.6
		Period          0.8926405795
		SemiMajorAxis   1.29
		Eccentricity    0.231
		ArgOfPericen    94.8
	}
}

Planet	"11 Oph b"
{
	ParentBody     "11 Oph"
	Mass            4454.8
	DiscMethod     "Imaging"
	DiscDate       "2006"
	Orbit
	{
		Period          19986.73812
		SemiMajorAxis   243
	}
}

Planet	"11 UMi b"
{
	ParentBody     "11 UMi"
	Msini           3341.1
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2452861.04
		Period          1.413363555
		SemiMajorAxis   1.54
		Eccentricity    0.08
		ArgOfPericen    117.63
	}
}

Planet	"14 Her b"
{
	ParentBody     "14 Her"
	Msini           1476.448
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451372.7
		Period          4.855408409
		SemiMajorAxis   2.77
		Eccentricity    0.369
		ArgOfPericen    22.6
	}
}

Planet	"16 Cyg B b"
{
	ParentBody     "16 Cyg B"
	Msini           534.576
	DiscMethod     "RadVel"
	DiscDate       "1996"
	Orbit
	{
		Epoch           2446549.1
		Period          2.186220602
		SemiMajorAxis   1.681
		Eccentricity    0.681
		ArgOfPericen    85.8
	}
}

Planet	"1RXS J160929.1-210524 b/1RXS 1609 b"
{
	ParentBody     "1RXS J160929.1-210524"
	Mass            4454.8
	Radius          121536.4
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		SemiMajorAxis   330
	}
}

Planet	"24 Sex b"
{
	ParentBody     "24 Sex"
	Msini           633.218
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454762
		Period          1.239725345
		SemiMajorAxis   1.333
		Eccentricity    0.09
		ArgOfPericen    9.2
	}
}

Planet	"24 Sex c"
{
	ParentBody     "24 Sex"
	Msini           273.652
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454930
		Period          2.41757394
		SemiMajorAxis   2.08
		Eccentricity    0.29
		ArgOfPericen    220.5
	}
}

Planet	"2M 0103-55 b/2MASS J01033563-5515561 b"
{
	ParentBody     "2M 0103-55"
	Mass            4136.6
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   84
	}
}

Planet	"2M 0122-24 b/2MASS J01225093-2439505 b"
{
	ParentBody     "2M 0122-24"
	Mass            6364
	Radius          71492
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   52
	}
}

Planet	"2M 0219-39 b/2MASS J02192210-3925225 b"
{
	ParentBody     "2M 0219-39"
	Mass            4422.98
	Radius          102948.48
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   156
	}
}

Planet	"2M 0441+23 b/2MASS J04414489+2301513 b"
{
	ParentBody     "2M 0441+23"
	Mass            2386.5
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   15
	}
}

Planet	"2M 0746+20 b/2MASS J07464256+2000321 b"
{
	ParentBody     "2M 0746+20"
	Mass            9546
	Radius          69347.24
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		Period          12.7038993
		SemiMajorAxis   2.897
		Eccentricity    0.487
		Inclination     138.2
		ArgOfPericen    354.4
	}
}

Planet	"2M 1207-39 b/2MASS J12073346-3932539 b"
{
	ParentBody     "2M 1207-39"
	Mass            1272.8
	DiscMethod     "Imaging"
	DiscDate       "2004"
	Orbit
	{
		SemiMajorAxis   46
	}
}

Planet	"2M 1938+46 b/2MASS J19383260+4603591 b"
{
	ParentBody     "2M 1938+46"
	Mass            604.58
	DiscMethod     "Pulsar"
	DiscDate       "2015"
	Orbit
	{
		Period          1.138970282
		SemiMajorAxis   0.92
	}
}

Planet	"2M 2140+16 b/2MASS J21402931+1625183 b"
{
	ParentBody     "2M 2140+16"
	Mass            6666.29
	Radius          65772.64
	DiscMethod     "Imaging"
	DiscDate       "2009"
	Orbit
	{
		Period          20.08667181
		SemiMajorAxis   3.53
		Eccentricity    0.26
		Inclination     46.2
		ArgOfPericen    223
	}
}

Planet	"2M 2206-20 b/2MASS J22062280-2047058 b"
{
	ParentBody     "2M 2206-20"
	Mass            9546
	Radius          92939.6
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		Period          23.78148046
		SemiMajorAxis   4.48
		Eccentricity    0
		Inclination     44.3
	}
}

Planet	"2M J2126-81 b"
{
	ParentBody     "2M J2126-81"
	Mass            4232.06
	DiscMethod     "Imaging"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   6900
	}
}

Planet	"30 Ari B b"
{
	ParentBody     "30 Ari B"
	Msini           3143.816
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454538
		Period          0.9174734171
		SemiMajorAxis   0.995
		Eccentricity    0.289
		ArgOfPericen    307
	}
}

Planet	"4 UMa b"
{
	ParentBody     "4 UMa"
	Msini           2259.22
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2452987.394
		Period          0.7373189831
		SemiMajorAxis   0.87
		Eccentricity    0.432
		ArgOfPericen    23.81
	}
}

Planet	"47 UMa d"
{
	ParentBody     "Chalawan"
	Msini           521.848
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2451736
		Period          38.33620647
		SemiMajorAxis   11.6
		Eccentricity    0.16
		ArgOfPericen    110
	}
}

Planet	"51 Eri b"
{
	ParentBody     "51 Eri"
	Mass            2227.4
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2452014.79
		Period          40.97281315
		SemiMajorAxis   14
		Eccentricity    0.21
		Inclination     138
		ArgOfPericen    90
	}
}

Planet	"6 Lyn b"
{
	ParentBody     "6 Lyn"
	Msini           703.222
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454024.5
		Period          2.395051898
		SemiMajorAxis   2.18
		Eccentricity    0.125
		Inclination     2
		ArgOfPericen    314.9
	}
}

Planet	"61 Vir b"
{
	ParentBody     "61 Vir"
	Msini           5.0912
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453369.166
		Period          0.01154028783
		SemiMajorAxis   0.050201
		Eccentricity    0.12
		ArgOfPericen    105
	}
}

Planet	"61 Vir c"
{
	ParentBody     "61 Vir"
	Msini           18.1374
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453369.166
		Period          0.1040980507
		SemiMajorAxis   0.2175
		Eccentricity    0.14
		ArgOfPericen    341
	}
}

Planet	"61 Vir d"
{
	ParentBody     "61 Vir"
	Msini           22.9104
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453369.166
		Period          0.3367902269
		SemiMajorAxis   0.476
		Eccentricity    0.35
		ArgOfPericen    314
	}
}

Planet	"7 CMa b"
{
	ParentBody     "7 CMa"
	Msini           782.772
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454093
		Period          2.179375828
		SemiMajorAxis   1.93
		Eccentricity    0.22
		ArgOfPericen    77
	}
}

Planet	"70 Vir b"
{
	ParentBody     "70 Vir"
	Msini           2354.68
	DiscMethod     "RadVel"
	DiscDate       "1996"
	Orbit
	{
		Epoch           2447239.709
		Period          0.3194937585
		SemiMajorAxis   0.481
		Eccentricity    0.399
		ArgOfPericen    358.8
	}
}

Planet	"75 Cet b"
{
	ParentBody     "75 Cet"
	Msini           954.6
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2452213
		Period          1.894359467
		SemiMajorAxis   2.1
		Eccentricity    0.117
		ArgOfPericen    165
	}
}

Planet	"8 UMi b/8 Umi b"
{
	ParentBody     "8 UMi"
	Msini           477.3
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2454108.5
		Period          0.2557207316
		SemiMajorAxis   0.49
		Eccentricity    0.06
		ArgOfPericen    91
	}
}

Planet	"81 Cet b"
{
	ParentBody     "81 Cet"
	Msini           1686.46
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452486
		Period          2.608406221
		SemiMajorAxis   2.5
		Eccentricity    0.206
		ArgOfPericen    175
	}
}

Planet	"83 Leo B b/HD 99492 b"
{
	ParentBody     "83 Leo B"
	Msini           25.1378
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2453776.317
		Period          0.04669230575
		SemiMajorAxis   0.123
		Eccentricity    0.07
		ArgOfPericen    240.7
	}
}

Planet	"83 Leo B c/HD 99492 c"
{
	ParentBody     "83 Leo B"
	Msini           114.552
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2449636
		Period          13.60740938
		SemiMajorAxis   5.4
		Eccentricity    0.1
		ArgOfPericen    38
	}
}

Planet	"91 Aqr b"
{
	ParentBody     "91 Aqr A"		// not "91 Aqr"
	Msini           1018.24
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2453472.1
		Period          0.4966567528
		SemiMajorAxis   0.7
		Eccentricity    0.027
		ArgOfPericen    177.3
	}
}

Planet	"AB Pic b"
{
	ParentBody     "AB Pic"
	Mass            4295.7
	DiscMethod     "Imaging"
	DiscDate       "2005"
	Orbit
	{
		SemiMajorAxis   260
	}
}

Planet	"AEgir/EPS Eri b"
{
	ParentBody     "Ran"
	Msini           248.196
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2454207.5
		Period          6.850249148
		SemiMajorAxis   3.39
		Eccentricity    0.702
		Inclination     30.1
		ArgOfPericen    47
	}
}

Planet	"ALF Ari b"
{
	ParentBody     "ALF Ari"
	Msini           572.76
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2451213.52
		Period          1.042595874
		SemiMajorAxis   1.2
		Eccentricity    0.25
		ArgOfPericen    89.16
	}
}

Planet	"ALF Cen B b"
{
	ParentBody     "ALF Cen B"
	Msini           1.14552
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.008859053225
		SemiMajorAxis   0.04
		Eccentricity    0
	}
}

Planet	"ALF Tau b/Aldebaran b"
{
	ParentBody     "Aldebaran"
	Msini           2058.754
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2451297
		Period          1.722035453
		SemiMajorAxis   1.46
		Eccentricity    0.1
		ArgOfPericen    287
	}
}

Planet	"Amateru/EPS Tau b"
{
	ParentBody     "Ain"
	Msini           2335.588
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2452879
		Period          1.628782262
		SemiMajorAxis   1.9
		Eccentricity    0.151
		ArgOfPericen    94.4
	}
}

Planet	"Arion/18 Del b"
{
	ParentBody     "Musica"
	Msini           3277.46
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2451672
		Period          2.719565339
		SemiMajorAxis   2.6
		Eccentricity    0.08
		ArgOfPericen    166.1
	}
}

Planet	"Arkas/HD 81688 b"
{
	ParentBody     "Intercrus"
	Msini           563.214
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452335.4
		Period          0.5038300753
		SemiMajorAxis   0.66
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"BD+14 4559 b"
{
	ParentBody     "HIP 104780"
	Msini           467.754
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453294.21
		Period          0.7363333357
		SemiMajorAxis   0.777
		Eccentricity    0.29
		ArgOfPericen    87.64
	}
}

Planet	"BD+15 2375 b"
{
	ParentBody     "BD+15 2375"
	Msini           337.292
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2457680
		Period          0.4195024678
		SemiMajorAxis   0.576
		Eccentricity    0.001
		ArgOfPericen    55
	}
}

Planet	"BD+15 2940 b"
{
	ParentBody     "HIP 78407"
	Msini           353.202
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2453464
		Period          0.376407775
		SemiMajorAxis   0.539
		Eccentricity    0.26
		ArgOfPericen    302
	}
}

Planet	"BD+20 1790 b"
{
	ParentBody     "BD+20 1790"
	Msini           2026.934
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Period          0.0213087924
		SemiMajorAxis   0.066
		Eccentricity    0.22
		ArgOfPericen    262
	}
}

Planet	"BD+20 2457 b"
{
	ParentBody     "BD+20 2457"
	Msini           6815.844
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454677.53
		Period          1.03939252
		SemiMajorAxis   1.45
		Eccentricity    0.15
		ArgOfPericen    207.64
	}
}

Planet	"BD+20 2457 c"
{
	ParentBody     "BD+20 2457"
	Msini           3967.954
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453867.45
		Period          1.702952225
		SemiMajorAxis   2.01
		Eccentricity    0.18
		ArgOfPericen    126.02
	}
}

Planet	"BD+20 274 b"
{
	ParentBody     "BD+20 274"
	Msini           1336.44
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453921
		Period          1.583059176
		SemiMajorAxis   1.3
		Eccentricity    0.21
		ArgOfPericen    108.5
	}
}

Planet	"BD+20 274 c"
{
	ParentBody     "BD+20 274"
	Mass            1336.44
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453920.5
		Period          1.583059176
		SemiMajorAxis   1.3
	}
}

Planet	"BD+20 594 b"
{
	ParentBody     "BD+20 594"
	Msini           16.32366
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1141311195
		SemiMajorAxis   0.241
		Eccentricity    0
		Inclination     89.55
	}
}

Planet	"BD+24 4697 b"
{
	ParentBody     "BD+24 4697"
	Msini           16864.6
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455986.042
		Period          0.3972186238
		SemiMajorAxis   0.5
		Eccentricity    0.50048
		ArgOfPericen    66.35
	}
}

Planet	"BD+26 1888 b"
{
	ParentBody     "BD+26 1888"
	Msini           8273.2
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456548.3
		Period          1.469654971
		SemiMajorAxis   1.19
		Eccentricity    0.2675
		ArgOfPericen    1.3
	}
}

Planet	"BD+48 738 b"
{
	ParentBody     "BD+48 738"
	Msini           289.562
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454457.2
		Period          1.074903204
		SemiMajorAxis   1
		Eccentricity    0.2
		ArgOfPericen    358.9
	}
}

Planet	"BD+49 828 b"
{
	ParentBody     "BD+49 828"
	Mass            509.12
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2455470
		Period          7.09118517
		SemiMajorAxis   4.2
		Eccentricity    0.35
		ArgOfPericen    170
	}
}

Planet	"BD-06 1339 b"
{
	ParentBody     "Gliese 221"
	Msini           8.5914
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455220.5
		Period          0.01060337526
		SemiMajorAxis   0.0428
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"BD-06 1339 c"
{
	ParentBody     "Gliese 221"
	Msini           54.094
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455264.2
		Period          0.3448123013
		SemiMajorAxis   0.435
		Eccentricity    0
		ArgOfPericen    41
	}
}

Planet	"BD-08 2823 b"
{
	ParentBody     "HIP 49067"
	Msini           14.319
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454637.7
		Period          0.01533229226
		SemiMajorAxis   0.056
		Eccentricity    0.15
		ArgOfPericen    30
	}
}

Planet	"BD-08 2823 c"
{
	ParentBody     "HIP 49067"
	Msini           105.006
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454193
		Period          0.6505272573
		SemiMajorAxis   0.68
		Eccentricity    0.19
		ArgOfPericen    127
	}
}

Planet	"BD-10 3166 b"
{
	ParentBody     "BD-10 3166"
	Msini           145.7356
	Radius          73636.76
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451844.7
		Period          0.009549280168
		SemiMajorAxis   0.046
		Eccentricity    0.0104
		ArgOfPericen    345.4
	}
}

Planet	"BD-11 4672 b"
{
	ParentBody     "HIP 90979"
	Msini           168.646
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455899
		Period          4.564094856
		SemiMajorAxis   2.28
		Eccentricity    0.05
		ArgOfPericen    231
	}
}

Planet	"BD-17 63 b"
{
	ParentBody     "HIP 2247"
	Msini           1622.82
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454627.1
		Period          1.794973358
		SemiMajorAxis   1.34
		Eccentricity    0.54
		ArgOfPericen    112.2
	}
}

Planet	"BET Cir b"
{
	ParentBody     "BET Cir"
	Mass            17819.2
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   6656
	}
}

Planet	"BET Cnc b"
{
	ParentBody     "BET Cnc"
	Msini           2481.96
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2453229.8
		Period          1.656982728
		SemiMajorAxis   1.7
		Eccentricity    0.08
		ArgOfPericen    58.9
	}
}

Planet	"BET Pic b"
{
	ParentBody     "BET Pic"
	Mass            2227.4
	Radius          117961.8
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		Period          36.3813392
		SemiMajorAxis   13.18
		Eccentricity    0.323
		Inclination     89.01
		ArgOfPericen    87
	}
}

Planet	"BET UMi b"
{
	ParentBody     "BET UMi"
	Msini           1941.02
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2453175.3
		Period          1.430010044
		SemiMajorAxis   1.4
		Eccentricity    0.19
		ArgOfPericen    307.4
	}
}

Planet	"CD-35 2722 b"
{
	ParentBody     "CD-35 2722"
	Mass            9864.2
	DiscMethod     "Imaging"
	DiscDate       "2011"
	Orbit
	{
		SemiMajorAxis   67
	}
}

Planet	"CHXR 73 b"
{
	ParentBody     "CHXR 73"
	Mass            3818.4
	DiscMethod     "Imaging"
	DiscDate       "2006"
	Orbit
	{
		SemiMajorAxis   200
	}
}

Planet	"CT Cha b"
{
	ParentBody     "CT Cha"
	Mass            5409.4
	Radius          157282.4
	DiscMethod     "Imaging"
	DiscDate       "2007"
	Orbit
	{
		SemiMajorAxis   440
	}
}

Planet	"CoRoT-1 b"
{
	ParentBody     "CoRoT-1"
	Mass            327.746
	Radius          106523.08
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.004131383892
		SemiMajorAxis   0.0254
		Eccentricity    0
		Inclination     85.1
	}
}

Planet	"CoRoT-10 b"
{
	ParentBody     "CoRoT-10"
	Mass            875.05
	Radius          69347.24
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454990.85
		Period          0.0362515623
		SemiMajorAxis   0.1055
		Eccentricity    0.53
		Inclination     88.55
		ArgOfPericen    218.9
	}
}

Planet	"CoRoT-11 b"
{
	ParentBody     "CoRoT-11"
	Mass            741.406
	Radius          102233.56
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.00819819036
		SemiMajorAxis   0.04351
		Eccentricity    0
		Inclination     81.41
	}
}

Planet	"CoRoT-12 b"
{
	ParentBody     "CoRoT-12"
	Mass            291.7894
	Radius          102948.48
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.007742922583
		SemiMajorAxis   0.04016
		Eccentricity    0.07
		Inclination     85.48
		ArgOfPericen    105
	}
}

Planet	"CoRoT-13 b"
{
	ParentBody     "CoRoT-13"
	Mass            416.2056
	Radius          63270.42
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01104798436
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     88.02
	}
}

Planet	"CoRoT-14 b"
{
	ParentBody     "CoRoT-14"
	Mass            2418.32
	Radius          77926.28
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454787.67
		Period          0.004140102217
		SemiMajorAxis   0.027
		Eccentricity    0
		Inclination     79.6
	}
}

Planet	"CoRoT-15 b"
{
	ParentBody     "CoRoT-15"
	Msini           20142.06
	Radius          80071.04
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.008378988203
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     86.7
	}
}

Planet	"CoRoT-16 b"
{
	ParentBody     "CoRoT-16"
	Mass            170.237
	Radius          83645.64
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01465402998
		SemiMajorAxis   0.0618
		Eccentricity    0.33
		Inclination     85.01
		ArgOfPericen    168.41
	}
}

Planet	"CoRoT-17 b"
{
	ParentBody     "CoRoT-17"
	Mass            773.226
	Radius          72921.84
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454923.309
		Period          0.0103167846
		SemiMajorAxis   0.0461
		Eccentricity    0
		Inclination     88.34
		ArgOfPericen    0
	}
}

Planet	"CoRoT-18 b"
{
	ParentBody     "CoRoT-18"
	Mass            1104.154
	Radius          93654.52
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.005202217468
		SemiMajorAxis   0.0295
		Eccentricity    0.08
		Inclination     86.5
	}
}

Planet	"CoRoT-19 b"
{
	ParentBody     "CoRoT-19"
	Mass            353.202
	Radius          92224.68
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01066998859
		SemiMajorAxis   0.0518
		Eccentricity    0.047
		Inclination     87.61
		ArgOfPericen    86
	}
}

Planet	"CoRoT-2 b"
{
	ParentBody     "CoRoT-2"
	Mass            1053.242
	Radius          104735.78
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454237.536
		Period          0.004772166109
		SemiMajorAxis   0.0281
		Eccentricity    0
		Inclination     87.84
		ArgOfPericen    102
	}
}

Planet	"CoRoT-20 b"
{
	ParentBody     "CoRoT-20"
	Mass            1349.168
	Radius          60053.28
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455265.791
		Period          0.02530608527
		SemiMajorAxis   0.0902
		Eccentricity    0.562
		Inclination     88.21
		ArgOfPericen    56.3
	}
}

Planet	"CoRoT-21 b"
{
	ParentBody     "CoRoT-21"
	Mass            719.132
	Radius          92939.6
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.007460091073
		SemiMajorAxis   0.0417
		Eccentricity    0
		Inclination     86.8
	}
}

Planet	"CoRoT-22 b"
{
	ParentBody     "CoRoT-22"
	Mass            12.21420256
	Radius          31125.13003
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02671098868
		SemiMajorAxis   0.092
		Eccentricity    0.077
		Inclination     89.749
		ArgOfPericen    210
	}
}

Planet	"CoRoT-23 b"
{
	ParentBody     "CoRoT-23"
	Mass            890.96
	Radius          77211.36
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.009942443948
		SemiMajorAxis   0.0477
		Eccentricity    0.16
		Inclination     85.7
		ArgOfPericen    51.8
	}
}

Planet	"CoRoT-24 b"
{
	ParentBody     "CoRoT-24"
	Mass            5.7276
	Radius          23592.36
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01400002558
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     86.5
	}
}

Planet	"CoRoT-24 c"
{
	ParentBody     "CoRoT-24"
	Mass            28.0016
	Radius          31456.48
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03219507583
		SemiMajorAxis   0.098
		Eccentricity    0
		Inclination     89
	}
}

Planet	"CoRoT-25 b"
{
	ParentBody     "CoRoT-25"
	Mass            85.914
	Radius          77211.36
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01330812851
		SemiMajorAxis   0.0578
		Eccentricity    0
		Inclination     84.5
	}
}

Planet	"CoRoT-26 b"
{
	ParentBody     "CoRoT-26"
	Mass            165.464
	Radius          90079.92
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01151219688
		SemiMajorAxis   0.0526
		Eccentricity    0
		Inclination     86.8
	}
}

Planet	"CoRoT-27 b"
{
	ParentBody     "CoRoT-27"
	Mass            3306.098
	Radius          71992.444
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009788901993
		SemiMajorAxis   0.0476
		Eccentricity    0.065
		Inclination     86.7
	}
}

Planet	"CoRoT-28 b"
{
	ParentBody     "CoRoT-28"
	Mass            154.0088
	Radius          68274.86
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01426042813
		SemiMajorAxis   0.059
		Eccentricity    0.047
		Inclination     88.1
		ArgOfPericen    126
	}
}

Planet	"CoRoT-29 b"
{
	ParentBody     "CoRoT-29"
	Mass            270.47
	Radius          64342.8
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007804602204
		SemiMajorAxis   0.039
		Eccentricity    0.082
		Inclination     87.3
		ArgOfPericen    87
	}
}

Planet	"CoRoT-3 b"
{
	ParentBody     "CoRoT-3"
	Mass            6927.214
	Radius          72206.92
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.0116547308
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     85.9
	}
}

Planet	"CoRoT-33 b"
{
	ParentBody     "CoRoT-33"
	Mass            18773.8
	Radius          78641.2
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01593228592
		SemiMajorAxis   0.0579
		Eccentricity    0.07
		Inclination     85.5
		ArgOfPericen    179.3
	}
}

Planet	"CoRoT-4 b"
{
	ParentBody     "CoRoT-4"
	Mass            229.104
	Radius          85075.48
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.02519437857
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     90
	}
}

Planet	"CoRoT-5 b"
{
	ParentBody     "CoRoT-5"
	Mass            148.5994
	Radius          95084.36
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01105539369
		SemiMajorAxis   0.04947
		Eccentricity    0.09
		Inclination     85.83
		ArgOfPericen   -128.3
	}
}

Planet	"CoRoT-6 b"
{
	ParentBody     "CoRoT-6"
	Mass            941.872
	Radius          83359.672
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454595.614
		Period          0.0243306859
		SemiMajorAxis   0.0855
		Eccentricity    0.1
		Inclination     89.07
	}
}

Planet	"CoRoT-7 b"
{
	ParentBody     "CoRoT-7"
	Mass            7.428637951
	Radius          10651.42769
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.002337038337
		SemiMajorAxis   0.0172
		Eccentricity    0
		Inclination     80.1
	}
}

Planet	"CoRoT-7 c"
{
	ParentBody     "CoRoT-7"
	Mass            8.410026
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454445
		Period          0.01012478871
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     80
		ArgOfPericen    180
	}
}

Planet	"CoRoT-8 b"
{
	ParentBody     "CoRoT-8"
	Mass            68.6798603
	Radius          40692.28065
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01700868676
		SemiMajorAxis   0.063
		Eccentricity    0
		Inclination     88.4
	}
}

Planet	"CoRoT-9 b"
{
	ParentBody     "CoRoT-9"
	Mass            267.288
	Radius          67202.48
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454603.345
		Period          0.2608510371
		SemiMajorAxis   0.407
		Eccentricity    0.11
		Inclination     89.9
		ArgOfPericen    37
	}
}

Planet	"DENIS-P J082303.1-491201 b/DE0823-49 b"
{
	ParentBody     "DENIS-P J082303.1-491201"
	Mass            10023.3
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		Period          0.678317037
		SemiMajorAxis   0.36
		Eccentricity    0.36
		Inclination     52.2
		ArgOfPericen    41.8
	}
}

Planet	"DH Tau b"
{
	ParentBody     "DH Tau"
	Mass            3500.2
	DiscMethod     "Imaging"
	DiscDate       "2004"
	Orbit
	{
		SemiMajorAxis   330
	}
}

Planet	"DP Leo b"
{
	ParentBody     "DP Leo"
	Msini           1925.11
	DiscMethod     "ETV"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453025
		Period          27.98143337
		SemiMajorAxis   8.19
		Eccentricity    0.39
		ArgOfPericen   -78
	}
}

Planet	"DW Lyn b"
{
	ParentBody     "DW Lyn"
	Msini           1775.556
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   1148
	}
}

Planet	"Dagon/Fomalhaut b"
{
	ParentBody     "Fomalhaut"
	Mass            954.6
	Radius          85790.4
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2423055.5
		Period          1520.990771
		SemiMajorAxis   160
		Eccentricity    0.87
		Inclination     55
		ArgOfPericen   -148
	}
}

Planet	"Dimidium/Bellerophon/51 Peg b"
{
	ParentBody     "Helvetios"
	Msini           150.1904
	Radius          135834.8
	DiscMethod     "RadVel"
	DiscDate       "1995"
	Orbit
	{
		Epoch           2450404.4
		Period          0.0115835468
		SemiMajorAxis   0.052
		Eccentricity    0.0069
		Inclination     80
		ArgOfPericen    54.1
	}
}

Planet	"Draugr/PSR B1257+12 b"
{
	ParentBody     "Lich"
	Mass            0.019092
	DiscMethod     "Pulsar"
	DiscDate       "1994"
	Orbit
	{
		Epoch           2449765.6
		Period          0.06916506554
		SemiMajorAxis   0.19
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"Dulcinea/MU Ara c/HD 160691 c"
{
	ParentBody     "Cervantes"
	Msini           577.2148
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452991.1
		Period          0.02638961289
		SemiMajorAxis   0.09094
		Eccentricity    0.172
		ArgOfPericen    212.7
	}
}

Planet	"EPIC 201295312 b"
{
	ParentBody     "EPIC 201295312"
	Msini           12.02796
	Radius          17515.54
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01548668297
		Eccentricity    0.12
		Inclination     86.6
	}
}

Planet	"EPIC 201367065 b/K2-3 b"
{
	ParentBody     "EPIC 201367065"
	Msini           8.2732
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.027528282
		SemiMajorAxis   0.0775
		Eccentricity    0.06
		Inclination     89.59
		ArgOfPericen    180
	}
}

Planet	"EPIC 201367065 c/K2-3 c"
{
	ParentBody     "EPIC 201367065"
	Msini           2.10012
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.06747177814
		SemiMajorAxis   0.1405
		Eccentricity    0.04
		Inclination     89.7
		ArgOfPericen    89
	}
}

Planet	"EPIC 201367065 d/K2-3 d"
{
	ParentBody     "EPIC 201367065"
	Msini           11.10518
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.1220006922
		SemiMajorAxis   0.2086
		Eccentricity    0.045
		Inclination     89.79
		ArgOfPericen    351
	}
}

Planet	"EPIC 201445392 c"
{
	ParentBody     "K2-8"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.006868209834
	}
}

Planet	"EPIC 201505350 b/K2-19 b"
{
	ParentBody     "EPIC 201505350"
	Msini           59.5034
	Radius          49400.972
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02168259916
		SemiMajorAxis   0.077
		Eccentricity    0.119
		Inclination     88.83
		ArgOfPericen    179
	}
}

Planet	"EPIC 201505350 c/K2-19 c"
{
	ParentBody     "EPIC 201505350"
	Mass            9.8642
	Radius          31027.528
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.0326006971
		SemiMajorAxis   0.1032
		Eccentricity    0.095
		Inclination     89.91
		ArgOfPericen    237
	}
}

Planet	"EPIC 205117205 b"
{
	ParentBody     "EPIC 205117205"
	Radius          32242.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01485315813
		Eccentricity    0
		Inclination     89.1
	}
}

Planet	"EPS CrB A b"
{
	ParentBody     "EPS CrB A"
	Msini           2131.94
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2451235.3
		Period          1.14417231
		SemiMajorAxis   1.3
		Eccentricity    0.11
		ArgOfPericen    133.1
	}
}

Planet	"EPS Ret A b/HD 27442 A b"
{
	ParentBody     "EPS Ret A"
	Msini           407.296
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451849.3
		Period          1.160438229
		SemiMajorAxis   1.18
		Eccentricity    0.07
		ArgOfPericen    4
	}
}

Planet	"ETA Cet b"
{
	ParentBody     "ETA Cet"
	Mass            811.41
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          1.104746415
		SemiMajorAxis   1.27
		Eccentricity    0.13
		ArgOfPericen    250.6
	}
}

Planet	"ETA Cet c"
{
	ParentBody     "ETA Cet"
	Mass            1056.424
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          2.058634027
		SemiMajorAxis   1.93
		Eccentricity    0.1
		ArgOfPericen    67.54
	}
}

Planet	"FU Tau b"
{
	ParentBody     "FU Tau"
	Mass            5091.2
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		SemiMajorAxis   800
	}
}

Planet	"FW Tau b"
{
	ParentBody     "FW Tau"
	Mass            3182
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   330
	}
}

Planet	"Fortitudo/KSI Aql b"
{
	ParentBody     "Libertas"
	Msini           642.764
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453001.7
		Period          0.3744091011
		SemiMajorAxis   0.58
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"GAM1 Leo b"
{
	ParentBody     "GAM1 Leo"
	Msini           2793.796
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2451236
		Period          1.173194149
		SemiMajorAxis   1.19
		Eccentricity    0.144
		Inclination     172.1
		ArgOfPericen    206.7
	}
}

Planet	"GQ Lup b"
{
	ParentBody     "GQ Lup"
	Mass            6364
	Radius          214476
	DiscMethod     "Imaging"
	DiscDate       "2004"
	Orbit
	{
		SemiMajorAxis   100
	}
}

Planet	"GSC 06214-00210 b"
{
	ParentBody     "GSC 06214-00210"
	Mass            5091.2
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   320
	}
}

Planet	"GU Psc b"
{
	ParentBody     "GU Psc"
	Mass            3500.2
	Radius          96514.2
	DiscMethod     "Imaging"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   2000
	}
}

Planet	"Gliese 1132 b"
{
	ParentBody     "Gliese 1132"
	Msini           1.62282
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.004459862648
		SemiMajorAxis   0.0154
		Eccentricity    0
	}
}

Planet	"Gliese 1214 b"
{
	ParentBody     "Gliese 1214"
	Mass            6.26854
	Radius          18158.968
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.004327004393
		SemiMajorAxis   0.01411
		Eccentricity    0.27
		Inclination     88.17
	}
}

Planet	"Gliese 15 A b"
{
	ParentBody     "Gliese 15 A"
	Msini           5.356228172
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03133071786
		SemiMajorAxis   0.0717
		Eccentricity    0
	}
}

Planet	"Gliese 160.2 b"
{
	ParentBody     "Gliese 160.2"
	Mass            10.21187427
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01433405052
		SemiMajorAxis   0.053
		Eccentricity    0.06
		ArgOfPericen    355.23
	}
}

Planet	"Gliese 163 b"
{
	ParentBody     "Gliese 163"
	Msini           10.62788
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455042.553
		Period          0.02363637126
		SemiMajorAxis   0.06069
		Eccentricity    0.0106
		ArgOfPericen    74.73
	}
}

Planet	"Gliese 163 c"
{
	ParentBody     "Gliese 163"
	Msini           7.27087
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455057.7
		Period          0.07021368482
		SemiMajorAxis   0.1254
		Eccentricity    0.094
		ArgOfPericen    235.4
	}
}

Planet	"Gliese 163 d"
{
	ParentBody     "Gliese 163"
	Msini           22.09899
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455275
		Period          1.645196028
		SemiMajorAxis   1.02689
		Eccentricity    0.399
		ArgOfPericen    126.915
	}
}

Planet	"Gliese 176 b/HD 285968 b"
{
	ParentBody     "Gliese 176"
	Msini           8.2732
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454399.79
		Period          0.02404870041
		SemiMajorAxis   0.066
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"Gliese 179 b"
{
	ParentBody     "Gliese 179"
	Msini           260.924
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455140
		Period          6.264336551
		SemiMajorAxis   2.41
		Eccentricity    0.21
		ArgOfPericen    153
	}
}

Planet	"Gliese 180 b"
{
	ParentBody     "Gliese 180"
	Mass            8.309662398
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04758486419
		SemiMajorAxis   0.103
		Eccentricity    0.11
		ArgOfPericen    11.46
	}
}

Planet	"Gliese 180 c"
{
	ParentBody     "Gliese 180"
	Mass            6.407450524
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06661059614
		SemiMajorAxis   0.129
		Eccentricity    0.09
		ArgOfPericen    234.91
	}
}

Planet	"Gliese 221 d"
{
	ParentBody     "Gliese 221"
	Msini           28.9562
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          1.368954666
		SemiMajorAxis   1.06
		Eccentricity    0.04
		ArgOfPericen    275
	}
}

Planet	"Gliese 229 b"
{
	ParentBody     "Gliese 229 A"
	Mass            32.03725262
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          1.289555295
		SemiMajorAxis   0.97
		Eccentricity    0.1
		ArgOfPericen    148.97
	}
}

Planet	"Gliese 27.1 b"
{
	ParentBody     "Gliese 27.1"
	Mass            13.01513388
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04331098772
		SemiMajorAxis   0.101
		Eccentricity    0.08
		ArgOfPericen    154.69
	}
}

Planet	"Gliese 3021 A b"
{
	ParentBody     "Gliese 3021 A"
	Msini           1072.334
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451545.86
		Period          0.3660858568
		SemiMajorAxis   0.49
		Eccentricity    0.511
		ArgOfPericen    290.7
	}
}

Planet	"Gliese 317 b"
{
	ParentBody     "Gliese 317"
	Msini           572.76
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2451656.7
		Period          1.894633258
		SemiMajorAxis   1.148
		Eccentricity    0.11
		Inclination     45
		ArgOfPericen    340
	}
}

Planet	"Gliese 317 c"
{
	ParentBody     "Gliese 317"
	Mass            636.4
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Period          19.98673812
		SemiMajorAxis   30
		Eccentricity    0.81
		ArgOfPericen    210
	}
}

Planet	"Gliese 328 b"
{
	ParentBody     "Gliese 328"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2454500
		Period          11.22542826
		SemiMajorAxis   4.5
		Eccentricity    0.37
		ArgOfPericen    290
	}
}

Planet	"Gliese 3293 b"
{
	ParentBody     "Gliese 3293"
	Msini           25.7742
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455640.3
		Period          0.08378002556
		SemiMajorAxis   0.1434
		Eccentricity    0.09
		ArgOfPericen   -77.7
	}
}

Planet	"Gliese 3293 c"
{
	ParentBody     "Gliese 3293"
	Msini           25.7742
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455687.8
		Period          0.3388162798
		SemiMajorAxis   0.364
		Eccentricity    0.33
		ArgOfPericen   -21.4
	}
}

Planet	"Gliese 3293 d"
{
	ParentBody     "Gliese 3293"
	Mass            22.4331
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455684.9
		Period          0.339445999
		SemiMajorAxis   0.364
		Eccentricity    0.37
		ArgOfPericen   -38
	}
}

Planet	"Gliese 3341 b"
{
	ParentBody     "Gliese 3341"
	Msini           6.61856
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455623.7
		Period          0.03889747788
		SemiMajorAxis   0.089
		Eccentricity    0.31
		ArgOfPericen    42.32
	}
}

Planet	"Gliese 3470 b"
{
	ParentBody     "Gliese 3470"
	Mass            13.91618161
	Radius          26724.24074
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009135609447
		SemiMajorAxis   0.03557
		Eccentricity    0.017
		Inclination     88.3
		ArgOfPericen    1.7
	}
}

Planet	"Gliese 3634 b"
{
	ParentBody     "Gliese 3634"
	Msini           7.0004
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454917.04
		Period          0.007243440308
		SemiMajorAxis   0.0287
		Eccentricity    0.08
		Inclination     59
		ArgOfPericen    84
	}
}

Planet	"Gliese 422 b"
{
	ParentBody     "Gliese 422"
	Mass            9.911525029
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07162644603
		SemiMajorAxis   0.119
		Eccentricity    0.05
		ArgOfPericen    246.37
	}
}

Planet	"Gliese 433 b"
{
	ParentBody     "Gliese 433"
	Msini           5.7276
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454287
		Period          0.0201775704
		SemiMajorAxis   0.06
		Eccentricity    0.05
		ArgOfPericen    309.39
	}
}

Planet	"Gliese 433 c"
{
	ParentBody     "Gliese 433"
	Mass            44.548
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2456740
		Period          10.11109916
		SemiMajorAxis   3.6
		Eccentricity    0.17
		ArgOfPericen   -154
	}
}

Planet	"Gliese 436 b"
{
	ParentBody     "Gliese 436"
	Mass            22.274
	Radius          27166.96
	DiscMethod     "Transit"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452992.1
		Period          0.007238867999
		SemiMajorAxis   0.02887
		Eccentricity    0.1912
		Inclination     85.8
		ArgOfPericen    354.4
	}
}

Planet	"Gliese 504 b"
{
	ParentBody     "Gliese 504"
	Mass            1272.8
	Radius          68632.32
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   43.5
	}
}

Planet	"Gliese 581 b"
{
	ParentBody     "Gliese 581"
	Msini           15.91
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2454753.95
		Period          0.01469887693
		SemiMajorAxis   0.041
		Eccentricity    0.031
		ArgOfPericen    251
	}
}

Planet	"Gliese 581 c"
{
	ParentBody     "Gliese 581"
	Msini           5.4094
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454763
		Period          0.03536886033
		SemiMajorAxis   0.073
		Eccentricity    0.07
		ArgOfPericen    235
	}
}

Planet	"Gliese 581 e"
{
	ParentBody     "Gliese 581"
	Msini           1.94102
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454750.31
		Period          0.008622908545
		SemiMajorAxis   0.028
		Eccentricity    0.32
		ArgOfPericen    236
	}
}

Planet	"Gliese 649 b"
{
	ParentBody     "Gliese 649"
	Msini           104.3696
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           12876
		Period          1.638091153
		SemiMajorAxis   1.135
		Eccentricity    0.3
		ArgOfPericen    352
	}
}

Planet	"Gliese 649 c"
{
	ParentBody     "Gliese 649"
	Msini           9.546
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01225542975
		SemiMajorAxis   0.043
		Eccentricity    0.2
		ArgOfPericen    334
	}
}

Planet	"Gliese 667 C b"
{
	ParentBody     "Gliese 667 C"
	Msini           5.60032
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454443.1
		Period          0.01971404235
		SemiMajorAxis   0.0505
		Eccentricity    0.13
		ArgOfPericen    5.7
	}
}

Planet	"Gliese 667 C c"
{
	ParentBody     "Gliese 667 C"
	Msini           3.78658
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454462
		Period          0.0770447686
		SemiMajorAxis   0.125
		Eccentricity    0.02
		ArgOfPericen    292
	}
}

Planet	"Gliese 667 C d"
{
	ParentBody     "Gliese 667 C"
	Msini           5.103928
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2454499
		Period          0.2508198739
		SemiMajorAxis   0.276
		Eccentricity    0.03
		ArgOfPericen    40.11
	}
}

Planet	"Gliese 667 C e"
{
	ParentBody     "Gliese 667 C"
	Msini           2.7047
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1704074768
		SemiMajorAxis   0.213
		Eccentricity    0.02
		ArgOfPericen    28.65
	}
}

Planet	"Gliese 667 C f"
{
	ParentBody     "Gliese 667 C"
	Msini           2.7047
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1068496496
		SemiMajorAxis   0.156
		Eccentricity    0.03
		ArgOfPericen    103
	}
}

Planet	"Gliese 667 C g"
{
	ParentBody     "Gliese 667 C"
	Msini           4.6139
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.7014523708
		SemiMajorAxis   0.549
		Eccentricity    0.08
		ArgOfPericen    51.56
	}
}

Planet	"Gliese 674 b"
{
	ParentBody     "Gliese 674"
	Msini           11.137
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453780.085
		Period          0.01285119882
		SemiMajorAxis   0.039
		Eccentricity    0.2
		ArgOfPericen    143
	}
}

Planet	"Gliese 676 A b"
{
	ParentBody     "Gliese 676 A"
	Msini           1575.09
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2455411.9
		Period          2.875626171
		SemiMajorAxis   1.8
		Eccentricity    0.328
		ArgOfPericen    86.9
	}
}

Planet	"Gliese 676 A c"
{
	ParentBody     "Gliese 676 A"
	Msini           954.6
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          12.04680106
		SemiMajorAxis   5.2
		Eccentricity    0.2
		ArgOfPericen    356
	}
}

Planet	"Gliese 676 A d"
{
	ParentBody     "Gliese 676 A"
	Msini           4.4548
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009856473595
		SemiMajorAxis   0.0413
		Eccentricity    0.15
		ArgOfPericen    315
	}
}

Planet	"Gliese 676 A e"
{
	ParentBody     "Gliese 676 A"
	Msini           11.4552
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.09683985307
		SemiMajorAxis   0.187
		Eccentricity    0.24
		ArgOfPericen    332
	}
}

Planet	"Gliese 682 b"
{
	ParentBody     "Gliese 682"
	Mass            4.405122235
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0478531793
		SemiMajorAxis   0.08
		Eccentricity    0.08
		ArgOfPericen    85.94
	}
}

Planet	"Gliese 682 c"
{
	ParentBody     "Gliese 682"
	Mass            8.707581502
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1569369629
		SemiMajorAxis   0.176
		Eccentricity    0.1
		ArgOfPericen    320.85
	}
}

Planet	"Gliese 687 b"
{
	ParentBody     "Gliese 687"
	Msini           18.4556
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2450603.97
		Period          0.1044238619
		SemiMajorAxis   0.16353
		Eccentricity    0.04
		ArgOfPericen    359.3
	}
}

Planet	"Gliese 758 b"
{
	ParentBody     "Gliese 758"
	Mass            11137
	DiscMethod     "Imaging"
	DiscDate       "2009"
	Orbit
	{
		Period          298.4321172
		SemiMajorAxis   44.8
		Eccentricity    0.564
		Inclination     43.6
	}
}

Planet	"Gliese 785 b/HD 192310 b"
{
	ParentBody     "Gliese 785"
	Msini           16.92824
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455164.3
		Period          0.2045765853
		SemiMajorAxis   0.32
		Eccentricity    0.13
		Inclination     90
		ArgOfPericen    173
	}
}

Planet	"Gliese 785 c/HD 192310 c"
{
	ParentBody     "Gliese 785"
	Msini           24.1832
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455151.026
		Period          1.439592727
		SemiMajorAxis   1.18
		Eccentricity    0.32
		Inclination     90
		ArgOfPericen    110
	}
}

Planet	"Gliese 832 b"
{
	ParentBody     "Gliese 832"
	Msini           216.376
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2451211
		Period          9.352698278
		SemiMajorAxis   3.6
		Eccentricity    0.08
		ArgOfPericen    246
	}
}

Planet	"Gliese 832 c"
{
	ParentBody     "Gliese 832"
	Msini           5.4094
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09768860496
		SemiMajorAxis   0.163
		Eccentricity    0.18
		ArgOfPericen    10
	}
}

Planet	"Gliese 849 b"
{
	ParentBody     "Gliese 849"
	Msini           289.562
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2454000
		Period          5.051442717
		SemiMajorAxis   2.32
		Eccentricity    0.05
		ArgOfPericen    298
	}
}

Planet	"Gliese 849 c"
{
	ParentBody     "Gliese 849"
	Mass            245.014
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          19.29952288
		Eccentricity    0.218
	}
}

Planet	"Gliese 86 A b"
{
	ParentBody     "Gliese 86 A"
	Msini           1275.982
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451146.7
		Period          0.04316587853
		SemiMajorAxis   0.11
		Eccentricity    0.046
		ArgOfPericen    266
	}
}

Planet	"Gliese 876 b"
{
	ParentBody     "Gliese 876"
	Msini           613.1714
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2450602.093
		Period          0.1670946065
		SemiMajorAxis   0.208317
		Eccentricity    0
		Inclination     84
		ArgOfPericen    116.7
	}
}

Planet	"Gliese 876 c"
{
	ParentBody     "Gliese 876"
	Msini           202.6934
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2450602.093
		Period          0.0827669991
		SemiMajorAxis   0.12959
		Eccentricity    0.002
		Inclination     48.07
		ArgOfPericen    225.2
	}
}

Planet	"Gliese 876 d"
{
	ParentBody     "Gliese 876"
	Msini           5.4094
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2450602.093
		Period          0.005311544104
		SemiMajorAxis   0.02080665
		Eccentricity    0.081
		Inclination     50
		ArgOfPericen    157.4
	}
}

Planet	"Gliese 876 e"
{
	ParentBody     "Gliese 876"
	Msini           12.4098
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450602.093
		Period          0.3413899146
		SemiMajorAxis   0.3343
		Eccentricity    0.073
		Inclination     59.5
		ArgOfPericen    360
	}
}

Planet	"HAT-P-1 b"
{
	ParentBody     "HAT-P-1"
	Msini           166.7368
	Radius          94297.948
	DiscMethod     "Transit"
	DiscDate       "2006"
	Orbit
	{
		Period          0.01222558588
		SemiMajorAxis   0.05561
		Eccentricity    0.067
		Inclination     85.634
		ArgOfPericen    0
	}
}

Planet	"HAT-P-12 b"
{
	ParentBody     "HAT-P-12"
	Mass            66.97788126
	Radius          68245.67445
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.00879706641
		SemiMajorAxis   0.0384
		Eccentricity    0
		Inclination     89
	}
}

Planet	"HAT-P-13 b"
{
	ParentBody     "HAT-P-13"
	Mass            270.7882
	Radius          90937.824
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.007984428089
		SemiMajorAxis   0.0426
		Eccentricity    0.0133
		Inclination     83.4
		ArgOfPericen    210
	}
}

Planet	"HAT-P-13 c"
{
	ParentBody     "HAT-P-13"
	Msini           4543.896
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2455312.8
		Period          1.221846798
		SemiMajorAxis   1.186
		Eccentricity    0.6616
		ArgOfPericen    175.29
	}
}

Planet	"HAT-P-14 b"
{
	ParentBody     "HAT-P-14"
	Mass            710.2224
	Radius          82215.8
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01267013814
		SemiMajorAxis   0.0606
		Eccentricity    0.107
		Inclination     83.5
		ArgOfPericen    94
	}
}

Planet	"HAT-P-15 b"
{
	ParentBody     "HAT-P-15"
	Mass            619.2172
	Radius          76639.424
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.0297432835
		SemiMajorAxis   0.0964
		Eccentricity    0.19
		Inclination     89.1
		ArgOfPericen    262
	}
}

Planet	"HAT-P-16 b"
{
	ParentBody     "HAT-P-16"
	Mass            1334.2126
	Radius          92153.188
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.007600326789
		SemiMajorAxis   0.0413
		Eccentricity    0.036
		Inclination     86.6
		ArgOfPericen    214
	}
}

Planet	"HAT-P-17 b"
{
	ParentBody     "HAT-P-17"
	Mass            169.9188
	Radius          72206.92
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454803.25
		Period          0.0283059386
		SemiMajorAxis   0.0882
		Eccentricity    0.346
		Inclination     89.2
		ArgOfPericen    201
	}
}

Planet	"HAT-P-17 c"
{
	ParentBody     "HAT-P-17"
	Msini           1081.88
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454885
		Period          15.28848571
		SemiMajorAxis   5.6
		Eccentricity    0.39
		ArgOfPericen    181.5
	}
}

Planet	"HAT-P-18 b"
{
	ParentBody     "HAT-P-18"
	Mass            58.2306
	Radius          67702.924
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.015080484
		SemiMajorAxis   0.0559
		Eccentricity    0.106
		Inclination     88.79
		ArgOfPericen    120
	}
}

Planet	"HAT-P-19 b"
{
	ParentBody     "HAT-P-19"
	Mass            92.9144
	Radius          80928.944
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01097568712
		SemiMajorAxis   0.0466
		Eccentricity    0.067
		Inclination     88.51
		ArgOfPericen    256
	}
}

Planet	"HAT-P-2 b"
{
	ParentBody     "HD 147506"
	Mass            2892.438
	Radius          82716.244
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454213.479
		Period          0.01542393802
		SemiMajorAxis   0.06878
		Eccentricity    0.5171
		Inclination     86.72
		ArgOfPericen    185.22
	}
}

Planet	"HAT-P-20 b"
{
	ParentBody     "HAT-P-20"
	Mass            2305.6772
	Radius          61983.564
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.007872357247
		SemiMajorAxis   0.0361
		Eccentricity    0.015
		Inclination     81.9
		ArgOfPericen    317
	}
}

Planet	"HAT-P-21 b"
{
	ParentBody     "HAT-P-21"
	Mass            1292.8466
	Radius          73207.808
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01129240026
		SemiMajorAxis   0.0494
		Eccentricity    0.228
		Inclination     87.2
		ArgOfPericen    300
	}
}

Planet	"HAT-P-22 b"
{
	ParentBody     "HD 233731"
	Mass            683.1754
	Radius          77211.36
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.008794767114
		SemiMajorAxis   0.0414
		Eccentricity    0.016
		Inclination     73.6
		ArgOfPericen    156
	}
}

Planet	"HAT-P-23 b"
{
	ParentBody     "HAT-P-23"
	Mass            658.674
	Radius          87506.208
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.003320763328
		SemiMajorAxis   0.02302
		Eccentricity    0
		Inclination     85.74
		ArgOfPericen    118
	}
}

Planet	"HAT-P-24 b"
{
	ParentBody     "HAT-P-24"
	Mass            217.967
	Radius          88793.064
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.009186342907
		SemiMajorAxis   0.0465
		Eccentricity    0.067
		Inclination     88.6
		ArgOfPericen    197
	}
}

Planet	"HAT-P-25 b"
{
	ParentBody     "HAT-P-25"
	Mass            180.4194
	Radius          85075.48
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01000113377
		SemiMajorAxis   0.0466
		Eccentricity    0.032
		Inclination     87.6
		ArgOfPericen    271
	}
}

Planet	"HAT-P-26 b"
{
	ParentBody     "HAT-P-26"
	Mass            18.62165308
	Radius          40373.37563
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01159372087
		SemiMajorAxis   0.0479
		Eccentricity    0.124
		Inclination     88.6
		ArgOfPericen    54
	}
}

Planet	"HAT-P-27 b"
{
	ParentBody     "HAT-P-27"
	Mass            210.012
	Radius          75424.06
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008322095268
		SemiMajorAxis   0.0403
		Eccentricity    0.078
		Inclination     85.08
		ArgOfPericen    63
	}
}

Planet	"HAT-P-28 b"
{
	ParentBody     "HAT-P-28"
	Mass            199.1932
	Radius          86648.304
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008917959345
		SemiMajorAxis   0.0434
		Eccentricity    0.051
		Inclination     88
		ArgOfPericen    233
	}
}

Planet	"HAT-P-29 b"
{
	ParentBody     "HAT-P-29"
	Mass            247.5596
	Radius          79141.644
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01566956436
		SemiMajorAxis   0.0667
		Eccentricity    0.095
		Inclination     87.1
		ArgOfPericen    169
	}
}

Planet	"HAT-P-3 b"
{
	ParentBody     "HAT-P-3"
	Mass            188.0562
	Radius          59123.884
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.007939123903
		SemiMajorAxis   0.03866
		Eccentricity    0
		Inclination     87.07
	}
}

Planet	"HAT-P-30 b"
{
	ParentBody     "HAT-P-30"
	Mass            226.2402
	Radius          95799.28
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.007695154279
		SemiMajorAxis   0.0419
		Eccentricity    0.035
		Inclination     83.6
		ArgOfPericen    252
	}
}

Planet	"HAT-P-31 b"
{
	ParentBody     "HAT-P-31"
	Mass            690.8122
	Radius          76496.44
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01370439982
		SemiMajorAxis   0.055
		Eccentricity    0.245
		Inclination     87.1
		ArgOfPericen    274.3
	}
}

Planet	"HAT-P-32 b"
{
	ParentBody     "HAT-P-32"
	Mass            299.4262
	Radius          145629.204
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.005886529705
		SemiMajorAxis   0.0344
		Eccentricity    0.163
		Inclination     88.7
		ArgOfPericen    52
	}
}

Planet	"HAT-P-33 b"
{
	ParentBody     "HAT-P-33"
	Mass            242.7866
	Radius          130615.884
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.009512794788
		SemiMajorAxis   0.0503
		Eccentricity    0.148
		Inclination     86.7
		ArgOfPericen    96
	}
}

Planet	"HAT-P-34 b"
{
	ParentBody     "HD 351766"
	Mass            1058.9696
	Radius          85575.924
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01492887227
		SemiMajorAxis   0.0677
		Eccentricity    0.441
		Inclination     87.1
		ArgOfPericen    20
	}
}

Planet	"HAT-P-35 b"
{
	ParentBody     "HAT-P-35"
	Mass            335.3828
	Radius          95227.344
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.009984350388
		SemiMajorAxis   0.0498
		Eccentricity    0.025
		Inclination     87.3
		ArgOfPericen    248
	}
}

Planet	"HAT-P-36 b"
{
	ParentBody     "HAT-P-36"
	Mass            582.9424
	Radius          90365.888
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.003634155738
		SemiMajorAxis   0.0238
		Eccentricity    0.063
		Inclination     86
		ArgOfPericen    95
	}
}

Planet	"HAT-P-37 b"
{
	ParentBody     "HAT-P-37"
	Mass            371.9758
	Radius          84217.576
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.00765912613
		SemiMajorAxis   0.0379
		Eccentricity    0.058
		Inclination     86.9
		ArgOfPericen    164
	}
}

Planet	"HAT-P-38 b"
{
	ParentBody     "HAT-P-38"
	Mass            84.9594
	Radius          58980.9
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01270494518
		SemiMajorAxis   0.0523
		Eccentricity    0.067
		Inclination     88.3
		ArgOfPericen    240
	}
}

Planet	"HAT-P-39 b"
{
	ParentBody     "HAT-P-39"
	Mass            190.6018
	Radius          112313.932
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009702794744
		SemiMajorAxis   0.0509
		Eccentricity    0
		Inclination     87
	}
}

Planet	"HAT-P-4 b"
{
	ParentBody     "HAT-P-4"
	Mass            216.376
	Radius          90794.84
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.008368451085
		SemiMajorAxis   0.0446
		Eccentricity    0
		Inclination     89.67
	}
}

Planet	"HAT-P-40 b"
{
	ParentBody     "HAT-P-40"
	Mass            195.693
	Radius          123681.16
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.0122035272
		SemiMajorAxis   0.0608
		Eccentricity    0
		Inclination     88.3
	}
}

Planet	"HAT-P-41 b"
{
	ParentBody     "HAT-P-41"
	Mass            254.56
	Radius          120464.02
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007376056422
		SemiMajorAxis   0.0426
		Eccentricity    0
		Inclination     87.7
	}
}

Planet	"HAT-P-42 b"
{
	ParentBody     "HAT-P-42"
	Mass            332.2008
	Radius          91509.76
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01270904109
		SemiMajorAxis   0.0575
		Eccentricity    0
		Inclination     85.9
	}
}

Planet	"HAT-P-43 b"
{
	ParentBody     "HAT-P-43"
	Mass            210.6484
	Radius          91581.252
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009124594838
		SemiMajorAxis   0.0443
		Eccentricity    0
		Inclination     88.7
	}
}

Planet	"HAT-P-44 b"
{
	ParentBody     "HAT-P-44"
	Mass            124.7344
	Radius          91509.76
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01177634216
		SemiMajorAxis   0.0507
		Eccentricity    0.072
		Inclination     89
		ArgOfPericen    113
	}
}

Planet	"HAT-P-44 c"
{
	ParentBody     "HAT-P-44"
	Msini           1272.8
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          2.388004519
		SemiMajorAxis   1.752
		Eccentricity    0.494
	}
}

Planet	"HAT-P-45 b"
{
	ParentBody     "HAT-P-45"
	Mass            283.8344
	Radius          101947.592
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.008566896396
		SemiMajorAxis   0.0452
		Eccentricity    0.049
		Inclination     87.8
		ArgOfPericen    146
	}
}

Planet	"HAT-P-46 b"
{
	ParentBody     "HAT-P-46"
	Mass            156.8726
	Radius          91795.728
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01221964254
		SemiMajorAxis   0.0577
		Eccentricity    0.123
		Inclination     85.5
		ArgOfPericen    70
	}
}

Planet	"HAT-P-46 c"
{
	ParentBody     "HAT-P-46"
	Mass            636.4
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.2127355551
		SemiMajorAxis   0.387
	}
}

Planet	"HAT-P-49 b"
{
	ParentBody     "HD 340099"
	Mass            550.486
	Radius          101018.196
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007369214387
		SemiMajorAxis   0.0438
		Eccentricity    0
		Inclination     86.2
		ArgOfPericen    0
	}
}

Planet	"HAT-P-5 b"
{
	ParentBody     "HAT-P-5"
	Mass            337.292
	Radius          90079.92
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.007634635531
		SemiMajorAxis   0.04075
		Eccentricity    0
		Inclination     86.75
	}
}

Planet	"HAT-P-50 b"
{
	ParentBody     "HAT-P-50"
	Mass            429.57
	Radius          92081.696
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.008547782777
		SemiMajorAxis   0.0453
		Eccentricity    0.115
		Inclination     83.65
	}
}

Planet	"HAT-P-51 b"
{
	ParentBody     "HAT-P-51"
	Mass            98.3238
	Radius          92439.156
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01154857768
		SemiMajorAxis   0.05069
		Eccentricity    0.123
		Inclination     88.48
	}
}

Planet	"HAT-P-52 b"
{
	ParentBody     "HAT-P-52"
	Mass            260.2876
	Radius          72135.428
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.007539094268
		SemiMajorAxis   0.03694
		Eccentricity    0.047
		Inclination     87.02
	}
}

Planet	"HAT-P-53 b"
{
	ParentBody     "HAT-P-53"
	Mass            472.2088
	Radius          94226.456
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.005370748929
		SemiMajorAxis   0.03159
		Eccentricity    0.134
		Inclination     86.2
	}
}

Planet	"HAT-P-54 b"
{
	ParentBody     "HAT-P-54"
	Mass            241.832
	Radius          67488.448
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01040363656
		SemiMajorAxis   0.04117
		Eccentricity    0.074
		Inclination     87.04
	}
}

Planet	"HAT-P-55 b"
{
	ParentBody     "HAT-P-55"
	Mass            185.1924
	Radius          84503.544
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009816080397
		SemiMajorAxis   0.04604
		Eccentricity    0.139
		Inclination     87.7
	}
}

Planet	"HAT-P-56 b"
{
	ParentBody     "HD 262389"
	Msini           693.676
	Radius          104807.272
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.007641046893
		SemiMajorAxis   0.0423
		Eccentricity    0.246
		Inclination     82.13
	}
}

Planet	"HAT-P-57 b"
{
	ParentBody     "HAT-P-57"
	Msini           588.67
	Radius          101018.196
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.006749754186
		SemiMajorAxis   0.0406
		Eccentricity    0
		Inclination     88.26
	}
}

Planet	"HAT-P-6 b"
{
	ParentBody     "HAT-P-6"
	Mass            336.3374
	Radius          95084.36
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.01054917287
		SemiMajorAxis   0.05235
		Eccentricity    0
		Inclination     85.51
	}
}

Planet	"HAT-P-8 b"
{
	ParentBody     "HAT-P-8"
	Mass            426.388
	Radius          107238
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.008422740542
		SemiMajorAxis   0.0449
		Eccentricity    0
		Inclination     87.8
	}
}

Planet	"HAT-P-9 b"
{
	ParentBody     "HAT-P-9"
	Mass            213.194
	Radius          100088.8
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01074030906
		SemiMajorAxis   0.053
		Eccentricity    0
		Inclination     86.5
	}
}

Planet	"HATS-1 b"
{
	ParentBody     "HATS-1"
	Mass            590.261
	Radius          93082.584
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009436092258
		SemiMajorAxis   0.0444
		Eccentricity    0.12
		Inclination     85.6
		ArgOfPericen    60
	}
}

Planet	"HATS-10 b"
{
	ParentBody     "HATS-10"
	Mass            167.3732
	Radius          69275.748
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009070271979
		SemiMajorAxis   0.0449
		Eccentricity    0.5
		Inclination     87.79
	}
}

Planet	"HATS-11 b"
{
	ParentBody     "HATS-11"
	Msini           270.47
	Radius          107952.92
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009908935497
		SemiMajorAxis   0.04614
		Eccentricity    0.34
		Inclination     88.31
	}
}

Planet	"HATS-12 b"
{
	ParentBody     "HATS-12"
	Msini           757.316
	Radius          96514.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008604791799
		SemiMajorAxis   0.04795
		Eccentricity    0.085
		Inclination     82.7
	}
}

Planet	"HATS-13 b"
{
	ParentBody     "HATS-13"
	Mass            172.7826
	Radius          86648.304
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.008334332628
		SemiMajorAxis   0.04057
		Eccentricity    0.181
		Inclination     88.55
	}
}

Planet	"HATS-14 b"
{
	ParentBody     "HATS-14"
	Mass            340.7922
	Radius          74280.188
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.007575149249
		SemiMajorAxis   0.03815
		Eccentricity    0.142
		Inclination     88.83
	}
}

Planet	"HATS-15 b"
{
	ParentBody     "HATS-15"
	Mass            690.494
	Radius          78998.66
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004784462416
		SemiMajorAxis   0.02712
		Eccentricity    0
		Inclination     87.13
	}
}

Planet	"HATS-16 b"
{
	ParentBody     "HATS-16"
	Mass            1040.514
	Radius          92939.6
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.007355398896
		SemiMajorAxis   0.03744
		Eccentricity    0
		Inclination     83.53
	}
}

Planet	"HATS-17 b"
{
	ParentBody     "HATS-17"
	Msini           425.7516
	Radius          55549.284
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04450365114
		SemiMajorAxis   0.1308
		Eccentricity    0.029
		Inclination     89.08
		ArgOfPericen    354
	}
}

Planet	"HATS-2 b"
{
	ParentBody     "HATS-2"
	Mass            427.979
	Radius          83502.656
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.003707493377
		SemiMajorAxis   0.023
		Eccentricity    0
		Inclination     87.2
		ArgOfPericen    0
	}
}

Planet	"HATS-3 b"
{
	ParentBody     "HATS-3"
	Mass            340.7922
	Radius          98730.452
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.009713694361
		SemiMajorAxis   0.0485
		Eccentricity    0
		Inclination     86.2
	}
}

Planet	"HATS-4 b"
{
	ParentBody     "HATS-4"
	Mass            420.9786
	Radius          72921.84
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006890575815
		SemiMajorAxis   0.0362
		Eccentricity    0.013
		Inclination     88.5
		ArgOfPericen    275
	}
}

Planet	"HATS-5 b"
{
	ParentBody     "HATS-5"
	Mass            75.4134
	Radius          65200.704
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01304172172
		SemiMajorAxis   0.0542
		Eccentricity    0.019
		Inclination     89.3
		ArgOfPericen    204
	}
}

Planet	"HATS-6 b"
{
	ParentBody     "HATS-6"
	Mass            101.5058
	Radius          71349.016
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009104294609
		SemiMajorAxis   0.03623
		Eccentricity    0
		Inclination     88.21
	}
}

Planet	"HATS-7 b"
{
	ParentBody     "HATS-7"
	Mass            38.184
	Radius          40249.996
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.008721103664
		SemiMajorAxis   0.04012
		Eccentricity    0
		Inclination     87.92
	}
}

Planet	"HATS-8 b"
{
	ParentBody     "HATS-8"
	Mass            43.9116
	Radius          62412.516
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009812374089
		SemiMajorAxis   0.04667
		Eccentricity    0.376
		Inclination     87.8
	}
}

Planet	"HATS-9 b"
{
	ParentBody     "HATS-9"
	Mass            266.3334
	Radius          76138.98
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.00524393773
		SemiMajorAxis   0.03048
		Eccentricity    0.129
		Inclination     86.5
	}
}

Planet	"HD 100546 b"
{
	ParentBody     "HD 100546"
	Radius          493294.8
	DiscMethod     "Imaging"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   53
	}
}

Planet	"HD 100655 b"
{
	ParentBody     "HD 100655"
	Msini           540.94
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2453072.4
		Period          0.4314123734
		SemiMajorAxis   0.76
		Eccentricity    0.085
		ArgOfPericen    132
	}
}

Planet	"HD 100777 b"
{
	ParentBody     "HD 100777"
	Msini           369.112
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453456.2
		Period          1.050535811
		SemiMajorAxis   1.03
		Eccentricity    0.36
		ArgOfPericen    202.7
	}
}

Planet	"HD 10180 c"
{
	ParentBody     "HD 10180"
	Msini           13.23712
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454001.445
		Period          0.015769509
		SemiMajorAxis   0.06412
		Eccentricity    0.073
		Inclination     90
		ArgOfPericen    328
	}
}

Planet	"HD 10180 d"
{
	ParentBody     "HD 10180"
	Msini           12.02796
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454022.119
		Period          0.04478398294
		SemiMajorAxis   0.12859
		Eccentricity    0.131
		Inclination     90
		ArgOfPericen    325
	}
}

Planet	"HD 10180 e"
{
	ParentBody     "HD 10180"
	Msini           25.6151
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454006.26
		Period          0.1362055134
		SemiMajorAxis   0.2699
		Eccentricity    0.051
		Inclination     90
		ArgOfPericen    147
	}
}

Planet	"HD 10180 f"
{
	ParentBody     "HD 10180"
	Msini           22.97404
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454024.67
		Period          0.336061943
		SemiMajorAxis   0.4929
		Eccentricity    0.119
		Inclination     90
		ArgOfPericen    327
	}
}

Planet	"HD 10180 g"
{
	ParentBody     "HD 10180"
	Msini           23.29224
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454002.8
		Period          1.655531636
		SemiMajorAxis   1.427
		Eccentricity    0.263
		Inclination     90
		ArgOfPericen    327
	}
}

Planet	"HD 10180 h"
{
	ParentBody     "HD 10180"
	Msini           65.74012
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453433.4
		Period          6.037090077
		SemiMajorAxis   3.381
		Eccentricity    0.095
		Inclination     90
		ArgOfPericen    142
	}
}

Planet	"HD 101930 b"
{
	ParentBody     "HD 101930"
	Msini           95.46
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453145
		Period          0.1929130915
		SemiMajorAxis   0.302
		Eccentricity    0.11
		ArgOfPericen    251
	}
}

Planet	"HD 102117 b"
{
	ParentBody     "HD 102117"
	Msini           54.7304
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2450942.2
		Period          0.0569849283
		SemiMajorAxis   0.1532
		Eccentricity    0.121
		ArgOfPericen    279
	}
}

Planet	"HD 102195 b"
{
	ParentBody     "HD 102195"
	Msini           143.19
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453895.96
		Period          0.01126314296
		SemiMajorAxis   0.049
		Eccentricity    0
		ArgOfPericen    360
	}
}

Planet	"HD 102272 b"
{
	ParentBody     "HD 102272"
	Msini           1877.38
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452146
		Period          0.3493024726
		SemiMajorAxis   0.614
		Eccentricity    0.05
		ArgOfPericen    118
	}
}

Planet	"HD 102272 c"
{
	ParentBody     "HD 102272"
	Mass            827.32
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           54135.5
		Period          1.423712853
		SemiMajorAxis   1.57
		Eccentricity    0.68
		ArgOfPericen    320
	}
}

Planet	"HD 102329 b"
{
	ParentBody     "HD 102329"
	Msini           1877.38
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455096
		Period          2.130367251
		SemiMajorAxis   2.03
		Eccentricity    0.211
		ArgOfPericen    182
	}
}

Planet	"HD 102365 A b"
{
	ParentBody     "HD 102365 A"
	Msini           15.91
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450129
		Period          0.3342987294
		SemiMajorAxis   0.46
		Eccentricity    0.34
		ArgOfPericen    105
	}
}

Planet	"HD 102956 b"
{
	ParentBody     "HD 102956"
	Msini           305.472
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455346
		Period          0.01778272111
		SemiMajorAxis   0.081
		Eccentricity    0.048
		ArgOfPericen    12
	}
}

Planet	"HD 103197 b"
{
	ParentBody     "HD 103197"
	Msini           31.1836
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Period          0.1309815824
		SemiMajorAxis   0.249
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 103720 b"
{
	ParentBody     "HD 103720"
	Msini           197.284
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455387.46
		Period          0.01247309354
		SemiMajorAxis   0.0498
		Eccentricity    0.086
		ArgOfPericen    262
	}
}

Planet	"HD 103774 b"
{
	ParentBody     "HD 103774"
	Msini           116.7794
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455675.4
		Period          0.01612108394
		SemiMajorAxis   0.07
		Eccentricity    0.09
		ArgOfPericen   -42
	}
}

Planet	"HD 104067 b"
{
	ParentBody     "HD 104067"
	Msini           59.1852
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454043.15
		Period          0.1527917682
		SemiMajorAxis   0.2643
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 10442 b"
{
	ParentBody     "HD 10442"
	Msini           668.22
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2457062
		Period          2.855639433
		SemiMajorAxis   2.335
		Eccentricity    0.11
		ArgOfPericen    198
	}
}

Planet	"HD 106252 b"
{
	ParentBody     "HD 106252"
	Msini           2201.944
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           51871
		Period          4.380654931
		SemiMajorAxis   2.7
		Eccentricity    0.47
		Inclination     166.7
		ArgOfPericen    292.2
	}
}

Planet	"HD 106270 b"
{
	ParentBody     "HD 106270"
	Msini           3500.2
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454830
		Period          7.912557969
		SemiMajorAxis   4.3
		Eccentricity    0.402
		ArgOfPericen    15.2
	}
}

Planet	"HD 10647 b"
{
	ParentBody     "HD 10647"
	Msini           295.926
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2453654
		Period          2.74612306
		SemiMajorAxis   2.03
		Eccentricity    0.1
		ArgOfPericen    108.9
	}
}

Planet	"HD 106515 A b"
{
	ParentBody     "HD 106515 A"
	Msini           3057.902
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2451844
		Period          9.938610875
		SemiMajorAxis   4.59
		Eccentricity    0.572
		ArgOfPericen    123.8
	}
}

Planet	"HD 106906 b"
{
	ParentBody     "HD 106906"
	Mass            3500.2
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   650
	}
}

Planet	"HD 10697 b"
{
	ParentBody     "HD 10697"
	Msini           2030.116
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451480
		Period          2.947085605
		SemiMajorAxis   2.16
		Eccentricity    0.1
		Inclination     69
		ArgOfPericen    108.9
	}
}

Planet	"HD 107148 b"
{
	ParentBody     "HD 107148"
	Msini           66.822
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2439969
		Period          0.1315729709
		SemiMajorAxis   0.269
		Eccentricity    0.05
		ArgOfPericen    75
	}
}

Planet	"HD 108147 b"
{
	ParentBody     "HD 108147"
	Msini           83.0502
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2450828.86
		Period          0.02983910485
		SemiMajorAxis   0.102
		Eccentricity    0.53
		ArgOfPericen    308
	}
}

Planet	"HD 108341 b"
{
	ParentBody     "HD 108341"
	Msini           1113.7
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456633
		Period          3.091099636
		SemiMajorAxis   2
		Eccentricity    0.85
		ArgOfPericen    190
	}
}

Planet	"HD 108863 b"
{
	ParentBody     "HD 108863"
	Msini           827.32
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455516
		Period          1.213988998
		SemiMajorAxis   1.4
		Eccentricity    0.06
		ArgOfPericen    153
	}
}

Planet	"HD 108874 b"
{
	ParentBody     "HD 108874"
	Msini           410.478
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2454069
		Period          1.083664514
		SemiMajorAxis   1.038
		Eccentricity    0.082
		ArgOfPericen    232
	}
}

Planet	"HD 108874 c"
{
	ParentBody     "HD 108874"
	Msini           315.018
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2452839
		Period          4.446364755
		SemiMajorAxis   2.659
		Eccentricity    0.239
		ArgOfPericen    27
	}
}

Planet	"HD 109246 b"
{
	ParentBody     "HD 109246"
	Msini           245.014
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454824.6
		Period          0.1869170701
		SemiMajorAxis   0.33
		Eccentricity    0.12
		ArgOfPericen    235
	}
}

Planet	"HD 109271 b"
{
	ParentBody     "HD 109271"
	Msini           17.1828
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455719.1
		Period          0.02150436127
		SemiMajorAxis   0.079
		Eccentricity    0.25
		ArgOfPericen   -64
	}
}

Planet	"HD 109271 c"
{
	ParentBody     "HD 109271"
	Msini           24.1832
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455733
		Period          0.08468353564
		SemiMajorAxis   0.196
		Eccentricity    0.15
		ArgOfPericen    4
	}
}

Planet	"HD 109749 A b"
{
	ParentBody     "HD 109749 A"
	Msini           89.096
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453013.55
		Period          0.0143466449
		SemiMajorAxis   0.0635
		Eccentricity    0.01
		ArgOfPericen    0
	}
}

Planet	"HD 110014 b"
{
	ParentBody     "HD 110014"
	Msini           3528.838
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2451796.907
		Period          2.287460275
		SemiMajorAxis   2.14
		Eccentricity    0.462
		ArgOfPericen    290.6
	}
}

Planet	"HD 111232 b"
{
	ParentBody     "HD 111232"
	Msini           2163.76
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451230
		Period          3.129430366
		SemiMajorAxis   1.97
		Eccentricity    0.2
		ArgOfPericen    98
	}
}

Planet	"HD 113337 b"
{
	ParentBody     "HD 113337"
	Msini           900.506
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456074.5
		Period          0.8870826235
		SemiMajorAxis   0.92
		Eccentricity    0.46
		ArgOfPericen   -140.8
	}
}

Planet	"HD 113538 b"
{
	ParentBody     "HD 113538"
	Msini           114.552
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455500
		Period          1.815781469
		SemiMajorAxis   1.24
		Eccentricity    0.14
		ArgOfPericen    74
	}
}

Planet	"HD 113538 c"
{
	ParentBody     "HD 113538"
	Msini           295.926
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2456741
		Period          4.977519165
		SemiMajorAxis   2.44
		Eccentricity    0.2
		ArgOfPericen    280
	}
}

Planet	"HD 114386 b"
{
	ParentBody     "HD 114386"
	Msini           394.568
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2450454
		Period          2.567337581
		SemiMajorAxis   1.65
		Eccentricity    0.23
		ArgOfPericen    273
	}
}

Planet	"HD 114386 c"
{
	ParentBody     "HD 114386"
	Mass            378.658
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          2.863853161
		Eccentricity    0.06
	}
}

Planet	"HD 114613 b"
{
	ParentBody     "HD 114613"
	Msini           152.736
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455550.3
		Period          10.47797901
		SemiMajorAxis   5.16
		Eccentricity    0.25
		ArgOfPericen    244
	}
}

Planet	"HD 114729 A b"
{
	ParentBody     "HD 114729 A"
	Msini           267.288
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2450520
		Period          3.107527092
		SemiMajorAxis   2.08
		Eccentricity    0.32
		ArgOfPericen    73
	}
}

Planet	"HD 114762 b"
{
	ParentBody     "HD 114762"
	Msini           3493.836
	DiscMethod     "RadVel"
	DiscDate       "1989"
	Orbit
	{
		Epoch           2449889.106
		Period          0.2297519354
		SemiMajorAxis   0.353
		Eccentricity    0.3354
		ArgOfPericen    201.28
	}
}

Planet	"HD 114783 b"
{
	ParentBody     "HD 114783"
	Msini           350.02
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2453806
		Period          1.351705837
		SemiMajorAxis   1.16
		Eccentricity    0.144
		Inclination     10
		ArgOfPericen    86
	}
}

Planet	"HD 11506 b"
{
	ParentBody     "HD 11506"
	Msini           1339.622
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2456637.2
		Period          4.455947438
		SemiMajorAxis   2.708
		Eccentricity    0.37
		ArgOfPericen    218.9
	}
}

Planet	"HD 11506 c"
{
	ParentBody     "HD 11506"
	Msini           114.552
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454127
		Period          0.6121965266
		SemiMajorAxis   0.721
		Eccentricity    0.24
		ArgOfPericen    272
	}
}

Planet	"HD 116029 b"
{
	ParentBody     "HD 116029"
	Msini           668.22
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455220
		Period          1.834399252
		SemiMajorAxis   1.78
		Eccentricity    0.054
		ArgOfPericen    40
	}
}

Planet	"HD 117207 b"
{
	ParentBody     "HD 117207"
	Msini           598.216
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2450630
		Period          7.110350535
		SemiMajorAxis   3.79
		Eccentricity    0.144
		ArgOfPericen    73
	}
}

Planet	"HD 11755 b"
{
	ParentBody     "HD 11755"
	Msini           2068.3
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2457018.2
		Period          1.187431277
		SemiMajorAxis   1.08
		Eccentricity    0.19
		ArgOfPericen    155.3
	}
}

Planet	"HD 117618 b"
{
	ParentBody     "HD 117618"
	Msini           56.6396
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2450832.2
		Period          0.07071198432
		SemiMajorAxis   0.176
		Eccentricity    0.42
		ArgOfPericen    245
	}
}

Planet	"HD 117618 c"
{
	ParentBody     "HD 117618"
	Mass            63.64
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.8706551675
		SemiMajorAxis   0.93
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 118203 b"
{
	ParentBody     "HD 118203"
	Msini           677.766
	Radius          75066.6
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453351.2
		Period          0.01679220027
		SemiMajorAxis   0.07
		Eccentricity    0.2943
		ArgOfPericen    332.7
	}
}

Planet	"HD 11964 b"
{
	ParentBody     "HD 11964"
	Msini           197.9204
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2454170
		Period          5.325233651
		SemiMajorAxis   3.16
		Eccentricity    0.041
		ArgOfPericen    155
	}
}

Planet	"HD 11964 c"
{
	ParentBody     "HD 11964"
	Msini           25.07416
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2454370
		Period          0.1037941428
		SemiMajorAxis   0.229
		Eccentricity    0.3
		ArgOfPericen    102
	}
}

Planet	"HD 11977 b"
{
	ParentBody     "HD 11977"
	Msini           2001.478
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2451420
		Period          1.946653535
		SemiMajorAxis   1.89
		Eccentricity    0.4
		ArgOfPericen    351.5
	}
}

Planet	"HD 120084 b"
{
	ParentBody     "HD 120084"
	Msini           1431.9
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2450774
		Period          5.700327229
		SemiMajorAxis   4.3
		Eccentricity    0.66
		ArgOfPericen    117
	}
}

Planet	"HD 121504 b"
{
	ParentBody     "HD 121504"
	Msini           388.204
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451450
		Period          0.173391798
		SemiMajorAxis   0.33
		Eccentricity    0.03
		ArgOfPericen    265
	}
}

Planet	"HD 122430 b"
{
	ParentBody     "HD 122430"
	Mass            1180.522
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451986.71
		Period          0.944441824
		SemiMajorAxis   1.02
		Eccentricity    0.68
		ArgOfPericen    91.04
	}
}

Planet	"HD 122562 b"
{
	ParentBody     "HD 122562"
	Msini           7636.8
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455935
		Period          7.603174215
		SemiMajorAxis   4.1
		Eccentricity    0.71
		ArgOfPericen    306.1
	}
}

Planet	"HD 12484 b"
{
	ParentBody     "HD 12484"
	Msini           948.236
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456699
		Period          0.161071206
		SemiMajorAxis   0.297
		Eccentricity    0.07
		ArgOfPericen   -35
	}
}

Planet	"HD 125595 b"
{
	ParentBody     "HD 125595"
	Msini           13.0462
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454435.23
		Period          0.0264857135
		SemiMajorAxis   0.0809
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 125612 b"
{
	ParentBody     "HD 125612"
	Msini           954.6
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454894.9
		Period          1.53158648
		SemiMajorAxis   1.37
		Eccentricity    0.46
		ArgOfPericen    41.5
	}
}

Planet	"HD 125612 c"
{
	ParentBody     "HD 125612"
	Msini           18.4556
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           54420.17
		Period          0.0113751919
		SemiMajorAxis   0.05
		Eccentricity    0.27
		ArgOfPericen    103
	}
}

Planet	"HD 125612 d"
{
	ParentBody     "HD 125612"
	Msini           2291.04
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           57174
		Period          8.23563127
		SemiMajorAxis   4.2
		Eccentricity    0.28
		ArgOfPericen   -76
	}
}

Planet	"HD 12648 b"
{
	ParentBody     "HD 12648"
	Msini           922.78
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2452324.7
		Period          0.3657846867
		SemiMajorAxis   0.54
		Eccentricity    0.04
		ArgOfPericen    99.3
	}
}

Planet	"HD 126525 b"
{
	ParentBody     "HD 126525"
	Mass            71.2768
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          2.595866596
		SemiMajorAxis   1.8105
		Eccentricity    0.13
	}
}

Planet	"HD 12661 b"
{
	ParentBody     "HD 12661"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2454152.76
		Period          0.7217128999
		SemiMajorAxis   0.83
		Eccentricity    0.377
		ArgOfPericen    296
	}
}

Planet	"HD 12661 c"
{
	ParentBody     "HD 12661"
	Msini           610.944
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2446153.76
		Period          4.676349139
		SemiMajorAxis   2.56
		Eccentricity    0.031
		ArgOfPericen    165
	}
}

Planet	"HD 126614 b"
{
	ParentBody     "HD 126614"
	Msini           120.916
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453808
		Period          3.405959209
		SemiMajorAxis   2.35
		Eccentricity    0.41
		ArgOfPericen    243
	}
}

Planet	"HD 128311 b"
{
	ParentBody     "HD 128311"
	Msini           562.8958
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2450198.691
		Period          1.240324948
		SemiMajorAxis   1.084
		Eccentricity    0.303
		Inclination     30
		ArgOfPericen    57.864
	}
}

Planet	"HD 128311 c"
{
	ParentBody     "HD 128311"
	Msini           994.375
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2449565.615
		Period          2.52308749
		SemiMajorAxis   1.74
		Eccentricity    0.159
		Inclination     55.95
		ArgOfPericen    15.445
	}
}

Planet	"HD 128356 b"
{
	ParentBody     "HD 128356"
	Msini           283.198
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          0.8164445628
		SemiMajorAxis   0.87
		Eccentricity    0.57
		ArgOfPericen    84
	}
}

Planet	"HD 129445 b"
{
	ParentBody     "HD 129445"
	Msini           509.12
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453093
		Period          5.037753171
		SemiMajorAxis   2.9
		Eccentricity    0.7
		ArgOfPericen    163
	}
}

Planet	"HD 130322 b"
{
	ParentBody     "HD 130322"
	Msini           365.93
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2453996.4
		Period          0.02931947704
		SemiMajorAxis   0.0925
		Eccentricity    0.029
		Inclination     76
		ArgOfPericen    193
	}
}

Planet	"HD 131496 b"
{
	ParentBody     "HD 131496"
	Msini           700.04
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2456040
		Period          2.41757394
		SemiMajorAxis   2.09
		Eccentricity    0.163
		ArgOfPericen    34
	}
}

Planet	"HD 131664 b"
{
	ParentBody     "HD 131664"
	Msini           5775.33
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452060
		Period          5.341661107
		SemiMajorAxis   3.17
		Eccentricity    0.638
		ArgOfPericen    149.7
	}
}

Planet	"HD 13189 b"
{
	ParentBody     "HD 13189"
	Msini           4454.8
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2452327.9
		Period          1.291198041
		SemiMajorAxis   1.85
		Eccentricity    0.27
		ArgOfPericen    160.7
	}
}

Planet	"HD 132406 b"
{
	ParentBody     "HD 132406"
	Msini           1785.102
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453474
		Period          2.666723689
		SemiMajorAxis   1.98
		Eccentricity    0.34
		ArgOfPericen    214
	}
}

Planet	"HD 132563 B b"
{
	ParentBody     "HD 132563 B"
	Msini           474.118
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2452593
		Period          4.227332008
		SemiMajorAxis   2.62
		Eccentricity    0.22
		ArgOfPericen    158
	}
}

Planet	"HD 134060 b"
{
	ParentBody     "HD 134060"
	Mass            11.16882
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008952963515
		SemiMajorAxis   0.0444
		Eccentricity    0.4
	}
}

Planet	"HD 134060 c"
{
	ParentBody     "HD 134060"
	Mass            47.95274
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          3.178438943
		SemiMajorAxis   2.2263
		Eccentricity    0.75
	}
}

Planet	"HD 134113 b"
{
	ParentBody     "HD 134113"
	Msini           14955.4
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456808.54
		Period          0.5521815541
		SemiMajorAxis   0.638
		Eccentricity    0.0891
		ArgOfPericen    163
	}
}

Planet	"HD 134606 b"
{
	ParentBody     "HD 134606"
	Mass            9.29144
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03308215846
		SemiMajorAxis   0.1023
		Eccentricity    0.15
	}
}

Planet	"HD 134606 c"
{
	ParentBody     "HD 134606"
	Mass            12.15524
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1629576255
		SemiMajorAxis   0.2962
		Eccentricity    0.29
	}
}

Planet	"HD 134606 d"
{
	ParentBody     "HD 134606"
	Mass            38.5022
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          1.25741224
		SemiMajorAxis   1.1567
		Eccentricity    0.46
	}
}

Planet	"HD 134987 b"
{
	ParentBody     "HD 134987"
	Msini           505.938
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2450071
		Period          0.7069008104
		SemiMajorAxis   0.81
		Eccentricity    0.233
		ArgOfPericen    352.7
	}
}

Planet	"HD 134987 c"
{
	ParentBody     "HD 134987"
	Msini           260.924
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2461100
		Period          13.68954666
		SemiMajorAxis   5.8
		Eccentricity    0.12
		ArgOfPericen    195
	}
}

Planet	"HD 136352 b"
{
	ParentBody     "HD 136352"
	Mass            5.28212
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03169677634
		SemiMajorAxis   0.0933
		Eccentricity    0.18
	}
}

Planet	"HD 136352 c"
{
	ParentBody     "HD 136352"
	Mass            11.39156
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.07551701519
		SemiMajorAxis   0.1665
		Eccentricity    0.16
	}
}

Planet	"HD 136352 d"
{
	ParentBody     "HD 136352"
	Mass            9.546
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2921896839
		SemiMajorAxis   0.411
		Eccentricity    0.43
	}
}

Planet	"HD 136418 b"
{
	ParentBody     "HD 136418"
	Msini           636.4
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2455228
		Period          1.271211303
		SemiMajorAxis   1.32
		Eccentricity    0.255
		ArgOfPericen    12
	}
}

Planet	"HD 137388 b"
{
	ParentBody     "HD 137388"
	Msini           70.9586
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455209
		Period          0.9035100795
		SemiMajorAxis   0.89
		Eccentricity    0.36
		ArgOfPericen    86
	}
}

Planet	"HD 13808 b"
{
	ParentBody     "HD 13808"
	Mass            10.3415
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03882903015
		SemiMajorAxis   0.1017
		Eccentricity    0.17
	}
}

Planet	"HD 13808 c"
{
	ParentBody     "HD 13808"
	Mass            11.4552
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1473871352
		SemiMajorAxis   0.2476
		Eccentricity    0.43
	}
}

Planet	"HD 13908 b"
{
	ParentBody     "HD 13908"
	Msini           275.243
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455750.93
		Period          0.05306615867
		SemiMajorAxis   0.154
		Eccentricity    0.046
		ArgOfPericen    185
	}
}

Planet	"HD 13908 c"
{
	ParentBody     "HD 13908"
	Msini           1632.366
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456165
		Period          2.548993588
		SemiMajorAxis   2.03
		Eccentricity    0.12
		ArgOfPericen    185
	}
}

Planet	"HD 13931 b"
{
	ParentBody     "HD 13931"
	Msini           598.216
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454494
		Period          11.54850156
		SemiMajorAxis   5.15
		Eccentricity    0.02
		ArgOfPericen    290
	}
}

Planet	"HD 139357 b"
{
	ParentBody     "HD 139357"
	Msini           3105.632
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452466.7
		Period          3.082064535
		SemiMajorAxis   2.36
		Eccentricity    0.1
		ArgOfPericen    235.4
	}
}

Planet	"HD 14067 b"
{
	ParentBody     "HD 14067"
	Msini           2481.96
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2451443
		Period          3.983658078
		SemiMajorAxis   3.4
		Eccentricity    0.533
		ArgOfPericen    109.9
	}
}

Planet	"HD 141399 b"
{
	ParentBody     "HD 141399"
	Msini           143.5082
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456998
		Period          0.2585681573
		SemiMajorAxis   0.415
		Eccentricity    0.04
		ArgOfPericen   -90
	}
}

Planet	"HD 141399 c"
{
	ParentBody     "HD 141399"
	Msini           423.206
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456838
		Period          0.553030306
		SemiMajorAxis   0.689
		Eccentricity    0.048
		ArgOfPericen   -140
	}
}

Planet	"HD 141399 d"
{
	ParentBody     "HD 141399"
	Msini           375.476
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456923
		Period          2.929015403
		SemiMajorAxis   2.09
		Eccentricity    0.074
		ArgOfPericen   -140
	}
}

Planet	"HD 141399 e"
{
	ParentBody     "HD 141399"
	Msini           210.012
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2458900
		Period          13.68954666
		SemiMajorAxis   5
		Eccentricity    0.26
		ArgOfPericen   -10
	}
}

Planet	"HD 141937 b"
{
	ParentBody     "HD 141937"
	Msini           3086.54
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451847.38
		Period          1.788457134
		SemiMajorAxis   1.52
		Eccentricity    0.41
		ArgOfPericen    187.72
	}
}

Planet	"HD 142 b"
{
	ParentBody     "HD 142"
	Msini           397.75
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2452683
		Period          0.9574468934
		SemiMajorAxis   1.02
		Eccentricity    0.17
		ArgOfPericen    327
	}
}

Planet	"HD 142 c"
{
	ParentBody     "HD 142"
	Msini           1686.46
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455954
		Period          16.44114554
		SemiMajorAxis   6.8
		Eccentricity    0.21
		ArgOfPericen    250
	}
}

Planet	"HD 142022 A b"
{
	ParentBody     "HD 142022 A"
	Msini           1622.82
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           50941
		Period          5.278689192
		SemiMajorAxis   3.03
		Eccentricity    0.53
		Inclination     10
		ArgOfPericen    170
	}
}

Planet	"HD 142245 b"
{
	ParentBody     "HD 142245"
	Msini           604.58
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454760
		Period          3.556544222
		SemiMajorAxis   2.77
		Eccentricity    0.09
		ArgOfPericen    242
	}
}

Planet	"HD 142415 b"
{
	ParentBody     "HD 142415"
	Msini           515.484
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451519
		Period          1.057654375
		SemiMajorAxis   1.05
		Eccentricity    0.5
		ArgOfPericen    255
	}
}

Planet	"HD 143105 b"
{
	ParentBody     "HD 143105"
	Msini           385.022
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456531.344
		Period          0.006016281966
		SemiMajorAxis   0.0379
		Eccentricity    0.07
	}
}

Planet	"HD 143361 b"
{
	ParentBody     "HD 143361"
	Msini           992.784
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453746
		Period          2.893970164
		SemiMajorAxis   2
		Eccentricity    0.15
		ArgOfPericen    237
	}
}

Planet	"HD 145377 b"
{
	ParentBody     "HD 145377"
	Msini           1832.832
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454635.4
		Period          0.2846056751
		SemiMajorAxis   0.45
		Eccentricity    0.307
		ArgOfPericen    138.1
	}
}

Planet	"HD 145457 b"
{
	ParentBody     "HD 145457"
	Msini           922.78
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453518
		Period          0.4826934152
		SemiMajorAxis   0.76
		Eccentricity    0.112
		ArgOfPericen    300
	}
}

Planet	"HD 145934 b"
{
	ParentBody     "HD 145934"
	Msini           725.496
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2451430
		Period          7.474492476
		SemiMajorAxis   4.6
		Eccentricity    0.053
		ArgOfPericen    215
	}
}

Planet	"HD 1461 b"
{
	ParentBody     "HD 1461"
	Msini           6.446732
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450366.936
		Period          0.01580189847
		SemiMajorAxis   0.0634
		Eccentricity    0.172
		ArgOfPericen    58
	}
}

Planet	"HD 1461 c"
{
	ParentBody     "HD 1461"
	Msini           5.597138
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.03697601311
		SemiMajorAxis   0.1117
		Eccentricity    0.305
	}
}

Planet	"HD 147018 b"
{
	ParentBody     "HD 147018"
	Msini           674.584
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           4459.49
		Period          0.1211141572
		SemiMajorAxis   0.2388
		Eccentricity    0.4686
		ArgOfPericen   -24.03
	}
}

Planet	"HD 147018 c"
{
	ParentBody     "HD 147018"
	Msini           2087.392
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           55301
		Period          2.759812607
		SemiMajorAxis   1.922
		Eccentricity    0.133
		ArgOfPericen   -133.1
	}
}

Planet	"HD 147513 b"
{
	ParentBody     "HD 147513"
	Msini           385.022
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451123
		Period          1.446711291
		SemiMajorAxis   1.32
		Eccentricity    0.26
		ArgOfPericen    282
	}
}

Planet	"HD 147873 b"
{
	ParentBody     "HD 147873"
	Msini           1635.548
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3192292765
		SemiMajorAxis   0.522
		Eccentricity    0.207
		ArgOfPericen    80
	}
}

Planet	"HD 147873 c"
{
	ParentBody     "HD 147873"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          1.345791953
		SemiMajorAxis   1.36
		Eccentricity    0.23
		ArgOfPericen    42
	}
}

Planet	"HD 148156 b"
{
	ParentBody     "HD 148156"
	Msini           270.47
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454707
		Period          2.811832884
		SemiMajorAxis   2.45
		Eccentricity    0.52
		ArgOfPericen    35
	}
}

Planet	"HD 148427 b"
{
	ParentBody     "HD 148427"
	Msini           305.472
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453991
		Period          0.9076169435
		SemiMajorAxis   0.93
		Eccentricity    0.16
		ArgOfPericen    277
	}
}

Planet	"HD 149143 b"
{
	ParentBody     "HD 149143"
	Msini           432.752
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453588
		Period          0.01119257335
		SemiMajorAxis   0.052
		Eccentricity    0.08
		ArgOfPericen    42
	}
}

Planet	"HD 1502 b"
{
	ParentBody     "HD 1502"
	Msini           986.42
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455227
		Period          1.18222925
		SemiMajorAxis   1.31
		Eccentricity    0.101
		ArgOfPericen    219
	}
}

Planet	"HD 150433 b"
{
	ParentBody     "HD 150433"
	Mass            53.4576
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          3.00129621
		SemiMajorAxis   1.9303
		Eccentricity    0
	}
}

Planet	"HD 150706 b"
{
	ParentBody     "HD 150706"
	Msini           862.322
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2458179
		Period          16.1372376
		SemiMajorAxis   6.7
		Eccentricity    0.38
		ArgOfPericen    132
	}
}

Planet	"HD 152079 b"
{
	ParentBody     "HD 152079"
	Msini           954.6
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453193
		Period          5.741395869
		SemiMajorAxis   3.2
		Eccentricity    0.6
		ArgOfPericen    325
	}
}

Planet	"HD 152581 b"
{
	ParentBody     "HD 152581"
	Msini           477.3
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455320
		Period          1.88641953
		SemiMajorAxis   1.48
		Eccentricity    0.074
		ArgOfPericen    321
	}
}

Planet	"HD 153950 b"
{
	ParentBody     "HD 153950"
	Msini           868.686
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454502
		Period          1.36731192
		SemiMajorAxis   1.28
		Eccentricity    0.34
		ArgOfPericen    308.2
	}
}

Planet	"HD 154088 b"
{
	ParentBody     "HD 154088"
	Mass            6.14126
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.05091416194
		SemiMajorAxis   0.1316
		Eccentricity    0.38
	}
}

Planet	"HD 154345 b"
{
	ParentBody     "HD 154345"
	Msini           301.3354
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2452830
		Period          9.150092987
		SemiMajorAxis   4.19
		Eccentricity    0.044
		Inclination     50
		ArgOfPericen    68
	}
}

Planet	"HD 154672 b"
{
	ParentBody     "HD 154672"
	Msini           1597.364
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454520
		Period          0.4487707186
		SemiMajorAxis   0.6
		Eccentricity    0.61
		ArgOfPericen    265
	}
}

Planet	"HD 154857 b"
{
	ParentBody     "HD 154857"
	Msini           712.768
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2453572.5
		Period          1.118709753
		SemiMajorAxis   1.291
		Eccentricity    0.46
		ArgOfPericen    57
	}
}

Planet	"HD 154857 c"
{
	ParentBody     "HD 154857"
	Msini           820.956
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455219
		Period          9.451263014
		SemiMajorAxis   5.36
		Eccentricity    0.06
		ArgOfPericen    352
	}
}

Planet	"HD 155233 b"
{
	ParentBody     "HD 155233"
	Msini           827.32
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2460282
		Period          2.241800161
		SemiMajorAxis   2
		Eccentricity    0.04
		ArgOfPericen    120
	}
}

Planet	"HD 155358 b"
{
	ParentBody     "HD 155358"
	Msini           270.47
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2451224.8
		Period          0.5319757832
		SemiMajorAxis   0.64
		Eccentricity    0.17
		ArgOfPericen    143
	}
}

Planet	"HD 155358 c"
{
	ParentBody     "HD 155358"
	Msini           260.924
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2455345.4
		Period          1.072986667
		SemiMajorAxis   1.02
		Eccentricity    0.16
		ArgOfPericen    180
	}
}

Planet	"HD 156279 b"
{
	ParentBody     "HD 156279"
	Msini           3089.722
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455525.59
		Period          0.3588030179
		SemiMajorAxis   0.495
		Eccentricity    0.708
		ArgOfPericen    264.2
	}
}

Planet	"HD 156411 b"
{
	ParentBody     "HD 156411"
	Msini           235.468
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454356
		Period          2.305867239
		SemiMajorAxis   1.88
		Eccentricity    0.22
		ArgOfPericen    45
	}
}

Planet	"HD 156668 b"
{
	ParentBody     "HD 156668"
	Msini           4.1366
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454718.57
		Period          0.0127189578
		SemiMajorAxis   0.05
		Eccentricity    0
	}
}

Planet	"HD 156846 b"
{
	ParentBody     "HD 156846"
	Msini           3363.374
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2455076.686
		Period          0.9844278947
		SemiMajorAxis   1.096
		Eccentricity    0.84785
		ArgOfPericen    51.62
	}
}

Planet	"HD 157172 b"
{
	ParentBody     "HD 157172"
	Mass            38.184
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2870424144
		SemiMajorAxis   0.416
		Eccentricity    0.46
	}
}

Planet	"HD 158038 b"
{
	ParentBody     "HD 158038"
	Msini           572.76
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455491
		Period          1.426450762
		SemiMajorAxis   1.52
		Eccentricity    0.291
		ArgOfPericen    335
	}
}

Planet	"HD 159243 b"
{
	ParentBody     "HD 159243"
	Msini           359.566
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456426.11
		Period          0.03455241577
		SemiMajorAxis   0.11
		Eccentricity    0.02
		ArgOfPericen    223
	}
}

Planet	"HD 159243 c"
{
	ParentBody     "HD 159243"
	Msini           604.58
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456484
		Period          0.680096678
		SemiMajorAxis   0.8
		Eccentricity    0.075
		ArgOfPericen    69
	}
}

Planet	"HD 159868 b"
{
	ParentBody     "HD 159868"
	Msini           668.22
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453435
		Period          3.226352357
		SemiMajorAxis   2.25
		Eccentricity    0.01
		ArgOfPericen    350
	}
}

Planet	"HD 159868 c"
{
	ParentBody     "HD 159868"
	Msini           232.286
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453239
		Period          0.9645654576
		SemiMajorAxis   1
		Eccentricity    0.15
		ArgOfPericen    290
	}
}

Planet	"HD 1605 b"
{
	ParentBody     "HD 1605"
	Msini           305.472
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2453443.3
		Period          1.582237803
		SemiMajorAxis   1.48
		Eccentricity    0.078
		ArgOfPericen    26.65
	}
}

Planet	"HD 1605 c"
{
	ParentBody     "HD 1605"
	Msini           1107.336
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2454758.3
		Period          5.7797266
		SemiMajorAxis   3.52
		Eccentricity    0.098
		ArgOfPericen    240
	}
}

Planet	"HD 160508 b"
{
	ParentBody     "HD 160508"
	Msini           15273.6
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455998.7
		Period          0.4898253952
		SemiMajorAxis   0.68
		Eccentricity    0.5967
		ArgOfPericen    191.17
	}
}

Planet	"HD 16141 b"
{
	ParentBody     "HD 16141"
	Msini           82.732
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2450338.1
		Period          0.2067751265
		SemiMajorAxis   0.363
		Eccentricity    0.252
		ArgOfPericen    42
	}
}

Planet	"HD 16175 b"
{
	ParentBody     "HD 16175"
	Msini           1517.814
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2455801.4
		Period          2.725314949
		SemiMajorAxis   2.148
		Eccentricity    0.637
		ArgOfPericen    221.5
	}
}

Planet	"HD 162020 b"
{
	ParentBody     "HD 162020"
	Msini           4582.08
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451990.677
		Period          0.02307564196
		SemiMajorAxis   0.074
		Eccentricity    0.277
		ArgOfPericen   -27.328
	}
}

Planet	"HD 163607 b"
{
	ParentBody     "HD 163607"
	Msini           245.014
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454185
		Period          0.2059701811
		SemiMajorAxis   0.36
		Eccentricity    0.73
		ArgOfPericen    78.7
	}
}

Planet	"HD 163607 c"
{
	ParentBody     "HD 163607"
	Msini           728.678
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455085
		Period          3.597612862
		SemiMajorAxis   2.42
		Eccentricity    0.12
		ArgOfPericen    265
	}
}

Planet	"HD 16417 b"
{
	ParentBody     "HD 16417"
	Msini           21.9558
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2450099.74
		Period          0.04720155688
		SemiMajorAxis   0.14
		Eccentricity    0.2
		ArgOfPericen    77
	}
}

Planet	"HD 164509 b"
{
	ParentBody     "HD 164509"
	Msini           152.736
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455703
		Period          0.7731855953
		SemiMajorAxis   0.875
		Eccentricity    0.26
		ArgOfPericen    324
	}
}

Planet	"HD 164595 b"
{
	ParentBody     "HD 164595"
	Msini           16.158196
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2456280
		Period          0.1095163733
		SemiMajorAxis   0.23
		Eccentricity    0.088
		ArgOfPericen    145
	}
}

Planet	"HD 164604 b"
{
	ParentBody     "HD 164604"
	Msini           859.14
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2452674
		Period          1.660268219
		SemiMajorAxis   1.13
		Eccentricity    0.24
		ArgOfPericen    51
	}
}

Planet	"HD 164922 b"
{
	ParentBody     "HD 164922"
	Msini           114.552
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2451100
		Period          3.162285278
		SemiMajorAxis   2.11
		Eccentricity    0.05
		ArgOfPericen    195
	}
}

Planet	"HD 165155 b"
{
	ParentBody     "HD 165155"
	Msini           919.598
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          1.189621605
		SemiMajorAxis   1.13
		Eccentricity    0.2
		ArgOfPericen    211
	}
}

Planet	"HD 1666 b"
{
	ParentBody     "HD 1666"
	Msini           2046.026
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2453526.3
		Period          0.7392355196
		SemiMajorAxis   0.94
		Eccentricity    0.63
		ArgOfPericen    295
	}
}

Planet	"HD 166724 b"
{
	ParentBody     "HD 166724"
	Msini           1123.246
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453212
		Period          14.0838056
		SemiMajorAxis   5.42
		Eccentricity    0.734
		ArgOfPericen    202.3
	}
}

Planet	"HD 167042 b"
{
	ParentBody     "HD 167042"
	Msini           540.94
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454230.1
		Period          1.15203011
		SemiMajorAxis   1.32
		Eccentricity    0.089
		ArgOfPericen    85.7
	}
}

Planet	"HD 168443 b"
{
	ParentBody     "HD 168443"
	Msini           2437.0938
	DiscMethod     "RadVel"
	DiscDate       "1998"
	Orbit
	{
		Epoch           2455626.199
		Period          0.1591066739
		SemiMajorAxis   0.2931
		Eccentricity    0.52883
		ArgOfPericen    172.923
	}
}

Planet	"HD 168443 c"
{
	ParentBody     "HD 168443"
	Msini           5470.8126
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2455521.3
		Period          4.790875886
		SemiMajorAxis   2.8373
		Eccentricity    0.2113
		Inclination     35.7
		ArgOfPericen    64.87
	}
}

Planet	"HD 168746 b"
{
	ParentBody     "HD 168746"
	Msini           78.9136
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451757.83
		Period          0.01753357136
		SemiMajorAxis   0.0659
		Eccentricity    0.107
		ArgOfPericen    17
	}
}

Planet	"HD 1690 b"
{
	ParentBody     "HD 1690"
	Msini           1941.02
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454449
		Period          1.459305674
		SemiMajorAxis   1.3
		Eccentricity    0.64
		ArgOfPericen    122
	}
}

Planet	"HD 169142 b"
{
	ParentBody     "HD 169142"
	Mass            9546
	DiscMethod     "Imaging"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   22.7
	}
}

Planet	"HD 169830 b"
{
	ParentBody     "HD 169830"
	Msini           916.416
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451923
		Period          0.6177271035
		SemiMajorAxis   0.81
		Eccentricity    0.31
		ArgOfPericen    148
	}
}

Planet	"HD 169830 c"
{
	ParentBody     "HD 169830"
	Msini           1285.528
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2452516
		Period          5.755085416
		SemiMajorAxis   3.6
		Eccentricity    0.33
		ArgOfPericen    252
	}
}

Planet	"HD 170469 b"
{
	ParentBody     "HD 170469"
	Msini           213.194
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2451669
		Period          3.134906185
		SemiMajorAxis   2.1
		Eccentricity    0.11
		ArgOfPericen    34
	}
}

Planet	"HD 17092 b"
{
	ParentBody     "HD 17092"
	Msini           1463.72
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2452969.5
		Period          0.9853735686
		SemiMajorAxis   1.29
		Eccentricity    0.166
		ArgOfPericen    347.4
	}
}

Planet	"HD 171028 b"
{
	ParentBody     "HD 171028"
	Msini           630.036
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454187
		Period          1.505850133
		SemiMajorAxis   1.32
		Eccentricity    0.59
		ArgOfPericen    304
	}
}

Planet	"HD 171238 b"
{
	ParentBody     "HD 171238"
	Msini           827.32
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           5062
		Period          4.169835913
		SemiMajorAxis   2.54
		Eccentricity    0.4
		ArgOfPericen    47
	}
}

Planet	"HD 17156 b"
{
	ParentBody     "HD 17156"
	Mass            1015.3762
	Radius          78283.74
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Epoch           3738.529
		Period          0.0580885738
		SemiMajorAxis   0.1623
		Eccentricity    0.6768
		Inclination     87.21
		ArgOfPericen    121.71
	}
}

Planet	"HD 173416 b"
{
	ParentBody     "HD 173416"
	Msini           859.14
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453465.8
		Period          0.8859874598
		SemiMajorAxis   1.16
		Eccentricity    0.21
		ArgOfPericen    254
	}
}

Planet	"HD 175167 b"
{
	ParentBody     "HD 175167"
	Msini           2481.96
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453598
		Period          3.531903038
		SemiMajorAxis   2.4
		Eccentricity    0.54
		ArgOfPericen    342
	}
}

Planet	"HD 175541 b"
{
	ParentBody     "HD 175541"
	Msini           194.102
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2450213
		Period          0.8139804444
		SemiMajorAxis   1.03
		Eccentricity    0.33
		ArgOfPericen    183
	}
}

Planet	"HD 175607 b"
{
	ParentBody     "HD 175607"
	Msini           9.00506
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2455532.17
		Period          0.07942674972
		Eccentricity    0.11
		ArgOfPericen    142.2
	}
}

Planet	"HD 176051 A b"
{
	ParentBody     "HD 176051 A"
	Mass            477.3
	DiscMethod     "Astrometry"
	DiscDate       "2010"
	Orbit
	{
		Period          2.781715881
		SemiMajorAxis   1.76
		Eccentricity    0
	}
}

Planet	"HD 177830 b"
{
	ParentBody     "HD 177830"
	Msini           474.118
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2450154
		Period          1.113233934
		SemiMajorAxis   1.2218
		Eccentricity    0.009
		ArgOfPericen    85
	}
}

Planet	"HD 177830 c"
{
	ParentBody     "HD 177830"
	Msini           47.73
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450179
		Period          0.3036341449
		SemiMajorAxis   0.5137
		Eccentricity    0.3
		ArgOfPericen    110
	}
}

Planet	"HD 178911 B b"
{
	ParentBody     "HD 178911 B"
	Msini           2236.946
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2453808.1
		Period          0.1957167107
		SemiMajorAxis   0.339
		Eccentricity    0.114
		ArgOfPericen    168.2
	}
}

Planet	"HD 179079 b"
{
	ParentBody     "HD 179079"
	Msini           27.55612
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454400.5
		Period          0.03963397549
		SemiMajorAxis   0.1216
		Eccentricity    0.115
		ArgOfPericen    357
	}
}

Planet	"HD 179949 b"
{
	ParentBody     "HD 179949"
	Msini           291.4712
	Radius          75066.6
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2452419.1
		Period          0.008466984609
		SemiMajorAxis   0.045
		Eccentricity    0.0104
		ArgOfPericen    189.3
	}
}

Planet	"HD 180314 b"
{
	ParentBody     "HD 180314"
	Msini           7000.4
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2453565.9
		Period          1.084294233
		SemiMajorAxis   1.4
		Eccentricity    0.257
		ArgOfPericen    303.1
	}
}

Planet	"HD 180902 b"
{
	ParentBody     "HD 180902"
	Msini           509.12
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454690
		Period          1.31145857
		SemiMajorAxis   1.39
		Eccentricity    0.09
		ArgOfPericen    300
	}
}

Planet	"HD 181342 b"
{
	ParentBody     "HD 181342"
	Msini           922.78
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2459915.5
		Period          1.538978835
		SemiMajorAxis   1.65
		Eccentricity    0.1
		ArgOfPericen    311.8
	}
}

Planet	"HD 181433 b"
{
	ParentBody     "HD 181433"
	Msini           7.6368
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           54542
		Period          0.02566598345
		SemiMajorAxis   0.08
		Eccentricity    0.396
		ArgOfPericen    202
	}
}

Planet	"HD 181433 c"
{
	ParentBody     "HD 181433"
	Msini           203.648
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           53235
		Period          2.633868777
		SemiMajorAxis   1.76
		Eccentricity    0.28
		ArgOfPericen    21.4
	}
}

Planet	"HD 181433 d"
{
	ParentBody     "HD 181433"
	Msini           171.828
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           52154
		Period          5.946739069
		SemiMajorAxis   3
		Eccentricity    0.48
		ArgOfPericen   -30
	}
}

Planet	"HD 181720 b"
{
	ParentBody     "HD 181720"
	Msini           117.734
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453631
		Period          2.617441321
		SemiMajorAxis   1.78
		Eccentricity    0.26
		Inclination     1.75
		ArgOfPericen    177
	}
}

Planet	"HD 183263 b"
{
	ParentBody     "HD 183263"
	Msini           1167.794
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452111.7
		Period          1.715300196
		SemiMajorAxis   1.51
		Eccentricity    0.3567
		ArgOfPericen    233.5
	}
}

Planet	"HD 183263 c"
{
	ParentBody     "HD 183263"
	Msini           1135.974
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2451971
		Period          8.405381649
		SemiMajorAxis   4.35
		Eccentricity    0.239
		ArgOfPericen    345
	}
}

Planet	"HD 185269 b"
{
	ParentBody     "HD 185269"
	Msini           299.108
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453154.1
		Period          0.01872182401
		SemiMajorAxis   0.077
		Eccentricity    0.3
		ArgOfPericen    173
	}
}

Planet	"HD 187085 b"
{
	ParentBody     "HD 187085"
	Msini           238.65
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2450912
		Period          2.699578601
		SemiMajorAxis   2.05
		Eccentricity    0.47
		ArgOfPericen    94
	}
}

Planet	"HD 187123 b"
{
	ParentBody     "HD 187123"
	Msini           166.4186
	DiscMethod     "RadVel"
	DiscDate       "1998"
	Orbit
	{
		Epoch           2454343.12
		Period          0.008478162945
		SemiMajorAxis   0.0426
		Eccentricity    0.0103
		ArgOfPericen    25
	}
}

Planet	"HD 187123 c"
{
	ParentBody     "HD 187123"
	Msini           633.218
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453580.04
		Period          10.43143455
		SemiMajorAxis   4.89
		Eccentricity    0.252
		ArgOfPericen    243
	}
}

Planet	"HD 18742 b"
{
	ParentBody     "HD 18742"
	Msini           859.14
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455200
		Period          2.113666004
		SemiMajorAxis   1.92
		Eccentricity    0.12
		ArgOfPericen    107
	}
}

Planet	"HD 188015 b"
{
	ParentBody     "HD 188015"
	Msini           477.3
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2451787
		Period          1.262723784
		SemiMajorAxis   1.203
		Eccentricity    0.137
		ArgOfPericen    222
	}
}

Planet	"HD 189567 b"
{
	ParentBody     "HD 189567"
	Mass            10.05512
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03908365571
		SemiMajorAxis   0.1099
		Eccentricity    0.23
	}
}

Planet	"HD 190360 b"
{
	ParentBody     "HD 190360"
	Msini           496.392
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2459271
		Period          7.852050173
		SemiMajorAxis   3.92
		Eccentricity    0.343
		ArgOfPericen    14.7
	}
}

Planet	"HD 190360 c"
{
	ParentBody     "HD 190360"
	Msini           19.092
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2455570.3
		Period          0.04686917469
		SemiMajorAxis   0.128
		Eccentricity    0.107
		ArgOfPericen    305.8
	}
}

Planet	"HD 190647 b"
{
	ParentBody     "HD 190647"
	Msini           604.58
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453869
		Period          2.842223677
		SemiMajorAxis   2.07
		Eccentricity    0.18
		ArgOfPericen    232.5
	}
}

Planet	"HD 190984 b"
{
	ParentBody     "HD 190984"
	Msini           986.42
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2449572
		Period          13.37468709
		SemiMajorAxis   5.5
		Eccentricity    0.57
		ArgOfPericen    318
	}
}

Planet	"HD 191806 b"
{
	ParentBody     "HD 191806"
	Msini           2711.064
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455014
		Period          4.39790376
		SemiMajorAxis   2.8
		Eccentricity    0.259
	}
}

Planet	"HD 192263 b"
{
	ParentBody     "HD 192263"
	Msini           203.9662
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2451796.9
		Period          0.06669191204
		SemiMajorAxis   0.15312
		Eccentricity    0.008
		ArgOfPericen    184
	}
}

Planet	"HD 192699 b"
{
	ParentBody     "HD 192699"
	Msini           763.68
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454036.6
		Period          0.9460298115
		SemiMajorAxis   1.15
		Eccentricity    0.129
		ArgOfPericen    41.3
	}
}

Planet	"HD 19467 b"
{
	ParentBody     "HD 19467"
	Mass            16546.4
	DiscMethod     "Imaging"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   51.1
	}
}

Planet	"HD 195019 A b"
{
	ParentBody     "HD 195019 A"
	Msini           1174.158
	DiscMethod     "RadVel"
	DiscDate       "1998"
	Orbit
	{
		Epoch           2451015.5
		Period          0.04983356388
		SemiMajorAxis   0.1388
		Eccentricity    0.0138
		ArgOfPericen    231
	}
}

Planet	"HD 196050 b"
{
	ParentBody     "HD 196050"
	Msini           922.78
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2450843
		Period          3.772839059
		SemiMajorAxis   2.54
		Eccentricity    0.228
		ArgOfPericen    187
	}
}

Planet	"HD 196067 b"
{
	ParentBody     "HD 196067"
	Msini           2195.58
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2453375
		Period          9.96051415
		SemiMajorAxis   5.02
		Eccentricity    0.66
		ArgOfPericen    148.2
	}
}

Planet	"HD 196885 A b"
{
	ParentBody     "HD 196885 A"
	Msini           820.956
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2451992
		Period          3.649633139
		SemiMajorAxis   2.37
		Eccentricity    0.48
		ArgOfPericen    78
	}
}

Planet	"HD 197037 b"
{
	ParentBody     "HD 197037"
	Msini           251.378
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2451353.1
		Period          2.835652695
		SemiMajorAxis   2.07
		Eccentricity    0.22
		ArgOfPericen    298
	}
}

Planet	"HD 19994 b"
{
	ParentBody     "HD 19994"
	Msini           435.934
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2453757
		Period          1.276413331
		SemiMajorAxis   1.305
		Eccentricity    0.063
		ArgOfPericen    346
	}
}

Planet	"HD 20003 b"
{
	ParentBody     "HD 20003"
	Mass            12.02796
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03244148767
		SemiMajorAxis   0.0974
		Eccentricity    0.4
	}
}

Planet	"HD 20003 c"
{
	ParentBody     "HD 20003"
	Mass            13.42804
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.09260430733
		SemiMajorAxis   0.1961
		Eccentricity    0.16
	}
}

Planet	"HD 200964 b"
{
	ParentBody     "HD 200964"
	Msini           588.67
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454900
		Period          1.680528748
		SemiMajorAxis   1.601
		Eccentricity    0.04
		ArgOfPericen    288
	}
}

Planet	"HD 200964 c"
{
	ParentBody     "HD 200964"
	Msini           284.789
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455000
		Period          2.258775199
		SemiMajorAxis   1.95
		Eccentricity    0.181
		ArgOfPericen    182.6
	}
}

Planet	"HD 202206 b"
{
	ParentBody     "HD 202206"
	Msini           5536.68
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2452250
		Period          0.7005488608
		SemiMajorAxis   0.83
		Eccentricity    0.435
		Inclination     90
		ArgOfPericen    161.18
	}
}

Planet	"HD 202206 c"
{
	ParentBody     "HD 202206"
	Msini           776.408
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452250
		Period          3.78762377
		SemiMajorAxis   2.55
		Eccentricity    0.267
		Inclination     90
		ArgOfPericen    78.99
	}
}

Planet	"HD 203030 b"
{
	ParentBody     "HD 203030"
	Mass            7665.438
	DiscMethod     "Imaging"
	DiscDate       "2006"
	Orbit
	{
		SemiMajorAxis   487.1
	}
}

Planet	"HD 20367 b"
{
	ParentBody     "HD 20367"
	Mass            340.474
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Period          1.368954666
		SemiMajorAxis   1.25
		Eccentricity    0.23
		ArgOfPericen    83
	}
}

Planet	"HD 2039 b"
{
	ParentBody     "HD 2039"
	Msini           1944.202
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2452041
		Period          3.066458452
		SemiMajorAxis   2.23
		Eccentricity    0.67
		ArgOfPericen    344.1
	}
}

Planet	"HD 204313 b"
{
	ParentBody     "HD 204313"
	Msini           1361.896
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2452111.6
		Period          5.541802279
		SemiMajorAxis   3.167
		Eccentricity    0.0946
		ArgOfPericen    292.5
	}
}

Planet	"HD 204313 c"
{
	ParentBody     "HD 204313"
	Msini           17.59646
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.09556672523
		SemiMajorAxis   0.2099
		Eccentricity    0.155
		ArgOfPericen    238
	}
}

Planet	"HD 204313 d"
{
	ParentBody     "HD 204313"
	Msini           534.576
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2456376.9
		Period          7.752664064
		SemiMajorAxis   3.93
		Eccentricity    0.28
		ArgOfPericen    247
	}
}

Planet	"HD 204941 b"
{
	ParentBody     "HD 204941"
	Msini           84.6412
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2456015
		Period          4.744796872
		SemiMajorAxis   2.56
		Eccentricity    0.37
		ArgOfPericen   -132
	}
}

Planet	"HD 205739 b"
{
	ParentBody     "HD 205739"
	Msini           435.934
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453390.7
		Period          0.7660670311
		SemiMajorAxis   0.896
		Eccentricity    0.27
		ArgOfPericen    301
	}
}

Planet	"HD 206610 b"
{
	ParentBody     "HD 206610"
	Msini           700.04
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454677
		Period          1.670124692
		SemiMajorAxis   1.68
		Eccentricity    0.229
		ArgOfPericen    296
	}
}

Planet	"HD 20781 b"
{
	ParentBody     "HD 20781"
	Mass            12.05978
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.07981005703
		SemiMajorAxis   0.169
		Eccentricity    0.11
	}
}

Planet	"HD 20781 c"
{
	ParentBody     "HD 20781"
	Mass            15.78272
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2330809593
		SemiMajorAxis   0.3456
		Eccentricity    0.28
	}
}

Planet	"HD 20782 b"
{
	ParentBody     "HD 20782"
	Msini           604.58
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2451175.9
		Period          1.620568534
		SemiMajorAxis   1.381
		Eccentricity    0.97
		ArgOfPericen    147.7
	}
}

Planet	"HD 207832 b"
{
	ParentBody     "HD 207832"
	Msini           178.192
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453191.073
		Period          0.4434591745
		SemiMajorAxis   0.57
		Eccentricity    0.13
		ArgOfPericen    130.8
	}
}

Planet	"HD 207832 c"
{
	ParentBody     "HD 207832"
	Msini           232.286
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453191.073
		Period          3.164201815
		SemiMajorAxis   2.112
		Eccentricity    0.27
		ArgOfPericen    121.6
	}
}

Planet	"HD 20794 b"
{
	ParentBody     "HD 20794"
	Msini           2.7047
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.05014480941
		SemiMajorAxis   0.1207
		Eccentricity    0
		Inclination     90
		ArgOfPericen    0
	}
}

Planet	"HD 20794 c"
{
	ParentBody     "HD 20794"
	Msini           2.40241
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1098284949
		SemiMajorAxis   0.2036
		Eccentricity    0
		Inclination     90
		ArgOfPericen    0
	}
}

Planet	"HD 20794 d"
{
	ParentBody     "HD 20794"
	Msini           4.80482
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2472578539
		SemiMajorAxis   0.3499
		Eccentricity    0
		Inclination     90
		ArgOfPericen    0
	}
}

Planet	"HD 208487 b"
{
	ParentBody     "HD 208487"
	Msini           165.464
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2450999
		Period          0.3561472459
		SemiMajorAxis   0.524
		Eccentricity    0.24
		ArgOfPericen    113
	}
}

Planet	"HD 208527 b"
{
	ParentBody     "HD 208527"
	Msini           3150.18
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2450745.3
		Period          2.39703962
		SemiMajorAxis   2.1
		Eccentricity    0.08
		ArgOfPericen    278
	}
}

Planet	"HD 20868 b"
{
	ParentBody     "HD 20868"
	Msini           633.218
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454451.52
		Period          1.042732769
		SemiMajorAxis   0.947
		Eccentricity    0.75
		ArgOfPericen    356.2
	}
}

Planet	"HD 210277 b"
{
	ParentBody     "HD 210277"
	Msini           410.478
	DiscMethod     "RadVel"
	DiscDate       "1998"
	Orbit
	{
		Epoch           2450104.3
		Period          1.210676127
		SemiMajorAxis   1.138
		Eccentricity    0.476
		ArgOfPericen    119.1
	}
}

Planet	"HD 210702 b"
{
	ParentBody     "HD 210702"
	Msini           604.58
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2452205
		Period          0.971410231
		SemiMajorAxis   1.2
		Eccentricity    0.094
		ArgOfPericen    126
	}
}

Planet	"HD 211847 b"
{
	ParentBody     "HD 211847"
	Mass            6109.44
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          21.711621
		SemiMajorAxis   7.5
		Eccentricity    0.685
		ArgOfPericen    159.2
	}
}

Planet	"HD 212301 b"
{
	ParentBody     "HD 212301"
	Msini           143.19
	Radius          76496.44
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453388.9
		Period          0.006148564055
		SemiMajorAxis   0.036
		Eccentricity    0.0147
		ArgOfPericen    172.8
	}
}

Planet	"HD 212771 b"
{
	ParentBody     "HD 212771"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454947
		Period          1.022061554
		SemiMajorAxis   1.22
		Eccentricity    0.111
		ArgOfPericen    55
	}
}

Planet	"HD 213240 b"
{
	ParentBody     "HD 213240"
	Msini           1431.9
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2451520
		Period          2.603751775
		SemiMajorAxis   2.03
		Eccentricity    0.45
		ArgOfPericen    214
	}
}

Planet	"HD 214823 b"
{
	ParentBody     "HD 214823"
	Msini           6109.44
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455652
		Period          5.139055816
		SemiMajorAxis   3.18
		Eccentricity    0.154
	}
}

Planet	"HD 215152 b"
{
	ParentBody     "HD 215152"
	Mass            2.76834
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01993882471
		SemiMajorAxis   0.0652
		Eccentricity    0.34
	}
}

Planet	"HD 215152 c"
{
	ParentBody     "HD 215152"
	Mass            3.08654
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0297501228
		SemiMajorAxis   0.0852
		Eccentricity    0.38
	}
}

Planet	"HD 215456 b"
{
	ParentBody     "HD 215456"
	Mass            32.1382
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.5256512126
		SemiMajorAxis   0.652
		Eccentricity    0.15
	}
}

Planet	"HD 215456 c"
{
	ParentBody     "HD 215456"
	Mass            78.2772
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          6.234219549
		SemiMajorAxis   3.394
		Eccentricity    0.19
	}
}

Planet	"HD 215497 b"
{
	ParentBody     "HD 215497"
	Msini           6.364
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454858.95
		Period          0.01077104483
		SemiMajorAxis   0.047
		Eccentricity    0.16
		ArgOfPericen    96
	}
}

Planet	"HD 215497 c"
{
	ParentBody     "HD 215497"
	Msini           105.006
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2455003.48
		Period          1.554968226
		SemiMajorAxis   1.282
		Eccentricity    0.49
		ArgOfPericen    45
	}
}

Planet	"HD 216435 b"
{
	ParentBody     "HD 216435"
	Msini           400.932
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2450870
		Period          3.589399134
		SemiMajorAxis   2.56
		Eccentricity    0.07
		ArgOfPericen    100
	}
}

Planet	"HD 216437 b"
{
	ParentBody     "HD 216437"
	Msini           579.124
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2450693
		Period          3.438814121
		SemiMajorAxis   2.32
		Eccentricity    0.29
		ArgOfPericen    63
	}
}

Planet	"HD 216536 b"
{
	ParentBody     "HD 216536"
	Msini           467.754
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2453587
		Period          0.4068533267
		SemiMajorAxis   0.609
		Eccentricity    0.38
		ArgOfPericen    270
	}
}

Planet	"HD 216770 b"
{
	ParentBody     "HD 216770"
	Msini           206.83
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2452672
		Period          0.3243053604
		SemiMajorAxis   0.46
		Eccentricity    0.37
		ArgOfPericen    281
	}
}

Planet	"HD 21693 b"
{
	ParentBody     "HD 21693"
	Mass            10.24604
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.06203007382
		SemiMajorAxis   0.1484
		Eccentricity    0.26
	}
}

Planet	"HD 21693 c"
{
	ParentBody     "HD 21693"
	Mass            20.593904
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1475212927
		SemiMajorAxis   0.2644
		Eccentricity    0.24
	}
}

Planet	"HD 217107 b"
{
	ParentBody     "HD 217107"
	Msini           442.298
	DiscMethod     "RadVel"
	DiscDate       "1998"
	Orbit
	{
		Epoch           2454396
		Period          0.01951257603
		SemiMajorAxis   0.0748
		Eccentricity    0.1267
		ArgOfPericen    24.4
	}
}

Planet	"HD 217107 c"
{
	ParentBody     "HD 217107"
	Msini           827.32
	DiscMethod     "RadVel"
	DiscDate       "1998"
	Orbit
	{
		Epoch           11106
		Period          11.52659829
		SemiMajorAxis   5.27
		Eccentricity    0.517
		ArgOfPericen    198.6
	}
}

Planet	"HD 217786 b"
{
	ParentBody     "HD 217786"
	Msini           4136.6
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2456053
		Period          3.611302409
		SemiMajorAxis   2.38
		Eccentricity    0.4
		ArgOfPericen    100
	}
}

Planet	"HD 218566 b"
{
	ParentBody     "HD 218566"
	Msini           66.822
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450360
		Period          0.6179461362
		SemiMajorAxis   0.6873
		Eccentricity    0.3
		ArgOfPericen    36
	}
}

Planet	"HD 219077 b"
{
	ParentBody     "HD 219077"
	Msini           3306.098
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2450455.8
		Period          15.06123923
		SemiMajorAxis   6.22
		Eccentricity    0.77
		ArgOfPericen    57.61
	}
}

Planet	"HD 219134 b"
{
	ParentBody     "HD 219134"
	Msini           3.8184
	Radius          10244.8036
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449999.5
		Period          0.008468627355
		SemiMajorAxis   0.038474
		Eccentricity    0
		Inclination     85.058
		ArgOfPericen    0
	}
}

Planet	"HD 219134 c"
{
	ParentBody     "HD 219134"
	Msini           3.5002
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449998.5
		Period          0.01851784977
		SemiMajorAxis   0.064816
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 219134 d"
{
	ParentBody     "HD 219134"
	Msini           21.3194
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449964
		Period          0.1278877449
		SemiMajorAxis   0.23508
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 219134 e"
{
	ParentBody     "HD 219134"
	Msini           3.72294
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          3.258112105
		SemiMajorAxis   2.56
		Eccentricity    0.34
		ArgOfPericen    345.42
	}
}

Planet	"HD 219134 f"
{
	ParentBody     "HD 219134"
	Msini           8.9096
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449983
		Period          0.06243802231
		SemiMajorAxis   0.14574
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 219134 g"
{
	ParentBody     "HD 219134"
	Msini           10.8188
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449972
		Period          0.2579110591
		SemiMajorAxis   0.3753
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 219134 h"
{
	ParentBody     "HD 219134"
	Msini           89.096
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2448616.291
		Period          6.017924712
		SemiMajorAxis   3.064
		Eccentricity    0.37
		ArgOfPericen    180
	}
}

Planet	"HD 219415 b"
{
	ParentBody     "HD 219415"
	Msini           318.2
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453461.4
		Period          5.731265605
		SemiMajorAxis   3.2
		Eccentricity    0.4
		ArgOfPericen    207
	}
}

Planet	"HD 219828 b"
{
	ParentBody     "HD 219828"
	Msini           19.092
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453898.63
		Period          0.01049577542
		SemiMajorAxis   0.052
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 220074 b"
{
	ParentBody     "HD 220074"
	Msini           3532.02
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2451158.2
		Period          1.840148862
		SemiMajorAxis   1.6
		Eccentricity    0.14
		ArgOfPericen    323
	}
}

Planet	"HD 220689 b"
{
	ParentBody     "HD 220689"
	Msini           337.292
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455649
		Period          6.048041714
		SemiMajorAxis   3.36
		Eccentricity    0.16
		ArgOfPericen    137
	}
}

Planet	"HD 220773 b"
{
	ParentBody     "HD 220773"
	Msini           461.39
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2453866.4
		Period          10.19789089
		SemiMajorAxis   4.94
		Eccentricity    0.51
		ArgOfPericen    226
	}
}

Planet	"HD 220842 b"
{
	ParentBody     "HD 220842"
	Msini           1011.876
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456624.8
		Period          0.5981510517
		SemiMajorAxis   0.74
		Eccentricity    0.404
		ArgOfPericen   -134.9
	}
}

Planet	"HD 221287 b"
{
	ParentBody     "HD 221287"
	Msini           983.238
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453263
		Period          1.248760446
		SemiMajorAxis   1.25
		Eccentricity    0.08
		ArgOfPericen    98
	}
}

Planet	"HD 221585 b"
{
	ParentBody     "HD 221585"
	Msini           512.302
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455050
		Period          3.211567646
		SemiMajorAxis   2.306
		Eccentricity    0.123
	}
}

Planet	"HD 222155 b"
{
	ParentBody     "HD 222155"
	Msini           604.58
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2456319
		Period          10.94889942
		SemiMajorAxis   5.1
		Eccentricity    0.16
		ArgOfPericen    137
	}
}

Planet	"HD 222582 b"
{
	ParentBody     "HD 222582"
	Msini           2466.05
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2450706.7
		Period          1.567124543
		SemiMajorAxis   1.35
		Eccentricity    0.725
		ArgOfPericen    319.01
	}
}

Planet	"HD 224538 b"
{
	ParentBody     "HD 224538"
	Msini           1899.654
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          3.255647987
		SemiMajorAxis   2.28
		Eccentricity    0.464
		ArgOfPericen    24
	}
}

Planet	"HD 224693 b"
{
	ParentBody     "HD 224693"
	Msini           225.922
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453193.9
		Period          0.07318431644
		SemiMajorAxis   0.192
		Eccentricity    0.05
		ArgOfPericen    6
	}
}

Planet	"HD 22781 b"
{
	ParentBody     "HD 22781"
	Msini           4343.43
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454881.4
		Period          1.445807781
		SemiMajorAxis   1.167
		Eccentricity    0.8191
		ArgOfPericen    315.92
	}
}

Planet	"HD 23079 b"
{
	ParentBody     "HD 23079"
	Msini           779.59
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2450492
		Period          2.000316558
		SemiMajorAxis   1.596
		Eccentricity    0.102
		ArgOfPericen    55
	}
}

Planet	"HD 23127 b"
{
	ParentBody     "HD 23127"
	Msini           477.3
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2450229
		Period          3.323821929
		SemiMajorAxis   2.4
		Eccentricity    0.44
		ArgOfPericen    190
	}
}

Planet	"HD 231701 b"
{
	ParentBody     "HD 231701"
	Msini           343.656
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454885.141
		Period          0.3884819551
		SemiMajorAxis   0.53
		Eccentricity    0.096
		ArgOfPericen    54.4
	}
}

Planet	"HD 233604 b"
{
	ParentBody     "HD 233604"
	Msini           2092.165
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2453022
		Period          0.5256785917
		SemiMajorAxis   0.747
		Eccentricity    0.05
		ArgOfPericen    281
	}
}

Planet	"HD 23596 b"
{
	ParentBody     "HD 23596"
	Msini           2453.322
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2453163
		Period          4.273876467
		SemiMajorAxis   2.772
		Eccentricity    0.266
		ArgOfPericen    272.6
	}
}

Planet	"HD 240210 b"
{
	ParentBody     "HD 240210"
	Msini           1657.822
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454487.38
		Period          1.373746007
		SemiMajorAxis   1.33
		Eccentricity    0.15
		ArgOfPericen    277.49
	}
}

Planet	"HD 240237 b"
{
	ParentBody     "HD 240237"
	Msini           1686.46
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454292.5
		Period          2.041658989
		SemiMajorAxis   1.9
		Eccentricity    0.4
		ArgOfPericen    108.1
	}
}

Planet	"HD 24040 b"
{
	ParentBody     "HD 24040"
	Msini           1275.982
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2454308
		Period          10.04265143
		SemiMajorAxis   4.92
		Eccentricity    0.04
		ArgOfPericen    154
	}
}

Planet	"HD 24064 b"
{
	ParentBody     "HD 24064"
	Msini           2991.08
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2455278.3
		Period          1.466424238
		SemiMajorAxis   1.29
		Eccentricity    0.35
		ArgOfPericen    250.8
	}
}

Planet	"HD 25171 b"
{
	ParentBody     "HD 25171"
	Msini           302.29
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2455301
		Period          5.051442717
		SemiMajorAxis   3.02
		Eccentricity    0.08
		ArgOfPericen    96
	}
}

Planet	"HD 2638 B b"
{
	ParentBody     "HD 2638 B"
	Msini           152.736
	Radius          74351.68
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453323.282
		Period          0.009411618087
		SemiMajorAxis   0.044
		Eccentricity    0.0407
		ArgOfPericen    126.9
	}
}

Planet	"HD 27631 b"
{
	ParentBody     "HD 27631"
	Msini           461.39
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453867
		Period          6.045303805
		SemiMajorAxis   3.25
		Eccentricity    0.12
		ArgOfPericen    134
	}
}

Planet	"HD 27894 b"
{
	ParentBody     "HD 27894"
	Msini           205.239
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2452933.64
		Period          0.04925608404
		SemiMajorAxis   0.125
		Eccentricity    0.0486
		ArgOfPericen    132
	}
}

Planet	"HD 28185 b"
{
	ParentBody     "HD 28185"
	Msini           1778.738
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2453793.6
		Period          1.056559211
		SemiMajorAxis   1.032
		Eccentricity    0.092
		ArgOfPericen    351.9
	}
}

Planet	"HD 28254 b"
{
	ParentBody     "HD 28254"
	Msini           369.112
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454049
		Period          3.055506814
		SemiMajorAxis   2.15
		Eccentricity    0.81
		ArgOfPericen    301
	}
}

Planet	"HD 283668 b"
{
	ParentBody     "HD 283668"
	Msini           16991.88
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2457401
		Period          7.003572071
		SemiMajorAxis   3.3
		Eccentricity    0.577
		ArgOfPericen    265.4
	}
}

Planet	"HD 284149 b"
{
	ParentBody     "HD 284149"
	Mass            10182.4
	DiscMethod     "Imaging"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   400
	}
}

Planet	"HD 285507 b"
{
	ParentBody     "HD 285507"
	Msini           291.7894
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456263.121
		Period          0.0166686658
		SemiMajorAxis   0.0729
		Eccentricity    0.086
		ArgOfPericen    182
	}
}

Planet	"HD 28678 b"
{
	ParentBody     "HD 28678"
	Msini           540.94
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455517
		Period          1.059844702
		SemiMajorAxis   1.25
		Eccentricity    0.168
		ArgOfPericen    126
	}
}

Planet	"HD 290327 b"
{
	ParentBody     "HD 290327"
	Msini           808.228
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2455326
		Period          6.688712498
		SemiMajorAxis   3.43
		Eccentricity    0.08
		ArgOfPericen    268
	}
}

Planet	"HD 2952 b"
{
	ParentBody     "HD 2952"
	Msini           509.12
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2450112
		Period          0.8531325478
		SemiMajorAxis   1.2
		Eccentricity    0.129
		ArgOfPericen    64
	}
}

Planet	"HD 30177 b"
{
	ParentBody     "HD 30177"
	Msini           3325.19
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451437
		Period          7.584008849
		SemiMajorAxis   3.95
		Eccentricity    0.193
		ArgOfPericen    34
	}
}

Planet	"HD 30562 b"
{
	ParentBody     "HD 30562"
	Msini           436.8886
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453601.4
		Period          3.173784498
		SemiMajorAxis   2.315
		Eccentricity    0.778
		ArgOfPericen    78.4
	}
}

Planet	"HD 30669 b"
{
	ParentBody     "HD 30669"
	Msini           149.554
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2457181
		Period          4.610639315
		SemiMajorAxis   2.69
		Eccentricity    0.18
		ArgOfPericen    82
	}
}

Planet	"HD 30856 b"
{
	ParentBody     "HD 30856"
	Msini           572.76
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455260
		Period          2.496973311
		SemiMajorAxis   1.8
		Eccentricity    0.117
		ArgOfPericen    192
	}
}

Planet	"HD 31253 b"
{
	ParentBody     "HD 31253"
	Msini           159.1
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450660
		Period          1.275865749
		SemiMajorAxis   1.26
		Eccentricity    0.3
		ArgOfPericen    244
	}
}

Planet	"HD 31527 b"
{
	ParentBody     "HD 31527"
	Mass            11.55066
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.04530144781
		SemiMajorAxis   0.1253
		Eccentricity    0.13
	}
}

Planet	"HD 31527 c"
{
	ParentBody     "HD 31527"
	Mass            15.84636
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1404109422
		SemiMajorAxis   0.2665
		Eccentricity    0.11
	}
}

Planet	"HD 31527 d"
{
	ParentBody     "HD 31527"
	Mass            16.51458
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.7515287325
		SemiMajorAxis   0.8181
		Eccentricity    0.38
	}
}

Planet	"HD 32518 b"
{
	ParentBody     "HD 32518"
	Msini           967.328
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2452950.29
		Period          0.4313302362
		SemiMajorAxis   0.59
		Eccentricity    0.01
		ArgOfPericen    306.11
	}
}

Planet	"HD 32963 b"
{
	ParentBody     "HD 32963"
	Msini           222.74
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2450532
		Period          6.494320935
		SemiMajorAxis   3.41
		Eccentricity    0.07
		ArgOfPericen    107
	}
}

Planet	"HD 330075 b"
{
	ParentBody     "HD 330075"
	Msini           197.284
	Radius          75781.52
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452968.399
		Period          0.00996954925
		SemiMajorAxis   0.039
		Eccentricity    0.0187
		ArgOfPericen    38.2
	}
}

Planet	"HD 33142 b"
{
	ParentBody     "HD 33142"
	Msini           413.66
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455324
		Period          0.8942011878
		SemiMajorAxis   1.06
		Eccentricity    0.12
		ArgOfPericen    143
	}
}

Planet	"HD 33283 b"
{
	ParentBody     "HD 33283"
	Msini           105.006
	Radius          70777.08
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453560
		Period          0.04977546545
		SemiMajorAxis   0.168
		Eccentricity    0.458
		ArgOfPericen    156
	}
}

Planet	"HD 33564 b"
{
	ParentBody     "HD 33564"
	Msini           2895.62
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2452603
		Period          1.062308821
		SemiMajorAxis   1.1
		Eccentricity    0.34
		ArgOfPericen    205
	}
}

Planet	"HD 33844 b"
{
	ParentBody     "HD 33844"
	Msini           623.672
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2454609
		Period          1.509683206
		SemiMajorAxis   1.6
		Eccentricity    0.15
		ArgOfPericen    211
	}
}

Planet	"HD 33844 c"
{
	ParentBody     "HD 33844"
	Msini           556.85
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2454544
		Period          2.507924948
		SemiMajorAxis   2.24
		Eccentricity    0.13
		ArgOfPericen    71
	}
}

Planet	"HD 34445 b"
{
	ParentBody     "HD 34445"
	Msini           251.378
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2453781
		Period          2.872066889
		SemiMajorAxis   2.07
		Eccentricity    0.27
		ArgOfPericen    104
	}
}

Planet	"HD 35759 b"
{
	ParentBody     "HD 35759"
	Msini           1196.432
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456469.72
		Period          0.2257871689
		SemiMajorAxis   0.389
		Eccentricity    0.389
		ArgOfPericen   -104
	}
}

Planet	"HD 3651 b"
{
	ParentBody     "HD 3651"
	Msini           72.8678
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2453932.6
		Period          0.1703472428
		SemiMajorAxis   0.295
		Eccentricity    0.596
		Inclination     83
		ArgOfPericen    242.5
	}
}

Planet	"HD 3651 c"
{
	ParentBody     "HD 3651"
	Mass            28.638
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.08487518929
		SemiMajorAxis   0.186
		Eccentricity    0.04
		ArgOfPericen    55
	}
}

Planet	"HD 37124 b"
{
	ParentBody     "HD 37124"
	Msini           194.102
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2450305
		Period          0.4226729668
		SemiMajorAxis   0.53364
		Eccentricity    0.054
		ArgOfPericen    130
	}
}

Planet	"HD 37124 c"
{
	ParentBody     "HD 37124"
	Msini           217.3306
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2449534
		Period          2.424418713
		SemiMajorAxis   1.71
		Eccentricity    0.125
		ArgOfPericen    53
	}
}

Planet	"HD 37124 d"
{
	ParentBody     "HD 37124"
	Msini           198.5568
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2448558
		Period          5.097987176
		SemiMajorAxis   2.807
		Eccentricity    0.16
		ArgOfPericen    0
	}
}

Planet	"HD 37605 b"
{
	ParentBody     "HD 37605"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452992.986
		Period          0.1505850133
		SemiMajorAxis   0.25
		Eccentricity    0.677
		ArgOfPericen    218.344
	}
}

Planet	"HD 37605 c"
{
	ParentBody     "HD 37605"
	Msini           1071.0612
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2454838
		Period          7.447113383
		SemiMajorAxis   3.814
		Eccentricity    0.013
		ArgOfPericen    221
	}
}

Planet	"HD 38283 b"
{
	ParentBody     "HD 38283"
	Msini           108.188
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2450802.6
		Period          0.9944086694
		SemiMajorAxis   1.02
		Eccentricity    0.41
	}
}

Planet	"HD 38529 b"
{
	ParentBody     "HD 38529"
	Msini           266.9698
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2454012.64
		Period          0.03917893496
		SemiMajorAxis   0.131
		Eccentricity    0.257
		Inclination     57
		ArgOfPericen    92.5
	}
}

Planet	"HD 38529 c"
{
	ParentBody     "HD 38529"
	Msini           4257.516
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           48002
		Period          5.844779325
		SemiMajorAxis   3.695
		Eccentricity    0.36
		Inclination     48.3
		ArgOfPericen    22.52
	}
}

Planet	"HD 38801 b"
{
	ParentBody     "HD 38801"
	Msini           3404.74
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453966
		Period          1.906406268
		SemiMajorAxis   1.7
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 38858 b"
{
	ParentBody     "HD 38858"
	Mass            30.57902
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          1.114739784
		SemiMajorAxis   1.0376
		Eccentricity    0.27
	}
}

Planet	"HD 39091 b"
{
	ParentBody     "HD 39091"
	Msini           3293.37
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           50073
		Period          5.650546562
		SemiMajorAxis   3.29
		Eccentricity    0.62
		ArgOfPericen    331
	}
}

Planet	"HD 39194 b"
{
	ParentBody     "HD 39194"
	Mass            3.72294
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01543167837
		SemiMajorAxis   0.0519
		Eccentricity    0.2
	}
}

Planet	"HD 39194 c"
{
	ParentBody     "HD 39194"
	Mass            5.95034
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03839917838
		SemiMajorAxis   0.0954
		Eccentricity    0.11
	}
}

Planet	"HD 39194 d"
{
	ParentBody     "HD 39194"
	Mass            5.15484
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.09292738063
		SemiMajorAxis   0.172
		Eccentricity    0.2
	}
}

Planet	"HD 39392 b"
{
	ParentBody     "HD 39392"
	Msini           4200.24
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456322
		Period          1.07955765
		SemiMajorAxis   1.08
		Eccentricity    0.394
		ArgOfPericen    328.1
	}
}

Planet	"HD 40307 b"
{
	ParentBody     "HD 40307"
	Msini           3.8184
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01180449608
		SemiMajorAxis   0.0475
		Eccentricity    0.2
		ArgOfPericen    194
	}
}

Planet	"HD 40307 c"
{
	ParentBody     "HD 40307"
	Msini           6.42764
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Period          0.02634060431
		SemiMajorAxis   0.0812
		Eccentricity    0.06
		ArgOfPericen    234
	}
}

Planet	"HD 40307 d"
{
	ParentBody     "HD 40307"
	Msini           8.7505
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Period          0.0559037279
		SemiMajorAxis   0.134
		Eccentricity    0.07
		ArgOfPericen    17
	}
}

Planet	"HD 40307 e"
{
	ParentBody     "HD 40307"
	Msini           3.5002
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.09478642107
		SemiMajorAxis   0.1886
		Eccentricity    0.15
		ArgOfPericen    302
	}
}

Planet	"HD 40307 f"
{
	ParentBody     "HD 40307"
	Msini           3.62748
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1411666052
		SemiMajorAxis   0.2485
		Eccentricity    0.02
		ArgOfPericen    354
	}
}

Planet	"HD 40307 g"
{
	ParentBody     "HD 40307"
	Msini           7.09586
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.5415584659
		SemiMajorAxis   0.6
		Eccentricity    0.29
		ArgOfPericen    91.2
	}
}

Planet	"HD 40979 b"
{
	ParentBody     "HD 40979"
	Msini           1275.982
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2453919
		Period          0.7230818546
		SemiMajorAxis   0.846
		Eccentricity    0.252
		ArgOfPericen    323.4
	}
}

Planet	"HD 41004 A b"
{
	ParentBody     "HD 41004 A"
	Msini           808.228
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452425
		Period          2.636606687
		SemiMajorAxis   1.64
		Eccentricity    0.74
		ArgOfPericen    97
	}
}

Planet	"HD 41004 B b"
{
	ParentBody     "HD 41004 B"
	Msini           5845.334
	Radius          75781.52
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452532.699
		Period          0.003623978929
		SemiMajorAxis   0.0177
		Eccentricity    0.058
		ArgOfPericen    149
	}
}

Planet	"HD 4113 b"
{
	ParentBody     "HD 4113"
	Msini           496.392
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453778
		Period          1.441837812
		SemiMajorAxis   1.28
		Eccentricity    0.903
		ArgOfPericen   -42.3
	}
}

Planet	"HD 4203 b"
{
	ParentBody     "HD 4203"
	Msini           579.124
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2451911.52
		Period          1.196603274
		SemiMajorAxis   1.164
		Eccentricity    0.52
		ArgOfPericen    328.03
	}
}

Planet	"HD 4203 c"
{
	ParentBody     "HD 4203"
	Msini           690.494
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456000
		Period          18.34399252
		SemiMajorAxis   6.95
		Eccentricity    0.24
		ArgOfPericen    224
	}
}

Planet	"HD 4208 b"
{
	ParentBody     "HD 4208"
	Msini           255.8328
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2451040
		Period          2.266988927
		SemiMajorAxis   1.65
		Eccentricity    0.052
		ArgOfPericen    345
	}
}

Planet	"HD 4308 b"
{
	ParentBody     "HD 4308"
	Msini           12.8871
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2450108.5
		Period          0.04273602676
		SemiMajorAxis   0.118
		Eccentricity    0.27
		ArgOfPericen    210
	}
}

Planet	"HD 4313 b"
{
	ParentBody     "HD 4313"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454804
		Period          0.9746957222
		SemiMajorAxis   1.19
		Eccentricity    0.041
		ArgOfPericen    76
	}
}

Planet	"HD 43197 b"
{
	ParentBody     "HD 43197"
	Msini           190.92
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454713.8
		Period          0.897486679
		SemiMajorAxis   0.92
		Eccentricity    0.83
		ArgOfPericen    251
	}
}

Planet	"HD 43691 b"
{
	ParentBody     "HD 43691"
	Msini           792.318
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454046.6
		Period          0.1011931289
		SemiMajorAxis   0.24
		Eccentricity    0.14
		ArgOfPericen    290
	}
}

Planet	"HD 44219 b"
{
	ParentBody     "HD 44219"
	Msini           184.556
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454585.6
		Period          1.293114577
		SemiMajorAxis   1.19
		Eccentricity    0.61
		ArgOfPericen    147.4
	}
}

Planet	"HD 45184 b"
{
	ParentBody     "HD 45184"
	Mass            12.728
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01611861982
		SemiMajorAxis   0.0638
		Eccentricity    0.3
	}
}

Planet	"HD 45350 b"
{
	ParentBody     "HD 45350"
	Msini           569.578
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2451825.3
		Period          2.638249432
		SemiMajorAxis   1.92
		Eccentricity    0.778
		ArgOfPericen    343.4
	}
}

Planet	"HD 45364 b"
{
	ParentBody     "HD 45364"
	Msini           59.56704
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453535.82
		Period          0.6213137647
		SemiMajorAxis   0.6813
		Eccentricity    0.1684
		ArgOfPericen    162.58
	}
}

Planet	"HD 45364 c"
{
	ParentBody     "HD 45364"
	Msini           209.34378
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453250.38
		Period          0.9386922144
		SemiMajorAxis   0.8972
		Eccentricity    0.0974
		ArgOfPericen    7.41
	}
}

Planet	"HD 45652 b"
{
	ParentBody     "HD 45652"
	Msini           149.554
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454120.3
		Period          0.1193728469
		SemiMajorAxis   0.23
		Eccentricity    0.38
		ArgOfPericen    273
	}
}

Planet	"HD 46375 A b"
{
	ParentBody     "HD 46375 A"
	Msini           71.9132
	Radius          72921.84
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451071.53
		Period          0.008278268732
		SemiMajorAxis   0.0398
		Eccentricity    0.063
		ArgOfPericen    114
	}
}

Planet	"HD 47186 b"
{
	ParentBody     "HD 47186"
	Msini           22.805394
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454566.95
		Period          0.01118299067
		SemiMajorAxis   0.05
		Eccentricity    0.038
		ArgOfPericen    59
	}
}

Planet	"HD 47186 c"
{
	ParentBody     "HD 47186"
	Msini           111.564102
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452010
		Period          3.706034072
		SemiMajorAxis   2.395
		Eccentricity    0.249
		ArgOfPericen    26
	}
}

Planet	"HD 4732 b"
{
	ParentBody     "HD 4732"
	Msini           754.134
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2454967
		Period          0.9861949414
		SemiMajorAxis   1.19
		Eccentricity    0.13
		ArgOfPericen    85
	}
}

Planet	"HD 4732 c"
{
	ParentBody     "HD 4732"
	Msini           754.134
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456093
		Period          7.479968295
		SemiMajorAxis   4.6
		Eccentricity    0.23
		ArgOfPericen    118
	}
}

Planet	"HD 47366 b"
{
	ParentBody     "HD 47366"
	Msini           556.85
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2450122
		Period          0.9946824603
		SemiMajorAxis   1.214
		Eccentricity    0.089
		ArgOfPericen    100
	}
}

Planet	"HD 47366 c"
{
	ParentBody     "HD 47366"
	Msini           591.852
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2450445
		Period          1.87464652
		SemiMajorAxis   1.853
		Eccentricity    0.278
		ArgOfPericen    132
	}
}

Planet	"HD 47536 b"
{
	ParentBody     "HD 47536"
	Msini           2329.224
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451599.36
		Period          1.949747373
		SemiMajorAxis   1.93
		Eccentricity    0.2
		ArgOfPericen    260.8
	}
}

Planet	"HD 47536 c"
{
	ParentBody     "HD 47536"
	Mass            2227.4
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Period          6.84477333
	}
}

Planet	"HD 48265 b"
{
	ParentBody     "HD 48265"
	Msini           381.84
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452892
		Period          2.086286911
		SemiMajorAxis   1.6
		Eccentricity    0.24
		ArgOfPericen    289
	}
}

Planet	"HD 49674 b"
{
	ParentBody     "HD 49674"
	Msini           33.411
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451882.38
		Period          0.01354545049
		SemiMajorAxis   0.058
		Eccentricity    0.087
		ArgOfPericen    264
	}
}

Planet	"HD 50499 b"
{
	ParentBody     "HD 50499"
	Msini           544.122
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2561234.6
		Period          7.071198432
		SemiMajorAxis   3.86
		Eccentricity    0.23
		ArgOfPericen    262
	}
}

Planet	"HD 50554 b"
{
	ParentBody     "HD 50554"
	Msini           1559.18
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451832.4
		Period          3.501786036
		SemiMajorAxis   2.38
		Eccentricity    0.42
		ArgOfPericen    0
	}
}

Planet	"HD 51608 b"
{
	ParentBody     "HD 51608"
	Mass            13.14166
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0385223843
		SemiMajorAxis   0.1059
		Eccentricity    0.15
	}
}

Planet	"HD 51608 c"
{
	ParentBody     "HD 51608"
	Mass            17.9783
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2612376189
		SemiMajorAxis   0.3791
		Eccentricity    0.41
	}
}

Planet	"HD 52265 b"
{
	ParentBody     "HD 52265"
	Msini           334.11
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451422.3
		Period          0.3274539561
		SemiMajorAxis   0.5
		Eccentricity    0.35
		ArgOfPericen    211
	}
}

Planet	"HD 52265 c"
{
	ParentBody     "HD 52265"
	Mass            111.37
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.164000769
		SemiMajorAxis   0.316
		Eccentricity    0.05
		ArgOfPericen    358
	}
}

Planet	"HD 5319 b"
{
	ParentBody     "HD 5319"
	Msini           560.032
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2456288
		Period          1.754999882
		SemiMajorAxis   1.6697
		Eccentricity    0.02
		ArgOfPericen    97
	}
}

Planet	"HD 5319 c"
{
	ParentBody     "HD 5319"
	Msini           365.93
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2453453
		Period          2.425787668
		SemiMajorAxis   2.071
		Eccentricity    0.15
		ArgOfPericen    252
	}
}

Planet	"HD 5583 b"
{
	ParentBody     "HD 5583"
	Msini           1839.196
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456021
		Period          0.3815276654
		SemiMajorAxis   0.53
		Eccentricity    0.076
		ArgOfPericen    12
	}
}

Planet	"HD 5608 b"
{
	ParentBody     "HD 5608"
	Msini           445.48
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2452327
		Period          2.170066936
		SemiMajorAxis   1.9
		Eccentricity    0.19
		ArgOfPericen    269
	}
}

Planet	"HD 564 b"
{
	ParentBody     "HD 564"
	Msini           105.006
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455433
		Period          1.347872764
		SemiMajorAxis   1.2
		Eccentricity    0.096
		ArgOfPericen    314
	}
}

Planet	"HD 5891 b"
{
	ParentBody     "HD 5891"
	Msini           2418.32
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455432
		Period          0.4849111218
		SemiMajorAxis   0.76
		Eccentricity    0.066
		ArgOfPericen    354
	}
}

Planet	"HD 59686 b"
{
	ParentBody     "HD 59686"
	Mass            1670.55
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Period          0.8295865276
		SemiMajorAxis   0.911
	}
}

Planet	"HD 60532 b"
{
	ParentBody     "HD 60532"
	Msini           327.746
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453987
		Period          0.5511411485
		SemiMajorAxis   0.759
		Eccentricity    0.28
		Inclination     20
		ArgOfPericen   -8.1
	}
}

Planet	"HD 60532 c"
{
	ParentBody     "HD 60532"
	Msini           782.772
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2453723
		Period          1.653697236
		SemiMajorAxis   1.58
		Eccentricity    0.02
		Inclination     20
		ArgOfPericen   -209
	}
}

Planet	"HD 63454 b"
{
	ParentBody     "HD 63454"
	Msini           126.6436
	Radius          78498.216
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453342.87
		Period          0.007715562655
		SemiMajorAxis   0.0368
		Eccentricity    0
		ArgOfPericen    87.3
	}
}

Planet	"HD 63765 b"
{
	ParentBody     "HD 63765"
	Msini           203.648
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454404
		Period          0.9801715408
		SemiMajorAxis   0.94
		Eccentricity    0.24
		ArgOfPericen    122
	}
}

Planet	"HD 6434 b"
{
	ParentBody     "HD 6434"
	Msini           140.008
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451909.308
		Period          0.06028054976
		SemiMajorAxis   0.148
		Eccentricity    0.146
		ArgOfPericen    163.2
	}
}

Planet	"HD 65216 b"
{
	ParentBody     "HD 65216"
	Msini           400.932
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           50762
		Period          1.567179302
		SemiMajorAxis   1.3
		Eccentricity    0.41
		ArgOfPericen    198
	}
}

Planet	"HD 65216 c"
{
	ParentBody     "HD 65216"
	Msini           54.094
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.4178049641
		SemiMajorAxis   0.54
		Eccentricity    0.02
		ArgOfPericen    0
	}
}

Planet	"HD 66141 b"
{
	ParentBody     "HD 66141"
	Msini           1909.2
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2451320.8
		Period          1.315565434
		SemiMajorAxis   1.2
		Eccentricity    0.07
		ArgOfPericen    22.1
	}
}

Planet	"HD 66428 b"
{
	ParentBody     "HD 66428"
	Msini           897.324
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2452139
		Period          5.401895112
		SemiMajorAxis   3.18
		Eccentricity    0.465
		ArgOfPericen    152.9
	}
}

Planet	"HD 67087 b"
{
	ParentBody     "HD 67087"
	Msini           973.692
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2450154.8
		Period          0.9642916667
		SemiMajorAxis   1.08
		Eccentricity    0.17
		ArgOfPericen    284
	}
}

Planet	"HD 67087 c"
{
	ParentBody     "HD 67087"
	Msini           1543.27
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2450322.5
		Period          6.499796754
		SemiMajorAxis   3.86
		Eccentricity    0.76
		ArgOfPericen    255
	}
}

Planet	"HD 6718 b"
{
	ParentBody     "HD 6718"
	Msini           496.392
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454357
		Period          6.833821692
		SemiMajorAxis   3.56
		Eccentricity    0.1
		ArgOfPericen    286
	}
}

Planet	"HD 68402 b"
{
	ParentBody     "HD 68402"
	Msini           976.874
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          3.019913993
		SemiMajorAxis   2.18
		Eccentricity    0.03
		ArgOfPericen    341
	}
}

Planet	"HD 68988 b"
{
	ParentBody     "HD 68988"
	Msini           591.852
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2451548.84
		Period          0.01718613067
		SemiMajorAxis   0.0704
		Eccentricity    0.1249
		ArgOfPericen    31.4
	}
}

Planet	"HD 69830 b"
{
	ParentBody     "HD 69830"
	Msini           10.21422
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453496.8
		Period          0.02372946018
		SemiMajorAxis   0.0785
		Eccentricity    0.1
		Inclination     13
		ArgOfPericen    340
	}
}

Planet	"HD 69830 c"
{
	ParentBody     "HD 69830"
	Msini           11.80522
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453469.6
		Period          0.08640841852
		SemiMajorAxis   0.186
		Eccentricity    0.13
		Inclination     13
		ArgOfPericen    221
	}
}

Planet	"HD 69830 d"
{
	ParentBody     "HD 69830"
	Msini           18.1374
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453358
		Period          0.5393681384
		SemiMajorAxis   0.63
		Eccentricity    0.07
		Inclination     13
		ArgOfPericen    224
	}
}

Planet	"HD 70573 b"
{
	ParentBody     "HD 70573"
	Msini           1941.02
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2452106.54
		Period          2.332151169
		SemiMajorAxis   1.76
		Eccentricity    0.4
		ArgOfPericen    269.6
	}
}

Planet	"HD 70642 b"
{
	ParentBody     "HD 70642"
	Msini           636.4
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451749
		Period          6.10827572
		SemiMajorAxis   3.3
		Eccentricity    0.1
		ArgOfPericen    277
	}
}

Planet	"HD 7199 b"
{
	ParentBody     "HD 7199"
	Msini           92.278
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455030
		Period          1.683814239
		SemiMajorAxis   1.36
		Eccentricity    0.19
		ArgOfPericen    155
	}
}

Planet	"HD 72659 b"
{
	ParentBody     "HD 72659"
	Msini           1002.33
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2455351
		Period          10.01527234
		SemiMajorAxis   4.74
		Eccentricity    0.22
		ArgOfPericen    260.7
	}
}

Planet	"HD 72892 b"
{
	ParentBody     "HD 72892"
	Msini           1734.19
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1080789709
		SemiMajorAxis   0.228
		Eccentricity    0.423
		ArgOfPericen    353
	}
}

Planet	"HD 73256 b"
{
	ParentBody     "HD 73256"
	Msini           595.034
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2452500.18
		Period          0.006977780965
		SemiMajorAxis   0.037
		Eccentricity    0.029
		ArgOfPericen    337.3
	}
}

Planet	"HD 73267 b"
{
	ParentBody     "HD 73267"
	Msini           973.692
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2451821.7
		Period          3.449765758
		SemiMajorAxis   2.198
		Eccentricity    0.256
		ArgOfPericen    229.1
	}
}

Planet	"HD 73526 b"
{
	ParentBody     "HD 73526"
	Msini           715.95
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2452856
		Period          0.5171910728
		SemiMajorAxis   0.65
		Eccentricity    0.29
		ArgOfPericen    196
	}
}

Planet	"HD 73526 c"
{
	ParentBody     "HD 73526"
	Msini           715.95
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453300
		Period          1.037941428
		SemiMajorAxis   1.03
		Eccentricity    0.28
		ArgOfPericen    272
	}
}

Planet	"HD 73534 b"
{
	ParentBody     "HD 73534"
	Msini           350.9746
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2456450
		Period          4.846099517
		SemiMajorAxis   3.067
		Eccentricity    0.074
		ArgOfPericen    12
	}
}

Planet	"HD 74156 b"
{
	ParentBody     "HD 74156"
	Msini           565.7596
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2450793.39
		Period          0.141381531
		SemiMajorAxis   0.2916
		Eccentricity    0.638
		ArgOfPericen    175.35
	}
}

Planet	"HD 74156 c"
{
	ParentBody     "HD 74156"
	Msini           2544.6454
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2448559
		Period          6.704866163
		SemiMajorAxis   3.82
		Eccentricity    0.3829
		ArgOfPericen    268.9
	}
}

Planet	"HD 7449 b"
{
	ParentBody     "HD 7449"
	Msini           353.202
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455298
		Period          3.490834398
		SemiMajorAxis   2.3
		Eccentricity    0.82
		ArgOfPericen   -21
	}
}

Planet	"HD 7449 c"
{
	ParentBody     "HD 7449"
	Msini           636.4
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455883
		Period          11.07758116
		SemiMajorAxis   4.96
		Eccentricity    0.53
		ArgOfPericen    11
	}
}

Planet	"HD 75289 b"
{
	ParentBody     "HD 75289"
	Msini           148.5994
	Radius          73636.76
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2450830.34
		Period          0.009608054867
		SemiMajorAxis   0.0482
		Eccentricity    0.034
		ArgOfPericen    141
	}
}

Planet	"HD 75784 b"
{
	ParentBody     "HD 75784"
	Msini           365.93
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2454411
		Period          0.9355436187
		SemiMajorAxis   1.073
		Eccentricity    0.13
		ArgOfPericen    29
	}
}

Planet	"HD 75898 b"
{
	ParentBody     "HD 75898"
	Msini           798.682
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2452907
		Period          1.144993683
		SemiMajorAxis   1.19
		Eccentricity    0.1
		ArgOfPericen    263.7
	}
}

Planet	"HD 76700 b"
{
	ParentBody     "HD 76700"
	Msini           62.6854
	Radius          70777.08
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2451212.9
		Period          0.01087223796
		SemiMajorAxis   0.049
		Eccentricity    0
		ArgOfPericen    12.3
	}
}

Planet	"HD 77065 b"
{
	ParentBody     "HD 77065"
	Msini           13046.2
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456881.239
		Period          0.3261219632
		SemiMajorAxis   0.438
		Eccentricity    0.69397
		ArgOfPericen    105.972
	}
}

Planet	"HD 77338 b"
{
	ParentBody     "HD 77338"
	Mass            15.91
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01570492172
		SemiMajorAxis   0.0614
		Eccentricity    0.09
		ArgOfPericen    223.454
	}
}

Planet	"HD 7924 b"
{
	ParentBody     "HD 7924"
	Msini           8.690042
	Radius          75066.6
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2454096.65
		Period          0.01477901554
		SemiMajorAxis   0.05664
		Eccentricity    0.058
		ArgOfPericen    332
	}
}

Planet	"HD 7924 c"
{
	ParentBody     "HD 7924"
	Msini           7.869086
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.04188727487
		SemiMajorAxis   0.1134
		Eccentricity    0.098
		ArgOfPericen    27
	}
}

Planet	"HD 7924 d"
{
	ParentBody     "HD 7924"
	Msini           6.446732
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.06694462107
		SemiMajorAxis   0.1551
		Eccentricity    0.21
		ArgOfPericen    119
	}
}

Planet	"HD 79498 b"
{
	ParentBody     "HD 79498"
	Msini           426.388
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2453210.9
		Period          5.383003537
		SemiMajorAxis   3.13
		Eccentricity    0.59
		ArgOfPericen    221
	}
}

Planet	"HD 80606 b"
{
	ParentBody     "HD 80606"
	Mass            1253.708
	Radius          65844.132
	DiscMethod     "Transit"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2454424.857
		Period          0.3051026773
		SemiMajorAxis   0.449
		Eccentricity    0.93366
		Inclination     89.285
		ArgOfPericen    300.651
	}
}

Planet	"HD 81040 b"
{
	ParentBody     "HD 81040"
	Msini           2182.852
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2452504
		Period          2.742563778
		SemiMajorAxis   1.94
		Eccentricity    0.526
		ArgOfPericen    81.3
	}
}

Planet	"HD 82886 b"
{
	ParentBody     "HD 82886"
	Msini           413.66
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455200
		Period          1.930226079
		SemiMajorAxis   1.65
		Eccentricity    0.066
		ArgOfPericen    352
	}
}

Planet	"HD 82943 b"
{
	ParentBody     "HD 82943"
	Mass            1527.36
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Period          1.211251088
		SemiMajorAxis   1.19
		Eccentricity    0.203
		Inclination     19.4
		ArgOfPericen    107
	}
}

Planet	"HD 82943 c"
{
	ParentBody     "HD 82943"
	Mass            1520.996
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Period          0.6004235165
		SemiMajorAxis   0.746
		Eccentricity    0.425
		Inclination     19.4
		ArgOfPericen    133
	}
}

Planet	"HD 82943 d"
{
	ParentBody     "HD 82943"
	Mass            92.278
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          2.95146626
		SemiMajorAxis   2.145
		Eccentricity    0
	}
}

Planet	"HD 83443 b"
{
	ParentBody     "HD 83443"
	Msini           126.6436
	Radius          74351.68
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2452248.9
		Period          0.00817463065
		SemiMajorAxis   0.0406
		Eccentricity    0.007
		ArgOfPericen    117.3
	}
}

Planet	"HD 8535 b"
{
	ParentBody     "HD 8535"
	Msini           216.376
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454537
		Period          3.594874953
		SemiMajorAxis   2.45
		Eccentricity    0.15
		ArgOfPericen    61
	}
}

Planet	"HD 85390 b"
{
	ParentBody     "HD 85390"
	Msini           42.0024
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Period          2.157472554
		SemiMajorAxis   1.52
		Eccentricity    0.41
		ArgOfPericen   -94
	}
}

Planet	"HD 85390 c"
{
	ParentBody     "HD 85390"
	Mass            63.64
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          10.13026453
		SemiMajorAxis   4.23
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 85512 b"
{
	ParentBody     "HD 85512"
	Msini           3.605206
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455239.709
		Period          0.1599760423
		SemiMajorAxis   0.26
		Eccentricity    0.11
		Inclination     90
		ArgOfPericen    178
	}
}

Planet	"HD 8574 b"
{
	ParentBody     "HD 8574"
	Msini           572.76
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2453981
		Period          0.6215054183
		SemiMajorAxis   0.757
		Eccentricity    0.297
		ArgOfPericen    26.6
	}
}

Planet	"HD 86081 b"
{
	ParentBody     "HD 86081"
	Msini           477.3
	Radius          77211.36
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2453694.8
		Period          0.005852281197
		SemiMajorAxis   0.035
		Eccentricity    0.008
		ArgOfPericen    251
	}
}

Planet	"HD 86226 b"
{
	ParentBody     "HD 86226"
	Msini           292.744
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2452240
		Period          4.199952915
		SemiMajorAxis   2.6
		Eccentricity    0.73
		ArgOfPericen    58
	}
}

Planet	"HD 86264 b"
{
	ParentBody     "HD 86264"
	Msini           2227.4
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2455172
		Period          4.038416265
		SemiMajorAxis   2.86
		Eccentricity    0.7
		ArgOfPericen    306
	}
}

Planet	"HD 8673 b"
{
	ParentBody     "HD 8673"
	Msini           4518.44
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454420.5
		Period          4.473743848
		SemiMajorAxis   3.02
		Eccentricity    0.723
		ArgOfPericen    323.4
	}
}

Planet	"HD 87883 b"
{
	ParentBody     "HD 87883"
	Msini           566.396
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2451139
		Period          7.5402023
		SemiMajorAxis   3.6
		Eccentricity    0.53
		Inclination     8.5
		ArgOfPericen    291
	}
}

Planet	"HD 88133 b"
{
	ParentBody     "HD 88133"
	Msini           95.1418
	Radius          71492
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2453016.31
		Period          0.00935234235
		SemiMajorAxis   0.0472
		Eccentricity    0.133
		ArgOfPericen    349
	}
}

Planet	"HD 89307 b"
{
	ParentBody     "HD 89307"
	Msini           566.396
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2450228
		Period          5.905670429
		SemiMajorAxis   3.27
		Eccentricity    0.241
		ArgOfPericen    36
	}
}

Planet	"HD 89744 A b"
{
	ParentBody     "HD 89744 A"
	Msini           2685.608
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2451505.5
		Period          0.700904789
		SemiMajorAxis   0.88
		Eccentricity    0.7
		Inclination     54
		ArgOfPericen    195
	}
}

Planet	"HD 89744 A c"
{
	ParentBody     "HD 89744 A"
	Mass            1018.24
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.2332698751
		SemiMajorAxis   0.44
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"HD 90156 b"
{
	ParentBody     "HD 90156"
	Msini           18.1374
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Period          0.1362657474
		SemiMajorAxis   0.25
		Eccentricity    0.31
		ArgOfPericen    113
	}
}

Planet	"HD 9174 b"
{
	ParentBody     "HD 9174"
	Msini           353.202
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          3.227995102
		SemiMajorAxis   2.2
		Eccentricity    0.12
		ArgOfPericen    101
	}
}

Planet	"HD 92788 b"
{
	ParentBody     "HD 92788"
	Msini           1228.252
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2450759.2
		Period          0.8920382394
		SemiMajorAxis   0.97
		Eccentricity    0.334
		Inclination     8
		ArgOfPericen    276.4
	}
}

Planet	"HD 92788 c"
{
	ParentBody     "HD 92788"
	Mass            286.38
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.4435413118
		SemiMajorAxis   0.6
		Eccentricity    0.04
		ArgOfPericen    0
	}
}

Planet	"HD 93083 b"
{
	ParentBody     "HD 93083"
	Msini           117.734
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453181.7
		Period          0.3931090219
		SemiMajorAxis   0.477
		Eccentricity    0.14
		ArgOfPericen    333.5
	}
}

Planet	"HD 93385 b"
{
	ParentBody     "HD 93385"
	Mass            8.36866
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03610207245
		SemiMajorAxis   0.1116
		Eccentricity    0.15
	}
}

Planet	"HD 93385 c"
{
	ParentBody     "HD 93385"
	Mass            10.11876
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.126012277
		SemiMajorAxis   0.257
		Eccentricity    0.24
	}
}

Planet	"HD 9446 b"
{
	ParentBody     "HD 9446"
	Msini           222.74
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454854.4
		Period          0.08227965124
		SemiMajorAxis   0.189
		Eccentricity    0.2
		ArgOfPericen    215
	}
}

Planet	"HD 9446 c"
{
	ParentBody     "HD 9446"
	Msini           579.124
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454510
		Period          0.5281427101
		SemiMajorAxis   0.654
		Eccentricity    0.06
		ArgOfPericen    100
	}
}

Planet	"HD 95086 b"
{
	ParentBody     "HD 95086"
	Mass            1591
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   61.7
		Eccentricity    0.2
		Inclination     153
	}
}

Planet	"HD 95089 b"
{
	ParentBody     "HD 95089"
	Msini           381.84
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454983
		Period          1.388120031
		SemiMajorAxis   1.51
		Eccentricity    0.157
		ArgOfPericen    317
	}
}

Planet	"HD 95127 b"
{
	ParentBody     "HD 95127"
	Msini           1594.182
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2453200
		Period          1.319672298
		SemiMajorAxis   1.28
		Eccentricity    0.11
		ArgOfPericen    40
	}
}

Planet	"HD 9578 b"
{
	ParentBody     "HD 9578"
	Mass            197.284
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Period          1.35252721
	}
}

Planet	"HD 95872 b"
{
	ParentBody     "HD 95872"
	Msini           1463.72
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449869
		Period          11.97835333
		SemiMajorAxis   5.2
		Eccentricity    0.06
		ArgOfPericen    17
	}
}

Planet	"HD 96063 b"
{
	ParentBody     "HD 96063"
	Msini           286.38
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455260
		Period          0.9886590598
		SemiMajorAxis   0.99
		Eccentricity    0.03
		ArgOfPericen    30
	}
}

Planet	"HD 96127 b"
{
	ParentBody     "HD 96127"
	Msini           1272.8
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2453969.9
		Period          1.772248711
		SemiMajorAxis   1.4
		Eccentricity    0.3
		ArgOfPericen    162
	}
}

Planet	"HD 96167 b"
{
	ParentBody     "HD 96167"
	Msini           216.376
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2453057
		Period          1.365942966
		SemiMajorAxis   1.3
		Eccentricity    0.71
		ArgOfPericen    285
	}
}

Planet	"HD 96700 b"
{
	ParentBody     "HD 96700"
	Mass            9.03688
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02224715607
		SemiMajorAxis   0.0774
		Eccentricity    0.1
	}
}

Planet	"HD 96700 c"
{
	ParentBody     "HD 96700"
	Mass            12.728
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2833462368
		SemiMajorAxis   0.422
		Eccentricity    0.37
	}
}

Planet	"HD 97658 b"
{
	ParentBody     "HD 97658"
	Mass            7.6368
	Radius          14298.4
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Period          0.02598358093
		SemiMajorAxis   0.08
		Eccentricity    0.078
		Inclination     89.14
		ArgOfPericen    71
	}
}

Planet	"HD 98219 b"
{
	ParentBody     "HD 98219"
	Msini           572.76
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455140
		Period          1.196192587
		SemiMajorAxis   1.23
		Eccentricity    0.112
		ArgOfPericen    57
	}
}

Planet	"HD 98649 b"
{
	ParentBody     "HD 98649"
	Msini           2163.76
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2450271
		Period          13.5553891
		SemiMajorAxis   5.6
		Eccentricity    0.85
		ArgOfPericen    248
	}
}

Planet	"HD 99109 b"
{
	ParentBody     "HD 99109"
	Msini           159.7364
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2451310
		Period          1.20276357
		SemiMajorAxis   1.105
		Eccentricity    0.09
		ArgOfPericen    256
	}
}

Planet	"HD 99706 b"
{
	ParentBody     "HD 99706"
	Msini           445.48
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455219
		Period          2.3765053
		SemiMajorAxis   2.14
		Eccentricity    0.365
		ArgOfPericen    4
	}
}

Planet	"HIP 105854 b"
{
	ParentBody     "HD 203949"
	Msini           2609.24
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455262.4
		Period          0.5043228989
		SemiMajorAxis   0.81
		Eccentricity    0.02
		ArgOfPericen    343.2
	}
}

Planet	"HIP 107773 b"
{
	ParentBody     "HD 207229"
	Msini           630.036
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2456202.3
		Period          0.3950803166
		SemiMajorAxis   0.72
		Eccentricity    0.09
		ArgOfPericen    166
	}
}

Planet	"HIP 109384 b"
{
	ParentBody     "HIP 109384"
	Msini           496.392
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456337.02
		Period          1.367530953
		SemiMajorAxis   1.134
		Eccentricity    0.549
		ArgOfPericen    104.49
	}
}

Planet	"HIP 109600 b"
{
	ParentBody     "HIP 109600"
	Msini           852.776
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456017.1
		Period          0.6354139978
		SemiMajorAxis   0.706
		Eccentricity    0.163
		ArgOfPericen   -131.3
	}
}

Planet	"HIP 116454 b"
{
	ParentBody     "HIP 116454"
	Mass            11.833858
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02498752952
		SemiMajorAxis   0.098
		Eccentricity    0.205
		Inclination     88.43
		ArgOfPericen    300.9
	}
}

Planet	"HIP 11915 b"
{
	ParentBody     "HIP 11915"
	Mass            315.018
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          10.48619274
		SemiMajorAxis   4.8
		Eccentricity    0.1
		ArgOfPericen    155
	}
}

Planet	"HIP 12961 b"
{
	ParentBody     "HIP 12961"
	Msini           111.37
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454428.4
		Period          0.1572518225
		SemiMajorAxis   0.25
		Eccentricity    0.166
		ArgOfPericen    272
	}
}

Planet	"HIP 14810 b"
{
	ParentBody     "HIP 14810"
	Msini           1234.616
	DiscMethod     "RadVel"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453694.598
		Period          0.01827240988
		SemiMajorAxis   0.0692
		Eccentricity    0.1427
		ArgOfPericen    159.32
	}
}

Planet	"HIP 14810 c"
{
	ParentBody     "HIP 14810"
	Msini           407.296
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2454672.24
		Period          0.4044713456
		SemiMajorAxis   0.545
		Eccentricity    0.164
		ArgOfPericen    329
	}
}

Planet	"HIP 14810 d"
{
	ParentBody     "HIP 14810"
	Msini           181.374
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454317.198
		Period          2.606489684
		SemiMajorAxis   1.89
		Eccentricity    0.173
		ArgOfPericen    286
	}
}

Planet	"HIP 5158 b"
{
	ParentBody     "HIP 5158"
	Msini           451.844
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454580.49
		Period          0.9465500142
		SemiMajorAxis   0.89
		Eccentricity    0.52
		ArgOfPericen   -108
	}
}

Planet	"HIP 5158 c"
{
	ParentBody     "HIP 5158"
	Msini           4785.728
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Period          24.68980926
		SemiMajorAxis   7.7
		Eccentricity    0.14
		ArgOfPericen    142.09
	}
}

Planet	"HIP 57050 b"
{
	ParentBody     "HIP 57050"
	Msini           94.8236
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Period          0.1133412326
		SemiMajorAxis   0.163506
		Eccentricity    0.314
		ArgOfPericen    238.1
	}
}

Planet	"HIP 57274 b"
{
	ParentBody     "HIP 57274"
	Msini           11.6143
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2454801.015
		Period          0.02227344
		SemiMajorAxis   0.07
		Eccentricity    0.187
		ArgOfPericen    81
	}
}

Planet	"HIP 57274 c"
{
	ParentBody     "HIP 57274"
	Msini           130.150164
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455785.208
		Period          0.0876952359
		SemiMajorAxis   0.178
		Eccentricity    0.05
		ArgOfPericen    356.2
	}
}

Planet	"HIP 57274 d"
{
	ParentBody     "HIP 57274"
	Msini           159.1
	DiscMethod     "RadVel"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455108.116
		Period          1.181955459
		SemiMajorAxis   1.01
		Eccentricity    0.27
		ArgOfPericen    187.2
	}
}

Planet	"HIP 63242 b"
{
	ParentBody     "HD 112410"
	Msini           2921.076
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455376.2
		Period          0.3411435028
		SemiMajorAxis   0.565
		Eccentricity    0.23
		ArgOfPericen    118.2
	}
}

Planet	"HIP 65407 b"
{
	ParentBody     "HIP 65407"
	Msini           136.1896
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456990.8
		Period          0.07700369996
		SemiMajorAxis   0.177
		Eccentricity    0.14
		ArgOfPericen    50
	}
}

Planet	"HIP 65407 c"
{
	ParentBody     "HIP 65407"
	Msini           249.4688
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2457047
		Period          0.184261298
		SemiMajorAxis   0.316
		Eccentricity    0.12
		ArgOfPericen   -19
	}
}

Planet	"HIP 65891 b"
{
	ParentBody     "HD 117253"
	Msini           1909.2
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2456014.8
		Period          2.96926267
		SemiMajorAxis   2.81
		Eccentricity    0.13
		ArgOfPericen    355.5
	}
}

Planet	"HIP 67851 b"
{
	ParentBody     "HD 121056"
	Msini           439.116
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2452997.8
		Period          0.2434001396
		SemiMajorAxis   0.46
		Eccentricity    0.05
		ArgOfPericen    138.1
	}
}

Planet	"HIP 67851 c"
{
	ParentBody     "HD 121056"
	Msini           1902.836
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2452684.1
		Period          5.836675114
		SemiMajorAxis   3.82
		Eccentricity    0.17
		ArgOfPericen    166.5
	}
}

Planet	"HIP 70849 b"
{
	ParentBody     "HIP 70849"
	Msini           2863.8
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Period          47.46850304
		SemiMajorAxis   20.25
		Eccentricity    0.715
	}
}

Planet	"HIP 73990 b"
{
	ParentBody     "HIP 73990"
	Mass            6682.2
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   20
	}
}

Planet	"HIP 73990 c"
{
	ParentBody     "HIP 73990"
	Mass            7000.4
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   32
	}
}

Planet	"HIP 74865 b"
{
	ParentBody     "HIP 74865"
	Mass            8909.6
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   23
	}
}

Planet	"HIP 74890 b"
{
	ParentBody     "HD 135760"
	Msini           763.68
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2459820.4
		Period          2.251382844
		SemiMajorAxis   2.1
		Eccentricity    0.07
		ArgOfPericen    181.9
	}
}

Planet	"HIP 77900 b"
{
	ParentBody     "HIP 77900"
	Mass            6364
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   3200
	}
}

Planet	"HIP 78530 b"
{
	ParentBody     "HD 143567"
	Mass            7318.6
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   740
	}
}

Planet	"HIP 79431 b"
{
	ParentBody     "HIP 79431"
	Msini           668.22
	DiscMethod     "RadVel"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454980.3
		Period          0.3058244724
		SemiMajorAxis   0.36
		Eccentricity    0.29
		ArgOfPericen    287.4
	}
}

Planet	"HIP 8541 b"
{
	ParentBody     "HD 11343"
	Msini           1750.1
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2459346.9
		Period          4.27168614
		SemiMajorAxis   2.8
		Eccentricity    0.16
		ArgOfPericen    293.9
	}
}

Planet	"HIP 91258 b"
{
	ParentBody     "HIP 91258"
	Msini           339.8376
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456164.275
		Period          0.01382781108
		SemiMajorAxis   0.057
		Eccentricity    0.024
		ArgOfPericen    276
	}
}

Planet	"HIP 97233 b"
{
	ParentBody     "HD 186641"
	Msini           6364
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455856.3
		Period          2.898898401
		SemiMajorAxis   2.55
		Eccentricity    0.61
		ArgOfPericen    249.3
	}
}

Planet	"HN Peg b"
{
	ParentBody     "HN Peg"
	Mass            6999.98634
	Radius          75138.092
	DiscMethod     "Imaging"
	DiscDate       "2006"
	Orbit
	{
		SemiMajorAxis   773
	}
}

Planet	"HR 3549 b"
{
	ParentBody     "HR 3549"
	Mass            15114.5
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   80
	}
}

Planet	"HR 810 b"
{
	ParentBody     "HD 17051"
	Msini           677.766
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2451492.8
		Period          0.8542277116
		SemiMajorAxis   0.91
		Eccentricity    0.15
		ArgOfPericen    309
	}
}

Planet	"HR 8799 b"
{
	ParentBody     "HD 218396"
	Mass            2227.4
	Radius          85790.4
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		Period          449.7016078
		SemiMajorAxis   68
		Eccentricity    0
		Inclination     28
	}
}

Planet	"HR 8799 c"
{
	ParentBody     "HD 218396"
	Mass            3182
	Radius          92939.6
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		Period          224.9055621
		SemiMajorAxis   42.9
		Eccentricity    0
		Inclination     28
	}
}

Planet	"HR 8799 d"
{
	ParentBody     "HD 218396"
	Mass            3182
	Radius          85790.4
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		Period          112.4021297
		SemiMajorAxis   27
		Eccentricity    0.1
		Inclination     28
		ArgOfPericen    80.2
	}
}

Planet	"HR 8799 e"
{
	ParentBody     "HD 218396"
	Mass            2863.8
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		Period          49.28236797
		SemiMajorAxis   14.5
	}
}

Planet	"HU Aqr c"
{
	ParentBody     "HU Aqr"
	Mass            1877.38
	DiscMethod     "Pulsar"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2450050
		Period          15.45823609
		SemiMajorAxis   6.18
		Eccentricity    0.29
		ArgOfPericen    351
	}
}

Planet	"HW Vir b"
{
	ParentBody     "HW Vir"
	Mass            4550.26
	DiscMethod     "Pulsar"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452410
		Period          12.7038993
		SemiMajorAxis   4.69
		Eccentricity    0.4
		ArgOfPericen   -18
	}
}

Planet	"Hypatia/Edasich b/Eldsich b/IOT Dra b/HD 137759 b/HIP 75458 b"
{
	ParentBody     "Edasich"
	Msini           2806.524
	DiscMethod     "RadVel"
	DiscDate       "2002"
	Orbit
	{
		Epoch           2452015.36
		Period          1.398305054
		SemiMajorAxis   1.275
		Eccentricity    0.713
		Inclination     69.9
		ArgOfPericen    92.5
	}
}

Planet	"K2-10 b"
{
	ParentBody     "K2-10"
	Msini           27.047
	Radius          24521.756
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.05285369691
		SemiMajorAxis   0.1374
		Eccentricity    0.31
		Inclination     88.5
	}
}

Planet	"K2-11 b"
{
	ParentBody     "K2-11"
	Radius          48185.608
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.1093457194
		SemiMajorAxis   0.2257
	}
}

Planet	"K2-12 b"
{
	ParentBody     "K2-12"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02267569364
		SemiMajorAxis   0.0802
	}
}

Planet	"K2-13 b"
{
	ParentBody     "K2-13"
	Radius          12082.148
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.1092833224
		SemiMajorAxis   0.2114
	}
}

Planet	"K2-14 b"
{
	ParentBody     "K2-14"
	Radius          30670.068
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02291088005
		SemiMajorAxis   0.0627
	}
}

Planet	"K2-15 b"
{
	ParentBody     "K2-15"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.03233580437
		SemiMajorAxis   0.091
	}
}

Planet	"K2-16 b"
{
	ParentBody     "K2-16"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02085958362
		SemiMajorAxis   0.0662
	}
}

Planet	"K2-16 c"
{
	ParentBody     "K2-16"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.05223555912
		SemiMajorAxis   0.122
	}
}

Planet	"K2-17 b"
{
	ParentBody     "K2-17"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.04919346806
		SemiMajorAxis   0.119
	}
}

Planet	"K2-18 b"
{
	ParentBody     "K2-18"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.09020009439
		SemiMajorAxis   0.1491
	}
}

Planet	"K2-19 d"
{
	ParentBody     "EPIC 201505350"
	Mass            14.01671
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.006868209834
		Eccentricity    0
	}
}

Planet	"K2-21 b/EPIC 206011691 b"
{
	ParentBody     "K2-21"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02552864992
		SemiMajorAxis   0.0731
		Inclination     88.3
	}
}

Planet	"K2-21 c/EPIC 206011691 c"
{
	ParentBody     "K2-21"
	Radius          12225.132
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.04244088014
		SemiMajorAxis   0.1026
		Inclination     89.08
	}
}

Planet	"K2-22 b/EPIC 201637175 b"
{
	ParentBody     "K2-22"
	Mass            445.48
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.001043357012
		SemiMajorAxis   0.0088
	}
}

Planet	"K2-24 b/EPIC 203771098 b"
{
	ParentBody     "K2-24"
	Msini           21.03302
	Radius          36246.444
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05718151019
		SemiMajorAxis   0.154
		Eccentricity    0
		Inclination     89.25
	}
}

Planet	"K2-24 c/EPIC 203771098 c"
{
	ParentBody     "K2-24"
	Msini           27.047
	Radius          49901.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1159868744
		SemiMajorAxis   0.247
		Eccentricity    0
		Inclination     89.76
	}
}

Planet	"K2-25 b/EPIC 210490365 b"
{
	ParentBody     "K2-25"
	Radius          21876.552
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009540387438
		Eccentricity    0.27
		Inclination     88.3
		ArgOfPericen    62
	}
}

Planet	"K2-26 b"
{
	ParentBody     "K2-26"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.03988175628
		SemiMajorAxis   0.0962
		Inclination     89.22
	}
}

Planet	"K2-27 b"
{
	ParentBody     "K2-27"
	Msini           29.14712
	Radius          28382.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01853961615
		Eccentricity    0.16
		Inclination     88.4
	}
}

Planet	"K2-28 b"
{
	ParentBody     "K2-28"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006188920839
		SemiMajorAxis   0.0214
		Eccentricity    0
		Inclination     88.9
	}
}

Planet	"K2-29 b/EPIC 211089792 b"
{
	ParentBody     "K2-29"
	Msini           232.286
	Radius          85075.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008922386818
		SemiMajorAxis   0.04217
		Eccentricity    0.066
		Inclination     86.656
		ArgOfPericen    132
	}
}

Planet	"K2-30 b/EPIC 210957318 b"
{
	ParentBody     "K2-30"
	Msini           198.2386
	Radius          74280.188
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01122132961
		SemiMajorAxis   0.04839
		Eccentricity    0
		Inclination     86.92
		ArgOfPericen    120
	}
}

Planet	"K2-31 b"
{
	ParentBody     "K2-31"
	Mass            590.78603
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003443879253
		Eccentricity    0
	}
}

Planet	"K2-32 b"
{
	ParentBody     "K2-32"
	Mass            21.125298
	Radius          34316.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02461977354
		Eccentricity    0
	}
}

Planet	"K2-32 c"
{
	ParentBody     "K2-32"
	Mass            8.110918
	Radius          22162.52
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05655463847
		Eccentricity    0
	}
}

Planet	"K2-32 d"
{
	ParentBody     "K2-32"
	Mass            35.040184
	Radius          23949.82
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08684434844
		Eccentricity    0
	}
}

Planet	"K2-34 b/EPIC 212110888 b"
{
	ParentBody     "K2-34"
	Msini           560.032
	Radius          102948.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008201829042
		SemiMajorAxis   0.0445
		Eccentricity    0.022
		Inclination     82.96
	}
}

Planet	"K2-4 b"
{
	ParentBody     "K2-4"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02738810104
		SemiMajorAxis   0.0777
	}
}

Planet	"K2-5 b"
{
	ParentBody     "K2-5"
	Radius          12225.132
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01570166361
		SemiMajorAxis   0.0509
	}
}

Planet	"K2-5 c"
{
	ParentBody     "K2-5"
	Radius          12225.132
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02993646491
		SemiMajorAxis   0.0783
	}
}

Planet	"K2-6 b"
{
	ParentBody     "K2-6"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.08471614414
		SemiMajorAxis   0.1898
	}
}

Planet	"K2-7 b"
{
	ParentBody     "K2-7"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.07852302061
		SemiMajorAxis   0.1814
	}
}

Planet	"K2-8 b"
{
	ParentBody     "K2-8"
	Radius          22805.948
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02834390519
		SemiMajorAxis   0.0856
	}
}

Planet	"K2-9 b"
{
	ParentBody     "K2-9"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.05051387959
		SemiMajorAxis   0.091
		Inclination     87.983
	}
}

Planet	"KAP And b"
{
	ParentBody     "KAP And"
	Mass            4454.8
	Radius          85790.4
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   55
	}
}

Planet	"KAP CrB b"
{
	ParentBody     "KAP CrB"
	Msini           550.486
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2451860
		Period          3.455077302
		SemiMajorAxis   2.8
		Eccentricity    0.044
		Inclination     60
		ArgOfPericen    210
	}
}

Planet	"KELT-1 b"
{
	ParentBody     "KELT-1"
	Mass            8712.316
	Radius          79785.072
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455914.08
		Period          0.003333442942
		SemiMajorAxis   0.02472
		Eccentricity    0.01
		Inclination     87.6
		ArgOfPericen    61
	}
}

Planet	"KELT-10 b"
{
	ParentBody     "KELT-10"
	Msini           216.0578
	Radius          100017.308
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01140688019
		SemiMajorAxis   0.0525
		Inclination     88.61
	}
}

Planet	"KELT-14 b/WASP-122 b"
{
	ParentBody     "KELT-14"
	Msini           374.5214
	Radius          108667.84
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004681985947
		SemiMajorAxis   0.02956
		Eccentricity    0
		Inclination     79.67
	}
}

Planet	"KELT-15 b"
{
	ParentBody     "KELT-15"
	Msini           289.562
	Radius          103162.956
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009115707584
		SemiMajorAxis   0.04613
		Eccentricity    0
		Inclination     88.3
	}
}

Planet	"KELT-2 A b"
{
	ParentBody     "HD 42176 A"
	Mass            484.3004
	Radius          91938.712
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455974.603
		Period          0.01126318732
		SemiMajorAxis   0.05496
		Eccentricity    0
		Inclination     88.6
		ArgOfPericen    90
	}
}

Planet	"KELT-3 b"
{
	ParentBody     "KELT-3"
	Msini           467.754
	Radius          95298.836
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007401637256
		SemiMajorAxis   0.04117
		Eccentricity    0
		Inclination     84.6
		ArgOfPericen    90
	}
}

Planet	"KELT-4 A b"
{
	ParentBody     "HIP 51260 A"
	Msini           285.1072
	Radius          121464.908
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456190.302
		Period          0.008185235121
		SemiMajorAxis   0.04317
		Eccentricity    0
		Inclination     83.16
		ArgOfPericen    300
	}
}

Planet	"KELT-6 b"
{
	ParentBody     "KELT-6"
	Msini           140.6444
	Radius          84360.56
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456269.2
		Period          0.02148049245
		SemiMajorAxis   0.08
		Eccentricity    0.029
		Inclination     88.81
		ArgOfPericen    308
	}
}

Planet	"KELT-6 c"
{
	ParentBody     "KELT-6"
	Msini           1180.522
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          3.493572308
		SemiMajorAxis   2.39
		Eccentricity    0.21
		ArgOfPericen    268.7
	}
}

Planet	"KELT-7 b"
{
	ParentBody     "HD 33643"
	Msini           407.296
	Radius          109597.236
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.007487565719
		SemiMajorAxis   0.04415
		Eccentricity    0
		Inclination     83.76
	}
}

Planet	"KELT-8 b"
{
	ParentBody     "HD 343246"
	Mass            275.8794
	Radius          132975.12
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2456870.47
		Period          0.008881942147
		SemiMajorAxis   0.04571
		Eccentricity    0.035
		Inclination     82.65
		ArgOfPericen    85
	}
}

Planet	"KIC 10001893 b"
{
	ParentBody     "KIC 10001893"
	DiscMethod     "Pulsar"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0006015186802
	}
}

Planet	"KIC 10001893 c"
{
	ParentBody     "KIC 10001893"
	DiscMethod     "OrbitLight"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0008905871475
	}
}

Planet	"KIC 10001893 d"
{
	ParentBody     "KIC 10001893"
	DiscMethod     "Pulsar"
	DiscDate       "2014"
	Orbit
	{
		Period          0.002222114593
	}
}

Planet	"KIC 10024862 b"
{
	ParentBody     "KIC 10024862"
	Radius          35031.08
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.552516428
		Inclination     89.868
	}
}

Planet	"KIC 10255705 b"
{
	ParentBody     "KIC 10255705"
	Radius          46469.8
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          1.936740387
		SemiMajorAxis   1.6
		Eccentricity    0
		Inclination     89.75
	}
}

Planet	"KIC 10525077 b"
{
	ParentBody     "KOI-5800"
	Radius          35102.572
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          2.338401816
		Inclination     89.861
	}
}

Planet	"KIC 12454613 b"
{
	ParentBody     "KIC 12454613"
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          2.016146876
		SemiMajorAxis   1.54
		Eccentricity    0.16
		Inclination     89.95
	}
}

Planet	"KIC 5010054 b"
{
	ParentBody     "KIC 5010054"
	Radius          44325.04
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          2.475727134
		SemiMajorAxis   1.86
		Eccentricity    0
		Inclination     89.79
	}
}

Planet	"KIC 5522786 b"
{
	ParentBody     "KIC 5522786"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          2.073046108
		SemiMajorAxis   1.98
		Eccentricity    0.56
		Inclination     89.86
		ArgOfPericen    20
	}
}

Planet	"KIC 5732155 b"
{
	ParentBody     "KIC 5732155"
	Radius          81500.88
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          1.763674947
		SemiMajorAxis   1.52
		Eccentricity    0
		Inclination     89.76
	}
}

Planet	"KIC 8012732 b"
{
	ParentBody     "KIC 8012732"
	Radius          62198.04
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.181320537
		Inclination     89.741
	}
}

Planet	"KIC 8540376 c"
{
	ParentBody     "Kepler-457"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.2058907818
		Inclination     89.701
	}
}

Planet	"KIC 9413313 b"
{
	ParentBody     "KIC 9413313"
	DiscMethod     "Transit"
	DiscDate       "2015"
}

Planet	"KIC 9662267 b"
{
	ParentBody     "KIC 9662267"
	Radius          24307.28
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          1.276418806
		SemiMajorAxis   1.12
		Eccentricity    0.11
		Inclination     89.82
		ArgOfPericen    1.7
	}
}

Planet	"KIC 9704149 b"
{
	ParentBody     "KIC 9704149"
	Radius          28596.8
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          1.908366337
		SemiMajorAxis   1.46
		Eccentricity    0.29
		Inclination     89.95
		ArgOfPericen    7.4
	}
}

Planet	"KMT-2015-1 b"
{
	ParentBody     "KMT-2015-1"
	Mass            700.04
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   0.76
	}
}

Planet	"KOI-1725.01/KIC 10905746 b"
{
	ParentBody     "KOI-1725"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.027062591
		SemiMajorAxis   0.0751
		Eccentricity    0
		Inclination     88.42
	}
}

Planet	"KOI-179.02/KIC 9663113 b"
{
	ParentBody     "Kepler-458"
	Radius          29311.72
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.567137412
		SemiMajorAxis   1.3337
		Eccentricity    0
		Inclination     89.768
	}
}

Planet	"KOI-1843.01"
{
	ParentBody     "Kepler-974"
	Mass            0.3182
	Radius          3717.584
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.000484312341
		SemiMajorAxis   0.0395
		Eccentricity    0
		Inclination     72
	}
}

Planet	"KOI-2700.01"
{
	ParentBody     "KOI-2700"
	Mass            0.8610011641
	Radius          6760.786441
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.002491557726
		SemiMajorAxis   0.015
		Eccentricity    0
		Inclination     38.39
	}
}

Planet	"KOI-2939 b"
{
	ParentBody     "KOI-2939"
	Msini           483.664
	Radius          108667.84
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          3.032487294
		SemiMajorAxis   2.7205
		Eccentricity    0.0581
		Inclination     90.0972
		ArgOfPericen    155.0464
	}
}

Planet	"KOI-368.01"
{
	ParentBody     "KOI-368"
	Radius          130830.36
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3020505382
		SemiMajorAxis   0.581
		Eccentricity    0
		Inclination     89.221
	}
}

Planet	"KOI-3791.01/KOI-3791 b/KIC 5437945 b"
{
	ParentBody     "Kepler-460"
	Radius          40821.932
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.206819235
		SemiMajorAxis   1.1455
		Eccentricity    0
		Inclination     89.904
	}
}

Planet	"KOI-4427.01"
{
	ParentBody     "KOI-4427"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.4042813347
		SemiMajorAxis   0.419
		Eccentricity    0.02
		Inclination     89.97
	}
}

Planet	"KOI-5124.01/KIC 5094412 b"
{
	ParentBody     "KOI-5124"
	Radius          36460.92
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.7580723358
		SemiMajorAxis   0.78
		Eccentricity    0
		Inclination     89.74
	}
}

Planet	"KOI-5278.01/KIC 6372194 b"
{
	ParentBody     "KOI-5278"
	Radius          52904.08
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.7709536516
		SemiMajorAxis   0.78
		Eccentricity    0.65
		Inclination     89.69
		ArgOfPericen    0
	}
}

Planet	"KOI-5833.01/KOI-5833 b"
{
	ParentBody     "KOI-5833"
	Radius          22162.52
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.205137337
		SemiMajorAxis   1.1207
		Eccentricity    0
		Inclination     89.57
	}
}

Planet	"KOI-5874.01/KIC 11152511 b"
{
	ParentBody     "KOI-5874"
	Radius          25737.12
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.7867738393
		SemiMajorAxis   0.85
		Eccentricity    0.67
		Inclination     89.39
		ArgOfPericen    37
	}
}

Planet	"KOI-5929.01/KOI-5929 b"
{
	ParentBody     "KOI-5929"
	Radius          26452.04
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.275866022
		SemiMajorAxis   1.1654
		Eccentricity    0
		Inclination     89.947
	}
}

Planet	"KOI-682.01/KOI-682 b"
{
	ParentBody     "KOI-682"
	Radius          62912.96
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.540647454
		SemiMajorAxis   1.3457
		Eccentricity    0
		Inclination     89.851
	}
}

Planet	"KOI-771.01/KOI-771 b"
{
	ParentBody     "KOI-771"
	Radius          87935.16
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.836179441
		SemiMajorAxis   1.5155
		Eccentricity    0
		Inclination     89.535
	}
}

Planet	"KOI-89.02/KOI-89 c"
{
	ParentBody     "Kepler-462"
	Radius          30741.56
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.5683352191
		SemiMajorAxis   0.86
		Eccentricity    0.5
		Inclination     90.64
	}
}

Planet	"Kapteyn b"
{
	ParentBody     "Kapteyn"
	Msini           4.773
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1331062001
		SemiMajorAxis   0.168
		Eccentricity    0.21
		ArgOfPericen    80.4
	}
}

Planet	"Kapteyn c"
{
	ParentBody     "Kapteyn"
	Msini           7.0004
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3327655002
		SemiMajorAxis   0.311
		Eccentricity    0.23
		ArgOfPericen    3.9
	}
}

Planet	"Kepler-10 b/KOI-72.01"
{
	ParentBody     "Kepler-10"
	Mass            3.333876601
	Radius          9394.0488
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.002292972398
		SemiMajorAxis   0.01685
		Eccentricity    0.06
		Inclination     84.8
	}
}

Planet	"Kepler-10 c/KOI-72.02"
{
	ParentBody     "Kepler-10"
	Msini           17.22002328
	Radius          14813.1424
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1240116894
		SemiMajorAxis   0.241
		Eccentricity    0.05
		Inclination     89.59
	}
}

Planet	"Kepler-100 b/KOI-41.02"
{
	ParentBody     "Kepler-100"
	Msini           7.35042
	Radius          8321.6688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01885608287
		SemiMajorAxis   0.0727
		Eccentricity    0.13
		Inclination     87.09
	}
}

Planet	"Kepler-100 c/KOI-41.01"
{
	ParentBody     "Kepler-100"
	Msini           0.85914
	Radius          14162.5652
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03508879685
		SemiMajorAxis   0.11
		Eccentricity    0.02
		Inclination     87.09
	}
}

Planet	"Kepler-100 d/KOI-41.03"
{
	ParentBody     "Kepler-100"
	Msini           2.99108
	Radius          9658.5692
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09673890635
		SemiMajorAxis   0.2163
		Eccentricity    0.38
		Inclination     88.81
	}
}

Planet	"Kepler-1000 b"
{
	ParentBody     "Kepler-1000"
	Radius          30384.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3285987505
	}
}

Planet	"Kepler-1001 b/KOI-1889.01"
{
	ParentBody     "Kepler-1001"
	Radius          20089.252
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03916612108
		SemiMajorAxis   0.1128
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1002 b/KOI-1890.01"
{
	ParentBody     "Kepler-1002"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01187275033
		SemiMajorAxis   0.0553
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1003 b/KOI-1893.01"
{
	ParentBody     "Kepler-1003"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009732875908
		SemiMajorAxis   0.0445
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1004 b/KOI-1894.01"
{
	ParentBody     "Kepler-1004"
	Radius          40035.52
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01447778492
		SemiMajorAxis   0.0665
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-1005 b/KOI-1898.01"
{
	ParentBody     "Kepler-1005"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01779097659
		SemiMajorAxis   0.0663
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1006 b/KOI-1899.01"
{
	ParentBody     "Kepler-1006"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05410579875
		SemiMajorAxis   0.1464
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1007 b/KOI-1900.01"
{
	ParentBody     "Kepler-1007"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01419606555
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1008 b/KOI-1904.01"
{
	ParentBody     "Kepler-1008"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03405770822
		SemiMajorAxis   0.102
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1009 b/KOI-1907.01"
{
	ParentBody     "Kepler-1009"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03107559719
		SemiMajorAxis   0.0811
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-101 b/KOI-46.01"
{
	ParentBody     "Kepler-101"
	Mass            50.912
	Radius          37461.808
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009548981736
		SemiMajorAxis   0.048
		Eccentricity    0.086
		Inclination     85.82
		ArgOfPericen    231
	}
}

Planet	"Kepler-101 c/KOI-46.02"
{
	ParentBody     "Kepler-101"
	Mass            3.182
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01650907033
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     84.6
		ArgOfPericen    90
	}
}

Planet	"Kepler-1010 b/KOI-1910.01"
{
	ParentBody     "Kepler-1010"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09382423896
		SemiMajorAxis   0.1925
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1011 b/KOI-1911.01"
{
	ParentBody     "Kepler-1011"
	Radius          18301.952
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01575180012
		SemiMajorAxis   0.0633
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1012 b/KOI-1913.01"
{
	ParentBody     "Kepler-1012"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01508205937
		SemiMajorAxis   0.0598
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1013 b/KOI-1914.01"
{
	ParentBody     "Kepler-1013"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05183012838
		SemiMajorAxis   0.137
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1014 b/KOI-1920.01"
{
	ParentBody     "Kepler-1014"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04537017927
		SemiMajorAxis   0.1204
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1015 b/KOI-1921.01"
{
	ParentBody     "Kepler-1015"
	Radius          22662.964
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04382008044
		SemiMajorAxis   0.1339
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1016 b/KOI-1922.01"
{
	ParentBody     "Kepler-1016"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00535131043
		SemiMajorAxis   0.031
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-1016 c/KOI-1922.03"
{
	ParentBody     "Kepler-1016"
	Radius          23449.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2892741853
		SemiMajorAxis   0.4428
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1017 b/KOI-1923.01"
{
	ParentBody     "Kepler-1017"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01980604895
		SemiMajorAxis   0.0734
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1018 b/KOI-1933.01"
{
	ParentBody     "Kepler-1018"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1344350482
		SemiMajorAxis   0.2657
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1019 b/KOI-1937.01"
{
	ParentBody     "Kepler-1019"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003863819376
		SemiMajorAxis   0.0209
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-102 b/KOI-82.05"
{
	ParentBody     "Kepler-102"
	Mass            0.41366
	Radius          3002.664
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01447521712
		SemiMajorAxis   0.055
		Eccentricity    0
		Inclination     89.56
		ArgOfPericen    360
	}
}

Planet	"Kepler-102 c/KOI-82.04"
{
	ParentBody     "Kepler-102"
	Msini           2.8638
	Radius          3717.584
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01936090681
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-102 d/KOI-82.02"
{
	ParentBody     "Kepler-102"
	Mass            2.60924
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2454972.987
		Period          0.02823249966
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-102 e/KOI-82.01"
{
	ParentBody     "Kepler-102"
	Mass            8.94142
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04420543532
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     89.56
		ArgOfPericen    360
	}
}

Planet	"Kepler-102 f/KOI-82.03"
{
	ParentBody     "Kepler-102"
	Mass            0.6364
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.07516546763
		SemiMajorAxis   0.165
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1020 b/KOI-1938.01"
{
	ParentBody     "Kepler-1020"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2653448925
		SemiMajorAxis   0.3796
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1021 b/KOI-1939.01"
{
	ParentBody     "Kepler-1021"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03689249513
		SemiMajorAxis   0.1029
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1022 b/KOI-1940.01"
{
	ParentBody     "Kepler-1022"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03010248839
		SemiMajorAxis   0.0805
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1023 b/KOI-1945.01"
{
	ParentBody     "Kepler-1023"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1701303221
		SemiMajorAxis   0.3103
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1024 b/KOI-1950.01"
{
	ParentBody     "Kepler-1024"
	Radius          24950.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1818415702
		SemiMajorAxis   0.3022
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1025 b/KOI-1951.01"
{
	ParentBody     "Kepler-1025"
	Radius          12654.084
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1021868512
		SemiMajorAxis   0.2186
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1026 b/KOI-1959.01"
{
	ParentBody     "Kepler-1026"
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09997641651
		SemiMajorAxis   0.1959
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1027 b/KOI-1961.01"
{
	ParentBody     "Kepler-1027"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005223397661
		SemiMajorAxis   0.0296
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1028 b/KOI-1965.01"
{
	ParentBody     "Kepler-1028"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006884813392
		SemiMajorAxis   0.0353
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1029 b/KOI-1967.01"
{
	ParentBody     "Kepler-1029"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01209525242
		SemiMajorAxis   0.0468
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-103 b/KOI-108.01"
{
	ParentBody     "Kepler-103"
	Msini           9.8642
	Radius          22169.6692
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04371158766
		SemiMajorAxis   0.128
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-103 c/KOI-108.02"
{
	ParentBody     "Kepler-103"
	Mass            36.2748
	Radius          33922.954
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.4917649302
		SemiMajorAxis   0.6425
		Eccentricity    0.02
		Inclination     89.38
	}
}

Planet	"Kepler-1030 b/KOI-1971.01"
{
	ParentBody     "Kepler-1030"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05292248458
		SemiMajorAxis   0.1345
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1031 b/KOI-1972.02"
{
	ParentBody     "Kepler-1031"
	Radius          5576.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003357271843
		SemiMajorAxis   0.0229
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1032 b/KOI-1973.01"
{
	ParentBody     "Kepler-1032"
	Radius          11939.164
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009008044638
		SemiMajorAxis   0.0361
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1033 b/KOI-1975.01"
{
	ParentBody     "Kepler-1033"
	Radius          16014.208
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02070004033
		SemiMajorAxis   0.0761
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1034 b/KOI-1976.01"
{
	ParentBody     "Kepler-1034"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03319443856
		SemiMajorAxis   0.0982
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1035 b/KOI-1979.01"
{
	ParentBody     "Kepler-1035"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007430898252
		SemiMajorAxis   0.0344
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1036 b/KOI-1980.01"
{
	ParentBody     "Kepler-1036"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3364365049
		SemiMajorAxis   0.4792
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1037 b/KOI-1981.01"
{
	ParentBody     "Kepler-1037"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002912556927
		SemiMajorAxis   0.0198
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1038 b/KOI-1986.01"
{
	ParentBody     "Kepler-1038"
	Radius          22519.98
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4064709454
		SemiMajorAxis   0.515
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1039 b/KOI-1988.01"
{
	ParentBody     "Kepler-1039"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002559628285
		SemiMajorAxis   0.0184
		Eccentricity    0
		Inclination     74.48
	}
}

Planet	"Kepler-104 b/KOI-111.01"
{
	ParentBody     "Kepler-104"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03128759031
		SemiMajorAxis   0.094
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-104 c/KOI-111.02"
{
	ParentBody     "Kepler-104"
	Radius          19946.268
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06480139934
		SemiMajorAxis   0.153
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-104 d/KOI-111.03"
{
	ParentBody     "Kepler-104"
	Radius          22805.948
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1417015762
		SemiMajorAxis   0.257
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1040 b/KOI-1989.01"
{
	ParentBody     "Kepler-1040"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5506521579
		SemiMajorAxis   0.6291
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1041 b/KOI-1990.01"
{
	ParentBody     "Kepler-1041"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06778417934
		SemiMajorAxis   0.1688
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1042 b/KOI-1996.01"
{
	ParentBody     "Kepler-1042"
	Radius          13940.94
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02774056785
		SemiMajorAxis   0.0756
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1043 b/KOI-1997.01"
{
	ParentBody     "Kepler-1043"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1054241292
		SemiMajorAxis   0.2159
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1044 b/KOI-1998.01"
{
	ParentBody     "Kepler-1044"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01854684061
		SemiMajorAxis   0.0724
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1045 b/KOI-2000.01"
{
	ParentBody     "Kepler-1045"
	Radius          17158.08
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0723094306
		SemiMajorAxis   0.1612
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1046 b/KOI-2002.01"
{
	ParentBody     "Kepler-1046"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03935766664
		SemiMajorAxis   0.1202
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1047 b/KOI-2004.01"
{
	ParentBody     "Kepler-1047"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1538395351
		SemiMajorAxis   0.2855
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1047 c/KOI-2004.02"
{
	ParentBody     "Kepler-1047"
	Radius          6291.296
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008731127177
		SemiMajorAxis   0.0422
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1048 b/KOI-2005.01"
{
	ParentBody     "Kepler-1048"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01894909844
		SemiMajorAxis   0.059
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1049 b/KOI-2006.01"
{
	ParentBody     "Kepler-1049"
	Radius          6076.82
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008962438708
		SemiMajorAxis   0.0334
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-105 b/KOI-115.01"
{
	ParentBody     "Kepler-105"
	Radius          30670.068
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01481811289
		SemiMajorAxis   0.066
		Eccentricity    0.47
		Inclination     85.94
		ArgOfPericen    272.16
	}
}

Planet	"Kepler-105 c/KOI-115.02"
{
	ParentBody     "Kepler-105"
	Mass            4.604354
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01951088948
		SemiMajorAxis   0.072
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1050 b"
{
	ParentBody     "Kepler-1050"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04210563573
	}
}

Planet	"Kepler-1050 c/KOI-2007.02"
{
	ParentBody     "Kepler-1050"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05784779932
		SemiMajorAxis   0.1516
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1051 b/KOI-2010.01"
{
	ParentBody     "Kepler-1051"
	Radius          21662.076
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07108160889
		SemiMajorAxis   0.1792
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1052 b/KOI-2012.01"
{
	ParentBody     "Kepler-1052"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09542661984
		SemiMajorAxis   0.2045
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1053 b/KOI-2013.01"
{
	ParentBody     "Kepler-1053"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006610275913
		SemiMajorAxis   0.0286
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1054 b/KOI-2016.01"
{
	ParentBody     "Kepler-1054"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0117909623
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     77.92
	}
}

Planet	"Kepler-1055 b/KOI-2017.01"
{
	ParentBody     "Kepler-1055"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006283601111
		SemiMajorAxis   0.0323
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1056 b/KOI-2018.01"
{
	ParentBody     "Kepler-1056"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07528047625
		SemiMajorAxis   0.1629
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1057 b/KOI-2019.01"
{
	ParentBody     "Kepler-1057"
	Radius          21447.6
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03857241817
		SemiMajorAxis   0.1138
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1058 b/KOI-2020.01"
{
	ParentBody     "Kepler-1058"
	Radius          17372.556
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3038133685
		SemiMajorAxis   0.3679
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1059 b/KOI-2021.01"
{
	ParentBody     "Kepler-1059"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0103060138
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-106 b/KOI-116.03"
{
	ParentBody     "Kepler-106"
	Msini           0.149554
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01687882772
		SemiMajorAxis   0.0646
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-106 c/KOI-116.01"
{
	ParentBody     "Kepler-106"
	Mass            10.45287
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03715561996
		SemiMajorAxis   0.1093
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-106 d/KOI-116.04"
{
	ParentBody     "Kepler-106"
	Mass            7.955
	Radius          6076.82
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06565561336
		SemiMajorAxis   0.1597
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-106 e/KOI-116.02"
{
	ParentBody     "Kepler-106"
	Msini           11.181548
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1200422657
		SemiMajorAxis   0.2388
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1060 b/KOI-2024.01"
{
	ParentBody     "Kepler-1060"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1283475404
		SemiMajorAxis   0.238
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1061 b/KOI-2026.01"
{
	ParentBody     "Kepler-1061"
	Radius          12654.084
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007551106489
		SemiMajorAxis   0.0395
		Eccentricity    0
		Inclination     73.34
	}
}

Planet	"Kepler-1062 b/KOI-2031.01"
{
	ParentBody     "Kepler-1062"
	Radius          11224.244
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02547383911
		SemiMajorAxis   0.0748
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1063 b/KOI-2032.01"
{
	ParentBody     "Kepler-1063"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03854898216
		SemiMajorAxis   0.1105
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1064 b/KOI-2033.01"
{
	ParentBody     "Kepler-1064"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04528721949
		SemiMajorAxis   0.1126
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1065 b/KOI-2034.01"
{
	ParentBody     "Kepler-1065"
	Radius          23806.836
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009881960546
		SemiMajorAxis   0.0455
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1065 c/KOI-2034.02"
{
	ParentBody     "Kepler-1065"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006489686832
		SemiMajorAxis   0.0344
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1066 b/KOI-2035.01"
{
	ParentBody     "Kepler-1066"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005288435711
		SemiMajorAxis   0.0284
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-1067 b/KOI-2039.02"
{
	ParentBody     "Kepler-1067"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002086640813
		SemiMajorAxis   0.0158
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1068 b/KOI-2044.01"
{
	ParentBody     "Kepler-1068"
	Radius          23163.408
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0463348474
		SemiMajorAxis   0.134
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1069 b/KOI-2046.01"
{
	ParentBody     "Kepler-1069"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06543337617
		SemiMajorAxis   0.1632
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-107 b/KOI-117.03"
{
	ParentBody     "Kepler-107"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008706622861
		SemiMajorAxis   0.044
		Eccentricity    0.02
		Inclination     87.66
	}
}

Planet	"Kepler-107 c/KOI-117.02"
{
	ParentBody     "Kepler-107"
	Radius          10616.562
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01341970105
		SemiMajorAxis   0.059
		Eccentricity    0.02
		Inclination     81.93
	}
}

Planet	"Kepler-107 d/KOI-117.04"
{
	ParentBody     "Kepler-107"
	Radius          6786.02064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02178896694
		SemiMajorAxis   0.082
		Eccentricity    0.14
		Inclination     89.38
	}
}

Planet	"Kepler-107 e/KOI-117.01"
{
	ParentBody     "Kepler-107"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04038190661
		SemiMajorAxis   0.123
		Eccentricity    0.02
		Inclination     87.09
	}
}

Planet	"Kepler-1070 b/KOI-2047.01"
{
	ParentBody     "Kepler-1070"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01703421695
		SemiMajorAxis   0.0708
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1071 b/KOI-2048.01"
{
	ParentBody     "Kepler-1071"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01692023696
		SemiMajorAxis   0.0533
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1072 b/KOI-2049.01"
{
	ParentBody     "Kepler-1072"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004295961813
		SemiMajorAxis   0.0282
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1073 b/KOI-2055.01"
{
	ParentBody     "Kepler-1073"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02376200278
		SemiMajorAxis   0.0802
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1073 c/KOI-2055.02"
{
	ParentBody     "Kepler-1073"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0110223371
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1074 b/KOI-2057.01"
{
	ParentBody     "Kepler-1074"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01627869262
		SemiMajorAxis   0.053
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1075 b/KOI-2058.01"
{
	ParentBody     "Kepler-1075"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004171829549
		SemiMajorAxis   0.0214
		Eccentricity    0
		Inclination     76.2
	}
}

Planet	"Kepler-1076 b/KOI-2059.01"
{
	ParentBody     "Kepler-1076"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01683069303
		SemiMajorAxis   0.0611
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1077 b/KOI-2062.01"
{
	ParentBody     "Kepler-1077"
	Radius          17658.524
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09405043654
		SemiMajorAxis   0.2101
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1078 b/KOI-2063.01"
{
	ParentBody     "Kepler-1078"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008233584464
		SemiMajorAxis   0.0387
		Eccentricity    0
		Inclination     72.19
	}
}

Planet	"Kepler-1079 b/KOI-2067.01"
{
	ParentBody     "Kepler-1079"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03626369639
		SemiMajorAxis   0.1231
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-108 b/KOI-119.01"
{
	ParentBody     "Kepler-108"
	Radius          60975.5268
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1346600731
		SemiMajorAxis   0.292
		Eccentricity    0.22
		Inclination     89.38
	}
}

Planet	"Kepler-108 c/KOI-119.02"
{
	ParentBody     "Kepler-108"
	Radius          52475.128
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.5210884703
		SemiMajorAxis   0.721
		Eccentricity    0.04
		Inclination     89.38
	}
}

Planet	"Kepler-1080 b/KOI-2069.01"
{
	ParentBody     "Kepler-1080"
	Radius          20947.156
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2115167463
		SemiMajorAxis   0.3799
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1081 b/KOI-2071.01"
{
	ParentBody     "Kepler-1081"
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01055989329
		SemiMajorAxis   0.0478
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1082 b/KOI-2072.01"
{
	ParentBody     "Kepler-1082"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004225159751
		SemiMajorAxis   0.0255
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1083 b/KOI-2074.01"
{
	ParentBody     "Kepler-1083"
	Radius          21447.6
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09149490456
		SemiMajorAxis   0.1898
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1084 b/KOI-2075.01"
{
	ParentBody     "Kepler-1084"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005621849959
		SemiMajorAxis   0.0316
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1085 b/KOI-2076.02"
{
	ParentBody     "Kepler-1085"
	Radius          46040.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.6004830737
		SemiMajorAxis   0.7391
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1086 b/KOI-2078.01"
{
	ParentBody     "Kepler-1086"
	Radius          15585.256
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0514295933
		SemiMajorAxis   0.1183
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1086 c/KOI-2078.02"
{
	ParentBody     "Kepler-1086"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4422170795
		SemiMajorAxis   0.4964
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1087 b/KOI-2079.01"
{
	ParentBody     "Kepler-1087"
	Radius          3860.568
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001899678814
		SemiMajorAxis   0.0154
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1088 b/KOI-2087.01"
{
	ParentBody     "Kepler-1088"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06332096095
		SemiMajorAxis   0.1593
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1089 b/KOI-2090.01"
{
	ParentBody     "Kepler-1089"
	Radius          11653.196
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01405228027
		SemiMajorAxis   0.0466
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-109 b/KOI-123.01"
{
	ParentBody     "Kepler-109"
	Mass            1.30462
	Radius          14913.2312
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01774613443
		SemiMajorAxis   0.069
		Eccentricity    0.21
		Inclination     89.38
	}
}

Planet	"Kepler-109 c/KOI-123.02"
{
	ParentBody     "Kepler-109"
	Mass            2.221036
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05810560935
		SemiMajorAxis   0.1521
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-1090 b/KOI-2094.02"
{
	ParentBody     "Kepler-1090"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5439683162
		SemiMajorAxis   0.619
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1091 b/KOI-2095.01"
{
	ParentBody     "Kepler-1091"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003928192306
		SemiMajorAxis   0.0232
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1092 b/KOI-2097.01"
{
	ParentBody     "Kepler-1092"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1604463946
		SemiMajorAxis   0.2996
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1093 b/KOI-2098.01"
{
	ParentBody     "Kepler-1093"
	Radius          12439.608
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06867350842
		SemiMajorAxis   0.1685
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1093 c/KOI-2098.02"
{
	ParentBody     "Kepler-1093"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2456515005
		SemiMajorAxis   0.394
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1094 b/KOI-2099.01"
{
	ParentBody     "Kepler-1094"
	Radius          20303.728
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2138307821
		SemiMajorAxis   0.3653
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1095 b/KOI-2100.01"
{
	ParentBody     "Kepler-1095"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01169369539
		SemiMajorAxis   0.0514
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1096 b/KOI-2101.01"
{
	ParentBody     "Kepler-1096"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007918629311
		SemiMajorAxis   0.0336
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1097 b/KOI-2102.01"
{
	ParentBody     "Kepler-1097"
	Radius          20804.172
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5140343427
		SemiMajorAxis   0.5791
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1098 b/KOI-2103.01"
{
	ParentBody     "Kepler-1098"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006962702915
		SemiMajorAxis   0.0346
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1099 b/KOI-2104.01"
{
	ParentBody     "Kepler-1099"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005937026582
		SemiMajorAxis   0.0337
		Eccentricity    0
		Inclination     77.35
	}
}

Planet	"Kepler-11 b/KOI-157.06"
{
	ParentBody     "Kepler-11"
	Mass            1.902211874
	Radius          11480.58075
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02821073328
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     88.5
	}
}

Planet	"Kepler-11 c/KOI-157.01"
{
	ParentBody     "Kepler-11"
	Mass            2.903376019
	Radius          18305.14819
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03566132381
		SemiMajorAxis   0.106
		Eccentricity    0
		Inclination     89
	}
}

Planet	"Kepler-11 d/KOI-157.02"
{
	ParentBody     "Kepler-11"
	Mass            7.308498254
	Radius          19899.6733
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.06211546922
		SemiMajorAxis   0.159
		Eccentricity    0
		Inclination     89.3
	}
}

Planet	"Kepler-11 e/KOI-157.03"
{
	ParentBody     "Kepler-11"
	Mass            9.546
	Radius          26738.008
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.08760187319
		SemiMajorAxis   0.194
		Eccentricity    0
		Inclination     88.8
	}
}

Planet	"Kepler-11 f/KOI-157.04"
{
	ParentBody     "Kepler-11"
	Mass            2.002328289
	Radius          15881.47004
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1278295917
		SemiMajorAxis   0.25
		Eccentricity    0
		Inclination     89.4
	}
}

Planet	"Kepler-11 g/KOI-157.05"
{
	ParentBody     "Kepler-11"
	Mass            302.29
	Radius          23406.4808
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.324107519
		SemiMajorAxis   0.462
		Eccentricity    0
		Inclination     89.8
	}
}

Planet	"Kepler-110 b/KOI-124.01"
{
	ParentBody     "Kepler-110"
	Radius          11653.196
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03474711398
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-110 c/KOI-124.02"
{
	ParentBody     "Kepler-110"
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08684586798
		SemiMajorAxis   0.198
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1100 b/KOI-2105.01"
{
	ParentBody     "Kepler-1100"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01758285532
		SemiMajorAxis   0.0689
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1101 b/KOI-2107.01"
{
	ParentBody     "Kepler-1101"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2226333873
		SemiMajorAxis   0.3522
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1102 b/KOI-2108.01"
{
	ParentBody     "Kepler-1102"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1405329497
		SemiMajorAxis   0.2731
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1103 b/KOI-2109.01"
{
	ParentBody     "Kepler-1103"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05418848186
		SemiMajorAxis   0.1475
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1104 b/KOI-2110.01"
{
	ParentBody     "Kepler-1104"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01379161633
		SemiMajorAxis   0.0614
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1105 b/KOI-2114.01"
{
	ParentBody     "Kepler-1105"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01210586373
		SemiMajorAxis   0.0461
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1106 b/KOI-2116.01"
{
	ParentBody     "Kepler-1106"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003429921857
		SemiMajorAxis   0.0229
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1107 b/KOI-2119.01"
{
	ParentBody     "Kepler-1107"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001563451693
		SemiMajorAxis   0.0129
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1108 b/KOI-2121.01"
{
	ParentBody     "Kepler-1108"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01234812846
		SemiMajorAxis   0.0513
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1109 b/KOI-2122.01"
{
	ParentBody     "Kepler-1109"
	Radius          13940.94
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1030733564
		SemiMajorAxis   0.2116
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-111 b/KOI-139.02"
{
	ParentBody     "Kepler-111"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009149586474
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     76.2
	}
}

Planet	"Kepler-111 c/KOI-139.01"
{
	ParentBody     "Kepler-111"
	Radius          46541.292
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.6154398759
		SemiMajorAxis   0.761
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1110 b/KOI-2126.01"
{
	ParentBody     "Kepler-1110"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02653888458
		SemiMajorAxis   0.0754
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1111 b/KOI-2129.01"
{
	ParentBody     "Kepler-1111"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02408313956
		SemiMajorAxis   0.0872
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1112 b/KOI-2131.01"
{
	ParentBody     "Kepler-1112"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03932371393
		SemiMajorAxis   0.1273
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1113 b/KOI-2134.01"
{
	ParentBody     "Kepler-1113"
	Radius          17944.492
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1158149211
		SemiMajorAxis   0.2323
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1114 b/KOI-2137.01"
{
	ParentBody     "Kepler-1114"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04099843161
		SemiMajorAxis   0.1103
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1115 b/KOI-2138.01/KOI-2138 b"
{
	ParentBody     "Kepler-1115"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0644889149
		SemiMajorAxis   0.21
		Eccentricity    0
		Inclination     88.34
	}
}

Planet	"Kepler-1116 b/KOI-2140.01"
{
	ParentBody     "Kepler-1116"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1141647484
		SemiMajorAxis   0.2331
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1117 b/KOI-2143.01"
{
	ParentBody     "Kepler-1117"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01311536488
		SemiMajorAxis   0.0538
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1118 b/KOI-2144.01"
{
	ParentBody     "Kepler-1118"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1058790813
		SemiMajorAxis   0.2079
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1119 b/KOI-2145.01"
{
	ParentBody     "Kepler-1119"
	Radius          12225.132
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02279724394
		SemiMajorAxis   0.0812
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-112 b/KOI-150.01"
{
	ParentBody     "Kepler-112"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02302274555
		SemiMajorAxis   0.076
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-112 c/KOI-150.02"
{
	ParentBody     "Kepler-112"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07823374132
		SemiMajorAxis   0.172
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1120 b/KOI-2146.01"
{
	ParentBody     "Kepler-1120"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008074174156
		SemiMajorAxis   0.0369
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1121 b/KOI-2149.01"
{
	ParentBody     "Kepler-1121"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03600737038
		SemiMajorAxis   0.1154
		Eccentricity    0
		Inclination     82.51
	}
}

Planet	"Kepler-1122 b/KOI-2152.01"
{
	ParentBody     "Kepler-1122"
	Radius          13011.544
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1155171469
		SemiMajorAxis   0.2335
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1123 b/KOI-2155.01"
{
	ParentBody     "Kepler-1123"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01188106046
		SemiMajorAxis   0.0517
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1124 b/KOI-2156.01"
{
	ParentBody     "Kepler-1124"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007809472863
		SemiMajorAxis   0.0309
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1125 b/KOI-2160.01"
{
	ParentBody     "Kepler-1125"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04837903367
		SemiMajorAxis   0.1283
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1126 b/KOI-2162.01"
{
	ParentBody     "Kepler-1126"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2973186889
		SemiMajorAxis   0.4358
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1127 b/KOI-2164.01"
{
	ParentBody     "Kepler-1127"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01402714038
		SemiMajorAxis   0.0547
		Eccentricity    0
		Inclination     80.79
	}
}

Planet	"Kepler-1128 b/KOI-2166.01"
{
	ParentBody     "Kepler-1128"
	Radius          23306.392
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1687039954
		SemiMajorAxis   0.3073
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1129 b/KOI-2167.01"
{
	ParentBody     "Kepler-1129"
	Radius          18873.888
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06664011189
		SemiMajorAxis   0.1631
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1129 c/KOI-2167.03"
{
	ParentBody     "Kepler-1129"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2095512532
		SemiMajorAxis   0.3502
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-113 b/KOI-153.02"
{
	ParentBody     "Kepler-113"
	Mass            11.70976
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01301602096
		SemiMajorAxis   0.0491
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-113 c/KOI-153.01"
{
	ParentBody     "Kepler-113"
	Msini           8.5914
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02443603244
		SemiMajorAxis   0.0747
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1130 b/KOI-2169.01"
{
	ParentBody     "Kepler-1130"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01492976962
		SemiMajorAxis   0.0596
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1131 b/KOI-2171.01"
{
	ParentBody     "Kepler-1131"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009671184185
		SemiMajorAxis   0.0458
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1132 b/KOI-2177.01"
{
	ParentBody     "Kepler-1132"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.172191561
		SemiMajorAxis   0.2867
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1133 b/KOI-2180.01"
{
	ParentBody     "Kepler-1133"
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03163824923
		SemiMajorAxis   0.0959
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1134 b/KOI-2182.01"
{
	ParentBody     "Kepler-1134"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04690761464
		SemiMajorAxis   0.1243
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1135 b/KOI-2185.01"
{
	ParentBody     "Kepler-1135"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2107036348
		SemiMajorAxis   0.3436
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1136 b/KOI-2193.01"
{
	ParentBody     "Kepler-1136"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006466187083
		SemiMajorAxis   0.0299
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1137 b/KOI-2198.01"
{
	ParentBody     "Kepler-1137"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0654937457
		SemiMajorAxis   0.1847
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1138 b/KOI-2200.01"
{
	ParentBody     "Kepler-1138"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008680815465
		SemiMajorAxis   0.0394
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1139 b/KOI-2202.01"
{
	ParentBody     "Kepler-1139"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002226376751
		SemiMajorAxis   0.0163
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-114 b/KOI-156.02"
{
	ParentBody     "Kepler-114"
	Mass            7.00814901
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01420577673
		SemiMajorAxis   0.053
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-114 c/KOI-156.01"
{
	ParentBody     "Kepler-114"
	Mass            40.04656577
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02201552894
		SemiMajorAxis   0.07
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-114 d/KOI-156.03"
{
	ParentBody     "Kepler-114"
	Mass            4.80482
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.03224162029
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1140 b/KOI-2205.01"
{
	ParentBody     "Kepler-1140"
	Radius          17658.524
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06594602532
		SemiMajorAxis   0.1478
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1141 b/KOI-2208.01"
{
	ParentBody     "Kepler-1141"
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006419061119
		SemiMajorAxis   0.0342
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1142 b/KOI-2209.01"
{
	ParentBody     "Kepler-1142"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05011120103
		SemiMajorAxis   0.1274
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1143 b/KOI-2210.01"
{
	ParentBody     "Kepler-1143"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007909559548
		SemiMajorAxis   0.0347
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1143 c/KOI-2210.02"
{
	ParentBody     "Kepler-1143"
	Radius          22948.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5766874607
		SemiMajorAxis   0.605
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1144 b/KOI-2212.01"
{
	ParentBody     "Kepler-1144"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04694548849
		SemiMajorAxis   0.1264
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1145 b/KOI-2213.01"
{
	ParentBody     "Kepler-1145"
	Radius          8936.5
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01087160183
		SemiMajorAxis   0.0443
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1146 b/KOI-2214.01"
{
	ParentBody     "Kepler-1146"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006440290485
		SemiMajorAxis   0.0324
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1147 b/KOI-2221.01"
{
	ParentBody     "Kepler-1147"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02909808961
		SemiMajorAxis   0.0961
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-1148 b/KOI-2223.01"
{
	ParentBody     "Kepler-1148"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003023920951
		SemiMajorAxis   0.0188
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1149 b/KOI-2224.01"
{
	ParentBody     "Kepler-1149"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01021486313
		SemiMajorAxis   0.0466
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-115 b/KOI-159.02"
{
	ParentBody     "Kepler-115"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006581055165
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-115 c/KOI-159.01"
{
	ParentBody     "Kepler-115"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0246162389
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1150 b/KOI-2225.01"
{
	ParentBody     "Kepler-1150"
	Radius          6505.772
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007632930881
		SemiMajorAxis   0.0382
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1151 b/KOI-2227.01"
{
	ParentBody     "Kepler-1151"
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1797378403
		SemiMajorAxis   0.3007
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1152 b/KOI-2238.01"
{
	ParentBody     "Kepler-1152"
	Radius          5576.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004508794317
		SemiMajorAxis   0.0225
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1153 b/KOI-2242.01"
{
	ParentBody     "Kepler-1153"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004807317935
		SemiMajorAxis   0.0277
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1154 b/KOI-2243.01"
{
	ParentBody     "Kepler-1154"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01419774151
		SemiMajorAxis   0.0604
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1154 c/KOI-2243.02"
{
	ParentBody     "Kepler-1154"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0231574647
		SemiMajorAxis   0.0837
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1155 b/KOI-2245.01"
{
	ParentBody     "Kepler-1155"
	Radius          12940.052
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0916371217
		SemiMajorAxis   0.2006
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1156 b/KOI-2246.01"
{
	ParentBody     "Kepler-1156"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03256799308
		SemiMajorAxis   0.1025
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1157 b/KOI-2247.01"
{
	ParentBody     "Kepler-1157"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01220404368
		SemiMajorAxis   0.0448
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-1158 b/KOI-2252.01"
{
	ParentBody     "Kepler-1158"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03707027741
		SemiMajorAxis   0.1174
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1159 b/KOI-2253.01"
{
	ParentBody     "Kepler-1159"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06217290483
		SemiMajorAxis   0.1603
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-116 b/KOI-171.01"
{
	ParentBody     "Kepler-116"
	Radius          21805.06
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01634185252
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-116 c/KOI-171.02"
{
	ParentBody     "Kepler-116"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03578893776
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1160 b/KOI-2255.01"
{
	ParentBody     "Kepler-1160"
	Radius          13654.972
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02182209449
		SemiMajorAxis   0.0755
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1161 b/KOI-2256.01"
{
	ParentBody     "Kepler-1161"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02932992329
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1162 b/KOI-2257.01"
{
	ParentBody     "Kepler-1162"
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.089156477
		SemiMajorAxis   0.194
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1163 b/KOI-2260.01"
{
	ParentBody     "Kepler-1163"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01675017057
		SemiMajorAxis   0.0679
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1164 b/KOI-2261.01"
{
	ParentBody     "Kepler-1164"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01088592115
		SemiMajorAxis   0.0456
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1165 b/KOI-2263.02"
{
	ParentBody     "Kepler-1165"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02595133384
		SemiMajorAxis   0.0905
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1166 b/KOI-2264.01"
{
	ParentBody     "Kepler-1166"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09100999042
		SemiMajorAxis   0.1957
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1167 b/KOI-2266.01"
{
	ParentBody     "Kepler-1167"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002748679555
		SemiMajorAxis   0.0175
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1168 b/KOI-2271.01"
{
	ParentBody     "Kepler-1168"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.152837365
		SemiMajorAxis   0.2661
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1169 b/KOI-2273.01"
{
	ParentBody     "Kepler-1169"
	Radius          6005.328
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0167288761
		SemiMajorAxis   0.0681
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-117 b/KOI-209.02"
{
	ParentBody     "Kepler-117"
	Mass            29.9108
	Radius          49829.924
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05146161238
		SemiMajorAxis   0.148
		Eccentricity    0.0493
		Inclination     88.74
		ArgOfPericen    254.3
	}
}

Planet	"Kepler-117 c/KOI-209.01"
{
	ParentBody     "Kepler-117"
	Mass            585.488
	Radius          72063.936
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.139059543
		SemiMajorAxis   0.287
		Eccentricity    0.0323
		Inclination     89.64
		ArgOfPericen    305
	}
}

Planet	"Kepler-1170 b/KOI-2274.01"
{
	ParentBody     "Kepler-1170"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02735087443
		SemiMajorAxis   0.0882
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1171 b/KOI-2276.01"
{
	ParentBody     "Kepler-1171"
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003949686756
		SemiMajorAxis   0.0284
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1172 b/KOI-2280.01"
{
	ParentBody     "Kepler-1172"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07124161179
		SemiMajorAxis   0.1716
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1173 b/KOI-2281.01"
{
	ParentBody     "Kepler-1173"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002107789356
		SemiMajorAxis   0.0158
		Eccentricity    0
		Inclination     82.51
	}
}

Planet	"Kepler-1174 b/KOI-2282.01"
{
	ParentBody     "Kepler-1174"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0188703617
		SemiMajorAxis   0.0712
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1175 b/KOI-2285.01"
{
	ParentBody     "Kepler-1175"
	Radius          19088.364
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1038916945
		SemiMajorAxis   0.2183
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1176 b/KOI-2286.01"
{
	ParentBody     "Kepler-1176"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06618583113
		SemiMajorAxis   0.1557
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1177 b/KOI-2296.01"
{
	ParentBody     "Kepler-1177"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2908961504
		SemiMajorAxis   0.4383
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1178 b"
{
	ParentBody     "Kepler-1178"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0870828751
	}
}

Planet	"Kepler-1179 b/KOI-2300.01"
{
	ParentBody     "Kepler-1179"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007351443959
		SemiMajorAxis   0.0346
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-118 b/KOI-216.02"
{
	ParentBody     "Kepler-118"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02058496036
		SemiMajorAxis   0.073
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-118 c/KOI-216.01"
{
	ParentBody     "Kepler-118"
	Radius          48972.02
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0552291618
		SemiMajorAxis   0.141
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1180 b/KOI-2302.01"
{
	ParentBody     "Kepler-1180"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04616150343
		SemiMajorAxis   0.1246
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1181 b/KOI-2303.01"
{
	ParentBody     "Kepler-1181"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0133976176
		SemiMajorAxis   0.0621
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1182 b/KOI-2304.01"
{
	ParentBody     "Kepler-1182"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03059325149
		SemiMajorAxis   0.0981
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1183 b/KOI-2308.01"
{
	ParentBody     "Kepler-1183"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07804607379
		SemiMajorAxis   0.1793
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1184 b/KOI-2309.01"
{
	ParentBody     "Kepler-1184"
	Radius          17086.588
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1467494881
		SemiMajorAxis   0.2863
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1185 b/KOI-2311.03"
{
	ParentBody     "Kepler-1185"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2857060342
		SemiMajorAxis   0.4425
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1186 b/KOI-2313.01"
{
	ParentBody     "Kepler-1186"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04401675545
		SemiMajorAxis   0.1281
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1187 b/KOI-2314.01"
{
	ParentBody     "Kepler-1187"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05166610322
		SemiMajorAxis   0.1401
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1188 b/KOI-2316.01"
{
	ParentBody     "Kepler-1188"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0469194271
		SemiMajorAxis   0.1344
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1189 b/KOI-2317.01"
{
	ParentBody     "Kepler-1189"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01037281542
		SemiMajorAxis   0.049
		Eccentricity    0
		Inclination     69.9
	}
}

Planet	"Kepler-119 b/KOI-220.01"
{
	ParentBody     "Kepler-119"
	Radius          22948.932
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00663144091
		SemiMajorAxis   0.035
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-119 c/KOI-220.02"
{
	ParentBody     "Kepler-119"
	Radius          5862.344
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.011294158
		SemiMajorAxis   0.049
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1190 b/KOI-2318.01"
{
	ParentBody     "Kepler-1190"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02863424517
		SemiMajorAxis   0.0823
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1191 b/KOI-2327.01"
{
	ParentBody     "Kepler-1191"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01533269887
		SemiMajorAxis   0.0597
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1192 b/KOI-2328.01"
{
	ParentBody     "Kepler-1192"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06900483953
		SemiMajorAxis   0.1693
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1193 b/KOI-2331.01"
{
	ParentBody     "Kepler-1193"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007755544701
		SemiMajorAxis   0.0397
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1194 b/KOI-2335.01"
{
	ParentBody     "Kepler-1194"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04441905541
		SemiMajorAxis   0.121
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1195 b/KOI-2337.01"
{
	ParentBody     "Kepler-1195"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0232624342
		SemiMajorAxis   0.0726
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1196 b/KOI-2338.01"
{
	ParentBody     "Kepler-1196"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1812082638
		SemiMajorAxis   0.3146
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1197 b/KOI-2339.01"
{
	ParentBody     "Kepler-1197"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00556430365
		SemiMajorAxis   0.0271
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1198 b/KOI-2340.01"
{
	ParentBody     "Kepler-1198"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02104020788
		SemiMajorAxis   0.0766
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1199 b/KOI-2342.01"
{
	ParentBody     "Kepler-1199"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04119107874
		SemiMajorAxis   0.1155
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-12 b/KOI-20.01"
{
	ParentBody     "Kepler-12"
	Mass            137.4624
	Radius          125396.968
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01215074004
		SemiMajorAxis   0.0553
		Eccentricity    0.01
		Inclination     88.796
		ArgOfPericen    182
	}
}

Planet	"Kepler-120 b/KOI-222.01"
{
	ParentBody     "Kepler-120"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0172830554
		SemiMajorAxis   0.055
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-120 c/KOI-222.02"
{
	ParentBody     "Kepler-120"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03503041367
		SemiMajorAxis   0.088
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1200 b/KOI-2344.01"
{
	ParentBody     "Kepler-1200"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003062487717
		SemiMajorAxis   0.0189
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1201 b/KOI-2345.01"
{
	ParentBody     "Kepler-1201"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04158133902
		SemiMajorAxis   0.1183
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1202 b/KOI-2346.01"
{
	ParentBody     "Kepler-1202"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07853729169
		SemiMajorAxis   0.1784
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1203 b/KOI-2347.01"
{
	ParentBody     "Kepler-1203"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001609892768
		SemiMajorAxis   0.0114
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1204 b/KOI-2348.01"
{
	ParentBody     "Kepler-1204"
	Radius          19445.824
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2347347346
		SemiMajorAxis   0.3877
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1205 b/KOI-2350.01"
{
	ParentBody     "Kepler-1205"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002952535003
		SemiMajorAxis   0.0196
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1206 b/KOI-2355.01"
{
	ParentBody     "Kepler-1206"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00333202925
		SemiMajorAxis   0.0201
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1207 b/KOI-2356.01"
{
	ParentBody     "Kepler-1207"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03746109176
		SemiMajorAxis   0.1156
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1208 b/KOI-2362.02"
{
	ParentBody     "Kepler-1208"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03034993404
		SemiMajorAxis   0.0901
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1209 b/KOI-2366.01"
{
	ParentBody     "Kepler-1209"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06945833944
		SemiMajorAxis   0.1801
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-121 b/KOI-223.01"
{
	ParentBody     "Kepler-121"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008699493345
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-121 c/KOI-223.02"
{
	ParentBody     "Kepler-121"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.112276216
		SemiMajorAxis   0.216
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1210 b/KOI-2368.01"
{
	ParentBody     "Kepler-1210"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02209832531
		SemiMajorAxis   0.0753
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1211 b/KOI-2369.01"
{
	ParentBody     "Kepler-1211"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03016674597
		SemiMajorAxis   0.0985
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1212 b/KOI-2371.01"
{
	ParentBody     "Kepler-1212"
	Radius          13654.972
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03543211003
		SemiMajorAxis   0.1082
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1213 b/KOI-2372.01"
{
	ParentBody     "Kepler-1213"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01464733338
		SemiMajorAxis   0.0599
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1214 b/KOI-2376.01"
{
	ParentBody     "Kepler-1214"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0515448192
		SemiMajorAxis   0.128
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1215 b/KOI-2378.01"
{
	ParentBody     "Kepler-1215"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01305172229
		SemiMajorAxis   0.0528
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1216 b/KOI-2383.01"
{
	ParentBody     "Kepler-1216"
	Radius          8865.008
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01196560934
		SemiMajorAxis   0.0543
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1217 b/KOI-2387.01"
{
	ParentBody     "Kepler-1217"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005564321775
		SemiMajorAxis   0.0326
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1218 b/KOI-2389.01"
{
	ParentBody     "Kepler-1218"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06275870433
		SemiMajorAxis   0.1564
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1219 b/KOI-2390.01"
{
	ParentBody     "Kepler-1219"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04409314679
		SemiMajorAxis   0.1245
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-122 b/KOI-232.02"
{
	ParentBody     "Kepler-122"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01578731362
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-122 c/KOI-232.01"
{
	ParentBody     "Kepler-122"
	Radius          37461.808
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03413074488
		SemiMajorAxis   0.108
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-122 d/KOI-232.03"
{
	ParentBody     "Kepler-122"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05910454926
		SemiMajorAxis   0.155
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-122 e/KOI-232.04"
{
	ParentBody     "Kepler-122"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1040221367
		SemiMajorAxis   0.227
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-122 f/KOI-232.05"
{
	ParentBody     "Kepler-122"
	Mass            35.9566
	Radius          11152.752
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1540566823
		SemiMajorAxis   0.2903
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1220 b/KOI-2392.01"
{
	ParentBody     "Kepler-1220"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02033428124
		SemiMajorAxis   0.0685
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1221 b/KOI-2397.01"
{
	ParentBody     "Kepler-1221"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03285754153
		SemiMajorAxis   0.0906
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1222 b/KOI-2399.01"
{
	ParentBody     "Kepler-1222"
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005248419551
		SemiMajorAxis   0.0274
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1223 b/KOI-2402.01"
{
	ParentBody     "Kepler-1223"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04463136914
		SemiMajorAxis   0.1187
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1224 b/KOI-2403.01"
{
	ParentBody     "Kepler-1224"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03647857882
		SemiMajorAxis   0.1108
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1225 b/KOI-2406.01"
{
	ParentBody     "Kepler-1225"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01919480973
		SemiMajorAxis   0.0738
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1226 b/KOI-2407.01"
{
	ParentBody     "Kepler-1226"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04734487357
		SemiMajorAxis   0.1323
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1227 b/KOI-2408.01"
{
	ParentBody     "Kepler-1227"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2581540696
		SemiMajorAxis   0.3816
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1228 b/KOI-2409.01"
{
	ParentBody     "Kepler-1228"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001580785561
		SemiMajorAxis   0.0124
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1229 b/KOI-2418.01"
{
	ParentBody     "Kepler-1229"
	Radius          8936.5
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2377298993
		SemiMajorAxis   0.2899
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-123 b/KOI-238.01"
{
	ParentBody     "Kepler-123"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04718065568
		SemiMajorAxis   0.135
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-123 c/KOI-238.02"
{
	ParentBody     "Kepler-123"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07308869222
		SemiMajorAxis   0.181
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1230 b/KOI-2419.01"
{
	ParentBody     "Kepler-1230"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02726031014
		SemiMajorAxis   0.0921
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1231 b/KOI-2420.01"
{
	ParentBody     "Kepler-1231"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02852149103
		SemiMajorAxis   0.0936
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1232 b/KOI-2422.01"
{
	ParentBody     "Kepler-1232"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07333193986
		SemiMajorAxis   0.1701
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1233 b/KOI-2423.01"
{
	ParentBody     "Kepler-1233"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1235517294
		SemiMajorAxis   0.2627
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1234 b/KOI-2424.01"
{
	ParentBody     "Kepler-1234"
	Radius          17944.492
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03269102152
		SemiMajorAxis   0.0963
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-1235 b/KOI-2426.01"
{
	ParentBody     "Kepler-1235"
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01139123211
		SemiMajorAxis   0.049
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1236 b/KOI-2432.01"
{
	ParentBody     "Kepler-1236"
	Radius          13654.972
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08503169312
		SemiMajorAxis   0.1799
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1237 b/KOI-2436.01"
{
	ParentBody     "Kepler-1237"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2315540892
		SemiMajorAxis   0.3778
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1238 b/KOI-2437.01"
{
	ParentBody     "Kepler-1238"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01135650729
		SemiMajorAxis   0.0546
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1239 b/KOI-2439.01"
{
	ParentBody     "Kepler-1239"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0142125973
		SemiMajorAxis   0.0626
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-124 b/KOI-241.03"
{
	ParentBody     "Kepler-124"
	Radius          4646.98
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009337620611
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-124 c/KOI-241.01"
{
	ParentBody     "Kepler-124"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03784167159
		SemiMajorAxis   0.1
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-124 d/KOI-241.02"
{
	ParentBody     "Kepler-124"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08474062378
		SemiMajorAxis   0.17
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1240 b/KOI-2440.01"
{
	ParentBody     "Kepler-1240"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01332371132
		SemiMajorAxis   0.0534
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1241 b/KOI-2444.01"
{
	ParentBody     "Kepler-1241"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05079525481
		SemiMajorAxis   0.1334
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1242 b/KOI-2448.01"
{
	ParentBody     "Kepler-1242"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03731218544
		SemiMajorAxis   0.1039
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1243 b/KOI-2450.01"
{
	ParentBody     "Kepler-1243"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04608468947
		SemiMajorAxis   0.1243
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1244 b/KOI-2457.01"
{
	ParentBody     "Kepler-1244"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01014198749
		SemiMajorAxis   0.049
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1245 b/KOI-2458.01"
{
	ParentBody     "Kepler-1245"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01192111197
		SemiMajorAxis   0.0484
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1245 c/KOI-2458.02"
{
	ParentBody     "Kepler-1245"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008040102599
		SemiMajorAxis   0.0372
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1246 b/KOI-2460.01"
{
	ParentBody     "Kepler-1246"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03100056742
		SemiMajorAxis   0.0848
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1247 b/KOI-2461.01"
{
	ParentBody     "Kepler-1247"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03754276617
		SemiMajorAxis   0.1091
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1248 b/KOI-2463.01"
{
	ParentBody     "Kepler-1248"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0204446646
		SemiMajorAxis   0.0779
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1249 b/KOI-2468.01"
{
	ParentBody     "Kepler-1249"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06662623699
		SemiMajorAxis   0.167
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-125 b/KOI-251.01"
{
	ParentBody     "Kepler-125"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0114017195
		SemiMajorAxis   0.041
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-125 c/KOI-251.02"
{
	ParentBody     "Kepler-125"
	Radius          4718.472
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01580995887
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1250 b/KOI-2472.01"
{
	ParentBody     "Kepler-1250"
	Radius          12225.132
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007139218586
		SemiMajorAxis   0.0394
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1251 b/KOI-2482.01"
{
	ParentBody     "Kepler-1251"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.123453603
		SemiMajorAxis   0.2478
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1252 b/KOI-2483.01"
{
	ParentBody     "Kepler-1252"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04121657716
		SemiMajorAxis   0.1078
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1253 b/KOI-2484.01"
{
	ParentBody     "Kepler-1253"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1886041465
		SemiMajorAxis   0.3094
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1254 b/KOI-2485.01"
{
	ParentBody     "Kepler-1254"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02735481663
		SemiMajorAxis   0.084
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1254 c/KOI-2485.02"
{
	ParentBody     "Kepler-1254"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009858780995
		SemiMajorAxis   0.0425
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1254 d/KOI-2485.03"
{
	ParentBody     "Kepler-1254"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01568047838
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1255 b/KOI-2487.01"
{
	ParentBody     "Kepler-1255"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09936402368
		SemiMajorAxis   0.2171
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1256 b/KOI-2488.01"
{
	ParentBody     "Kepler-1256"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0339850536
		SemiMajorAxis   0.1097
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1257 b/KOI-2491.01"
{
	ParentBody     "Kepler-1257"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007305601144
		SemiMajorAxis   0.0376
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1258 b/KOI-2492.01"
{
	ParentBody     "Kepler-1258"
	Radius          5504.884
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002696676883
		SemiMajorAxis   0.0194
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1259 b/KOI-2493.01"
{
	ParentBody     "Kepler-1259"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001815467321
		SemiMajorAxis   0.0142
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-126 b/KOI-260.01"
{
	ParentBody     "Kepler-126"
	Radius          9179.5728
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02873609427
		SemiMajorAxis   0.099
		Eccentricity    0.07
		Inclination     86.52
	}
}

Planet	"Kepler-126 c/KOI-260.03"
{
	ParentBody     "Kepler-126"
	Radius          9551.3312
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05987709144
		SemiMajorAxis   0.162
		Eccentricity    0.19
		Inclination     88.24
	}
}

Planet	"Kepler-126 d/KOI-260.02"
{
	ParentBody     "Kepler-126"
	Radius          16028.5064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2745632427
		SemiMajorAxis   0.448
		Eccentricity    0.02
		Inclination     89.95
	}
}

Planet	"Kepler-1260 b/KOI-2494.01"
{
	ParentBody     "Kepler-1260"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05234547331
		SemiMajorAxis   0.1305
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1261 b/KOI-2497.01"
{
	ParentBody     "Kepler-1261"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1325994106
		SemiMajorAxis   0.249
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1262 b/KOI-2506.01"
{
	ParentBody     "Kepler-1262"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02376232172
		SemiMajorAxis   0.0829
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1263 b/KOI-2509.01"
{
	ParentBody     "Kepler-1263"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01246131963
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1264 b/KOI-2517.01"
{
	ParentBody     "Kepler-1264"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002651736428
		SemiMajorAxis   0.0174
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1265 b/KOI-2520.01"
{
	ParentBody     "Kepler-1265"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01778111366
		SemiMajorAxis   0.0612
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1266 b/KOI-2521.01"
{
	ParentBody     "Kepler-1266"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07796127827
		SemiMajorAxis   0.1725
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1267 b/KOI-2523.01"
{
	ParentBody     "Kepler-1267"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03567877661
		SemiMajorAxis   0.1074
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1268 b/KOI-2524.01"
{
	ParentBody     "Kepler-1268"
	Radius          12940.052
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1122279948
		SemiMajorAxis   0.2395
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1269 b/KOI-2530.01"
{
	ParentBody     "Kepler-1269"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1022147896
		SemiMajorAxis   0.2227
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-127 b/KOI-271.03"
{
	ParentBody     "Kepler-127"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0395238294
		SemiMajorAxis   0.125
		Eccentricity    0.47
		Inclination     89.38
	}
}

Planet	"Kepler-127 c/KOI-271.02"
{
	ParentBody     "Kepler-127"
	Radius          15234.9452
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08047657367
		SemiMajorAxis   0.2
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-127 d/KOI-271.01"
{
	ParentBody     "Kepler-127"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1331444487
		SemiMajorAxis   0.28
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-1270 b/KOI-2533.01"
{
	ParentBody     "Kepler-1270"
	Radius          21161.632
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01651934559
		SemiMajorAxis   0.0712
		Eccentricity    0
		Inclination     71.62
	}
}

Planet	"Kepler-1271 b/KOI-2534.01"
{
	ParentBody     "Kepler-1271"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008283806154
		SemiMajorAxis   0.0423
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1272 b/KOI-2536.01"
{
	ParentBody     "Kepler-1272"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.139991961
		SemiMajorAxis   0.2704
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1273 b/KOI-2544.01"
{
	ParentBody     "Kepler-1273"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07837444248
		SemiMajorAxis   0.1857
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1274 b/KOI-2545.01"
{
	ParentBody     "Kepler-1274"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01911478801
		SemiMajorAxis   0.0799
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1275 b/KOI-2552.01"
{
	ParentBody     "Kepler-1275"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01001229116
		SemiMajorAxis   0.0477
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1276 b/KOI-2555.01"
{
	ParentBody     "Kepler-1276"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03442102213
		SemiMajorAxis   0.1055
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1277 b/KOI-2556.01"
{
	ParentBody     "Kepler-1277"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1118066377
		SemiMajorAxis   0.2128
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1278 b/KOI-2561.01"
{
	ParentBody     "Kepler-1278"
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008869220287
		SemiMajorAxis   0.0419
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1279 b/KOI-2563.01"
{
	ParentBody     "Kepler-1279"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0642790202
		SemiMajorAxis   0.1633
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-128 b/KOI-274.01"
{
	ParentBody     "Kepler-128"
	Mass            29.94262
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04131505182
		SemiMajorAxis   0.1263
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-128 c/KOI-274.02"
{
	ParentBody     "Kepler-128"
	Mass            33.0928
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.06243528441
		SemiMajorAxis   0.1664
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1280 b/KOI-2564.01"
{
	ParentBody     "Kepler-1280"
	Radius          11939.164
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1822295111
		SemiMajorAxis   0.3314
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1281 b/KOI-2580.01"
{
	ParentBody     "Kepler-1281"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008531401893
		SemiMajorAxis   0.0415
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1282 b/KOI-2586.01"
{
	ParentBody     "Kepler-1282"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005837076245
		SemiMajorAxis   0.0333
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1283 b/KOI-2587.01"
{
	ParentBody     "Kepler-1283"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03544524198
		SemiMajorAxis   0.1062
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1284 b/KOI-2589.01"
{
	ParentBody     "Kepler-1284"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001818173881
		SemiMajorAxis   0.0143
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1285 b/KOI-2593.01"
{
	ParentBody     "Kepler-1285"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04051214841
		SemiMajorAxis   0.1272
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1286 b/KOI-2594.01"
{
	ParentBody     "Kepler-1286"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03081251181
		SemiMajorAxis   0.0991
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1287 b/KOI-2602.01"
{
	ParentBody     "Kepler-1287"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0314225996
		SemiMajorAxis   0.1001
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1288 b/KOI-2608.01"
{
	ParentBody     "Kepler-1288"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007559981532
		SemiMajorAxis   0.0435
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-1289 b"
{
	ParentBody     "Kepler-1289"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02187643293
	}
}

Planet	"Kepler-129 b/KOI-275.01"
{
	ParentBody     "Kepler-129"
	Radius          15363.6308
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04323602103
		SemiMajorAxis   0.131
		Eccentricity    0.01
		Inclination     89.38
	}
}

Planet	"Kepler-129 c/KOI-275.02"
{
	ParentBody     "Kepler-129"
	Radius          16085.7
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2250566125
		SemiMajorAxis   0.393
		Eccentricity    0.2
		Inclination     89.95
	}
}

Planet	"Kepler-1290 b/KOI-2615.01"
{
	ParentBody     "Kepler-1290"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01285448798
		SemiMajorAxis   0.0557
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1291 b/KOI-2617.01"
{
	ParentBody     "Kepler-1291"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02362934239
		SemiMajorAxis   0.0778
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1292 b/KOI-2619.01"
{
	ParentBody     "Kepler-1292"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008970661498
		SemiMajorAxis   0.0444
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1293 b/KOI-2623.01"
{
	ParentBody     "Kepler-1293"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01526808237
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1294 b/KOI-2624.01"
{
	ParentBody     "Kepler-1294"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3167383972
		SemiMajorAxis   0.4671
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1295 b/KOI-2625.01"
{
	ParentBody     "Kepler-1295"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01044161887
		SemiMajorAxis   0.0465
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1296 b/KOI-2627.01"
{
	ParentBody     "Kepler-1296"
	Radius          5790.852
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02295459488
		SemiMajorAxis   0.0758
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1297 b/KOI-2628.01"
{
	ParentBody     "Kepler-1297"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004604862381
		SemiMajorAxis   0.0275
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1298 b/KOI-2632.01"
{
	ParentBody     "Kepler-1298"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0195161443
		SemiMajorAxis   0.0781
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1299 b/KOI-2634.01"
{
	ParentBody     "Kepler-1299"
	Radius          19016.872
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05459415137
		SemiMajorAxis   0.1351
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-13 A b/KOI-13.01/KOI-13 b"
{
	ParentBody     "Kepler-13 A"
	Msini           2068.3
	Radius          100517.752
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.00482791624
		SemiMajorAxis   0.03641
		Eccentricity    0.00064
		Inclination     81.8
		ArgOfPericen    5
	}
}

Planet	"Kepler-130 b/KOI-282.02"
{
	ParentBody     "Kepler-130"
	Radius          6224.80844
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0231550468
		SemiMajorAxis   0.079
		Eccentricity    0.15
		Inclination     89.38
	}
}

Planet	"Kepler-130 c/KOI-282.01"
{
	ParentBody     "Kepler-130"
	Radius          17930.1936
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07531628811
		SemiMajorAxis   0.178
		Eccentricity    0.08
		Inclination     89.34
		ArgOfPericen    0
	}
}

Planet	"Kepler-130 d/KOI-282.03"
{
	ParentBody     "Kepler-130"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2396248364
		SemiMajorAxis   0.377
		Eccentricity    0.8
		Inclination     89.95
	}
}

Planet	"Kepler-1300 b/KOI-2635.01"
{
	ParentBody     "Kepler-1300"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06089633076
		SemiMajorAxis   0.1577
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1301 b"
{
	ParentBody     "Kepler-1301"
	Radius          8936.5
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02486670684
	}
}

Planet	"Kepler-1302 b/KOI-2647.01"
{
	ParentBody     "Kepler-1302"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02420100097
		SemiMajorAxis   0.0795
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1303 b/KOI-2649.01"
{
	ParentBody     "Kepler-1303"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02070207783
		SemiMajorAxis   0.0751
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1304 b/KOI-2652.01"
{
	ParentBody     "Kepler-1304"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04415942558
		SemiMajorAxis   0.1138
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-1305 b/KOI-2654.01"
{
	ParentBody     "Kepler-1305"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03713453039
		SemiMajorAxis   0.1109
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1306 b/KOI-2655.01"
{
	ParentBody     "Kepler-1306"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04461684404
		SemiMajorAxis   0.1245
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1307 b/KOI-2660.01"
{
	ParentBody     "Kepler-1307"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04932675211
		SemiMajorAxis   0.1369
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1308 b/KOI-2662.01"
{
	ParentBody     "Kepler-1308"
	Radius          3288.632
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005761486976
		SemiMajorAxis   0.0227
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1309 b/KOI-2664.01"
{
	ParentBody     "Kepler-1309"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07897024359
		SemiMajorAxis   0.1679
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-131 b/KOI-283.01"
{
	ParentBody     "Kepler-131"
	Msini           16.14865
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04405843697
		SemiMajorAxis   0.1277
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-131 c/KOI-283.02"
{
	ParentBody     "Kepler-131"
	Msini           8.2732
	Radius          5361.9
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06986049451
		SemiMajorAxis   0.1736
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1310 b/KOI-2668.01"
{
	ParentBody     "Kepler-1310"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001859961113
		SemiMajorAxis   0.0144
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1311 b/KOI-2674.02"
{
	ParentBody     "Kepler-1311"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03058983795
		SemiMajorAxis   0.0979
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1311 c/KOI-2674.03"
{
	ParentBody     "Kepler-1311"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006942610439
		SemiMajorAxis   0.0364
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1312 b/KOI-2675.01"
{
	ParentBody     "Kepler-1312"
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01491702065
		SemiMajorAxis   0.0575
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1313 b/KOI-2678.01"
{
	ParentBody     "Kepler-1313"
	Radius          11224.244
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01049465611
		SemiMajorAxis   0.0454
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1314 b/KOI-2688.01"
{
	ParentBody     "Kepler-1314"
	Radius          32600.352
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01485247168
		SemiMajorAxis   0.0504
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1315 b/KOI-2694.01"
{
	ParentBody     "Kepler-1315"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002309098274
		SemiMajorAxis   0.0163
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1316 b/KOI-2698.01"
{
	ParentBody     "Kepler-1316"
	Radius          22591.472
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2408626825
		SemiMajorAxis   0.3793
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1317 b/KOI-2699.01"
{
	ParentBody     "Kepler-1317"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001557526611
		SemiMajorAxis   0.0129
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1318 b/KOI-2703.01"
{
	ParentBody     "Kepler-1318"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5838801456
		SemiMajorAxis   0.6085
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1319 b/KOI-2705.01"
{
	ParentBody     "Kepler-1319"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007903694398
		SemiMajorAxis   0.0256
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-132 A b/KOI-284.03"
{
	ParentBody     "Kepler-132 A"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01691534048
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-132 A d/KOI-284.01"
{
	ParentBody     "Kepler-132 A"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04931029191
		SemiMajorAxis   0.136
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-132 A e"
{
	ParentBody     "Kepler-132 A"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3019556351
	}
}

Planet	"Kepler-132 B c/KOI-284.02"
{
	ParentBody     "Kepler-132 B"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0175634529
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1320 b/KOI-2708.01"
{
	ParentBody     "Kepler-1320"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002377563584
		SemiMajorAxis   0.0164
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1321 b/KOI-2715.01"
{
	ParentBody     "Kepler-1321"
	Radius          31384.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03046828967
		SemiMajorAxis   0.0882
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1321 c/KOI-2715.02"
{
	ParentBody     "Kepler-1321"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006095930733
		SemiMajorAxis   0.0302
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1322 b/KOI-2716.01"
{
	ParentBody     "Kepler-1322"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002636243585
		SemiMajorAxis   0.0183
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1323 b/KOI-2717.01"
{
	ParentBody     "Kepler-1323"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002546000177
		SemiMajorAxis   0.0195
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-1324 b/KOI-2719.01"
{
	ParentBody     "Kepler-1324"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01126880956
		SemiMajorAxis   0.0466
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1325 b/KOI-2721.01"
{
	ParentBody     "Kepler-1325"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09275676453
		SemiMajorAxis   0.2039
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1326 b/KOI-2728.01"
{
	ParentBody     "Kepler-1326"
	Radius          26666.516
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1159543664
		SemiMajorAxis   0.2596
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1327 b/KOI-2729.01"
{
	ParentBody     "Kepler-1327"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0407620242
		SemiMajorAxis   0.1186
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1328 b/KOI-2730.01"
{
	ParentBody     "Kepler-1328"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01237970039
		SemiMajorAxis   0.0535
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1329 b/KOI-2736.01"
{
	ParentBody     "Kepler-1329"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02556239722
		SemiMajorAxis   0.0747
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-133 b/KOI-291.02"
{
	ParentBody     "Kepler-133"
	Radius          11224.244
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02225913716
		SemiMajorAxis   0.083
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-133 c/KOI-291.01"
{
	ParentBody     "Kepler-133"
	Radius          18087.476
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08629229283
		SemiMajorAxis   0.204
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1330 b/KOI-2739.01"
{
	ParentBody     "Kepler-1330"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02767394064
		SemiMajorAxis   0.0933
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1331 b/KOI-2742.01"
{
	ParentBody     "Kepler-1331"
	Radius          6720.248
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002160653046
		SemiMajorAxis   0.0142
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1332 b/KOI-2743.01"
{
	ParentBody     "Kepler-1332"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03251149142
		SemiMajorAxis   0.0937
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1333 b/KOI-2744.01"
{
	ParentBody     "Kepler-1333"
	Radius          17944.492
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3002040488
		SemiMajorAxis   0.4277
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1334 b/KOI-2745.01"
{
	ParentBody     "Kepler-1334"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04283710252
		SemiMajorAxis   0.1229
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1335 b/KOI-2747.01"
{
	ParentBody     "Kepler-1335"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01715045149
		SemiMajorAxis   0.0615
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1336 b/KOI-2748.01"
{
	ParentBody     "Kepler-1336"
	Radius          12654.084
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0635158852
		SemiMajorAxis   0.157
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1336 c/KOI-2748.02"
{
	ParentBody     "Kepler-1336"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01581748295
		SemiMajorAxis   0.0621
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1337 b/KOI-2751.01"
{
	ParentBody     "Kepler-1337"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06680568559
		SemiMajorAxis   0.1441
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1338 b/KOI-2753.01"
{
	ParentBody     "Kepler-1338"
	Radius          5862.344
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002560268463
		SemiMajorAxis   0.0188
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-1339 b/KOI-2754.01"
{
	ParentBody     "Kepler-1339"
	Radius          4503.996
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00367305631
		SemiMajorAxis   0.0233
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-134 b/KOI-295.01"
{
	ParentBody     "Kepler-134"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01455863848
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-134 c/KOI-295.02"
{
	ParentBody     "Kepler-134"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02766872306
		SemiMajorAxis   0.092
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1340 b/KOI-2756.01"
{
	ParentBody     "Kepler-1340"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00182078341
		SemiMajorAxis   0.0151
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1341 b/KOI-2762.01"
{
	ParentBody     "Kepler-1341"
	Radius          19088.364
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.364133268
		SemiMajorAxis   0.4516
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1342 b/KOI-2778.01"
{
	ParentBody     "Kepler-1342"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006066414071
		SemiMajorAxis   0.0313
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1343 b/KOI-2780.01"
{
	ParentBody     "Kepler-1343"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009177010962
		SemiMajorAxis   0.0449
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1344 b/KOI-2785.01"
{
	ParentBody     "Kepler-1344"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01305518648
		SemiMajorAxis   0.0568
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1345 b/KOI-2786.01"
{
	ParentBody     "Kepler-1345"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1221571794
		SemiMajorAxis   0.2638
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1346 b/KOI-2789.01"
{
	ParentBody     "Kepler-1346"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009313427568
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1347 b/KOI-2790.01"
{
	ParentBody     "Kepler-1347"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0383566731
		SemiMajorAxis   0.104
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1348 b/KOI-2791.01"
{
	ParentBody     "Kepler-1348"
	Radius          12368.116
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07549038683
		SemiMajorAxis   0.1716
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1349 b/KOI-2792.01"
{
	ParentBody     "Kepler-1349"
	Radius          4432.504
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005826926185
		SemiMajorAxis   0.0338
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-135 b/KOI-301.01"
{
	ParentBody     "Kepler-135"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0164343829
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-135 c/KOI-301.02"
{
	ParentBody     "Kepler-135"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03134552447
		SemiMajorAxis   0.103
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1350 b/KOI-2793.01"
{
	ParentBody     "Kepler-1350"
	Radius          16085.7
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01231199605
		SemiMajorAxis   0.0413
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1350 c/KOI-2793.02"
{
	ParentBody     "Kepler-1350"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004837308255
		SemiMajorAxis   0.0222
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1351 b/KOI-2798.01"
{
	ParentBody     "Kepler-1351"
	Radius          4146.536
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002508310364
		SemiMajorAxis   0.0156
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1352 b/KOI-2805.01"
{
	ParentBody     "Kepler-1352"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005141472705
		SemiMajorAxis   0.03
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1353 b/KOI-2806.01"
{
	ParentBody     "Kepler-1353"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06777529346
		SemiMajorAxis   0.153
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1354 b/KOI-2812.01"
{
	ParentBody     "Kepler-1354"
	Radius          18945.38
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2097604798
		SemiMajorAxis   0.3522
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1355 b/KOI-2816.01"
{
	ParentBody     "Kepler-1355"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003530775321
		SemiMajorAxis   0.0224
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1356 b/KOI-2817.01"
{
	ParentBody     "Kepler-1356"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001735842566
		SemiMajorAxis   0.0136
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1357 b/KOI-2820.01"
{
	ParentBody     "Kepler-1357"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008238731679
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1358 b/KOI-2827.01"
{
	ParentBody     "Kepler-1358"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01933832839
		SemiMajorAxis   0.0656
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1359 b/KOI-2828.01/KIC 6436029 b"
{
	ParentBody     "Kepler-1359"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2455291.092
		Period          0.1628976522
		SemiMajorAxis   0.2769
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-136 b/KOI-312.01"
{
	ParentBody     "Kepler-136"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03170197836
		SemiMajorAxis   0.106
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-136 c/KOI-312.02"
{
	ParentBody     "Kepler-136"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04489961854
		SemiMajorAxis   0.133
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1360 b/KOI-2830.01"
{
	ParentBody     "Kepler-1360"
	Radius          21662.076
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1109637452
		SemiMajorAxis   0.248
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1361 b/KOI-2832.01"
{
	ParentBody     "Kepler-1361"
	Radius          5504.884
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009789530507
		SemiMajorAxis   0.0431
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-1362 b/KOI-2834.01"
{
	ParentBody     "Kepler-1362"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3729186545
		SemiMajorAxis   0.46
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1363 b/KOI-2836.01"
{
	ParentBody     "Kepler-1363"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008054767554
		SemiMajorAxis   0.0363
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1364 b/KOI-2837.01"
{
	ParentBody     "Kepler-1364"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03647432509
		SemiMajorAxis   0.1231
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1365 b"
{
	ParentBody     "Kepler-1365"
	Radius          5862.344
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02108172348
	}
}

Planet	"Kepler-1365 c/KOI-2838.02"
{
	ParentBody     "Kepler-1365"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01307264107
		SemiMajorAxis   0.0558
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1366 b/KOI-2839.01"
{
	ParentBody     "Kepler-1366"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005926399058
		SemiMajorAxis   0.0269
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1367 b/KOI-2845.01"
{
	ParentBody     "Kepler-1367"
	Radius          5862.344
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00430971644
		SemiMajorAxis   0.022
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1368 b/KOI-2852.01"
{
	ParentBody     "Kepler-1368"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001849867044
		SemiMajorAxis   0.0153
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-1369 b/KOI-2856.01"
{
	ParentBody     "Kepler-1369"
	Radius          17158.08
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07083833336
		SemiMajorAxis   0.1741
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-137 b/KOI-313.02"
{
	ParentBody     "Kepler-137"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02309806269
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-137 c/KOI-313.01"
{
	ParentBody     "Kepler-137"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05129679298
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1370 b/KOI-2857.01"
{
	ParentBody     "Kepler-1370"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05548145577
		SemiMajorAxis   0.1563
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1370 c/KOI-2857.02"
{
	ParentBody     "Kepler-1370"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02037393635
		SemiMajorAxis   0.0801
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1371 b/KOI-2859.01"
{
	ParentBody     "Kepler-1371"
	Radius          4646.98
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009435393817
		SemiMajorAxis   0.0393
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1371 c/KOI-2859.02"
{
	ParentBody     "Kepler-1371"
	Radius          4075.044
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005490638118
		SemiMajorAxis   0.0274
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1372 b/KOI-2865.01"
{
	ParentBody     "Kepler-1372"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003590920234
		SemiMajorAxis   0.024
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1373 b/KOI-2866.01"
{
	ParentBody     "Kepler-1373"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003535278196
		SemiMajorAxis   0.0239
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1374 b/KOI-2868.01"
{
	ParentBody     "Kepler-1374"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02916631037
		SemiMajorAxis   0.0918
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1375 b/KOI-2869.01"
{
	ParentBody     "Kepler-1375"
	Radius          11081.26
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009036248527
		SemiMajorAxis   0.0445
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1376 b/KOI-2877.01"
{
	ParentBody     "Kepler-1376"
	Radius          6720.248
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01453503102
		SemiMajorAxis   0.0598
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1377 b"
{
	ParentBody     "Kepler-1377"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002028594835
	}
}

Planet	"Kepler-1378 b/KOI-2883.01"
{
	ParentBody     "Kepler-1378"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03272893902
		SemiMajorAxis   0.0885
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1379 b/KOI-2886.01"
{
	ParentBody     "Kepler-1379"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002414401114
		SemiMajorAxis   0.0171
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-138 b/KOI-314.03"
{
	ParentBody     "Kepler-138"
	Mass            0.066822
	Radius          3717.584
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02823662413
		SemiMajorAxis   0.0746
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-138 c/KOI-314.01"
{
	ParentBody     "Kepler-138"
	Mass            1.011876
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03773288077
		SemiMajorAxis   0.0905
		Eccentricity    0.05
		Inclination     89.95
		ArgOfPericen    72
	}
}

Planet	"Kepler-138 d/KOI-314.02"
{
	ParentBody     "Kepler-138"
	Mass            1.011175786
	Radius          10268.74167
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06321649207
		SemiMajorAxis   0.1277
		Eccentricity    0.024
		Inclination     88.81
		ArgOfPericen    170
	}
}

Planet	"Kepler-1380 b/KOI-2894.01"
{
	ParentBody     "Kepler-1380"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02823010262
		SemiMajorAxis   0.0917
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1381 b/KOI-2898.01"
{
	ParentBody     "Kepler-1381"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06949982588
		SemiMajorAxis   0.1728
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1382 b/KOI-2904.01"
{
	ParentBody     "Kepler-1382"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04478755728
		SemiMajorAxis   0.1307
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1383 b/KOI-2906.01"
{
	ParentBody     "Kepler-1383"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03808256189
		SemiMajorAxis   0.1107
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1384 b/KOI-2910.01"
{
	ParentBody     "Kepler-1384"
	Radius          12368.116
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04206148128
		SemiMajorAxis   0.1126
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1385 b/KOI-2913.01"
{
	ParentBody     "Kepler-1385"
	Radius          5433.392
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0079092687
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1386 b/KOI-2920.01"
{
	ParentBody     "Kepler-1386"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01845275271
		SemiMajorAxis   0.0699
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1387 b/KOI-2924.01"
{
	ParentBody     "Kepler-1387"
	Radius          5933.836
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006241137315
		SemiMajorAxis   0.031
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1388 b/KOI-2926.01"
{
	ParentBody     "Kepler-1388"
	Radius          16514.652
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0336364764
		SemiMajorAxis   0.085
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1388 c/KOI-2926.02"
{
	ParentBody     "Kepler-1388"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01515728923
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1388 d/KOI-2926.03"
{
	ParentBody     "Kepler-1388"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05737786155
		SemiMajorAxis   0.1214
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1388 e/KOI-2926.04"
{
	ParentBody     "Kepler-1388"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1030349435
		SemiMajorAxis   0.1793
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1389 b/KOI-2931.01"
{
	ParentBody     "Kepler-1389"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2717459753
		SemiMajorAxis   0.3825
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-139 b/KOI-316.01"
{
	ParentBody     "Kepler-139"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04317968854
		SemiMajorAxis   0.127
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-139 c/KOI-316.02"
{
	ParentBody     "Kepler-139"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.4300512985
		SemiMajorAxis   0.586
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1390 b/KOI-2936.01"
{
	ParentBody     "Kepler-1390"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01774224586
		SemiMajorAxis   0.0647
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1391 b/KOI-2943.01"
{
	ParentBody     "Kepler-1391"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1489675476
		SemiMajorAxis   0.2796
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1392 b/KOI-2946.01"
{
	ParentBody     "Kepler-1392"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04145479389
		SemiMajorAxis   0.1189
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1393 b/KOI-2951.01"
{
	ParentBody     "Kepler-1393"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006690295338
		SemiMajorAxis   0.0344
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1394 b/KOI-2956.01"
{
	ParentBody     "Kepler-1394"
	Radius          8865.008
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01078096627
		SemiMajorAxis   0.0536
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1395 b/KOI-2961.01"
{
	ParentBody     "Kepler-1395"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01036218322
		SemiMajorAxis   0.0519
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1396 b/KOI-2963.01"
{
	ParentBody     "Kepler-1396"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04988646604
		SemiMajorAxis   0.1397
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1397 b/KOI-2964.01"
{
	ParentBody     "Kepler-1397"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1299136746
		SemiMajorAxis   0.2451
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1398 b/KOI-2977.01"
{
	ParentBody     "Kepler-1398"
	Radius          5719.36
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007633720494
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-1398 c/KOI-2977.02"
{
	ParentBody     "Kepler-1398"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01133022434
		SemiMajorAxis   0.0508
		Eccentricity    0
		Inclination     82.51
	}
}

Planet	"Kepler-1399 b/KOI-2980.01"
{
	ParentBody     "Kepler-1399"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004486483505
		SemiMajorAxis   0.0276
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-14 A b/KOI-98.01"
{
	ParentBody     "Kepler-14 A"
	Mass            2672.88
	Radius          81214.912
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01859074113
		SemiMajorAxis   0.0787
		Eccentricity    0.035
		Inclination     90
	}
}

Planet	"Kepler-140 b/KOI-327.01"
{
	ParentBody     "Kepler-140"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008909896202
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-140 c/KOI-327.02"
{
	ParentBody     "Kepler-140"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2501170033
		SemiMajorAxis   0.414
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1400 b/KOI-2981.01"
{
	ParentBody     "Kepler-1400"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02482433427
		SemiMajorAxis   0.0771
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1401 b/KOI-2990.01"
{
	ParentBody     "Kepler-1401"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03066640372
		SemiMajorAxis   0.0975
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1402 b/KOI-2994.01"
{
	ParentBody     "Kepler-1402"
	Radius          4861.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005568576677
		SemiMajorAxis   0.0301
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-1403 b/KOI-2995.01"
{
	ParentBody     "Kepler-1403"
	Radius          13654.972
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01422322548
		SemiMajorAxis   0.0642
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1404 b/KOI-2996.01"
{
	ParentBody     "Kepler-1404"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04361893106
		SemiMajorAxis   0.114
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1405 b/KOI-2998.01"
{
	ParentBody     "Kepler-1405"
	Radius          25236.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07728411225
		SemiMajorAxis   0.1772
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1406 b"
{
	ParentBody     "Kepler-1406"
	Radius          7006.216
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03183930719
	}
}

Planet	"Kepler-1407 b/KOI-3004.01"
{
	ParentBody     "Kepler-1407"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05495298998
		SemiMajorAxis   0.1494
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1408 b/KOI-3008.01"
{
	ParentBody     "Kepler-1408"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008208065753
		SemiMajorAxis   0.0417
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1409 b/KOI-3009.01"
{
	ParentBody     "Kepler-1409"
	Radius          6648.756
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00209413083
		SemiMajorAxis   0.0152
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-141 b/KOI-338.02"
{
	ParentBody     "Kepler-141"
	Radius          4432.504
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008508532383
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-141 c/KOI-338.01"
{
	ParentBody     "Kepler-141"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01919440359
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1410 b/KOI-3010.01"
{
	ParentBody     "Kepler-1410"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1666460494
		SemiMajorAxis   0.247
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1411 b/KOI-3014.01"
{
	ParentBody     "Kepler-1411"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2357753052
		SemiMajorAxis   0.3998
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1412 b/KOI-3015.01"
{
	ParentBody     "Kepler-1412"
	Radius          5290.408
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009896461034
		SemiMajorAxis   0.0439
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1413 b"
{
	ParentBody     "Kepler-1413"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03609376071
	}
}

Planet	"Kepler-1414 b/KOI-3026.01"
{
	ParentBody     "Kepler-1414"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009625840737
		SemiMajorAxis   0.0426
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1415 b"
{
	ParentBody     "Kepler-1415"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001742471428
	}
}

Planet	"Kepler-1416 b/KOI-3038.01"
{
	ParentBody     "Kepler-1416"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004093583823
		SemiMajorAxis   0.0248
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1417 b/KOI-3039.01"
{
	ParentBody     "Kepler-1417"
	Radius          6362.788
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05571788218
		SemiMajorAxis   0.1431
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1418 b/KOI-3049.01"
{
	ParentBody     "Kepler-1418"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06153846167
		SemiMajorAxis   0.1309
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1419 b/KOI-3053.01"
{
	ParentBody     "Kepler-1419"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1164202567
		SemiMajorAxis   0.2391
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-142 b/KOI-343.02"
{
	ParentBody     "Kepler-142"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00554194465
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-142 c/KOI-343.01"
{
	ParentBody     "Kepler-142"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01303710834
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-142 d/KOI-343.03"
{
	ParentBody     "Kepler-142"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1144695743
		SemiMajorAxis   0.242
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1420 b/KOI-3056.01"
{
	ParentBody     "Kepler-1420"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01834289752
		SemiMajorAxis   0.0669
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1421 b/KOI-3060.01"
{
	ParentBody     "Kepler-1421"
	Radius          5933.836
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01892747167
		SemiMajorAxis   0.0749
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1422 b/KOI-3063.01"
{
	ParentBody     "Kepler-1422"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05093933482
		SemiMajorAxis   0.1505
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1423 b/KOI-3071.01"
{
	ParentBody     "Kepler-1423"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06558765298
		SemiMajorAxis   0.1586
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1424 b/KOI-3093.01"
{
	ParentBody     "Kepler-1424"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0810672349
		SemiMajorAxis   0.1781
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1425 b/KOI-3096.01"
{
	ParentBody     "Kepler-1425"
	Radius          6005.328
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03957409796
		SemiMajorAxis   0.1038
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1426 b/KOI-3101.01"
{
	ParentBody     "Kepler-1426"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03903251896
		SemiMajorAxis   0.1187
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1427 b/KOI-3106.01"
{
	ParentBody     "Kepler-1427"
	Radius          7006.216
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002652958522
		SemiMajorAxis   0.0196
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1428 b/KOI-3109.01"
{
	ParentBody     "Kepler-1428"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02923011631
		SemiMajorAxis   0.0995
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1429 b/KOI-3110.01"
{
	ParentBody     "Kepler-1429"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01227918092
		SemiMajorAxis   0.0549
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-143 b/KOI-352.02"
{
	ParentBody     "Kepler-143"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04382731088
		SemiMajorAxis   0.127
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-143 c/KOI-352.01"
{
	ParentBody     "Kepler-143"
	Radius          21519.092
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0741494596
		SemiMajorAxis   0.181
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1430 b/KOI-3113.01"
{
	ParentBody     "Kepler-1430"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006736653099
		SemiMajorAxis   0.0304
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1431 b/KOI-3115.01"
{
	ParentBody     "Kepler-1431"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01606061792
		SemiMajorAxis   0.0648
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1432 b/KOI-3116.01"
{
	ParentBody     "Kepler-1432"
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06546587926
		SemiMajorAxis   0.167
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1433 b/KOI-3120.01"
{
	ParentBody     "Kepler-1433"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01132378138
		SemiMajorAxis   0.0523
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1434 b/KOI-3122.01"
{
	ParentBody     "Kepler-1434"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02204930428
		SemiMajorAxis   0.0803
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1435 b/KOI-3125.01"
{
	ParentBody     "Kepler-1435"
	Radius          5504.884
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01219309525
		SemiMajorAxis   0.0568
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1436 b/KOI-3127.01"
{
	ParentBody     "Kepler-1436"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02657337041
		SemiMajorAxis   0.0881
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1437 b/KOI-3131.01"
{
	ParentBody     "Kepler-1437"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02992410626
		SemiMajorAxis   0.0954
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1438 b/KOI-3141.01"
{
	ParentBody     "Kepler-1438"
	Radius          6005.328
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006350361909
		SemiMajorAxis   0.033
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1439 b/KOI-3144.01"
{
	ParentBody     "Kepler-1439"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02210568416
		SemiMajorAxis   0.0579
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-144 b/KOI-369.01"
{
	ParentBody     "Kepler-144"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01611334387
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-144 c/KOI-369.02"
{
	ParentBody     "Kepler-144"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0276656566
		SemiMajorAxis   0.094
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1440 b/KOI-3146.01"
{
	ParentBody     "Kepler-1440"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1091316532
		SemiMajorAxis   0.2245
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1441 b/KOI-3147.01"
{
	ParentBody     "Kepler-1441"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1079885758
		SemiMajorAxis   0.2201
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1442 b"
{
	ParentBody     "Kepler-1442"
	Radius          25093.692
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2229104314
	}
}

Planet	"Kepler-1443 b/KOI-3234.01"
{
	ParentBody     "Kepler-1443"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006620574723
		SemiMajorAxis   0.0356
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-1444 b/KOI-3237.01"
{
	ParentBody     "Kepler-1444"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09150188907
		SemiMajorAxis   0.2026
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1445 b/KOI-3245.01"
{
	ParentBody     "Kepler-1445"
	Radius          6148.312
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0290232695
		SemiMajorAxis   0.0949
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1446 b/KOI-3246.01"
{
	ParentBody     "Kepler-1446"
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00188906936
		SemiMajorAxis   0.0151
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1447 b/KOI-3260.01"
{
	ParentBody     "Kepler-1447"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.155170268
		SemiMajorAxis   0.2919
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1448 b/KOI-3261.01"
{
	ParentBody     "Kepler-1448"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03359595083
		SemiMajorAxis   0.1058
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1449 b/KOI-3262.01"
{
	ParentBody     "Kepler-1449"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03621556646
		SemiMajorAxis   0.1176
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-145 b/KOI-370.02"
{
	ParentBody     "Kepler-145"
	Mass            34.3656
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.06283781184
		SemiMajorAxis   0.1732
		Eccentricity    0.43
		Inclination     89.38
	}
}

Planet	"Kepler-145 c/KOI-370.01"
{
	ParentBody     "Kepler-145"
	Mass            74.4588
	Radius          25022.2
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1174085064
		SemiMajorAxis   0.2627
		Eccentricity    0.11
		Inclination     88.24
	}
}

Planet	"Kepler-1450 b/KOI-3266.01"
{
	ParentBody     "Kepler-1450"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1492418404
		SemiMajorAxis   0.2392
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1451 b/KOI-3274.01"
{
	ParentBody     "Kepler-1451"
	Radius          21376.108
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09753044415
		SemiMajorAxis   0.2097
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1452 b/KOI-3277.01"
{
	ParentBody     "Kepler-1452"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1174939593
		SemiMajorAxis   0.2457
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1453 b/KOI-3280.01"
{
	ParentBody     "Kepler-1453"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1291230064
		SemiMajorAxis   0.262
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1454 b/KOI-3281.01"
{
	ParentBody     "Kepler-1454"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1287692091
		SemiMajorAxis   0.2393
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1455 b/KOI-3282.01"
{
	ParentBody     "Kepler-1455"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.134915312
		SemiMajorAxis   0.2153
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1456 b/KOI-3286.01"
{
	ParentBody     "Kepler-1456"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0496585099
		SemiMajorAxis   0.1132
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1457 b/KOI-3287.01"
{
	ParentBody     "Kepler-1457"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1399373504
		SemiMajorAxis   0.2668
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1458 b/KOI-3288.01"
{
	ParentBody     "Kepler-1458"
	Radius          17587.032
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1313848119
		SemiMajorAxis   0.2495
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1459 b/KOI-3296.01"
{
	ParentBody     "Kepler-1459"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1721300629
		SemiMajorAxis   0.2901
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-146 b/KOI-386.01"
{
	ParentBody     "Kepler-146"
	Radius          23663.852
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08530996655
		SemiMajorAxis   0.2
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-146 c/KOI-386.02"
{
	ParentBody     "Kepler-146"
	Radius          19946.268
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.210085727
		SemiMajorAxis   0.364
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1460 b/KOI-3298.01"
{
	ParentBody     "Kepler-1460"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08203686631
		SemiMajorAxis   0.1614
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1461 b/KOI-3303.01"
{
	ParentBody     "Kepler-1461"
	Radius          12940.052
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08035620833
		SemiMajorAxis   0.1709
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1462 b/KOI-3305.01"
{
	ParentBody     "Kepler-1462"
	Radius          24378.772
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1797405555
		SemiMajorAxis   0.3094
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1463 b/KOI-3306.01"
{
	ParentBody     "Kepler-1463"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06888207523
		SemiMajorAxis   0.1694
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1464 b/KOI-3308.01"
{
	ParentBody     "Kepler-1464"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08700689839
		SemiMajorAxis   0.1803
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1464 c/KOI-3308.02"
{
	ParentBody     "Kepler-1464"
	Radius          6362.788
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01458720561
		SemiMajorAxis   0.0548
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1465 b/KOI-3311.01"
{
	ParentBody     "Kepler-1465"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08714138723
		SemiMajorAxis   0.1722
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1466 b/KOI-3315.01"
{
	ParentBody     "Kepler-1466"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08535444608
		SemiMajorAxis   0.1942
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1467 b/KOI-3316.01"
{
	ParentBody     "Kepler-1467"
	Radius          21018.648
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1288375374
		SemiMajorAxis   0.2385
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1468 b/KOI-3319.02"
{
	ParentBody     "Kepler-1468"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02255995862
		SemiMajorAxis   0.0805
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1468 c/KOI-3319.03"
{
	ParentBody     "Kepler-1468"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009707340249
		SemiMajorAxis   0.0459
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1469 b/KOI-3324.01"
{
	ParentBody     "Kepler-1469"
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05986036309
		SemiMajorAxis   0.1464
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-147 b/KOI-392.02"
{
	ParentBody     "Kepler-147"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03452663561
		SemiMajorAxis   0.113
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-147 c/KOI-392.01"
{
	ParentBody     "Kepler-147"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09149113637
		SemiMajorAxis   0.216
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1470 b/KOI-3330.01"
{
	ParentBody     "Kepler-1470"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0446144798
		SemiMajorAxis   0.1158
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1471 b/KOI-3344.02"
{
	ParentBody     "Kepler-1471"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009963235577
		SemiMajorAxis   0.0429
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1472 b/KOI-3345.01"
{
	ParentBody     "Kepler-1472"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1043999958
		SemiMajorAxis   0.2335
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1473 b/KOI-3346.01"
{
	ParentBody     "Kepler-1473"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03950079016
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1474 b/KOI-3348.01"
{
	ParentBody     "Kepler-1474"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09975119582
		SemiMajorAxis   0.2233
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1475 b/KOI-3349.01"
{
	ParentBody     "Kepler-1475"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2249941991
		SemiMajorAxis   0.373
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1476 b/KOI-3352.01"
{
	ParentBody     "Kepler-1476"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02836099588
		SemiMajorAxis   0.0932
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1477 b/KOI-3353.01"
{
	ParentBody     "Kepler-1477"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03163736428
		SemiMajorAxis   0.0911
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1478 b/KOI-3356.01"
{
	ParentBody     "Kepler-1478"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07141578965
		SemiMajorAxis   0.1681
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1479 b/KOI-3363.01"
{
	ParentBody     "Kepler-1479"
	Radius          11653.196
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03978897845
		SemiMajorAxis   0.1173
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-148 b/KOI-398.03"
{
	ParentBody     "Kepler-148"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00473484731
		SemiMajorAxis   0.028
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-148 c/KOI-398.02"
{
	ParentBody     "Kepler-148"
	Radius          22948.932
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01144457874
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-148 d/KOI-398.01"
{
	ParentBody     "Kepler-148"
	Radius          55334.808
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1419520723
		SemiMajorAxis   0.2623
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1480 b/KOI-3365.01"
{
	ParentBody     "Kepler-1480"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06058117078
		SemiMajorAxis   0.1525
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1481 b/KOI-3370.02"
{
	ParentBody     "Kepler-1481"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01626923216
		SemiMajorAxis   0.0588
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1482 b/KOI-3371.02"
{
	ParentBody     "Kepler-1482"
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03354988145
		SemiMajorAxis   0.0928
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1483 b/KOI-3374.01"
{
	ParentBody     "Kepler-1483"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02603345359
		SemiMajorAxis   0.0899
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1484 b/KOI-3379.01"
{
	ParentBody     "Kepler-1484"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08338279215
		SemiMajorAxis   0.1939
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1485 b/KOI-3384.02"
{
	ParentBody     "Kepler-1485"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05452757938
		SemiMajorAxis   0.1476
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1486 b/KOI-3393.01"
{
	ParentBody     "Kepler-1486"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1496255838
		SemiMajorAxis   0.2898
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1487 b/KOI-3398.01"
{
	ParentBody     "Kepler-1487"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02004002778
		SemiMajorAxis   0.0747
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1488 b/KOI-3403.01"
{
	ParentBody     "Kepler-1488"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1090207931
		SemiMajorAxis   0.2278
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1489 b/KOI-3404.01"
{
	ParentBody     "Kepler-1489"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2253155667
		SemiMajorAxis   0.3579
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-149 b/KOI-401.01"
{
	ParentBody     "Kepler-149"
	Radius          26880.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07994405852
		SemiMajorAxis   0.184
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-149 c/KOI-401.03"
{
	ParentBody     "Kepler-149"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1514839456
		SemiMajorAxis   0.281
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-149 d/KOI-401.02"
{
	ParentBody     "Kepler-149"
	Radius          25236.676
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.4381148631
		SemiMajorAxis   0.571
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1490 b/KOI-3407.01"
{
	ParentBody     "Kepler-1490"
	Radius          19374.332
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.253082201
		SemiMajorAxis   0.3726
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1491 b/KOI-3410.01"
{
	ParentBody     "Kepler-1491"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0454114466
		SemiMajorAxis   0.1278
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1492 b/KOI-3412.01"
{
	ParentBody     "Kepler-1492"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04586696317
		SemiMajorAxis   0.1262
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1493 b/KOI-3415.01"
{
	ParentBody     "Kepler-1493"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04112832175
		SemiMajorAxis   0.1066
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1494 b/KOI-3417.01"
{
	ParentBody     "Kepler-1494"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2493701016
		SemiMajorAxis   0.3982
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1495 b/KOI-3418.01"
{
	ParentBody     "Kepler-1495"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2334704434
		SemiMajorAxis   0.3677
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1496 b/KOI-3428.01"
{
	ParentBody     "Kepler-1496"
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1770299366
		SemiMajorAxis   0.3255
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1497 b/KOI-3429.02"
{
	ParentBody     "Kepler-1497"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02393479714
		SemiMajorAxis   0.0832
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1498 b/KOI-3432.01"
{
	ParentBody     "Kepler-1498"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1315603902
		SemiMajorAxis   0.2432
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1499 b/KOI-3436.01"
{
	ParentBody     "Kepler-1499"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1210177828
		SemiMajorAxis   0.2196
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-15 b/KOI-128.01"
{
	ParentBody     "Kepler-15"
	Mass            210.012
	Radius          68632.32
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01353288896
		SemiMajorAxis   0.05714
		Eccentricity    0.06
		Inclination     87.44
	}
}

Planet	"Kepler-150 b/KOI-408.04"
{
	ParentBody     "Kepler-150"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009385701037
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-150 c/KOI-408.01"
{
	ParentBody     "Kepler-150"
	Radius          23520.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02021124121
		SemiMajorAxis   0.073
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-150 d/KOI-408.02"
{
	ParentBody     "Kepler-150"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03439068746
		SemiMajorAxis   0.104
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-150 e/KOI-408.03"
{
	ParentBody     "Kepler-150"
	Radius          19874.776
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08440031808
		SemiMajorAxis   0.189
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1500 b/KOI-3437.01"
{
	ParentBody     "Kepler-1500"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04115901973
		SemiMajorAxis   0.1124
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1501 b/KOI-3438.01"
{
	ParentBody     "Kepler-1501"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03985424933
		SemiMajorAxis   0.124
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1502 b/KOI-3439.01"
{
	ParentBody     "Kepler-1502"
	Radius          20303.728
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.114193716
		SemiMajorAxis   0.2482
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1503 b/KOI-3443.01"
{
	ParentBody     "Kepler-1503"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2633043845
		SemiMajorAxis   0.3753
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1504 b/KOI-3445.01"
{
	ParentBody     "Kepler-1504"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2253408979
		SemiMajorAxis   0.3562
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1505 b/KOI-3456.01"
{
	ParentBody     "Kepler-1505"
	Radius          5933.836
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08449444631
		SemiMajorAxis   0.1908
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1506 b/KOI-3458.01"
{
	ParentBody     "Kepler-1506"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03842085003
		SemiMajorAxis   0.1168
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1507 b/KOI-3465.01"
{
	ParentBody     "Kepler-1507"
	Radius          5361.9
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04394514584
		SemiMajorAxis   0.1155
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1508 b/KOI-3468.01"
{
	ParentBody     "Kepler-1508"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05669019345
		SemiMajorAxis   0.138
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1509 b/KOI-3470.02"
{
	ParentBody     "Kepler-1509"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0696354923
		SemiMajorAxis   0.1733
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-151 b/KOI-413.01"
{
	ParentBody     "Kepler-151"
	Radius          19517.316
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04169550622
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-151 c/KOI-413.02"
{
	ParentBody     "Kepler-151"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06755685046
		SemiMajorAxis   0.16
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1510 b/KOI-3484.01"
{
	ParentBody     "Kepler-1510"
	Radius          21447.6
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2319116558
		SemiMajorAxis   0.3888
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1511 b/KOI-3496.01"
{
	ParentBody     "Kepler-1511"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06362430148
		SemiMajorAxis   0.1753
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1512 b/KOI-3497.01"
{
	ParentBody     "Kepler-1512"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05574308378
		SemiMajorAxis   0.1294
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1513 b/KOI-3678.01"
{
	ParentBody     "Kepler-1513"
	Radius          53976.46
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.440487587
		SemiMajorAxis   0.5416
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1514 b/KOI-3681.01"
{
	ParentBody     "Kepler-1514"
	Radius          75424.06
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5964036156
		SemiMajorAxis   0.7308
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1515 b/KOI-3683.01"
{
	ParentBody     "Kepler-1515"
	Radius          60911.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5867652269
		SemiMajorAxis   0.7455
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1516 b/KOI-3685.02"
{
	ParentBody     "Kepler-1516"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0198753594
		SemiMajorAxis   0.0718
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1517 b/KOI-3728.01"
{
	ParentBody     "Kepler-1517"
	Radius          62269.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01518467424
		SemiMajorAxis   0.078
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-1518 b/KOI-3741.03"
{
	ParentBody     "Kepler-1518"
	Radius          19445.824
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01399558754
		SemiMajorAxis   0.0593
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1519 b/KOI-3762.01"
{
	ParentBody     "Kepler-1519"
	Radius          45039.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.6592856641
		SemiMajorAxis   0.7509
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-152 b/KOI-416.01"
{
	ParentBody     "Kepler-152"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04985177919
		SemiMajorAxis   0.124
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-152 c/KOI-416.02"
{
	ParentBody     "Kepler-152"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2416343387
		SemiMajorAxis   0.356
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1520 b/KOI-3794.01/KIC 12557548 b"
{
	ParentBody     "Kepler-1520"
	Mass            954.6
	Radius          36818.38
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001789370418
		SemiMajorAxis   0.013
		Eccentricity    0
		Inclination     66.46
	}
}

Planet	"Kepler-1521 b/KOI-3835.01"
{
	ParentBody     "Kepler-1521"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1290880664
		SemiMajorAxis   0.2579
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1522 b/KOI-3848.01"
{
	ParentBody     "Kepler-1522"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005059353003
		SemiMajorAxis   0.0289
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1523 b/KOI-3867.01"
{
	ParentBody     "Kepler-1523"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002570214494
		SemiMajorAxis   0.0189
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1524 b"
{
	ParentBody     "Kepler-1524"
	Radius          22591.472
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1943024718
	}
}

Planet	"Kepler-1525 b/KOI-3892.01"
{
	ParentBody     "Kepler-1525"
	Radius          5790.852
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006616434922
		SemiMajorAxis   0.0354
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1526 b/KOI-3893.01"
{
	ParentBody     "Kepler-1526"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01070148003
		SemiMajorAxis   0.0418
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1527 b/KOI-3901.01"
{
	ParentBody     "Kepler-1527"
	Radius          30455.592
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4384211968
		SemiMajorAxis   0.5756
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1528 b/KOI-3911.01"
{
	ParentBody     "Kepler-1528"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004903897358
		SemiMajorAxis   0.0296
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1529 b/KOI-3916.01"
{
	ParentBody     "Kepler-1529"
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0146178536
		SemiMajorAxis   0.0525
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-153 b/KOI-431.01"
{
	ParentBody     "Kepler-153"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0516649706
		SemiMajorAxis   0.129
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-153 c/KOI-431.02"
{
	ParentBody     "Kepler-153"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1284142996
		SemiMajorAxis   0.237
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1530 b/KOI-3925.02"
{
	ParentBody     "Kepler-1530"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007092399159
		SemiMajorAxis   0.0371
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1530 c/KOI-3925.03"
{
	ParentBody     "Kepler-1530"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01457318116
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1531 b/KOI-3928.01"
{
	ParentBody     "Kepler-1531"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003117228545
		SemiMajorAxis   0.0217
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1532 b/KOI-3935.01"
{
	ParentBody     "Kepler-1532"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002994351667
		SemiMajorAxis   0.0205
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1533 b/KOI-3946.01"
{
	ParentBody     "Kepler-1533"
	Radius          22091.028
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.8447739844
		SemiMajorAxis   0.9191
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1534 b/KOI-3954.02"
{
	ParentBody     "Kepler-1534"
	Radius          12082.148
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01565177539
		SemiMajorAxis   0.0599
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1535 b/KOI-3966.01"
{
	ParentBody     "Kepler-1535"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3804166218
		SemiMajorAxis   0.5125
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1536 b/KOI-3975.01"
{
	ParentBody     "Kepler-1536"
	Radius          20017.76
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.998674417
		SemiMajorAxis   0.8507
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1537 b/KOI-3984.01"
{
	ParentBody     "Kepler-1537"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003954783539
		SemiMajorAxis   0.0245
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1538 b/KOI-4009.01"
{
	ParentBody     "Kepler-1538"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4795142069
		SemiMajorAxis   0.6344
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1539 b/KOI-4015.01"
{
	ParentBody     "Kepler-1539"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3649733733
		SemiMajorAxis   0.4777
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-154 b/KOI-435.03"
{
	ParentBody     "Kepler-154"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09046198089
		SemiMajorAxis   0.198
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-154 c/KOI-435.05"
{
	ParentBody     "Kepler-154"
	Radius          18802.396
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1705807208
		SemiMajorAxis   0.303
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-154 d/KOI-435.01"
{
	ParentBody     "Kepler-154"
	Radius          24521.756
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05626354074
		SemiMajorAxis   0.1426
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-154 e/KOI-435.04"
{
	ParentBody     "Kepler-154"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01076755304
		SemiMajorAxis   0.0474
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-154 f/KOI-435.06"
{
	ParentBody     "Kepler-154"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02715829966
		SemiMajorAxis   0.0878
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1540 b/KOI-4016.01"
{
	ParentBody     "Kepler-1540"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3433697453
		SemiMajorAxis   0.4198
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1541 b/KOI-4024.01"
{
	ParentBody     "Kepler-1541"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02301736279
		SemiMajorAxis   0.0781
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1542 b/KOI-4032.01"
{
	ParentBody     "Kepler-1542"
	Radius          4861.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01081794198
		SemiMajorAxis   0.0466
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1542 c/KOI-4032.02"
{
	ParentBody     "Kepler-1542"
	Radius          4146.536
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007918664082
		SemiMajorAxis   0.0379
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1542 d/KOI-4032.03"
{
	ParentBody     "Kepler-1542"
	Radius          5576.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0164075716
		SemiMajorAxis   0.0616
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1542 e/KOI-4032.04"
{
	ParentBody     "Kepler-1542"
	Radius          4861.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01396650689
		SemiMajorAxis   0.0553
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1543 b"
{
	ParentBody     "Kepler-1543"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01907529547
	}
}

Planet	"Kepler-1544 b/KOI-4036.01"
{
	ParentBody     "Kepler-1544"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4621896886
		SemiMajorAxis   0.54
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1545 b/KOI-4051.01"
{
	ParentBody     "Kepler-1545"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4481748099
		SemiMajorAxis   0.5634
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1546 b/KOI-4068.01"
{
	ParentBody     "Kepler-1546"
	Radius          19946.268
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05365617019
		SemiMajorAxis   0.1366
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1547 b/KOI-4072.01"
{
	ParentBody     "Kepler-1547"
	Radius          5719.36
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001897315533
		SemiMajorAxis   0.0152
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1548 b/KOI-4076.01"
{
	ParentBody     "Kepler-1548"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3417696051
		SemiMajorAxis   0.4786
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1549 b/KOI-4084.01"
{
	ParentBody     "Kepler-1549"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5883398769
		SemiMajorAxis   0.6961
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-155 b/KOI-438.01"
{
	ParentBody     "Kepler-155"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0162390714
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-155 c/KOI-438.02"
{
	ParentBody     "Kepler-155"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1441832145
		SemiMajorAxis   0.242
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1550 b/KOI-4091.01"
{
	ParentBody     "Kepler-1550"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.6176252779
		SemiMajorAxis   0.7333
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1551 b/KOI-4092.01"
{
	ParentBody     "Kepler-1551"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06707157738
		SemiMajorAxis   0.1766
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1552 b"
{
	ParentBody     "Kepler-1552"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5058885806
	}
}

Planet	"Kepler-1553 b/KOI-4117.01"
{
	ParentBody     "Kepler-1553"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01161590563
		SemiMajorAxis   0.0489
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1554 b/KOI-4121.01"
{
	ParentBody     "Kepler-1554"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5423491029
		SemiMajorAxis   0.6259
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1555 b/KOI-4126.01"
{
	ParentBody     "Kepler-1555"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0221907999
		SemiMajorAxis   0.081
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1556 b/KOI-4127.01"
{
	ParentBody     "Kepler-1556"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02416789411
		SemiMajorAxis   0.082
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1557 b/KOI-4139.01"
{
	ParentBody     "Kepler-1557"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01024067061
		SemiMajorAxis   0.0486
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1558 b/KOI-4146.01"
{
	ParentBody     "Kepler-1558"
	Radius          4361.012
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009595560637
		SemiMajorAxis   0.0419
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1559 b/KOI-4159.01"
{
	ParentBody     "Kepler-1559"
	Radius          4575.488
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002661016326
		SemiMajorAxis   0.0187
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-156 b/KOI-440.02"
{
	ParentBody     "Kepler-156"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01361687159
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-156 c/KOI-440.01"
{
	ParentBody     "Kepler-156"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0435513789
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1560 b/KOI-4160.01"
{
	ParentBody     "Kepler-1560"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008301224569
		SemiMajorAxis   0.0397
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1561 b/KOI-4169.01"
{
	ParentBody     "Kepler-1561"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002752165653
		SemiMajorAxis   0.0194
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-1562 b/KOI-4189.01"
{
	ParentBody     "Kepler-1562"
	Radius          22662.964
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1759757689
		SemiMajorAxis   0.3337
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1563 b/KOI-4190.01"
{
	ParentBody     "Kepler-1563"
	Radius          4789.964
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009398602011
		SemiMajorAxis   0.0442
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-1564 b/KOI-4192.01"
{
	ParentBody     "Kepler-1564"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04943031939
		SemiMajorAxis   0.1326
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1565 b/KOI-4194.01"
{
	ParentBody     "Kepler-1565"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004211420484
		SemiMajorAxis   0.024
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1566 b/KOI-4199.01"
{
	ParentBody     "Kepler-1566"
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001478238974
		SemiMajorAxis   0.0118
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1567 b/KOI-4202.01"
{
	ParentBody     "Kepler-1567"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4215821235
		SemiMajorAxis   0.552
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1568 b/KOI-4204.01"
{
	ParentBody     "Kepler-1568"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05729182603
		SemiMajorAxis   0.1499
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1569 b/KOI-4212.01"
{
	ParentBody     "Kepler-1569"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01585742754
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-157 b/KOI-442.02"
{
	ParentBody     "Kepler-157"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004742995328
		SemiMajorAxis   0.028
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-157 c/KOI-442.01"
{
	ParentBody     "Kepler-157"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03707266131
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-157 d/KOI-442.03"
{
	ParentBody     "Kepler-157"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01923582471
		SemiMajorAxis   0.0724
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1570 b/KOI-4215.01"
{
	ParentBody     "Kepler-1570"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07268863165
		SemiMajorAxis   0.1784
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1571 b/KOI-4222.01"
{
	ParentBody     "Kepler-1571"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0092693423
		SemiMajorAxis   0.0432
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1572 b/KOI-4230.01"
{
	ParentBody     "Kepler-1572"
	Radius          6005.328
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01504614298
		SemiMajorAxis   0.0614
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1573 b/KOI-4232.01"
{
	ParentBody     "Kepler-1573"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00716170112
		SemiMajorAxis   0.0364
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1574 b/KOI-4234.01"
{
	ParentBody     "Kepler-1574"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01900775319
		SemiMajorAxis   0.0743
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1575 b"
{
	ParentBody     "Kepler-1575"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006990271663
	}
}

Planet	"Kepler-1576 b/KOI-4246.01"
{
	ParentBody     "Kepler-1576"
	Radius          6648.756
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01912352933
		SemiMajorAxis   0.0727
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1577 b/KOI-4255.01"
{
	ParentBody     "Kepler-1577"
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01726416785
		SemiMajorAxis   0.0657
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1578 b/KOI-4261.01"
{
	ParentBody     "Kepler-1578"
	Radius          6648.756
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00397239681
		SemiMajorAxis   0.0252
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1579 b/KOI-4268.01"
{
	ParentBody     "Kepler-1579"
	Radius          5361.9
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002326970743
		SemiMajorAxis   0.014
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-158 b/KOI-446.01"
{
	ParentBody     "Kepler-158"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0457482308
		SemiMajorAxis   0.111
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-158 c/KOI-446.02"
{
	ParentBody     "Kepler-158"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07817109795
		SemiMajorAxis   0.158
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1580 b/KOI-4276.01"
{
	ParentBody     "Kepler-1580"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1550886767
		SemiMajorAxis   0.2875
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1581 b/KOI-4288.01"
{
	ParentBody     "Kepler-1581"
	Radius          5075.932
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.017204625
		SemiMajorAxis   0.0682
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1582 b/KOI-4290.01"
{
	ParentBody     "Kepler-1582"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01324649029
		SemiMajorAxis   0.0285
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1583 b/KOI-4292.01"
{
	ParentBody     "Kepler-1583"
	Radius          3860.568
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02553941962
		SemiMajorAxis   0.0866
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1584 b/KOI-4295.01"
{
	ParentBody     "Kepler-1584"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03668719078
		SemiMajorAxis   0.1187
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1585 b/KOI-4300.01"
{
	ParentBody     "Kepler-1585"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009809234529
		SemiMajorAxis   0.0445
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1586 b/KOI-4301.01"
{
	ParentBody     "Kepler-1586"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04272485938
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1587 b/KOI-4304.01"
{
	ParentBody     "Kepler-1587"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02575290304
		SemiMajorAxis   0.0878
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-1588 b/KOI-4312.01"
{
	ParentBody     "Kepler-1588"
	Radius          4861.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02149071933
		SemiMajorAxis   0.0726
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1589 b/KOI-4327.01"
{
	ParentBody     "Kepler-1589"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002715089597
		SemiMajorAxis   0.0203
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-159 b/KOI-448.01"
{
	ParentBody     "Kepler-159"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02776136843
		SemiMajorAxis   0.082
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-159 c/KOI-448.02"
{
	ParentBody     "Kepler-159"
	Radius          21733.568
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1193613257
		SemiMajorAxis   0.218
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1590 b/KOI-4335.01"
{
	ParentBody     "Kepler-1590"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02085632014
		SemiMajorAxis   0.0772
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1591 b/KOI-4337.01"
{
	ParentBody     "Kepler-1591"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02240992338
		SemiMajorAxis   0.0794
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1592 b/KOI-4347.01"
{
	ParentBody     "Kepler-1592"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008370064508
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1593 b/KOI-4356.01"
{
	ParentBody     "Kepler-1593"
	Radius          20232.236
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4777921058
		SemiMajorAxis   0.4839
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1594 b/KOI-4360.01"
{
	ParentBody     "Kepler-1594"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007436266032
		SemiMajorAxis   0.0391
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1595 b/KOI-4364.01"
{
	ParentBody     "Kepler-1595"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01249528342
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1596 b/KOI-4371.01"
{
	ParentBody     "Kepler-1596"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1817242938
		SemiMajorAxis   0.322
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1597 b/KOI-4382.01"
{
	ParentBody     "Kepler-1597"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008067364264
		SemiMajorAxis   0.0427
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1598 b/KOI-4383.01"
{
	ParentBody     "Kepler-1598"
	Radius          6076.82
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01188786879
		SemiMajorAxis   0.0527
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1599 b/KOI-4384.01"
{
	ParentBody     "Kepler-1599"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3350203136
		SemiMajorAxis   0.4826
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-16 b"
{
	ParentBody     "Kepler-16"
	Mass            105.9606
	Radius          53904.968
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.6263679453
		SemiMajorAxis   0.7048
		Eccentricity    0.0069
		Inclination     90.032
		ArgOfPericen    318
	}
}

Planet	"Kepler-160 b/KOI-456.02"
{
	ParentBody     "Kepler-160"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0117988204
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-160 c/KOI-456.01"
{
	ParentBody     "Kepler-160"
	Radius          23020.424
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03750685814
		SemiMajorAxis   0.109
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1600 b/KOI-4385.02"
{
	ParentBody     "Kepler-1600"
	Radius          19946.268
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.057847529
		SemiMajorAxis   1.0144
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1601 b/KOI-4400.01"
{
	ParentBody     "Kepler-1601"
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006048642713
		SemiMajorAxis   0.0336
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-1602 b/KOI-4411.01"
{
	ParentBody     "Kepler-1602"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03060795374
		SemiMajorAxis   0.1008
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1603 b/KOI-4424.01"
{
	ParentBody     "Kepler-1603"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006219542329
		SemiMajorAxis   0.0347
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-1604 b"
{
	ParentBody     "Kepler-1604"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001871865516
	}
}

Planet	"Kepler-1605 b/KOI-4446.01"
{
	ParentBody     "Kepler-1605"
	Radius          6863.232
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2347936571
		SemiMajorAxis   0.4506
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1606 b/KOI-4450.01"
{
	ParentBody     "Kepler-1606"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5378218329
		SemiMajorAxis   0.6375
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1607 b/KOI-4473.01"
{
	ParentBody     "Kepler-1607"
	Radius          5862.344
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03736525511
		SemiMajorAxis   0.1075
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1608 b/KOI-4474.01"
{
	ParentBody     "Kepler-1608"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0451031372
		SemiMajorAxis   0.1126
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1609 b/KOI-4491.01"
{
	ParentBody     "Kepler-1609"
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.313058549
		SemiMajorAxis   0.4932
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-161 b/KOI-457.01"
{
	ParentBody     "Kepler-161"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01347422378
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-161 c/KOI-457.02"
{
	ParentBody     "Kepler-161"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01934124862
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1610 b/KOI-4500.01"
{
	ParentBody     "Kepler-1610"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02382478252
		SemiMajorAxis   0.0777
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1611 b/KOI-4510.01"
{
	ParentBody     "Kepler-1611"
	Radius          5147.424
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01417208374
		SemiMajorAxis   0.0541
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1612 b/KOI-4513.01"
{
	ParentBody     "Kepler-1612"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01072699463
		SemiMajorAxis   0.0468
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1613 b/KOI-4561.01"
{
	ParentBody     "Kepler-1613"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004157323393
		SemiMajorAxis   0.0264
		Eccentricity    0
		Inclination     52.14
	}
}

Planet	"Kepler-1614 b/KOI-4566.01"
{
	ParentBody     "Kepler-1614"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01080547157
		SemiMajorAxis   0.0471
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1615 b/KOI-4571.01"
{
	ParentBody     "Kepler-1615"
	Radius          13154.528
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1295376616
		SemiMajorAxis   0.2595
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-1616 b/KOI-4585.01"
{
	ParentBody     "Kepler-1616"
	Radius          6505.772
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01851605307
		SemiMajorAxis   0.074
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1617 b/KOI-4617.01"
{
	ParentBody     "Kepler-1617"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07523379819
		SemiMajorAxis   0.1833
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1618 b/KOI-4640.01"
{
	ParentBody     "Kepler-1618"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01672386258
		SemiMajorAxis   0.0709
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1619 b/KOI-4693.01"
{
	ParentBody     "Kepler-1619"
	Radius          4861.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06467651316
		SemiMajorAxis   0.1597
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-162 b/KOI-459.02"
{
	ParentBody     "Kepler-162"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01894577952
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-162 c/KOI-459.01"
{
	ParentBody     "Kepler-162"
	Radius          19302.84
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05324235683
		SemiMajorAxis   0.137
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1620 b/KOI-4706.01"
{
	ParentBody     "Kepler-1620"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.279134864
		SemiMajorAxis   0.4322
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1621 b/KOI-4747.01"
{
	ParentBody     "Kepler-1621"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2526096836
		SemiMajorAxis   0.4266
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1622 b/KOI-4765.01"
{
	ParentBody     "Kepler-1622"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0296019299
		SemiMajorAxis   0.1006
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1623 b/KOI-4803.01"
{
	ParentBody     "Kepler-1623"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01194079874
		SemiMajorAxis   0.0533
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-1624 b/KOI-4928.01"
{
	ParentBody     "Kepler-1624"
	Radius          36389.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00900855545
		SemiMajorAxis   0.0238
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1625 b/KOI-5084.01"
{
	ParentBody     "Kepler-1625"
	Radius          38677.172
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.7868175063
		SemiMajorAxis   0.811
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1626 b/KOI-5178.01"
{
	ParentBody     "Kepler-1626"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01133393068
		SemiMajorAxis   0.0534
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1627 b/KOI-5245.01"
{
	ParentBody     "Kepler-1627"
	Radius          23520.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01972071335
		SemiMajorAxis   0.0643
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1628 b/KOI-5416.01"
{
	ParentBody     "Kepler-1628"
	Radius          41036.408
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2091161293
		SemiMajorAxis   0.2956
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1629 b"
{
	ParentBody     "Kepler-1629"
	Radius          4932.948
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01061202177
	}
}

Planet	"Kepler-163 b/KOI-471.02"
{
	ParentBody     "Kepler-163"
	Radius          6720.248
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0213856373
		SemiMajorAxis   0.078
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-163 c/KOI-471.01"
{
	ParentBody     "Kepler-163"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05844686784
		SemiMajorAxis   0.152
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1630 b/KOI-5454.01"
{
	ParentBody     "Kepler-1630"
	Radius          13940.94
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.396326646
		SemiMajorAxis   1.1218
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1631 b/KOI-5466.01"
{
	ParentBody     "Kepler-1631"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01121212016
		SemiMajorAxis   0.0511
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1632 b"
{
	ParentBody     "Kepler-1632"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.227414495
	}
}

Planet	"Kepler-1633 b/KOI-5568.01"
{
	ParentBody     "Kepler-1633"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5103579931
		SemiMajorAxis   0.6407
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1634 b/KOI-5581.01"
{
	ParentBody     "Kepler-1634"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.026377153
		SemiMajorAxis   1.0525
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1635 b/KOI-5622.01"
{
	ParentBody     "Kepler-1635"
	Radius          23234.9
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.285807399
		SemiMajorAxis   1.1123
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1636 b/KOI-5706.01"
{
	ParentBody     "Kepler-1636"
	Radius          20589.696
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.164919776
		SemiMajorAxis   1.1546
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1637 b/KOI-5827.01"
{
	ParentBody     "Kepler-1637"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01672753973
		SemiMajorAxis   0.0596
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1638 b/KOI-5856.01"
{
	ParentBody     "Kepler-1638"
	Radius          11939.164
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.710040727
		SemiMajorAxis   0.7307
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1639 b/KOI-5875.01"
{
	ParentBody     "Kepler-1639"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02704638805
		SemiMajorAxis   0.0934
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-164 b/KOI-474.04"
{
	ParentBody     "Kepler-164"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01378545562
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-164 c/KOI-474.01"
{
	ParentBody     "Kepler-164"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02996839715
		SemiMajorAxis   0.097
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-164 d/KOI-474.02"
{
	ParentBody     "Kepler-164"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07936314535
		SemiMajorAxis   0.187
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-1640 b/KOI-6132.02"
{
	ParentBody     "Kepler-1640"
	Radius          30741.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02076543403
		SemiMajorAxis   0.0834
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-1641 b/KOI-6145.01"
{
	ParentBody     "Kepler-1641"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05386088066
		SemiMajorAxis   0.1473
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-1641 c/KOI-6145.02"
{
	ParentBody     "Kepler-1641"
	Radius          18802.396
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08941248549
		SemiMajorAxis   0.2065
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1642 b/KOI-6166.01"
{
	ParentBody     "Kepler-1642"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03341824039
		SemiMajorAxis   0.1016
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1642 c/KOI-6166.02"
{
	ParentBody     "Kepler-1642"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01821087592
		SemiMajorAxis   0.0678
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1643 b/KOI-6186.01"
{
	ParentBody     "Kepler-1643"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01462767779
		SemiMajorAxis   0.0531
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-1644 b/KOI-6228.01"
{
	ParentBody     "Kepler-1644"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05774463188
		SemiMajorAxis   0.142
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-1645 b"
{
	ParentBody     "Kepler-1645"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04429377698
	}
}

Planet	"Kepler-1646 b"
{
	ParentBody     "Kepler-1646"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01228112183
	}
}

Planet	"Kepler-165 b/KOI-475.01"
{
	ParentBody     "Kepler-165"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02239842008
		SemiMajorAxis   0.072
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-165 c/KOI-475.02"
{
	ParentBody     "Kepler-165"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04192557822
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-166 b/KOI-481.01"
{
	ParentBody     "Kepler-166"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02094570182
		SemiMajorAxis   0.072
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-166 c/KOI-481.03"
{
	ParentBody     "Kepler-166"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09380154306
		SemiMajorAxis   0.195
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-166 d/KOI-481.02"
{
	ParentBody     "Kepler-166"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004254721862
		SemiMajorAxis   0.0246
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-167 b/KOI-490.01"
{
	ParentBody     "Kepler-167"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01202808252
		SemiMajorAxis   0.0483
		Eccentricity    0
		Inclination     89.33
	}
}

Planet	"Kepler-167 c/KOI-490.03"
{
	ParentBody     "Kepler-167"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02027726863
		SemiMajorAxis   0.0684
		Eccentricity    0
		Inclination     89.3
	}
}

Planet	"Kepler-167 d/KOI-490.04"
{
	ParentBody     "Kepler-167"
	Mass            1.9092
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05969697808
		SemiMajorAxis   0.1405
		Eccentricity    0.12
		Inclination     89.352
	}
}

Planet	"Kepler-167 e/KOI-490.02"
{
	ParentBody     "Kepler-167"
	Mass            1272.8
	Radius          64771.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          2.932936856
		SemiMajorAxis   1.89
		Eccentricity    0.062
		Inclination     89.976
		ArgOfPericen    201
	}
}

Planet	"Kepler-168 b/KOI-497.02"
{
	ParentBody     "Kepler-168"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01211631932
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-168 c/KOI-497.01"
{
	ParentBody     "Kepler-168"
	Radius          17158.08
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03612190039
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-169 b/KOI-505.03"
{
	ParentBody     "Kepler-169"
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008899900095
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-169 c/KOI-505.02"
{
	ParentBody     "Kepler-169"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01696263239
		SemiMajorAxis   0.062
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-169 d/KOI-505.04"
{
	ParentBody     "Kepler-169"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02285640934
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-169 e/KOI-505.01"
{
	ParentBody     "Kepler-169"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03769307704
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-169 f/KOI-505.05"
{
	ParentBody     "Kepler-169"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2384450576
		SemiMajorAxis   0.359
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-17 b/KOI-203.01"
{
	ParentBody     "Kepler-17"
	Mass            779.59
	Radius          93797.504
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.004067741464
		SemiMajorAxis   0.02591
		Eccentricity    0.011
		Inclination     87.2
	}
}

Planet	"Kepler-170 b/KOI-508.01"
{
	ParentBody     "Kepler-170"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02171324184
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-170 c/KOI-508.02"
{
	ParentBody     "Kepler-170"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04562962183
		SemiMajorAxis   0.131
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-171 b/KOI-509.01"
{
	ParentBody     "Kepler-171"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01140879152
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-171 c/KOI-509.02"
{
	ParentBody     "Kepler-171"
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03138591959
		SemiMajorAxis   0.098
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-171 d/KOI-509.03"
{
	ParentBody     "Kepler-171"
	Radius          12082.148
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.108408941
		SemiMajorAxis   0.223
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-172 b/KOI-510.01"
{
	ParentBody     "Kepler-172"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00805029945
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-172 c/KOI-510.02"
{
	ParentBody     "Kepler-172"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01749249177
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-172 d/KOI-510.03"
{
	ParentBody     "Kepler-172"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04004772561
		SemiMajorAxis   0.118
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-172 e/KOI-510.04"
{
	ParentBody     "Kepler-172"
	Radius          17587.032
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09615191502
		SemiMajorAxis   0.211
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-173 b/KOI-511.02"
{
	ParentBody     "Kepler-173"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01167373901
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-173 c/KOI-511.01"
{
	ParentBody     "Kepler-173"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02191909156
		SemiMajorAxis   0.074
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-174 b/KOI-518.01"
{
	ParentBody     "Kepler-174"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03828087332
		SemiMajorAxis   0.1
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-174 c/KOI-518.02"
{
	ParentBody     "Kepler-174"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.120469459
		SemiMajorAxis   0.214
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-174 d/KOI-518.03"
{
	ParentBody     "Kepler-174"
	Radius          13940.94
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.6772320857
		SemiMajorAxis   0.677
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-175 b/KOI-519.01"
{
	ParentBody     "Kepler-175"
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0325907448
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-175 c/KOI-519.02"
{
	ParentBody     "Kepler-175"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09318544775
		SemiMajorAxis   0.213
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-176 b/KOI-520.02"
{
	ParentBody     "Kepler-176"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01487526401
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-176 c/KOI-520.01"
{
	ParentBody     "Kepler-176"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03493493456
		SemiMajorAxis   0.102
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-176 d/KOI-520.03"
{
	ParentBody     "Kepler-176"
	Radius          16014.208
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07050656993
		SemiMajorAxis   0.163
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-176 e/KOI-520.04"
{
	ParentBody     "Kepler-176"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1400872939
		SemiMajorAxis   0.2534
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-177 b/KOI-523.02"
{
	ParentBody     "Kepler-177"
	Mass            1.70237
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.0981677391
		SemiMajorAxis   0.2222
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-177 c/KOI-523.01"
{
	ParentBody     "Kepler-177"
	Mass            6.30036
	Radius          45397.42
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1352855759
		SemiMajorAxis   0.2701
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-178 b/KOI-528.01"
{
	ParentBody     "Kepler-178"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02622011987
		SemiMajorAxis   0.085
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-178 c/KOI-528.03"
{
	ParentBody     "Kepler-178"
	Radius          18373.444
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05627170839
		SemiMajorAxis   0.142
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-178 d/KOI-528.02"
{
	ParentBody     "Kepler-178"
	Radius          25165.184
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2646983034
		SemiMajorAxis   0.397
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-179 b/KOI-534.02"
{
	ParentBody     "Kepler-179"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007490717327
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-179 c/KOI-534.01"
{
	ParentBody     "Kepler-179"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01752297565
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-18 b/KOI-137.03"
{
	ParentBody     "Kepler-18"
	Mass            6.877997672
	Radius          12756.20083
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.009595619283
		SemiMajorAxis   0.0447
		Eccentricity    0
		Inclination     84.92
	}
}

Planet	"Kepler-18 c/KOI-137.01"
{
	ParentBody     "Kepler-18"
	Mass            17.22002328
	Radius          34951.99028
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02092198057
		SemiMajorAxis   0.0752
		Eccentricity    0
		Inclination     87.68
	}
}

Planet	"Kepler-18 d/KOI-137.02"
{
	ParentBody     "Kepler-18"
	Mass            16.31897555
	Radius          44455.3599
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.04068226621
		SemiMajorAxis   0.1172
		Eccentricity    0
		Inclination     88.07
	}
}

Planet	"Kepler-180 b/KOI-542.02"
{
	ParentBody     "Kepler-180"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03783003274
		SemiMajorAxis   0.109
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-180 c/KOI-542.01"
{
	ParentBody     "Kepler-180"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1146794542
		SemiMajorAxis   0.229
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-181 b/KOI-543.02"
{
	ParentBody     "Kepler-181"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008591211769
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-181 c/KOI-543.01"
{
	ParentBody     "Kepler-181"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01177889389
		SemiMajorAxis   0.049
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-182 b/KOI-546.02"
{
	ParentBody     "Kepler-182"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02690212761
		SemiMajorAxis   0.096
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-182 c/KOI-546.01"
{
	ParentBody     "Kepler-182"
	Radius          21876.552
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05663185299
		SemiMajorAxis   0.157
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-183 b/KOI-551.02"
{
	ParentBody     "Kepler-183"
	Radius          13154.528
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01557307769
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-183 c/KOI-551.01"
{
	ParentBody     "Kepler-183"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03186124529
		SemiMajorAxis   0.103
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-184 b/KOI-567.01"
{
	ParentBody     "Kepler-184"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02926161407
		SemiMajorAxis   0.092
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-184 c/KOI-567.02"
{
	ParentBody     "Kepler-184"
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05558778686
		SemiMajorAxis   0.141
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-184 d/KOI-567.03"
{
	ParentBody     "Kepler-184"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0794605848
		SemiMajorAxis   0.179
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-185 b/KOI-569.02"
{
	ParentBody     "Kepler-185"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004470732148
		SemiMajorAxis   0.026
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-185 c/KOI-569.01"
{
	ParentBody     "Kepler-185"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05675423753
		SemiMajorAxis   0.139
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-186 b/KOI-571.03"
{
	ParentBody     "Kepler-186"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01064171421
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-186 c/KOI-571.01"
{
	ParentBody     "Kepler-186"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01989714552
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-186 d/KOI-571.02"
{
	ParentBody     "Kepler-186"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03653208301
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-186 e/KOI-571.04"
{
	ParentBody     "Kepler-186"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06135050556
		SemiMajorAxis   0.129
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-186 f/KOI-571.05"
{
	ParentBody     "Kepler-186"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.355775164
		SemiMajorAxis   0.432
		Eccentricity    0.04
		Inclination     89.96
	}
}

Planet	"Kepler-187 b/KOI-572.02"
{
	ParentBody     "Kepler-187"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01352216183
		SemiMajorAxis   0.059
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-187 c/KOI-572.01"
{
	ParentBody     "Kepler-187"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02913207536
		SemiMajorAxis   0.099
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-188 b/KOI-573.02"
{
	ParentBody     "Kepler-188"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005645287038
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-188 c/KOI-573.01"
{
	ParentBody     "Kepler-188"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01641801842
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-189 b/KOI-574.02"
{
	ParentBody     "Kepler-189"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02847406814
		SemiMajorAxis   0.088
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-189 c/KOI-574.01"
{
	ParentBody     "Kepler-189"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05512743752
		SemiMajorAxis   0.137
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-19 b/KOI-84.01"
{
	ParentBody     "Kepler-19"
	Mass            20.3648
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02542694863
		SemiMajorAxis   0.0833
		Eccentricity    0
		Inclination     89.94
	}
}

Planet	"Kepler-19 c"
{
	ParentBody     "Kepler-19"
	Mass            1909.2
	DiscMethod     "TTV"
	DiscDate       "2011"
	Orbit
	{
		Period          0.4380654931
	}
}

Planet	"Kepler-190 b/KOI-579.01"
{
	ParentBody     "Kepler-190"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005530574113
		SemiMajorAxis   0.03
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-190 c/KOI-579.02"
{
	ParentBody     "Kepler-190"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01030281853
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-191 b/KOI-582.03"
{
	ParentBody     "Kepler-191"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02721381121
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-191 c/KOI-582.02"
{
	ParentBody     "Kepler-191"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04856642111
		SemiMajorAxis   0.128
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-191 d/KOI-582.01"
{
	ParentBody     "Kepler-191"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01627698329
		SemiMajorAxis   0.0616
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-192 b/KOI-584.01"
{
	ParentBody     "Kepler-192"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02717853051
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-192 c/KOI-584.02"
{
	ParentBody     "Kepler-192"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05810774492
		SemiMajorAxis   0.15
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-192 d/KOI-584.03"
{
	ParentBody     "Kepler-192"
	Radius          6505.772
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01771502847
		SemiMajorAxis   0.0654
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-193 b/KOI-590.01"
{
	ParentBody     "Kepler-193"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03118062567
		SemiMajorAxis   0.106
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-193 c/KOI-590.02"
{
	ParentBody     "Kepler-193"
	Radius          17515.54
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1388051419
		SemiMajorAxis   0.286
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-194 b/KOI-597.02"
{
	ParentBody     "Kepler-194"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005728475675
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-194 c/KOI-597.01"
{
	ParentBody     "Kepler-194"
	Radius          16514.652
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04738782233
		SemiMajorAxis   0.131
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-194 d/KOI-597.03"
{
	ParentBody     "Kepler-194"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1446026074
		SemiMajorAxis   0.275
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-195 b/KOI-598.01"
{
	ParentBody     "Kepler-195"
	Radius          12940.052
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02274620028
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-195 c/KOI-598.02"
{
	ParentBody     "Kepler-195"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0933541194
		SemiMajorAxis   0.197
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-196 b/KOI-612.01"
{
	ParentBody     "Kepler-196"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05678392742
		SemiMajorAxis   0.138
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-196 c/KOI-612.02"
{
	ParentBody     "Kepler-196"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1298528437
		SemiMajorAxis   0.24
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-197 b/KOI-623.03"
{
	ParentBody     "Kepler-197"
	Radius          6786.02064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01533035656
		SemiMajorAxis   0.06
		Eccentricity    0.02
		Inclination     89.95
	}
}

Planet	"Kepler-197 c/KOI-623.01"
{
	ParentBody     "Kepler-197"
	Mass            5.4094
	Radius          7706.8376
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02833657033
		SemiMajorAxis   0.09
		Eccentricity    0.08
		Inclination     89.38
	}
}

Planet	"Kepler-197 d/KOI-623.02"
{
	ParentBody     "Kepler-197"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04292458658
		SemiMajorAxis   0.119
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-197 e/KOI-623.04"
{
	ParentBody     "Kepler-197"
	Radius          6269.8484
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06902187288
		SemiMajorAxis   0.164
		Eccentricity    0.38
		Inclination     88.24
	}
}

Planet	"Kepler-198 b/KOI-624.01"
{
	ParentBody     "Kepler-198"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04870750832
		SemiMajorAxis   0.131
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-198 c/KOI-624.02"
{
	ParentBody     "Kepler-198"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1357110908
		SemiMajorAxis   0.259
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-198 d/KOI-624.03"
{
	ParentBody     "Kepler-198"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003591711107
		SemiMajorAxis   0.0231
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-199 b/KOI-638.01"
{
	ParentBody     "Kepler-199"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06471761658
		SemiMajorAxis   0.158
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-199 c/KOI-638.02"
{
	ParentBody     "Kepler-199"
	Radius          20732.68
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1836956679
		SemiMajorAxis   0.316
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-2 b/KOI-2.01/HAT-P-7 b"
{
	ParentBody     "Kepler-2"
	Mass            566.7142
	Radius          101447.148
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.006036365626
		SemiMajorAxis   0.0355
		Eccentricity    0
		Inclination     83.143
	}
}

Planet	"Kepler-20 b/KOI-70.02"
{
	ParentBody     "Kepler-20"
	Mass            8.45983702
	Radius          12118.39079
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01011964664
		SemiMajorAxis   0.04537
		Eccentricity    0.32
		Inclination     86.5
	}
}

Planet	"Kepler-20 c/KOI-70.01"
{
	ParentBody     "Kepler-20"
	Mass            15.71827707
	Radius          19516.98727
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02971751978
		SemiMajorAxis   0.093
		Eccentricity    0.4
		Inclination     88.39
	}
}

Planet	"Kepler-20 d/KOI-70.03"
{
	ParentBody     "Kepler-20"
	Mass            19.092
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.2124942084
		SemiMajorAxis   0.3453
		Eccentricity    0.6
		Inclination     89.57
	}
}

Planet	"Kepler-20 e/KOI-70.04"
{
	ParentBody     "Kepler-20"
	Mass            3.08654
	Radius          5576.376
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0166971209
		SemiMajorAxis   0.0507
		Eccentricity    0.28
		Inclination     87.5
	}
}

Planet	"Kepler-20 f/KOI-70.05"
{
	ParentBody     "Kepler-20"
	Mass            14.319
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.05360021527
		SemiMajorAxis   0.11
		Eccentricity    0.32
		Inclination     88.68
	}
}

Planet	"Kepler-200 b/KOI-654.01"
{
	ParentBody     "Kepler-200"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02353179682
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-200 c/KOI-654.02"
{
	ParentBody     "Kepler-200"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02798733904
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-201 b/KOI-655.01"
{
	ParentBody     "Kepler-201"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07028783562
		SemiMajorAxis   0.175
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-201 c/KOI-655.02"
{
	ParentBody     "Kepler-201"
	Radius          18158.968
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.4158447798
		SemiMajorAxis   0.573
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-202 b/KOI-657.01"
{
	ParentBody     "Kepler-202"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01114172216
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-202 c/KOI-657.02"
{
	ParentBody     "Kepler-202"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04457998953
		SemiMajorAxis   0.113
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-203 b/KOI-658.01"
{
	ParentBody     "Kepler-203"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00865917763
		SemiMajorAxis   0.043
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-203 c/KOI-658.02"
{
	ParentBody     "Kepler-203"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01470434454
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-203 d/KOI-658.03"
{
	ParentBody     "Kepler-203"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03101974612
		SemiMajorAxis   0.1
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-204 b/KOI-661.01"
{
	ParentBody     "Kepler-204"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0394285611
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-204 c/KOI-661.02"
{
	ParentBody     "Kepler-204"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07025637704
		SemiMajorAxis   0.173
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-205 b/KOI-663.01"
{
	ParentBody     "Kepler-205"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007544692471
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-205 c/KOI-663.02"
{
	ParentBody     "Kepler-205"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05559748179
		SemiMajorAxis   0.122
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-206 b/KOI-664.02"
{
	ParentBody     "Kepler-206"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02130637483
		SemiMajorAxis   0.078
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-206 c/KOI-664.01"
{
	ParentBody     "Kepler-206"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03596920445
		SemiMajorAxis   0.111
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-206 d/KOI-664.03"
{
	ParentBody     "Kepler-206"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06418428827
		SemiMajorAxis   0.163
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-207 b/KOI-665.02"
{
	ParentBody     "Kepler-207"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004413140225
		SemiMajorAxis   0.029
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-207 c/KOI-665.03"
{
	ParentBody     "Kepler-207"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008409682905
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-207 d/KOI-665.01"
{
	ParentBody     "Kepler-207"
	Radius          21090.14
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0160662573
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-208 b/KOI-671.01"
{
	ParentBody     "Kepler-208"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01157763292
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-208 c/KOI-671.02"
{
	ParentBody     "Kepler-208"
	Radius          8865.008
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02044293679
		SemiMajorAxis   0.079
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-208 d/KOI-671.04"
{
	ParentBody     "Kepler-208"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03047782077
		SemiMajorAxis   0.103
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-208 e/KOI-671.03"
{
	ParentBody     "Kepler-208"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04451692179
		SemiMajorAxis   0.132
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-209 b/KOI-672.01"
{
	ParentBody     "Kepler-209"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04404706096
		SemiMajorAxis   0.122
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-209 c/KOI-672.02"
{
	ParentBody     "Kepler-209"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1143073915
		SemiMajorAxis   0.231
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-21 b/KOI-975.01"
{
	ParentBody     "Kepler-21"
	Mass            10.5006
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.007627144611
		SemiMajorAxis   0.042507
		Eccentricity    0
		Inclination     82.58
	}
}

Planet	"Kepler-210 b/KOI-676.02"
{
	ParentBody     "Kepler-210"
	Radius          24443.1148
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006716639173
		SemiMajorAxis   0.01421
		Eccentricity    0.44
		Inclination     77.86
	}
}

Planet	"Kepler-210 c/KOI-676.01"
{
	ParentBody     "Kepler-210"
	Radius          31170.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02182798215
		SemiMajorAxis   0.037
		Eccentricity    0.5
		Inclination     85.73
	}
}

Planet	"Kepler-211 b/KOI-678.02"
{
	ParentBody     "Kepler-211"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01133104311
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-211 c/KOI-678.01"
{
	ParentBody     "Kepler-211"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01653820442
		SemiMajorAxis   0.062
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-212 b/KOI-679.02"
{
	ParentBody     "Kepler-212"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04451178547
		SemiMajorAxis   0.133
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-212 c/KOI-679.01"
{
	ParentBody     "Kepler-212"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0870796827
		SemiMajorAxis   0.207
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-213 b/KOI-692.01"
{
	ParentBody     "Kepler-213"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006741718423
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-213 c/KOI-692.02"
{
	ParentBody     "Kepler-213"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01320483267
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-214 b/KOI-693.02"
{
	ParentBody     "Kepler-214"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04287714956
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-214 c/KOI-693.01"
{
	ParentBody     "Kepler-214"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07879648299
		SemiMajorAxis   0.194
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-215 b/KOI-700.02"
{
	ParentBody     "Kepler-215"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02562867122
		SemiMajorAxis   0.084
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-215 c/KOI-700.03"
{
	ParentBody     "Kepler-215"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04015721187
		SemiMajorAxis   0.113
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-215 d/KOI-700.01"
{
	ParentBody     "Kepler-215"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08450399176
		SemiMajorAxis   0.185
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-215 e/KOI-700.04"
{
	ParentBody     "Kepler-215"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1866186654
		SemiMajorAxis   0.314
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-216 b/KOI-708.02"
{
	ParentBody     "Kepler-216"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02106449149
		SemiMajorAxis   0.079
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-216 c/KOI-708.01"
{
	ParentBody     "Kepler-216"
	Radius          19374.332
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04765788149
		SemiMajorAxis   0.136
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-217 b/KOI-710.01"
{
	ParentBody     "Kepler-217"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0147161066
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-217 c/KOI-710.02"
{
	ParentBody     "Kepler-217"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02350770048
		SemiMajorAxis   0.089
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-217 d/KOI-710.03"
{
	ParentBody     "Kepler-217"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01064196678
		SemiMajorAxis   0.0545
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-218 b/KOI-711.02"
{
	ParentBody     "Kepler-218"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009909416548
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-218 c/KOI-711.01"
{
	ParentBody     "Kepler-218"
	Radius          20017.76
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1223833863
		SemiMajorAxis   0.248
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-218 d/KOI-711.03"
{
	ParentBody     "Kepler-218"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.340936694
		SemiMajorAxis   0.4853
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-219 b/KOI-718.01"
{
	ParentBody     "Kepler-219"
	Radius          18802.396
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0125547161
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-219 c/KOI-718.02"
{
	ParentBody     "Kepler-219"
	Radius          22805.948
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0621905509
		SemiMajorAxis   0.165
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-219 d/KOI-718.03"
{
	ParentBody     "Kepler-219"
	Radius          17944.492
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1311558367
		SemiMajorAxis   0.272
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-22 b/KOI-87.01"
{
	ParentBody     "Kepler-22"
	Mass            35.002
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.7936166961
		SemiMajorAxis   0.849
		Eccentricity    0
		Inclination     89.764
	}
}

Planet	"Kepler-220 b/KOI-719.04"
{
	ParentBody     "Kepler-220"
	Radius          5147.424
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0113891744
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-220 c/KOI-719.01"
{
	ParentBody     "Kepler-220"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02473481775
		SemiMajorAxis   0.076
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-220 d/KOI-719.02"
{
	ParentBody     "Kepler-220"
	Radius          6219.804
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07699657318
		SemiMajorAxis   0.163
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-220 e/KOI-719.03"
{
	ParentBody     "Kepler-220"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.125677521
		SemiMajorAxis   0.226
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-221 b/KOI-720.04"
{
	ParentBody     "Kepler-221"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007654937129
		SemiMajorAxis   0.037
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-221 c/KOI-720.01"
{
	ParentBody     "Kepler-221"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01558030851
		SemiMajorAxis   0.059
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-221 d/KOI-720.02"
{
	ParentBody     "Kepler-221"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02749288083
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-221 e/KOI-720.03"
{
	ParentBody     "Kepler-221"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05029516718
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-222 b/KOI-723.01"
{
	ParentBody     "Kepler-222"
	Radius          20160.744
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01077909702
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-222 c/KOI-723.03"
{
	ParentBody     "Kepler-222"
	Radius          29597.688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02762224705
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-222 d/KOI-723.02"
{
	ParentBody     "Kepler-222"
	Radius          23520.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07688572892
		SemiMajorAxis   0.18
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-223 b/KOI-730.04"
{
	ParentBody     "Kepler-223"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0202170182
		SemiMajorAxis   0.073
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-223 c/KOI-730.02"
{
	ParentBody     "Kepler-223"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02696343214
		SemiMajorAxis   0.088
		Eccentricity    0
		Inclination     74.48
	}
}

Planet	"Kepler-223 d/KOI-730.01"
{
	ParentBody     "Kepler-223"
	Radius          19016.872
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04049028127
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     81.36
	}
}

Planet	"Kepler-223 e/KOI-730.03"
{
	ParentBody     "Kepler-223"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05399631956
		SemiMajorAxis   0.14
		Eccentricity    0
		Inclination     73.34
	}
}

Planet	"Kepler-224 b/KOI-733.03"
{
	ParentBody     "Kepler-224"
	Radius          8865.008
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008577661856
		SemiMajorAxis   0.038
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-224 c/KOI-733.01"
{
	ParentBody     "Kepler-224"
	Radius          19874.776
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01622212101
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-224 d/KOI-733.02"
{
	ParentBody     "Kepler-224"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03107360901
		SemiMajorAxis   0.089
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-224 e/KOI-733.04"
{
	ParentBody     "Kepler-224"
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05104442345
		SemiMajorAxis   0.124
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-225 b/KOI-736.02"
{
	ParentBody     "Kepler-225"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01845070254
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-225 c/KOI-736.01"
{
	ParentBody     "Kepler-225"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05145690865
		SemiMajorAxis   0.111
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-226 b/KOI-749.02"
{
	ParentBody     "Kepler-226"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01079009246
		SemiMajorAxis   0.047
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-226 c/KOI-749.01"
{
	ParentBody     "Kepler-226"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01464659656
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-226 d/KOI-749.03"
{
	ParentBody     "Kepler-226"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02220182724
		SemiMajorAxis   0.076
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-227 b/KOI-752.01"
{
	ParentBody     "Kepler-227"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02597732481
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-227 c/KOI-752.02"
{
	ParentBody     "Kepler-227"
	Radius          19374.332
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1489934501
		SemiMajorAxis   0.29
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-228 b/KOI-756.03"
{
	ParentBody     "Kepler-228"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007026970244
		SemiMajorAxis   0.038
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-228 c/KOI-756.02"
{
	ParentBody     "Kepler-228"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01131973281
		SemiMajorAxis   0.052
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-228 d/KOI-756.01"
{
	ParentBody     "Kepler-228"
	Radius          25737.12
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03037514917
		SemiMajorAxis   0.101
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-229 b/KOI-757.03"
{
	ParentBody     "Kepler-229"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01712007039
		SemiMajorAxis   0.062
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-229 c/KOI-757.01"
{
	ParentBody     "Kepler-229"
	Radius          31384.988
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04399447393
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-229 d/KOI-757.02"
{
	ParentBody     "Kepler-229"
	Radius          24521.756
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.112787934
		SemiMajorAxis   0.22
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-23 b/KOI-168.03"
{
	ParentBody     "Kepler-23"
	Mass            15.20996
	Radius          10802.4412
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01945830793
		SemiMajorAxis   0.075
		Eccentricity    0.06
		Inclination     83.65
	}
}

Planet	"Kepler-23 c/KOI-168.01"
{
	ParentBody     "Kepler-23"
	Mass            60.1398
	Radius          19874.776
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.0294118103
		SemiMajorAxis   0.099
		Eccentricity    0.02
		Inclination     89.38
	}
}

Planet	"Kepler-23 d/KOI-168.02"
{
	ParentBody     "Kepler-23"
	Mass            17.501
	Radius          14255.5048
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04181962113
		SemiMajorAxis   0.124
		Eccentricity    0.08
		Inclination     89.38
	}
}

Planet	"Kepler-230 b/KOI-759.01"
{
	ParentBody     "Kepler-230"
	Radius          27166.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08932581149
		SemiMajorAxis   0.191
		Eccentricity    0
		Inclination     56.72
	}
}

Planet	"Kepler-230 c/KOI-759.02"
{
	ParentBody     "Kepler-230"
	Radius          13011.544
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2512668157
		SemiMajorAxis   0.38
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-231 b/KOI-784.02"
{
	ParentBody     "Kepler-231"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02755781035
		SemiMajorAxis   0.074
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-231 c/KOI-784.01"
{
	ParentBody     "Kepler-231"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05276380039
		SemiMajorAxis   0.114
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-232 b/KOI-787.01"
{
	ParentBody     "Kepler-232"
	Radius          19660.3
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01213228407
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-232 c/KOI-787.02"
{
	ParentBody     "Kepler-232"
	Radius          24450.264
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03115562582
		SemiMajorAxis   0.101
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-233 b/KOI-790.01"
{
	ParentBody     "Kepler-233"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02319661374
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-233 c/KOI-790.02"
{
	ParentBody     "Kepler-233"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1654216207
		SemiMajorAxis   0.287
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-234 b/KOI-800.01"
{
	ParentBody     "Kepler-234"
	Radius          23592.36
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007423857581
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     79.64
	}
}

Planet	"Kepler-234 c/KOI-800.02"
{
	ParentBody     "Kepler-234"
	Radius          22376.996
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.019745939
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-235 b/KOI-812.01"
{
	ParentBody     "Kepler-235"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009145224984
		SemiMajorAxis   0.037
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-235 c/KOI-812.04"
{
	ParentBody     "Kepler-235"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02142387768
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-235 d/KOI-812.02"
{
	ParentBody     "Kepler-235"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05492396157
		SemiMajorAxis   0.122
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-235 e/KOI-812.03"
{
	ParentBody     "Kepler-235"
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1264466983
		SemiMajorAxis   0.213
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-236 b/KOI-817.02"
{
	ParentBody     "Kepler-236"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02271263077
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-236 c/KOI-817.01"
{
	ParentBody     "Kepler-236"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06562255858
		SemiMajorAxis   0.132
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-237 b/KOI-825.02"
{
	ParentBody     "Kepler-237"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01290953272
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-237 c/KOI-825.01"
{
	ParentBody     "Kepler-237"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02218702063
		SemiMajorAxis   0.071
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-238 b/KOI-834.04"
{
	ParentBody     "Kepler-238"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005724628912
		SemiMajorAxis   0.034
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-238 c/KOI-834.03"
{
	ParentBody     "Kepler-238"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01685335695
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-238 d/KOI-834.02"
{
	ParentBody     "Kepler-238"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0362322573
		SemiMajorAxis   0.115
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-238 e/KOI-834.01"
{
	ParentBody     "Kepler-238"
	Mass            199.1932
	Radius          35817.492
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.06476250734
		SemiMajorAxis   0.1644
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-238 f/KOI-834.05"
{
	ParentBody     "Kepler-238"
	Mass            17.8192
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1381193121
		SemiMajorAxis   0.2724
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-239 b/KOI-835.01"
{
	ParentBody     "Kepler-239"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0322061671
		SemiMajorAxis   0.095
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-239 c/KOI-835.02"
{
	ParentBody     "Kepler-239"
	Radius          16014.208
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1539474342
		SemiMajorAxis   0.268
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-24 b/KOI-1102.02"
{
	ParentBody     "Kepler-24"
	Mass            509.12
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02230109288
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     79.07
	}
}

Planet	"Kepler-24 c/KOI-1102.01"
{
	ParentBody     "Kepler-24"
	Mass            509.12
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03376800475
		SemiMajorAxis   0.106
		Eccentricity    0
		Inclination     77.35
	}
}

Planet	"Kepler-24 d/KOI-1102.04"
{
	ParentBody     "Kepler-24"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01162073856
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-24 e/KOI-1102.03"
{
	ParentBody     "Kepler-24"
	Radius          17730.016
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05201577345
		SemiMajorAxis   0.138
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-240 b/KOI-837.02"
{
	ParentBody     "Kepler-240"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01134725154
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-240 c/KOI-837.01"
{
	ParentBody     "Kepler-240"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02177603853
		SemiMajorAxis   0.074
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-241 b/KOI-842.01"
{
	ParentBody     "Kepler-241"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03482098277
		SemiMajorAxis   0.094
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-241 c/KOI-842.02"
{
	ParentBody     "Kepler-241"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09874537773
		SemiMajorAxis   0.189
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-242 b/KOI-853.01"
{
	ParentBody     "Kepler-242"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02246167126
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-242 c/KOI-853.02"
{
	ParentBody     "Kepler-242"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03969005061
		SemiMajorAxis   0.109
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-243 b/KOI-857.01"
{
	ParentBody     "Kepler-243"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01564836199
		SemiMajorAxis   0.062
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-243 c/KOI-857.02"
{
	ParentBody     "Kepler-243"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05482996915
		SemiMajorAxis   0.142
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-244 b/KOI-864.01"
{
	ParentBody     "Kepler-244"
	Radius          17587.032
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01180529555
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-244 c/KOI-864.03"
{
	ParentBody     "Kepler-244"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02674195991
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-244 d/KOI-864.02"
{
	ParentBody     "Kepler-244"
	Radius          14727.352
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05489618001
		SemiMajorAxis   0.14
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-245 b/KOI-869.01"
{
	ParentBody     "Kepler-245"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0205074611
		SemiMajorAxis   0.071
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-245 c/KOI-869.03"
{
	ParentBody     "Kepler-245"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04780612012
		SemiMajorAxis   0.124
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-245 d/KOI-869.02"
{
	ParentBody     "Kepler-245"
	Radius          19302.84
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09932343253
		SemiMajorAxis   0.202
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-245 e/KOI-869.04"
{
	ParentBody     "Kepler-245"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008815578127
		SemiMajorAxis   0.0397
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-246 b/KOI-874.01"
{
	ParentBody     "Kepler-246"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01259936592
		SemiMajorAxis   0.052
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-246 c/KOI-874.02"
{
	ParentBody     "Kepler-246"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0306294325
		SemiMajorAxis   0.095
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-247 b/KOI-884.03"
{
	ParentBody     "Kepler-247"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009134103597
		SemiMajorAxis   0.042
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-247 c/KOI-884.01"
{
	ParentBody     "Kepler-247"
	Radius          26094.58
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02584436372
		SemiMajorAxis   0.084
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-247 d/KOI-884.02"
{
	ParentBody     "Kepler-247"
	Radius          25165.184
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05606666636
		SemiMajorAxis   0.14
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-248 b/KOI-896.02"
{
	ParentBody     "Kepler-248"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01727129334
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-248 c/KOI-896.01"
{
	ParentBody     "Kepler-248"
	Radius          25951.596
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04446226217
		SemiMajorAxis   0.123
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-249 b/KOI-899.02"
{
	ParentBody     "Kepler-249"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009053003984
		SemiMajorAxis   0.035
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-249 c/KOI-899.01"
{
	ParentBody     "Kepler-249"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01947667109
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-249 d/KOI-899.03"
{
	ParentBody     "Kepler-249"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04207744731
		SemiMajorAxis   0.097
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-25 b/KOI-244.02"
{
	ParentBody     "Kepler-25"
	Mass            8.9096
	Radius          17236.7212
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.0170805484
		SemiMajorAxis   0.068
		Eccentricity    0.05
		Inclination     89.95
	}
}

Planet	"Kepler-25 c/KOI-244.01"
{
	ParentBody     "Kepler-25"
	Mass            14.319
	Radius          32872.0216
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03482721371
		SemiMajorAxis   0.11
		Eccentricity    0.01
		Inclination     89.95
	}
}

Planet	"Kepler-25 d"
{
	ParentBody     "Kepler-25"
	Msini           90.00465658
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3367628478
	}
}

Planet	"Kepler-250 b/KOI-906.03"
{
	ParentBody     "Kepler-250"
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01135723395
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-250 c/KOI-906.01"
{
	ParentBody     "Kepler-250"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01959468046
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-250 d/KOI-906.02"
{
	ParentBody     "Kepler-250"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04831947812
		SemiMajorAxis   0.127
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-251 b/KOI-907.03"
{
	ParentBody     "Kepler-251"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01311714838
		SemiMajorAxis   0.053
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-251 c/KOI-907.01"
{
	ParentBody     "Kepler-251"
	Radius          17658.524
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04521395244
		SemiMajorAxis   0.122
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-251 d/KOI-907.02"
{
	ParentBody     "Kepler-251"
	Radius          17658.524
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08250142464
		SemiMajorAxis   0.182
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-251 e/KOI-907.04"
{
	ParentBody     "Kepler-251"
	Radius          17658.524
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2728057266
		SemiMajorAxis   0.404
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-252 b/KOI-912.02"
{
	ParentBody     "Kepler-252"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01825744995
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-252 c/KOI-912.01"
{
	ParentBody     "Kepler-252"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02970210808
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-253 b/KOI-921.03"
{
	ParentBody     "Kepler-253"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01036021058
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-253 c/KOI-921.01"
{
	ParentBody     "Kepler-253"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02815104959
		SemiMajorAxis   0.089
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-253 d/KOI-921.02"
{
	ParentBody     "Kepler-253"
	Radius          20232.236
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04961055843
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-254 b/KOI-934.01"
{
	ParentBody     "Kepler-254"
	Radius          24664.74
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01595287226
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-254 c/KOI-934.02"
{
	ParentBody     "Kepler-254"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03398343167
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-254 d/KOI-934.03"
{
	ParentBody     "Kepler-254"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05132615432
		SemiMajorAxis   0.139
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-255 b/KOI-938.03"
{
	ParentBody     "Kepler-255"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0156460731
		SemiMajorAxis   0.063
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-255 c/KOI-938.01"
{
	ParentBody     "Kepler-255"
	Radius          19088.364
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0272313749
		SemiMajorAxis   0.092
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-255 d/KOI-938.02"
{
	ParentBody     "Kepler-255"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002862820038
		SemiMajorAxis   0.0202
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-256 b/KOI-939.03"
{
	ParentBody     "Kepler-256"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004436762907
		SemiMajorAxis   0.027
		Eccentricity    0
		Inclination     79.07
	}
}

Planet	"Kepler-256 c/KOI-939.01"
{
	ParentBody     "Kepler-256"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009276091575
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-256 d/KOI-939.02"
{
	ParentBody     "Kepler-256"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01598712351
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-256 e/KOI-939.04"
{
	ParentBody     "Kepler-256"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02924517566
		SemiMajorAxis   0.096
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-257 b/KOI-941.02"
{
	ParentBody     "Kepler-257"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006523526214
		SemiMajorAxis   0.034
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-257 c/KOI-941.01"
{
	ParentBody     "Kepler-257"
	Radius          34530.636
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01801950646
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-257 d/KOI-941.03"
{
	ParentBody     "Kepler-257"
	Radius          31599.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06752930435
		SemiMajorAxis   0.16
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-258 b/KOI-951.01"
{
	ParentBody     "Kepler-258"
	Radius          25880.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03613279179
		SemiMajorAxis   0.103
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-258 c/KOI-951.02"
{
	ParentBody     "Kepler-258"
	Radius          23020.424
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09213907904
		SemiMajorAxis   0.193
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-259 b/KOI-954.01"
{
	ParentBody     "Kepler-259"
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02221900215
		SemiMajorAxis   0.079
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-259 c/KOI-954.02"
{
	ParentBody     "Kepler-259"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1010971132
		SemiMajorAxis   0.217
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-26 b/KOI-250.01"
{
	ParentBody     "Kepler-26"
	Mass            5.126202
	Radius          17730.016
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0336215266
		SemiMajorAxis   0.085
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-26 c/KOI-250.02"
{
	ParentBody     "Kepler-26"
	Mass            6.208082
	Radius          17372.556
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.04724508964
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-26 d/KOI-250.03"
{
	ParentBody     "Kepler-26"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009702928902
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-26 e/KOI-250.04"
{
	ParentBody     "Kepler-26"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1282105855
		SemiMajorAxis   0.22
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-260 b/KOI-986.01"
{
	ParentBody     "Kepler-260"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02241635613
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-260 c/KOI-986.02"
{
	ParentBody     "Kepler-260"
	Radius          11081.26
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.208218492
		SemiMajorAxis   0.332
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-261 b/KOI-988.01"
{
	ParentBody     "Kepler-261"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02842285828
		SemiMajorAxis   0.088
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-261 c/KOI-988.02"
{
	ParentBody     "Kepler-261"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06727278141
		SemiMajorAxis   0.156
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-262 b/KOI-993.02"
{
	ParentBody     "Kepler-262"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03575943679
		SemiMajorAxis   0.108
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-262 c/KOI-993.01"
{
	ParentBody     "Kepler-262"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0598335094
		SemiMajorAxis   0.152
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-263 b/KOI-999.01"
{
	ParentBody     "Kepler-263"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04536192001
		SemiMajorAxis   0.12
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-263 c/KOI-999.02"
{
	ParentBody     "Kepler-263"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1295928409
		SemiMajorAxis   0.242
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-264 b/KOI-1001.01"
{
	ParentBody     "Kepler-264"
	Radius          21233.124
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1117237607
		SemiMajorAxis   0.249
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-264 c/KOI-1001.02"
{
	ParentBody     "Kepler-264"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3835845499
		SemiMajorAxis   0.566
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-265 b/KOI-1052.02"
{
	ParentBody     "Kepler-265"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01874444462
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-265 c/KOI-1052.01"
{
	ParentBody     "Kepler-265"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04662368552
		SemiMajorAxis   0.127
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-265 d/KOI-1052.04"
{
	ParentBody     "Kepler-265"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1180877188
		SemiMajorAxis   0.236
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-265 e/KOI-1052.03"
{
	ParentBody     "Kepler-265"
	Radius          16514.652
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1857151936
		SemiMajorAxis   0.319
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-266 b/KOI-1070.01"
{
	ParentBody     "Kepler-266"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01812038747
		SemiMajorAxis   0.071
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-266 c/KOI-1070.02"
{
	ParentBody     "Kepler-266"
	Radius          24807.724
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2949374524
		SemiMajorAxis   0.457
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-267 b/KOI-1078.01"
{
	ParentBody     "Kepler-267"
	Radius          12654.084
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009182203188
		SemiMajorAxis   0.037
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-267 c/KOI-1078.02"
{
	ParentBody     "Kepler-267"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01882983453
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-267 d/KOI-1078.03"
{
	ParentBody     "Kepler-267"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07793326125
		SemiMajorAxis   0.154
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-268 b/KOI-1113.01"
{
	ParentBody     "Kepler-268"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07100531845
		SemiMajorAxis   0.18
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-268 c/KOI-1113.02"
{
	ParentBody     "Kepler-268"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2284686581
		SemiMajorAxis   0.391
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-269 b/KOI-1127.01"
{
	ParentBody     "Kepler-269"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01458407092
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-269 c/KOI-1127.02"
{
	ParentBody     "Kepler-269"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02225345052
		SemiMajorAxis   0.081
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-27 b/KOI-841.01"
{
	ParentBody     "Kepler-27"
	Mass            2898.802
	Radius          25522.644
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.04198529202
		SemiMajorAxis   0.118
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-27 c/KOI-841.02"
{
	ParentBody     "Kepler-27"
	Mass            4391.16
	Radius          31456.48
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.08578116349
		SemiMajorAxis   0.191
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-270 b/KOI-1148.01"
{
	ParentBody     "Kepler-270"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03142050486
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-270 c/KOI-1148.02"
{
	ParentBody     "Kepler-270"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06916749407
		SemiMajorAxis   0.18
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-271 b/KOI-1151.01"
{
	ParentBody     "Kepler-271"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01428569356
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-271 c/KOI-1151.02"
{
	ParentBody     "Kepler-271"
	Radius          6362.788
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02029046809
		SemiMajorAxis   0.071
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-271 d/KOI-1151.03"
{
	ParentBody     "Kepler-271"
	Radius          4218.028
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01437327219
		SemiMajorAxis   0.0554
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-272 b/KOI-1161.03"
{
	ParentBody     "Kepler-272"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008135295107
		SemiMajorAxis   0.038
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-272 c/KOI-1161.01"
{
	ParentBody     "Kepler-272"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01658445319
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-272 d/KOI-1161.02"
{
	ParentBody     "Kepler-272"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02994534669
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-273 b/KOI-1163.01"
{
	ParentBody     "Kepler-273"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008039958366
		SemiMajorAxis   0.037
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-273 c/KOI-1163.02"
{
	ParentBody     "Kepler-273"
	Radius          12654.084
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02194414343
		SemiMajorAxis   0.073
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-274 b/KOI-1196.02"
{
	ParentBody     "Kepler-274"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03185499464
		SemiMajorAxis   0.101
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-274 c/KOI-1196.03"
{
	ParentBody     "Kepler-274"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09089273343
		SemiMajorAxis   0.204
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-275 b/KOI-1198.02"
{
	ParentBody     "Kepler-275"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02820233337
		SemiMajorAxis   0.098
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-275 c/KOI-1198.01"
{
	ParentBody     "Kepler-275"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04404785221
		SemiMajorAxis   0.132
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-275 d/KOI-1198.03"
{
	ParentBody     "Kepler-275"
	Radius          21233.124
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09767782308
		SemiMajorAxis   0.224
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-276 b/KOI-1203.02"
{
	ParentBody     "Kepler-276"
	Radius          18301.952
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03868230558
		SemiMajorAxis   0.119
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-276 c/KOI-1203.01"
{
	ParentBody     "Kepler-276"
	Mass            14.319
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.08729550114
		SemiMajorAxis   0.2032
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-276 d/KOI-1203.03"
{
	ParentBody     "Kepler-276"
	Mass            14.0008
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1331938132
		SemiMajorAxis   0.2694
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-277 b/KOI-1215.01"
{
	ParentBody     "Kepler-277"
	Mass            89.096
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04743154127
		SemiMajorAxis   0.1363
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-277 c/KOI-1215.02"
{
	ParentBody     "Kepler-277"
	Mass            66.822
	Radius          21447.6
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.09036743541
		SemiMajorAxis   0.2095
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-278 b/KOI-1221.01"
{
	ParentBody     "Kepler-278"
	Radius          29240.228
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08257140286
		SemiMajorAxis   0.207
		Eccentricity    0.04
		Inclination     87.66
	}
}

Planet	"Kepler-278 c/KOI-1221.02"
{
	ParentBody     "Kepler-278"
	Radius          21090.14
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.139866372
		SemiMajorAxis   0.294
		Eccentricity    0.51
		Inclination     89.38
	}
}

Planet	"Kepler-279 b/KOI-1236.02"
{
	ParentBody     "Kepler-279"
	Radius          23091.916
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03370279048
		SemiMajorAxis   0.112
		Eccentricity    0
		Inclination     82.51
	}
}

Planet	"Kepler-279 c/KOI-1236.01"
{
	ParentBody     "Kepler-279"
	Mass            54.4122
	Radius          27524.42
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.09784192789
		SemiMajorAxis   0.232
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-279 d/KOI-1236.03"
{
	ParentBody     "Kepler-279"
	Mass            41.366
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1489805984
		SemiMajorAxis   0.30728
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-28 b/KOI-870.01"
{
	ParentBody     "Kepler-28"
	Mass            480.482
	Radius          22948.932
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01618734134
		SemiMajorAxis   0.062
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-28 c/KOI-870.02"
{
	ParentBody     "Kepler-28"
	Mass            432.752
	Radius          21662.076
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02460230567
		SemiMajorAxis   0.081
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-280 b/KOI-1240.01"
{
	ParentBody     "Kepler-280"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005857872008
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-280 c/KOI-1240.02"
{
	ParentBody     "Kepler-280"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01316137931
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-281 b/KOI-1258.02"
{
	ParentBody     "Kepler-281"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04009944198
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-281 c/KOI-1258.01"
{
	ParentBody     "Kepler-281"
	Radius          33887.208
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09948843263
		SemiMajorAxis   0.215
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-282 b/KOI-1278.03"
{
	ParentBody     "Kepler-282"
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0252449587
		SemiMajorAxis   0.082
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-282 c/KOI-1278.04"
{
	ParentBody     "Kepler-282"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03734158698
		SemiMajorAxis   0.106
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-282 d/KOI-1278.01"
{
	ParentBody     "Kepler-282"
	Mass            64.9128
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.06791657889
		SemiMajorAxis   0.1648
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-282 e/KOI-1278.02"
{
	ParentBody     "Kepler-282"
	Mass            61.0944
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1214180651
		SemiMajorAxis   0.2427
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-283 b/KOI-1298.01"
{
	ParentBody     "Kepler-283"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03013931935
		SemiMajorAxis   0.082
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-283 c/KOI-1298.02"
{
	ParentBody     "Kepler-283"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2539238718
		SemiMajorAxis   0.341
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-284 b/KOI-1301.01"
{
	ParentBody     "Kepler-284"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03476911855
		SemiMajorAxis   0.104
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-284 c/KOI-1301.02"
{
	ParentBody     "Kepler-284"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1027111792
		SemiMajorAxis   0.213
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-285 b/KOI-1305.01"
{
	ParentBody     "Kepler-285"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007211289038
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-285 c/KOI-1305.02"
{
	ParentBody     "Kepler-285"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01693855795
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-286 b/KOI-1306.01"
{
	ParentBody     "Kepler-286"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004918112009
		SemiMajorAxis   0.027
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-286 c/KOI-1306.02"
{
	ParentBody     "Kepler-286"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009495329664
		SemiMajorAxis   0.042
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-286 d/KOI-1306.03"
{
	ParentBody     "Kepler-286"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01619288013
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-286 e/KOI-1306.04"
{
	ParentBody     "Kepler-286"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08000523984
		SemiMajorAxis   0.176
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-287 b/KOI-1307.02"
{
	ParentBody     "Kepler-287"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05569509647
		SemiMajorAxis   0.145
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-287 c/KOI-1307.01"
{
	ParentBody     "Kepler-287"
	Radius          20804.172
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1228004246
		SemiMajorAxis   0.246
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-288 b/KOI-1332.02"
{
	ParentBody     "Kepler-288"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01669392576
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-288 c/KOI-1332.01"
{
	ParentBody     "Kepler-288"
	Radius          18158.968
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05285745332
		SemiMajorAxis   0.14
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-288 d/KOI-1332.03"
{
	ParentBody     "Kepler-288"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1550580507
		SemiMajorAxis   0.287
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-289 b/KOI-1353.02"
{
	ParentBody     "Kepler-289"
	Msini           7.3186
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09458107787
		SemiMajorAxis   0.21
		Eccentricity    0.024
		Inclination     89.59
		ArgOfPericen    28
	}
}

Planet	"Kepler-289 c/KOI-1353.01"
{
	ParentBody     "Kepler-289"
	Msini           4.1366
	Radius          17086.588
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1808755994
		SemiMajorAxis   0.33
		Eccentricity    0.0115
		Inclination     89.73
		ArgOfPericen    72
	}
}

Planet	"Kepler-289 d"
{
	ParentBody     "Kepler-289"
	Msini           132.053
	Radius          73922.728
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3445708177
		SemiMajorAxis   0.51
		Eccentricity    0.0033
		Inclination     89.794
		ArgOfPericen    45
	}
}

Planet	"Kepler-29 b/KOI-738.01"
{
	ParentBody     "Kepler-29"
	Mass            4.515258
	Radius          21376.108
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02830560184
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     39.53
	}
}

Planet	"Kepler-29 c/KOI-738.02"
{
	ParentBody     "Kepler-29"
	Mass            4.006138
	Radius          20017.76
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03638243437
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     55
	}
}

Planet	"Kepler-290 b/KOI-1360.02"
{
	ParentBody     "Kepler-290"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0399443093
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-290 c/KOI-1360.01"
{
	ParentBody     "Kepler-290"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1006737749
		SemiMajorAxis   0.205
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-291 b/KOI-1363.01"
{
	ParentBody     "Kepler-291"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009710025563
		SemiMajorAxis   0.047
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-291 c/KOI-1363.02"
{
	ParentBody     "Kepler-291"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01560823519
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-292 b/KOI-1364.05"
{
	ParentBody     "Kepler-292"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007066070327
		SemiMajorAxis   0.035
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-292 c/KOI-1364.04"
{
	ParentBody     "Kepler-292"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01017225037
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-292 d/KOI-1364.02"
{
	ParentBody     "Kepler-292"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01931780938
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-292 e/KOI-1364.03"
{
	ParentBody     "Kepler-292"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03279744327
		SemiMajorAxis   0.097
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-292 f/KOI-1364.01"
{
	ParentBody     "Kepler-292"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05704225191
		SemiMajorAxis   0.141
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-293 b/KOI-1366.01"
{
	ParentBody     "Kepler-293"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05271624291
		SemiMajorAxis   0.144
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-293 c/KOI-1366.02"
{
	ParentBody     "Kepler-293"
	Radius          24450.264
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1482735141
		SemiMajorAxis   0.286
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-294 b/KOI-1396.02"
{
	ParentBody     "Kepler-294"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01013358287
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-294 c/KOI-1396.01"
{
	ParentBody     "Kepler-294"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0181424824
		SemiMajorAxis   0.071
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-295 b/KOI-1413.01"
{
	ParentBody     "Kepler-295"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03462131252
		SemiMajorAxis   0.099
		Eccentricity    0
		Inclination     81.36
	}
}

Planet	"Kepler-295 c/KOI-1413.02"
{
	ParentBody     "Kepler-295"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05893694266
		SemiMajorAxis   0.142
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-295 d/KOI-1413.03"
{
	ParentBody     "Kepler-295"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09277146765
		SemiMajorAxis   0.192
	}
}

Planet	"Kepler-296 A b/KOI-1422.03"
{
	ParentBody     "Kepler-296 A"
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02974569834
		SemiMajorAxis   0.079
		Eccentricity    0.33
		Inclination     79.64
	}
}

Planet	"Kepler-296 A c/KOI-1422.01"
{
	ParentBody     "Kepler-296 A"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01599387136
		SemiMajorAxis   0.0521
		Eccentricity    0.33
		Inclination     88.24
	}
}

Planet	"Kepler-296 A d/KOI-1422.02"
{
	ParentBody     "Kepler-296 A"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05434829697
		SemiMajorAxis   0.118
		Eccentricity    0.33
		Inclination     88.81
	}
}

Planet	"Kepler-296 A e/KOI-1422.05"
{
	ParentBody     "Kepler-296 A"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09347800158
		SemiMajorAxis   0.169
		Eccentricity    0.33
		Inclination     89.89
	}
}

Planet	"Kepler-296 A f/KOI-1422.04"
{
	ParentBody     "Kepler-296 A"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1734089647
		SemiMajorAxis   0.255
		Eccentricity    0.33
		Inclination     89.95
	}
}

Planet	"Kepler-297 b/KOI-1426.01"
{
	ParentBody     "Kepler-297"
	Radius          18301.952
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1064275352
		SemiMajorAxis   0.217
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-297 c/KOI-1426.02"
{
	ParentBody     "Kepler-297"
	Radius          41679.836
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2051245422
		SemiMajorAxis   0.336
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-298 b/KOI-1430.01"
{
	ParentBody     "Kepler-298"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02868087064
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-298 c/KOI-1430.02"
{
	ParentBody     "Kepler-298"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06277700287
		SemiMajorAxis   0.136
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-298 d/KOI-1430.03"
{
	ParentBody     "Kepler-298"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2121157828
		SemiMajorAxis   0.305
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-299 b/KOI-1432.03"
{
	ParentBody     "Kepler-299"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008014211067
		SemiMajorAxis   0.04
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-299 c/KOI-1432.01"
{
	ParentBody     "Kepler-299"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01885290142
		SemiMajorAxis   0.07
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-299 d/KOI-1432.02"
{
	ParentBody     "Kepler-299"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04121863908
		SemiMajorAxis   0.118
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-299 e/KOI-1432.04"
{
	ParentBody     "Kepler-299"
	Radius          11939.164
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1048221976
		SemiMajorAxis   0.22
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-3 b/KOI-3.01/HAT-P-11 b"
{
	ParentBody     "Kepler-3"
	Mass            26.23050058
	Radius          30168.41497
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.01338236418
		SemiMajorAxis   0.053
		Eccentricity    0.198
		Inclination     88.5
		ArgOfPericen    355.2
	}
}

Planet	"Kepler-30 b/KOI-806.03"
{
	ParentBody     "Kepler-30"
	Mass            11.4552
	Radius          25022.2
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.08031383234
		SemiMajorAxis   0.18
		Eccentricity    0.042
		Inclination     89.82
		ArgOfPericen   -31
	}
}

Planet	"Kepler-30 c/KOI-806.02"
{
	ParentBody     "Kepler-30"
	Mass            639.582
	Radius          78426.724
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1651591921
		SemiMajorAxis   0.3
		Eccentricity    0.0111
		Inclination     90.323
		ArgOfPericen   -49
	}
}

Planet	"Kepler-30 d/KOI-806.01"
{
	ParentBody     "Kepler-30"
	Mass            23.2286
	Radius          56121.22
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.392462711
		SemiMajorAxis   0.5
		Eccentricity    0.022
		Inclination     89.841
		ArgOfPericen   -163
	}
}

Planet	"Kepler-300 b/KOI-1435.02"
{
	ParentBody     "Kepler-300"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02860115094
		SemiMajorAxis   0.094
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-300 c/KOI-1435.01"
{
	ParentBody     "Kepler-300"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1114738552
		SemiMajorAxis   0.232
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-301 b/KOI-1436.01"
{
	ParentBody     "Kepler-301"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006868190668
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-301 c/KOI-1436.03"
{
	ParentBody     "Kepler-301"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01483680186
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-301 d/KOI-1436.02"
{
	ParentBody     "Kepler-301"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03764965654
		SemiMajorAxis   0.112
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-302 b/KOI-1486.02"
{
	ParentBody     "Kepler-302"
	Radius          25880.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08264134002
		SemiMajorAxis   0.193
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-302 c/KOI-1486.01"
{
	ParentBody     "Kepler-302"
	Radius          79427.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3484870794
		SemiMajorAxis   0.503
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-303 b/KOI-1515.01"
{
	ParentBody     "Kepler-303"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005303480961
		SemiMajorAxis   0.024
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-303 c/KOI-1515.02"
{
	ParentBody     "Kepler-303"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01933278574
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-304 b/KOI-1557.01"
{
	ParentBody     "Kepler-304"
	Radius          18230.46
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009023352426
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-304 c/KOI-1557.03"
{
	ParentBody     "Kepler-304"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01455457816
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-304 d/KOI-1557.02"
{
	ParentBody     "Kepler-304"
	Radius          17515.54
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02643032834
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-304 e/KOI-1557.04"
{
	ParentBody     "Kepler-304"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004104528424
		SemiMajorAxis   0.0241
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-305 b/KOI-1563.01"
{
	ParentBody     "Kepler-305"
	Mass            11.32792
	Radius          23020.424
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.0150229085
		SemiMajorAxis   0.05856
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-305 c/KOI-1563.02"
{
	ParentBody     "Kepler-305"
	Mass            6.10944
	Radius          21090.14
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02270000627
		SemiMajorAxis   0.07711
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-305 d/KOI-1563.04"
{
	ParentBody     "Kepler-305"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04582893616
		SemiMajorAxis   0.121
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-306 b/KOI-1567.02"
{
	ParentBody     "Kepler-306"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01272083601
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-306 c/KOI-1567.01"
{
	ParentBody     "Kepler-306"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01982299198
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-306 d/KOI-1567.03"
{
	ParentBody     "Kepler-306"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0474387803
		SemiMajorAxis   0.12
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-306 e/KOI-1567.04"
{
	ParentBody     "Kepler-306"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1227705239
		SemiMajorAxis   0.227
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-307 b/KOI-1576.01"
{
	ParentBody     "Kepler-307"
	Mass            7.449062
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02853120557
		SemiMajorAxis   0.0928
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-307 c/KOI-1576.02"
{
	ParentBody     "Kepler-307"
	Mass            3.64339
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.03579241491
		SemiMajorAxis   0.1081
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-308 b/KOI-1593.01"
{
	ParentBody     "Kepler-308"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02654383384
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-308 c/KOI-1593.02"
{
	ParentBody     "Kepler-308"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0421153701
		SemiMajorAxis   0.123
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-309 b/KOI-1596.01"
{
	ParentBody     "Kepler-309"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01621842483
		SemiMajorAxis   0.059
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-309 c/KOI-1596.02"
{
	ParentBody     "Kepler-309"
	Radius          16014.208
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2884562242
		SemiMajorAxis   0.401
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-31 b/KOI-935.01"
{
	ParentBody     "Kepler-31"
	Radius          27166.96
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.05711634795
		SemiMajorAxis   0.16
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-31 c/KOI-935.02"
{
	ParentBody     "Kepler-31"
	Mass            1495.54
	Radius          27166.96
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1167220031
		SemiMajorAxis   0.26
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-31 d/KOI-935.03"
{
	ParentBody     "Kepler-31"
	Mass            2163.76
	Radius          24879.216
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2399643372
		SemiMajorAxis   0.4
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-310 b/KOI-1598.03"
{
	ParentBody     "Kepler-310"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03814098805
		SemiMajorAxis   0.111
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-310 c/KOI-1598.01"
{
	ParentBody     "Kepler-310"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1546245794
		SemiMajorAxis   0.281
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-310 d/KOI-1598.02"
{
	ParentBody     "Kepler-310"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2542864093
		SemiMajorAxis   0.392
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-311 b/KOI-1608.01"
{
	ParentBody     "Kepler-311"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02512330792
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-311 c/KOI-1608.02"
{
	ParentBody     "Kepler-311"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05404163744
		SemiMajorAxis   0.145
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-312 b/KOI-1628.02"
{
	ParentBody     "Kepler-312"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00485272252
		SemiMajorAxis   0.031
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-312 c/KOI-1628.01"
{
	ParentBody     "Kepler-312"
	Radius          20089.252
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0540666236
		SemiMajorAxis   0.153
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-313 b/KOI-1647.01"
{
	ParentBody     "Kepler-313"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04098764714
		SemiMajorAxis   0.125
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-313 c/KOI-1647.02"
{
	ParentBody     "Kepler-313"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08836129532
		SemiMajorAxis   0.208
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-314 b/KOI-1692.02"
{
	ParentBody     "Kepler-314"
	Radius          5290.408
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006738183782
		SemiMajorAxis   0.035
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-314 c/KOI-1692.01"
{
	ParentBody     "Kepler-314"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01631901288
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-315 b/KOI-1707.01"
{
	ParentBody     "Kepler-315"
	Radius          24021.312
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2631162108
		SemiMajorAxis   0.402
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-315 c/KOI-1707.02"
{
	ParentBody     "Kepler-315"
	Radius          26452.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.7268309696
		SemiMajorAxis   0.791
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-316 b/KOI-1713.02"
{
	ParentBody     "Kepler-316"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006134307761
		SemiMajorAxis   0.027
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-316 c/KOI-1713.01"
{
	ParentBody     "Kepler-316"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01869380425
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-317 b/KOI-1760.01"
{
	ParentBody     "Kepler-317"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01512487372
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-317 c/KOI-1760.02"
{
	ParentBody     "Kepler-317"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02402518177
		SemiMajorAxis   0.083
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-318 b/KOI-1779.01"
{
	ParentBody     "Kepler-318"
	Radius          30026.64
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01276609091
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-318 c/KOI-1779.02"
{
	ParentBody     "Kepler-318"
	Radius          23449.376
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03234841792
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-319 b/KOI-1805.03"
{
	ParentBody     "Kepler-319"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01194469073
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-319 c/KOI-1805.01"
{
	ParentBody     "Kepler-319"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01900480611
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-319 d/KOI-1805.02"
{
	ParentBody     "Kepler-319"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08701602904
		SemiMajorAxis   0.191
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-32 b/KOI-952.01"
{
	ParentBody     "Kepler-32"
	Mass            1304.62
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01615706007
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-32 c/KOI-952.02"
{
	ParentBody     "Kepler-32"
	Mass            159.1
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.02396273005
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-32 d/KOI-952.03"
{
	ParentBody     "Kepler-32"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.06237012216
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-32 e/KOI-952.04"
{
	ParentBody     "Kepler-32"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007928985425
		SemiMajorAxis   0.033
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-32 f/KOI-952.05"
{
	ParentBody     "Kepler-32"
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.002034157117
		SemiMajorAxis   0.013
		Eccentricity    0
		Inclination     66.46
	}
}

Planet	"Kepler-320 b/KOI-1806.03"
{
	ParentBody     "Kepler-320"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02292055582
		SemiMajorAxis   0.085
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-320 c/KOI-1806.02"
{
	ParentBody     "Kepler-320"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04910423138
		SemiMajorAxis   0.142
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-321 b/KOI-1809.02"
{
	ParentBody     "Kepler-321"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01345786203
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-321 c/KOI-1809.01"
{
	ParentBody     "Kepler-321"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0358499685
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-322 b/KOI-1820.02"
{
	ParentBody     "Kepler-322"
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004528195389
		SemiMajorAxis   0.027
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-322 c/KOI-1820.01"
{
	ParentBody     "Kepler-322"
	Radius          10652.308
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01187495344
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-323 b/KOI-1824.02"
{
	ParentBody     "Kepler-323"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004595107155
		SemiMajorAxis   0.028
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-323 c/KOI-1824.01"
{
	ParentBody     "Kepler-323"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009730042418
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-324 b/KOI-1831.02"
{
	ParentBody     "Kepler-324"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01200659486
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-324 c/KOI-1831.01"
{
	ParentBody     "Kepler-324"
	Radius          20089.252
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1418390685
		SemiMajorAxis   0.26
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-325 b/KOI-1832.01"
{
	ParentBody     "Kepler-325"
	Radius          18587.92
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01244226195
		SemiMajorAxis   0.053
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-325 c/KOI-1832.02"
{
	ParentBody     "Kepler-325"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03494166981
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-325 d/KOI-1832.03"
{
	ParentBody     "Kepler-325"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1059986663
		SemiMajorAxis   0.22
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-326 b/KOI-1835.02"
{
	ParentBody     "Kepler-326"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00615572095
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-326 c/KOI-1835.01"
{
	ParentBody     "Kepler-326"
	Radius          8936.5
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01254060491
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-326 d/KOI-1835.03"
{
	ParentBody     "Kepler-326"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0185271258
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-327 b/KOI-1867.01"
{
	ParentBody     "Kepler-327"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006980505185
		SemiMajorAxis   0.029
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-327 c/KOI-1867.03"
{
	ParentBody     "Kepler-327"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01427089516
		SemiMajorAxis   0.047
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-327 d/KOI-1867.02"
{
	ParentBody     "Kepler-327"
	Radius          11009.768
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03824710668
		SemiMajorAxis   0.09
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-328 b/KOI-1873.02"
{
	ParentBody     "Kepler-328"
	Mass            21.9558
	Radius          14727.352
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.09561053178
		SemiMajorAxis   0.219
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-328 c/KOI-1873.01"
{
	ParentBody     "Kepler-328"
	Mass            31.82
	Radius          34530.636
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1952457903
		SemiMajorAxis   0.3526
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-329 b/KOI-1874.02"
{
	ParentBody     "Kepler-329"
	Radius          8936.5
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02030542256
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-329 c/KOI-1874.01"
{
	ParentBody     "Kepler-329"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0511571158
		SemiMajorAxis   0.113
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-33 b/KOI-707.05"
{
	ParentBody     "Kepler-33"
	Radius          11081.26
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01551827844
		SemiMajorAxis   0.0677
		Eccentricity    0
		Inclination     86.39
	}
}

Planet	"Kepler-33 c/KOI-707.04"
{
	ParentBody     "Kepler-33"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.03607365295
		SemiMajorAxis   0.1189
		Eccentricity    0
		Inclination     88.19
	}
}

Planet	"Kepler-33 d/KOI-707.01"
{
	ParentBody     "Kepler-33"
	Radius          34101.684
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0596206041
		SemiMajorAxis   0.1662
		Eccentricity    0
		Inclination     88.71
	}
}

Planet	"Kepler-33 e/KOI-707.03"
{
	ParentBody     "Kepler-33"
	Radius          25665.628
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.08702280537
		SemiMajorAxis   0.2138
		Eccentricity    0
		Inclination     88.94
	}
}

Planet	"Kepler-33 f/KOI-707.02"
{
	ParentBody     "Kepler-33"
	Radius          28453.816
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.1123337367
		SemiMajorAxis   0.2535
		Eccentricity    0
		Inclination     89.17
	}
}

Planet	"Kepler-330 b/KOI-1891.02"
{
	ParentBody     "Kepler-330"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02261452874
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-330 c/KOI-1891.01"
{
	ParentBody     "Kepler-330"
	Radius          12439.608
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04368440296
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-331 b/KOI-1895.01"
{
	ParentBody     "Kepler-331"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02315585722
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-331 c/KOI-1895.02"
{
	ParentBody     "Kepler-331"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04731411233
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-331 d/KOI-1895.03"
{
	ParentBody     "Kepler-331"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08798087651
		SemiMajorAxis   0.159
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-332 b/KOI-1905.01"
{
	ParentBody     "Kepler-332"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02088018365
		SemiMajorAxis   0.07
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-332 c/KOI-1905.02"
{
	ParentBody     "Kepler-332"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04379456274
		SemiMajorAxis   0.114
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-332 d/KOI-1905.03"
{
	ParentBody     "Kepler-332"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09366809463
		SemiMajorAxis   0.189
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-333 b/KOI-1908.01"
{
	ParentBody     "Kepler-333"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03436393261
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-333 c/KOI-1908.02"
{
	ParentBody     "Kepler-333"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06595133495
		SemiMajorAxis   0.135
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-334 b/KOI-1909.02"
{
	ParentBody     "Kepler-334"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01497723744
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-334 c/KOI-1909.01"
{
	ParentBody     "Kepler-334"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03493026095
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-334 d/KOI-1909.03"
{
	ParentBody     "Kepler-334"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06871738999
		SemiMajorAxis   0.168
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-335 b/KOI-1915.01"
{
	ParentBody     "Kepler-335"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01796706728
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-335 c/KOI-1915.02"
{
	ParentBody     "Kepler-335"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1857520048
		SemiMajorAxis   0.356
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-336 b/KOI-1916.03"
{
	ParentBody     "Kepler-336"
	Radius          6505.772
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005543781787
		SemiMajorAxis   0.033
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-336 c/KOI-1916.02"
{
	ParentBody     "Kepler-336"
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02628393232
		SemiMajorAxis   0.092
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-336 d/KOI-1916.01"
{
	ParentBody     "Kepler-336"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05661660283
		SemiMajorAxis   0.154
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-337 b/KOI-1929.02"
{
	ParentBody     "Kepler-337"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009015335828
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-337 c/KOI-1929.01"
{
	ParentBody     "Kepler-337"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02653910547
		SemiMajorAxis   0.093
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-338 b/KOI-1930.01"
{
	ParentBody     "Kepler-338"
	Mass            30.64266
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03758325402
		SemiMajorAxis   0.117
		Eccentricity    0.04
		Inclination     89.38
	}
}

Planet	"Kepler-338 c/KOI-1930.02"
{
	ParentBody     "Kepler-338"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06656317555
		SemiMajorAxis   0.172
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-338 d/KOI-1930.03"
{
	ParentBody     "Kepler-338"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1216417523
		SemiMajorAxis   0.257
		Eccentricity    0.03
		Inclination     88.24
	}
}

Planet	"Kepler-338 e/KOI-1930.04"
{
	ParentBody     "Kepler-338"
	Mass            8.5914
	Radius          10123.2672
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02557615265
		SemiMajorAxis   0.0906
		Eccentricity    0.05
		Inclination     81.93
	}
}

Planet	"Kepler-339 b/KOI-1931.01"
{
	ParentBody     "Kepler-339"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01362837081
		SemiMajorAxis   0.055
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-339 c/KOI-1931.03"
{
	ParentBody     "Kepler-339"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.019132661
		SemiMajorAxis   0.069
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-339 d/KOI-1931.02"
{
	ParentBody     "Kepler-339"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02890779131
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-34 b"
{
	ParentBody     "Kepler-34"
	Mass            69.98137369
	Radius          54596.53956
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.7907684491
		SemiMajorAxis   1.0896
		Eccentricity    0.182
		Inclination     90.355
	}
}

Planet	"Kepler-340 b/KOI-1932.02"
{
	ParentBody     "Kepler-340"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04064258569
		SemiMajorAxis   0.134
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-340 c/KOI-1932.01"
{
	ParentBody     "Kepler-340"
	Radius          21519.092
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06249187425
		SemiMajorAxis   0.178
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-341 b/KOI-1952.03"
{
	ParentBody     "Kepler-341"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0142248846
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-341 c/KOI-1952.01"
{
	ParentBody     "Kepler-341"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02193177629
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-341 d/KOI-1952.02"
{
	ParentBody     "Kepler-341"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07574785654
		SemiMajorAxis   0.182
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-341 e/KOI-1952.04"
{
	ParentBody     "Kepler-341"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1162879596
		SemiMajorAxis   0.242
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-342 b/KOI-1955.01"
{
	ParentBody     "Kepler-342"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04153495522
		SemiMajorAxis   0.128
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-342 c/KOI-1955.04"
{
	ParentBody     "Kepler-342"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07182669124
		SemiMajorAxis   0.185
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-342 d/KOI-1955.02"
{
	ParentBody     "Kepler-342"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1080361418
		SemiMajorAxis   0.242
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-342 e/KOI-1955.03"
{
	ParentBody     "Kepler-342"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004501737903
		SemiMajorAxis   0.029
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-343 b/KOI-1960.01"
{
	ParentBody     "Kepler-343"
	Radius          15370.78
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02455507674
		SemiMajorAxis   0.088
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-343 c/KOI-1960.02"
{
	ParentBody     "Kepler-343"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06357923768
		SemiMajorAxis   0.167
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-344 b/KOI-1970.01"
{
	ParentBody     "Kepler-344"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06013528998
		SemiMajorAxis   0.153
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-344 c/KOI-1970.02"
{
	ParentBody     "Kepler-344"
	Radius          18802.396
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3438726754
		SemiMajorAxis   0.488
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-345 b/KOI-1977.02"
{
	ParentBody     "Kepler-345"
	Radius          4718.472
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02030313914
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-345 c/KOI-1977.01"
{
	ParentBody     "Kepler-345"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02570192399
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-346 b/KOI-1978.01"
{
	ParentBody     "Kepler-346"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01782687537
		SemiMajorAxis   0.071
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-346 c/KOI-1978.02"
{
	ParentBody     "Kepler-346"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06530337859
		SemiMajorAxis   0.168
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-347 b/KOI-1992.01"
{
	ParentBody     "Kepler-347"
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03504074928
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-347 c/KOI-1992.02"
{
	ParentBody     "Kepler-347"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07480206767
		SemiMajorAxis   0.183
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-348 b/KOI-2011.01"
{
	ParentBody     "Kepler-348"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01932079644
		SemiMajorAxis   0.076
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-348 c/KOI-2011.02"
{
	ParentBody     "Kepler-348"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0472711737
		SemiMajorAxis   0.138
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-349 b/KOI-2022.01"
{
	ParentBody     "Kepler-349"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01623519452
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-349 c/KOI-2022.02"
{
	ParentBody     "Kepler-349"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03353289773
		SemiMajorAxis   0.105
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-35 b"
{
	ParentBody     "Kepler-35"
	Mass            40.34691502
	Radius          52045.29939
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.359920085
		SemiMajorAxis   0.60347
		Eccentricity    0.042
		Inclination     90.76
	}
}

Planet	"Kepler-350 b/KOI-2025.03"
{
	ParentBody     "Kepler-350"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03063600622
		SemiMajorAxis   0.104
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-350 c/KOI-2025.01"
{
	ParentBody     "Kepler-350"
	Mass            5.60032
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04886894367
		SemiMajorAxis   0.1336
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-350 d/KOI-2025.02"
{
	ParentBody     "Kepler-350"
	Mass            15.2736
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.0715579983
		SemiMajorAxis   0.1723
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-351 b/KOI-2028.02"
{
	ParentBody     "Kepler-351"
	Radius          19517.316
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1014530085
		SemiMajorAxis   0.214
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-351 c/KOI-2028.01"
{
	ParentBody     "Kepler-351"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1567400798
		SemiMajorAxis   0.287
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-351 d/KOI-2028.03"
{
	ParentBody     "Kepler-351"
	Radius          17372.556
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3902732241
		SemiMajorAxis   0.5184
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-352 b/KOI-2029.02"
{
	ParentBody     "Kepler-352"
	Radius          5504.884
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02753069136
		SemiMajorAxis   0.085
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-352 c/KOI-2029.01"
{
	ParentBody     "Kepler-352"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04471825943
		SemiMajorAxis   0.118
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-353 b/KOI-2036.02"
{
	ParentBody     "Kepler-353"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01586694572
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-353 c/KOI-2036.01"
{
	ParentBody     "Kepler-353"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02302826517
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-354 b/KOI-2045.01"
{
	ParentBody     "Kepler-354"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01499459852
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-354 c/KOI-2045.03"
{
	ParentBody     "Kepler-354"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04636485727
		SemiMajorAxis   0.115
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-354 d/KOI-2045.02"
{
	ParentBody     "Kepler-354"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06628435234
		SemiMajorAxis   0.146
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-355 b/KOI-2051.02"
{
	ParentBody     "Kepler-355"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03020431458
		SemiMajorAxis   0.102
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-355 c/KOI-2051.01"
{
	ParentBody     "Kepler-355"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07053482515
		SemiMajorAxis   0.179
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-356 b/KOI-2053.02"
{
	ParentBody     "Kepler-356"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01262914342
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-356 c/KOI-2053.01"
{
	ParentBody     "Kepler-356"
	Radius          11510.212
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0359258387
		SemiMajorAxis   0.115
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-357 b/KOI-2073.02"
{
	ParentBody     "Kepler-357"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01772915118
		SemiMajorAxis   0.063
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-357 c/KOI-2073.03"
{
	ParentBody     "Kepler-357"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04615668854
		SemiMajorAxis   0.12
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-357 d/KOI-2073.01"
{
	ParentBody     "Kepler-357"
	Radius          21876.552
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1355261697
		SemiMajorAxis   0.246
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-358 b/KOI-2080.02"
{
	ParentBody     "Kepler-358"
	Radius          17372.556
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09325447045
		SemiMajorAxis   0.21
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-358 c/KOI-2080.01"
{
	ParentBody     "Kepler-358"
	Radius          18158.968
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2285835846
		SemiMajorAxis   0.381
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-359 b/KOI-2092.02"
{
	ParentBody     "Kepler-359"
	Radius          22519.98
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06998978407
		SemiMajorAxis   0.178
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-359 c/KOI-2092.01"
{
	ParentBody     "Kepler-359"
	Radius          27452.928
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1579445683
		SemiMajorAxis   0.307
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-359 d/KOI-2092.03"
{
	ParentBody     "Kepler-359"
	Radius          25594.136
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2110810118
		SemiMajorAxis   0.372
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-36 b/KOI-277.02"
{
	ParentBody     "Kepler-36"
	Mass            4.465192084
	Radius          9439.588616
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03789236398
		SemiMajorAxis   0.1153
		Eccentricity    0.039
		Inclination     90.01
	}
}

Planet	"Kepler-36 c/KOI-277.01"
{
	ParentBody     "Kepler-36"
	Mass            8.08702118
	Radius          23463.6744
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.04445967758
		SemiMajorAxis   0.1283
		Eccentricity    0.033
		Inclination     89.98
	}
}

Planet	"Kepler-360 b/KOI-2111.01"
{
	ParentBody     "Kepler-360"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009006823668
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-360 c/KOI-2111.02"
{
	ParentBody     "Kepler-360"
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01967580471
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-361 b/KOI-2135.03"
{
	ParentBody     "Kepler-361"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02323558514
		SemiMajorAxis   0.086
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-361 c/KOI-2135.01"
{
	ParentBody     "Kepler-361"
	Radius          16085.7
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1510998032
		SemiMajorAxis   0.3
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-362 b/KOI-2147.02"
{
	ParentBody     "Kepler-362"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02827489892
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-362 c/KOI-2147.01"
{
	ParentBody     "Kepler-362"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1036744441
		SemiMajorAxis   0.207
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-363 b/KOI-2148.03"
{
	ParentBody     "Kepler-363"
	Radius          7363.676
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009896359458
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-363 c/KOI-2148.02"
{
	ParentBody     "Kepler-363"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02065048127
		SemiMajorAxis   0.079
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-363 d/KOI-2148.01"
{
	ParentBody     "Kepler-363"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03266907639
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-364 b/KOI-2153.02"
{
	ParentBody     "Kepler-364"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07048944157
		SemiMajorAxis   0.178
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-364 c/KOI-2153.01"
{
	ParentBody     "Kepler-364"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1642215184
		SemiMajorAxis   0.312
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-365 b/KOI-2163.01"
{
	ParentBody     "Kepler-365"
	Radius          13011.544
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02919953745
		SemiMajorAxis   0.098
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-365 c/KOI-2163.02"
{
	ParentBody     "Kepler-365"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04869133275
		SemiMajorAxis   0.137
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-366 b/KOI-2168.01"
{
	ParentBody     "Kepler-366"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008985706173
		SemiMajorAxis   0.045
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-366 c/KOI-2168.02"
{
	ParentBody     "Kepler-366"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03426811126
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-367 b/KOI-2173.01"
{
	ParentBody     "Kepler-367"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1035360236
		SemiMajorAxis   0.201
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-367 c/KOI-2173.02"
{
	ParentBody     "Kepler-367"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1466934502
		SemiMajorAxis   0.253
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-368 b/KOI-2175.01"
{
	ParentBody     "Kepler-368"
	Radius          20804.172
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07350651361
		SemiMajorAxis   0.186
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-368 c/KOI-2175.02"
{
	ParentBody     "Kepler-368"
	Radius          24736.232
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.198168054
		SemiMajorAxis   0.36
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-369 b/KOI-2179.02"
{
	ParentBody     "Kepler-369"
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007482038154
		SemiMajorAxis   0.03
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-369 c/KOI-2179.01"
{
	ParentBody     "Kepler-369"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04071701576
		SemiMajorAxis   0.094
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-37 b/KOI-245.03"
{
	ParentBody     "Kepler-37"
	Mass            2.783236321
	Radius          2040.992133
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.03659847732
		SemiMajorAxis   0.1003
		Eccentricity    0
		Inclination     88.63
	}
}

Planet	"Kepler-37 c/KOI-245.02"
{
	ParentBody     "Kepler-37"
	Mass            10.01164144
	Radius          4783.575312
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.05832263247
		SemiMajorAxis   0.1368
		Eccentricity    0
		Inclination     89.07
	}
}

Planet	"Kepler-37 d/KOI-245.01"
{
	ParentBody     "Kepler-37"
	Mass            12.21420256
	Radius          12373.51481
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1089474001
		SemiMajorAxis   0.2076
		Eccentricity    0
		Inclination     89.335
	}
}

Planet	"Kepler-37 e/KOI-245.04"
{
	ParentBody     "Kepler-37"
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1401700062
	}
}

Planet	"Kepler-370 b/KOI-2183.02"
{
	ParentBody     "Kepler-370"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01253833792
		SemiMajorAxis   0.054
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-370 c/KOI-2183.01"
{
	ParentBody     "Kepler-370"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05208305757
		SemiMajorAxis   0.14
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-371 b/KOI-2194.01"
{
	ParentBody     "Kepler-371"
	Radius          12082.148
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09517870324
		SemiMajorAxis   0.2
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-371 c/KOI-2194.02"
{
	ParentBody     "Kepler-371"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1860902625
		SemiMajorAxis   0.313
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-372 b/KOI-2195.03"
{
	ParentBody     "Kepler-372"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01875383565
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-372 c/KOI-2195.01"
{
	ParentBody     "Kepler-372"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05490538486
		SemiMajorAxis   0.154
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-372 d/KOI-2195.02"
{
	ParentBody     "Kepler-372"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08239072275
		SemiMajorAxis   0.201
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-373 b/KOI-2218.01"
{
	ParentBody     "Kepler-373"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01515517417
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-373 c/KOI-2218.02"
{
	ParentBody     "Kepler-373"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04579412911
		SemiMajorAxis   0.126
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-374 b/KOI-2220.03"
{
	ParentBody     "Kepler-374"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.005196020758
		SemiMajorAxis   0.029
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-374 c/KOI-2220.01"
{
	ParentBody     "Kepler-374"
	Radius          7006.216
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00898802792
		SemiMajorAxis   0.042
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-374 d/KOI-2220.02"
{
	ParentBody     "Kepler-374"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01376680772
		SemiMajorAxis   0.056
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-375 b/KOI-2236.02"
{
	ParentBody     "Kepler-375"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03319970786
		SemiMajorAxis   0.101
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-375 c/KOI-2236.01"
{
	ParentBody     "Kepler-375"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05472074847
		SemiMajorAxis   0.141
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-376 b/KOI-2278.02"
{
	ParentBody     "Kepler-376"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01347105876
		SemiMajorAxis   0.057
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-376 c/KOI-2278.01"
{
	ParentBody     "Kepler-376"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03880254635
		SemiMajorAxis   0.115
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-377 b/KOI-2279.02"
{
	ParentBody     "Kepler-377"
	Radius          8865.008
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03424995619
		SemiMajorAxis   0.109
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-377 c/KOI-2279.01"
{
	ParentBody     "Kepler-377"
	Radius          13154.528
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07396455489
		SemiMajorAxis   0.182
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-378 b/KOI-2287.01"
{
	ParentBody     "Kepler-378"
	Radius          4789.964
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04405942535
		SemiMajorAxis   0.112
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-378 c/KOI-2287.02"
{
	ParentBody     "Kepler-378"
	Radius          4432.504
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07914203179
		SemiMajorAxis   0.166
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-379 b/KOI-2289.02"
{
	ParentBody     "Kepler-379"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05502754216
		SemiMajorAxis   0.152
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-379 c/KOI-2289.01"
{
	ParentBody     "Kepler-379"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1718988078
		SemiMajorAxis   0.326
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-38 b"
{
	ParentBody     "Kepler-38"
	Mass            120.916
	Radius          27881.88
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.2891095359
		SemiMajorAxis   0.4644
		Eccentricity    0.032
		Inclination     89.446
	}
}

Planet	"Kepler-380 b/KOI-2333.01"
{
	ParentBody     "Kepler-380"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0107622315
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-380 c/KOI-2333.02"
{
	ParentBody     "Kepler-380"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02089025915
		SemiMajorAxis   0.078
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-381 b/KOI-2352.02"
{
	ParentBody     "Kepler-381"
	Radius          6291.296
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01541174913
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-381 c/KOI-2352.01"
{
	ParentBody     "Kepler-381"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03666508244
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-382 b/KOI-2374.01"
{
	ParentBody     "Kepler-382"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01440730328
		SemiMajorAxis   0.055
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-382 c/KOI-2374.02"
{
	ParentBody     "Kepler-382"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03330037257
		SemiMajorAxis   0.097
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-383 b/KOI-2413.01"
{
	ParentBody     "Kepler-383"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03533143859
		SemiMajorAxis   0.095
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-383 c/KOI-2413.02"
{
	ParentBody     "Kepler-383"
	Radius          7935.612
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08542482733
		SemiMajorAxis   0.172
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-384 b/KOI-2414.01"
{
	ParentBody     "Kepler-384"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06186868228
		SemiMajorAxis   0.148
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-384 c/KOI-2414.02"
{
	ParentBody     "Kepler-384"
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1241594489
		SemiMajorAxis   0.236
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-385 b/KOI-2433.02"
{
	ParentBody     "Kepler-385"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02749870163
		SemiMajorAxis   0.097
		Eccentricity    0
		Inclination     79.64
	}
}

Planet	"Kepler-385 c/KOI-2433.01"
{
	ParentBody     "Kepler-385"
	Radius          19374.332
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04151536
		SemiMajorAxis   0.127
		Eccentricity    0
		Inclination     80.79
	}
}

Planet	"Kepler-386 b/KOI-2442.02"
{
	ParentBody     "Kepler-386"
	Radius          8865.008
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03370484118
		SemiMajorAxis   0.096
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-386 c/KOI-2442.01"
{
	ParentBody     "Kepler-386"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06897740376
		SemiMajorAxis   0.155
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-387 b/KOI-2443.01"
{
	ParentBody     "Kepler-387"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01859488358
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-387 c/KOI-2443.02"
{
	ParentBody     "Kepler-387"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03241013587
		SemiMajorAxis   0.098
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-388 b/KOI-2466.01"
{
	ParentBody     "Kepler-388"
	Radius          5147.424
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008688248752
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-388 c/KOI-2466.02"
{
	ParentBody     "Kepler-388"
	Radius          5504.884
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03640599134
		SemiMajorAxis   0.093
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-389 b/KOI-2473.01"
{
	ParentBody     "Kepler-389"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008882070829
		SemiMajorAxis   0.041
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-389 c/KOI-2473.03"
{
	ParentBody     "Kepler-389"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03973097962
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-39 b/KOI-423.01"
{
	ParentBody     "Kepler-39"
	Mass            5727.6
	Radius          87220.24
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.05773538925
		SemiMajorAxis   0.155
		Eccentricity    0.121
		Inclination     88.83
		ArgOfPericen    98.9
	}
}

Planet	"Kepler-390 b/KOI-2498.01"
{
	ParentBody     "Kepler-390"
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01844827401
		SemiMajorAxis   0.065
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-390 c/KOI-2498.02"
{
	ParentBody     "Kepler-390"
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03575715611
		SemiMajorAxis   0.101
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-391 b/KOI-2541.01"
{
	ParentBody     "Kepler-391"
	Radius          20375.22
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02030640273
		SemiMajorAxis   0.082
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-391 c/KOI-2541.02"
{
	ParentBody     "Kepler-391"
	Radius          22591.472
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05608726365
		SemiMajorAxis   0.161
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-392 b/KOI-2585.01"
{
	ParentBody     "Kepler-392"
	Radius          6362.788
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01462550918
		SemiMajorAxis   0.059
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-392 c/KOI-2585.02"
{
	ParentBody     "Kepler-392"
	Radius          7006.216
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02853755204
		SemiMajorAxis   0.093
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-393 b/KOI-2595.01"
{
	ParentBody     "Kepler-393"
	Radius          8221.58
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02514062519
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-393 c/KOI-2595.02"
{
	ParentBody     "Kepler-393"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04001074467
		SemiMajorAxis   0.124
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-394 b/KOI-2597.01"
{
	ParentBody     "Kepler-394"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02191699979
		SemiMajorAxis   0.083
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-394 c/KOI-2597.02"
{
	ParentBody     "Kepler-394"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0332127184
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-395 b/KOI-2650.02"
{
	ParentBody     "Kepler-395"
	Radius          6577.264
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01931415974
		SemiMajorAxis   0.061
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-395 c/KOI-2650.01"
{
	ParentBody     "Kepler-395"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09579742695
		SemiMajorAxis   0.177
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-396 b/KOI-2672.02"
{
	ParentBody     "Kepler-396"
	Mass            70.004
	Radius          22162.52
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1177136738
		SemiMajorAxis   0.36709
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-396 c/KOI-2672.01"
{
	ParentBody     "Kepler-396"
	Mass            16.8646
	Radius          33601.24
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.2423186654
		SemiMajorAxis   0.22662
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-397 b/KOI-2681.02"
{
	ParentBody     "Kepler-397"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06092108091
		SemiMajorAxis   0.144
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-397 c/KOI-2681.01"
{
	ParentBody     "Kepler-397"
	Radius          39392.092
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3709826815
		SemiMajorAxis   0.48
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-398 b/KOI-2693.01"
{
	ParentBody     "Kepler-398"
	Radius          5933.836
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01117456612
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-398 c/KOI-2693.02"
{
	ParentBody     "Kepler-398"
	Radius          6434.28
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03126531468
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-398 d/KOI-2693.03"
{
	ParentBody     "Kepler-398"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01871188543
		SemiMajorAxis   0.0626
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-399 b/KOI-2707.02"
{
	ParentBody     "Kepler-399"
	Radius          6148.312
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03949511147
		SemiMajorAxis   0.103
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-399 c/KOI-2707.03"
{
	ParentBody     "Kepler-399"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07303562059
		SemiMajorAxis   0.155
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-399 d/KOI-2707.01"
{
	ParentBody     "Kepler-399"
	Radius          12082.148
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1588935167
		SemiMajorAxis   0.261
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-4 b/KOI-7.01"
{
	ParentBody     "Kepler-4"
	Mass            26.23050058
	Radius          25512.40166
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.008798162122
		SemiMajorAxis   0.0456
		Eccentricity    0
		Inclination     89.76
	}
}

Planet	"Kepler-40 b/KOI-428.01"
{
	ParentBody     "Kepler-40"
	Mass            700.04
	Radius          83645.64
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01881899241
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     89.7
	}
}

Planet	"Kepler-400 b/KOI-2711.01"
{
	ParentBody     "Kepler-400"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02470795886
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-400 c/KOI-2711.02"
{
	ParentBody     "Kepler-400"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04747760385
		SemiMajorAxis   0.134
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-401 b/KOI-2714.01"
{
	ParentBody     "Kepler-401"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03937944575
		SemiMajorAxis   0.122
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-401 c/KOI-2714.02"
{
	ParentBody     "Kepler-401"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1295529906
		SemiMajorAxis   0.269
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-401 d/KOI-2714.03"
{
	ParentBody     "Kepler-401"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5044773307
		SemiMajorAxis   0.645
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-402 b/KOI-2722.03"
{
	ParentBody     "Kepler-402"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01103035496
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-402 c/KOI-2722.01"
{
	ParentBody     "Kepler-402"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01676920457
		SemiMajorAxis   0.068
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-402 d/KOI-2722.04"
{
	ParentBody     "Kepler-402"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.0244251602
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-402 e/KOI-2722.02"
{
	ParentBody     "Kepler-402"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03078193405
		SemiMajorAxis   0.102
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-403 b/KOI-2732.01"
{
	ParentBody     "Kepler-403"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01925150543
		SemiMajorAxis   0.076
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-403 c/KOI-2732.03"
{
	ParentBody     "Kepler-403"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1486157692
		SemiMajorAxis   0.297
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-403 d/KOI-2732.02"
{
	ParentBody     "Kepler-403"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03726730282
		SemiMajorAxis   0.1153
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-404 b/KOI-2768.01"
{
	ParentBody     "Kepler-404"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03238905945
		SemiMajorAxis   0.102
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-404 c/KOI-2768.02"
{
	ParentBody     "Kepler-404"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04038735505
		SemiMajorAxis   0.118
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-405 b/KOI-3057.02"
{
	ParentBody     "Kepler-405"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02905972885
		SemiMajorAxis   0.095
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-405 c/KOI-3057.01"
{
	ParentBody     "Kepler-405"
	Radius          29740.672
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.08138896005
		SemiMajorAxis   0.188
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-406 b/KOI-321.01"
{
	ParentBody     "Kepler-406"
	Msini           6.364
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006642962033
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-406 c/KOI-321.02"
{
	ParentBody     "Kepler-406"
	Msini           2.714246
	Radius          5433.392
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01265823097
		SemiMajorAxis   0.0554
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-407 b/KOI-1442.01"
{
	ParentBody     "Kepler-407"
	Mass            0.06364
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.001832510095
		SemiMajorAxis   0.0152
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-407 c"
{
	ParentBody     "Kepler-407"
	Mass            4009.32
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          8.213727996
	}
}

Planet	"Kepler-408 b/KOI-1612.01"
{
	ParentBody     "Kepler-408"
	Msini           6.364
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.007022792195
		SemiMajorAxis   0.0366
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-409 b/KOI-1925.01"
{
	ParentBody     "Kepler-409"
	Msini           22.01944
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1888018469
		SemiMajorAxis   0.3198
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-41 b/KOI-196.01"
{
	ParentBody     "Kepler-41"
	Mass            155.918
	Radius          60124.772
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.005080349564
		SemiMajorAxis   0.029
		Eccentricity    0
		Inclination     88.3
	}
}

Planet	"Kepler-410 A b/KOI-42.01"
{
	ParentBody     "Kepler-410 A"
	Radius          18101.04898
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04882691128
		SemiMajorAxis   0.1236
		Eccentricity    0.17
		Inclination     87.72
		ArgOfPericen    270
	}
}

Planet	"Kepler-411 b/KOI-1781.02"
{
	ParentBody     "Kepler-411"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.008227855608
		SemiMajorAxis   0.038
		Eccentricity    0
		Inclination     88.27
		ArgOfPericen    0
	}
}

Planet	"Kepler-411 c/KOI-1781.01"
{
	ParentBody     "Kepler-411"
	Radius          20875.664
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0214499532
		SemiMajorAxis   0.0726
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-412 b/KOI-202.01"
{
	ParentBody     "Kepler-412"
	Mass            299.4262
	Radius          95870.772
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004711559748
		SemiMajorAxis   0.02897
		Eccentricity    0.0038
		Inclination     80.559
		ArgOfPericen    125
	}
}

Planet	"Kepler-413 b"
{
	ParentBody     "Kepler-413"
	Mass            67.07799767
	Radius          27725.60251
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1814193482
		SemiMajorAxis   0.3553
		Eccentricity    0.1181
		Inclination     89.929
		ArgOfPericen    94.6
	}
}

Planet	"Kepler-414 b/KOI-341.02"
{
	ParentBody     "Kepler-414"
	Mass            3.5002
	Radius          10938.276
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01286817386
		SemiMajorAxis   0.0529
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-414 c/KOI-341.01"
{
	ParentBody     "Kepler-414"
	Mass            29.9108
	Radius          19231.348
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01963354782
		SemiMajorAxis   0.0701
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-415 b/KOI-1194.03"
{
	ParentBody     "Kepler-415"
	Mass            119.9614
	Radius          7721.136
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01143350937
		SemiMajorAxis   0.0446
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-415 c/KOI-1194.01"
{
	ParentBody     "Kepler-415"
	Radius          16692.02
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02384171446
		SemiMajorAxis   0.0727
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-416 b/KOI-1860.01"
{
	ParentBody     "Kepler-416"
	Mass            58.2306
	Radius          15799.732
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01730084907
		SemiMajorAxis   0.0669
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-416 c/KOI-1860.02"
{
	ParentBody     "Kepler-416"
	Radius          16182.34
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03342713503
		SemiMajorAxis   0.1038
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-417 b/KOI-2113.02"
{
	ParentBody     "Kepler-417"
	Mass            11.137
	Radius          14727.352
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03376115997
		SemiMajorAxis   0.1006
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-417 c/KOI-2113.01"
{
	ParentBody     "Kepler-417"
	Radius          17201.7
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04365048848
		SemiMajorAxis   0.1194
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-418 b/KOI-1089.01"
{
	ParentBody     "Kepler-418"
	Mass            350.02
	Radius          85790.4
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2373182847
		SemiMajorAxis   0.389
		Eccentricity    0.2
		Inclination     89.952
		ArgOfPericen    4.35
	}
}

Planet	"Kepler-418 c/KOI-1089.02"
{
	ParentBody     "Kepler-418"
	Mass            203.648
	Radius          44682.5
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03345248807
		SemiMajorAxis   0.1054
		Eccentricity    0.5
		Inclination     87.6
		ArgOfPericen    3.48
	}
}

Planet	"Kepler-419 b/KOI-1474.01"
{
	ParentBody     "Kepler-419"
	Mass            795.5
	Radius          60768.2
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1909817703
		SemiMajorAxis   0.37
		Eccentricity    0.833
		Inclination     88.95
		ArgOfPericen    95.2
	}
}

Planet	"Kepler-419 c"
{
	ParentBody     "Kepler-419"
	Mass            2322.86
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          1.849375616
		SemiMajorAxis   1.68
		Eccentricity    0.184
		Inclination     88
		ArgOfPericen    275.3
	}
}

Planet	"Kepler-42 b/KOI-961.01"
{
	ParentBody     "Kepler-42"
	Mass            2.8638
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.003323184544
		SemiMajorAxis   0.0116
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-42 c/KOI-961.02"
{
	ParentBody     "Kepler-42"
	Mass            1.9092
	Radius          4646.98
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.001241053478
		SemiMajorAxis   0.006
		Eccentricity    0
		Inclination     78.5
	}
}

Planet	"Kepler-42 d/KOI-961.03"
{
	ParentBody     "Kepler-42"
	Mass            0.9546
	Radius          3646.092
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.005082022427
		SemiMajorAxis   0.0154
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-420 A b/KOI-1257.01"
{
	ParentBody     "Kepler-420 A"
	Mass            461.39
	Radius          67202.48
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2372334396
		SemiMajorAxis   0.382
		Eccentricity    0.772
		Inclination     89.66
		ArgOfPericen    141.3
	}
}

Planet	"Kepler-421 b/KOI-1274.01"
{
	ParentBody     "Kepler-421"
	Radius          26523.532
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          1.928031371
		SemiMajorAxis   1.219
		Eccentricity    0.041
		Inclination     89.965
		ArgOfPericen    160
	}
}

Planet	"Kepler-422 b/KOI-22.01"
{
	ParentBody     "Kepler-422"
	Mass            136.826
	Radius          82215.8
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02160606994
		SemiMajorAxis   0.082
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-423 b/KOI-183.01"
{
	ParentBody     "Kepler-423"
	Mass            189.329
	Radius          85218.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00734944805
		SemiMajorAxis   0.03585
		Eccentricity    0.019
		Inclination     87.828
		ArgOfPericen    120.26
	}
}

Planet	"Kepler-424 b/KOI-214.01"
{
	ParentBody     "Kepler-424"
	Mass            327.746
	Radius          63627.88
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009067584447
		SemiMajorAxis   0.044
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-424 c"
{
	ParentBody     "Kepler-424"
	Msini           2217.854
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455403.4
		Period          0.6113751538
		SemiMajorAxis   0.73
	}
}

Planet	"Kepler-425 b/KOI-188.01/KOI-188 b"
{
	ParentBody     "Kepler-425"
	Msini           79.55
	Radius          69919.176
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01039589145
		SemiMajorAxis   0.0464
		Eccentricity    0.33
		Inclination     87.02
	}
}

Planet	"Kepler-426 b/KOI-195.01"
{
	ParentBody     "Kepler-426"
	Mass            108.188
	Radius          77926.28
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.00880927483
		SemiMajorAxis   0.0414
		Eccentricity    0.18
		Inclination     85.74
	}
}

Planet	"Kepler-427 b/KOI-192.01/KOI-192 b"
{
	ParentBody     "Kepler-427"
	Msini           92.278
	Radius          87935.16
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02817580851
		SemiMajorAxis   0.091
		Eccentricity    0.57
		Inclination     89.5
	}
}

Planet	"Kepler-428 b/KOI-830.01"
{
	ParentBody     "Kepler-428"
	Mass            404.114
	Radius          77211.36
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009652862232
		SemiMajorAxis   0.0433
		Eccentricity    0.22
		Inclination     89.36
	}
}

Planet	"Kepler-43 b/KOI-135.01"
{
	ParentBody     "Kepler-43"
	Mass            1027.786
	Radius          85790.4
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008279697921
		SemiMajorAxis   0.0449
		Eccentricity    0.025
		Inclination     84.35
		ArgOfPericen    52
	}
}

Planet	"Kepler-430 b/KOI-2365.01"
{
	ParentBody     "Kepler-430"
	Radius          20732.68
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.09847712285
		SemiMajorAxis   0.2244
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-430 c/KOI-2365.02"
{
	ParentBody     "Kepler-430"
	Radius          20732.68
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.3038504397
		SemiMajorAxis   0.4757
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-431 b/KOI-3097.02"
{
	ParentBody     "Kepler-431"
	Radius          4875.7544
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01862599719
		SemiMajorAxis   0.0719
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-431 c/KOI-3097.03"
{
	ParentBody     "Kepler-431"
	Radius          4260.9232
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02382802492
		SemiMajorAxis   0.0847
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-431 d/KOI-3097.01"
{
	ParentBody     "Kepler-431"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.03264135506
		SemiMajorAxis   0.1045
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-432 b/KOI-1299.01"
{
	ParentBody     "Kepler-432"
	Mass            1721.462
	Radius          81858.34
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.143743331
		SemiMajorAxis   0.301
		Eccentricity    0.5134
		Inclination     88.17
		ArgOfPericen    64.1
	}
}

Planet	"Kepler-432 c"
{
	ParentBody     "Kepler-432"
	Msini           773.226
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2456134.9
		Period          1.112138771
		SemiMajorAxis   1.188
		Eccentricity    0.498
		ArgOfPericen    60.8
	}
}

Planet	"Kepler-433 b/KOI-206.01"
{
	ParentBody     "Kepler-433"
	Mass            897.324
	Radius          103663.4
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01460423792
		SemiMajorAxis   0.0679
		Eccentricity    0.119
		Inclination     89.21
		ArgOfPericen    68
	}
}

Planet	"Kepler-434 b/KOI-614.01"
{
	ParentBody     "Kepler-434"
	Mass            910.052
	Radius          80785.96
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.03524978838
		SemiMajorAxis   0.1143
		Eccentricity    0.131
		Inclination     86.46
		ArgOfPericen    82
	}
}

Planet	"Kepler-435 b/KOI-680.01"
{
	ParentBody     "Kepler-435"
	Mass            267.288
	Radius          142269.08
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.0235464408
		SemiMajorAxis   0.0948
		Eccentricity    0.114
		Inclination     85.51
		ArgOfPericen    104
	}
}

Planet	"Kepler-436 b/KOI-2529.02"
{
	ParentBody     "Kepler-436"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.17523181
		SemiMajorAxis   0.339
		Eccentricity    0.19
		Inclination     89.93
	}
}

Planet	"Kepler-436 c/KOI-2529.01"
{
	ParentBody     "Kepler-436"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04598904291
		SemiMajorAxis   0.1026
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-437 b/KOI-3255.01"
{
	ParentBody     "Kepler-437"
	Radius          13654.972
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.1824833545
		SemiMajorAxis   0.288
		Eccentricity    0.02
		Inclination     89.9
	}
}

Planet	"Kepler-438 b/KOI-3284.01"
{
	ParentBody     "Kepler-438"
	Radius          7142.0508
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.09646527969
		SemiMajorAxis   0.166
		Eccentricity    0.03
		Inclination     89.86
	}
}

Planet	"Kepler-439 b/KOI-4005.01"
{
	ParentBody     "Kepler-439"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.4877300732
		SemiMajorAxis   0.563
		Eccentricity    0.03
		Inclination     89.95
	}
}

Planet	"Kepler-44 b/KOI-204.01"
{
	ParentBody     "Kepler-44"
	Mass            324.564
	Radius          88650.08
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008889279744
		SemiMajorAxis   0.0455
		Eccentricity    0.021
		Inclination     83.78
	}
}

Planet	"Kepler-440 b/KOI-4087.01"
{
	ParentBody     "Kepler-440"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.276833873
		SemiMajorAxis   0.242
		Eccentricity    0.34
		Inclination     89.93
	}
}

Planet	"Kepler-441 b/KOI-4622.01"
{
	ParentBody     "Kepler-441"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.5674267808
		SemiMajorAxis   0.64
		Eccentricity    0.1
		Inclination     89.97
	}
}

Planet	"Kepler-442 b/KOI-4742.01"
{
	ParentBody     "Kepler-442"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.3074817289
		SemiMajorAxis   0.409
		Eccentricity    0.04
		Inclination     89.94
	}
}

Planet	"Kepler-443 b/KOI-4745.01"
{
	ParentBody     "Kepler-443"
	Radius          14870.336
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.4864424345
		SemiMajorAxis   0.495
		Eccentricity    0.11
		Inclination     89.94
	}
}

Planet	"Kepler-445 b/KOI-2704.02"
{
	ParentBody     "Kepler-445"
	Mass            5.0912
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.008170334871
		SemiMajorAxis   0.0224
		Eccentricity    0
		Inclination     89.74
	}
}

Planet	"Kepler-445 c/KOI-2704.01"
{
	ParentBody     "Kepler-445"
	Mass            8.5914
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01333698334
		SemiMajorAxis   0.0311
		Eccentricity    0
		Inclination     89.91
	}
}

Planet	"Kepler-445 d"
{
	ParentBody     "Kepler-445"
	Mass            3.5002
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02232149031
		Eccentricity    0
		Inclination     89.61
	}
}

Planet	"Kepler-446 b/KOI-2842.01"
{
	ParentBody     "Kepler-446"
	Mass            4.4548
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.004285947909
		SemiMajorAxis   0.0206
		Eccentricity    0
		Inclination     87.42
	}
}

Planet	"Kepler-446 c/KOI-2842.03"
{
	ParentBody     "Kepler-446"
	Mass            2.8638
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.008312782817
		SemiMajorAxis   0.032
		Eccentricity    0
		Inclination     88.97
	}
}

Planet	"Kepler-446 d/KOI-2842.02"
{
	ParentBody     "Kepler-446"
	Mass            4.1366
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01409727886
		SemiMajorAxis   0.0455
		Eccentricity    0
		Inclination     88.72
	}
}

Planet	"Kepler-447 b/KOI-1800.01"
{
	ParentBody     "Kepler-447"
	Mass            435.934
	Radius          117961.8
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02134009032
		SemiMajorAxis   0.0769
		Eccentricity    0.123
		Inclination     86.55
		ArgOfPericen    98.3
	}
}

Planet	"Kepler-448 b/KOI-12.01/KOI-12 b"
{
	ParentBody     "Kepler-448"
	Mass            3182
	Radius          102233.56
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.04888600988
		SemiMajorAxis   0.151
		Eccentricity    0
		Inclination     88.95
		ArgOfPericen    228
	}
}

Planet	"Kepler-449 b/KOI-270.01"
{
	ParentBody     "Kepler-449"
	Radius          13111.6328
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.03444952514
		SemiMajorAxis   0.1047
		Eccentricity    0.03
		Inclination     88.81
	}
}

Planet	"Kepler-449 c/KOI-270.02"
{
	ParentBody     "Kepler-449"
	Radius          17629.9272
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.09219279956
		SemiMajorAxis   0.2018
		Eccentricity    0.05
		Inclination     89.95
	}
}

Planet	"Kepler-45 b/KOI-254.01"
{
	ParentBody     "Kepler-45"
	Mass            160.691
	Radius          68632.32
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.00672222177
		SemiMajorAxis   0.027
		Eccentricity    0.11
		Inclination     87
		ArgOfPericen    230
	}
}

Planet	"Kepler-450 b/KOI-279.01"
{
	ParentBody     "Kepler-450"
	Radius          39177.616
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.07790680209
		SemiMajorAxis   0.2004
		Eccentricity    0.02
		Inclination     89.95
	}
}

Planet	"Kepler-450 c/KOI-279.02"
{
	ParentBody     "Kepler-450"
	Radius          16729.128
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.04219976615
		SemiMajorAxis   0.1332
		Eccentricity    0.02
		Inclination     88.81
	}
}

Planet	"Kepler-450 d/KOI-279.03"
{
	ParentBody     "Kepler-450"
	Radius          5340.4524
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02057440298
		SemiMajorAxis   0.0825
		Eccentricity    0.14
		Inclination     88.81
	}
}

Planet	"Kepler-452 b"
{
	ParentBody     "Kepler-452"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          1.053665241
		SemiMajorAxis   1.046
		Eccentricity    0.035
		Inclination     89.806
	}
}

Planet	"Kepler-453 b/KIC 9632895 b"
{
	ParentBody     "Kepler-453"
	Mass            9.546
	Radius          39320.6
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2454964
		Period          0.6584754081
		SemiMajorAxis   0.7903
		Eccentricity    0.0359
		Inclination     89.4338
		AscendingNode  -178.59
		ArgOfPericen    185.1
	}
}

Planet	"Kepler-454 b/KOI-273.01"
{
	ParentBody     "Kepler-454"
	Msini           6.8413
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02894997808
		SemiMajorAxis   0.0954
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-454 c"
{
	ParentBody     "Kepler-454"
	Msini           1419.172
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2454892
		Period          1.434390699
		SemiMajorAxis   1.286
		Eccentricity    0.0214
		ArgOfPericen    337.4
	}
}

Planet	"Kepler-455 b/KIC 3558849 b"
{
	ParentBody     "Kepler-455"
	Radius          44325.04
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          3.62033751
		Inclination     89.973
	}
}

Planet	"Kepler-456 b/KIC 5951458 b"
{
	ParentBody     "Kepler-456"
	Radius          42108.788
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          3.614314109
		Inclination     89.799
	}
}

Planet	"Kepler-457 b/KIC 8540376 b"
{
	ParentBody     "Kepler-457"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.08709262206
		SemiMajorAxis   0.161
		Inclination     89.3
	}
}

Planet	"Kepler-458 c/KOI-179.01/KIC 9663113 c"
{
	ParentBody     "Kepler-458"
	Radius          26809.5
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05678501747
		SemiMajorAxis   0.146
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-46 b/KOI-872.01"
{
	ParentBody     "Kepler-46"
	Mass            1909.2
	Radius          58051.504
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.09199742235
		SemiMajorAxis   0.1967
		Eccentricity    0.01
		Inclination     89.033
	}
}

Planet	"Kepler-46 c"
{
	ParentBody     "Kepler-46"
	Mass            119.6432
	DiscMethod     "TTV"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1560717836
		SemiMajorAxis   0.2799
		Eccentricity    0.0145
		Inclination     87.25
		ArgOfPericen    329.4
	}
}

Planet	"Kepler-46 d/KOI-872.02"
{
	ParentBody     "Kepler-46"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01852630717
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-460 c/KOI-3791.02/KIC 5437945 c"
{
	ParentBody     "Kepler-460"
	Radius          35174.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.6026969004
		SemiMajorAxis   0.721
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-461 b/KOI-49.01"
{
	ParentBody     "Kepler-461"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02276238422
		SemiMajorAxis   0.0821
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-462 b/KOI-89.01/KOI-89 b"
{
	ParentBody     "Kepler-462"
	Radius          24021.312
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2318680129
		SemiMajorAxis   0.4731
		Eccentricity    0.056
		Inclination     89.34
	}
}

Planet	"Kepler-463 b/KOI-105.01"
{
	ParentBody     "Kepler-463"
	Radius          19445.824
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02458920979
		SemiMajorAxis   0.0797
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-464 b/KOI-107.01"
{
	ParentBody     "Kepler-464"
	Radius          21018.648
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0198689128
		SemiMajorAxis   0.0778
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-465 b/KOI-110.01"
{
	ParentBody     "Kepler-465"
	Radius          18802.396
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02721665992
		SemiMajorAxis   0.0945
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-466 b/KOI-112.01"
{
	ParentBody     "Kepler-466"
	Radius          18158.968
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.139850391
		SemiMajorAxis   0.2643
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-466 c/KOI-112.02"
{
	ParentBody     "Kepler-466"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01015549121
		SemiMajorAxis   0.046
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-467 b/KOI-118.01"
{
	ParentBody     "Kepler-467"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06842923031
		SemiMajorAxis   0.1686
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-468 b"
{
	ParentBody     "Kepler-468"
	Radius          85075.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1053513481
	}
}

Planet	"Kepler-469 b"
{
	ParentBody     "Kepler-469"
	Radius          114172.724
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09255140074
	}
}

Planet	"Kepler-47 b"
{
	ParentBody     "Kepler-47"
	Mass            636.4
	Radius          19302.84
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1355648427
		SemiMajorAxis   0.2956
		Eccentricity    0.035
		Inclination     89.59
	}
}

Planet	"Kepler-47 c"
{
	ParentBody     "Kepler-47"
	Mass            8909.6
	Radius          29311.72
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.8299917382
		SemiMajorAxis   0.989
		Eccentricity    0.411
		Inclination     89.826
	}
}

Planet	"Kepler-470 b/KOI-129.01"
{
	ParentBody     "Kepler-470"
	Radius          92081.696
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06754202109
		SemiMajorAxis   0.1804
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-471 b/KOI-131.01"
{
	ParentBody     "Kepler-471"
	Radius          95441.82
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01372851962
		SemiMajorAxis   0.0629
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-472 b/KOI-144.01"
{
	ParentBody     "Kepler-472"
	Radius          20518.204
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01143420893
		SemiMajorAxis   0.0479
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-473 b/KOI-149.01"
{
	ParentBody     "Kepler-473"
	Radius          26023.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0398566142
		SemiMajorAxis   0.1176
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-474 b/KOI-155.01"
{
	ParentBody     "Kepler-474"
	Radius          19517.316
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01549840927
		SemiMajorAxis   0.0603
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-475 b/KOI-161.01"
{
	ParentBody     "Kepler-475"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008502599854
		SemiMajorAxis   0.0387
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-476 b/KOI-162.01"
{
	ParentBody     "Kepler-476"
	Radius          19660.3
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03834826989
		SemiMajorAxis   0.1151
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-477 b"
{
	ParentBody     "Kepler-477"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03044529586
	}
}

Planet	"Kepler-478 b/KOI-165.01"
{
	ParentBody     "Kepler-478"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03619997352
		SemiMajorAxis   0.1005
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-479 b/KOI-166.01"
{
	ParentBody     "Kepler-479"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03420583223
		SemiMajorAxis   0.0965
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-48 b/KOI-148.01"
{
	ParentBody     "Kepler-48"
	Mass            3.94568
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01308173079
		SemiMajorAxis   0.0547
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-48 c/KOI-148.02"
{
	ParentBody     "Kepler-48"
	Mass            14.627654
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02648633775
		SemiMajorAxis   0.0876
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-48 d/KOI-148.03"
{
	ParentBody     "Kepler-48"
	Mass            7.955
	Radius          13011.544
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1174456325
		SemiMajorAxis   0.2365
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-48 e"
{
	ParentBody     "Kepler-48"
	Msini           657.7194
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          2.688626964
	}
}

Planet	"Kepler-480 b/KOI-167.01"
{
	ParentBody     "Kepler-480"
	Radius          17730.016
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0134693744
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-481 b/KOI-173.01"
{
	ParentBody     "Kepler-481"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02754562849
		SemiMajorAxis   0.0891
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-482 b/KOI-174.01"
{
	ParentBody     "Kepler-482"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1542926511
		SemiMajorAxis   0.2498
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-483 b/KOI-176.01"
{
	ParentBody     "Kepler-483"
	Radius          20446.712
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08276454594
		SemiMajorAxis   0.1967
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-484 b/KOI-180.01"
{
	ParentBody     "Kepler-484"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02750385796
		SemiMajorAxis   0.0913
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-485 b/KOI-186.01"
{
	ParentBody     "Kepler-485"
	Radius          91938.712
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008879751272
		SemiMajorAxis   0.0443
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-486 b/KOI-189.01"
{
	ParentBody     "Kepler-486"
	Radius          70133.652
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08312415026
		SemiMajorAxis   0.1725
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-487 b/KOI-191.01"
{
	ParentBody     "Kepler-487"
	Radius          72850.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04205091533
		SemiMajorAxis   0.117
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-487 c/KOI-191.04"
{
	ParentBody     "Kepler-487"
	Radius          17086.588
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1058256649
		SemiMajorAxis   0.2164
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-488 b"
{
	ParentBody     "Kepler-488"
	Radius          100732.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008544547472
	}
}

Planet	"Kepler-489 b/KOI-197.01"
{
	ParentBody     "Kepler-489"
	Radius          49257.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04730093237
		SemiMajorAxis   0.1202
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-49 b/KOI-248.01"
{
	ParentBody     "Kepler-49"
	Mass            311.836
	Radius          17372.556
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01972333619
		SemiMajorAxis   0.0595
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-49 c/KOI-248.02"
{
	ParentBody     "Kepler-49"
	Mass            229.104
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02987862466
		SemiMajorAxis   0.0784
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-49 d/KOI-248.03"
{
	ParentBody     "Kepler-49"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007054357551
		SemiMajorAxis   0.031
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-49 e/KOI-248.04"
{
	ParentBody     "Kepler-49"
	Radius          9937.388
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05091445763
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-490 b/KOI-199.01"
{
	ParentBody     "Kepler-490"
	Radius          74280.188
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008949390954
		SemiMajorAxis   0.0464
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-491 b/KOI-201.01"
{
	ParentBody     "Kepler-491"
	Radius          56907.632
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01156871968
		SemiMajorAxis   0.0524
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-492 b/KOI-205.01"
{
	ParentBody     "Kepler-492"
	Radius          61197.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0320886332
		SemiMajorAxis   0.0935
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-493 b/KOI-208.01"
{
	ParentBody     "Kepler-493"
	Radius          96514.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00822434172
		SemiMajorAxis   0.0439
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-494 b/KOI-219.01"
{
	ParentBody     "Kepler-494"
	Radius          45540.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02197204604
		SemiMajorAxis   0.072
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-495 b/KOI-221.01"
{
	ParentBody     "Kepler-495"
	Radius          33386.764
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009344583717
		SemiMajorAxis   0.0406
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-496 b/KOI-226.01"
{
	ParentBody     "Kepler-496"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02274832865
		SemiMajorAxis   0.0732
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-497 b"
{
	ParentBody     "Kepler-497"
	Radius          38534.188
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009783107673
	}
}

Planet	"Kepler-498 b/KOI-234.01"
{
	ParentBody     "Kepler-498"
	Radius          19302.84
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02632158559
		SemiMajorAxis   0.0897
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-499 b/KOI-235.01"
{
	ParentBody     "Kepler-499"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01542135221
		SemiMajorAxis   0.0598
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-5 b/KOI-18.01"
{
	ParentBody     "Kepler-5"
	Mass            671.7202
	Radius          101947.592
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.009715377354
		SemiMajorAxis   0.0538
		Eccentricity    0
		Inclination     89.14
	}
}

Planet	"Kepler-50 b/KOI-262.01"
{
	ParentBody     "Kepler-50"
	Mass            31.82
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02138995061
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-50 c/KOI-262.02"
{
	ParentBody     "Kepler-50"
	Mass            35.002
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02567101244
		SemiMajorAxis   0.087
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-500 b/KOI-237.01"
{
	ParentBody     "Kepler-500"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02329502077
		SemiMajorAxis   0.0846
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-501 b/KOI-239.01"
{
	ParentBody     "Kepler-501"
	Radius          27452.928
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01544366376
		SemiMajorAxis   0.0632
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-502 b/KOI-240.01"
{
	ParentBody     "Kepler-502"
	Radius          30455.592
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0117370458
		SemiMajorAxis   0.0532
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-503 b/KOI-242.01"
{
	ParentBody     "Kepler-503"
	Radius          39964.028
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01987297035
		SemiMajorAxis   0.0736
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-504 b/KOI-249.01"
{
	ParentBody     "Kepler-504"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02614505029
		SemiMajorAxis   0.0641
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-505 b/KOI-255.01"
{
	ParentBody     "Kepler-505"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07535268571
		SemiMajorAxis   0.1444
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-506 b/KOI-257.01"
{
	ParentBody     "Kepler-506"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01884614015
		SemiMajorAxis   0.0749
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-507 b/KOI-265.01"
{
	ParentBody     "Kepler-507"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009769125882
		SemiMajorAxis   0.0475
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-508 b/KOI-266.01"
{
	ParentBody     "Kepler-508"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06929346659
		SemiMajorAxis   0.1827
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-509 b/KOI-276.01"
{
	ParentBody     "Kepler-509"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1142967737
		SemiMajorAxis   0.2412
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-51 b/KOI-620.01"
{
	ParentBody     "Kepler-51"
	Mass            2.102444703
	Radius          45284.51295
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1236316711
		SemiMajorAxis   0.2514
		Eccentricity    0.04
		Inclination     89.95
	}
}

Planet	"Kepler-51 c/KOI-620.03"
{
	ParentBody     "Kepler-51"
	Mass            4.004656577
	Radius          57402.90374
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.2335788925
		SemiMajorAxis   0.384
		Eccentricity    0.014
		Inclination     89.38
	}
}

Planet	"Kepler-51 d/KOI-620.02"
{
	ParentBody     "Kepler-51"
	Mass            7.608847497
	Radius          61867.57403
	DiscMethod     "TTV"
	DiscDate       "2014"
	Orbit
	{
		Period          0.3564593676
		SemiMajorAxis   0.509
		Eccentricity    0.008
		Inclination     89.95
	}
}

Planet	"Kepler-510 b/KOI-281.01"
{
	ParentBody     "Kepler-510"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05354418171
		SemiMajorAxis   0.1371
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-511 b/KOI-289.02"
{
	ParentBody     "Kepler-511"
	Radius          40535.964
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.8121675788
		SemiMajorAxis   0.9045
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-512 b/KOI-294.01"
{
	ParentBody     "Kepler-512"
	Radius          17158.08
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09428231652
		SemiMajorAxis   0.2038
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-513 b/KOI-296.01"
{
	ParentBody     "Kepler-513"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0790225134
		SemiMajorAxis   0.1836
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-514 b/KOI-297.01"
{
	ParentBody     "Kepler-514"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01547410515
		SemiMajorAxis   0.0642
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-515 b/KOI-298.01"
{
	ParentBody     "Kepler-515"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05465883662
		SemiMajorAxis   0.1443
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-516 b"
{
	ParentBody     "Kepler-516"
	Radius          36603.904
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0680497074
	}
}

Planet	"Kepler-517 b/KOI-303.01"
{
	ParentBody     "Kepler-517"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1668162233
		SemiMajorAxis   0.288
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-518 b/KOI-304.01"
{
	ParentBody     "Kepler-518"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02330518247
		SemiMajorAxis   0.0861
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-519 b/KOI-306.01"
{
	ParentBody     "Kepler-519"
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06655281146
		SemiMajorAxis   0.1599
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-52 b/KOI-775.02"
{
	ParentBody     "Kepler-52"
	Mass            2768.34
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02156748787
		SemiMajorAxis   0.0639
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-52 c/KOI-775.01"
{
	ParentBody     "Kepler-52"
	Mass            3312.462
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.04486065015
		SemiMajorAxis   0.1041
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-52 d/KOI-775.03"
{
	ParentBody     "Kepler-52"
	Radius          12439.608
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.09978357378
		SemiMajorAxis   0.182
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-520 b/KOI-307.01"
{
	ParentBody     "Kepler-520"
	Radius          10580.816
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05386606966
		SemiMajorAxis   0.1487
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-520 c/KOI-307.02"
{
	ParentBody     "Kepler-520"
	Radius          6791.74
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01426736219
		SemiMajorAxis   0.0613
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-521 b/KOI-317.01"
{
	ParentBody     "Kepler-521"
	Radius          20303.728
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06080385223
		SemiMajorAxis   0.1655
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-522 b/KOI-318.01"
{
	ParentBody     "Kepler-522"
	Radius          44039.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1056401192
		SemiMajorAxis   0.2425
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-523 b/KOI-323.01"
{
	ParentBody     "Kepler-523"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01597839262
		SemiMajorAxis   0.0621
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-524 b/KOI-330.01"
{
	ParentBody     "Kepler-524"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02183263131
		SemiMajorAxis   0.079
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-524 c/KOI-330.02"
{
	ParentBody     "Kepler-524"
	Radius          6148.312
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005171853396
		SemiMajorAxis   0.0302
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-525 b/KOI-331.01"
{
	ParentBody     "Kepler-525"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05115523302
		SemiMajorAxis   0.1387
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-526 b/KOI-332.01"
{
	ParentBody     "Kepler-526"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01494487349
		SemiMajorAxis   0.0632
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-527 b/KOI-333.01"
{
	ParentBody     "Kepler-527"
	Radius          18087.476
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03637410107
		SemiMajorAxis   0.1142
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-528 b/KOI-337.01"
{
	ParentBody     "Kepler-528"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05416398954
		SemiMajorAxis   0.1441
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-529 b/KOI-339.01"
{
	ParentBody     "Kepler-529"
	Radius          11867.672
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005422039718
		SemiMajorAxis   0.0306
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-529 c/KOI-339.02"
{
	ParentBody     "Kepler-529"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03513970334
		SemiMajorAxis   0.1065
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-53 b/KOI-829.01"
{
	ParentBody     "Kepler-53"
	Mass            5858.062
	Radius          18587.92
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.05105914108
		SemiMajorAxis   0.1385
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-53 c/KOI-829.03"
{
	ParentBody     "Kepler-53"
	Mass            5011.65
	Radius          20017.76
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1055691398
		SemiMajorAxis   0.2248
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-53 d/KOI-829.02"
{
	ParentBody     "Kepler-53"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02669998776
		SemiMajorAxis   0.091
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-530 b/KOI-344.01"
{
	ParentBody     "Kepler-530"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1076256252
		SemiMajorAxis   0.2186
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-531 b/KOI-345.01"
{
	ParentBody     "Kepler-531"
	Radius          17730.016
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08182202999
		SemiMajorAxis   0.1694
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-532 b/KOI-346.01"
{
	ParentBody     "Kepler-532"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03538724876
		SemiMajorAxis   0.0986
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-533 b/KOI-348.01"
{
	ParentBody     "Kepler-533"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07806109492
		SemiMajorAxis   0.1801
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-534 b/KOI-354.01"
{
	ParentBody     "Kepler-534"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04369688271
		SemiMajorAxis   0.1272
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-535 b/KOI-355.01"
{
	ParentBody     "Kepler-535"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01342484983
		SemiMajorAxis   0.0601
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-536 b/KOI-356.01"
{
	ParentBody     "Kepler-536"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005002385679
		SemiMajorAxis   0.0276
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-537 b/KOI-361.01"
{
	ParentBody     "Kepler-537"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008891511743
		SemiMajorAxis   0.0432
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-538 b/KOI-365.01"
{
	ParentBody     "Kepler-538"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2237907045
		SemiMajorAxis   0.353
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-539 b/KOI-372.01/KOI-372 b"
{
	ParentBody     "Kepler-539"
	Mass            308.654
	Radius          53404.524
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3439702025
		SemiMajorAxis   0.4988
		Eccentricity    0.39
		Inclination     89.845
		ArgOfPericen    71
	}
}

Planet	"Kepler-539 c/KOI-372 c"
{
	ParentBody     "Kepler-539"
	Msini           763.68
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          2.737909332
		SemiMajorAxis   2.42
		Eccentricity    0.5
		Inclination     97.92
		ArgOfPericen    254.91
	}
}

Planet	"Kepler-54 b/KOI-886.01"
{
	ParentBody     "Kepler-54"
	Mass            292.744
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02193323669
		SemiMajorAxis   0.0618
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-54 c/KOI-886.02"
{
	ParentBody     "Kepler-54"
	Mass            117.734
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03305128826
		SemiMajorAxis   0.0812
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-54 d/KOI-886.03"
{
	ParentBody     "Kepler-54"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05748430653
		SemiMajorAxis   0.126
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-540 b/KOI-374.01"
{
	ParentBody     "Kepler-540"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.472850572
		SemiMajorAxis   0.5866
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-541 b/KOI-384.01"
{
	ParentBody     "Kepler-541"
	Radius          21447.6
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01390873952
		SemiMajorAxis   0.0584
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-542 b/KOI-385.01"
{
	ParentBody     "Kepler-542"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03598975153
		SemiMajorAxis   0.1074
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-543 b/KOI-387.01"
{
	ParentBody     "Kepler-543"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03805589838
		SemiMajorAxis   0.098
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-544 b/KOI-393.01"
{
	ParentBody     "Kepler-544"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05863552967
		SemiMajorAxis   0.1611
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-545 b/KOI-409.01"
{
	ParentBody     "Kepler-545"
	Radius          17158.08
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03627549324
		SemiMajorAxis   0.1124
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-546 b/KOI-412.01"
{
	ParentBody     "Kepler-546"
	Radius          44611.008
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01135416547
		SemiMajorAxis   0.0502
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-547 b/KOI-420.01"
{
	ParentBody     "Kepler-547"
	Radius          25522.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01645588724
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-548 b/KOI-421.01"
{
	ParentBody     "Kepler-548"
	Radius          76496.44
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01219518025
		SemiMajorAxis   0.0495
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-549 b/KOI-427.02"
{
	ParentBody     "Kepler-549"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1175920145
		SemiMajorAxis   0.2264
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-549 c/KOI-427.03"
{
	ParentBody     "Kepler-549"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3204462717
		SemiMajorAxis   0.4416
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-55 b/KOI-904.02"
{
	ParentBody     "Kepler-55"
	Mass            474.118
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.07651948673
		SemiMajorAxis   0.1557
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-55 c/KOI-904.03"
{
	ParentBody     "Kepler-55"
	Mass            353.202
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1154073734
		SemiMajorAxis   0.2047
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-55 d/KOI-904.01"
{
	ParentBody     "Kepler-55"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006053788586
		SemiMajorAxis   0.029
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-55 e/KOI-904.04"
{
	ParentBody     "Kepler-55"
	Radius          9865.896
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01264238943
		SemiMajorAxis   0.048
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-55 f/KOI-904.05"
{
	ParentBody     "Kepler-55"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02792269153
		SemiMajorAxis   0.081
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-550 b/KOI-429.01"
{
	ParentBody     "Kepler-550"
	Radius          28167.848
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0235463053
		SemiMajorAxis   0.0747
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-551 b/KOI-430.01"
{
	ParentBody     "Kepler-551"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03388564203
		SemiMajorAxis   0.0837
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-552 b/KOI-432.01"
{
	ParentBody     "Kepler-552"
	Radius          25165.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01441075515
		SemiMajorAxis   0.0612
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-553 b/KOI-433.01"
{
	ParentBody     "Kepler-553"
	Radius          29526.196
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01103505606
		SemiMajorAxis   0.0488
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-553 c/KOI-433.02"
{
	ParentBody     "Kepler-553"
	Radius          71420.508
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.8986912348
		SemiMajorAxis   0.9166
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-554 b/KOI-439.01"
{
	ParentBody     "Kepler-554"
	Radius          27381.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005208074568
		SemiMajorAxis   0.0294
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-555 b/KOI-443.01"
{
	ParentBody     "Kepler-555"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04440274021
		SemiMajorAxis   0.12
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-556 b/KOI-444.01"
{
	ParentBody     "Kepler-556"
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03209629688
		SemiMajorAxis   0.1019
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-557 b/KOI-452.01"
{
	ParentBody     "Kepler-557"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01014666337
		SemiMajorAxis   0.0469
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-558 b/KOI-454.01"
{
	ParentBody     "Kepler-558"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07942101484
		SemiMajorAxis   0.176
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-559 b/KOI-460.01"
{
	ParentBody     "Kepler-559"
	Radius          23020.424
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04815304425
		SemiMajorAxis   0.1299
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-56 b/KOI-1241.02"
{
	ParentBody     "Kepler-56"
	Mass            22.274
	Radius          41465.36
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02875242864
		SemiMajorAxis   0.1028
		Eccentricity    0
		Inclination     83.84
	}
}

Planet	"Kepler-56 c/KOI-1241.01"
{
	ParentBody     "Kepler-56"
	Mass            181.0558
	Radius          62912.96
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.05859780331
		SemiMajorAxis   0.1652
		Eccentricity    0
		Inclination     84.02
	}
}

Planet	"Kepler-56 d"
{
	ParentBody     "Kepler-56"
	Mass            1050.06
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   2
		Eccentricity    0.4
	}
}

Planet	"Kepler-560 b/KOI-463.01"
{
	ParentBody     "Kepler-560"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05059011528
		SemiMajorAxis   0.0916
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-561 b/KOI-464.01"
{
	ParentBody     "Kepler-561"
	Radius          44396.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.15979
		SemiMajorAxis   0.2918
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-561 c/KOI-464.02"
{
	ParentBody     "Kepler-561"
	Radius          17086.588
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01464825841
		SemiMajorAxis   0.0593
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-562 b/KOI-467.01"
{
	ParentBody     "Kepler-562"
	Radius          33243.78
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04930787007
		SemiMajorAxis   0.1333
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-563 b/KOI-468.01"
{
	ParentBody     "Kepler-563"
	Radius          19731.792
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06073867613
		SemiMajorAxis   0.1418
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-564 b/KOI-470.01"
{
	ParentBody     "Kepler-564"
	Radius          29526.196
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0102694387
		SemiMajorAxis   0.0484
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-565 b"
{
	ParentBody     "Kepler-565"
	Radius          23234.9
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01161899514
	}
}

Planet	"Kepler-566 b/KOI-476.01"
{
	ParentBody     "Kepler-566"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05045404598
		SemiMajorAxis   0.1234
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-567 b/KOI-477.01"
{
	ParentBody     "Kepler-567"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04529316221
		SemiMajorAxis   0.1229
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-568 b/KOI-478.01"
{
	ParentBody     "Kepler-568"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03018127439
		SemiMajorAxis   0.078
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-569 b/KOI-479.01"
{
	ParentBody     "Kepler-569"
	Radius          20160.744
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09360612262
		SemiMajorAxis   0.2067
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-57 b/KOI-1270.01"
{
	ParentBody     "Kepler-57"
	Mass            6001.252
	Radius          14298.4
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.0156863576
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-57 c/KOI-1270.02"
{
	ParentBody     "Kepler-57"
	Mass            2211.49
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03178509226
		SemiMajorAxis   0.0961
		Eccentricity    0
		Inclination     79.64
	}
}

Planet	"Kepler-570 b/KOI-480.01"
{
	ParentBody     "Kepler-570"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01177756053
		SemiMajorAxis   0.0497
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-571 b/KOI-483.01"
{
	ParentBody     "Kepler-571"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01313813005
		SemiMajorAxis   0.0544
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-572 b/KOI-484.01"
{
	ParentBody     "Kepler-572"
	Radius          16443.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.047106373
		SemiMajorAxis   0.1194
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-573 b/KOI-486.01"
{
	ParentBody     "Kepler-573"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06073585472
		SemiMajorAxis   0.145
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-574 b/KOI-487.01"
{
	ParentBody     "Kepler-574"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02096911133
		SemiMajorAxis   0.0723
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-575 b/KOI-488.01"
{
	ParentBody     "Kepler-575"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02567863106
		SemiMajorAxis   0.0788
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-576 b/KOI-492.01"
{
	ParentBody     "Kepler-576"
	Radius          20875.664
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08189461341
		SemiMajorAxis   0.1892
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-577 b/KOI-494.01"
{
	ParentBody     "Kepler-577"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07035272273
		SemiMajorAxis   0.1353
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-578 b/KOI-496.01"
{
	ParentBody     "Kepler-578"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004426880971
		SemiMajorAxis   0.0258
		Eccentricity    0
		Inclination     81.36
	}
}

Planet	"Kepler-579 b/KOI-499.01"
{
	ParentBody     "Kepler-579"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02647168782
		SemiMajorAxis   0.0854
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-58 b/KOI-1336.01"
{
	ParentBody     "Kepler-58"
	Mass            442.298
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02797731391
		SemiMajorAxis   0.0927
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-58 c/KOI-1336.02"
{
	ParentBody     "Kepler-58"
	Mass            696.858
	Radius          18587.92
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.04264062924
		SemiMajorAxis   0.1228
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-58 d/KOI-1336.03"
{
	ParentBody     "Kepler-58"
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1097939179
		SemiMajorAxis   0.236
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-580 b/KOI-503.01"
{
	ParentBody     "Kepler-580"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02251223952
		SemiMajorAxis   0.0665
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-581 b/KOI-504.01"
{
	ParentBody     "Kepler-581"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1111782352
		SemiMajorAxis   0.2244
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-582 b/KOI-507.01"
{
	ParentBody     "Kepler-582"
	Radius          23449.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05063039592
		SemiMajorAxis   0.1254
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-583 b/KOI-512.01"
{
	ParentBody     "Kepler-583"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01782385902
		SemiMajorAxis   0.0689
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-584 b/KOI-513.01"
{
	ParentBody     "Kepler-584"
	Radius          26880.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09632247144
		SemiMajorAxis   0.2237
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-585 b/KOI-517.01"
{
	ParentBody     "Kepler-585"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007535711444
		SemiMajorAxis   0.0384
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-586 b/KOI-526.01"
{
	ParentBody     "Kepler-586"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005762538498
		SemiMajorAxis   0.0331
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-587 b/KOI-530.01"
{
	ParentBody     "Kepler-587"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02995349035
		SemiMajorAxis   0.0955
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-588 b"
{
	ParentBody     "Kepler-588"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01155842747
	}
}

Planet	"Kepler-589 b/KOI-533.01"
{
	ParentBody     "Kepler-589"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04531143937
		SemiMajorAxis   0.1196
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-59 b/KOI-1529.02"
{
	ParentBody     "Kepler-59"
	Mass            652.31
	Radius          7006.216
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03249397531
		SemiMajorAxis   0.1042
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-59 c/KOI-1529.01"
{
	ParentBody     "Kepler-59"
	Mass            435.934
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.04922794792
		SemiMajorAxis   0.1375
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-590 b/KOI-535.01"
{
	ParentBody     "Kepler-590"
	Radius          25665.628
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01602488084
		SemiMajorAxis   0.0647
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-591 b/KOI-536.01"
{
	ParentBody     "Kepler-591"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2222345396
		SemiMajorAxis   0.3719
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-592 b/KOI-537.01"
{
	ParentBody     "Kepler-592"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007721431117
		SemiMajorAxis   0.0397
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-593 b/KOI-538.01"
{
	ParentBody     "Kepler-593"
	Radius          18301.952
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05809046797
		SemiMajorAxis   0.1508
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-594 b/KOI-541.01"
{
	ParentBody     "Kepler-594"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03736200882
		SemiMajorAxis   0.1086
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-595 b/KOI-547.01"
{
	ParentBody     "Kepler-595"
	Radius          24307.28
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06927710988
		SemiMajorAxis   0.1648
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-596 b/KOI-548.01"
{
	ParentBody     "Kepler-596"
	Radius          22091.028
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05831808904
		SemiMajorAxis   0.1542
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-597 b/KOI-550.01"
{
	ParentBody     "Kepler-597"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03565759644
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-598 b/KOI-555.01"
{
	ParentBody     "Kepler-598"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01013506759
		SemiMajorAxis   0.0438
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-599 b/KOI-557.01"
{
	ParentBody     "Kepler-599"
	Radius          18087.476
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04286368595
		SemiMajorAxis   0.1128
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-6 b/KOI-17.01"
{
	ParentBody     "Kepler-6"
	Mass            212.5576
	Radius          93225.568
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.008856314221
		SemiMajorAxis   0.04852
		Eccentricity    0
		Inclination     88.93
	}
}

Planet	"Kepler-60 b/KOI-2086.01"
{
	ParentBody     "Kepler-60"
	Mass            4.193876
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01953060243
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-60 c/KOI-2086.02"
{
	ParentBody     "Kepler-60"
	Mass            3.853402
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02441859196
		SemiMajorAxis   0.0871
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-60 d/KOI-2086.03"
{
	ParentBody     "Kepler-60"
	Mass            4.165238
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03257591902
		SemiMajorAxis   0.1055
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-600 b/KOI-560.01"
{
	ParentBody     "Kepler-600"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0648204855
		SemiMajorAxis   0.154
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-601 b/KOI-561.01"
{
	ParentBody     "Kepler-601"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0147268541
		SemiMajorAxis   0.0547
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-602 b/KOI-563.01"
{
	ParentBody     "Kepler-602"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04184810899
		SemiMajorAxis   0.1231
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-603 b/KOI-564.01"
{
	ParentBody     "Kepler-603"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05764280947
		SemiMajorAxis   0.1484
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-603 c/KOI-564.02"
{
	ParentBody     "Kepler-603"
	Radius          41465.36
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3501993498
		SemiMajorAxis   0.4942
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-603 d/KOI-564.03"
{
	ParentBody     "Kepler-603"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01702193605
		SemiMajorAxis   0.0658
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-604 b/KOI-566.01"
{
	ParentBody     "Kepler-604"
	Radius          16514.652
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07078869468
		SemiMajorAxis   0.1735
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-605 b/KOI-568.01"
{
	ParentBody     "Kepler-605"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009263820457
		SemiMajorAxis   0.0429
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-605 c/KOI-568.02"
{
	ParentBody     "Kepler-605"
	Radius          5504.884
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00645859538
		SemiMajorAxis   0.0337
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-606 b/KOI-575.01"
{
	ParentBody     "Kepler-606"
	Radius          21090.14
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.066574346
		SemiMajorAxis   0.1693
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-607 b/KOI-577.02"
{
	ParentBody     "Kepler-607"
	Radius          5576.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001747232981
		SemiMajorAxis   0.0135
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-608 b/KOI-578.01"
{
	ParentBody     "Kepler-608"
	Radius          23234.9
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01755688477
		SemiMajorAxis   0.0685
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-609 b/KOI-580.01"
{
	ParentBody     "Kepler-609"
	Radius          21376.108
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01785448355
		SemiMajorAxis   0.0682
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-61 b/KOI-1361.01"
{
	ParentBody     "Kepler-61"
	Radius          13726.464
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1639393303
		SemiMajorAxis   0.27
		Eccentricity    0.25
		Inclination     89.8
	}
}

Planet	"Kepler-610 b/KOI-581.01"
{
	ParentBody     "Kepler-610"
	Radius          26738.008
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0191569505
		SemiMajorAxis   0.0719
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-610 c/KOI-581.02"
{
	ParentBody     "Kepler-610"
	Radius          21018.648
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4157896437
		SemiMajorAxis   0.5594
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-611 b/KOI-583.01"
{
	ParentBody     "Kepler-611"
	Radius          10509.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006672376214
		SemiMajorAxis   0.0365
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-612 b/KOI-585.01"
{
	ParentBody     "Kepler-612"
	Radius          18087.476
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01019092677
		SemiMajorAxis   0.0451
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-613 b/KOI-586.01"
{
	ParentBody     "Kepler-613"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04320365111
		SemiMajorAxis   0.1232
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-614 b/KOI-587.01"
{
	ParentBody     "Kepler-614"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03842632513
		SemiMajorAxis   0.1027
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-615 b/KOI-588.01"
{
	ParentBody     "Kepler-615"
	Radius          11081.26
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02835336896
		SemiMajorAxis   0.0756
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-616 b/KOI-593.01"
{
	ParentBody     "Kepler-616"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02737257302
		SemiMajorAxis   0.0927
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-616 c/KOI-593.02"
{
	ParentBody     "Kepler-616"
	Radius          21733.568
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2475380942
		SemiMajorAxis   0.4024
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-617 b/KOI-596.01"
{
	ParentBody     "Kepler-617"
	Radius          8436.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004607069492
		SemiMajorAxis   0.0218
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-618 b/KOI-600.01"
{
	ParentBody     "Kepler-618"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009844891253
		SemiMajorAxis   0.0468
		Eccentricity    0
		Inclination     79.64
	}
}

Planet	"Kepler-619 b/KOI-601.01"
{
	ParentBody     "Kepler-619"
	Radius          20160.744
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01479640729
		SemiMajorAxis   0.0611
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-619 c/KOI-601.03"
{
	ParentBody     "Kepler-619"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003308667683
		SemiMajorAxis   0.0225
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-62 b/KOI-701.02"
{
	ParentBody     "Kepler-62"
	Mass            8.9096
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01564696565
		SemiMajorAxis   0.0553
		Eccentricity    0
		Inclination     89.2
	}
}

Planet	"Kepler-62 c/KOI-701.05"
{
	ParentBody     "Kepler-62"
	Mass            4.00932
	Radius          3431.616
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.03406424653
		SemiMajorAxis   0.0929
		Eccentricity    0
		Inclination     89.7
	}
}

Planet	"Kepler-62 d/KOI-701.01"
{
	ParentBody     "Kepler-62"
	Mass            14.0008
	Radius          12439.608
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04973154938
		SemiMajorAxis   0.12
		Eccentricity    0
		Inclination     89.7
	}
}

Planet	"Kepler-62 e/KOI-701.03"
{
	ParentBody     "Kepler-62"
	Mass            35.9566
	Radius          10294.848
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.3350856046
		SemiMajorAxis   0.427
		Eccentricity    0
		Inclination     89.98
	}
}

Planet	"Kepler-62 f/KOI-701.04"
{
	ParentBody     "Kepler-62"
	Mass            35.002
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.7318185232
		SemiMajorAxis   0.718
		Eccentricity    0
		Inclination     89.9
	}
}

Planet	"Kepler-620 b/KOI-602.01"
{
	ParentBody     "Kepler-620"
	Radius          21161.632
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03535668844
		SemiMajorAxis   0.1053
		Eccentricity    0
		Inclination     82.51
	}
}

Planet	"Kepler-621 b/KOI-605.01"
{
	ParentBody     "Kepler-621"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007195537161
		SemiMajorAxis   0.0311
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-622 b/KOI-610.01"
{
	ParentBody     "Kepler-622"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03910355144
		SemiMajorAxis   0.0909
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-623 b/KOI-618.01"
{
	ParentBody     "Kepler-623"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02483551351
		SemiMajorAxis   0.0854
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-624 b/KOI-626.01"
{
	ParentBody     "Kepler-624"
	Radius          14727.352
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03993650371
		SemiMajorAxis   0.119
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-625 b/KOI-627.01"
{
	ParentBody     "Kepler-625"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02122406758
		SemiMajorAxis   0.0807
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-625 c/KOI-627.02"
{
	ParentBody     "Kepler-625"
	Radius          6720.248
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01140439198
		SemiMajorAxis   0.0533
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-626 b/KOI-628.01"
{
	ParentBody     "Kepler-626"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03966094934
		SemiMajorAxis   0.1086
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-627 b/KOI-629.01"
{
	ParentBody     "Kepler-627"
	Radius          23806.836
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1114313884
		SemiMajorAxis   0.2327
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-628 b"
{
	ParentBody     "Kepler-628"
	Radius          53547.508
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04232275769
	}
}

Planet	"Kepler-629 b/KOI-632.01"
{
	ParentBody     "Kepler-629"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01981859052
		SemiMajorAxis   0.0706
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-63 b/KOI-63.01"
{
	ParentBody     "TYC 3550-458-1"
	Mass            120.2796
	Radius          38963.14
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02582984869
		SemiMajorAxis   0.08
		Eccentricity    0.45
		Inclination     87.806
	}
}

Planet	"Kepler-630 b/KOI-633.01"
{
	ParentBody     "Kepler-630"
	Radius          20303.728
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4421022494
		SemiMajorAxis   0.5755
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-631 b/KOI-639.01"
{
	ParentBody     "Kepler-631"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04922703644
		SemiMajorAxis   0.133
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-632 b/KOI-640.01"
{
	ParentBody     "Kepler-632"
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08486590047
		SemiMajorAxis   0.1813
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-633 b/KOI-645.01"
{
	ParentBody     "Kepler-633"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02328155787
		SemiMajorAxis   0.0824
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-634 b/KOI-647.01"
{
	ParentBody     "Kepler-634"
	Radius          12082.148
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01415362714
		SemiMajorAxis   0.0592
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-635 b/KOI-649.01"
{
	ParentBody     "Kepler-635"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06420317995
		SemiMajorAxis   0.1697
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-636 b/KOI-652.01"
{
	ParentBody     "Kepler-636"
	Radius          28382.324
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04402739223
		SemiMajorAxis   0.1022
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-637 b/KOI-659.01"
{
	ParentBody     "Kepler-637"
	Radius          30312.608
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06353550295
		SemiMajorAxis   0.1734
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-638 b/KOI-660.01"
{
	ParentBody     "Kepler-638"
	Radius          11653.196
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01664574644
		SemiMajorAxis   0.0617
		Eccentricity    0
		Inclination     75.06
	}
}

Planet	"Kepler-639 b/KOI-662.01"
{
	ParentBody     "Kepler-639"
	Radius          15156.304
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02796556708
		SemiMajorAxis   0.0915
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-640 b/KOI-666.01"
{
	ParentBody     "Kepler-640"
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06091338922
		SemiMajorAxis   0.1602
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-641 b/KOI-670.01"
{
	ParentBody     "Kepler-641"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02598170741
		SemiMajorAxis   0.0879
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-642 b/KOI-673.01"
{
	ParentBody     "Kepler-642"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01209460099
		SemiMajorAxis   0.0557
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-643 b/KOI-674.01"
{
	ParentBody     "Kepler-643"
	Radius          64771.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04473441654
		SemiMajorAxis   0.1321
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-644 b/KOI-685.01"
{
	ParentBody     "Kepler-644"
	Radius          20089.252
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008689897247
		SemiMajorAxis   0.0469
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-645 b/KOI-688.01"
{
	ParentBody     "Kepler-645"
	Radius          13369.004
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008968905321
		SemiMajorAxis   0.0442
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-646 b/KOI-689.01"
{
	ParentBody     "Kepler-646"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04346060256
		SemiMajorAxis   0.1149
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-647 b/KOI-691.02"
{
	ParentBody     "Kepler-647"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04442385176
		SemiMajorAxis   0.1224
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-648 b/KOI-694.01"
{
	ParentBody     "Kepler-648"
	Radius          20518.204
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04769759733
		SemiMajorAxis   0.1302
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-649 b/KOI-695.01"
{
	ParentBody     "Kepler-649"
	Radius          14441.384
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08188327518
		SemiMajorAxis   0.1761
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-65 b/KOI-85.02"
{
	ParentBody     "Kepler-65"
	Radius          8986.5444
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.005899963531
		SemiMajorAxis   0.035
		Eccentricity    0.02
		Inclination     80.79
	}
}

Planet	"Kepler-65 c/KOI-85.01"
{
	ParentBody     "Kepler-65"
	Msini           26.7288
	Radius          16400.2648
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.0160439866
		SemiMajorAxis   0.068
		Eccentricity    0.08
		Inclination     89.95
	}
}

Planet	"Kepler-65 d/KOI-85.03"
{
	ParentBody     "Kepler-65"
	Mass            2.002328289
	Radius          9608.5248
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02226257323
		SemiMajorAxis   0.084
		Eccentricity    0.1
		Inclination     83.08
	}
}

Planet	"Kepler-650 b/KOI-697.01"
{
	ParentBody     "Kepler-650"
	Radius          18873.888
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008301739707
		SemiMajorAxis   0.0415
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-651 b/KOI-709.01"
{
	ParentBody     "Kepler-651"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05855077988
		SemiMajorAxis   0.1449
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-652 b/KOI-714.01"
{
	ParentBody     "Kepler-652"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01144994375
		SemiMajorAxis   0.0484
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-653 b/KOI-717.01"
{
	ParentBody     "Kepler-653"
	Radius          12439.608
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04026777346
		SemiMajorAxis   0.1205
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-653 c/KOI-717.02"
{
	ParentBody     "Kepler-653"
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002465149167
		SemiMajorAxis   0.0187
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-654 b/KOI-721.01"
{
	ParentBody     "Kepler-654"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03757685084
		SemiMajorAxis   0.1211
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-655 b/KOI-722.01"
{
	ParentBody     "Kepler-655"
	Radius          17301.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1270563398
		SemiMajorAxis   0.2698
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-656 b/KOI-732.01"
{
	ParentBody     "Kepler-656"
	Radius          19874.776
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003450475123
		SemiMajorAxis   0.0232
		Eccentricity    0
		Inclination     77.35
	}
}

Planet	"Kepler-657 b/KOI-734.01"
{
	ParentBody     "Kepler-657"
	Radius          22448.488
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06719788913
		SemiMajorAxis   0.1654
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-658 b/KOI-739.01"
{
	ParentBody     "Kepler-658"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003523899472
		SemiMajorAxis   0.0187
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-659 b/KOI-740.01"
{
	ParentBody     "Kepler-659"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04838377518
		SemiMajorAxis   0.1205
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-66 b/KOI-1958.01"
{
	ParentBody     "Kepler-66"
	Mass            98.642
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04877808614
		SemiMajorAxis   0.1352
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-660 b/KOI-746.01"
{
	ParentBody     "Kepler-660"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02539022653
		SemiMajorAxis   0.0759
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-661 b/KOI-747.01"
{
	ParentBody     "Kepler-661"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01650768035
		SemiMajorAxis   0.0591
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-662 b/KOI-750.01"
{
	ParentBody     "Kepler-662"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05934959176
		SemiMajorAxis   0.1236
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-663 b/KOI-751.01"
{
	ParentBody     "Kepler-663"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01368073837
		SemiMajorAxis   0.0559
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-664 b/KOI-755.01"
{
	ParentBody     "Kepler-664"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006914845519
		SemiMajorAxis   0.0374
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-665 b/KOI-758.01"
{
	ParentBody     "Kepler-665"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04384242154
		SemiMajorAxis   0.1148
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-666 b/KOI-762.01"
{
	ParentBody     "Kepler-666"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0123171995
		SemiMajorAxis   0.0542
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-667 b/KOI-764.01"
{
	ParentBody     "Kepler-667"
	Radius          30169.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1134579444
		SemiMajorAxis   0.2288
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-668 b/KOI-765.01"
{
	ParentBody     "Kepler-668"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02287223826
		SemiMajorAxis   0.0765
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-669 b/KOI-766.01"
{
	ParentBody     "Kepler-669"
	Radius          30813.052
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01129537327
		SemiMajorAxis   0.0529
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-67 b/KOI-2115.01"
{
	ParentBody     "Kepler-67"
	Mass            98.642
	Radius          18730.904
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.04305608836
		SemiMajorAxis   0.1171
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-670 b/KOI-767.01"
{
	ParentBody     "Kepler-670"
	Radius          84074.592
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007711334912
		SemiMajorAxis   0.0382
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-671 b/KOI-769.01"
{
	ParentBody     "Kepler-671"
	Radius          17158.08
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01172087647
		SemiMajorAxis   0.05
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-672 b/KOI-773.01"
{
	ParentBody     "Kepler-672"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1050740122
		SemiMajorAxis   0.2288
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-673 b/KOI-776.01"
{
	ParentBody     "Kepler-673"
	Radius          41679.836
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01020892765
		SemiMajorAxis   0.0456
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-674 b/KOI-778.01"
{
	ParentBody     "Kepler-674"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006142176102
		SemiMajorAxis   0.0261
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-675 b/KOI-780.01"
{
	ParentBody     "Kepler-675"
	Radius          15585.256
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00639969334
		SemiMajorAxis   0.0317
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-676 b/KOI-781.01"
{
	ParentBody     "Kepler-676"
	Radius          19374.332
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03175487948
		SemiMajorAxis   0.0802
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-677 b/KOI-782.01"
{
	ParentBody     "Kepler-677"
	Radius          34316.16
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01800262117
		SemiMajorAxis   0.067
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-678 b/KOI-783.01"
{
	ParentBody     "Kepler-678"
	Radius          32814.828
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01991839235
		SemiMajorAxis   0.0732
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-679 b/KOI-785.01"
{
	ParentBody     "Kepler-679"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03393251487
		SemiMajorAxis   0.0978
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-68 b/KOI-246.01"
{
	ParentBody     "Kepler-68"
	Mass            5.98216
	Radius          14727.352
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01478129704
		SemiMajorAxis   0.0617
		Eccentricity    0.02
		Inclination     87.6
	}
}

Planet	"Kepler-68 c/KOI-246.02"
{
	ParentBody     "Kepler-68"
	Mass            2.182852
	Radius          5912.3884
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02629756164
		SemiMajorAxis   0.09059
		Eccentricity    0.42
		Inclination     86.93
	}
}

Planet	"Kepler-68 d"
{
	ParentBody     "Kepler-68"
	Msini           267.288
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          1.711193332
		SemiMajorAxis   1.4
		Eccentricity    0.18
	}
}

Planet	"Kepler-680 b/KOI-786.01"
{
	ParentBody     "Kepler-680"
	Radius          15442.272
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01010268362
		SemiMajorAxis   0.0469
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-681 b/KOI-788.01"
{
	ParentBody     "Kepler-681"
	Radius          19660.3
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07226535486
		SemiMajorAxis   0.1642
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-682 b/KOI-791.01"
{
	ParentBody     "Kepler-682"
	Radius          47041.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03453025697
		SemiMajorAxis   0.1058
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-683 b/KOI-794.01"
{
	ParentBody     "Kepler-683"
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006952053324
		SemiMajorAxis   0.0368
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-684 b/KOI-795.01"
{
	ParentBody     "Kepler-684"
	Radius          21447.6
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01853647305
		SemiMajorAxis   0.064
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-685 b/KOI-801.01"
{
	ParentBody     "Kepler-685"
	Radius          67488.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004450532401
		SemiMajorAxis   0.0272
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-686 b/KOI-809.01"
{
	ParentBody     "Kepler-686"
	Radius          77497.328
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004366268477
		SemiMajorAxis   0.0258
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-687 b/KOI-811.01"
{
	ParentBody     "Kepler-687"
	Radius          22448.488
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05614321223
		SemiMajorAxis   0.1326
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-688 b/KOI-813.01"
{
	ParentBody     "Kepler-688"
	Radius          62269.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01066672183
		SemiMajorAxis   0.0459
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-689 b/KOI-814.01"
{
	ParentBody     "Kepler-689"
	Radius          18444.936
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06123761551
		SemiMajorAxis   0.1448
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-69 b/KOI-172.01"
{
	ParentBody     "Kepler-69"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.03757052548
		SemiMajorAxis   0.094
		Eccentricity    0.16
		Inclination     89.62
	}
}

Planet	"Kepler-69 c/KOI-172.02"
{
	ParentBody     "Kepler-69"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.6638370559
		SemiMajorAxis   0.64
		Eccentricity    0.14
		Inclination     89.85
	}
}

Planet	"Kepler-690 b/KOI-816.01"
{
	ParentBody     "Kepler-690"
	Radius          37962.252
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02121357988
		SemiMajorAxis   0.0802
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-691 b/KOI-818.01"
{
	ParentBody     "Kepler-691"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02221643399
		SemiMajorAxis   0.0644
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-692 b/KOI-821.01"
{
	ParentBody     "Kepler-692"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05972183813
		SemiMajorAxis   0.1495
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-693 b/KOI-824.01"
{
	ParentBody     "Kepler-693"
	Radius          64914.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04209708995
		SemiMajorAxis   0.1083
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-694 b/KOI-826.01"
{
	ParentBody     "Kepler-694"
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01742909715
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-695 b"
{
	ParentBody     "Kepler-695"
	Radius          58766.424
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008324149029
	}
}

Planet	"Kepler-696 b/KOI-843.01"
{
	ParentBody     "Kepler-696"
	Radius          39177.616
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01147300527
		SemiMajorAxis   0.0535
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-697 b/KOI-844.01"
{
	ParentBody     "Kepler-697"
	Radius          26309.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01015728947
		SemiMajorAxis   0.0462
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-698 b/KOI-845.01"
{
	ParentBody     "Kepler-698"
	Radius          23449.376
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04470940826
		SemiMajorAxis   0.1255
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-699 b/KOI-846.01"
{
	ParentBody     "Kepler-699"
	Radius          90008.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07613458604
		SemiMajorAxis   0.1708
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-7 b/KOI-97.01"
{
	ParentBody     "Kepler-7"
	Mass            140.3262
	Radius          115960.024
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.01337602647
		SemiMajorAxis   0.06067
		Eccentricity    0.1
		Inclination     85.161
		ArgOfPericen    357.1
	}
}

Planet	"Kepler-70 b"
{
	ParentBody     "Kepler-70"
	Mass            4.4548
	Radius          4861.456
	DiscMethod     "Imaging"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0006573720306
		SemiMajorAxis   0.006
		Inclination     65
	}
}

Planet	"Kepler-70 c"
{
	ParentBody     "Kepler-70"
	Mass            0.66822
	Radius          5576.376
	DiscMethod     "Imaging"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0009388017308
		SemiMajorAxis   0.0076
		Inclination     65
	}
}

Planet	"Kepler-700 b/KOI-847.01"
{
	ParentBody     "Kepler-700"
	Radius          38176.728
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2214203784
		SemiMajorAxis   0.3369
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-701 b/KOI-849.01"
{
	ParentBody     "Kepler-701"
	Radius          18087.476
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02835195949
		SemiMajorAxis   0.0895
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-702 b/KOI-850.01"
{
	ParentBody     "Kepler-702"
	Radius          58480.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02882003874
		SemiMajorAxis   0.088
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-703 b/KOI-851.01"
{
	ParentBody     "Kepler-703"
	Radius          52332.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.012549267
		SemiMajorAxis   0.0535
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-704 b/KOI-852.01"
{
	ParentBody     "Kepler-704"
	Radius          16657.636
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01029952523
		SemiMajorAxis   0.047
		Eccentricity    0
		Inclination     79.07
	}
}

Planet	"Kepler-705 b/KOI-854.01"
{
	ParentBody     "Kepler-705"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1534763928
		SemiMajorAxis   0.2261
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-706 b/KOI-855.01"
{
	ParentBody     "Kepler-706"
	Radius          84003.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1133722079
		SemiMajorAxis   0.2162
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-707 b/KOI-861.01"
{
	ParentBody     "Kepler-707"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00612605228
		SemiMajorAxis   0.0315
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-708 b/KOI-863.01"
{
	ParentBody     "Kepler-708"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008673400905
		SemiMajorAxis   0.0426
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-709 b/KOI-867.01"
{
	ParentBody     "Kepler-709"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04403995482
		SemiMajorAxis   0.1173
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-71 b/KOI-217.01"
{
	ParentBody     "Kepler-71"
	Radius          74723.4384
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01069175771
		SemiMajorAxis   0.047
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-710 b/KOI-873.01"
{
	ParentBody     "Kepler-710"
	Radius          12010.656
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01190247362
		SemiMajorAxis   0.0487
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-711 b/KOI-878.01"
{
	ParentBody     "Kepler-711"
	Radius          21733.568
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06458493743
		SemiMajorAxis   0.1429
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-712 b/KOI-881.01"
{
	ParentBody     "Kepler-712"
	Radius          21733.568
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05755763593
		SemiMajorAxis   0.1367
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-712 c/KOI-881.02"
{
	ParentBody     "Kepler-712"
	Radius          30956.036
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.6212055351
		SemiMajorAxis   0.6676
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-713 b"
{
	ParentBody     "Kepler-713"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0202910321
	}
}

Planet	"Kepler-714 b/KOI-890.01"
{
	ParentBody     "Kepler-714"
	Radius          61697.596
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02217402101
		SemiMajorAxis   0.0827
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-715 b/KOI-891.01"
{
	ParentBody     "Kepler-715"
	Radius          23949.82
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02739697173
		SemiMajorAxis   0.0933
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-716 b/KOI-892.01"
{
	ParentBody     "Kepler-716"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02839673186
		SemiMajorAxis   0.0874
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-717 b/KOI-893.01"
{
	ParentBody     "Kepler-717"
	Radius          15442.272
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01206980013
		SemiMajorAxis   0.052
		Eccentricity    0
		Inclination     77.35
	}
}

Planet	"Kepler-718 b/KOI-897.01"
{
	ParentBody     "Kepler-718"
	Radius          105593.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005619147944
		SemiMajorAxis   0.0331
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-719 b"
{
	ParentBody     "Kepler-719"
	Radius          54333.92
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01370958208
	}
}

Planet	"Kepler-720 b/KOI-908.01"
{
	ParentBody     "Kepler-720"
	Radius          53619
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01289097117
		SemiMajorAxis   0.0539
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-721 b/KOI-910.01"
{
	ParentBody     "Kepler-721"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01476287663
		SemiMajorAxis   0.0581
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-722 b/KOI-911.01"
{
	ParentBody     "Kepler-722"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0112078324
		SemiMajorAxis   0.0514
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-722 c/KOI-911.02"
{
	ParentBody     "Kepler-722"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2878767895
		SemiMajorAxis   0.4471
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-723 b/KOI-913.01"
{
	ParentBody     "Kepler-723"
	Radius          77783.296
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01117689901
		SemiMajorAxis   0.0477
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-724 b/KOI-916.01"
{
	ParentBody     "Kepler-724"
	Radius          21018.648
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009076022519
		SemiMajorAxis   0.0433
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-725 b/KOI-918.01"
{
	ParentBody     "Kepler-725"
	Radius          67774.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1085394273
		SemiMajorAxis   0.2205
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-726 b/KOI-920.01"
{
	ParentBody     "Kepler-726"
	Radius          20804.172
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05969877382
		SemiMajorAxis   0.1411
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-727 b/KOI-922.01"
{
	ParentBody     "Kepler-727"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01411251099
		SemiMajorAxis   0.0546
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-728 b/KOI-923.01"
{
	ParentBody     "Kepler-728"
	Radius          21304.616
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01572512002
		SemiMajorAxis   0.0625
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-729 b/KOI-926.01"
{
	ParentBody     "Kepler-729"
	Radius          22805.948
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008669189371
		SemiMajorAxis   0.0432
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-730 b/KOI-929.01"
{
	ParentBody     "Kepler-730"
	Radius          58766.424
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01777364292
		SemiMajorAxis   0.0714
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-731 b/KOI-931.01"
{
	ParentBody     "Kepler-731"
	Radius          88507.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01055629294
		SemiMajorAxis   0.0505
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-732 b/KOI-936.01"
{
	ParentBody     "Kepler-732"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02592201644
		SemiMajorAxis   0.0677
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-732 c/KOI-936.02"
{
	ParentBody     "Kepler-732"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002445065945
		SemiMajorAxis   0.014
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-733 b/KOI-937.01"
{
	ParentBody     "Kepler-733"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05704228
		SemiMajorAxis   0.1483
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-734 b/KOI-940.01"
{
	ParentBody     "Kepler-734"
	Radius          22734.456
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01671453362
		SemiMajorAxis   0.0617
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-735 b/KOI-942.01"
{
	ParentBody     "Kepler-735"
	Radius          18802.396
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03152749107
		SemiMajorAxis   0.0966
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-736 b/KOI-943.01"
{
	ParentBody     "Kepler-736"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009860503825
		SemiMajorAxis   0.0446
		Eccentricity    0
		Inclination     80.21
	}
}

Planet	"Kepler-737 b/KOI-947.01"
{
	ParentBody     "Kepler-737"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07830189059
		SemiMajorAxis   0.1443
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-738 b/KOI-948.01"
{
	ParentBody     "Kepler-738"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06731756739
		SemiMajorAxis   0.1548
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-739 b/KOI-949.01"
{
	ParentBody     "Kepler-739"
	Radius          21161.632
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03431280668
		SemiMajorAxis   0.1054
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-74 b/KOI-200.01"
{
	ParentBody     "Kepler-74"
	Mass            216.376
	Radius          94369.44
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2454967.04
		Period          0.02009822032
		SemiMajorAxis   0.084
		Eccentricity    0.287
		Inclination     85.55
		ArgOfPericen    64
	}
}

Planet	"Kepler-740 b/KOI-953.01"
{
	ParentBody     "Kepler-740"
	Radius          29168.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009812944177
		SemiMajorAxis   0.0462
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-741 b/KOI-955.01"
{
	ParentBody     "Kepler-741"
	Radius          18945.38
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01927220879
		SemiMajorAxis   0.074
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-742 b/KOI-956.01"
{
	ParentBody     "Kepler-742"
	Radius          20661.188
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02289129918
		SemiMajorAxis   0.0744
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-743 b/KOI-987.01"
{
	ParentBody     "Kepler-743"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008704533617
		SemiMajorAxis   0.0418
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-744 b/KOI-991.01"
{
	ParentBody     "Kepler-744"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03302527683
		SemiMajorAxis   0.1049
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-745 b/KOI-992.01"
{
	ParentBody     "Kepler-745"
	Radius          13797.956
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0271913701
		SemiMajorAxis   0.0908
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-746 b/KOI-1002.01"
{
	ParentBody     "Kepler-746"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009532284623
		SemiMajorAxis   0.0437
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-747 b/KOI-1005.01"
{
	ParentBody     "Kepler-747"
	Radius          33601.24
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09751777549
		SemiMajorAxis   0.1916
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-748 b/KOI-1007.01"
{
	ParentBody     "Kepler-748"
	Radius          16085.7
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02028086606
		SemiMajorAxis   0.0745
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-749 b/KOI-1014.01"
{
	ParentBody     "Kepler-749"
	Radius          19803.284
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04741282998
		SemiMajorAxis   0.1054
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-75 b/KOI-889.01"
{
	ParentBody     "Kepler-75"
	Mass            3150.18
	Radius          73636.76
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2455002.841
		Period          0.02432611633
		SemiMajorAxis   0.08
		Eccentricity    0.569
		Inclination     89.1
		ArgOfPericen    63.6
	}
}

Planet	"Kepler-750 b/KOI-1015.01"
{
	ParentBody     "Kepler-750"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02581539606
		SemiMajorAxis   0.0926
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-750 c/KOI-1015.02"
{
	ParentBody     "Kepler-750"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01119528448
		SemiMajorAxis   0.0531
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-751 b/KOI-1017.01"
{
	ParentBody     "Kepler-751"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04776257192
		SemiMajorAxis   0.1263
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-752 b/KOI-1022.01"
{
	ParentBody     "Kepler-752"
	Radius          17944.492
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05154791306
		SemiMajorAxis   0.1353
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-753 b/KOI-1024.01"
{
	ParentBody     "Kepler-753"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01573674994
		SemiMajorAxis   0.0508
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-754 b/KOI-1031.01"
{
	ParentBody     "Kepler-754"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0398629296
		SemiMajorAxis   0.116
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-755 b/KOI-1050.01"
{
	ParentBody     "Kepler-755"
	Radius          11224.244
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003474654367
		SemiMajorAxis   0.0207
		Eccentricity    0
		Inclination     72.19
	}
}

Planet	"Kepler-755 c/KOI-1050.02"
{
	ParentBody     "Kepler-755"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007811621218
		SemiMajorAxis   0.0355
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-756 b/KOI-1053.01"
{
	ParentBody     "Kepler-756"
	Radius          7149.2
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003353572928
		SemiMajorAxis   0.0217
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-757 b/KOI-1059.01"
{
	ParentBody     "Kepler-757"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002800001885
		SemiMajorAxis   0.0191
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-758 b/KOI-1060.01"
{
	ParentBody     "Kepler-758"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03315528911
		SemiMajorAxis   0.1114
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-758 c/KOI-1060.02"
{
	ParentBody     "Kepler-758"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01302680794
		SemiMajorAxis   0.0597
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-758 d/KOI-1060.03"
{
	ParentBody     "Kepler-758"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05611788635
		SemiMajorAxis   0.1582
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-758 e/KOI-1060.04"
{
	ParentBody     "Kepler-758"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02243298318
		SemiMajorAxis   0.0858
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-759 b/KOI-1061.01"
{
	ParentBody     "Kepler-759"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1144609965
		SemiMajorAxis   0.2329
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-76 b/KOI-1658.01"
{
	ParentBody     "Kepler-76"
	Mass            639.582
	Radius          97229.12
	DiscMethod     "OrbitLight"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2456126.77
		Period          0.004229877717
		SemiMajorAxis   0.0274
		Eccentricity    0
		Inclination     77.55
	}
}

Planet	"Kepler-760 b/KOI-1069.01"
{
	ParentBody     "Kepler-760"
	Radius          19517.316
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02383129442
		SemiMajorAxis   0.0805
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-760 c/KOI-1069.02"
{
	ParentBody     "Kepler-760"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006754352204
		SemiMajorAxis   0.0347
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-761 b/KOI-1072.01"
{
	ParentBody     "Kepler-761"
	Radius          12940.052
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02772967683
		SemiMajorAxis   0.0904
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-762 b/KOI-1074.01"
{
	ParentBody     "Kepler-762"
	Radius          80857.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01032342978
		SemiMajorAxis   0.0486
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-763 b/KOI-1082.03"
{
	ParentBody     "Kepler-763"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003276049682
		SemiMajorAxis   0.0212
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-764 b/KOI-1083.01"
{
	ParentBody     "Kepler-764"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02008760095
		SemiMajorAxis   0.0722
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-765 b/KOI-1086.01"
{
	ParentBody     "Kepler-765"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0757456925
		SemiMajorAxis   0.1754
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-766 b/KOI-1094.01"
{
	ParentBody     "Kepler-766"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01670200817
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-767 b/KOI-1099.01"
{
	ParentBody     "Kepler-767"
	Radius          42323.264
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4422490462
		SemiMajorAxis   0.5733
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-768 b/KOI-1101.01"
{
	ParentBody     "Kepler-768"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03118753204
		SemiMajorAxis   0.0926
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-769 b/KOI-1106.01"
{
	ParentBody     "Kepler-769"
	Radius          18659.412
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02033196106
		SemiMajorAxis   0.0763
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-769 c/KOI-1106.02"
{
	ParentBody     "Kepler-769"
	Radius          11438.72
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04377100413
		SemiMajorAxis   0.1272
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-77 b/KOI-127.01"
{
	ParentBody     "Kepler-77"
	Mass            136.826
	Radius          68632.32
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.009798179946
		SemiMajorAxis   0.04501
		Eccentricity    0
		Inclination     88
	}
}

Planet	"Kepler-770 b/KOI-1108.01"
{
	ParentBody     "Kepler-770"
	Radius          14655.86
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05181603677
		SemiMajorAxis   0.1302
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-770 c/KOI-1108.02"
{
	ParentBody     "Kepler-770"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00403929872
		SemiMajorAxis   0.0238
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-770 d"
{
	ParentBody     "Kepler-770"
	Radius          8936.5
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01136902399
	}
}

Planet	"Kepler-771 b/KOI-1110.01"
{
	ParentBody     "Kepler-771"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02391525022
		SemiMajorAxis   0.0843
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-772 b/KOI-1115.01"
{
	ParentBody     "Kepler-772"
	Radius          11581.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03557111892
		SemiMajorAxis   0.1056
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-773 b/KOI-1116.01"
{
	ParentBody     "Kepler-773"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01026469604
		SemiMajorAxis   0.0465
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-774 b/KOI-1117.01"
{
	ParentBody     "Kepler-774"
	Radius          20232.236
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03036224349
		SemiMajorAxis   0.1068
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-775 b/KOI-1128.01"
{
	ParentBody     "Kepler-775"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002669102741
		SemiMajorAxis   0.0187
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-776 b/KOI-1129.01"
{
	ParentBody     "Kepler-776"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01340805629
		SemiMajorAxis   0.0523
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-777 b/KOI-1141.01"
{
	ParentBody     "Kepler-777"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0156830896
		SemiMajorAxis   0.0526
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-778 b/KOI-1142.01"
{
	ParentBody     "Kepler-778"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01028288726
		SemiMajorAxis   0.0453
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-779 b/KOI-1146.01"
{
	ParentBody     "Kepler-779"
	Radius          5862.344
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01943133194
		SemiMajorAxis   0.0537
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-78 b"
{
	ParentBody     "Kepler-78"
	Mass            1.691967404
	Radius          7653.720499
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.0009719782103
		SemiMajorAxis   0.01
		Eccentricity    0
		Inclination     79
	}
}

Planet	"Kepler-780 b/KOI-1150.01"
{
	ParentBody     "Kepler-780"
	Radius          5647.868
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001854591772
		SemiMajorAxis   0.0149
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-781 b/KOI-1160.01"
{
	ParentBody     "Kepler-781"
	Radius          18444.936
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03617893433
		SemiMajorAxis   0.1016
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-782 b/KOI-1162.01"
{
	ParentBody     "Kepler-782"
	Radius          20446.712
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.434466048
		SemiMajorAxis   0.5692
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-783 b/KOI-1165.02"
{
	ParentBody     "Kepler-783"
	Radius          5004.44
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01175287658
		SemiMajorAxis   0.0487
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-784 b/KOI-1175.01"
{
	ParentBody     "Kepler-784"
	Radius          10080.372
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08649675606
		SemiMajorAxis   0.1997
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-785 b/KOI-1176.01"
{
	ParentBody     "Kepler-785"
	Radius          83073.704
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005403978469
		SemiMajorAxis   0.0249
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-786 b/KOI-1199.01"
{
	ParentBody     "Kepler-786"
	Radius          15513.764
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1465585033
		SemiMajorAxis   0.2554
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-787 b/KOI-1202.01"
{
	ParentBody     "Kepler-787"
	Radius          8150.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002541629981
		SemiMajorAxis   0.017
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-788 b/KOI-1204.01"
{
	ParentBody     "Kepler-788"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02299422937
		SemiMajorAxis   0.0832
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-789 b/KOI-1205.01"
{
	ParentBody     "Kepler-789"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02365136748
		SemiMajorAxis   0.0836
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-79 b/KOI-152.03"
{
	ParentBody     "Kepler-79"
	Mass            10.91426
	Radius          22162.52
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03691933839
		SemiMajorAxis   0.117
		Eccentricity    0.015
		Inclination     88.78
	}
}

Planet	"Kepler-79 c/KOI-152.02"
{
	ParentBody     "Kepler-79"
	Mass            6.0458
	Radius          23735.344
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.07502665563
		SemiMajorAxis   0.187
		Eccentricity    0.03
		Inclination     89.48
	}
}

Planet	"Kepler-79 d/KOI-152.01"
{
	ParentBody     "Kepler-79"
	Mass            6.0458
	Radius          45683.388
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1426182447
		SemiMajorAxis   0.287
		Eccentricity    0.025
		Inclination     89.93
	}
}

Planet	"Kepler-79 e/KOI-152.04"
{
	ParentBody     "Kepler-79"
	Mass            4.1366
	Radius          22234.012
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.2219510841
		SemiMajorAxis   0.386
		Eccentricity    0.012
		Inclination     89.13
	}
}

Planet	"Kepler-790 b/KOI-1207.01"
{
	ParentBody     "Kepler-790"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03760435802
		SemiMajorAxis   0.101
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-791 b/KOI-1210.01"
{
	ParentBody     "Kepler-791"
	Radius          19445.824
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03984746643
		SemiMajorAxis   0.1248
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-792 b/KOI-1212.01"
{
	ParentBody     "Kepler-792"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0309416395
		SemiMajorAxis   0.0991
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-793 b/KOI-1214.01"
{
	ParentBody     "Kepler-793"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01161294206
		SemiMajorAxis   0.0491
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-794 b/KOI-1216.01"
{
	ParentBody     "Kepler-794"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03047635686
		SemiMajorAxis   0.0972
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-795 b/KOI-1218.01"
{
	ParentBody     "Kepler-795"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08109507314
		SemiMajorAxis   0.1808
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-796 b/KOI-1220.01"
{
	ParentBody     "Kepler-796"
	Radius          8293.072
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01752501863
		SemiMajorAxis   0.0697
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-797 b/KOI-1238.01"
{
	ParentBody     "Kepler-797"
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07412171393
		SemiMajorAxis   0.1656
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-798 b/KOI-1245.01"
{
	ParentBody     "Kepler-798"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03756229174
		SemiMajorAxis   0.118
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-799 b/KOI-1261.01"
{
	ParentBody     "Kepler-799"
	Radius          43896.088
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3654028127
		SemiMajorAxis   0.5307
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-8 b/KOI-10.01"
{
	ParentBody     "Kepler-8"
	Mass            187.738
	Radius          101232.672
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.009644283158
		SemiMajorAxis   0.0474
		Eccentricity    0
		Inclination     83.978
	}
}

Planet	"Kepler-80 b/KOI-500.01"
{
	ParentBody     "Kepler-80"
	Radius          16872.112
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01931047452
		SemiMajorAxis   0.0604
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-80 c/KOI-500.02"
{
	ParentBody     "Kepler-80"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02607037266
		SemiMajorAxis   0.0738
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-80 d/KOI-500.03"
{
	ParentBody     "Kepler-80"
	Radius          11081.26
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008411366719
		SemiMajorAxis   0.037
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-80 e/KOI-500.04"
{
	ParentBody     "Kepler-80"
	Radius          10437.832
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01271864842
		SemiMajorAxis   0.049
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-80 f/KOI-500.05"
{
	ParentBody     "Kepler-80"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0027017335
		SemiMajorAxis   0.0163
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-800 b/KOI-1264.01"
{
	ParentBody     "Kepler-800"
	Radius          18158.968
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03869147829
		SemiMajorAxis   0.1107
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-801 b/KOI-1266.01"
{
	ParentBody     "Kepler-801"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0312649602
		SemiMajorAxis   0.0793
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-802 b/KOI-1273.01"
{
	ParentBody     "Kepler-802"
	Radius          22591.472
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1096772181
		SemiMajorAxis   0.2272
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-803 b/KOI-1275.01"
{
	ParentBody     "Kepler-803"
	Radius          24164.296
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1376795543
		SemiMajorAxis   0.2551
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-804 b/KOI-1279.01"
{
	ParentBody     "Kepler-804"
	Radius          12368.116
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03935627896
		SemiMajorAxis   0.1138
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-804 c/KOI-1279.02"
{
	ParentBody     "Kepler-804"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02642589065
		SemiMajorAxis   0.0873
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-805 b/KOI-1282.01"
{
	ParentBody     "Kepler-805"
	Radius          18444.936
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08450254094
		SemiMajorAxis   0.1996
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-806 b/KOI-1283.01"
{
	ParentBody     "Kepler-806"
	Radius          7292.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02215570009
		SemiMajorAxis   0.0786
		Eccentricity    0
		Inclination     79.64
	}
}

Planet	"Kepler-807 b/KOI-1288.01"
{
	ParentBody     "Kepler-807"
	Radius          66487.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3228846258
		SemiMajorAxis   0.4809
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-808 b/KOI-1300.01"
{
	ParentBody     "Kepler-808"
	Radius          9293.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001728530733
		SemiMajorAxis   0.0116
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-809 b/KOI-1302.01"
{
	ParentBody     "Kepler-809"
	Radius          19231.348
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1523354682
		SemiMajorAxis   0.2901
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-81 b/KOI-877.01"
{
	ParentBody     "Kepler-81"
	Radius          15442.272
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01630425007
		SemiMajorAxis   0.0524
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-81 c/KOI-877.02"
{
	ParentBody     "Kepler-81"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03296442836
		SemiMajorAxis   0.0837
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-81 d/KOI-877.03"
{
	ParentBody     "Kepler-81"
	Radius          7721.136
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.05705213302
		SemiMajorAxis   0.128
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-810 b/KOI-1304.01"
{
	ParentBody     "Kepler-810"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01258686422
		SemiMajorAxis   0.055
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-811 b/KOI-1308.01"
{
	ParentBody     "Kepler-811"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06457215958
		SemiMajorAxis   0.1612
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-812 b/KOI-1309.01"
{
	ParentBody     "Kepler-812"
	Radius          22662.964
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02769988131
		SemiMajorAxis   0.1021
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-813 b/KOI-1310.01"
{
	ParentBody     "Kepler-813"
	Radius          13654.972
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05237476365
		SemiMajorAxis   0.1424
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-814 b/KOI-1312.01"
{
	ParentBody     "Kepler-814"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01682988787
		SemiMajorAxis   0.0676
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-815 b/KOI-1314.01"
{
	ParentBody     "Kepler-815"
	Radius          26237.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02347766977
		SemiMajorAxis   0.0905
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-816 b/KOI-1320.01"
{
	ParentBody     "Kepler-816"
	Radius          65343.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.028766736
		SemiMajorAxis   0.0893
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-817 b/KOI-1323.01"
{
	ParentBody     "Kepler-817"
	Radius          57622.552
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01092454908
		SemiMajorAxis   0.0493
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-818 b/KOI-1325.01"
{
	ParentBody     "Kepler-818"
	Radius          32600.352
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02747597646
		SemiMajorAxis   0.0892
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-819 b/KOI-1329.01"
{
	ParentBody     "Kepler-819"
	Radius          17587.032
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09089739828
		SemiMajorAxis   0.1899
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-82 b/KOI-880.01"
{
	ParentBody     "Kepler-82"
	Radius          25522.644
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.07240127437
		SemiMajorAxis   0.1718
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-82 c/KOI-880.02"
{
	ParentBody     "Kepler-82"
	Radius          34101.684
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.1411063711
		SemiMajorAxis   0.2681
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-82 d/KOI-880.04"
{
	ParentBody     "Kepler-82"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006524331159
		SemiMajorAxis   0.034
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-82 e/KOI-880.03"
{
	ParentBody     "Kepler-82"
	Radius          15728.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01615970489
		SemiMajorAxis   0.063
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-820 b/KOI-1335.01"
{
	ParentBody     "Kepler-820"
	Radius          38820.156
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3499973808
		SemiMajorAxis   0.5102
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-821 b/KOI-1337.01"
{
	ParentBody     "Kepler-821"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005264448586
		SemiMajorAxis   0.0282
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-822 b/KOI-1338.01"
{
	ParentBody     "Kepler-822"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008824197641
		SemiMajorAxis   0.0412
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-823 b/KOI-1339.01"
{
	ParentBody     "Kepler-823"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01141185475
		SemiMajorAxis   0.0523
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-824 b/KOI-1341.01"
{
	ParentBody     "Kepler-824"
	Radius          11939.164
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0123599257
		SemiMajorAxis   0.0568
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-825 b"
{
	ParentBody     "Kepler-825"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01033177627
	}
}

Planet	"Kepler-825 c/KOI-1342.02"
{
	ParentBody     "Kepler-825"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02240109392
		SemiMajorAxis   0.0759
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-826 b/KOI-1344.01"
{
	ParentBody     "Kepler-826"
	Radius          8007.104
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01228661199
		SemiMajorAxis   0.0512
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-827 b/KOI-1355.01"
{
	ParentBody     "Kepler-827"
	Radius          35888.984
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1421776491
		SemiMajorAxis   0.2648
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-828 b/KOI-1367.01"
{
	ParentBody     "Kepler-828"
	Radius          9651.42
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001554741363
		SemiMajorAxis   0.0124
		Eccentricity    0
		Inclination     83.65
	}
}

Planet	"Kepler-829 b/KOI-1370.01"
{
	ParentBody     "Kepler-829"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01884605835
		SemiMajorAxis   0.0679
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-83 b/KOI-898.01"
{
	ParentBody     "Kepler-83"
	Radius          18015.984
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02674937417
		SemiMajorAxis   0.0729
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-83 c/KOI-898.03"
{
	ParentBody     "Kepler-83"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.05500459848
		SemiMajorAxis   0.1178
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-83 d/KOI-898.02"
{
	ParentBody     "Kepler-83"
	Radius          12368.116
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01415443271
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-830 b/KOI-1377.01"
{
	ParentBody     "Kepler-830"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03093002858
		SemiMajorAxis   0.0968
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-831 b/KOI-1379.01"
{
	ParentBody     "Kepler-831"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01539126521
		SemiMajorAxis   0.0585
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-832 b/KOI-1402.01"
{
	ParentBody     "Kepler-832"
	Radius          13154.528
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0195478351
		SemiMajorAxis   0.075
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-833 b/KOI-1403.01"
{
	ParentBody     "Kepler-833"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0513486676
		SemiMajorAxis   0.1139
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-834 b/KOI-1404.01"
{
	ParentBody     "Kepler-834"
	Radius          12868.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03647958363
		SemiMajorAxis   0.0862
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-835 b/KOI-1405.01"
{
	ParentBody     "Kepler-835"
	Radius          17801.508
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03126444334
		SemiMajorAxis   0.107
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-836 b/KOI-1406.01"
{
	ParentBody     "Kepler-836"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03110572542
		SemiMajorAxis   0.1016
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-837 b/KOI-1409.01"
{
	ParentBody     "Kepler-837"
	Radius          16300.176
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0453414077
		SemiMajorAxis   0.1144
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-838 b/KOI-1410.01"
{
	ParentBody     "Kepler-838"
	Radius          17444.048
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04312092189
		SemiMajorAxis   0.1266
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-839 b/KOI-1412.01"
{
	ParentBody     "Kepler-839"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1035325394
		SemiMajorAxis   0.2281
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-84 b/KOI-1589.01"
{
	ParentBody     "Kepler-84"
	Radius          14226.908
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02389099683
		SemiMajorAxis   0.0831
		Eccentricity    0
		Inclination     80.79
	}
}

Planet	"Kepler-84 c/KOI-1589.02"
{
	ParentBody     "Kepler-84"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03527248592
		SemiMajorAxis   0.1078
		Eccentricity    0
		Inclination     81.36
	}
}

Planet	"Kepler-84 d/KOI-1589.04"
{
	ParentBody     "Kepler-84"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01156639928
		SemiMajorAxis   0.052
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-84 e/KOI-1589.03"
{
	ParentBody     "Kepler-84"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.07511286966
		SemiMajorAxis   0.181
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-84 f/KOI-1589.05"
{
	ParentBody     "Kepler-84"
	Radius          14012.432
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.1219797993
		SemiMajorAxis   0.25
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-840 b"
{
	ParentBody     "Kepler-840"
	Radius          108882.316
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006833218312
	}
}

Planet	"Kepler-841 b/KOI-1423.01"
{
	ParentBody     "Kepler-841"
	Radius          33386.764
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3406502405
		SemiMajorAxis   0.4494
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-842 b/KOI-1424.01"
{
	ParentBody     "Kepler-842"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003339067347
		SemiMajorAxis   0.0204
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-843 b/KOI-1425.01"
{
	ParentBody     "Kepler-843"
	Radius          16514.652
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005623336726
		SemiMajorAxis   0.0315
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-844 b/KOI-1427.01"
{
	ParentBody     "Kepler-844"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007154214197
		SemiMajorAxis   0.0301
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-845 b/KOI-1428.01"
{
	ParentBody     "Kepler-845"
	Radius          13011.544
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00254039606
		SemiMajorAxis   0.017
		Eccentricity    0
		Inclination     73.34
	}
}

Planet	"Kepler-846 b/KOI-1433.01"
{
	ParentBody     "Kepler-846"
	Radius          15799.732
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05423229408
		SemiMajorAxis   0.1406
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-847 b/KOI-1434.01"
{
	ParentBody     "Kepler-847"
	Radius          7506.66
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006415556486
		SemiMajorAxis   0.0322
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-848 b/KOI-1438.01"
{
	ParentBody     "Kepler-848"
	Radius          10866.784
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01892263367
		SemiMajorAxis   0.0703
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-849 b/KOI-1439.01"
{
	ParentBody     "Kepler-849"
	Radius          45540.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          1.080446075
		SemiMajorAxis   1.1084
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-85 b/KOI-2038.01"
{
	ParentBody     "Kepler-85"
	Mass            14.7963
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02274107491
		SemiMajorAxis   0.0796
		Eccentricity    0
		Inclination     83.08
	}
}

Planet	"Kepler-85 c/KOI-2038.02"
{
	ParentBody     "Kepler-85"
	Mass            18.7738
	Radius          13869.448
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.03425945947
		SemiMajorAxis   0.1046
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-85 d/KOI-2038.03"
{
	ParentBody     "Kepler-85"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04904479958
		SemiMajorAxis   0.13
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-85 e/KOI-2038.04"
{
	ParentBody     "Kepler-85"
	Radius          8078.596
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.06904117788
		SemiMajorAxis   0.163
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-850 b/KOI-1440.01"
{
	ParentBody     "Kepler-850"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.019693888
		SemiMajorAxis   0.0744
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-851 b/KOI-1441.01"
{
	ParentBody     "Kepler-851"
	Radius          10723.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02329138532
		SemiMajorAxis   0.0802
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-852 b/KOI-1444.01"
{
	ParentBody     "Kepler-852"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1230169505
		SemiMajorAxis   0.2492
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-853 b/KOI-1445.01"
{
	ParentBody     "Kepler-853"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01962786564
		SemiMajorAxis   0.0777
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-854 b"
{
	ParentBody     "Kepler-854"
	Radius          106666.064
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005871810294
	}
}

Planet	"Kepler-855 b/KOI-1456.01"
{
	ParentBody     "Kepler-855"
	Radius          53261.54
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02159288089
		SemiMajorAxis   0.0762
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-856 b/KOI-1457.01"
{
	ParentBody     "Kepler-856"
	Radius          59338.36
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0219790616
		SemiMajorAxis   0.0787
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-857 b/KOI-1472.01"
{
	ParentBody     "Kepler-857"
	Radius          43395.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2336841051
		SemiMajorAxis   0.3629
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-858 b/KOI-1478.01"
{
	ParentBody     "Kepler-858"
	Radius          31027.528
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2084535204
		SemiMajorAxis   0.3355
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-859 b/KOI-1480.01"
{
	ParentBody     "Kepler-859"
	Radius          19731.792
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05580345397
		SemiMajorAxis   0.1343
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-860 b/KOI-1481.01"
{
	ParentBody     "Kepler-860"
	Radius          20661.188
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0139671144
		SemiMajorAxis   0.058
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-861 b/KOI-1488.01"
{
	ParentBody     "Kepler-861"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01081373261
		SemiMajorAxis   0.0463
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-862 b/KOI-1491.01"
{
	ParentBody     "Kepler-862"
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008620758
		SemiMajorAxis   0.039
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-863 b/KOI-1495.01"
{
	ParentBody     "Kepler-863"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04269665218
		SemiMajorAxis   0.122
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-864 b/KOI-1498.01"
{
	ParentBody     "Kepler-864"
	Radius          15299.288
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01597230846
		SemiMajorAxis   0.0686
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-865 b/KOI-1499.01"
{
	ParentBody     "Kepler-865"
	Radius          15871.224
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03877972845
		SemiMajorAxis   0.1057
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-866 b/KOI-1501.01"
{
	ParentBody     "Kepler-866"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007165197813
		SemiMajorAxis   0.0331
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-867 b/KOI-1503.01"
{
	ParentBody     "Kepler-867"
	Radius          29597.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4113493216
		SemiMajorAxis   0.5154
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-868 b/KOI-1505.01"
{
	ParentBody     "Kepler-868"
	Radius          13083.036
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01377857775
		SemiMajorAxis   0.0575
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-869 b/KOI-1506.01"
{
	ParentBody     "Kepler-869"
	Radius          23020.424
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1106903217
		SemiMajorAxis   0.2241
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-87 b/KOI-1574.01"
{
	ParentBody     "Kepler-87"
	Mass            324.564
	Radius          86076.368
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.3141377234
		SemiMajorAxis   0.481
		Eccentricity    0.036
		Inclination     89.274
		ArgOfPericen    238.6
	}
}

Planet	"Kepler-87 c/KOI-1574.02"
{
	ParentBody     "Kepler-87"
	Mass            6.364
	Radius          39177.616
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.5235753298
		SemiMajorAxis   0.676
		Eccentricity    0.039
		Inclination     89.588
		ArgOfPericen    223.2
	}
}

Planet	"Kepler-870 b/KOI-1507.01"
{
	ParentBody     "Kepler-870"
	Radius          17730.016
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05847835407
		SemiMajorAxis   0.1539
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-871 b/KOI-1508.01"
{
	ParentBody     "Kepler-871"
	Radius          23878.328
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06035968027
		SemiMajorAxis   0.1572
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-872 b/KOI-1511.01"
{
	ParentBody     "Kepler-872"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007060671362
		SemiMajorAxis   0.0362
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-873 b/KOI-1516.01"
{
	ParentBody     "Kepler-873"
	Radius          23949.82
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05627330295
		SemiMajorAxis   0.1568
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-874 b/KOI-1517.01"
{
	ParentBody     "Kepler-874"
	Radius          25165.184
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1097043929
		SemiMajorAxis   0.2234
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-875 b/KOI-1518.01"
{
	ParentBody     "Kepler-875"
	Radius          18516.428
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07531271212
		SemiMajorAxis   0.1771
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-876 b/KOI-1519.01"
{
	ParentBody     "Kepler-876"
	Radius          9150.976
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01408484631
		SemiMajorAxis   0.0563
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-877 b/KOI-1520.01"
{
	ParentBody     "Kepler-877"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05053761992
		SemiMajorAxis   0.1303
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-878 b/KOI-1521.01"
{
	ParentBody     "Kepler-878"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07102740051
		SemiMajorAxis   0.154
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-879 b/KOI-1522.01"
{
	ParentBody     "Kepler-879"
	Radius          16371.668
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09140672882
		SemiMajorAxis   0.2012
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-88 b/KOI-142.01"
{
	ParentBody     "Kepler-88"
	Mass            8.710128056
	Radius          24109.21957
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02999149689
		SemiMajorAxis   0.098
		Eccentricity    0.05593
		Inclination     89.055
		ArgOfPericen    90.59
	}
}

Planet	"Kepler-88 c"
{
	ParentBody     "Kepler-88"
	Mass            199.0314319
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Period          0.06116352552
		SemiMajorAxis   0.1529
		Eccentricity    0.05628
		Inclination     86.2
		ArgOfPericen    270.76
	}
}

Planet	"Kepler-880 b/KOI-1525.01"
{
	ParentBody     "Kepler-880"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02112212106
		SemiMajorAxis   0.0854
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-881 b/KOI-1526.01"
{
	ParentBody     "Kepler-881"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01216858373
		SemiMajorAxis   0.0546
		Eccentricity    0
		Inclination     80.21
	}
}

Planet	"Kepler-882 b/KOI-1528.01"
{
	ParentBody     "Kepler-882"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01092299789
		SemiMajorAxis   0.0451
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-883 b/KOI-1530.01"
{
	ParentBody     "Kepler-883"
	Radius          11367.228
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03555163147
		SemiMajorAxis   0.102
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-884 b/KOI-1531.01"
{
	ParentBody     "Kepler-884"
	Radius          7864.12
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01560387956
		SemiMajorAxis   0.0625
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-885 b/KOI-1532.01"
{
	ParentBody     "Kepler-885"
	Radius          15942.716
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04959648692
		SemiMajorAxis   0.1441
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-886 b/KOI-1533.01"
{
	ParentBody     "Kepler-886"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01708856163
		SemiMajorAxis   0.0671
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-887 b/KOI-1534.01"
{
	ParentBody     "Kepler-887"
	Radius          11724.688
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05591437284
		SemiMajorAxis   0.1543
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-887 c/KOI-1534.02"
{
	ParentBody     "Kepler-887"
	Radius          7220.692
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02091341155
		SemiMajorAxis   0.0801
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-888 b/KOI-1535.01"
{
	ParentBody     "Kepler-888"
	Radius          11224.244
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1935644569
		SemiMajorAxis   0.3341
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-889 b/KOI-1536.01"
{
	ParentBody     "Kepler-889"
	Radius          6934.724
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01025193448
		SemiMajorAxis   0.0486
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-89 b/KOI-94.04"
{
	ParentBody     "Kepler-89"
	Mass            10.5006
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01024866569
		SemiMajorAxis   0.05
		Eccentricity    0.25
		Inclination     89.3
	}
}

Planet	"Kepler-89 c/KOI-94.02"
{
	ParentBody     "Kepler-89"
	Mass            15.5918
	Radius          27595.912
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02853916467
		SemiMajorAxis   0.099
		Eccentricity    0.43
		Inclination     88.36
	}
}

Planet	"Kepler-89 d/KOI-94.01"
{
	ParentBody     "Kepler-89"
	Mass            52.1848
	Radius          70062.16
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.0611731093
		SemiMajorAxis   0.165
		Eccentricity    0.022
		Inclination     89.871
	}
}

Planet	"Kepler-89 e/KOI-94.03"
{
	ParentBody     "Kepler-89"
	Mass            13.0462
	Radius          39320.6
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.148723046
		SemiMajorAxis   0.298
		Eccentricity    0.019
		Inclination     89.76
	}
}

Planet	"Kepler-890 b/KOI-1553.01"
{
	ParentBody     "Kepler-890"
	Radius          56693.156
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1444486898
		SemiMajorAxis   0.2948
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-891 b/KOI-1564.01"
{
	ParentBody     "Kepler-891"
	Radius          40893.424
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1463397642
		SemiMajorAxis   0.2881
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-892 b/KOI-1569.01"
{
	ParentBody     "Kepler-892"
	Radius          17944.492
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03765202264
		SemiMajorAxis   0.1014
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-893 b/KOI-1570.01"
{
	ParentBody     "Kepler-893"
	Radius          19302.84
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01735439603
		SemiMajorAxis   0.0699
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-894 b/KOI-1572.01"
{
	ParentBody     "Kepler-894"
	Radius          17730.016
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02684033847
		SemiMajorAxis   0.0916
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-895 b/KOI-1577.01"
{
	ParentBody     "Kepler-895"
	Radius          9794.404
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007683237063
		SemiMajorAxis   0.0319
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-896 b/KOI-1581.02"
{
	ParentBody     "Kepler-896"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3957576644
		SemiMajorAxis   0.5162
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-897 b/KOI-1583.01"
{
	ParentBody     "Kepler-897"
	Radius          15227.796
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02203267975
		SemiMajorAxis   0.077
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-898 b/KOI-1584.01"
{
	ParentBody     "Kepler-898"
	Radius          9508.436
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01607322282
		SemiMajorAxis   0.0534
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-899 b/KOI-1585.01"
{
	ParentBody     "Kepler-899"
	Radius          17086.588
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05251012469
		SemiMajorAxis   0.1392
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-9 b/KOI-377.01"
{
	ParentBody     "Kepler-9"
	Mass            45.15250291
	Radius          70796.91462
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.05263406182
		SemiMajorAxis   0.143
		Eccentricity    0.0626
		Inclination     87.1
		ArgOfPericen    356.9
	}
}

Planet	"Kepler-9 c/KOI-377.02"
{
	ParentBody     "Kepler-9"
	Mass            31.03608847
	Radius          68245.67445
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.1068635034
		SemiMajorAxis   0.229
		Eccentricity    0.0684
		Inclination     87.2
		ArgOfPericen    169.3
	}
}

Planet	"Kepler-9 d/KOI-377.03"
{
	ParentBody     "Kepler-9"
	Mass            5.256111758
	Radius          12756.20083
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.004361081617
		SemiMajorAxis   0.0273
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-90 b/KOI-351.06"
{
	ParentBody     "Kepler-90"
	Radius          8364.564
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01918768202
		SemiMajorAxis   0.074
		Eccentricity    0
		Inclination     89.4
	}
}

Planet	"Kepler-90 c/KOI-351.05"
{
	ParentBody     "Kepler-90"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02387285818
		SemiMajorAxis   0.089
		Eccentricity    0
		Inclination     89.68
	}
}

Planet	"Kepler-90 d/KOI-351.03"
{
	ParentBody     "Kepler-90"
	Radius          18373.444
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.1635535863
		SemiMajorAxis   0.32
		Eccentricity    0
		Inclination     89.71
	}
}

Planet	"Kepler-90 e/KOI-351.04"
{
	ParentBody     "Kepler-90"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.251721002
		SemiMajorAxis   0.42
		Eccentricity    0
		Inclination     89.79
	}
}

Planet	"Kepler-90 f/KOI-351.07"
{
	ParentBody     "Kepler-90"
	Radius          18444.936
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.3420043015
		SemiMajorAxis   0.48
		Eccentricity    0.01
		Inclination     89.77
	}
}

Planet	"Kepler-90 g/KOI-351.02"
{
	ParentBody     "Kepler-90"
	Radius          51831.7
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.5766227885
		SemiMajorAxis   0.71
		Eccentricity    0
		Inclination     89.8
	}
}

Planet	"Kepler-90 h/KOI-351.01"
{
	ParentBody     "Kepler-90"
	Radius          72206.92
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.9078923498
		SemiMajorAxis   1.01
		Eccentricity    0
		Inclination     89.6
	}
}

Planet	"Kepler-900 b/KOI-1586.01"
{
	ParentBody     "Kepler-900"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01914156906
		SemiMajorAxis   0.0679
		Eccentricity    0
		Inclination     86.52
	}
}

Planet	"Kepler-901 b/KOI-1588.01"
{
	ParentBody     "Kepler-901"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009630580715
		SemiMajorAxis   0.0366
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-902 b/KOI-1595.01"
{
	ParentBody     "Kepler-902"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1098174193
		SemiMajorAxis   0.2281
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-903 b/KOI-1601.01"
{
	ParentBody     "Kepler-903"
	Radius          12797.068
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02833947553
		SemiMajorAxis   0.0912
		Eccentricity    0
		Inclination     80.79
	}
}

Planet	"Kepler-903 c/KOI-1601.02"
{
	ParentBody     "Kepler-903"
	Radius          16157.192
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1722770738
		SemiMajorAxis   0.3037
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-904 b/KOI-1603.01"
{
	ParentBody     "Kepler-904"
	Radius          11295.736
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00827305474
		SemiMajorAxis   0.0417
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-905 b/KOI-1606.01"
{
	ParentBody     "Kepler-905"
	Radius          9007.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01391609913
		SemiMajorAxis   0.0581
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-906 b/KOI-1609.01"
{
	ParentBody     "Kepler-906"
	Radius          13440.496
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1141653368
		SemiMajorAxis   0.2279
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-907 b/KOI-1613.01"
{
	ParentBody     "Kepler-907"
	Radius          7649.644
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0434402669
		SemiMajorAxis   0.1236
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-908 b/KOI-1615.01"
{
	ParentBody     "Kepler-908"
	Radius          7792.628
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.003670434323
		SemiMajorAxis   0.0248
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-909 b/KOI-1616.01"
{
	ParentBody     "Kepler-909"
	Radius          9365.452
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03814702564
		SemiMajorAxis   0.1188
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-91 b/KOI-2133.01"
{
	ParentBody     "Kepler-91"
	Mass            257.742
	Radius          97729.564
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01710256967
		SemiMajorAxis   0.0731
		Eccentricity    0.0519
		Inclination     69.68
		ArgOfPericen   -57.2
	}
}

Planet	"Kepler-910 b/KOI-1618.01"
{
	ParentBody     "Kepler-910"
	Radius          5218.916
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006473427977
		SemiMajorAxis   0.0376
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-911 b/KOI-1621.01"
{
	ParentBody     "Kepler-911"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05560831022
		SemiMajorAxis   0.1586
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-912 b/KOI-1626.01"
{
	ParentBody     "Kepler-912"
	Radius          17873
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006939932846
		SemiMajorAxis   0.0339
		Eccentricity    0
		Inclination     73.91
	}
}

Planet	"Kepler-913 b/KOI-1627.01"
{
	ParentBody     "Kepler-913"
	Radius          13154.528
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02819150004
		SemiMajorAxis   0.0878
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-914 b/KOI-1629.01"
{
	ParentBody     "Kepler-914"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01207326427
		SemiMajorAxis   0.0546
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-915 b/KOI-1632.01"
{
	ParentBody     "Kepler-915"
	Radius          9579.928
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01258040875
		SemiMajorAxis   0.0542
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-916 b/KOI-1633.01"
{
	ParentBody     "Kepler-916"
	Radius          11224.244
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0884259286
		SemiMajorAxis   0.1949
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-917 b/KOI-1637.01"
{
	ParentBody     "Kepler-917"
	Radius          12153.64
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008132725223
		SemiMajorAxis   0.0378
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-918 b/KOI-1641.01"
{
	ParentBody     "Kepler-918"
	Radius          11081.26
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01328945413
		SemiMajorAxis   0.0571
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-919 b/KOI-1643.01"
{
	ParentBody     "Kepler-919"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03024303913
		SemiMajorAxis   0.0981
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-92 b/KOI-285.01"
{
	ParentBody     "Kepler-92"
	Mass            60.1398
	Radius          23306.392
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.03764333196
		SemiMajorAxis   0.1194
		Eccentricity    0.17
		Inclination     87.66
	}
}

Planet	"Kepler-92 c/KOI-285.02"
{
	ParentBody     "Kepler-92"
	Mass            5.69578
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.07316545225
		SemiMajorAxis   0.186
		Eccentricity    0.04
		Inclination     89.38
	}
}

Planet	"Kepler-92 d/KOI-285.03"
{
	ParentBody     "Kepler-92"
	Radius          13183.1248
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.1351344433
		SemiMajorAxis   0.2801
		Eccentricity    0.07
		Inclination     89.95
	}
}

Planet	"Kepler-920 b/KOI-1650.01"
{
	ParentBody     "Kepler-920"
	Radius          15442.272
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.017883824
		SemiMajorAxis   0.0686
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-920 c/KOI-1650.02"
{
	ParentBody     "Kepler-920"
	Radius          24235.788
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2760563103
		SemiMajorAxis   0.425
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-921 b/KOI-1651.01"
{
	ParentBody     "Kepler-921"
	Radius          18301.952
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1404564846
		SemiMajorAxis   0.2716
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-922 b/KOI-1655.01"
{
	ParentBody     "Kepler-922"
	Radius          9079.484
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002569437092
		SemiMajorAxis   0.0186
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-923 b/KOI-1665.01"
{
	ParentBody     "Kepler-923"
	Radius          8793.516
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01898374545
		SemiMajorAxis   0.0759
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-924 b/KOI-1669.01"
{
	ParentBody     "Kepler-924"
	Radius          19588.808
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1671138039
		SemiMajorAxis   0.3101
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-925 b/KOI-1672.01"
{
	ParentBody     "Kepler-925"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09272711105
		SemiMajorAxis   0.1805
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-926 b/KOI-1677.01"
{
	ParentBody     "Kepler-926"
	Radius          14727.352
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.142559818
		SemiMajorAxis   0.2616
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-927 b/KOI-1683.01"
{
	ParentBody     "Kepler-927"
	Radius          10938.276
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.024956017
		SemiMajorAxis   0.0866
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-928 b/KOI-1687.01"
{
	ParentBody     "Kepler-928"
	Radius          10151.864
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01076672249
		SemiMajorAxis   0.0444
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-929 b/KOI-1688.01"
{
	ParentBody     "Kepler-929"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.002521702491
		SemiMajorAxis   0.0169
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-93 b/KOI-69.01"
{
	ParentBody     "Kepler-93"
	Mass            4.00932
	Radius          9458.722917
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2454944.292
		Period          0.01294138495
		SemiMajorAxis   0.053
		Eccentricity    0
		Inclination     89.49
	}
}

Planet	"Kepler-93 c"
{
	ParentBody     "Kepler-93"
	Mass            954.6
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          3.997347625
	}
}

Planet	"Kepler-930 b/KOI-1695.01"
{
	ParentBody     "Kepler-930"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1956284884
		SemiMajorAxis   0.3475
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-931 b/KOI-1700.01"
{
	ParentBody     "Kepler-931"
	Radius          8507.548
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02200610716
		SemiMajorAxis   0.0719
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-932 b/KOI-1706.01"
{
	ParentBody     "Kepler-932"
	Radius          8722.024
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005260721388
		SemiMajorAxis   0.0279
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-933 b/KOI-1710.01"
{
	ParentBody     "Kepler-933"
	Radius          15656.748
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0388904417
		SemiMajorAxis   0.1039
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-934 b/KOI-1711.01"
{
	ParentBody     "Kepler-934"
	Radius          13297.512
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1524299012
		SemiMajorAxis   0.2709
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-935 b/KOI-1716.01"
{
	ParentBody     "Kepler-935"
	Radius          8579.04
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01336329333
		SemiMajorAxis   0.0527
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-936 b/KOI-1717.01"
{
	ParentBody     "Kepler-936"
	Radius          9222.468
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02891599739
		SemiMajorAxis   0.0954
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-937 b/KOI-1718.01"
{
	ParentBody     "Kepler-937"
	Radius          23735.344
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1852711129
		SemiMajorAxis   0.3212
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-937 c/KOI-1718.02"
{
	ParentBody     "Kepler-937"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.4198402273
		SemiMajorAxis   0.5542
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-938 b/KOI-1721.01"
{
	ParentBody     "Kepler-938"
	Radius          14155.416
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1440957347
		SemiMajorAxis   0.2663
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-939 b/KOI-1722.01"
{
	ParentBody     "Kepler-939"
	Radius          11152.752
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04073542546
		SemiMajorAxis   0.115
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-94 b/KOI-104.01"
{
	ParentBody     "Kepler-94"
	Mass            10.853802
	Radius          22376.996
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006866840879
		SemiMajorAxis   0.0311
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-94 c"
{
	ParentBody     "Kepler-94"
	Msini           3129.8152
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          2.245085652
	}
}

Planet	"Kepler-940 b/KOI-1723.01"
{
	ParentBody     "Kepler-940"
	Radius          21304.616
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1632410695
		SemiMajorAxis   0.3059
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-941 b/KOI-1724.01"
{
	ParentBody     "Kepler-941"
	Radius          19660.3
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04770520072
		SemiMajorAxis   0.1311
		Eccentricity    0
		Inclination     85.37
	}
}

Planet	"Kepler-942 b/KOI-1726.01"
{
	ParentBody     "Kepler-942"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.123107834
		SemiMajorAxis   0.2245
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-943 b/KOI-1727.01/KIC 6185331 b"
{
	ParentBody     "Kepler-943"
	Radius          37819.268
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1362661412
		SemiMajorAxis   0.2672
		Eccentricity    0
		Inclination     89.2
	}
}

Planet	"Kepler-944 b/KOI-1732.01"
{
	ParentBody     "Kepler-944"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1185973989
		SemiMajorAxis   0.229
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-945 b/KOI-1736.01"
{
	ParentBody     "Kepler-945"
	Radius          16800.62
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.08488444726
		SemiMajorAxis   0.2014
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-946 b/KOI-1746.01"
{
	ParentBody     "Kepler-946"
	Radius          12296.624
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0322844021
		SemiMajorAxis   0.0997
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-947 b/KOI-1749.01"
{
	ParentBody     "Kepler-947"
	Radius          14512.876
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07382616918
		SemiMajorAxis   0.1773
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-948 b/KOI-1750.01"
{
	ParentBody     "Kepler-948"
	Radius          11796.18
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02126935616
		SemiMajorAxis   0.0743
		Eccentricity    0
		Inclination     78.5
	}
}

Planet	"Kepler-949 b/KOI-1751.01"
{
	ParentBody     "Kepler-949"
	Radius          18587.92
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02379053554
		SemiMajorAxis   0.0774
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-95 b/KOI-122.01"
{
	ParentBody     "Kepler-95"
	Mass            13.0462
	Radius          21805.06
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.03154920302
		SemiMajorAxis   0.1026
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-950 b/KOI-1787.01"
{
	ParentBody     "Kepler-950"
	Radius          57265.092
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2702810446
		SemiMajorAxis   0.3993
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-951 b/KOI-1788.01"
{
	ParentBody     "Kepler-951"
	Radius          35674.508
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1958298095
		SemiMajorAxis   0.3114
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-952 b/KOI-1790.01"
{
	ParentBody     "Kepler-952"
	Radius          48757.544
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3568993274
		SemiMajorAxis   0.5183
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-953 b/KOI-1792.01/KIC 8552719 b"
{
	ParentBody     "Kepler-953"
	Radius          26880.992
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2420491253
		SemiMajorAxis   0.19757
		Eccentricity    0
		Inclination     89.53
	}
}

Planet	"Kepler-953 c/KOI-1792.03"
{
	ParentBody     "Kepler-953"
	Radius          7578.152
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02494145357
		SemiMajorAxis   0.0878
		Eccentricity    0
		Inclination     88.24
	}
}

Planet	"Kepler-954 b/KOI-1797.01"
{
	ParentBody     "Kepler-954"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04594695379
		SemiMajorAxis   0.1157
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-955 b/KOI-1801.01"
{
	ParentBody     "Kepler-955"
	Radius          19946.268
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.0397885078
		SemiMajorAxis   0.1083
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-956 b/KOI-1802.01"
{
	ParentBody     "Kepler-956"
	Radius          19159.856
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01437038977
		SemiMajorAxis   0.0609
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-957 b/KOI-1804.01"
{
	ParentBody     "Kepler-957"
	Radius          35102.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01617396266
		SemiMajorAxis   0.0559
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-958 b/KOI-1813.01"
{
	ParentBody     "Kepler-958"
	Radius          13154.528
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02674357117
		SemiMajorAxis   0.0867
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-959 b/KOI-1814.01"
{
	ParentBody     "Kepler-959"
	Radius          27953.372
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04052310705
		SemiMajorAxis   0.1324
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-96 b/KOI-261.01"
{
	ParentBody     "Kepler-96"
	Mass            8.5914
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.04445954069
		SemiMajorAxis   0.1257
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-960 b/KOI-1815.01"
{
	ParentBody     "Kepler-960"
	Radius          14584.368
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.008561065279
		SemiMajorAxis   0.0414
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-961 b/KOI-1818.01"
{
	ParentBody     "Kepler-961"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04620844637
		SemiMajorAxis   0.128
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-962 b/KOI-1819.01"
{
	ParentBody     "Kepler-962"
	Radius          12582.592
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03301117101
		SemiMajorAxis   0.0933
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-963 b/KOI-1821.01"
{
	ParentBody     "Kepler-963"
	Radius          16943.604
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02731567526
		SemiMajorAxis   0.0849
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-964 b/KOI-1825.01"
{
	ParentBody     "Kepler-964"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03702340796
		SemiMajorAxis   0.114
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-965 b/KOI-1826.01"
{
	ParentBody     "Kepler-965"
	Radius          21590.584
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3675718018
		SemiMajorAxis   0.4971
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-966 b/KOI-1828.01"
{
	ParentBody     "Kepler-966"
	Radius          26309.056
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2730999451
		SemiMajorAxis   0.3907
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-967 b/KOI-1830.01"
{
	ParentBody     "Kepler-967"
	Radius          15013.32
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03621469304
		SemiMajorAxis   0.0933
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-967 c/KOI-1830.02"
{
	ParentBody     "Kepler-967"
	Radius          23306.392
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.5440533863
		SemiMajorAxis   0.568
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-968 b/KOI-1833.01"
{
	ParentBody     "Kepler-968"
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01011105462
		SemiMajorAxis   0.0388
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-968 c/KOI-1833.03"
{
	ParentBody     "Kepler-968"
	Radius          10795.292
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01563183301
		SemiMajorAxis   0.0518
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-969 b/KOI-1837.01"
{
	ParentBody     "Kepler-969"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.09356304488
		SemiMajorAxis   0.1943
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-969 c/KOI-1837.02"
{
	ParentBody     "Kepler-969"
	Radius          6291.296
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004607722346
		SemiMajorAxis   0.0261
		Eccentricity    0
		Inclination     85.94
	}
}

Planet	"Kepler-97 b/KOI-292.01"
{
	ParentBody     "Kepler-97"
	Mass            3.5002
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007081985794
		SemiMajorAxis   0.0357
		Eccentricity    0
		Inclination     81.93
	}
}

Planet	"Kepler-97 c"
{
	ParentBody     "Kepler-97"
	Mass            343.656
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Period          2.160210463
	}
}

Planet	"Kepler-970 b/KOI-1838.01"
{
	ParentBody     "Kepler-970"
	Radius          17658.524
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04582308062
		SemiMajorAxis   0.1139
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-971 b/KOI-1839.01"
{
	ParentBody     "Kepler-971"
	Radius          13583.48
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02625848663
		SemiMajorAxis   0.0827
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-972 b/KOI-1840.01"
{
	ParentBody     "Kepler-972"
	Radius          29669.18
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01927303506
		SemiMajorAxis   0.0733
		Eccentricity    0
		Inclination     81.36
	}
}

Planet	"Kepler-973 b/KOI-1841.01"
{
	ParentBody     "Kepler-973"
	Radius          12511.1
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1358214754
		SemiMajorAxis   0.2351
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-974 b"
{
	ParentBody     "Kepler-974"
	Radius          10008.88
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01148415114
	}
}

Planet	"Kepler-975 b/KOI-1845.01"
{
	ParentBody     "Kepler-975"
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005394619008
		SemiMajorAxis   0.0303
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-976 b/KOI-1846.01"
{
	ParentBody     "Kepler-976"
	Radius          25236.676
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2900990569
		SemiMajorAxis   0.4209
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-977 b/KOI-1847.01"
{
	ParentBody     "Kepler-977"
	Radius          16729.128
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07352185472
		SemiMajorAxis   0.162
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-978 b/KOI-1848.01"
{
	ParentBody     "Kepler-978"
	Radius          19088.364
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.13586095
		SemiMajorAxis   0.2682
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-979 b/KOI-1849.01"
{
	ParentBody     "Kepler-979"
	Radius          17372.556
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02214424764
		SemiMajorAxis   0.0743
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-98 b/KOI-299.01"
{
	ParentBody     "Kepler-98"
	Mass            3.5002
	Radius          12725.576
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004220980059
		SemiMajorAxis   0.026
		Eccentricity    0
		Inclination     74.48
	}
}

Planet	"Kepler-980 b/KOI-1850.01"
{
	ParentBody     "Kepler-980"
	Radius          17015.096
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.03162565925
		SemiMajorAxis   0.0974
		Eccentricity    0
		Inclination     84.8
	}
}

Planet	"Kepler-981 b/KOI-1851.01"
{
	ParentBody     "Kepler-981"
	Radius          14727.352
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01223779143
		SemiMajorAxis   0.0535
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-982 b/KOI-1852.01"
{
	ParentBody     "Kepler-982"
	Radius          14369.892
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04318729473
		SemiMajorAxis   0.1287
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-983 b/KOI-1853.01"
{
	ParentBody     "Kepler-983"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1645086736
		SemiMajorAxis   0.3061
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-984 b/KOI-1854.01"
{
	ParentBody     "Kepler-984"
	Radius          13511.988
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1178238122
		SemiMajorAxis   0.2364
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-985 b/KOI-1858.01"
{
	ParentBody     "Kepler-985"
	Radius          19016.872
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.3185061973
		SemiMajorAxis   0.4636
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-986 b/KOI-1862.01"
{
	ParentBody     "Kepler-986"
	Radius          15084.812
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.1545138962
		SemiMajorAxis   0.2863
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-987 b/KOI-1866.01"
{
	ParentBody     "Kepler-987"
	Radius          20804.172
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2883109283
		SemiMajorAxis   0.4445
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-988 b/KOI-1868.01"
{
	ParentBody     "Kepler-988"
	Radius          13226.02
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04862746151
		SemiMajorAxis   0.11
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-989 b/KOI-1870.01"
{
	ParentBody     "Kepler-989"
	Radius          14083.924
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02180557332
		SemiMajorAxis   0.0734
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-99 b/KOI-305.01"
{
	ParentBody     "Kepler-99"
	Mass            6.0458
	Radius          9436.944
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01260418464
		SemiMajorAxis   0.0492
		Eccentricity    0
		Inclination     84.22
	}
}

Planet	"Kepler-990 b/KOI-1875.01"
{
	ParentBody     "Kepler-990"
	Radius          16586.144
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.02715248828
		SemiMajorAxis   0.089
		Eccentricity    0
		Inclination     87.09
	}
}

Planet	"Kepler-990 c/KOI-1875.02"
{
	ParentBody     "Kepler-990"
	Radius          9722.912
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.001473965289
		SemiMajorAxis   0.0128
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-991 b/KOI-1876.01"
{
	ParentBody     "Kepler-991"
	Radius          16228.684
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.2259712985
		SemiMajorAxis   0.3067
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-992 b/KOI-1877.01"
{
	ParentBody     "Kepler-992"
	Radius          10366.34
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.05519719567
		SemiMajorAxis   0.1423
		Eccentricity    0
		Inclination     87.66
	}
}

Planet	"Kepler-993 b/KOI-1879.01"
{
	ParentBody     "Kepler-993"
	Radius          18945.38
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.06046830362
		SemiMajorAxis   0.1165
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-994 b/KOI-1880.01"
{
	ParentBody     "Kepler-994"
	Radius          10223.356
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00315178953
		SemiMajorAxis   0.0175
		Eccentricity    0
		Inclination     79.07
	}
}

Planet	"Kepler-995 b/KOI-1881.01"
{
	ParentBody     "Kepler-995"
	Radius          17229.572
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.07739335024
		SemiMajorAxis   0.1645
		Eccentricity    0
		Inclination     89.95
	}
}

Planet	"Kepler-996 b/KOI-1882.01"
{
	ParentBody     "Kepler-996"
	Radius          12654.084
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01032353514
		SemiMajorAxis   0.0462
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-997 b/KOI-1883.01"
{
	ParentBody     "Kepler-997"
	Radius          8650.532
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.007412360333
		SemiMajorAxis   0.0382
		Eccentricity    0
		Inclination     88.81
	}
}

Planet	"Kepler-998 b/KOI-1885.01"
{
	ParentBody     "Kepler-998"
	Radius          14798.844
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01547952971
		SemiMajorAxis   0.0626
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"Kepler-999 b/KOI-1886.01"
{
	ParentBody     "Kepler-999"
	Radius          14941.828
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01640516125
		SemiMajorAxis   0.066
		Eccentricity    0
		Inclination     89.38
	}
}

Planet	"LKCA 15 b/LkCa 15 b"
{
	ParentBody     "LKCA 15"
	Mass            1909.2
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		Period          109.5163733
		SemiMajorAxis   14.7
		Inclination     50
	}
}

Planet	"LkCa 15 c"
{
	ParentBody     "LKCA 15"
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   18.6
		Inclination     50
	}
}

Planet	"Lupus-TR-3 b"
{
	ParentBody     "Lupus-TR-3"
	Mass            257.742
	Radius          63627.88
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.01071631402
		SemiMajorAxis   0.0464
		Eccentricity    0
		Inclination     88.3
	}
}

Planet	"MOA-2007-BLG-192L b"
{
	ParentBody     "MOA-2007-BLG-192L"
	Mass            3.182
	DiscMethod     "MicroLens"
	DiscDate       "2008"
	Orbit
	{
		SemiMajorAxis   0.62
	}
}

Planet	"MOA-2007-BLG-197L b"
{
	ParentBody     "MOA-2007-BLG-197L"
	Mass            13046.2
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   4.29
	}
}

Planet	"MOA-2007-BLG-400L b"
{
	ParentBody     "MOA-2007-BLG-400L"
	Mass            264.106
	DiscMethod     "MicroLens"
	DiscDate       "2008"
	Orbit
	{
		SemiMajorAxis   0.72
	}
}

Planet	"MOA-2008-BLG-310L b"
{
	ParentBody     "MOA-2008-BLG-310L"
	Mass            73.186
	DiscMethod     "MicroLens"
	DiscDate       "2009"
	Orbit
	{
		SemiMajorAxis   1.25
	}
}

Planet	"MOA-2008-BLG-379L b"
{
	ParentBody     "MOA-2008-BLG-379L"
	Mass            1304.62
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   3.3
	}
}

Planet	"MOA-2009-BLG-266L b"
{
	ParentBody     "MOA-2009-BLG-266L"
	Mass            10.5006
	DiscMethod     "MicroLens"
	DiscDate       "2011"
	Orbit
	{
		Period          7.594960487
		SemiMajorAxis   3.2
	}
}

Planet	"MOA-2009-BLG-319L b"
{
	ParentBody     "MOA-2009-BLG-319L"
	Mass            50.912
	DiscMethod     "MicroLens"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   2.4
	}
}

Planet	"MOA-2009-BLG-387L b"
{
	ParentBody     "MOA-2009-BLG-387L"
	Mass            814.592
	DiscMethod     "MicroLens"
	DiscDate       "2010"
	Orbit
	{
		Period          5.426536296
		SemiMajorAxis   1.82
		Inclination     52
	}
}

Planet	"MOA-2010-BLG-073L b"
{
	ParentBody     "MOA-2010-BLG-073L"
	Mass            3500.2
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   1.21
	}
}

Planet	"MOA-2010-BLG-328L b"
{
	ParentBody     "MOA-2010-BLG-328L"
	Mass            9.21189
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   0.92
	}
}

Planet	"MOA-2010-BLG-353L b"
{
	ParentBody     "MOA-2010-BLG-353L"
	Mass            85.914
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   1.72
	}
}

Planet	"MOA-2010-BLG-477L b"
{
	ParentBody     "MOA-2010-BLG-477L"
	Mass            477.3
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   2
	}
}

Planet	"MOA-2011-BLG-028L b"
{
	ParentBody     "MOA-2011-BLG-028L"
	Mass            30.034898
	DiscMethod     "MicroLens"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   4.14
	}
}

Planet	"MOA-2011-BLG-262L b"
{
	ParentBody     "MOA-2011-BLG-262L"
	Mass            18.019666
	DiscMethod     "MicroLens"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   0.84
	}
}

Planet	"MOA-2011-BLG-274L b"
{
	ParentBody     "MOA-2011-BLG-274L"
	Mass            254.56
	DiscMethod     "MicroLens"
	DiscDate       "2014"
}

Planet	"MOA-2011-BLG-293L b"
{
	ParentBody     "MOA-2011-BLG-293L"
	Mass            1527.36
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   1.1
	}
}

Planet	"MOA-2011-BLG-322L b"
{
	ParentBody     "MOA-2011-BLG-322L"
	Mass            2481.96
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   3.6
	}
}

Planet	"MOA-2013-BLG-220L b"
{
	ParentBody     "MOA-2013-BLG-220L"
	Mass            60.06984866
	DiscMethod     "MicroLens"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   0.7
	}
}

Planet	"MOA-2013-BLG-605L b"
{
	ParentBody     "MOA-2013-BLG-605L"
	Mass            21.0012
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   4.2
	}
}

Planet	"MOA-bin-1L b"
{
	ParentBody     "MOA-bin-1L"
	Mass            1177.34
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   8.3
	}
}

Planet	"MU Leo b"
{
	ParentBody     "MU Leo"
	Msini           763.68
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2452921
		Period          0.979623959
		SemiMajorAxis   1.1
		Eccentricity    0.09
		ArgOfPericen    227.1
	}
}

Planet	"Majriti/UPS And A d"
{
	ParentBody     "UPS And A"
	Msini           1314.8024
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2450059.072
		Period          3.508463796
		SemiMajorAxis   2.55
		Eccentricity    0.316
		Inclination     25.609
		ArgOfPericen    252.991
	}
}

Planet	"Methuselah/PSR B1620-26 b"
{
	ParentBody     "PSR B1620-26"
	Mass            795.5
	DiscMethod     "Pulsar"
	DiscDate       "2003"
	Orbit
	{
		Period          100.0021383
		SemiMajorAxis   23
		Inclination     55
	}
}

Planet	"Meztli/HD 104985 b"
{
	ParentBody     "Tonatiuh"
	Msini           2641.06
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           2451927.5
		Period          0.5462266013
		SemiMajorAxis   0.95
		Eccentricity    0.09
		ArgOfPericen    203.5
	}
}

Planet	"NGC 2423 3 b/BD-13 2130 b"
{
	ParentBody     "NGC 2423 3"
	Msini           3372.92
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2453213
		Period          1.955688636
		SemiMajorAxis   2.1
		Eccentricity    0.21
		ArgOfPericen    18
	}
}

Planet	"NGC 2682 Sand 364 b"
{
	ParentBody     "NGC 2682 Sand 364"
	Msini           490.028
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456240.9
		Period          0.3332309448
		Eccentricity    0.35
		ArgOfPericen    273.51
	}
}

Planet	"NGC 2682 YBP 1194 b"
{
	ParentBody     "NGC 2682 YBP 1194"
	Msini           108.188
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455978.8
		Period          0.01905037313
		Eccentricity    0.24
		ArgOfPericen    98.62
	}
}

Planet	"NGC 2682 YBP 1514 b"
{
	ParentBody     "NGC 2682 YBP 1514"
	Msini           127.28
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2455986.3
		Period          0.01401261996
		Eccentricity    0.39
		ArgOfPericen    327.49
	}
}

Planet	"NGC 4349 127 b"
{
	ParentBody     "NGC 4349 127"
	Msini           6300.36
	DiscMethod     "RadVel"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454114
		Period          1.855754945
		SemiMajorAxis   2.38
		Eccentricity    0.19
		ArgOfPericen    61
	}
}

Planet	"NLTT 41135 b"
{
	ParentBody     "NLTT 41135"
	Mass            10723.34
	Radius          80785.96
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.007911120567
		SemiMajorAxis   0.024
		Inclination     87.42
	}
}

Planet	"NN Ser c"
{
	ParentBody     "NN Ser"
	Mass            2198.762
	DiscMethod     "Pulsar"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2454016
		Period          15.49656682
		SemiMajorAxis   5.38
		Eccentricity    0
		ArgOfPericen    43
	}
}

Planet	"NN Ser d"
{
	ParentBody     "NN Ser"
	Mass            725.496
	DiscMethod     "Pulsar"
	DiscDate       "2009"
	Orbit
	{
		Epoch           2454515
		Period          7.748283409
		SemiMajorAxis   3.39
		Eccentricity    0.2
		ArgOfPericen    74
	}
}

Planet	"NU Oph b"
{
	ParentBody     "NU Oph"
	Msini           7636.8
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2452034.2
		Period          1.451968077
		SemiMajorAxis   1.9
		Eccentricity    0.1256
		ArgOfPericen    9.6
	}
}

Planet	"NU Oph c"
{
	ParentBody     "NU Oph"
	Msini           8591.4
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453038
		Period          8.722979131
		SemiMajorAxis   6.1
		Eccentricity    0.165
		ArgOfPericen    4.6
	}
}

Planet	"NY Vir b"
{
	ParentBody     "NY Vir"
	Msini           884.596
	DiscMethod     "Pulsar"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2453472
		Period          8.180174917
		SemiMajorAxis   3.39
		Eccentricity    0.44
		ArgOfPericen    346
	}
}

Planet	"NY Vir c"
{
	ParentBody     "NY Vir"
	Mass            1428.718
	DiscMethod     "Pulsar"
	DiscDate       "2011"
	Orbit
	{
		Period          27.00057735
		SemiMajorAxis   7.54
	}
}

Planet	"OGLE-2003-BLG-235L b"
{
	ParentBody     "MOA-2003-BLG-053L"
	Mass            827.32
	DiscMethod     "MicroLens"
	DiscDate       "2004"
	Orbit
	{
		SemiMajorAxis   5.1
	}
}

Planet	"OGLE-2005-BLG-071L b"
{
	ParentBody     "OGLE-2005-BLG-071L"
	Mass            1113.7
	DiscMethod     "MicroLens"
	DiscDate       "2005"
	Orbit
	{
		Period          9.856473595
		SemiMajorAxis   3.6
	}
}

Planet	"OGLE-2005-BLG-169L b"
{
	ParentBody     "OGLE-2005-BLG-169L"
	Mass            14.12808
	DiscMethod     "MicroLens"
	DiscDate       "2005"
	Orbit
	{
		Period          9.035100795
		SemiMajorAxis   4
	}
}

Planet	"OGLE-2005-BLG-390L b"
{
	ParentBody     "OGLE-2005-BLG-390L"
	Mass            5.4094
	DiscMethod     "MicroLens"
	DiscDate       "2005"
	Orbit
	{
		Period          9.582682662
		SemiMajorAxis   2.1
	}
}

Planet	"OGLE-2006-BLG-109L b"
{
	ParentBody     "OGLE-2006-BLG-109L"
	Mass            231.3314
	DiscMethod     "MicroLens"
	DiscDate       "2008"
	Orbit
	{
		Period          4.900857704
		SemiMajorAxis   2.3
		Inclination     64
	}
}

Planet	"OGLE-2006-BLG-109L c"
{
	ParentBody     "OGLE-2006-BLG-109L"
	Mass            86.2322
	DiscMethod     "MicroLens"
	DiscDate       "2008"
	Orbit
	{
		Period          13.50063092
		SemiMajorAxis   4.5
		Eccentricity    0.15
		Inclination     64
	}
}

Planet	"OGLE-2007-BLG-368L b"
{
	ParentBody     "OGLE-2007-BLG-368L"
	Mass            19.092
	DiscMethod     "MicroLens"
	DiscDate       "2009"
	Orbit
	{
		SemiMajorAxis   3.3
	}
}

Planet	"OGLE-2008-BLG-092L b"
{
	ParentBody     "OGLE-2008-BLG-092L"
	Mass            57.276
	DiscMethod     "MicroLens"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   18
	}
}

Planet	"OGLE-2008-BLG-355L b"
{
	ParentBody     "OGLE-2008-BLG-355L"
	Mass            1463.72
	DiscMethod     "MicroLens"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   1.7
	}
}

Planet	"OGLE-2009-BLG-151L b"
{
	ParentBody     "MOA-2009-BLG-232L"
	Mass            2386.5
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   0.31
	}
}

Planet	"OGLE-2011-BLG-251L b"
{
	ParentBody     "OGLE-2011-BLG-251L"
	Mass            305.472
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   3.86
	}
}

Planet	"OGLE-2011-BLG-265L b"
{
	ParentBody     "OGLE-2011-BLG-265L"
	Mass            280.016
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   1.89
	}
}

Planet	"OGLE-2011-BLG-420L b"
{
	ParentBody     "OGLE-2011-BLG-420L"
	Mass            2991.08
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   0.19
	}
}

Planet	"OGLE-2012-BLG-026L b"
{
	ParentBody     "OGLE-2012-BLG-026L"
	Mass            35.002
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   3.82
	}
}

Planet	"OGLE-2012-BLG-026L c"
{
	ParentBody     "OGLE-2012-BLG-026L"
	Mass            216.376
	DiscMethod     "MicroLens"
	DiscDate       "2012"
	Orbit
	{
		SemiMajorAxis   4.63
	}
}

Planet	"OGLE-2012-BLG-358L b"
{
	ParentBody     "OGLE-2012-BLG-358L"
	Mass            588.67
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   0.87
	}
}

Planet	"OGLE-2012-BLG-406L b"
{
	ParentBody     "OGLE-2012-BLG-406L"
	Mass            868.686
	DiscMethod     "MicroLens"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   3.45
	}
}

Planet	"OGLE-2012-BLG-563L b"
{
	ParentBody     "OGLE-2012-BLG-563L"
	Mass            124.098
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   0.9
	}
}

Planet	"OGLE-2012-BLG-724L b"
{
	ParentBody     "OGLE-2012-BLG-724L"
	Mass            149.554
	DiscMethod     "MicroLens"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   1.6
	}
}

Planet	"OGLE-2013-BLG-102L b"
{
	ParentBody     "OGLE-2013-BLG-102L"
	Mass            3999.4558
	DiscMethod     "MicroLens"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   0.8
	}
}

Planet	"OGLE-2013-BLG-341L b"
{
	ParentBody     "OGLE-2013-BLG-341L"
	Mass            2.32286
	DiscMethod     "MicroLens"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   0.883
	}
}

Planet	"OGLE-2013-BLG-723LB b"
{
	ParentBody     "OGLE-2013-BLG-723LB"
	Mass            0.70004
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   0.34
	}
}

Planet	"OGLE-2014-BLG-124L b"
{
	ParentBody     "OGLE-2014-BLG-124L"
	Mass            162.282
	DiscMethod     "MicroLens"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   3.11
	}
}

Planet	"OGLE-2014-BLG-1760L b"
{
	ParentBody     "OGLE-2014-BLG-1760L"
	Mass            182.3286
	DiscMethod     "MicroLens"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   1.75
	}
}

Planet	"OGLE-2014-BLG-257L b"
{
	ParentBody     "OGLE-2014-BLG-257L"
	Mass            11455.2
	DiscMethod     "MicroLens"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   0.61
	}
}

Planet	"OGLE-2015-BLG-954L b"
{
	ParentBody     "OGLE-2015-BLG-954L"
	Mass            1400.08
	DiscMethod     "MicroLens"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   1.2
	}
}

Planet	"OGLE-2015-BLG-966L b"
{
	ParentBody     "OGLE-2015-BLG-966L"
	Mass            21.023474
	DiscMethod     "MicroLens"
	DiscDate       "2016"
	Orbit
	{
		SemiMajorAxis   2.1
	}
}

Planet	"OGLE-TR-10 b"
{
	ParentBody     "OGLE-TR-10"
	Mass            216.376
	Radius          122966.24
	DiscMethod     "Transit"
	DiscDate       "2004"
	Orbit
	{
		Period          0.008491050832
		SemiMajorAxis   0.04162
		Eccentricity    0
		Inclination     84.5
	}
}

Planet	"OGLE-TR-111 b"
{
	ParentBody     "OGLE-TR-111"
	Mass            171.828
	Radius          76996.884
	DiscMethod     "Transit"
	DiscDate       "2004"
	Orbit
	{
		Period          0.01099136439
		SemiMajorAxis   0.047
		Eccentricity    0
		Inclination     88.1
	}
}

Planet	"OGLE-TR-113 b"
{
	ParentBody     "OGLE-TR-113"
	Mass            394.568
	Radius          79356.12
	DiscMethod     "Transit"
	DiscDate       "2004"
	Orbit
	{
		Period          0.003921992694
		SemiMajorAxis   0.0229
		Eccentricity    0
		Inclination     89.4
	}
}

Planet	"OGLE-TR-132 b"
{
	ParentBody     "OGLE-TR-132"
	Mass            375.476
	Radius          85790.4
	DiscMethod     "Transit"
	DiscDate       "2004"
	Orbit
	{
		Period          0.004626705367
		SemiMajorAxis   0.03035
		Eccentricity    0
		Inclination     83.4
	}
}

Planet	"OGLE-TR-182 b"
{
	ParentBody     "OGLE-TR-182"
	Mass            321.382
	Radius          80785.96
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.01089441502
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     85.7
	}
}

Planet	"OGLE-TR-211 b"
{
	ParentBody     "OGLE-TR-211"
	Mass            327.746
	Radius          97229.12
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.01006794971
		SemiMajorAxis   0.051
		Eccentricity    0
		Inclination     87.2
	}
}

Planet	"OGLE-TR-56 b"
{
	ParentBody     "OGLE-TR-56"
	Mass            413.66
	Radius          85790.4
	DiscMethod     "Transit"
	DiscDate       "2002"
	Orbit
	{
		Period          0.003318096961
		SemiMajorAxis   0.0225
		Eccentricity    0
		Inclination     78.8
	}
}

Planet	"OGLE2-TR-L9 b"
{
	ParentBody     "OGLE2-TR-L9"
	Mass            1431.9
	Radius          115102.12
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.006805165364
		SemiMajorAxis   0.0308
		Inclination     79.8
	}
}

Planet	"OME Ser b"
{
	ParentBody     "OME Ser"
	Msini           540.94
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2450022
		Period          0.7584556431
		SemiMajorAxis   1.1
		Eccentricity    0.106
		ArgOfPericen    132
	}
}

Planet	"OMI CrB b"
{
	ParentBody     "OMI CrB"
	Msini           477.3
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2452211
		Period          0.5142615098
		SemiMajorAxis   0.83
		Eccentricity    0.191
		ArgOfPericen    79
	}
}

Planet	"OMI UMa b"
{
	ParentBody     "OMI UMa"
	Msini           1304.62
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2453400
		Period          4.462792211
		SemiMajorAxis   3.9
		Eccentricity    0.13
		ArgOfPericen    58
	}
}

Planet	"OY Car b"
{
	ParentBody     "OY Car"
	Mass            2698.336
	DiscMethod     "Pulsar"
	DiscDate       "2014"
	Orbit
	{
		SemiMajorAxis   6.18
	}
}

Planet	"Orbitar/42 Dra b"
{
	ParentBody     "Fafnir"
	Msini           1234.616
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452757.4
		Period          1.311732361
		SemiMajorAxis   1.19
		Eccentricity    0.38
		ArgOfPericen    218.7
	}
}

Planet	"PH1/Kepler-64 b"
{
	ParentBody     "Kepler-64"
	Mass            168.646
	Radius          39535.076
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.3792168699
		SemiMajorAxis   0.634
		Eccentricity    0.0539
		Inclination     90
		ArgOfPericen    348
	}
}

Planet	"PH2/Kepler-86 b/KOI-3663.01"
{
	ParentBody     "Kepler-86"
	Radius          64700.26
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.773529203
		SemiMajorAxis   0.828
		Eccentricity    0.41
		Inclination     89.83
		ArgOfPericen    3.4
	}
}

Planet	"POTS-1 b"
{
	ParentBody     "POTS-1"
	Mass            735.042
	Radius          67273.972
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.008653517277
		SemiMajorAxis   0.03734
		Inclination     88.06
	}
}

Planet	"PSI Dra B b/HD 162004 b"
{
	ParentBody     "PSI Dra B"
	Msini           486.846
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2449344
		Period          8.534063388
		SemiMajorAxis   4.43
		Eccentricity    0.4
		ArgOfPericen    64
	}
}

Planet	"PSR B1957+20 b"
{
	ParentBody     "PSR B1957+20"
	Mass            7000.4
	DiscMethod     "Pulsar"
	DiscDate       "1988"
	Orbit
	{
		Period          0.02491497492
	}
}

Planet	"PSR J1719-14 b"
{
	ParentBody     "PSR J1719-14"
	Mass            381.84
	Radius          28596.8
	DiscMethod     "Pulsar"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455235.517
		Period          0.0002483455979
		SemiMajorAxis   0.0044
		Eccentricity    0.06
	}
}

Planet	"PSR J1807-2459 A b"
{
	ParentBody     "PSR J1807-2459 A"
	Mass            2991.08
	DiscMethod     "Pulsar"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2450851.887
		Period          0.0001916536532
		Eccentricity    0
	}
}

Planet	"PSR J2051-0827 b"
{
	ParentBody     "PSR J2051-0827"
	Mass            9005.06
	DiscMethod     "Pulsar"
	DiscDate       "1996"
	Orbit
	{
		Epoch           2449642.173
		Period          0.0002713549222
		Eccentricity    0
	}
}

Planet	"PSR J2241-5236 b"
{
	ParentBody     "PSR J2241-5236"
	Mass            3818.4
	DiscMethod     "Pulsar"
	DiscDate       "2011"
	Orbit
	{
		Epoch           2455044.158
		Period          0.0003988373839
		Eccentricity    0
	}
}

Planet	"PZ Tel b"
{
	ParentBody     "PZ Tel"
	Mass            19728.4
	Radius          173010.64
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   20
		Eccentricity    0.62
	}
}

Planet	"Phobetor/PSR B1257+12 d"
{
	ParentBody     "Lich"
	Mass            3.904314
	DiscMethod     "Pulsar"
	DiscDate       "1992"
	Orbit
	{
		Epoch           2449767
		Period          0.2688939086
		SemiMajorAxis   0.46
		Eccentricity    0.0252
		Inclination     47
		ArgOfPericen    108.3
	}
}

Planet	"Poltergeist/PSR B1257+12 c"
{
	ParentBody     "Lich"
	Mass            4.305246
	DiscMethod     "Pulsar"
	DiscDate       "1992"
	Orbit
	{
		Epoch           2449768.6
		Period          0.182185689
		SemiMajorAxis   0.36
		Eccentricity    0.0186
		Inclination     53
		ArgOfPericen    250.4
	}
}

Planet	"Pr 0201 b"
{
	ParentBody     "Pr 0201"
	Msini           171.828
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455992.861
		Period          0.01211908187
		Eccentricity    0
	}
}

Planet	"Pr 0201 c"
{
	ParentBody     "Pr 0201"
	Mass            171.828
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455992.861
		Period          0.01211908187
	}
}

Planet	"Pr 0211 b"
{
	ParentBody     "Pr 0211"
	Msini           598.216
	DiscMethod     "RadVel"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2456678.6
		Period          0.005875799838
		SemiMajorAxis   0.03184
		Eccentricity    0.017
		ArgOfPericen    329
	}
}

Planet	"Pr 0211 c"
{
	ParentBody     "Pr 0211"
	Msini           2529.69
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456709
		Period          14.51091946
		SemiMajorAxis   5.8
		Eccentricity    0.7
		ArgOfPericen    103
	}
}

Planet	"Qatar-1 b"
{
	ParentBody     "Qatar-1"
	Mass            405.705
	Radius          81214.912
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.003887897125
		SemiMajorAxis   0.02298
		Eccentricity    0
		Inclination     84.26
	}
}

Planet	"Qatar-2 b"
{
	ParentBody     "Qatar-2"
	Mass            793.5908
	Radius          89650.968
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.003660903661
		SemiMajorAxis   0.02153
		Eccentricity    0
		Inclination     86.12
	}
}

Planet	"Quijote/MU Ara b/HD 160691 b"
{
	ParentBody     "Cervantes"
	Msini           343.656
	DiscMethod     "RadVel"
	DiscDate       "2000"
	Orbit
	{
		Epoch           2452365.6
		Period          1.761160178
		SemiMajorAxis   1.5
		Eccentricity    0.128
		ArgOfPericen    22
	}
}

Planet	"RHO CrB b"
{
	ParentBody     "RHO CrB"
	Msini           330.928
	DiscMethod     "RadVel"
	DiscDate       "1997"
	Orbit
	{
		Epoch           2450413.7
		Period          0.1085444155
		SemiMajorAxis   0.22
		Eccentricity    0.028
		ArgOfPericen    30
	}
}

Planet	"ROXs 12 b"
{
	ParentBody     "ROXs 12"
	Mass            5091.2
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   210
	}
}

Planet	"ROXs 42B b"
{
	ParentBody     "ROXs 42B"
	Mass            2863.8
	Radius          178730
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   140
	}
}

Planet	"RR Cae b"
{
	ParentBody     "RR Cae"
	Msini           1336.44
	DiscMethod     "ETV"
	DiscDate       "2012"
	Orbit
	{
		Period          11.89210918
		SemiMajorAxis   5.3
		Eccentricity    0
		Inclination     17.6
	}
}

Planet	"Rocinante/MU Ara d/HD 160691 d"
{
	ParentBody     "Cervantes"
	Msini           10.567422
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2452708.7
		Period          0.850257743
		SemiMajorAxis   0.921
		Eccentricity    0.0666
		ArgOfPericen    189.6
	}
}

Planet	"Ross 458 c/HIP 63510 c"
{
	ParentBody     "DT Vir"
	Mass            3595.66
	Radius          76496.44
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   1168
	}
}

Planet	"SIG Per b"
{
	ParentBody     "SIG Per"
	Mass            2068.3
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2453022.6
		Period          1.587439831
		SemiMajorAxis   1.8
		Eccentricity    0.3
		ArgOfPericen    83.5
	}
}

Planet	"SR 12 c"
{
	ParentBody     "SR 12"
	Mass            4136.6
	DiscMethod     "Imaging"
	DiscDate       "2010"
	Orbit
	{
		SemiMajorAxis   1083
	}
}

Planet	"SWEEPS-04 b"
{
	ParentBody     "SWEEPS-04"
	Mass            1209.16
	Radius          57908.52
	DiscMethod     "Transit"
	DiscDate       "2006"
	Orbit
	{
		Period          0.01149921919
		SemiMajorAxis   0.055
		Inclination     87
	}
}

Planet	"SWEEPS-11 b"
{
	ParentBody     "SWEEPS-11"
	Mass            3086.54
	Radius          80785.96
	DiscMethod     "Transit"
	DiscDate       "2006"
	Orbit
	{
		Period          0.00491728516
		SemiMajorAxis   0.03
		Inclination     84
	}
}

Planet	"Saffar/UPS And A b"
{
	ParentBody     "UPS And A"
	Msini           218.79432
	DiscMethod     "RadVel"
	DiscDate       "1996"
	Orbit
	{
		Epoch           2450034.058
		Period          0.01264122856
		SemiMajorAxis   0.059
		Eccentricity    0.01186
		Inclination     90
		ArgOfPericen    44.519
	}
}

Planet	"Samh/UPS And A c"
{
	ParentBody     "UPS And A"
	Msini           630.3542
	DiscMethod     "RadVel"
	DiscDate       "1999"
	Orbit
	{
		Epoch           2449922.548
		Period          0.6596636607
		SemiMajorAxis   0.861
		Eccentricity    0.2445
		Inclination     11.347
		ArgOfPericen    247.629
	}
}

Planet	"Sancho/MU Ara e/HD 160691 e"
{
	ParentBody     "Cervantes"
	Msini           166.06858
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2452955.2
		Period          11.51509907
		SemiMajorAxis   5.235
		Eccentricity    0.0985
		ArgOfPericen    57.6
	}
}

Planet	"Smertrios/HD 149026 b"
{
	ParentBody     "Ogma"
	Mass            113.2792
	Radius          51331.256
	DiscMethod     "Transit"
	DiscDate       "2005"
	Orbit
	{
		Epoch           2453317.838
		Period          0.007873930449
		SemiMajorAxis   0.04288
		Eccentricity    0
		Inclination     85.3
	}
}

Planet	"Spe/14 And b"
{
	ParentBody     "Veritate"
	Msini           1527.36
	DiscMethod     "RadVel"
	DiscDate       "2008"
	Orbit
	{
		Epoch           2452861.4
		Period          0.5088130702
		SemiMajorAxis   0.83
		Eccentricity    0
		ArgOfPericen    0
	}
}

Planet	"TAU Boo A b"
{
	ParentBody     "TAU Boo A"
	Msini           1314.166
	Radius          75781.52
	DiscMethod     "RadVel"
	DiscDate       "1996"
	Orbit
	{
		Epoch           2450529.2
		Period          0.009069297283
		SemiMajorAxis   0.046
		Eccentricity    0.0787
		Inclination     45
		ArgOfPericen    218.4
	}
}

Planet	"TAU Gem b"
{
	ParentBody     "TAU Gem"
	Msini           6554.92
	DiscMethod     "RadVel"
	DiscDate       "2004"
	Orbit
	{
		Epoch           2453270.7
		Period          0.8364313009
		SemiMajorAxis   1.17
		Eccentricity    0.031
		ArgOfPericen    137.4
	}
}

Planet	"TRAPPIST-1 b"
{
	ParentBody     "TRAPPIST-1"
	Radius          7077.708
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004136564838
		SemiMajorAxis   0.01111
		Eccentricity    0
		Inclination     89.41
	}
}

Planet	"TRAPPIST-1 c"
{
	ParentBody     "TRAPPIST-1"
	Radius          6720.248
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.00663080024
		SemiMajorAxis   0.01522
		Eccentricity    0
		Inclination     89.5
	}
}

Planet	"TRAPPIST-1 d"
{
	ParentBody     "TRAPPIST-1"
	Radius          7435.168
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.04983542566
		SemiMajorAxis   0.08
		Eccentricity    0
		Inclination     89.87
	}
}

Planet	"TWA 5 b"
{
	ParentBody     "TWA 5"
	Mass            7955
	DiscMethod     "Imaging"
	DiscDate       "2009"
	Orbit
	{
		SemiMajorAxis   86
		Eccentricity    0.45
	}
}

Planet	"TYC 1422-614-1 b"
{
	ParentBody     "TYC 1422-614-1"
	Msini           795.5
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2453236.5
		Period          0.5432012115
		SemiMajorAxis   0.69
		Eccentricity    0.06
		ArgOfPericen    50
	}
}

Planet	"TYC 1422-614-1 c"
{
	ParentBody     "TYC 1422-614-1"
	Msini           3182
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2453190.5
		Period          1.531312689
		SemiMajorAxis   1.37
		Eccentricity    0.048
		ArgOfPericen    130
	}
}

Planet	"TYC 3667-1280-1 b"
{
	ParentBody     "TYC 3667-1280-1"
	Msini           1718.28
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456320.1
		Period          0.0724669842
		SemiMajorAxis   0.21
		Eccentricity    0.036
		ArgOfPericen    240
	}
}

Planet	"TYC-3667-1280-1 b"
{
	ParentBody     "TYC-3667-1280-1"
	Msini           1718.28
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Epoch           2456319.6
		Period          0.0724669842
		SemiMajorAxis   0.21
		Eccentricity    0.036
		ArgOfPericen    240
	}
}

Planet	"Tadmor/GAM Cep A b/Errai A b"
{
	ParentBody     "Errai A"
	Msini           540.94
	DiscMethod     "RadVel"
	DiscDate       "2003"
	Orbit
	{
		Epoch           53147
		Period          2.4731535
		SemiMajorAxis   2.05
		Eccentricity    0.049
		Inclination     9.6
		ArgOfPericen    94.6
	}
}

Planet	"Taphao Kaew/47 UMa c"
{
	ParentBody     "Chalawan"
	Msini           171.828
	DiscMethod     "RadVel"
	DiscDate       "2001"
	Orbit
	{
		Epoch           2456441
		Period          6.546341213
		SemiMajorAxis   3.6
		Eccentricity    0.098
		ArgOfPericen    295
	}
}

Planet	"Taphao Thong/47 UMa b"
{
	ParentBody     "Chalawan"
	Msini           805.046
	DiscMethod     "RadVel"
	DiscDate       "1996"
	Orbit
	{
		Epoch           2451917
		Period          2.95146626
		SemiMajorAxis   2.1
		Eccentricity    0.032
		ArgOfPericen    334
	}
}

Planet	"Thestias/Pollux b/HD 62509 b"
{
	ParentBody     "Pollux"
	Msini           731.86
	DiscMethod     "RadVel"
	DiscDate       "2006"
	Orbit
	{
		Epoch           2447739.02
		Period          1.614380858
		SemiMajorAxis   1.69
		Eccentricity    0.02
		ArgOfPericen    354.58
	}
}

Planet	"TrES-1 b"
{
	ParentBody     "TrES-1"
	Mass            242.1502
	Radius          78569.708
	DiscMethod     "Transit"
	DiscDate       "2004"
	Orbit
	{
		Period          0.008296062953
		SemiMajorAxis   0.0393
		Eccentricity    0
		Inclination     88.4
	}
}

Planet	"TrES-3 b"
{
	ParentBody     "TrES-3"
	Mass            607.762
	Radius          93297.06
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.003576219058
		SemiMajorAxis   0.0226
		Eccentricity    0
		Inclination     82.15
	}
}

Planet	"TrES-4 b"
{
	ParentBody     "TrES-4"
	Mass            157.1908
	Radius          131402.296
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.009730331842
		SemiMajorAxis   0.0516
		Eccentricity    0.016
		Inclination     83.07
	}
}

Planet	"TrES-5 b"
{
	ParentBody     "TrES-5"
	Mass            569.578
	Radius          85361.448
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.00405825751
		SemiMajorAxis   0.02459
		Eccentricity    0
		Inclination     84.27
	}
}

Planet	"UPS And A e"
{
	ParentBody     "UPS And A"
	Msini           336.9738
	DiscMethod     "RadVel"
	DiscDate       "2010"
	Orbit
	{
		Epoch           2449535.95
		Period          10.53782971
		SemiMajorAxis   5.24558
		Eccentricity    0.00536
		ArgOfPericen    7.3
	}
}

Planet	"USco1602-2401 b"
{
	ParentBody     "USco1602-2401"
	Mass            14955.4
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   1000
	}
}

Planet	"USco1610-1913 b"
{
	ParentBody     "USco1610-1913"
	Mass            6364
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   840
	}
}

Planet	"USco1612-1800 b"
{
	ParentBody     "USco1612-1800"
	Mass            8273.2
	DiscMethod     "Imaging"
	DiscDate       "2013"
	Orbit
	{
		SemiMajorAxis   430
	}
}

Planet	"UScoCTIO 108 b/USco CTIO 108 b"
{
	ParentBody     "UScoCTIO 108"
	Mass            4454.8
	DiscMethod     "Imaging"
	DiscDate       "2008"
	Orbit
	{
		SemiMajorAxis   670
	}
}

Planet	"UZ For b"
{
	ParentBody     "UZ For"
	Mass            2004.66
	DiscMethod     "ETV"
	DiscDate       "2011"
	Orbit
	{
		Period          15.9893905
		SemiMajorAxis   5.9
		Eccentricity    0.04
	}
}

Planet	"UZ For c"
{
	ParentBody     "UZ For"
	Mass            2450.14
	DiscMethod     "Pulsar"
	DiscDate       "2011"
	Orbit
	{
		Period          5.202027731
		SemiMajorAxis   2.8
		Eccentricity    0.05
	}
}

Planet	"V391 Peg b/V0391 Peg b"
{
	ParentBody     "V391 Peg"
	Msini           1018.24
	DiscMethod     "Variable"
	DiscDate       "2007"
	Orbit
	{
		Period          3.203353918
		SemiMajorAxis   1.7
		Eccentricity    0
	}
}

Planet	"VHS J125601.92-125723.9 b/VHS 1256-1257 b"
{
	ParentBody     "VHS J125601.92-125723.9"
	Mass            3563.84
	DiscMethod     "Imaging"
	DiscDate       "2015"
	Orbit
	{
		SemiMajorAxis   102
	}
}

Planet	"WASP-1 b"
{
	ParentBody     "WASP-1"
	Mass            273.652
	Radius          106094.128
	DiscMethod     "Transit"
	DiscDate       "2006"
	Orbit
	{
		Period          0.006899384764
		SemiMajorAxis   0.0382
		Eccentricity    0
		Inclination     88.65
	}
}

Planet	"WASP-10 b"
{
	ParentBody     "WASP-10"
	Mass            1005.512
	Radius          77211.36
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.008467700846
		SemiMajorAxis   0.0371
		Eccentricity    0.057
		Inclination     86.8
		ArgOfPericen    2.737
	}
}

Planet	"WASP-100 b"
{
	ParentBody     "WASP-100"
	Mass            645.946
	Radius          120821.48
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.007801330403
		SemiMajorAxis   0.0457
		Eccentricity    0
		Inclination     82.6
	}
}

Planet	"WASP-101 b"
{
	ParentBody     "WASP-101"
	Mass            159.1
	Radius          100803.72
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009817381725
		SemiMajorAxis   0.0506
		Eccentricity    0
		Inclination     85
	}
}

Planet	"WASP-103 b"
{
	ParentBody     "WASP-103"
	Mass            474.118
	Radius          109239.776
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.002534050079
		SemiMajorAxis   0.01985
		Inclination     86.3
	}
}

Planet	"WASP-104 b"
{
	ParentBody     "WASP-104"
	Mass            404.7504
	Radius          81286.404
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004806163551
		SemiMajorAxis   0.02918
		Eccentricity    0
		Inclination     83.63
	}
}

Planet	"WASP-106 b"
{
	ParentBody     "WASP-106"
	Mass            612.535
	Radius          77568.82
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02543439739
		SemiMajorAxis   0.0917
		Eccentricity    0
		Inclination     89.49
	}
}

Planet	"WASP-108 b"
{
	ParentBody     "WASP-108"
	Mass            371.3394
	Radius          86862.78
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007325403183
		SemiMajorAxis   0.0397
		Eccentricity    0
		Inclination     88.49
	}
}

Planet	"WASP-109 b"
{
	ParentBody     "WASP-109"
	Msini           289.562
	Radius          103162.956
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009087184866
		SemiMajorAxis   0.0463
		Eccentricity    0
		Inclination     84.28
	}
}

Planet	"WASP-11 b"
{
	ParentBody     "HAT-P-10"
	Mass            146.372
	Radius          74709.14
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01019178261
		SemiMajorAxis   0.0439
		Eccentricity    0
		Inclination     89.8
	}
}

Planet	"WASP-110 b"
{
	ParentBody     "WASP-110"
	Mass            163.873
	Radius          88507.096
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01034491032
		SemiMajorAxis   0.0457
		Eccentricity    0
		Inclination     88.06
	}
}

Planet	"WASP-111 b"
{
	ParentBody     "WASP-111"
	Mass            582.306
	Radius          103091.464
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.006327212639
		SemiMajorAxis   0.03914
		Eccentricity    0
		Inclination     81.61
	}
}

Planet	"WASP-112 b"
{
	ParentBody     "WASP-112"
	Mass            280.016
	Radius          85146.972
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008310647796
		SemiMajorAxis   0.0382
		Eccentricity    0
		Inclination     88.68
	}
}

Planet	"WASP-117 b"
{
	ParentBody     "WASP-117"
	Mass            87.6641
	Radius          72993.332
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.02743836906
		SemiMajorAxis   0.09459
		Eccentricity    0.302
		Inclination     89.14
		ArgOfPericen    242
	}
}

Planet	"WASP-119 b"
{
	ParentBody     "WASP-119"
	Msini           391.386
	Radius          100088.8
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.006844198369
		SemiMajorAxis   0.0363
		Eccentricity    0.058
		Inclination     85
	}
}

Planet	"WASP-12 b"
{
	ParentBody     "WASP-12"
	Mass            446.7528
	Radius          124110.112
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.002988215026
		SemiMajorAxis   0.02293
		Eccentricity    0
		Inclination     86
		ArgOfPericen   -74
	}
}

Planet	"WASP-120 b"
{
	ParentBody     "WASP-120"
	Mass            1594.182
	Radius          108310.38
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009887331476
		SemiMajorAxis   0.0522
		Eccentricity    0.059
		Inclination     82.29
		ArgOfPericen    323
	}
}

Planet	"WASP-121 b"
{
	ParentBody     "WASP-121"
	Msini           376.4306
	Radius          133332.58
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.003490630424
		SemiMajorAxis   0.02544
		Eccentricity    0
		Inclination     87.6
	}
}

Planet	"WASP-123 b"
{
	ParentBody     "WASP-123"
	Mass            292.744
	Radius          94869.884
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.008152511081
		SemiMajorAxis   0.0431
		Eccentricity    0
		Inclination     85.79
	}
}

Planet	"WASP-124 b"
{
	ParentBody     "WASP-124"
	Msini           190.92
	Radius          88650.08
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009234009908
		SemiMajorAxis   0.0449
		Eccentricity    0.017
		Inclination     86.3
	}
}

Planet	"WASP-126 b"
{
	ParentBody     "WASP-126"
	Msini           89.096
	Radius          68632.32
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.009004436211
		SemiMajorAxis   0.0449
		Eccentricity    0.18
		Inclination     87.9
	}
}

Planet	"WASP-129 b"
{
	ParentBody     "WASP-129"
	Msini           318.2
	Radius          66487.56
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01573789984
		SemiMajorAxis   0.0628
		Eccentricity    0.096
		Inclination     87.7
	}
}

Planet	"WASP-13 b"
{
	ParentBody     "WASP-13"
	Mass            154.327
	Radius          97586.58
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01191814944
		SemiMajorAxis   0.05379
		Eccentricity    0
		Inclination     85.64
	}
}

Planet	"WASP-133 b"
{
	ParentBody     "WASP-133"
	Msini           369.112
	Radius          86505.32
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.005958848842
		SemiMajorAxis   0.0345
		Eccentricity    0.17
		Inclination     87
	}
}

Planet	"WASP-135 b"
{
	ParentBody     "WASP-135"
	Msini           604.58
	Radius          92939.6
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.003836849737
		SemiMajorAxis   0.0243
		Eccentricity    0
		Inclination     82
	}
}

Planet	"WASP-14 b"
{
	ParentBody     "WASP-14"
	Mass            2335.9062
	Radius          91581.252
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.006143228144
		SemiMajorAxis   0.036
		Eccentricity    0.087
		Inclination     84.79
		ArgOfPericen   -107.1
	}
}

Planet	"WASP-15 b"
{
	ParentBody     "WASP-15"
	Mass            172.4644
	Radius          102090.576
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01027281542
		SemiMajorAxis   0.0499
		Eccentricity    0
		Inclination     85.5
	}
}

Planet	"WASP-157 b"
{
	ParentBody     "WASP-157"
	Msini           182.6468
	Radius          74709.14
	DiscMethod     "RadVel"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01081917864
		SemiMajorAxis   0.0529
		Eccentricity    0
		Inclination     85.19
	}
}

Planet	"WASP-16 b"
{
	ParentBody     "WASP-16"
	Mass            272.061
	Radius          72063.936
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.008538446507
		SemiMajorAxis   0.0421
		Eccentricity    0
		Inclination     85.22
	}
}

Planet	"WASP-17 b"
{
	ParentBody     "WASP-17"
	Mass            154.6452
	Radius          142340.572
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.01022729056
		SemiMajorAxis   0.0515
		Eccentricity    0.028
		Inclination     86.83
		ArgOfPericen    277.4
	}
}

Planet	"WASP-18 b"
{
	ParentBody     "HD 10069"
	Mass            3318.826
	Radius          83288.18
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.002577612927
		SemiMajorAxis   0.02026
		Eccentricity    0.0092
		Inclination     86
		ArgOfPericen   -96
	}
}

Planet	"WASP-19 b"
{
	ParentBody     "WASP-19"
	Mass            354.4748
	Radius          99731.34
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.002159772397
		SemiMajorAxis   0.01616
		Eccentricity    0.0046
		Inclination     79.4
		ArgOfPericen    3
	}
}

Planet	"WASP-2 b"
{
	ParentBody     "WASP-2"
	Mass            269.5154
	Radius          77139.868
	DiscMethod     "Transit"
	DiscDate       "2006"
	Orbit
	{
		Period          0.005892587165
		SemiMajorAxis   0.03138
		Eccentricity    0
		Inclination     84.73
	}
}

Planet	"WASP-20 b"
{
	ParentBody     "WASP-20"
	Mass            98.9602
	Radius          104521.304
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01341473832
		SemiMajorAxis   0.06
		Eccentricity    0
		Inclination     85.56
	}
}

Planet	"WASP-21 b"
{
	ParentBody     "WASP-21"
	Mass            95.46
	Radius          86505.32
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01183464758
		SemiMajorAxis   0.052
		Eccentricity    0
		Inclination     87.12
	}
}

Planet	"WASP-22 b"
{
	ParentBody     "WASP-22"
	Msini           196.3294
	Radius          85718.908
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.009672296186
		SemiMajorAxis   0.0489
		Eccentricity    0
		Inclination     88.6
	}
}

Planet	"WASP-23 b"
{
	ParentBody     "WASP-23"
	Mass            281.2888
	Radius          68775.304
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.008061570327
		SemiMajorAxis   0.0376
		Eccentricity    0.062
		Inclination     88.39
	}
}

Planet	"WASP-24 b"
{
	ParentBody     "WASP-24"
	Mass            340.7922
	Radius          92939.6
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.006410028099
		SemiMajorAxis   0.03651
		Eccentricity    0
		Inclination     83.64
	}
}

Planet	"WASP-25 b"
{
	ParentBody     "WASP-25"
	Mass            184.556
	Radius          90079.92
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01030776319
		SemiMajorAxis   0.0474
		Eccentricity    0
		Inclination     87.7
		ArgOfPericen    0
	}
}

Planet	"WASP-26 b"
{
	ParentBody     "WASP-26"
	Mass            327.1096
	Radius          91581.252
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.00754732196
		SemiMajorAxis   0.03985
		Eccentricity    0
		Inclination     82.91
	}
}

Planet	"WASP-28 b"
{
	ParentBody     "WASP-28"
	Mass            288.6074
	Radius          86719.796
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009333067468
		SemiMajorAxis   0.04469
		Eccentricity    0
		Inclination     88.61
	}
}

Planet	"WASP-29 b"
{
	ParentBody     "WASP-29"
	Mass            77.28987194
	Radius          60145.48692
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01074007086
		SemiMajorAxis   0.0457
		Eccentricity    0.03
		Inclination     88.8
	}
}

Planet	"WASP-3 b"
{
	ParentBody     "WASP-3"
	Mass            560.032
	Radius          92224.68
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.005056466781
		SemiMajorAxis   0.03151
		Eccentricity    0
		Inclination     84.93
	}
}

Planet	"WASP-31 b"
{
	ParentBody     "WASP-31"
	Mass            152.0996
	Radius          109883.204
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.009325070035
		SemiMajorAxis   0.04657
		Eccentricity    0
		Inclination     84.54
	}
}

Planet	"WASP-32 b"
{
	ParentBody     "WASP-32"
	Mass            1145.52
	Radius          84360.56
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.007443441846
		SemiMajorAxis   0.0394
		Eccentricity    0.018
		Inclination     85.3
		ArgOfPericen    130
	}
}

Planet	"WASP-33 b"
{
	ParentBody     "HD 15082"
	Mass            668.22
	Radius          114601.676
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.003339892553
		SemiMajorAxis   0.02558
		Eccentricity    0
		Inclination     87.7
	}
}

Planet	"WASP-34 b"
{
	ParentBody     "WASP-34"
	Mass            187.738
	Radius          87220.24
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01182141144
		SemiMajorAxis   0.0524
		Eccentricity    0.038
		Inclination     85.2
		ArgOfPericen    319.8
	}
}

Planet	"WASP-35 b"
{
	ParentBody     "WASP-35"
	Mass            229.104
	Radius          94369.44
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008656105696
		SemiMajorAxis   0.04317
		Eccentricity    0
		Inclination     87.96
	}
}

Planet	"WASP-36 b"
{
	ParentBody     "WASP-36"
	Mass            751.2702
	Radius          94869.884
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.004209168608
		SemiMajorAxis   0.02677
		Eccentricity    0
		Inclination     83.15
	}
}

Planet	"WASP-37 b"
{
	ParentBody     "WASP-37"
	Mass            572.76
	Radius          82930.72
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.009794791236
		SemiMajorAxis   0.04339
		Eccentricity    0
		Inclination     88.78
	}
}

Planet	"WASP-38 b"
{
	ParentBody     "HD 146389"
	Mass            856.2762
	Radius          78212.248
	DiscMethod     "Transit"
	DiscDate       "2010"
	Orbit
	{
		Period          0.01881440642
		SemiMajorAxis   0.07522
		Eccentricity    0.0314
		Inclination     88.69
		ArgOfPericen   -16
	}
}

Planet	"WASP-39 b"
{
	ParentBody     "WASP-39"
	Mass            89.096
	Radius          90794.84
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01110293146
		SemiMajorAxis   0.0486
		Eccentricity    0
		Inclination     87.83
	}
}

Planet	"WASP-4 b"
{
	ParentBody     "WASP-4"
	Mass            386.9312
	Radius          95084.36
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.003663959277
		SemiMajorAxis   0.02312
		Eccentricity    0
		Inclination     86.85
	}
}

Planet	"WASP-41 b"
{
	ParentBody     "WASP-41"
	Mass            299.108
	Radius          84360.56
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.008357205396
		SemiMajorAxis   0.04
		Eccentricity    0.026
		Inclination     89.4
	}
}

Planet	"WASP-41 c"
{
	ParentBody     "WASP-41"
	Msini           1011.876
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2456011
		Period          1.152659829
		SemiMajorAxis   1.07
		Eccentricity    0.294
		ArgOfPericen    353
	}
}

Planet	"WASP-42 b"
{
	ParentBody     "WASP-42"
	Mass            167.6914
	Radius          80214.024
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01363939336
		SemiMajorAxis   0.0561
		Eccentricity    0.06
		Inclination     88
		ArgOfPericen    167
	}
}

Planet	"WASP-43 b"
{
	ParentBody     "WASP-43"
	Msini           647.2188
	Radius          74065.712
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.002227227721
		SemiMajorAxis   0.01526
		Eccentricity    0.0035
		Inclination     82.33
		ArgOfPericen    328
	}
}

Planet	"WASP-44 b"
{
	ParentBody     "WASP-44"
	Mass            282.8798
	Radius          81500.88
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.006636155317
		SemiMajorAxis   0.03473
		Eccentricity    0
		Inclination     86.02
	}
}

Planet	"WASP-45 b"
{
	ParentBody     "WASP-45"
	Mass            318.8364
	Radius          70920.064
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.008558967411
		SemiMajorAxis   0.0405
		Eccentricity    0
		Inclination     84.686
	}
}

Planet	"WASP-46 b"
{
	ParentBody     "WASP-46"
	Mass            607.762
	Radius          83931.608
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.003916216882
		SemiMajorAxis   0.02335
		Eccentricity    0
		Inclination     82.8
	}
}

Planet	"WASP-47 b"
{
	ParentBody     "WASP-47"
	Mass            341.39678
	Radius          81429.388
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Epoch           2455764.346
		Period          0.01138731728
		SemiMajorAxis   0.052
		Eccentricity    0.11
		Inclination     89.03
	}
}

Planet	"WASP-47 c"
{
	ParentBody     "WASP-47"
	Msini           394.568
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Epoch           2455981
		Period          1.566084138
		SemiMajorAxis   1.36
		Eccentricity    0.13
		ArgOfPericen    144
	}
}

Planet	"WASP-47 d"
{
	ParentBody     "WASP-47"
	Mass            15.216324
	Radius          23163.408
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.02472553897
		SemiMajorAxis   0.087568
		Inclination     89.36
	}
}

Planet	"WASP-47 e"
{
	ParentBody     "WASP-47"
	Mass            22.025804
	Radius          11653.196
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.002161844995
		SemiMajorAxis   0.01725
		Inclination     87
	}
}

Planet	"WASP-48 b"
{
	ParentBody     "WASP-48"
	Mass            288.6074
	Radius          99802.832
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.005869079475
		SemiMajorAxis   0.0332
		Eccentricity    0
		Inclination     81.99
	}
}

Planet	"WASP-49 b"
{
	ParentBody     "WASP-49"
	Mass            120.2796
	Radius          79713.58
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007616148346
		SemiMajorAxis   0.0379
		Eccentricity    0
		Inclination     84.89
	}
}

Planet	"WASP-5 b"
{
	ParentBody     "WASP-5"
	Mass            520.8934
	Radius          83717.132
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.004458478909
		SemiMajorAxis   0.02729
		Eccentricity    0
		Inclination     85.8
		ArgOfPericen    34.38
	}
}

Planet	"WASP-50 b"
{
	ParentBody     "WASP-50"
	Mass            457.2534
	Radius          81357.896
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.005352875309
		SemiMajorAxis   0.02913
		Eccentricity    0.009
		Inclination     84.74
		ArgOfPericen    44
	}
}

Planet	"WASP-52 b"
{
	ParentBody     "WASP-52"
	Mass            146.372
	Radius          90794.84
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.004790738443
		SemiMajorAxis   0.0272
		Eccentricity    0
		Inclination     85.35
	}
}

Planet	"WASP-54 b"
{
	ParentBody     "WASP-54"
	Mass            202.3752
	Radius          118176.276
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01011285444
		SemiMajorAxis   0.04987
		Eccentricity    0.067
		Inclination     84.97
		ArgOfPericen    62
	}
}

Planet	"WASP-55 b"
{
	ParentBody     "WASP-55"
	Mass            199.5114
	Radius          95441.82
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01222648759
		SemiMajorAxis   0.0558
		Eccentricity    0
		Inclination     89.05
	}
}

Planet	"WASP-56 b"
{
	ParentBody     "WASP-56"
	Mass            181.6922
	Radius          78069.264
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01264120391
		SemiMajorAxis   0.05458
		Eccentricity    0
		Inclination     88.5
	}
}

Planet	"WASP-57 b"
{
	ParentBody     "WASP-57"
	Mass            204.9208
	Radius          75066.6
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007772701618
		SemiMajorAxis   0.03769
		Eccentricity    0
		Inclination     86.05
	}
}

Planet	"WASP-58 b"
{
	ParentBody     "WASP-58"
	Mass            283.198
	Radius          97944.04
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01373658394
		SemiMajorAxis   0.0561
		Eccentricity    0
		Inclination     87.4
	}
}

Planet	"WASP-59 b"
{
	ParentBody     "WASP-59"
	Mass            274.6066
	Radius          55406.3
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.02168310568
		SemiMajorAxis   0.0697
		Eccentricity    0.1
		Inclination     89.27
		ArgOfPericen    74
	}
}

Planet	"WASP-6 b"
{
	ParentBody     "WASP-6"
	Mass            154.327
	Radius          87935.16
	DiscMethod     "Transit"
	DiscDate       "2009"
	Orbit
	{
		Period          0.009202118959
		SemiMajorAxis   0.0414
		Eccentricity    0.054
		Inclination     88.38
		ArgOfPericen    1.7
	}
}

Planet	"WASP-60 b"
{
	ParentBody     "WASP-60"
	Mass            163.5548
	Radius          61483.12
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01178670269
		SemiMajorAxis   0.0531
		Eccentricity    0
		Inclination     87.9
	}
}

Planet	"WASP-61 b"
{
	ParentBody     "WASP-61"
	Mass            655.492
	Radius          88650.08
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01055710459
		SemiMajorAxis   0.0514
		Eccentricity    0.26
		Inclination     89.35
	}
}

Planet	"WASP-62 b"
{
	ParentBody     "WASP-62"
	Mass            181.374
	Radius          99373.88
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01207952729
		SemiMajorAxis   0.0567
		Eccentricity    0.21
		Inclination     88.3
	}
}

Planet	"WASP-63 b"
{
	ParentBody     "WASP-63"
	Mass            120.916
	Radius          102233.56
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01198681347
		SemiMajorAxis   0.0574
		Eccentricity    0.22
		Inclination     87.8
	}
}

Planet	"WASP-64 b"
{
	ParentBody     "WASP-64"
	Mass            404.4322
	Radius          90866.332
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.004307530301
		SemiMajorAxis   0.02648
		Eccentricity    0
		Inclination     86.57
	}
}

Planet	"WASP-65 b"
{
	ParentBody     "WASP-65"
	Mass            493.21
	Radius          79499.104
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.006328470161
		SemiMajorAxis   0.0334
		Eccentricity    0
		Inclination     88.8
	}
}

Planet	"WASP-66 b"
{
	ParentBody     "WASP-66"
	Mass            738.224
	Radius          99373.88
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.0111872399
		SemiMajorAxis   0.0546
		Eccentricity    0
		Inclination     85.9
	}
}

Planet	"WASP-67 b"
{
	ParentBody     "WASP-67"
	Mass            133.644
	Radius          100088.8
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01263386358
		SemiMajorAxis   0.0517
		Eccentricity    0.2
		Inclination     85.8
	}
}

Planet	"WASP-68 b"
{
	ParentBody     "HD 193334"
	Mass            302.29
	Radius          88650.08
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01392034694
		SemiMajorAxis   0.06206
		Eccentricity    0
		Inclination     88.1
	}
}

Planet	"WASP-69 b"
{
	ParentBody     "WASP-69"
	Mass            82.732
	Radius          75567.044
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01059061167
		SemiMajorAxis   0.04525
		Eccentricity    0
		Inclination     86.71
	}
}

Planet	"WASP-7 b"
{
	ParentBody     "HD 197286"
	Mass            305.472
	Radius          95084.36
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01356540437
		SemiMajorAxis   0.0618
		Eccentricity    0
		Inclination     89.6
	}
}

Planet	"WASP-70 A b"
{
	ParentBody     "HD 358155"
	Mass            187.738
	Radius          83216.688
	DiscMethod     "Transit"
	DiscDate       "2011"
	Orbit
	{
		Period          0.01016591293
		SemiMajorAxis   0.04853
		Eccentricity    0
		Inclination     87.12
	}
}

Planet	"WASP-71 b"
{
	ParentBody     "WASP-71"
	Mass            713.4044
	Radius          104378.32
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.007949998058
		SemiMajorAxis   0.04619
		Eccentricity    0
		Inclination     84.9
	}
}

Planet	"WASP-72 b"
{
	ParentBody     "WASP-72"
	Mass            464.8902
	Radius          90794.84
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.006069238882
		SemiMajorAxis   0.03708
		Eccentricity    0
		Inclination     81.6
	}
}

Planet	"WASP-73 b"
{
	ParentBody     "HD 202678"
	Mass            598.216
	Radius          82930.72
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01119043778
		SemiMajorAxis   0.05512
		Eccentricity    0
		Inclination     87.4
	}
}

Planet	"WASP-74 b"
{
	ParentBody     "WASP-74"
	Mass            302.29
	Radius          111527.52
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.005852965674
		SemiMajorAxis   0.037
		Eccentricity    0
		Inclination     79.81
	}
}

Planet	"WASP-75 b"
{
	ParentBody     "WASP-75"
	Mass            340.474
	Radius          90794.84
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.006801495197
		SemiMajorAxis   0.0375
		Eccentricity    0
		Inclination     82
	}
}

Planet	"WASP-76 b"
{
	ParentBody     "WASP-76"
	Mass            292.744
	Radius          130830.36
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.004955303769
		SemiMajorAxis   0.033
		Eccentricity    0
		Inclination     88
	}
}

Planet	"WASP-77 A b"
{
	ParentBody     "WASP-77 A"
	Mass            560.032
	Radius          86505.32
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.003723641293
		SemiMajorAxis   0.024
		Eccentricity    0
		Inclination     89.4
	}
}

Planet	"WASP-78 b"
{
	ParentBody     "WASP-78"
	Mass            283.198
	Radius          121536.4
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.005955435545
		SemiMajorAxis   0.0362
		Eccentricity    0
		Inclination     83.2
	}
}

Planet	"WASP-79 b"
{
	ParentBody     "WASP-79"
	Mass            286.38
	Radius          121536.4
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.01002726903
		SemiMajorAxis   0.0539
		Eccentricity    0
		Inclination     85.4
	}
}

Planet	"WASP-8 b"
{
	ParentBody     "WASP-8"
	Mass            714.0408
	Radius          74208.696
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.02233782193
		SemiMajorAxis   0.0801
		Eccentricity    0.31
		Inclination     88.55
		ArgOfPericen   -85.73
	}
}

Planet	"WASP-8 c"
{
	ParentBody     "WASP-8"
	Msini           3006.99
	DiscMethod     "RadVel"
	DiscDate       "2013"
	Orbit
	{
		Epoch           2452613
		Period          11.83598204
		SemiMajorAxis   5.28
		Eccentricity    0
		ArgOfPericen    90
	}
}

Planet	"WASP-80 b"
{
	ParentBody     "WASP-80"
	Mass            171.1916
	Radius          71420.508
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.008399501551
		SemiMajorAxis   0.0344
		Eccentricity    0.002
		Inclination     89.02
		ArgOfPericen    94
	}
}

Planet	"WASP-82 b"
{
	ParentBody     "WASP-82"
	Mass            394.568
	Radius          119391.64
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.007408185788
		SemiMajorAxis   0.0447
		Eccentricity    0
		Inclination     87.9
	}
}

Planet	"WASP-83 b"
{
	ParentBody     "WASP-83"
	Mass            95.46
	Radius          74351.68
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01114671884
		SemiMajorAxis   0.059
		Eccentricity    0
		Inclination     88.9
	}
}

Planet	"WASP-84 b"
{
	ParentBody     "WASP-84"
	Mass            220.8308
	Radius          67345.464
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.02333653323
		SemiMajorAxis   0.0771
		Eccentricity    0
		Inclination     88.368
	}
}

Planet	"WASP-85 b"
{
	ParentBody     "WASP-85"
	Mass            402.523
	Radius          88650.08
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.007271004757
		SemiMajorAxis   0.039
		Eccentricity    0.103
		Inclination     89.69
		ArgOfPericen   -11
	}
}

Planet	"WASP-87 A b"
{
	ParentBody     "WASP-87 A"
	Msini           693.676
	Radius          99016.42
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.004607340134
		SemiMajorAxis   0.02946
		Eccentricity    0
		Inclination     81.07
	}
}

Planet	"WASP-88 b"
{
	ParentBody     "WASP-88"
	Mass            178.192
	Radius          121536.4
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01356360283
		SemiMajorAxis   0.06431
		Eccentricity    0
		Inclination     88
	}
}

Planet	"WASP-89 b"
{
	ParentBody     "WASP-89"
	Mass            1877.38
	Radius          74351.68
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.009189581032
		SemiMajorAxis   0.0427
		Eccentricity    0.193
		Inclination     89.4
		ArgOfPericen    28
	}
}

Planet	"WASP-90 b"
{
	ParentBody     "WASP-90"
	Mass            200.466
	Radius          116531.96
	DiscMethod     "Transit"
	DiscDate       "2016"
	Orbit
	{
		Period          0.01072231826
		SemiMajorAxis   0.0562
		Eccentricity    0
		Inclination     82.1
	}
}

Planet	"WASP-94 A b"
{
	ParentBody     "WASP-94 A"
	Mass            143.8264
	Radius          122966.24
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.01081526398
		SemiMajorAxis   0.055
		Eccentricity    0
		Inclination     88.7
	}
}

Planet	"WASP-94 B b"
{
	ParentBody     "WASP-94 B"
	Msini           196.6476
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456574.359
		Period          0.005498789723
		SemiMajorAxis   0.0335
		Eccentricity    0
	}
}

Planet	"WASP-95 b"
{
	ParentBody     "WASP-95"
	Mass            359.566
	Radius          86505.32
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.005981436594
		SemiMajorAxis   0.03416
		Eccentricity    0
		Inclination     88.4
	}
}

Planet	"WASP-96 b"
{
	ParentBody     "WASP-96"
	Mass            152.736
	Radius          85790.4
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.009378051866
		SemiMajorAxis   0.0453
		Eccentricity    0
		Inclination     85.6
	}
}

Planet	"WASP-97 b"
{
	ParentBody     "WASP-97"
	Mass            420.024
	Radius          80785.96
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.005675028947
		SemiMajorAxis   0.03303
		Eccentricity    0
		Inclination     88
	}
}

Planet	"WASP-98 b"
{
	ParentBody     "WASP-98"
	Mass            264.106
	Radius          78641.2
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.008111439703
		SemiMajorAxis   0.036
		Eccentricity    0
		Inclination     86.3
	}
}

Planet	"WASP-99 b"
{
	ParentBody     "WASP-99"
	Mass            884.596
	Radius          78641.2
	DiscMethod     "Transit"
	DiscDate       "2013"
	Orbit
	{
		Period          0.01574985081
		SemiMajorAxis   0.0717
		Eccentricity    0
		Inclination     88.8
	}
}

Planet	"WD 0806-661 B b"
{
	ParentBody     "WD 0806-661 B"
	Mass            2545.6
	DiscMethod     "Imaging"
	DiscDate       "2011"
	Orbit
	{
		SemiMajorAxis   2500
	}
}

Planet	"WD 1145+017 b"
{
	ParentBody     "WD 1145+017"
	Mass            0.00066822
	DiscMethod     "Transit"
	DiscDate       "2015"
	Orbit
	{
		Period          0.0005133579997
	}
}

Planet	"WISE 1711+3500 b"
{
	ParentBody     "WISE 1711+3500"
	Mass            5727.6
	DiscMethod     "Imaging"
	DiscDate       "2012"
	Orbit
	{
		Period          342.2386665
		SemiMajorAxis   15
	}
}

Planet	"WISE J0720-0846 b"
{
	ParentBody     "WISE J0720-0846"
	Mass            19728.4
	DiscMethod     "Imaging"
	DiscDate       "2014"
	Orbit
	{
		Period          3.800218153
		SemiMajorAxis   1.3
		Eccentricity    0.8
		Inclination     93.5
		ArgOfPericen    54
	}
}

Planet	"WTS-1 b"
{
	ParentBody     "WTS-1"
	Mass            1275.982
	Radius          106523.08
	DiscMethod     "Transit"
	DiscDate       "2012"
	Orbit
	{
		Period          0.009177633617
		SemiMajorAxis   0.047
		Eccentricity    0.1
		Inclination     85.5
	}
}

Planet	"WTS-2 b"
{
	ParentBody     "WTS-2"
	Mass            356.384
	Radius          97443.596
	DiscMethod     "Transit"
	DiscDate       "2014"
	Orbit
	{
		Period          0.002789126854
		SemiMajorAxis   0.01855
		Eccentricity    0
		Inclination     83.55
	}
}

Planet	"Wolf 1061 b"
{
	ParentBody     "Wolf 1061"
	Msini           1.361896
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.01338180565
		SemiMajorAxis   0.035509
		Eccentricity    0
	}
}

Planet	"Wolf 1061 c"
{
	ParentBody     "Wolf 1061"
	Msini           4.254334
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.04891822603
		SemiMajorAxis   0.08427
		Eccentricity    0.19
		ArgOfPericen    37
	}
}

Planet	"Wolf 1061 d"
{
	ParentBody     "Wolf 1061"
	Msini           5.215298
	DiscMethod     "RadVel"
	DiscDate       "2015"
	Orbit
	{
		Period          0.1841791608
		SemiMajorAxis   0.2039
		Eccentricity    0.32
		ArgOfPericen    102
	}
}

Planet	"XO-1 b"
{
	ParentBody     "XO-1"
	Mass            286.38
	Radius          84646.528
	DiscMethod     "Transit"
	DiscDate       "2006"
	Orbit
	{
		Period          0.01079150468
		SemiMajorAxis   0.0488
		Eccentricity    0
		Inclination     89.31
	}
}

Planet	"XO-2 N b"
{
	ParentBody     "XO-2 N"
	Mass            197.284
	Radius          69561.716
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Period          0.007161927271
		SemiMajorAxis   0.0369
		Eccentricity    0.045
		Inclination     88.7
	}
}

Planet	"XO-2 S b"
{
	ParentBody     "XO-2 S"
	Msini           82.4138
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456413.11
		Period          0.04971221974
		SemiMajorAxis   0.1344
		Eccentricity    0.18
		ArgOfPericen    311.9
	}
}

Planet	"XO-2 S c"
{
	ParentBody     "XO-2 S"
	Msini           435.934
	DiscMethod     "RadVel"
	DiscDate       "2014"
	Orbit
	{
		Epoch           2456408.1
		Period          0.3307394473
		SemiMajorAxis   0.4756
		Eccentricity    0.1528
		ArgOfPericen    264.5
	}
}

Planet	"XO-3 b"
{
	ParentBody     "XO-3"
	Mass            3751.578
	Radius          87005.764
	DiscMethod     "Transit"
	DiscDate       "2007"
	Orbit
	{
		Epoch           2454024.84
		Period          0.008738103069
		SemiMajorAxis   0.0454
		Eccentricity    0.26
		Inclination     84.2
		ArgOfPericen    345.8
	}
}

Planet	"XO-4 b"
{
	ParentBody     "XO-4"
	Msini           513.893
	Radius          94154.964
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01129313676
		SemiMajorAxis   0.05485
		Eccentricity    0
		Inclination     88.47
	}
}

Planet	"XO-5 b"
{
	ParentBody     "XO-5"
	Mass            378.658
	Radius          81500.88
	DiscMethod     "Transit"
	DiscDate       "2008"
	Orbit
	{
		Period          0.01146569568
		SemiMajorAxis   0.0515
		Eccentricity    0
		Inclination     86.8
	}
}

// 3452 planets
