// Saturn cage without Wormhole 

//---------------------------
// DedecahedronCore
//---------------------------

DwarfMoon	"SaturnCageWWH"
{
	ParentBody "Saturn"
	Class		"Selena"
	
	Radius		0.0001
	
	RotationPeriod	8765812556.4
	Precession	1000000
	
	AlbedoBond      0.0
	AlbedoGeom      0.0
	Brightness      0.0
	Color          (0.0 0.0 0.0)
	
	Surface
	{
		//DiffMap		"black.*"
		SurfStyle       0
		OceanStyle      0
		Randomize      (0.000, 0.000, 0.000)
		colorDistMagn   0
		colorDistFreq   1
		detailScale     1
		drivenDarkening 0
		seaLevel        0
		snowLevel       0
		tropicLatitude  0
		icecapLatitude  0
		icecapHeight    0
		climatePole     0
		climateTropic   0
		climateEquator  0
		heightTempGrad  0
		tropicWidth     0
		mainFreq        0
		venusFreq       0
		venusMagn       0
		mareFreq        0
		mareDensity     0
		terraceProb     0
		erosion         0
		montesMagn      0
		montesFreq      0
		montesSpiky     0
		montesFraction  0
		dunesMagn       0
		dunesFreq       0
		dunesFraction   0
		hillsMagn       0
		hillsFreq       0
		hillsFraction   0
		hills2Fraction  0
		riversMagn      0
		riversFreq      0
		riversSin       0
		riversOctaves   0
		canyonsMagn     0
		canyonsFreq     0
		canyonFraction  0
		cracksMagn      0
		cracksFreq      0
		cracksOctaves   0
		craterMagn      0
		craterFreq      0
		craterDensity   0
		craterOctaves   0
		craterRayedFactor 0
		volcanoMagn     0
		volcanoFreq     0
		volcanoDensity  0
		volcanoOctaves  0
		volcanoActivity 0
		volcanoFlows    0
		volcanoRadius   0
		volcanoTemp     0
		lavaCoverTidal  0
		lavaCoverSun    0
		lavaCoverYoung  0
		twistZones      0
		twistMagn       0
		cycloneMagn     0
		cycloneFreq     0
		cycloneDensity  0
		cycloneOctaves  0
		colorSea       (0.000, 0.000, 0.000, 0.000)
		colorShelf     (0.000, 0.000, 0.000, 0.000)
		colorBeach     (0.000, 0.000, 0.000, 0.000)
		colorDesert    (0.000, 0.000, 0.000, 0.200)
		colorLowland   (0.000, 0.000, 0.000, 0.500)
		colorUpland    (0.000, 0.000, 0.000, 0.800)
		colorRock      (0.000, 0.000, 0.000, 1.000)
		colorSnow      (0.000, 0.000, 0.000, 1.000)
		BumpHeight      0
		BumpOffset      0
		SpecBrightWater 0
		SpecBrightIce   0
		SpecularPower   1
		Hapke           1
		SpotBright      4
		SpotWidth       0
		DayAmbient      0
	}
	
	NoClouds        true
	NoOcean         true
	NoLava          true
	NoAtmosphere    true
	NoAurora        true
	NoRings         true
	NoCometTail     true
	
	Orbit 
	{
		Period         0.001678300043
		SemiMajorAxis  0.0009314839571
		Eccentricity   0.0023
		Inclination    0
		LongOfPericen  32.879
		ArgOfPericenter 212.87899722222
		MeanAnomaly    22.695
		RefPlane       "Ecliptic"
	}
}

//-------------------------------
// DedecahedronCorners
//------------------------------

DwarfMoon "Corner 01"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     36
		AscendingNode   0
		ArgOfPericenter 99
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 02"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     72
		AscendingNode   0
		ArgOfPericenter 81
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 03"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     108
		AscendingNode   0
		ArgOfPericenter 99
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 04"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     144
		AscendingNode   0
		ArgOfPericenter 81
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 05"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     180
		AscendingNode   0
		ArgOfPericenter 99
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 06"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -144
		AscendingNode   0
		ArgOfPericenter 81
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 07"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -108
		AscendingNode   0
		ArgOfPericenter 99
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 08"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -72
		AscendingNode   0
		ArgOfPericenter 81
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 09"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -36
		AscendingNode   0
		ArgOfPericenter 99
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 10"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     0
		AscendingNode   0
		ArgOfPericenter 81
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 11"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     72
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 12"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     144
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 13"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -144
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 14"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -72
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 15"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     0
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 16"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     72
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 17"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     144
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 18"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -144
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 19"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -72
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Corner 20"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		1.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		GlowMap		"FieldGen.*" 
		GlowMode	"Thermal" 
		GlowColor	(0.66 1.00 0.66) // (1.00 0.66 0.66) 
		GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     0
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

// --------------------------
// SaturnCagebars
//--------------------------

DwarfMoon "Bar 01.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     36
		AscendingNode   0
		ArgOfPericenter 114
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 01.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     36
		AscendingNode   0
		ArgOfPericenter 121.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 01.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     36
		AscendingNode   0
		ArgOfPericenter 129
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 02.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     72
		AscendingNode   0
		ArgOfPericenter 66
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 02.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     72
		AscendingNode   0
		ArgOfPericenter 58.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 02.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     72
		AscendingNode   0
		ArgOfPericenter 51
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 03.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     108
		AscendingNode   0
		ArgOfPericenter 114
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 03.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     108
		AscendingNode   0
		ArgOfPericenter 121.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 03.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     108
		AscendingNode   0
		ArgOfPericenter 129
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 04.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     144
		AscendingNode   0
		ArgOfPericenter 66
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 04.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     144
		AscendingNode   0
		ArgOfPericenter 58.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 04.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     144
		AscendingNode   0
		ArgOfPericenter 51
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 05.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     180
		AscendingNode   0
		ArgOfPericenter 114
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 05.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     180
		AscendingNode   0
		ArgOfPericenter 121.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 05.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     180
		AscendingNode   0
		ArgOfPericenter 129
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 06.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -144
		AscendingNode   0
		ArgOfPericenter 66
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 06.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -144
		AscendingNode   0
		ArgOfPericenter 58.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 06.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -144
		AscendingNode   0
		ArgOfPericenter 51
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 07.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -108
		AscendingNode   0
		ArgOfPericenter 114
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 07.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -108
		AscendingNode   0
		ArgOfPericenter 121.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 07.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -108
		AscendingNode   0
		ArgOfPericenter 129
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 08.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -72
		AscendingNode   0
		ArgOfPericenter 66
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 08.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -72
		AscendingNode   0
		ArgOfPericenter 58.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 08.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -72
		AscendingNode   0
		ArgOfPericenter 51
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 09.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -36
		AscendingNode   0
		ArgOfPericenter 114
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 09.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -36
		AscendingNode   0
		ArgOfPericenter 121.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 09.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -36
		AscendingNode   0
		ArgOfPericenter 129
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 10.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     0
		AscendingNode   0
		ArgOfPericenter 66
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 10.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     0
		AscendingNode   0
		ArgOfPericenter 58.5
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 10.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     0
		AscendingNode   0
		ArgOfPericenter 51
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 11.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     96
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 11.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     108
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 11.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     120
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 12.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     168
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 12.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     180
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 12.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -168
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 13.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -120
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 13.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -108
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 13.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -96
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 14.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -48
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 14.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -36
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 14.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -24
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 15.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     24
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 15.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     36
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 15.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     48
		AscendingNode   0
		ArgOfPericenter 36
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 16.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     96
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 16.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     108
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 16.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     120
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 17.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     168
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 17.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     180
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 17.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -168
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 18.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -120
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 18.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -108
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 18.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -96
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 19.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -48
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 19.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -36
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 19.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -24
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 20.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     24
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 20.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     36
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 20.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     48
		AscendingNode   0
		ArgOfPericenter 216
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 01-02.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     48
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 01-02.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     54
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 01-02.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     60
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 02-03.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     84
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 02-03.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     90
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 02-03.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     96
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 03-04.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     120
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 03-04.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     126
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 03-04.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     132
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 04-05.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     156
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 04-05.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     162
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 04-05.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     168
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 05-06.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -168
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 05-06.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -162
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 05-06.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -156
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 06-07.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -132
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 06-07.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -126
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 06-07.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -120
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 07-08.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -96
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 07-08.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -90
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 07-08.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -84
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 08-09.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -60
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 08-09.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -54
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 08-09.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -48
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 09-10.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -24
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 09-10.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -18
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 09-10.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     -12
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 10-01.2"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     12
		AscendingNode   0
		ArgOfPericenter 87
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 10-01.3"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     18
		AscendingNode   0
		ArgOfPericenter 90
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

DwarfMoon "Bar 10-01.4"
{
	ParentBody	"SaturnCageWWH"
	Class		"Selena"
	
	Radius		0.5
	
	RotationPeriod	8765812556.4 
	Precession	1000000 
	
	Surface
	{
		TidalLocked	true
		DiffMap		"FieldGen.*"
		// GlowMap		"FieldGen.*" 
		// GlowMode	"Thermal" 
		// GlowColor	(1.00 0.66 0.66) 
		// GlowBright	0.025 
	}
	
	Orbit
	{
		SemiMajorAxis	5.0134403420029e-008 // 6.6845871226706e-008
		Period		1000000
		Eccentricity    0
		Inclination     24
		AscendingNode   0
		ArgOfPericenter 93
		MeanAnomaly     0
		RefPlane       "Equator"
	}
}

